/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.renderers;

import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import org.gephi.graph.api.Edge;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.api.Vector;
import org.gephi.preview.plugin.builders.EdgeBuilder;
import org.gephi.preview.plugin.builders.EdgeLabelBuilder;
import org.gephi.preview.plugin.builders.NodeBuilder;
import org.gephi.preview.plugin.items.EdgeLabelItem;
import org.gephi.preview.plugin.items.NodeItem;
import org.gephi.preview.plugin.renderers.SVGUtils;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.preview.types.DependantColor;
import org.gephi.preview.types.DependantOriginalColor;
import org.gephi.preview.types.EdgeColor;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EdgeLabelRenderer
implements Renderer {
    public static final String EDGE_COLOR = "edge.label.edgeColor";
    public static final String LABEL_X = "edge.label.x";
    public static final String LABEL_Y = "edge.label.y";
    protected final boolean defaultShowLabels = true;
    protected final Font defaultFont = new Font("Arial", 0, 10);
    protected final boolean defaultShorten = false;
    protected final DependantOriginalColor defaultColor = new DependantOriginalColor(DependantOriginalColor.Mode.ORIGINAL);
    protected final int defaultMaxChar = 30;
    protected final float defaultOutlineSize = 2.0f;
    protected final DependantColor defaultOutlineColor = new DependantColor(Color.WHITE);
    protected final float defaultOutlineOpacity = 40.0f;
    protected Font font;

    @Override
    public void preProcess(PreviewModel previewModel) {
        PreviewProperties properties = previewModel.getProperties();
        if (properties.getBooleanValue("edge.label.shorten")) {
            Item[] EdgeLabelsItems = previewModel.getItems("edge_label");
            int maxChars = properties.getIntValue("edge.label.max-char");
            for (Item item : EdgeLabelsItems) {
                String label = (String)item.getData("label");
                if (label.length() < maxChars + 3) continue;
                label = label.substring(0, maxChars) + "...";
                item.setData("label", label);
            }
        }
        for (Item item : previewModel.getItems("edge_label")) {
            Float y;
            Float x;
            Edge edge = (Edge)item.getSource();
            Item edgeItem = previewModel.getItem("edge", edge);
            EdgeColor edgeColor = (EdgeColor)properties.getValue("edge.color");
            NodeItem sourceItem = (NodeItem)edgeItem.getData("source");
            NodeItem targetItem = (NodeItem)edgeItem.getData("target");
            Color color = edgeColor.getColor((Color)item.getData("color"), (Color)sourceItem.getData("color"), (Color)targetItem.getData("color"));
            item.setData(EDGE_COLOR, color);
            if (edge.isSelfLoop()) {
                x = (Float)sourceItem.getData("x");
                y = (Float)sourceItem.getData("y");
                Float size = (Float)sourceItem.getData("size");
                Vector v1 = new Vector(x.floatValue(), y.floatValue());
                v1.add(size.floatValue(), -size.floatValue());
                Vector v2 = new Vector(x.floatValue(), y.floatValue());
                v2.add(size.floatValue(), size.floatValue());
                Vector middle = this.bezierPoint(x.floatValue(), y.floatValue(), v1.x, v1.y, v2.x, v2.y, x.floatValue(), y.floatValue(), 0.5f);
                item.setData(LABEL_X, Float.valueOf(middle.x));
                item.setData(LABEL_Y, Float.valueOf(middle.y));
                continue;
            }
            if (properties.getBooleanValue("edge.curved")) {
                Float x1 = (Float)sourceItem.getData("x");
                Float x2 = (Float)targetItem.getData("x");
                Float y1 = (Float)sourceItem.getData("y");
                Float y2 = (Float)targetItem.getData("y");
                Vector direction = new Vector(x2.floatValue(), y2.floatValue());
                direction.sub(new Vector(x1.floatValue(), y1.floatValue()));
                float length = direction.mag();
                direction.normalize();
                float factor = properties.getFloatValue("edge.bezier-curveness") * length;
                Vector n = new Vector(direction.y, -direction.x);
                n.mult(factor);
                Vector v1 = new Vector(direction.x, direction.y);
                v1.mult(factor);
                v1.add(new Vector(x1.floatValue(), y1.floatValue()));
                v1.add(n);
                Vector v2 = new Vector(direction.x, direction.y);
                v2.mult(-factor);
                v2.add(new Vector(x2.floatValue(), y2.floatValue()));
                v2.add(n);
                Vector middle = this.bezierPoint(x1.floatValue(), y1.floatValue(), v1.x, v1.y, v2.x, v2.y, x2.floatValue(), y2.floatValue(), 0.5f);
                item.setData(LABEL_X, Float.valueOf(middle.x));
                item.setData(LABEL_Y, Float.valueOf(middle.y));
                continue;
            }
            x = Float.valueOf((((Float)sourceItem.getData("x")).floatValue() + ((Float)targetItem.getData("x")).floatValue()) / 2.0f);
            y = Float.valueOf((((Float)sourceItem.getData("y")).floatValue() + ((Float)targetItem.getData("y")).floatValue()) / 2.0f);
            item.setData(LABEL_X, x);
            item.setData(LABEL_Y, y);
        }
        this.font = properties.getFontValue("edge.label.font");
    }

    @Override
    public void render(Item item, RenderTarget target, PreviewProperties properties) {
        Edge edge = (Edge)item.getSource();
        Color edgeColor = (Color)item.getData(EDGE_COLOR);
        Color color = (Color)item.getData("color");
        DependantOriginalColor propColor = (DependantOriginalColor)properties.getValue("edge.label.color");
        color = propColor.getColor(edgeColor, color);
        String label = (String)item.getData("label");
        Float x = (Float)item.getData(LABEL_X);
        Float y = (Float)item.getData(LABEL_Y);
        if (label == null || label.trim().isEmpty()) {
            return;
        }
        DependantColor outlineDependantColor = (DependantColor)properties.getValue("edge.label.outline.color");
        Float outlineSize = Float.valueOf(properties.getFloatValue("edge.label.outline.size"));
        outlineSize = Float.valueOf(outlineSize.floatValue() * ((float)this.font.getSize() / 32.0f));
        int outlineAlpha = (int)(properties.getFloatValue("edge.label.outline.opacity") / 100.0f * 255.0f);
        if (outlineAlpha < 0) {
            outlineAlpha = 0;
        }
        if (outlineAlpha > 255) {
            outlineAlpha = 255;
        }
        Color outlineColor = outlineDependantColor.getColor(edgeColor);
        outlineColor = new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), outlineAlpha);
        if (target instanceof G2DTarget) {
            this.renderG2D((G2DTarget)target, label, x.floatValue(), y.floatValue(), color, outlineSize.floatValue(), outlineColor);
        } else if (target instanceof SVGTarget) {
            this.renderSVG((SVGTarget)target, edge, label, x.floatValue(), y.floatValue(), color, outlineSize.floatValue(), outlineColor);
        } else if (target instanceof PDFTarget) {
            this.renderPDF((PDFTarget)target, label, x.floatValue(), y.floatValue(), color, outlineSize.floatValue(), outlineColor);
        }
    }

    @Override
    public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
        return new CanvasSize();
    }

    public void renderG2D(G2DTarget target, String label, float x, float y, Color color, float outlineSize, Color outlineColor) {
        Graphics2D graphics = target.getGraphics();
        graphics.setFont(this.font);
        FontMetrics fm = graphics.getFontMetrics();
        float posX = x - (float)fm.stringWidth(label) / 2.0f;
        float posY = y + (float)fm.getAscent() / 2.0f;
        Shape outlineGlyph = null;
        if (outlineSize > 0.0f) {
            FontRenderContext frc = graphics.getFontRenderContext();
            GlyphVector gv = this.font.createGlyphVector(frc, label);
            outlineGlyph = gv.getOutline(posX, posY);
            graphics.setColor(outlineColor);
            graphics.setStroke(new BasicStroke(outlineSize, 1, 1));
            graphics.draw(outlineGlyph);
        }
        graphics.setColor(color);
        if (null == outlineGlyph) {
            graphics.drawString(label, posX, posY);
        } else {
            graphics.fill(outlineGlyph);
        }
    }

    public void renderSVG(SVGTarget target, Edge edge, String label, float x, float y, Color color, float outlineSize, Color outlineColor) {
        Text labelText = target.createTextNode(label);
        if (outlineSize > 0.0f) {
            Text labelTextOutline = target.createTextNode(label);
            Element outlineElem = target.createElement("text");
            outlineElem.setAttribute("class", SVGUtils.idAsClassAttribute(edge.getId()));
            outlineElem.setAttribute("x", String.valueOf(x));
            outlineElem.setAttribute("y", String.valueOf(y));
            outlineElem.setAttribute("style", "text-anchor: middle; dominant-baseline: central;");
            outlineElem.setAttribute("fill", target.toHexString(color));
            outlineElem.setAttribute("font-family", this.font.getFamily());
            outlineElem.setAttribute("font-size", this.font.getSize() + "");
            outlineElem.setAttribute("stroke", target.toHexString(outlineColor));
            outlineElem.setAttribute("stroke-width", outlineSize * target.getScaleRatio() + "px");
            outlineElem.setAttribute("stroke-linecap", "round");
            outlineElem.setAttribute("stroke-linejoin", "round");
            outlineElem.setAttribute("stroke-opacity", String.valueOf((float)outlineColor.getAlpha() / 255.0f));
            outlineElem.appendChild(labelTextOutline);
            target.getTopElement("node-labels-outline").appendChild(outlineElem);
        }
        Element labelElem = target.createElement("text");
        labelElem.setAttribute("class", SVGUtils.idAsClassAttribute(edge.getId()));
        labelElem.setAttribute("x", x + "");
        labelElem.setAttribute("y", y + "");
        labelElem.setAttribute("style", "text-anchor: middle; dominant-baseline: central;");
        labelElem.setAttribute("fill", target.toHexString(color));
        labelElem.setAttribute("font-family", this.font.getFamily());
        labelElem.setAttribute("font-size", this.font.getSize() + "");
        labelElem.appendChild(labelText);
        target.getTopElement("edge-labels").appendChild(labelElem);
    }

    public void renderPDF(PDFTarget target, String label, float x, float y, Color color, float outlineSize, Color outlineColor) {
        PdfContentByte cb = target.getContentByte();
        cb.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
        BaseFont bf = target.getBaseFont(this.font);
        float textHeight = this.getTextHeight(bf, this.font.getSize(), label);
        if (outlineSize > 0.0f) {
            cb.setTextRenderingMode(1);
            cb.setRGBColorStroke(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue());
            cb.setLineWidth(outlineSize);
            cb.setLineJoin(1);
            cb.setLineCap(1);
            if (outlineColor.getAlpha() < 255) {
                cb.saveState();
                float alpha = (float)outlineColor.getAlpha() / 255.0f;
                PdfGState gState = new PdfGState();
                gState.setStrokeOpacity(alpha);
                cb.setGState(gState);
            }
            cb.beginText();
            cb.setFontAndSize(bf, this.font.getSize());
            cb.showTextAligned(1, label, x, -y - textHeight / 2.0f, 0.0f);
            cb.endText();
            if (outlineColor.getAlpha() < 255) {
                cb.restoreState();
            }
        }
        cb.setTextRenderingMode(0);
        cb.beginText();
        cb.setFontAndSize(bf, this.font.getSize());
        cb.showTextAligned(1, label, x, -y - textHeight / 2.0f, 0.0f);
        cb.endText();
    }

    private float getTextHeight(BaseFont baseFont, float fontSize, String text) {
        float ascend = baseFont.getAscentPoint(text, fontSize);
        float descend = baseFont.getDescentPoint(text, fontSize);
        return ascend + descend;
    }

    @Override
    public PreviewProperty[] getProperties() {
        return new PreviewProperty[]{PreviewProperty.createProperty(this, "edge.label.show", Boolean.class, NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.display.displayName"), NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.display.description"), PreviewProperty.CATEGORY_EDGE_LABELS).setValue(true), PreviewProperty.createProperty(this, "edge.label.font", Font.class, NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.font.displayName"), NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.font.description"), PreviewProperty.CATEGORY_EDGE_LABELS, "edge.label.show").setValue(this.defaultFont), PreviewProperty.createProperty(this, "edge.label.color", DependantOriginalColor.class, NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.color.displayName"), NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.color.description"), PreviewProperty.CATEGORY_EDGE_LABELS, "edge.label.show").setValue(this.defaultColor), PreviewProperty.createProperty(this, "edge.label.shorten", Boolean.class, NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.shorten.displayName"), NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.shorten.description"), PreviewProperty.CATEGORY_EDGE_LABELS, "edge.label.show").setValue(false), PreviewProperty.createProperty(this, "edge.label.max-char", Integer.class, NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.maxchar.displayName"), NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.maxchar.description"), PreviewProperty.CATEGORY_EDGE_LABELS, "edge.label.show").setValue(30), PreviewProperty.createProperty(this, "edge.label.outline.size", Float.class, NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.outlineSize.displayName"), NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.outlineSize.description"), PreviewProperty.CATEGORY_EDGE_LABELS, "edge.label.show").setValue(Float.valueOf(2.0f)), PreviewProperty.createProperty(this, "edge.label.outline.color", DependantColor.class, NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.outlineColor.displayName"), NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.outlineColor.description"), PreviewProperty.CATEGORY_EDGE_LABELS, "edge.label.show").setValue(this.defaultOutlineColor), PreviewProperty.createProperty(this, "edge.label.outline.opacity", Float.class, NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.outlineOpacity.displayName"), NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.property.outlineOpacity.description"), PreviewProperty.CATEGORY_EDGE_LABELS, "edge.label.show").setValue(Float.valueOf(40.0f))};
    }

    private boolean showEdgeLabels(PreviewProperties properties) {
        return properties.getBooleanValue("edge.label.show") && !properties.getBooleanValue("canvas.moving");
    }

    @Override
    public boolean isRendererForitem(Item item, PreviewProperties properties) {
        return item instanceof EdgeLabelItem && this.showEdgeLabels(properties);
    }

    @Override
    public boolean needsItemBuilder(ItemBuilder itemBuilder, PreviewProperties properties) {
        return (itemBuilder instanceof EdgeLabelBuilder || itemBuilder instanceof NodeBuilder || itemBuilder instanceof EdgeBuilder) && this.showEdgeLabels(properties);
    }

    protected Vector bezierPoint(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float c) {
        Vector ab = this.linearInterpolation(x1, y1, x2, y2, c);
        Vector bc = this.linearInterpolation(x2, y2, x3, y3, c);
        Vector cd = this.linearInterpolation(x3, y3, x4, y4, c);
        Vector abbc = this.linearInterpolation(ab.x, ab.y, bc.x, bc.y, c);
        Vector bccd = this.linearInterpolation(bc.x, bc.y, cd.x, cd.y, c);
        return this.linearInterpolation(abbc.x, abbc.y, bccd.x, bccd.y, c);
    }

    protected Vector linearInterpolation(float x1, float y1, float x2, float y2, float c) {
        Vector r = new Vector(x1 + (x2 - x1) * c, y1 + (y2 - y1) * c);
        return r;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(EdgeLabelRenderer.class, "EdgeLabelRenderer.name");
    }
}

