/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.renderers;

import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.gephi.graph.api.Node;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.plugin.builders.NodeBuilder;
import org.gephi.preview.plugin.builders.NodeLabelBuilder;
import org.gephi.preview.plugin.items.NodeLabelItem;
import org.gephi.preview.plugin.renderers.SVGUtils;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.preview.types.DependantColor;
import org.gephi.preview.types.DependantOriginalColor;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGRect;

public class NodeLabelRenderer
implements Renderer {
    public static final String NODE_COLOR = "node.label.nodeColor";
    public static final String NODE_SIZE = "node.label.nodeSize";
    public static final String NODE_X = "node.x";
    public static final String NODE_Y = "node.y";
    public static final String FONT_SIZE = "node.label.fontSize";
    protected final boolean defaultShowLabels = true;
    protected final Font defaultFont = new Font("Arial", 0, 12);
    protected final boolean defaultShorten = false;
    protected final DependantOriginalColor defaultColor = new DependantOriginalColor(DependantOriginalColor.Mode.ORIGINAL);
    protected final int defaultMaxChar = 30;
    protected final boolean defaultProportinalSize = true;
    protected final float defaultOutlineSize = 4.0f;
    protected final DependantColor defaultOutlineColor = new DependantColor(Color.WHITE);
    protected final int defaultOutlineOpacity = 40;
    protected final boolean defaultShowBox = false;
    protected final DependantColor defaultBoxColor = new DependantColor(DependantColor.Mode.PARENT);
    protected final int defaultBoxOpacity = 100;
    protected Map<Integer, Font> fontCache;

    @Override
    public void preProcess(PreviewModel previewModel) {
        PreviewProperties properties = previewModel.getProperties();
        if (properties.getBooleanValue("node.label.shorten")) {
            Item[] nodeLabelsItems = previewModel.getItems("node_label");
            int maxChars = properties.getIntValue("node.label.max-char");
            Item[] itemArray = nodeLabelsItems;
            int n = itemArray.length;
            for (int i = 0; i < n; ++i) {
                Item item = itemArray[i];
                String label = (String)item.getData("label");
                if (label.length() < maxChars + 3) continue;
                label = label.substring(0, maxChars) + "...";
                item.setData("label", label);
            }
        }
        for (Item item : previewModel.getItems("node_label")) {
            Node node = (Node)item.getSource();
            Item nodeItem = previewModel.getItem("node", node);
            item.setData(NODE_COLOR, nodeItem.getData("color"));
            item.setData(NODE_SIZE, nodeItem.getData("size"));
            item.setData(NODE_X, nodeItem.getData("x"));
            item.setData(NODE_Y, nodeItem.getData("y"));
        }
        this.fontCache = new HashMap<Integer, Font>();
        Font font = properties.getFontValue("node.label.font");
        for (Item item : previewModel.getItems("node_label")) {
            Float nodeSize = (Float)item.getData(NODE_SIZE);
            Float fontSize = Float.valueOf(1.0f);
            if (item.getData("size") != null) {
                fontSize = (Float)item.getData("size");
            }
            if (properties.getBooleanValue("node.label.proportinalSize")) {
                fontSize = Float.valueOf(fontSize.floatValue() * (nodeSize.floatValue() / 10.0f));
            }
            fontSize = Float.valueOf(fontSize.floatValue() * (float)font.getSize());
            Font labelFont = font.deriveFont(fontSize.floatValue());
            this.fontCache.put(labelFont.getSize(), labelFont);
            item.setData(FONT_SIZE, labelFont.getSize());
        }
    }

    @Override
    public void render(Item item, RenderTarget target, PreviewProperties properties) {
        Node node = (Node)item.getSource();
        Color nodeColor = (Color)item.getData(NODE_COLOR);
        Color color = (Color)item.getData("color");
        DependantOriginalColor propColor = (DependantOriginalColor)properties.getValue("node.label.color");
        color = propColor.getColor(nodeColor, color);
        String label = (String)item.getData("label");
        Integer fontSize = (Integer)item.getData(FONT_SIZE);
        Float x = (Float)item.getData(NODE_X);
        Float y = (Float)item.getData(NODE_Y);
        if (label == null || label.trim().isEmpty()) {
            return;
        }
        DependantColor outlineDependantColor = (DependantColor)properties.getValue("node.label.outline.color");
        Float outlineSize = Float.valueOf(properties.getFloatValue("node.label.outline.size"));
        outlineSize = Float.valueOf(outlineSize.floatValue() * ((float)fontSize.intValue() / 32.0f));
        int outlineAlpha = (int)(properties.getFloatValue("node.label.outline.opacity") / 100.0f * 255.0f);
        if (outlineAlpha < 0) {
            outlineAlpha = 0;
        }
        if (outlineAlpha > 255) {
            outlineAlpha = 255;
        }
        Color outlineColor = outlineDependantColor.getColor(nodeColor);
        outlineColor = new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), outlineAlpha);
        Boolean showBox = (Boolean)properties.getValue("node.label.box");
        DependantColor boxDependantColor = (DependantColor)properties.getValue("node.label.box.color");
        Color boxColor = boxDependantColor.getColor(nodeColor);
        int boxAlpha = (int)(properties.getFloatValue("node.label.box.opacity") / 100.0f * 255.0f);
        if (boxAlpha < 0) {
            boxAlpha = 0;
        }
        if (boxAlpha > 255) {
            boxAlpha = 255;
        }
        boxColor = new Color(boxColor.getRed(), boxColor.getGreen(), boxColor.getBlue(), boxAlpha);
        if (target instanceof G2DTarget) {
            this.renderG2D((G2DTarget)target, label, x.floatValue(), y.floatValue(), fontSize, color, outlineSize.floatValue(), outlineColor, showBox, boxColor);
        } else if (target instanceof SVGTarget) {
            this.renderSVG((SVGTarget)target, node, label, x.floatValue(), y.floatValue(), fontSize, color, outlineSize.floatValue(), outlineColor, showBox, boxColor);
        } else if (target instanceof PDFTarget) {
            this.renderPDF((PDFTarget)target, node, label, x.floatValue(), y.floatValue(), fontSize, color, outlineSize.floatValue(), outlineColor, showBox, boxColor);
        }
    }

    @Override
    public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
        return new CanvasSize();
    }

    public void renderG2D(G2DTarget target, String label, float x, float y, int fontSize, Color color, float outlineSize, Color outlineColor, boolean showBox, Color boxColor) {
        Graphics2D graphics = target.getGraphics();
        Font font = this.fontCache.get(fontSize);
        graphics.setFont(font);
        FontMetrics fm = graphics.getFontMetrics();
        float posX = x - (float)fm.stringWidth(label) / 2.0f;
        float posY = y + (float)fm.getDescent();
        Shape outlineGlyph = null;
        if (showBox) {
            graphics.setColor(boxColor);
            Rectangle2D.Float rect = new Rectangle2D.Float();
            rect.setFrame(posX - outlineSize / 2.0f, y - (float)(fm.getAscent() + fm.getDescent()) / 2.0f - outlineSize / 2.0f, (float)fm.stringWidth(label) + outlineSize, (float)(fm.getAscent() + fm.getDescent()) + outlineSize);
            graphics.draw(rect);
        }
        if (outlineSize > 0.0f) {
            FontRenderContext frc = graphics.getFontRenderContext();
            GlyphVector gv = font.createGlyphVector(frc, label);
            outlineGlyph = gv.getOutline(posX, posY);
            graphics.setColor(outlineColor);
            graphics.setStroke(new BasicStroke(outlineSize, 1, 1));
            graphics.draw(outlineGlyph);
        }
        graphics.setColor(color);
        if (null == outlineGlyph) {
            graphics.drawString(label, posX, posY);
        } else {
            graphics.fill(outlineGlyph);
        }
    }

    public void renderSVG(SVGTarget target, Node node, String label, float x, float y, int fontSize, Color color, float outlineSize, Color outlineColor, boolean showBox, Color boxColor) {
        Text labelText = target.createTextNode(label);
        Font font = this.fontCache.get(fontSize);
        if (outlineSize > 0.0f) {
            Text labelTextOutline = target.createTextNode(label);
            Element outlineElem = target.createElement("text");
            outlineElem.setAttribute("class", SVGUtils.idAsClassAttribute(node.getId()));
            outlineElem.setAttribute("x", String.valueOf(x));
            outlineElem.setAttribute("y", String.valueOf(y));
            outlineElem.setAttribute("style", "text-anchor: middle; dominant-baseline: central;");
            outlineElem.setAttribute("fill", target.toHexString(color));
            outlineElem.setAttribute("font-family", font.getFamily());
            outlineElem.setAttribute("font-size", String.valueOf(fontSize));
            outlineElem.setAttribute("stroke", target.toHexString(outlineColor));
            outlineElem.setAttribute("stroke-width", outlineSize * target.getScaleRatio() + "px");
            outlineElem.setAttribute("stroke-linecap", "round");
            outlineElem.setAttribute("stroke-linejoin", "round");
            outlineElem.setAttribute("stroke-opacity", String.valueOf((float)outlineColor.getAlpha() / 255.0f));
            outlineElem.appendChild(labelTextOutline);
            target.getTopElement("node-labels-outline").appendChild(outlineElem);
            SVGRect rect = ((SVGLocatable)((Object)outlineElem)).getBBox();
            outlineElem.setAttribute("y", String.valueOf(y + rect.getHeight() / 4.0f));
        }
        Element labelElem = target.createElement("text");
        labelElem.setAttribute("class", SVGUtils.idAsClassAttribute(node.getId()));
        labelElem.setAttribute("x", String.valueOf(x));
        labelElem.setAttribute("y", String.valueOf(y));
        labelElem.setAttribute("style", "text-anchor: middle; dominant-baseline: central;");
        labelElem.setAttribute("fill", target.toHexString(color));
        labelElem.setAttribute("font-family", font.getFamily());
        labelElem.setAttribute("font-size", String.valueOf(fontSize));
        labelElem.appendChild(labelText);
        target.getTopElement("node-labels").appendChild(labelElem);
        SVGRect rect = ((SVGLocatable)((Object)labelElem)).getBBox();
        labelElem.setAttribute("y", String.valueOf(y + rect.getHeight() / 4.0f));
        if (showBox) {
            rect = ((SVGLocatable)((Object)labelElem)).getBBox();
            Element boxElem = target.createElement("rect");
            boxElem.setAttribute("x", Float.toString(rect.getX() - outlineSize / 2.0f));
            boxElem.setAttribute("y", Float.toString(rect.getY() - outlineSize / 2.0f));
            boxElem.setAttribute("width", Float.toString(rect.getWidth() + outlineSize));
            boxElem.setAttribute("height", Float.toString(rect.getHeight() + outlineSize));
            boxElem.setAttribute("fill", target.toHexString(boxColor));
            boxElem.setAttribute("opacity", String.valueOf((float)boxColor.getAlpha() / 255.0f));
            target.getTopElement("node-labels").insertBefore(boxElem, labelElem);
        }
    }

    public void renderPDF(PDFTarget target, Node node, String label, float x, float y, int fontSize, Color color, float outlineSize, Color outlineColor, boolean showBox, Color boxColor) {
        Font font = this.fontCache.get(fontSize);
        PdfContentByte cb = target.getContentByte();
        BaseFont bf = target.getBaseFont(font);
        if (showBox) {
            cb.setRGBColorFill(boxColor.getRed(), boxColor.getGreen(), boxColor.getBlue());
            if (boxColor.getAlpha() < 255) {
                cb.saveState();
                float alpha = (float)boxColor.getAlpha() / 255.0f;
                PdfGState gState = new PdfGState();
                gState.setFillOpacity(alpha);
                cb.setGState(gState);
            }
            float textWidth = this.getTextWidth(bf, fontSize, label);
            float textHeight = this.getTextHeight(bf, fontSize, label);
            cb.rectangle(x - textWidth / 2.0f - outlineSize / 2.0f, -y - outlineSize / 2.0f - textHeight, textWidth + outlineSize, textHeight * 2.0f + outlineSize);
            cb.fill();
            if (boxColor.getAlpha() < 255) {
                cb.restoreState();
            }
        }
        cb.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
        float textHeight = this.getTextHeight(bf, fontSize, label);
        if (outlineSize > 0.0f) {
            cb.setTextRenderingMode(1);
            cb.setRGBColorStroke(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue());
            cb.setLineWidth(outlineSize);
            cb.setLineJoin(1);
            cb.setLineCap(1);
            if (outlineColor.getAlpha() < 255) {
                cb.saveState();
                float alpha = (float)outlineColor.getAlpha() / 255.0f;
                PdfGState gState = new PdfGState();
                gState.setStrokeOpacity(alpha);
                cb.setGState(gState);
            }
            cb.beginText();
            cb.setFontAndSize(bf, font.getSize());
            cb.showTextAligned(1, label, x, -y - textHeight / 2.0f, 0.0f);
            cb.endText();
            if (outlineColor.getAlpha() < 255) {
                cb.restoreState();
            }
        }
        cb.setTextRenderingMode(0);
        cb.beginText();
        cb.setFontAndSize(bf, font.getSize());
        cb.showTextAligned(1, label, x, -y - textHeight / 2.0f, 0.0f);
        cb.endText();
    }

    private float getTextHeight(BaseFont baseFont, float fontSize, String text) {
        float ascend = baseFont.getAscentPoint(text, fontSize);
        float descend = baseFont.getDescentPoint(text, fontSize);
        return ascend + descend;
    }

    private float getTextWidth(BaseFont baseFont, float fontSize, String text) {
        return baseFont.getWidthPoint(text, fontSize);
    }

    @Override
    public PreviewProperty[] getProperties() {
        return new PreviewProperty[]{PreviewProperty.createProperty(this, "node.label.show", Boolean.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.display.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.display.description"), PreviewProperty.CATEGORY_NODE_LABELS).setValue(true), PreviewProperty.createProperty(this, "node.label.font", Font.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.font.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.font.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.show").setValue(this.defaultFont), PreviewProperty.createProperty(this, "node.label.proportinalSize", Boolean.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.proportionalSize.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.proportionalSize.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.show").setValue(true), PreviewProperty.createProperty(this, "node.label.color", DependantOriginalColor.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.color.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.color.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.show").setValue(this.defaultColor), PreviewProperty.createProperty(this, "node.label.shorten", Boolean.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.shorten.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.shorten.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.show").setValue(false), PreviewProperty.createProperty(this, "node.label.max-char", Integer.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.maxchar.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.maxchar.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.show").setValue(30), PreviewProperty.createProperty(this, "node.label.outline.size", Float.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.outlineSize.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.outlineSize.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.show").setValue(Float.valueOf(4.0f)), PreviewProperty.createProperty(this, "node.label.outline.color", DependantColor.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.outlineColor.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.outlineColor.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.show").setValue(this.defaultOutlineColor), PreviewProperty.createProperty(this, "node.label.outline.opacity", Float.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.outlineOpacity.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.outlineOpacity.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.show").setValue(40), PreviewProperty.createProperty(this, "node.label.box", Boolean.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.box.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.box.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.show").setValue(false), PreviewProperty.createProperty(this, "node.label.box.color", DependantColor.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.box.color.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.box.color.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.box", "node.label.show").setValue(this.defaultBoxColor), PreviewProperty.createProperty(this, "node.label.box.opacity", Float.class, NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.box.opacity.displayName"), NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.property.box.opacity.description"), PreviewProperty.CATEGORY_NODE_LABELS, "node.label.box", "node.label.show").setValue(100)};
    }

    private boolean showNodeLabels(PreviewProperties properties) {
        return properties.getBooleanValue("node.label.show") && !properties.getBooleanValue("canvas.moving");
    }

    @Override
    public boolean isRendererForitem(Item item, PreviewProperties properties) {
        return item instanceof NodeLabelItem && this.showNodeLabels(properties);
    }

    @Override
    public boolean needsItemBuilder(ItemBuilder itemBuilder, PreviewProperties properties) {
        return (itemBuilder instanceof NodeLabelBuilder || itemBuilder instanceof NodeBuilder) && this.showNodeLabels(properties);
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(NodeLabelRenderer.class, "NodeLabelRenderer.name");
    }
}

