/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.renderers;

import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.gephi.graph.api.Node;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.plugin.builders.NodeBuilder;
import org.gephi.preview.plugin.items.NodeItem;
import org.gephi.preview.plugin.renderers.SVGUtils;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.preview.types.DependantColor;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class NodeRenderer
implements Renderer {
    protected float defaultBorderWidth = 1.0f;
    protected DependantColor defaultBorderColor = new DependantColor(Color.BLACK);
    protected float defaultOpacity = 100.0f;
    protected boolean defaultPerNodeOpacity = false;

    @Override
    public void preProcess(PreviewModel previewModel) {
    }

    @Override
    public void render(Item item, RenderTarget target, PreviewProperties properties) {
        if (target instanceof G2DTarget) {
            this.renderG2D(item, (G2DTarget)target, properties);
        } else if (target instanceof SVGTarget) {
            this.renderSVG(item, (SVGTarget)target, properties);
        } else if (target instanceof PDFTarget) {
            this.renderPDF(item, (PDFTarget)target, properties);
        }
    }

    @Override
    public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
        float x = ((Float)item.getData("x")).floatValue();
        float y = ((Float)item.getData("y")).floatValue();
        float s = ((Float)item.getData("size")).floatValue() + properties.getFloatValue("node.border.width");
        float r = s / 2.0f;
        int intS = Math.round(s);
        return new CanvasSize(Math.round(x - r), Math.round(y - r), intS, intS);
    }

    public void renderG2D(Item item, G2DTarget target, PreviewProperties properties) {
        int alpha;
        Float x = (Float)item.getData("x");
        Float y = (Float)item.getData("y");
        Float size = (Float)item.getData("size");
        Color color = (Color)item.getData("color");
        Color borderColor = ((DependantColor)properties.getValue("node.border.color")).getColor(color);
        float borderSize = properties.getFloatValue("node.border.width");
        int n = alpha = properties.getBooleanValue("node.per.node.opacity") ? color.getAlpha() : (int)(properties.getFloatValue("node.opacity") / 100.0f * 255.0f);
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        Graphics2D graphics = target.getGraphics();
        x = Float.valueOf(x.floatValue() - size.floatValue() / 2.0f);
        y = Float.valueOf(y.floatValue() - size.floatValue() / 2.0f);
        Ellipse2D.Float ellipse = new Ellipse2D.Float(x.floatValue(), y.floatValue(), size.floatValue(), size.floatValue());
        if (borderSize > 0.0f) {
            graphics.setColor(new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue(), alpha));
            graphics.setStroke(new BasicStroke(borderSize));
            graphics.draw(ellipse);
        }
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
        graphics.fill(ellipse);
    }

    public void renderSVG(Item item, SVGTarget target, PreviewProperties properties) {
        float alpha;
        Node node = (Node)item.getSource();
        Float x = (Float)item.getData("x");
        Float y = (Float)item.getData("y");
        Float size = (Float)item.getData("size");
        size = Float.valueOf(size.floatValue() / 2.0f);
        Color color = (Color)item.getData("color");
        Color borderColor = ((DependantColor)properties.getValue("node.border.color")).getColor(color);
        float borderSize = properties.getFloatValue("node.border.width");
        float f = alpha = properties.getBooleanValue("node.per.node.opacity") ? (float)color.getAlpha() / 255.0f : properties.getFloatValue("node.opacity") / 100.0f;
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        Element nodeElem = target.createElement("circle");
        nodeElem.setAttribute("class", SVGUtils.idAsClassAttribute(node.getId()));
        nodeElem.setAttribute("cx", x.toString());
        nodeElem.setAttribute("cy", y.toString());
        nodeElem.setAttribute("r", size.toString());
        nodeElem.setAttribute("fill", target.toHexString(color));
        nodeElem.setAttribute("fill-opacity", "" + alpha);
        if (borderSize > 0.0f) {
            nodeElem.setAttribute("stroke", target.toHexString(borderColor));
            nodeElem.setAttribute("stroke-width", Float.toString(borderSize * target.getScaleRatio()));
            nodeElem.setAttribute("stroke-opacity", "" + alpha);
        }
        target.getTopElement("nodes").appendChild(nodeElem);
    }

    public void renderPDF(Item item, PDFTarget target, PreviewProperties properties) {
        Float x = (Float)item.getData("x");
        Float y = (Float)item.getData("y");
        Float size = (Float)item.getData("size");
        size = Float.valueOf(size.floatValue() / 2.0f);
        Color color = (Color)item.getData("color");
        Color borderColor = ((DependantColor)properties.getValue("node.border.color")).getColor(color);
        float borderSize = properties.getFloatValue("node.border.width");
        float alpha = properties.getBooleanValue("node.per.node.opacity") ? (float)color.getAlpha() / 255.0f : properties.getFloatValue("node.opacity") / 100.0f;
        PdfContentByte cb = target.getContentByte();
        cb.setRGBColorStroke(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue());
        cb.setLineWidth(borderSize);
        cb.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
        if (alpha < 1.0f) {
            cb.saveState();
            PdfGState gState = new PdfGState();
            gState.setFillOpacity(alpha);
            gState.setStrokeOpacity(alpha);
            cb.setGState(gState);
        }
        cb.circle(x.floatValue(), -y.floatValue(), size.floatValue());
        if (borderSize > 0.0f) {
            cb.fillStroke();
        } else {
            cb.fill();
        }
        if (alpha < 1.0f) {
            cb.restoreState();
        }
    }

    @Override
    public PreviewProperty[] getProperties() {
        return new PreviewProperty[]{PreviewProperty.createProperty(this, "node.border.width", Float.class, NbBundle.getMessage(NodeRenderer.class, "NodeRenderer.property.borderWidth.displayName"), NbBundle.getMessage(NodeRenderer.class, "NodeRenderer.property.borderWidth.description"), PreviewProperty.CATEGORY_NODES).setValue(Float.valueOf(this.defaultBorderWidth)), PreviewProperty.createProperty(this, "node.border.color", DependantColor.class, NbBundle.getMessage(NodeRenderer.class, "NodeRenderer.property.borderColor.displayName"), NbBundle.getMessage(NodeRenderer.class, "NodeRenderer.property.borderColor.description"), PreviewProperty.CATEGORY_NODES).setValue(this.defaultBorderColor), PreviewProperty.createProperty(this, "node.opacity", Float.class, NbBundle.getMessage(NodeRenderer.class, "NodeRenderer.property.opacity.displayName"), NbBundle.getMessage(NodeRenderer.class, "NodeRenderer.property.opacity.description"), PreviewProperty.CATEGORY_NODES).setValue(Float.valueOf(this.defaultOpacity)), PreviewProperty.createProperty(this, "node.per.node.opacity", Boolean.class, NbBundle.getMessage(NodeRenderer.class, "NodeRenderer.property.perNodeOpacity.displayName"), NbBundle.getMessage(NodeRenderer.class, "NodeRenderer.property.perNodeOpacity.description"), PreviewProperty.CATEGORY_NODES).setValue(this.defaultPerNodeOpacity)};
    }

    private boolean showNodes(PreviewProperties properties) {
        return properties.getFloatValue("node.opacity") > 0.0f;
    }

    @Override
    public boolean isRendererForitem(Item item, PreviewProperties properties) {
        return item instanceof NodeItem && this.showNodes(properties);
    }

    @Override
    public boolean needsItemBuilder(ItemBuilder itemBuilder, PreviewProperties properties) {
        return itemBuilder instanceof NodeBuilder && this.showNodes(properties);
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(NodeRenderer.class, "NodeRenderer.name");
    }
}

