/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.project.api.Project;
import org.gephi.project.impl.ProjectInformationImpl;
import org.gephi.project.impl.ProjectMetaDataImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ProjectImpl
implements Project,
Lookup.Provider,
Serializable {
    private transient InstanceContent instanceContent = new InstanceContent();
    private transient AbstractLookup lookup = new AbstractLookup(this.instanceContent);
    private final AtomicInteger workspaceIds = new AtomicInteger(1);

    public ProjectImpl(int id) {
        this(NbBundle.getMessage(ProjectImpl.class, "Project.default.prefix") + " " + id);
    }

    public ProjectImpl(String name) {
        ProjectMetaDataImpl metaDataImpl = new ProjectMetaDataImpl();
        this.instanceContent.add(metaDataImpl);
        ProjectInformationImpl projectInformationImpl = new ProjectInformationImpl(this, name);
        this.instanceContent.add(projectInformationImpl);
        WorkspaceProviderImpl workspaceProviderImpl = new WorkspaceProviderImpl(this);
        this.instanceContent.add(workspaceProviderImpl);
    }

    @Override
    public void add(Object instance) {
        this.instanceContent.add(instance);
    }

    @Override
    public void remove(Object instance) {
        this.instanceContent.remove(instance);
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    public int nextWorkspaceId() {
        return this.workspaceIds.getAndIncrement();
    }

    public void setWorkspaceIds(int ids) {
        this.workspaceIds.set(ids);
    }

    public int getWorkspaceIds() {
        return this.workspaceIds.get();
    }
}

