/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamReader;
import org.gephi.project.api.Workspace;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.ProjectsImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.io.GephiFormatException;
import org.gephi.project.spi.WorkspacePersistenceProvider;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;
import org.gephi.workspace.impl.WorkspaceImpl;
import org.gephi.workspace.impl.WorkspaceInformationImpl;
import org.openide.util.Lookup;

public class GephiReader {
    static final String VERSION = "0.7";

    public static ProjectImpl readProject(XMLStreamReader reader, ProjectsImpl projects) throws Exception {
        ProjectImpl project = null;
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if ("projectFile".equalsIgnoreCase(name) || "gephiFile".equalsIgnoreCase(name)) {
                    String version = reader.getAttributeValue(null, "version");
                    if (version != null && !version.isEmpty() && !(Double.parseDouble(version) < Double.parseDouble(VERSION))) continue;
                    throw new GephiFormatException("Gephi project file version must be at least of version 0.7");
                }
                if ("project".equalsIgnoreCase(name)) {
                    String projectName = reader.getAttributeValue(null, "name");
                    project = new ProjectImpl(projectName);
                    project.getLookup().lookup(WorkspaceProviderImpl.class);
                    if (reader.getAttributeValue(null, "ids") == null) continue;
                    Integer workspaceIds = Integer.parseInt(reader.getAttributeValue(null, "ids"));
                    project.setWorkspaceIds(workspaceIds);
                    continue;
                }
                if (!"workspace".equalsIgnoreCase(name)) continue;
                GephiReader.readWorkspaceLegacy(reader, project);
                continue;
            }
            if (!eventType.equals(2) || !"project".equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
        return project;
    }

    private static void readWorkspaceLegacy(XMLStreamReader reader, ProjectImpl project) throws Exception {
        WorkspaceImpl workspace = project.getLookup().lookup(WorkspaceProviderImpl.class).newWorkspace();
        WorkspaceInformationImpl info = workspace.getLookup().lookup(WorkspaceInformationImpl.class);
        info.setName(reader.getAttributeValue(null, "name"));
        String workspaceStatus = reader.getAttributeValue(null, "status");
        if (workspaceStatus.equals("open")) {
            info.open();
        } else if (workspaceStatus.equals("closed")) {
            info.close();
        } else {
            info.invalid();
        }
        LinkedHashMap<String, WorkspaceXMLPersistenceProvider> providers = new LinkedHashMap<String, WorkspaceXMLPersistenceProvider>();
        for (WorkspacePersistenceProvider w : Lookup.getDefault().lookupAll(WorkspacePersistenceProvider.class)) {
            String id = w.getIdentifier();
            if (id == null || id.isEmpty() || !(w instanceof WorkspaceXMLPersistenceProvider)) continue;
            providers.put(w.getIdentifier(), (WorkspaceXMLPersistenceProvider)w);
        }
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                WorkspaceXMLPersistenceProvider pp = (WorkspaceXMLPersistenceProvider)providers.get(name);
                if (pp == null) continue;
                try {
                    pp.readXML(reader, workspace);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                continue;
            }
            if (!eventType.equals(2) || !"workspace".equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }

    public static WorkspaceImpl readWorkspace(XMLStreamReader reader, ProjectImpl project) throws Exception {
        WorkspaceImpl workspace = null;
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (!"workspace".equalsIgnoreCase(name)) continue;
                Integer workspaceId = reader.getAttributeValue(null, "id") == null ? Integer.valueOf(project.nextWorkspaceId()) : Integer.valueOf(Integer.parseInt(reader.getAttributeValue(null, "id")));
                workspace = project.getLookup().lookup(WorkspaceProviderImpl.class).newWorkspace(workspaceId);
                WorkspaceInformationImpl info = workspace.getLookup().lookup(WorkspaceInformationImpl.class);
                info.setName(reader.getAttributeValue(null, "name"));
                String workspaceStatus = reader.getAttributeValue(null, "status");
                if (workspaceStatus.equals("open")) {
                    info.open();
                    continue;
                }
                if (workspaceStatus.equals("closed")) {
                    info.close();
                    continue;
                }
                info.invalid();
                continue;
            }
            if (!eventType.equals(2) || !"workspace".equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
        return workspace;
    }

    public static void readWorkspaceChildren(Workspace workspace, XMLStreamReader reader, WorkspaceXMLPersistenceProvider persistenceProvider) throws Exception {
        String identifier = persistenceProvider.getIdentifier();
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (!identifier.equals(name)) continue;
                try {
                    persistenceProvider.readXML(reader, workspace);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                continue;
            }
            if (!eventType.equals(2) || !identifier.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }
}

