/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.project.api.Project;
import org.gephi.project.api.Workspace;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.io.GephiFormatException;
import org.gephi.project.io.GephiWriter;
import org.gephi.project.io.PersistenceProviderUtils;
import org.gephi.project.spi.WorkspaceBytesPersistenceProvider;
import org.gephi.project.spi.WorkspacePersistenceProvider;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SaveTask
implements LongTask,
Runnable {
    private static final String ZIP_LEVEL_PREFERENCE = "ProjectIO_Save_ZipLevel_0_TO_9";
    private final File file;
    private final Project project;
    private boolean cancel = false;
    private ProgressTicket progressTicket;

    public SaveTask(Project project, File file) {
        this.project = project;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Progress.start(this.progressTicket);
        Progress.setDisplayName(this.progressTicket, NbBundle.getMessage(SaveTask.class, "SaveTask.name"));
        File writeFile = null;
        try {
            String tempFileName = this.file.getName() + "_temp" + System.currentTimeMillis();
            writeFile = new File(this.file.getParent(), tempFileName);
            FileOutputStream outputStream = null;
            ZipOutputStream zipOut = null;
            FilterOutputStream bos = null;
            FilterOutputStream dos = null;
            try {
                int zipLevel = NbPreferences.forModule(SaveTask.class).getInt(ZIP_LEVEL_PREFERENCE, 9);
                outputStream = new FileOutputStream(writeFile);
                zipOut = new ZipOutputStream(outputStream);
                zipOut.setLevel(zipLevel);
                bos = new BufferedOutputStream(zipOut);
                dos = new DataOutputStream(bos);
                Collection<WorkspacePersistenceProvider> providers = PersistenceProviderUtils.getPersistenceProviders();
                Workspace[] workspaces = this.project.getLookup().lookup(WorkspaceProviderImpl.class).getWorkspaces();
                Progress.switchToDeterminate(this.progressTicket, 1 + (1 + providers.size()) * workspaces.length);
                this.writeProject(dos, zipOut);
                Progress.progress(this.progressTicket);
                for (Workspace ws : workspaces) {
                    this.writeWorkspace(ws, dos, zipOut);
                    Progress.progress(this.progressTicket);
                    for (WorkspacePersistenceProvider provider : providers) {
                        if (provider instanceof WorkspaceXMLPersistenceProvider) {
                            this.writeWorkspaceChildrenXML(ws, (WorkspaceXMLPersistenceProvider)provider, dos, zipOut);
                        } else if (provider instanceof WorkspaceBytesPersistenceProvider) {
                            this.writeWorkspaceChildrenBytes(ws, (WorkspaceBytesPersistenceProvider)provider, (DataOutputStream)dos, zipOut);
                        }
                        Progress.progress(this.progressTicket);
                        if (!this.cancel) continue;
                        break;
                    }
                    if (this.cancel) break;
                }
                Progress.switchToIndeterminate(this.progressTicket);
                zipOut.finish();
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException zipLevel) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException zipLevel) {}
                }
                if (zipOut != null) {
                    try {
                        zipOut.close();
                    }
                    catch (IOException zipLevel) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException zipLevel) {}
                }
            }
            Progress.finish(this.progressTicket);
            if (!this.cancel && writeFile.exists()) {
                if (this.file.exists()) {
                    this.file.delete();
                }
                FileObject tempFileObject = FileUtil.toFileObject(writeFile);
                FileLock lock = tempFileObject.lock();
                tempFileObject.rename(lock, SaveTask.getFileNameWithoutExt(this.file), SaveTask.getFileExtension(this.file));
                lock.releaseLock();
            }
        }
        catch (Exception ex) {
            if (ex instanceof GephiFormatException) {
                throw (GephiFormatException)ex;
            }
            throw new GephiFormatException(SaveTask.class, (Throwable)ex);
        }
        finally {
            if (writeFile != null && writeFile.exists()) {
                FileObject tempFileObject = FileUtil.toFileObject(writeFile);
                try {
                    tempFileObject.delete();
                }
                catch (IOException iOException) {}
            }
        }
        Progress.finish(this.progressTicket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProject(OutputStream outputStream, ZipOutputStream zipOut) throws Exception {
        zipOut.putNextEntry(new ZipEntry("Project_xml"));
        try (XMLStreamWriter writer = null;){
            writer = SaveTask.newXMLWriter(outputStream);
            GephiWriter.writeProject(writer, this.project);
        }
        zipOut.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWorkspace(Workspace workspace, OutputStream outputStream, ZipOutputStream zipOut) throws Exception {
        zipOut.putNextEntry(new ZipEntry("Workspace_" + workspace.getId() + "_xml"));
        try (XMLStreamWriter writer = null;){
            writer = SaveTask.newXMLWriter(outputStream);
            GephiWriter.writeWorkspace(writer, workspace);
        }
        zipOut.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWorkspaceChildrenXML(Workspace workspace, WorkspaceXMLPersistenceProvider persistenceProvider, OutputStream outputStream, ZipOutputStream zipOut) throws Exception {
        String identifier = persistenceProvider.getIdentifier();
        zipOut.putNextEntry(new ZipEntry("Workspace_" + workspace.getId() + "_" + identifier + "_xml"));
        try (XMLStreamWriter writer = null;){
            writer = SaveTask.newXMLWriter(outputStream);
            GephiWriter.writeWorkspaceChildren(writer, workspace, persistenceProvider);
        }
        zipOut.closeEntry();
    }

    private void writeWorkspaceChildrenBytes(Workspace workspace, WorkspaceBytesPersistenceProvider persistenceProvider, DataOutputStream outputStream, ZipOutputStream zipOut) throws Exception {
        String identifier = persistenceProvider.getIdentifier();
        zipOut.putNextEntry(new ZipEntry("Workspace_" + workspace.getId() + "_" + identifier + "_bytes"));
        persistenceProvider.writeBytes(outputStream, workspace);
        outputStream.flush();
        zipOut.closeEntry();
    }

    private static XMLStreamWriter newXMLWriter(OutputStream outputStream) throws Exception {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
        return outputFactory.createXMLStreamWriter(outputStream, "UTF-8");
    }

    private static String getFileExtension(File file) {
        String name = file.getName();
        try {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getFileNameWithoutExt(File file) {
        String fileName = file.getName();
        int pos = fileName.lastIndexOf(".");
        if (pos > 0) {
            fileName = fileName.substring(0, pos);
        }
        return fileName;
    }

    @Override
    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

