/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.binary.Base64;
import org.gephi.statistics.api.StatisticsModel;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsBuilder;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.utils.TempDirUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class StatisticsModelImpl
implements StatisticsModel {
    private final Map<Class, String> reportMap = new HashMap<Class, String>();

    public void addReport(Statistics statistics) {
        this.reportMap.put(statistics.getClass(), statistics.getReport());
    }

    @Override
    public String getReport(Class<? extends Statistics> statisticsClass) {
        return this.reportMap.get(statisticsClass);
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("reports");
        for (Map.Entry<Class, String> entry : this.reportMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            writer.writeStartElement("report");
            String report = entry.getValue();
            report = this.embedImages(report);
            writer.writeAttribute("class", entry.getKey().getName());
            writer.writeAttribute("value", report);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void readXML(XMLStreamReader reader) throws XMLStreamException {
        Collection<StatisticsUI> uis = Lookup.getDefault().lookupAll(StatisticsUI.class);
        Collection<StatisticsBuilder> builders = Lookup.getDefault().lookupAll(StatisticsBuilder.class);
        boolean end = false;
        block4: while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!"report".equalsIgnoreCase(name)) break;
                    String classStr = reader.getAttributeValue(null, "class");
                    Class<? extends Statistics> reportClass = null;
                    for (StatisticsBuilder builder : builders) {
                        if (!builder.getStatisticsClass().getName().equals(classStr)) continue;
                        reportClass = builder.getStatisticsClass();
                    }
                    if (reportClass == null) continue block4;
                    String report = reader.getAttributeValue(null, "value");
                    report = this.unembedImages(report);
                    this.reportMap.put(reportClass, report);
                    break;
                }
                case 2: {
                    if (!"statisticsmodel".equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    private String unembedImages(String report) {
        StringBuilder builder = new StringBuilder();
        String[] result = report.split("data:image/png;base64");
        if (result.length == 0) {
            return report;
        }
        try {
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            for (int i = 0; i < result.length; ++i) {
                if (result[i].contains("</IMG>")) {
                    String next = result[i];
                    int endIndex = next.indexOf(34);
                    String pngStr = next.substring(0, endIndex);
                    byte[] imageBytes = Base64.decodeBase64(pngStr);
                    String fileName = "image" + i + ".png";
                    File file = tempDir.createFile(fileName);
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(imageBytes);
                    String path = "file:" + file.getAbsolutePath();
                    builder.append(path);
                    builder.append(next.substring(endIndex, next.length()));
                    continue;
                }
                builder.append(result[i]);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
        return builder.toString();
    }

    private String embedImages(String report) {
        StringBuilder builder = new StringBuilder();
        String[] result = report.split("file:");
        boolean first = true;
        for (int i = 0; i < result.length; ++i) {
            if (result[i].contains("</IMG>")) {
                String next = result[i];
                String[] elements = next.split("\"");
                String filename = elements[0];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                File file = new File(filename);
                try {
                    BufferedImage image = ImageIO.read(file);
                    ImageIO.write((RenderedImage)image, "PNG", out);
                }
                catch (Exception e) {
                    Exceptions.printStackTrace(e);
                }
                byte[] imageBytes = out.toByteArray();
                String base64String = Base64.encodeBase64String(imageBytes);
                if (!first) {
                    builder.append("\"");
                }
                first = false;
                builder.append("data:image/png;base64,");
                builder.append(base64String);
                for (int j = 1; j < elements.length; ++j) {
                    builder.append("\"");
                    builder.append(elements[j]);
                }
                continue;
            }
            builder.append(result[i]);
        }
        return builder.toString();
    }
}

