/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.gephi.utils.TempDirUtils;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;

public abstract class ChartUtils {
    public static void decorateChart(JFreeChart chart) {
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(0, true);
        renderer.setSeriesShape(0, new Ellipse2D.Double(0.0, 0.0, 2.0, 2.0));
        plot.setBackgroundPaint(Color.WHITE);
        plot.setDomainGridlinePaint(Color.GRAY);
        plot.setRangeGridlinePaint(Color.GRAY);
        plot.setRenderer(renderer);
    }

    public static void scaleChart(JFreeChart chart, XYSeries dSeries, boolean normalized) {
        XYPlot plot = (XYPlot)chart.getPlot();
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLowerMargin(1.0);
        domainAxis.setUpperMargin(1.0);
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (normalized) {
            domainAxis.setRange(-0.05, 1.05);
        } else {
            domainAxis.setRange(dSeries.getMinX() - 1.0, dSeries.getMaxX() + 1.0);
        }
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setRange(-0.1 * Math.sqrt(dSeries.getMaxY()), dSeries.getMaxY() + 0.1 * Math.sqrt(dSeries.getMaxY()));
    }

    public static String renderChart(JFreeChart chart, String fileName) {
        String imageFile = "";
        try {
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            File file1 = tempDir.createFile(fileName);
            imageFile = "<IMG SRC=\"file:" + file1.getAbsolutePath() + "\" WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
            ChartUtilities.saveChartAsPNG(file1, chart, 600, 400, info);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return imageFile;
    }

    public static XYSeries createXYSeries(Map data, String name) {
        XYSeries series = new XYSeries((Comparable)((Object)name));
        for (Map.Entry d : data.entrySet()) {
            Number x = (Number)d.getKey();
            Number y = (Number)d.getValue();
            series.add(x, y);
        }
        return series;
    }
}

