/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Table;
import org.gephi.statistics.plugin.ArrayWrapper;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.plugin.EdgeWrapper;
import org.gephi.statistics.plugin.Renumbering;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;

public class ClusteringCoefficient
implements Statistics,
LongTask {
    public static final String CLUSTERING_COEFF = "clustering";
    private double avgClusteringCoeff;
    private boolean isDirected;
    private boolean isCanceled;
    private ProgressTicket progress;
    private int[] triangles;
    private ArrayWrapper[] network;
    private int K;
    private int N;
    private double[] nodeClustering;
    private int totalTriangles;

    public ClusteringCoefficient() {
        GraphController graphController = Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.isDirected = graphController.getGraphModel().isDirected();
        }
    }

    public double getAverageClusteringCoefficient() {
        return this.avgClusteringCoeff;
    }

    @Override
    public void execute(GraphModel graphModel) {
        Graph graph = this.isDirected ? graphModel.getDirectedGraphVisible() : graphModel.getUndirectedGraphVisible();
        this.execute(graph);
    }

    public void execute(Graph graph) {
        this.isCanceled = false;
        if (this.isDirected) {
            this.avgClusteringCoeff = this.bruteForce(graph);
        } else {
            this.initStartValues(graph);
            HashMap<String, Double> resultValues = this.computeTriangles(graph, this.network, this.triangles, this.nodeClustering, this.isDirected);
            this.totalTriangles = resultValues.get("triangles").intValue();
            this.avgClusteringCoeff = resultValues.get("clusteringCoefficient");
        }
        Table nodeTable = graph.getModel().getNodeTable();
        Column clusteringCol = nodeTable.getColumn(CLUSTERING_COEFF);
        if (clusteringCol == null) {
            clusteringCol = nodeTable.addColumn(CLUSTERING_COEFF, "Clustering Coefficient", Double.class, 0.0);
        }
        Column triCount = null;
        if (!this.isDirected && (triCount = nodeTable.getColumn("Triangles")) == null) {
            triCount = nodeTable.addColumn("Triangles", "Number of triangles", Integer.class, 0);
        }
        for (int v = 0; v < this.N; ++v) {
            if (this.network[v].length() <= 1) continue;
            this.network[v].node.setAttribute(clusteringCol, (Object)this.nodeClustering[v]);
            if (this.isDirected) continue;
            this.network[v].node.setAttribute(triCount, (Object)this.triangles[v]);
        }
    }

    public void triangles(Graph graph) {
        this.initStartValues(graph);
        HashMap<String, Double> resultValues = this.computeTriangles(graph, this.network, this.triangles, this.nodeClustering, this.isDirected);
        this.totalTriangles = resultValues.get("triangles").intValue();
        this.avgClusteringCoeff = resultValues.get("clusteringCoefficient");
    }

    public HashMap<String, Double> computeClusteringCoefficient(Graph graph, ArrayWrapper[] currentNetwork, int[] currentTriangles, double[] currentNodeClustering, boolean directed) {
        HashMap<String, Double> resultValues = new HashMap<String, Double>();
        if (directed) {
            double avClusteringCoefficient = this.bruteForce(graph);
            resultValues.put("clusteringCoefficient", avClusteringCoefficient);
            return resultValues;
        }
        this.initStartValues(graph);
        resultValues = this.computeTriangles(graph, currentNetwork, currentTriangles, currentNodeClustering, directed);
        return resultValues;
    }

    public void initStartValues(Graph graph) {
        this.N = graph.getNodeCount();
        this.K = (int)Math.sqrt(this.N);
        this.nodeClustering = new double[this.N];
        this.network = new ArrayWrapper[this.N];
        this.triangles = new int[this.N];
    }

    public int createIndiciesMapAndInitNetwork(Graph graph, HashMap<Node, Integer> indicies, ArrayWrapper[] networks, int currentProgress) {
        int index = 0;
        for (Node s : graph.getNodes()) {
            indicies.put(s, index);
            networks[index] = new ArrayWrapper();
            ++index;
            Progress.progress(this.progress, ++currentProgress);
        }
        return currentProgress;
    }

    private int closest_in_array(ArrayWrapper[] currentNetwork, int v) {
        int right = currentNetwork[v].length() - 1;
        if (right < 0) {
            return -1;
        }
        if (currentNetwork[v].get(0) >= v) {
            return -1;
        }
        if (currentNetwork[v].get(right) < v) {
            return right;
        }
        if (currentNetwork[v].get(right) == v) {
            return right - 1;
        }
        int left = 0;
        while (right > left) {
            int mid = (left + right) / 2;
            if (v < currentNetwork[v].get(mid)) {
                right = mid - 1;
                continue;
            }
            if (v > currentNetwork[v].get(mid)) {
                left = mid + 1;
                continue;
            }
            return mid - 1;
        }
        if (v > currentNetwork[v].get(right)) {
            return right;
        }
        return right - 1;
    }

    private void newVertex(ArrayWrapper[] currentNetwork, int[] currentTrianlgles, int v, int n) {
        int neighbor;
        int i;
        int[] A = new int[n];
        for (i = currentNetwork[v].length() - 1; i >= 0 && currentNetwork[v].get(i) > v; --i) {
            neighbor = currentNetwork[v].get(i);
            A[neighbor] = currentNetwork[v].getCount(i);
        }
        for (i = currentNetwork[v].length() - 1; i >= 0; --i) {
            neighbor = currentNetwork[v].get(i);
            for (int j = this.closest_in_array(currentNetwork, neighbor); j >= 0; --j) {
                int next = currentNetwork[neighbor].get(j);
                if (A[next] <= 0) continue;
                int n2 = next;
                currentTrianlgles[n2] = currentTrianlgles[n2] + currentNetwork[v].getCount(i);
                int n3 = v;
                currentTrianlgles[n3] = currentTrianlgles[n3] + currentNetwork[v].getCount(i);
                int n4 = neighbor;
                currentTrianlgles[n4] = currentTrianlgles[n4] + A[next];
            }
        }
    }

    private void tr_link_nohigh(ArrayWrapper[] currentNetwork, int[] currentTriangles, int u, int v, int count, int k) {
        int iu = 0;
        int iv = 0;
        while (iu < currentNetwork[u].length() && iv < currentNetwork[v].length()) {
            if (currentNetwork[u].get(iu) < currentNetwork[v].get(iv)) {
                ++iu;
                continue;
            }
            if (currentNetwork[u].get(iu) > currentNetwork[v].get(iv)) {
                ++iv;
                continue;
            }
            int w = currentNetwork[u].get(iu);
            if (w >= k) {
                int n = w;
                currentTriangles[n] = currentTriangles[n] + count;
            }
            ++iu;
            ++iv;
        }
    }

    private HashMap<Node, EdgeWrapper> createNeighbourTable(Graph graph, Node node, HashMap<Node, Integer> indicies, ArrayWrapper[] networks, boolean directed) {
        HashMap<Node, EdgeWrapper> neighborTable = new HashMap<Node, EdgeWrapper>();
        if (!directed) {
            for (Edge edge : graph.getEdges(node)) {
                Node neighbor = graph.getOpposite(node, edge);
                neighborTable.put(neighbor, new EdgeWrapper(1, networks[indicies.get(neighbor)]));
            }
        } else {
            for (Node neighbor : ((DirectedGraph)graph).getPredecessors(node)) {
                neighborTable.put(neighbor, new EdgeWrapper(1, networks[indicies.get(neighbor)]));
            }
            for (Edge out : ((DirectedGraph)graph).getOutEdges(node)) {
                Node neighbor = out.getTarget();
                EdgeWrapper ew = neighborTable.get(neighbor);
                if (ew == null) {
                    neighborTable.put(neighbor, new EdgeWrapper(1, this.network[indicies.get(neighbor)]));
                    continue;
                }
                ++ew.count;
            }
        }
        return neighborTable;
    }

    private EdgeWrapper[] getEdges(HashMap<Node, EdgeWrapper> neighborTable) {
        int i = 0;
        EdgeWrapper[] edges = new EdgeWrapper[neighborTable.size()];
        Iterator<EdgeWrapper> iterator = neighborTable.values().iterator();
        while (iterator.hasNext()) {
            EdgeWrapper e;
            edges[i] = e = iterator.next();
            ++i;
        }
        return edges;
    }

    private int processNetwork(ArrayWrapper[] currentNetwork, int currentProgress) {
        int j;
        Arrays.sort(currentNetwork);
        for (j = 0; j < this.N; ++j) {
            currentNetwork[j].setID(j);
            Progress.progress(this.progress, ++currentProgress);
        }
        for (j = 0; j < this.N; ++j) {
            Arrays.sort(currentNetwork[j].getArray(), new Renumbering());
            Progress.progress(this.progress, ++currentProgress);
        }
        return currentProgress;
    }

    private int computeRemainingTrianles(Graph graph, ArrayWrapper[] currentNetwork, int[] currentTriangles, int currentProgress) {
        int n = graph.getNodeCount();
        int k = (int)Math.sqrt(n);
        for (int v = n - 1; v >= 0 && v >= k; --v) {
            for (int i = this.closest_in_array(currentNetwork, v); i >= 0; --i) {
                int u = currentNetwork[v].get(i);
                if (u < k) continue;
                this.tr_link_nohigh(currentNetwork, currentTriangles, u, v, currentNetwork[v].getCount(i), k);
            }
            Progress.progress(this.progress, ++currentProgress);
            if (!this.isCanceled) continue;
            return currentProgress;
        }
        return currentProgress;
    }

    private HashMap<String, Double> computeResultValues(Graph graph, ArrayWrapper[] currentNetwork, int[] currentTriangles, double[] currentNodeClusterig, boolean directed, int currentProgress) {
        int n = graph.getNodeCount();
        HashMap<String, Double> totalValues = new HashMap<String, Double>();
        int numNodesDegreeGreaterThanOne = 0;
        int trianglesNumber = 0;
        double currentClusteringCoefficient = 0.0;
        for (int v = 0; v < n; ++v) {
            if (currentNetwork[v].length() > 1) {
                ++numNodesDegreeGreaterThanOne;
                double cc = currentTriangles[v];
                trianglesNumber += currentTriangles[v];
                cc /= (double)(currentNetwork[v].length() * (currentNetwork[v].length() - 1));
                if (!directed) {
                    cc *= 2.0;
                }
                currentNodeClusterig[v] = cc;
                currentClusteringCoefficient += cc;
            }
            Progress.progress(this.progress, ++currentProgress);
            if (!this.isCanceled) continue;
            return totalValues;
        }
        totalValues.put("triangles", Double.valueOf(trianglesNumber /= 3));
        totalValues.put("clusteringCoefficient", currentClusteringCoefficient /= (double)numNodesDegreeGreaterThanOne);
        return totalValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Double> computeTriangles(Graph graph, ArrayWrapper[] currentNetwork, int[] currentTriangles, double[] nodeClustering, boolean directed) {
        HashMap<String, Double> resultValues = new HashMap();
        int ProgressCount = 0;
        Progress.start(this.progress, 7 * graph.getNodeCount());
        graph.readLock();
        try {
            int n = graph.getNodeCount();
            HashMap<Node, Integer> indicies = new HashMap<Node, Integer>();
            ProgressCount = this.createIndiciesMapAndInitNetwork(graph, indicies, currentNetwork, ProgressCount);
            int index = 0;
            NodeIterable nodesIterable = graph.getNodes();
            for (Node node : nodesIterable) {
                HashMap<Node, EdgeWrapper> neighborTable = this.createNeighbourTable(graph, node, indicies, currentNetwork, directed);
                EdgeWrapper[] edges = this.getEdges(neighborTable);
                currentNetwork[index].node = node;
                currentNetwork[index].setArray(edges);
                ++index;
                Progress.progress(this.progress, ++ProgressCount);
                if (!this.isCanceled) continue;
                nodesIterable.doBreak();
                HashMap<String, Double> hashMap = resultValues;
                return hashMap;
            }
            ProgressCount = this.processNetwork(currentNetwork, ProgressCount);
            int k = (int)Math.sqrt(n);
            for (int v = 0; v < k && v < n; ++v) {
                this.newVertex(currentNetwork, currentTriangles, v, n);
                Progress.progress(this.progress, ++ProgressCount);
            }
            ProgressCount = this.computeRemainingTrianles(graph, currentNetwork, currentTriangles, ProgressCount);
            resultValues = this.computeResultValues(graph, currentNetwork, currentTriangles, nodeClustering, directed, ProgressCount);
        }
        finally {
            graph.readUnlock();
        }
        return resultValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double bruteForce(Graph graph) {
        Column clusteringColumn = this.initializeAttributeColunms(graph.getModel());
        float totalCC = 0.0f;
        graph.readLock();
        try {
            double clusteringCoeff;
            Progress.start(this.progress, graph.getNodeCount());
            int node_count = 0;
            NodeIterable nodesIterable = graph.getNodes();
            for (Node node : nodesIterable) {
                float nodeClusteringCoefficient = this.computeNodeClusteringCoefficient(graph, node, this.isDirected);
                if (nodeClusteringCoefficient > -1.0f) {
                    this.saveCalculatedValue(node, clusteringColumn, nodeClusteringCoefficient);
                    totalCC += nodeClusteringCoefficient;
                }
                if (this.isCanceled) {
                    nodesIterable.doBreak();
                    break;
                }
                Progress.progress(this.progress, ++node_count);
            }
            double d = clusteringCoeff = (double)(totalCC / (float)graph.getNodeCount());
            return d;
        }
        finally {
            graph.readUnlockAll();
        }
    }

    private float increaseCCifNesessary(Graph graph, Node neighbor1, Node neighbor2, boolean directed, float nodeCC) {
        if (neighbor1 == neighbor2) {
            return nodeCC;
        }
        if (directed) {
            if (graph.isAdjacent(neighbor1, neighbor2)) {
                nodeCC += 1.0f;
            }
            if (graph.isAdjacent(neighbor2, neighbor1)) {
                nodeCC += 1.0f;
            }
        } else if (graph.isAdjacent(neighbor1, neighbor2)) {
            nodeCC += 1.0f;
        }
        return nodeCC;
    }

    private float computeNodeClusteringCoefficient(Graph graph, Node node, boolean directed) {
        float nodeCC = 0.0f;
        int neighborhood = 0;
        NodeIterable neighbors1 = graph.getNeighbors(node);
        for (Node neighbor1 : neighbors1) {
            ++neighborhood;
            NodeIterable neighbors2 = graph.getNeighbors(node);
            for (Node neighbor2 : neighbors2) {
                nodeCC = this.increaseCCifNesessary(graph, neighbor1, neighbor2, directed, nodeCC);
            }
        }
        nodeCC = (float)((double)nodeCC / 2.0);
        if (neighborhood > 1) {
            float cc = nodeCC / (0.5f * (float)neighborhood * (float)(neighborhood - 1));
            if (directed) {
                cc = nodeCC / (float)(neighborhood * (neighborhood - 1));
            }
            return cc;
        }
        return -1.0f;
    }

    private Column initializeAttributeColunms(GraphModel graphModel) {
        if (graphModel == null) {
            return null;
        }
        Table nodeTable = graphModel.getNodeTable();
        Column clusteringCol = nodeTable.getColumn(CLUSTERING_COEFF);
        if (clusteringCol == null) {
            clusteringCol = nodeTable.addColumn(CLUSTERING_COEFF, "Clustering Coefficient", Double.class, new Double(0.0));
        }
        return clusteringCol;
    }

    private void saveCalculatedValue(Node node, Column clusteringColumn, double nodeClusteringCoefficient) {
        if (clusteringColumn == null) {
            return;
        }
        node.setAttribute(clusteringColumn, (Object)nodeClusteringCoefficient);
    }

    @Override
    public String getReport() {
        HashMap<Double, Integer> dist = new HashMap<Double, Integer>();
        for (int i = 0; i < this.N; ++i) {
            Double d = this.nodeClustering[i];
            if (dist.containsKey(d)) {
                Integer v = (Integer)dist.get(d);
                dist.put(d, v + 1);
                continue;
            }
            dist.put(d, 1);
        }
        XYSeries dSeries = ChartUtils.createXYSeries(dist, "Clustering Coefficient");
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createScatterPlot("Clustering Coefficient Distribution", "Value", "Count", dataset, PlotOrientation.VERTICAL, true, false, false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, false);
        String imageFile = ChartUtils.renderChart(chart, "clustering-coefficient.png");
        DecimalFormat f = new DecimalFormat("#0.000");
        if (this.isDirected) {
            return "<HTML> <BODY> <h1> Clustering Coefficient Metric Report </h1> <hr><br /><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br /><br><h2> Results: </h2>Average Clustering Coefficient: " + f.format(this.avgClusteringCoeff) + "<br />The Average Clustering Coefficient is the mean value of individual coefficients.<br /><br />" + imageFile + "<br /><br /><h2> Algorithm: </h2>Simple and slow brute force.<br /></BODY> </HTML>";
        }
        return "<HTML> <BODY> <h1> Clustering Coefficient Metric Report </h1> <hr><br /><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br /><br><h2> Results: </h2>Average Clustering Coefficient: " + f.format(this.avgClusteringCoeff) + "<br />Total triangles: " + this.totalTriangles + "<br />The Average Clustering Coefficient is the mean value of individual coefficients.<br /><br />" + imageFile + "<br /><br /><h2> Algorithm: </h2>Matthieu Latapy, <i>Main-memory Triangle Computations for Very Large (Sparse (Power-Law)) Graphs</i>, in Theoretical Computer Science (TCS) 407 (1-3), pages 458-473, 2008<br /></BODY> </HTML>";
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket ProgressTicket2) {
        this.progress = ProgressTicket2;
    }

    public double[] getCoefficientReuslts() {
        double[] res = new double[this.N];
        for (int v = 0; v < this.N; ++v) {
            if (this.network[v].length() <= 1) continue;
            res[v] = this.nodeClustering[v];
        }
        return res;
    }

    public double[] getTriangesReuslts() {
        double[] res = new double[this.N];
        for (int v = 0; v < this.N; ++v) {
            if (this.network[v].length() <= 1) continue;
            res[v] = this.triangles[v];
        }
        return res;
    }
}

