/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.text.DecimalFormat;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.statistics.spi.Statistics;
import org.openide.util.Lookup;

public class GraphDensity
implements Statistics {
    private double density;
    private boolean isDirected;

    public GraphDensity() {
        GraphController graphController = Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.isDirected = graphController.getGraphModel().isDirected();
        }
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean getDirected() {
        return this.isDirected;
    }

    public double getDensity() {
        return this.density;
    }

    @Override
    public void execute(GraphModel graphModel) {
        Graph graph = this.isDirected ? graphModel.getDirectedGraphVisible() : graphModel.getUndirectedGraphVisible();
        this.density = this.calculateDensity(graph, this.isDirected);
    }

    public double calculateDensity(Graph graph, boolean isGraphDirected) {
        double edgesCount = graph.getEdgeCount();
        double nodesCount = graph.getNodeCount();
        double multiplier = 1.0;
        if (!isGraphDirected) {
            multiplier = 2.0;
        }
        double result = multiplier * edgesCount / (nodesCount * nodesCount - nodesCount);
        return result;
    }

    @Override
    public String getReport() {
        DecimalFormat f = new DecimalFormat("#0.000");
        return "<HTML> <BODY> <h1>Graph Density  Report </h1> <hr><br><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br><br> <h2> Results: </h2>Density: " + f.format(this.density) + "</BODY></HTML>";
    }
}

