/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin.dynamic;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.plugin.ClusteringCoefficient;
import org.gephi.statistics.spi.DynamicStatistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DynamicClusteringCoefficient
implements DynamicStatistics,
LongTask {
    public static final String DYNAMIC_AVG_CLUSTERING_COEFFICIENT = "dynamic_avg_clustering";
    public static final String DYNAMIC_CLUSTERING_COEFFICIENT = "dynamic_clustering";
    private GraphModel graphModel;
    private double window;
    private double tick;
    private Interval bounds;
    private boolean isDirected;
    private boolean averageOnly;
    private boolean cancel = false;
    private ClusteringCoefficient clusteringCoefficientStat;
    private Column dynamicCoefficientColumn;
    private Column dynamicAverageCoefficientColumn;
    private Map<Double, Double> averages;

    public DynamicClusteringCoefficient() {
        GraphController graphController = Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.isDirected = graphController.getGraphModel().isDirected();
        }
    }

    @Override
    public void execute(GraphModel graphModel) {
        this.graphModel = graphModel;
        this.isDirected = graphModel.isDirected();
        this.averages = new HashMap<Double, Double>();
        if (!this.averageOnly) {
            TimeRepresentation tr = graphModel.getConfiguration().getTimeRepresentation();
            Table nodeTable = graphModel.getNodeTable();
            this.dynamicCoefficientColumn = nodeTable.getColumn(DYNAMIC_CLUSTERING_COEFFICIENT);
            if (this.dynamicCoefficientColumn == null) {
                this.dynamicCoefficientColumn = nodeTable.addColumn(DYNAMIC_CLUSTERING_COEFFICIENT, NbBundle.getMessage(DynamicClusteringCoefficient.class, "DynamicClusteringCoefficient.nodecolumn.ClusteringCoefficient"), tr.equals((Object)TimeRepresentation.INTERVAL) ? IntervalDoubleMap.class : TimestampDoubleMap.class, null);
            }
        }
    }

    @Override
    public String getReport() {
        XYSeries dSeries = ChartUtils.createXYSeries(this.averages, "Clustering Coefficient Time Series");
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createXYLineChart("Clustering Coefficient", "Time", "Average Clustering Coefficient", dataset, PlotOrientation.VERTICAL, true, false, false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, false);
        String coefficientImageFile = ChartUtils.renderChart(chart, "coefficient-ts.png");
        DecimalFormat f = new DecimalFormat("#0.000000");
        String report = "<HTML> <BODY> <h1>Dynamic Clustering Coefficient Report </h1> <hr><br> Bounds: from " + f.format(this.bounds.getLow()) + " to " + f.format(this.bounds.getHigh()) + "<br> Window: " + this.window + "<br> Tick: " + this.tick + "<br><br><h2> Average clustering cloefficient over time: </h2><br /><br />" + coefficientImageFile;
        report = report + "<br /><br /></BODY></HTML>";
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loop(GraphView window, Interval interval) {
        block8: {
            Subgraph graph = this.isDirected ? this.graphModel.getDirectedGraph(window) : this.graphModel.getUndirectedGraph(window);
            TimeRepresentation tr = this.graphModel.getConfiguration().getTimeRepresentation();
            graph.readLock();
            try {
                this.clusteringCoefficientStat = new ClusteringCoefficient();
                this.clusteringCoefficientStat.setDirected(this.isDirected);
                this.clusteringCoefficientStat.triangles(graph);
                if (this.averageOnly) break block8;
                double[] coefficients = this.clusteringCoefficientStat.getCoefficientReuslts();
                int i = 0;
                for (Node n : graph.getNodes()) {
                    double coef = coefficients[i++];
                    switch (tr) {
                        case INTERVAL: {
                            n.setAttribute(this.dynamicCoefficientColumn, (Object)coef, new Interval(interval.getLow(), interval.getLow() + this.tick));
                            break;
                        }
                        case TIMESTAMP: {
                            n.setAttribute(this.dynamicCoefficientColumn, (Object)coef, interval.getLow());
                            n.setAttribute(this.dynamicCoefficientColumn, (Object)coef, interval.getHigh());
                        }
                    }
                    if (!this.cancel) continue;
                    break;
                }
            }
            finally {
                graph.readUnlockAll();
            }
        }
        double avg = this.clusteringCoefficientStat.getAverageClusteringCoefficient();
        this.graphModel.getGraphVisible().setAttribute(DYNAMIC_AVG_CLUSTERING_COEFFICIENT, (Object)avg, interval.getLow());
        this.graphModel.getGraphVisible().setAttribute(DYNAMIC_AVG_CLUSTERING_COEFFICIENT, (Object)avg, interval.getHigh());
        this.averages.put(interval.getLow(), avg);
        this.averages.put(interval.getHigh(), avg);
    }

    @Override
    public void end() {
        this.clusteringCoefficientStat = null;
    }

    @Override
    public void setBounds(Interval bounds) {
        this.bounds = bounds;
    }

    @Override
    public void setWindow(double window) {
        this.window = window;
    }

    @Override
    public void setTick(double tick) {
        this.tick = tick;
    }

    @Override
    public double getWindow() {
        return this.window;
    }

    @Override
    public double getTick() {
        return this.tick;
    }

    @Override
    public Interval getBounds() {
        return this.bounds;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public void setAverageOnly(boolean averageOnly) {
        this.averageOnly = averageOnly;
    }

    public boolean isAverageOnly() {
        return this.averageOnly;
    }

    @Override
    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
    }
}

