/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.WeakSet;

final class NbInstrumentation
implements Instrumentation {
    private static final Logger LOG = Logger.getLogger(NbInstrumentation.class.getName());
    private static final Object LOCK = new Object();
    private static volatile Collection<NbInstrumentation> ACTIVE;
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private static final ThreadLocal<Boolean> IN;

    NbInstrumentation() {
    }

    static NbInstrumentation registerAgent(ClassLoader l, String agentClassName) {
        try {
            return NbInstrumentation.registerImpl(agentClassName, l);
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Cannot register " + agentClassName, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterAgent(NbInstrumentation instr) {
        Object object = LOCK;
        synchronized (object) {
            if (ACTIVE != null) {
                WeakSet<NbInstrumentation> clone = new WeakSet<NbInstrumentation>(ACTIVE);
                clone.remove(instr);
                ACTIVE = clone;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NbInstrumentation registerImpl(String agentClassName, ClassLoader l) throws ClassNotFoundException, IllegalArgumentException, NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException {
        NbInstrumentation inst = new NbInstrumentation();
        Object object = LOCK;
        synchronized (object) {
            ACTIVE = ACTIVE == null ? new WeakSet<NbInstrumentation>() : new WeakSet<NbInstrumentation>(ACTIVE);
            ACTIVE.add(inst);
        }
        Class<?> agentClass = Class.forName(agentClassName, true, l);
        try {
            Method m = agentClass.getMethod("agentmain", String.class, Instrumentation.class);
            m.invoke(null, "", inst);
        }
        catch (NoSuchMethodException ex) {
            Method m = agentClass.getMethod("agentmain", String.class);
            m.invoke(null, "");
        }
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] patchByteCode(ClassLoader l, String className, ProtectionDomain pd, byte[] arr) throws IllegalClassFormatException {
        if (ACTIVE == null) {
            return arr;
        }
        if (Boolean.TRUE.equals(IN.get())) {
            return arr;
        }
        try {
            IN.set(Boolean.TRUE);
            for (NbInstrumentation inst : ACTIVE) {
                for (ClassFileTransformer t : inst.transformers) {
                    arr = t.transform(l, className, null, pd, arr);
                }
            }
        }
        finally {
            IN.set(null);
        }
        return arr;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer, boolean canRetransform) {
        this.transformers.add(transformer);
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    @Override
    public boolean removeTransformer(ClassFileTransformer transformer) {
        return this.transformers.remove(transformer);
    }

    @Override
    public boolean isRetransformClassesSupported() {
        return false;
    }

    @Override
    public void retransformClasses(Class<?> ... classes) throws UnmodifiableClassException {
        throw new UnmodifiableClassException();
    }

    @Override
    public boolean isRedefineClassesSupported() {
        return false;
    }

    @Override
    public void redefineClasses(ClassDefinition ... definitions) throws ClassNotFoundException, UnmodifiableClassException {
        throw new UnmodifiableClassException();
    }

    @Override
    public boolean isModifiableClass(Class<?> theClass) {
        return false;
    }

    @Override
    public Class[] getAllLoadedClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getInitiatedClasses(ClassLoader loader) {
        return new Class[0];
    }

    @Override
    public long getObjectSize(Object objectToSize) {
        return 42L;
    }

    @Override
    public void appendToBootstrapClassLoaderSearch(JarFile jarfile) {
    }

    @Override
    public void appendToSystemClassLoaderSearch(JarFile jarfile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNativeMethodPrefixSupported() {
        return false;
    }

    @Override
    public void setNativeMethodPrefix(ClassFileTransformer transformer, String prefix) {
        throw new UnsupportedOperationException();
    }

    static {
        IN = new ThreadLocal();
    }
}

