/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.intent;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.intent.Callback;
import org.netbeans.api.intent.IntentAction;
import org.netbeans.api.intent.NoAvailableHandlerException;
import org.netbeans.modules.intent.CallbackResult;
import org.netbeans.modules.intent.IntentHandler;
import org.netbeans.modules.intent.SettableResult;
import org.netbeans.spi.intent.Result;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class Intent {
    private static final Logger LOG = Logger.getLogger(Intent.class.getName());
    public static final String ACTION_VIEW = "VIEW";
    public static final String ACTION_EDIT = "EDIT";
    private final String action;
    private final URI uri;

    public Intent(@NonNull String action, @NonNull URI uri) {
        Parameters.notNull("action", action);
        Parameters.notNull("uri", uri);
        this.action = action;
        this.uri = uri;
    }

    @NonNull
    public String getAction() {
        return this.action;
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public Future<Object> execute() {
        return IntentHandler.RP.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SettableResult sr = new SettableResult();
                Intent.invoke(Intent.this, sr);
                if (sr.getException() != null) {
                    throw sr.getException();
                }
                return sr.getResult();
            }
        });
    }

    public void execute(final @NullAllowed Callback callback) {
        IntentHandler.RP.post(new Runnable(){

            @Override
            public void run() {
                Intent.invoke(Intent.this, callback == null ? null : new CallbackResult(callback));
            }
        });
    }

    @NonNull
    public SortedSet<? extends IntentAction> getIntentActions() {
        SortedSet<IntentHandler> intentHandlers = Intent.getIntentHandlers(this);
        TreeSet<IntentAction> actions2 = new TreeSet<IntentAction>(new Comparator<IntentAction>(){

            @Override
            public int compare(IntentAction o1, IntentAction o2) {
                return o1.getPosition() - o2.getPosition();
            }
        });
        for (IntentHandler ih : intentHandlers) {
            actions2.add(new IntentAction(this, ih));
        }
        return Collections.unmodifiableSortedSet(actions2);
    }

    private static SortedSet<IntentHandler> getIntentHandlers(Intent intent) {
        FileObject f = FileUtil.getConfigFile("Services/Intent/Handlers");
        if (f == null) {
            return null;
        }
        TreeSet<IntentHandler> candidates = new TreeSet<IntentHandler>();
        for (FileObject fo : f.getChildren()) {
            if (!"instance".equals(fo.getExt())) continue;
            Object pattern = fo.getAttribute("uriPattern");
            Object displayName = fo.getAttribute("displayName");
            Object position = fo.getAttribute("position");
            Object actions2 = fo.getAttribute("actions");
            if (pattern instanceof String && displayName instanceof String && position instanceof Integer && actions2 instanceof String) {
                if (!Intent.canSupport((String)pattern, (String)actions2, intent)) continue;
                try {
                    IntentHandler ih = FileUtil.getConfigObject(fo.getPath(), IntentHandler.class);
                    candidates.add(ih);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Cannot instantiate handler for " + fo.getPath(), e);
                }
                continue;
            }
            LOG.log(Level.FINE, "Invalid URI handler {0}", fo.getPath());
        }
        return candidates;
    }

    private static boolean canSupport(String uriPattern, String actions2, Intent intent) {
        Pattern p = Pattern.compile(uriPattern);
        if (p.matcher(intent.getUri().toString()).matches()) {
            if ("*".equals(actions2)) {
                return true;
            }
            List<String> actionList = Arrays.asList(actions2.split(","));
            return actionList.contains(intent.getAction());
        }
        return false;
    }

    private static void invoke(Intent intent, Result resultOrNull) {
        Exception lastException = null;
        boolean handled = false;
        for (IntentHandler h : Intent.getIntentHandlers(intent)) {
            try {
                h.handle(intent, resultOrNull);
                handled = true;
                break;
            }
            catch (Exception e) {
                lastException = e;
                LOG.log(Level.WARNING, null, e);
            }
        }
        if (!handled) {
            if (resultOrNull != null) {
                resultOrNull.setException(lastException == null ? new NoAvailableHandlerException(intent) : new NoAvailableHandlerException(intent, (Throwable)lastException));
            }
            LOG.log(Level.INFO, "Intent {0} cannot be handled", intent);
        }
    }

    public String toString() {
        return "Intent{action=" + this.action + ", uri=" + this.uri + '}';
    }
}

