/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import java.io.PrintWriter;
import java.io.Reader;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.io.IOProvider;
import org.netbeans.api.io.OutputWriter;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.spi.io.InputOutputProvider;
import org.openide.util.Lookup;

public abstract class InputOutput
implements Lookup.Provider {
    private static final Set<ShowOperation> DEFAULT_SHOW_OPERATIONS = EnumSet.of(ShowOperation.OPEN, ShowOperation.MAKE_VISIBLE);

    private InputOutput() {
    }

    @NonNull
    public static InputOutput get(@NonNull String name, boolean newIO) {
        return IOProvider.getDefault().getIO(name, newIO);
    }

    @NonNull
    public static InputOutput get(@NonNull String name, boolean newIO, @NonNull Lookup lookup) {
        return IOProvider.getDefault().getIO(name, newIO, lookup);
    }

    @NonNull
    public abstract Reader getIn();

    @NonNull
    public abstract OutputWriter getOut();

    @NonNull
    public abstract OutputWriter getErr();

    public abstract void reset();

    @Override
    @NonNull
    public abstract Lookup getLookup();

    public abstract void close();

    public abstract boolean isClosed();

    @CheckForNull
    public abstract String getDescription();

    public abstract void setDescription(@NullAllowed String var1);

    static <IO, OW extends PrintWriter, P, F> InputOutput create(InputOutputProvider<IO, OW, P, F> provider, IO io) {
        return new Impl<IO, OW, P, F>(provider, io);
    }

    public final void show() {
        this.show(DEFAULT_SHOW_OPERATIONS);
    }

    public abstract void show(@NullAllowed Set<ShowOperation> var1);

    private static class Impl<IO, OW extends PrintWriter, P, F>
    extends InputOutput {
        private final Map<OW, OutputWriter> cache = Collections.synchronizedMap(new WeakHashMap());
        private final InputOutputProvider<IO, OW, P, F> provider;
        private final IO ioObject;

        public Impl(InputOutputProvider<IO, OW, P, F> provider, IO ioObject) {
            this.provider = provider;
            this.ioObject = ioObject;
        }

        @Override
        public Reader getIn() {
            return this.provider.getIn(this.ioObject);
        }

        @Override
        public OutputWriter getOut() {
            return this.createOrGetCachedWrapper(this.provider.getOut(this.ioObject));
        }

        @Override
        public OutputWriter getErr() {
            return this.createOrGetCachedWrapper(this.provider.getErr(this.ioObject));
        }

        @Override
        @NonNull
        public Lookup getLookup() {
            return this.provider.getIOLookup(this.ioObject);
        }

        @Override
        public void reset() {
            this.provider.resetIO(this.ioObject);
        }

        private OutputWriter createOrGetCachedWrapper(OW pw) {
            OutputWriter ow = this.cache.get(pw);
            if (ow == null) {
                ow = OutputWriter.create(this.provider, this.ioObject, pw);
                this.cache.put(pw, ow);
            }
            return ow;
        }

        @Override
        public void close() {
            this.provider.closeIO(this.ioObject);
        }

        @Override
        public boolean isClosed() {
            return this.provider.isIOClosed(this.ioObject);
        }

        @Override
        public String getDescription() {
            return this.provider.getIODescription(this.ioObject);
        }

        @Override
        public void setDescription(String description) {
            this.provider.setIODescription(this.ioObject, description);
        }

        @Override
        public void show(Set<ShowOperation> operations) {
            this.provider.showIO(this.ioObject, operations != null ? operations : Collections.emptySet());
        }
    }
}

