/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.text.MessageFormat;
import java.util.Date;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public abstract class WrappersEditor
implements ExPropertyEditor {
    protected PropertyEditor pe = null;

    public WrappersEditor(Class type) {
        this.pe = PropertyEditorManager.findEditor(type);
    }

    @Override
    public void setValue(Object newValue) throws IllegalArgumentException {
        this.pe.setValue(newValue);
    }

    @Override
    public Object getValue() {
        return this.pe.getValue();
    }

    @Override
    public boolean isPaintable() {
        return this.pe.isPaintable();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        this.pe.paintValue(gfx, box);
    }

    @Override
    public String getAsText() {
        if (this.pe.getValue() == null) {
            return "null";
        }
        return this.pe.getAsText();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if ("null".equals(text)) {
            return;
        }
        try {
            this.pe.setAsText(text);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
            String msg = e.getLocalizedMessage();
            if (msg == null || e.getMessage().equals(msg)) {
                msg = MessageFormat.format(NbBundle.getMessage(WrappersEditor.class, "FMT_EXC_GENERIC_BAD_VALUE"), text);
            }
            UIExceptions.annotateUser(iae, iae.getMessage(), msg, e, new Date());
            throw iae;
        }
    }

    @Override
    public String[] getTags() {
        return this.pe.getTags();
    }

    @Override
    public Component getCustomEditor() {
        return this.pe.getCustomEditor();
    }

    @Override
    public boolean supportsCustomEditor() {
        return this.pe.supportsCustomEditor();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pe.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pe.removePropertyChangeListener(listener);
    }

    @Override
    public void attachEnv(PropertyEnv env) {
        if (this.pe instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.pe).attachEnv(env);
        }
    }
}

