/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class IDESettings {
    public static final String PROP_WWWBROWSER = "WWWBrowser";
    public static final String PROP_EXTERNAL_WWWBROWSER = "ExternalWWWBrowser";

    static Preferences getPreferences() {
        return NbPreferences.forModule(IDESettings.class);
    }

    public static HtmlBrowser.Factory getWWWBrowser() {
        return IDESettings.getBrowser(PROP_WWWBROWSER, false);
    }

    public static HtmlBrowser.Factory getExternalWWWBrowser() {
        return IDESettings.getBrowser(PROP_EXTERNAL_WWWBROWSER, true);
    }

    public static void setWWWBrowser(HtmlBrowser.Factory brow) {
        IDESettings.setBrowser(PROP_WWWBROWSER, brow);
        if (IDESettings.isExternal(brow)) {
            IDESettings.setExternalWWWBrowser(brow);
        }
    }

    public static void setExternalWWWBrowser(HtmlBrowser.Factory brow) {
        IDESettings.setBrowser(PROP_EXTERNAL_WWWBROWSER, brow);
    }

    private static void setBrowser(String prefId, HtmlBrowser.Factory brow) {
        try {
            if (brow == null) {
                IDESettings.getPreferences().put(prefId, "");
                return;
            }
            Lookup.Item<HtmlBrowser.Factory> item = Lookup.getDefault().lookupItem(new Lookup.Template<HtmlBrowser.Factory>(HtmlBrowser.Factory.class, null, brow));
            if (item != null) {
                IDESettings.getPreferences().put(prefId, item.getId());
            } else {
                Logger.getLogger(IDESettings.class.getName()).warning("IDESettings: Cannot find browser in lookup");
                IDESettings.getPreferences().put(prefId, "");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    private static HtmlBrowser.Factory getBrowser(String prefId, boolean mustBeExternal) {
        block8: {
            try {
                String obj = IDESettings.getPreferences().get(prefId, null);
                if (obj instanceof String && !"".equals(obj)) {
                    Lookup.Item<Object> item = Lookup.getDefault().lookupItem(new Lookup.Template<Object>(HtmlBrowser.Factory.class, obj, null));
                    return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
                }
                if (obj != null && !"".equals(obj)) break block8;
                Lookup.Result<HtmlBrowser.Factory> res = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);
                for (HtmlBrowser.Factory brow : res.allInstances()) {
                    FileObject fo = FileUtil.getConfigFile("Services/Browsers");
                    DataFolder folder = DataFolder.findFolder(fo);
                    DataObject[] dobjs = folder.getChildren();
                    for (int i = 0; i < dobjs.length; ++i) {
                        Object o = null;
                        try {
                            InstanceCookie cookie;
                            if (Boolean.TRUE.equals(dobjs[i].getPrimaryFile().getAttribute("hidden")) || mustBeExternal && Boolean.TRUE.equals(dobjs[i].getPrimaryFile().getAttribute("internal")) || (cookie = dobjs[i].getCookie(InstanceCookie.class)) == null || (o = cookie.instanceCreate()) == null || !o.equals(brow)) continue;
                            return brow;
                        }
                        catch (IOException ex) {
                            Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, ex);
                            continue;
                        }
                        catch (ClassNotFoundException ex) {
                            Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, ex);
                        }
                    }
                }
                return null;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        return null;
    }

    private static boolean isExternal(HtmlBrowser.Factory brow) {
        FileObject fo = FileUtil.getConfigFile("Services/Browsers");
        DataFolder folder = DataFolder.findFolder(fo);
        DataObject[] dobjs = folder.getChildren();
        for (int i = 0; i < dobjs.length; ++i) {
            Object o = null;
            try {
                InstanceCookie cookie;
                if (Boolean.TRUE.equals(dobjs[i].getPrimaryFile().getAttribute("hidden")) || !Boolean.TRUE.equals(dobjs[i].getPrimaryFile().getAttribute("internal")) || (cookie = dobjs[i].getCookie(InstanceCookie.class)) == null || (o = cookie.instanceCreate()) == null || !o.equals(brow)) continue;
                return false;
            }
            catch (IOException ex) {
                Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, ex);
                continue;
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, ex);
            }
        }
        return false;
    }

    private static HtmlBrowser.FactoryEditor createHtmlBrowserFactoryEditor() {
        return new HtmlBrowser.FactoryEditor(){

            @Override
            public void setValue(Object value) {
                IDESettings.setWWWBrowser((HtmlBrowser.Factory)value);
            }

            @Override
            public Object getValue() {
                return IDESettings.getWWWBrowser();
            }
        };
    }
}

