/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.MissingResourceException;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CLIOptions
extends CLIHandler {
    static final String DIR_MODULES = "modules";
    static boolean defaultsLoaded = false;
    protected static boolean noLogging = false;
    private static boolean noSplash;
    protected static Class uiClass;
    private static int uiFontSize;
    private static boolean fallbackToMemory;
    private static String homeDir;
    private static String userDir;
    private static String systemDir;
    private static File cacheDir;
    private static boolean gui;

    public CLIOptions() {
        super(1);
    }

    @Override
    protected int cli(CLIHandler.Args arguments) {
        return this.cli(arguments.getArguments());
    }

    static boolean isFallbackToMemory() {
        return fallbackToMemory;
    }

    static void fallbackToMemory() {
        fallbackToMemory = true;
    }

    public static boolean isGui() {
        return gui && !GraphicsEnvironment.isHeadless();
    }

    private static boolean isOption(String value, String optionName) {
        if (value == null) {
            return false;
        }
        if (value.startsWith("--") && optionName.length() > 1) {
            return value.substring(2).equals(optionName);
        }
        if (value.startsWith("-") && optionName.length() == 1) {
            return value.substring(1).contains(optionName);
        }
        return false;
    }

    public final int cli(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            boolean used = true;
            if (CLIOptions.isOption(args[i], "nogui")) {
                gui = false;
            } else if (CLIOptions.isOption(args[i], "nosplash")) {
                noSplash = true;
            } else if (!CLIOptions.isOption(args[i], "noinfo")) {
                if (CLIOptions.isOption(args[i], "nologging")) {
                    noLogging = true;
                } else if (CLIOptions.isOption(args[i], "userdir")) {
                    args[i] = null;
                    try {
                        String v = args[++i];
                        if (!v.equals("memory")) {
                            v = FileUtil.normalizeFile(new File(v)).getPath();
                        }
                        userDir = v;
                        System.setProperty("netbeans.user", v);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.err.println(CLIOptions.getString("ERR_UserDirExpected"));
                        return 2;
                    }
                } else if (CLIOptions.isOption(args[i], "cachedir")) {
                    args[i] = null;
                    try {
                        cacheDir = FileUtil.normalizeFile(new File(args[++i]));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.err.println(CLIOptions.getString("ERR_UserDirExpected"));
                        return 2;
                    }
                } else if (CLIOptions.isOption(args[i], "ui") || CLIOptions.isOption(args[i], "laf")) {
                    args[i] = null;
                    try {
                        String ui = args[++i];
                        if ("Metal".equals(ui)) {
                            ui = "javax.swing.plaf.metal.MetalLookAndFeel";
                        } else if ("GTK".equals(ui)) {
                            ui = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                        } else if ("Nimbus".equals(ui)) {
                            ui = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
                        } else if ("Windows".equals(ui)) {
                            ui = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                        } else if ("Aqua".equals(ui)) {
                            ui = "apple.laf.AquaLookAndFeel";
                        }
                        uiClass = Class.forName(ui);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.err.println(CLIOptions.getString("ERR_UIExpected"));
                        return 2;
                    }
                    catch (ClassNotFoundException e2) {
                        System.err.println(CLIOptions.getString("ERR_UINotFound"));
                    }
                } else if (CLIOptions.isOption(args[i], "fontsize")) {
                    args[i] = null;
                    try {
                        uiFontSize = Integer.parseInt(args[++i]);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.err.println(CLIOptions.getString("ERR_FontSizeExpected"));
                        return 2;
                    }
                    catch (NumberFormatException e2) {
                        System.err.println(CLIOptions.getString("ERR_BadFontSize"));
                        return 1;
                    }
                } else if (CLIOptions.isOption(args[i], "locale")) {
                    args[i] = null;
                    try {
                        String language;
                        String localeParam = args[++i];
                        String country = "";
                        String variant = "";
                        int index1 = localeParam.indexOf(":");
                        if (index1 == -1) {
                            language = localeParam;
                        } else {
                            language = localeParam.substring(0, index1);
                            int index2 = localeParam.indexOf(":", index1 + 1);
                            if (index2 != -1) {
                                country = localeParam.substring(index1 + 1, index2);
                                variant = localeParam.substring(index2 + 1);
                            } else {
                                country = localeParam.substring(index1 + 1);
                            }
                        }
                        Locale.setDefault(new Locale(language, country, variant));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.err.println(CLIOptions.getString("ERR_LocaleExpected"));
                        return 2;
                    }
                } else if (CLIOptions.isOption(args[i], "branding")) {
                    args[i] = null;
                    if (++i == args.length) {
                        System.err.println(CLIOptions.getString("ERR_BrandingNeedsArgument"));
                        return 2;
                    }
                    String branding = args[i];
                    if (branding.equals("-")) {
                        branding = null;
                    }
                    try {
                        NbBundle.setBranding(branding);
                    }
                    catch (IllegalArgumentException iae) {
                        iae.printStackTrace();
                        return 1;
                    }
                } else {
                    used = false;
                }
            }
            if (!used) continue;
            args[i] = null;
        }
        return 0;
    }

    public static void initialize() {
        TopLogging.initialize();
        StartLog.logProgress("TopLogging initialized");
    }

    @Override
    protected void usage(PrintWriter w) {
        w.println("Core options:");
        w.println("  --laf <LaF classname> use given LookAndFeel class instead of the default");
        w.println("  --fontsize <size>     set the base font size of the user interface, in points");
        w.println("  --locale <language[:country[:variant]]> use specified locale");
        w.println("  --userdir <path>      use specified directory to store user settings");
        w.println("  --cachedir <path>     use specified directory to store user cache, must be different from userdir");
        w.println("  --nosplash            do not show the splash screen");
        w.println("");
    }

    private static String getString(String key) {
        return NbBundle.getMessage(CLIOptions.class, key);
    }

    public static String getLogDir() {
        return new File(new File(CLIOptions.getUserDir(), "var"), "log").toString();
    }

    static final void clearForTests() {
        homeDir = null;
        userDir = null;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            homeDir = System.getProperty("netbeans.home");
        }
        return homeDir;
    }

    public static String getUserDir() {
        if (userDir == null || !userDir.equals(System.getProperty("netbeans.user"))) {
            userDir = System.getProperty("netbeans.user");
            if ("memory".equals(userDir)) {
                return "memory";
            }
            if (userDir == null) {
                if (homeDir == null) {
                    return "memory";
                }
                System.err.println(NbBundle.getMessage(CLIOptions.class, "ERR_no_user_directory"));
                Thread.dumpStack();
                TopLogging.exit(1);
            }
            File userDirF = FileUtil.normalizeFile(new File(userDir));
            String _homeDir = CLIOptions.getHomeDir();
            if (_homeDir != null) {
                File homeDirF = FileUtil.normalizeFile(new File(_homeDir));
                if ((userDirF.getAbsolutePath() + File.separatorChar).startsWith(homeDirF.getParentFile().getAbsolutePath() + File.separatorChar)) {
                    System.err.println(NbBundle.getMessage(CLIOptions.class, "ERR_user_dir_is_inside_home", userDirF, homeDirF.getParentFile()));
                    TopLogging.exit(1);
                }
            }
            userDir = userDirF.getPath();
            System.setProperty("netbeans.user", userDir);
            File systemDirFile = new File(userDirF, "config");
            CLIOptions.makedir(systemDirFile);
            systemDir = systemDirFile.getAbsolutePath();
        }
        return userDir;
    }

    public static File getCacheDir() {
        return cacheDir;
    }

    private static void makedir(File f) {
        Object[] arg;
        if (f.isFile()) {
            arg = new Object[]{f};
            System.err.println(NbBundle.getMessage(CLIOptions.class, "CTL_CannotCreate_text", arg));
            TopSecurityManager.exit(6);
        }
        if (!f.exists() && !f.mkdirs()) {
            arg = new Object[]{f};
            System.err.println(NbBundle.getMessage(CLIOptions.class, "CTL_CannotCreateSysDir_text", arg));
            TopSecurityManager.exit(7);
        }
    }

    protected static String getSystemDir() {
        CLIOptions.getUserDir();
        return systemDir;
    }

    private static void initDefaults() {
        if (!defaultsLoaded) {
            if (uiFontSize == 0) {
                String key = "";
                try {
                    key = NbBundle.getMessage(Main.class, "CTL_globalFontSize");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (key.length() > 0) {
                    try {
                        uiFontSize = Integer.parseInt(key);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (!noSplash) {
                String value = NbBundle.getMessage(CLIOptions.class, "SplashOnByDefault");
                noSplash = !Boolean.parseBoolean(value);
            }
            defaultsLoaded = true;
        }
    }

    public static int getFontSize() {
        CLIOptions.initDefaults();
        return uiFontSize;
    }

    static boolean isNoSplash() {
        CLIOptions.initDefaults();
        return noSplash;
    }

    static {
        uiFontSize = 0;
        gui = true;
    }
}

