/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.core.startup.NbProblemDisplayer;
import org.openide.modules.Dependency;

public class ConsistencyVerifier {
    private ConsistencyVerifier() {
    }

    public static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> modules) throws IllegalArgumentException {
        return ConsistencyVerifier.findInconsistencies(modules, null);
    }

    public static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> modules, Set<String> permittedDisabledAutoloads) throws IllegalArgumentException {
        return ConsistencyVerifier.findInconsistencies(modules, permittedDisabledAutoloads, true);
    }

    static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> modules, Set<String> permittedDisabledAutoloads, boolean formatted) throws IllegalArgumentException {
        ModuleManager mgr = new ModuleManager(new DummyInstaller(), new DummyEvents());
        mgr.mutexPrivileged().enterWriteAccess();
        Manifest dummy = new Manifest();
        dummy.getMainAttributes().putValue("OpenIDE-Module", "__dummy__");
        dummy.getMainAttributes().putValue("OpenIDE-Module-Provides", "org.openide.modules.ModuleFormat1, org.openide.modules.ModuleFormat2, org.openide.modules.jre.JavaFX, org.openide.modules.os.Unix, org.openide.modules.os.PlainUnix, org.openide.modules.os.Windows, org.openide.modules.os.MacOSX, org.openide.modules.os.Linux, org.openide.modules.os.Solaris, org.openide.modules.os.OS2");
        dummy.getMainAttributes().putValue("OpenIDE-Module-Public-Packages", "-");
        try {
            mgr.createFixed(dummy, null, ClassLoader.getSystemClassLoader());
        }
        catch (Exception x) {
            throw new AssertionError((Object)x);
        }
        HashSet<Module> mods = new HashSet<Module>();
        HashSet<Module> regularMods = new HashSet<Module>();
        for (Manifest m : modules) {
            Attributes man = m.getMainAttributes();
            try {
                man.putValue("OpenIDE-Module-Public-Packages", "-");
                man.remove(new Attributes.Name("OpenIDE-Module-Friends"));
                man.remove(new Attributes.Name("OpenIDE-Module-Localizing-Bundle"));
                String bsn = man.getValue("Bundle-SymbolicName");
                String ver = man.getValue("Bundle-Version");
                if (bsn != null && ver != null) {
                    bsn = bsn.replaceAll(";.*", "");
                    if (man.getValue("OpenIDE-Module") == null) {
                        man.putValue("OpenIDE-Module", bsn);
                    }
                    if (man.getValue("OpenIDE-Module-Specification-Version") == null) {
                        Matcher match = Pattern.compile("[0-9]*(\\.[0-9]*)?(\\.[0-9]*)?").matcher(ver);
                        if (match.find()) {
                            ver = match.group();
                        }
                        man.putValue("OpenIDE-Module-Specification-Version", ver.replace("(.*)", ""));
                    }
                }
                boolean autoload = "true".equals(man.getValue("autoload"));
                boolean eager = "true".equals(man.getValue("eager"));
                Module mod = mgr.createFixed(m, null, ClassLoader.getSystemClassLoader(), autoload, eager);
                mods.add(mod);
                if (autoload || eager) continue;
                regularMods.add(mod);
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Error parsing " + man.entrySet() + ": " + x, x);
            }
        }
        TreeMap<String, SortedSet<String>> problems = new TreeMap<String, SortedSet<String>>();
        List<Module> regularModsEnabled = mgr.simulateEnable(regularMods);
        for (Module m : mods) {
            String cnb = m.getCodeNameBase();
            Set<Object> probs = m.getProblems();
            if (probs.isEmpty()) {
                if (permittedDisabledAutoloads == null || permittedDisabledAutoloads.contains(cnb) || !m.isAutoload() || regularModsEnabled.contains(m) || "true".equals(m.getAttribute("OpenIDE-Module-Deprecated"))) continue;
                problems.put(cnb, new TreeSet<String>(Collections.singleton("module is autoload but would not be enabled")));
                continue;
            }
            TreeSet<String> probnames = new TreeSet<String>();
            for (Object prob : probs) {
                Dependency d;
                if (prob instanceof Dependency && 3 == (d = (Dependency)prob).getType() && m.isAutoload()) continue;
                String description = formatted ? NbProblemDisplayer.messageForProblem(m, prob, false) : prob.toString();
                probnames.add(description);
            }
            if (probnames.isEmpty()) continue;
            problems.put(cnb, probnames);
        }
        return problems;
    }

    private static final class DummyEvents
    extends Events {
        private DummyEvents() {
        }

        @Override
        protected void logged(String message, Object[] args) {
        }
    }

    private static final class DummyInstaller
    extends ModuleInstaller {
        private DummyInstaller() {
        }

        @Override
        public void prepare(Module m) throws InvalidException {
            throw new AssertionError();
        }

        @Override
        public void dispose(Module m) {
            throw new AssertionError();
        }

        @Override
        public void load(List<Module> modules) {
            throw new AssertionError();
        }

        @Override
        public void unload(List<Module> modules) {
            throw new AssertionError();
        }

        @Override
        public boolean closing(List<Module> modules) {
            throw new AssertionError();
        }

        @Override
        public void close(List<Module> modules) {
            throw new AssertionError();
        }
    }
}

