/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.JaveleonModule;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Stamps;
import org.netbeans.core.startup.JaveleonModuleReloader;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.ModuleLifecycleManager;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.NbEvents;
import org.netbeans.core.startup.NbInstaller;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class ModuleSystem {
    private static final Logger LOG = Logger.getLogger(ModuleSystem.class.getName());
    private final ModuleManager mgr;
    private final NbInstaller installer;
    private ModuleList list;
    private final Events ev = Boolean.getBoolean("netbeans.modules.quiet") ? new QuietEvents() : new NbEvents();
    private Set<Module> bootModules = null;

    public ModuleSystem(FileSystem systemFileSystem) throws IOException {
        this();
        this.init(systemFileSystem);
    }

    ModuleSystem() {
        this.installer = new NbInstaller(this.ev);
        this.mgr = new ModuleManager(this.installer, this.ev);
    }

    final void init(FileSystem systemFileSystem) throws IOException {
        if (Boolean.getBoolean("org.netbeans.core.startup.ModuleSystem.CULPRIT")) {
            Thread.dumpStack();
        }
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if ("classLoader".equals(ev.getPropertyName())) {
                    MainLookup.systemClassLoaderChanged(ModuleSystem.this.mgr.getClassLoader());
                }
            }
        };
        this.mgr.addPropertyChangeListener(l);
        MainLookup.systemClassLoaderChanged(this.installer.getClass().getClassLoader());
        MainLookup.moduleLookupReady(this.mgr.getModuleLookup());
        if (systemFileSystem.isReadOnly()) {
            this.list = null;
        } else {
            FileObject root = systemFileSystem.getRoot();
            FileObject modulesFolder = root.getFileObject("Modules");
            if (modulesFolder == null) {
                modulesFolder = root.createFolder("Modules");
            }
            this.list = new ModuleList(this.mgr, modulesFolder, this.ev);
            this.installer.registerList(this.list);
            this.installer.registerManager(this.mgr);
        }
        this.ev.log("createdModuleSystem", new Object[0]);
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public Events getEvents() {
        return this.ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getModuleJars() {
        this.mgr.mutexPrivileged().enterReadAccess();
        try {
            ArrayList<File> l = new ArrayList<File>();
            for (Module m : this.mgr.getEnabledModules()) {
                l.addAll(m.getAllJars());
            }
            ArrayList<File> arrayList = l;
            return arrayList;
        }
        finally {
            this.mgr.mutexPrivileged().exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBootModules() {
        HashSet<File> ignoredJars = new HashSet<File>();
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            File file = new File(new File(javaHome).getParentFile(), "lib");
            ignoredJars.add(new File(file, "tools.jar"));
            ignoredJars.add(new File(file, "dt.jar"));
        }
        for (String entry : System.getProperty("sun.boot.class.path", "").split(File.pathSeparator)) {
            ignoredJars.add(new File(entry));
        }
        LOG.log(Level.FINE, "Ignored JARs: {0}", ignoredJars);
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startLoadBootModules", new Object[0]);
        try {
            this.bootModules = new HashSet<Module>(10);
            ClassLoader classLoader = ModuleSystem.class.getClassLoader();
            Enumeration<URL> e = classLoader.getResources("META-INF/MANIFEST.MF");
            this.ev.log("perfTick", "got all manifests");
            HashSet<URL> checkedManifests = new HashSet<URL>();
            while (e.hasMoreElements()) {
                InputStream is;
                URL manifestUrl = e.nextElement();
                if (!checkedManifests.add(manifestUrl)) continue;
                URL jarURL = FileUtil.getArchiveFile(manifestUrl);
                if (jarURL != null && jarURL.getProtocol().equals("file") && jarURL.getPath().startsWith("/")) {
                    LOG.log(Level.FINE, "Considering JAR: {0}", jarURL);
                    try {
                        if (ignoredJars.contains(Utilities.toFile(jarURL.toURI()))) {
                            LOG.log(Level.FINE, "ignoring JDK/JRE manifest: {0}", manifestUrl);
                            continue;
                        }
                    }
                    catch (URISyntaxException x) {
                        Exceptions.printStackTrace(x);
                    }
                }
                LOG.log(Level.FINE, "Checking boot manifest: {0}", manifestUrl);
                try {
                    is = manifestUrl.openStream();
                }
                catch (IOException ioe) {
                    Exceptions.attachMessage(ioe, "URL: " + manifestUrl);
                    throw ioe;
                }
                try {
                    Manifest mani = new Manifest(is);
                    Attributes attr = mani.getMainAttributes();
                    if (attr.getValue("OpenIDE-Module") == null) continue;
                    this.bootModules.add(this.mgr.createFixed(mani, manifestUrl, classLoader));
                }
                finally {
                    is.close();
                }
            }
            if (this.list == null) {
                this.mgr.enable(this.bootModules);
            }
            this.ev.log("perfTick", "added all classpath modules");
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
        catch (DuplicateException duplicateException) {
            LOG.log(Level.WARNING, null, duplicateException);
        }
        finally {
            this.ev.log("finishLoadBootModules", new Object[0]);
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    public final void refresh() {
        this.list.moduleListChanged();
    }

    public void readList() {
        this.ev.log("perfStart", "ModuleSystem.readList");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.list.readInitial();
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", "ModuleSystem.readList");
    }

    public void restore() {
        this.ev.log("perfStart", "ModuleSystem.restore");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            HashSet<Module> toTrigger = new HashSet<Module>(this.bootModules);
            this.list.trigger(toTrigger);
            this.mgr.releaseModuleManifests();
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.installer.preloadCache(this.mgr.getModules());
        this.ev.log("perfEnd", "ModuleSystem.restore");
        this.ev.log("perfStart", "ModuleSystem.waitOnStart");
        this.installer.waitOnStart();
        this.ev.log("perfEnd", "ModuleSystem.waitOnStart");
    }

    public boolean shutDown(Runnable midHook) {
        try {
            return this.shutDownAsync(midHook).get();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace(ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace(ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> shutDownAsync(final Runnable midHook) {
        Future<Boolean> res;
        this.mgr.mutexPrivileged().enterWriteAccess();
        Runnable both = new Runnable(){

            @Override
            public void run() {
                midHook.run();
                Stamps.getModulesJARs().shutdown();
            }
        };
        try {
            res = this.mgr.shutDownAsync(both);
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void deployTestModule(File jar) throws IOException {
        block18: {
            if (!jar.isAbsolute()) {
                throw new IOException("Absolute paths only please");
            }
            if (JaveleonModule.isJaveleonPresent && JaveleonModuleReloader.getDefault().reloadJaveleonModule(jar, this.mgr, this.installer, this.ev)) {
                return;
            }
            this.mgr.mutexPrivileged().enterWriteAccess();
            this.ev.log("startDeployTestModule", new Object[]{jar});
            System.err.println("Deploying test module " + jar + "...");
            try {
                tm = null;
                toReenable = new HashSet<Module>();
                for (Module m : this.mgr.getModules()) {
                    if (m.getJarFile() == null || !jar.equals(m.getJarFile())) continue;
                    if (m.isAutoload() || m.isEager()) {
                        System.err.println("Reloading autoload and eager modules is not supported, sorry! (Try Javeleon.)");
                        break block18;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl31
            }
            catch (Throwable var7_9) {
                this.ev.log("finishDeployTestModule", new Object[]{jar});
                this.mgr.mutexPrivileged().exitWriteAccess();
                throw var7_9;
            }
        }
        this.ev.log("finishDeployTestModule", new Object[]{jar});
        this.mgr.mutexPrivileged().exitWriteAccess();
        return;
lbl-1000:
        // 1 sources

        {
            if (!m.isReloadable()) {
                m.setReloadable(true);
            }
            this.turnOffModule(m, toReenable);
            this.mgr.reload(m);
            tm = m;
lbl31:
            // 2 sources

            if (tm == null) {
                try {
                    tm = this.mgr.create(jar, new ModuleHistory(jar.getAbsolutePath()), true, false, false);
                }
                catch (DuplicateException dupe) {
                    old = dupe.getOldModule();
                    System.err.println("Replacing old module in " + old);
                    this.turnOffModule(old, toReenable);
                    this.mgr.delete(old);
                    try {
                        tm = this.mgr.create(jar, new ModuleHistory(jar.getAbsolutePath()), true, false, false);
                    }
                    catch (DuplicateException dupe2) {
                        throw (IOException)new IOException(dupe2.toString()).initCause(dupe2);
                    }
                }
            }
            System.err.println("Enabling " + tm + "...");
            if (!this.mgr.simulateEnable(Collections.singleton(tm)).contains(tm)) {
                throw new IOException("Cannot enable " + tm + "; problems: " + tm.getProblems());
            }
            this.mgr.enable(tm);
            if (!toReenable.isEmpty()) {
                System.err.println("Also re-enabling:");
                for (Module m : toReenable) {
                    System.err.println("\t" + m.getDisplayName());
                    if (!m.isReloadable()) continue;
                    m.reload();
                }
                try {
                    this.mgr.enable(toReenable);
                }
                catch (IllegalArgumentException iae) {
                    throw new IOException(iae.toString());
                }
            }
            System.err.println("Done.");
        }
        this.ev.log("finishDeployTestModule", new Object[]{jar});
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOffModule(Module m, Set<Module> toReenable) {
        if (!m.isEnabled()) {
            return;
        }
        for (Module m2 : this.mgr.simulateDisable(Collections.singleton(m))) {
            if (m2.isAutoload() || m2.isEager()) continue;
            toReenable.add(m2);
        }
        try {
            System.err.println("Disabling " + m + "...");
            this.mgr.disable(toReenable);
        }
        finally {
            toReenable.remove(m);
        }
    }

    public String getEffectiveClasspath(Module m) {
        return this.installer.getEffectiveClasspath(m);
    }

    public boolean isShowInAutoUpdateClient(ModuleInfo mi) {
        return this.installer.isShowInAutoUpdateClient(mi);
    }

    public static void markForRestart() throws UnsupportedOperationException {
        ModuleLifecycleManager.markReadyForRestart();
    }

    private static final class QuietEvents
    extends Events {
        QuietEvents() {
        }

        @Override
        protected void logged(String message, Object[] args) {
        }
    }
}

