/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public final class NbProblemDisplayer {
    private NbProblemDisplayer() {
    }

    public static String messageForProblem(Module m, Object problem) {
        return NbProblemDisplayer.messageForProblem(m, problem, true);
    }

    static String messageForProblem(Module m, Object problem, boolean localized) {
        if (problem instanceof InvalidException) {
            String loc = Exceptions.findLocalizedMessage((InvalidException)problem);
            return loc != null ? loc : problem.toString();
        }
        Dependency dep = (Dependency)problem;
        switch (dep.getType()) {
            case 1: {
                Module other;
                String polite = (String)m.getLocalizedAttribute("OpenIDE-Module-Module-Dependency-Message");
                if (polite != null) {
                    return polite;
                }
                String name = dep.getName();
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    name = name.substring(0, idx);
                }
                if ((other = m.getManager().get(name)) != null && other.getCodeName().equals(dep.getName())) {
                    switch (dep.getComparison()) {
                        case 3: {
                            return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_other_disabled", NbProblemDisplayer.label(other, localized));
                        }
                        case 2: {
                            String actualI;
                            String requestedI = dep.getVersion();
                            String string = actualI = other.getImplementationVersion() != null ? other.getImplementationVersion() : NbBundle.getMessage(NbProblemDisplayer.class, "LBL_no_impl_version");
                            if (requestedI.equals(actualI)) {
                                return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_other_disabled", NbProblemDisplayer.label(other, localized));
                            }
                            return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_other_wrong_version", NbProblemDisplayer.label(other, localized), requestedI, actualI);
                        }
                        case 1: {
                            SpecificationVersion actualS;
                            SpecificationVersion requestedS = new SpecificationVersion(dep.getVersion());
                            SpecificationVersion specificationVersion = actualS = other.getSpecificationVersion() != null ? other.getSpecificationVersion() : new SpecificationVersion("0");
                            if (actualS.compareTo(requestedS) >= 0) {
                                return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_other_disabled", NbProblemDisplayer.label(other, localized));
                            }
                            return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_other_too_old", NbProblemDisplayer.label(other, localized), requestedS, actualS);
                        }
                    }
                    throw new IllegalStateException();
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_other_needed_not_found", dep.getName());
            }
            case 5: 
            case 6: {
                String polite = (String)m.getLocalizedAttribute("OpenIDE-Module-Requires-Message");
                if (polite != null) {
                    return polite;
                }
                for (Module other : m.getManager().getModules()) {
                    if (!other.provides(dep.getName())) continue;
                    return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_require_disabled", dep.getName());
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_require_not_found", dep.getName());
            }
            case 2: {
                String polite = (String)m.getLocalizedAttribute("OpenIDE-Module-Package-Dependency-Message");
                if (polite != null) {
                    return polite;
                }
                String name = dep.getName();
                int idx = name.lastIndexOf(91);
                if (idx == 0) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_class_not_loaded", name.substring(1, name.length() - 1));
                }
                if (idx != -1) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_package_not_loaded_or_old", name.substring(0, idx));
                }
                return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_package_not_loaded_or_old", name);
            }
            case 3: {
                if (dep.getName().equals("Java") && dep.getComparison() == 1) {
                    return NbBundle.getMessage(NbProblemDisplayer.class, "MSG_problem_java_too_old", dep.getVersion(), Dependency.JAVA_SPEC);
                }
                return dep.toString();
            }
        }
        throw new IllegalArgumentException(dep.toString());
    }

    private static String label(Module m, boolean localized) {
        if (localized) {
            return m.getDisplayName();
        }
        return m.getCodeNameBase();
    }

    static void problemMessagesForModules(final Appendable writeTo, Collection<? extends Module> modules, final boolean justRootCause) {
        try {
            HashSet<String> names = new HashSet<String>();
            for (Module module : modules) {
                names.add(module.getCodeName());
            }
            HashSet<String> dependentModules = new HashSet<String>();
            class Report {
                final Module m;
                final List<Object> problems = new ArrayList<Object>();

                Report(Module m) {
                    this.m = m;
                }

                void write() throws IOException {
                    for (Object problem : this.problems) {
                        writeTo.append("\n\t").append(NbProblemDisplayer.label(this.m, justRootCause) + " - " + NbProblemDisplayer.messageForProblem(this.m, problem, justRootCause));
                    }
                }
            }
            HashMap<Module, Report> hashMap = new HashMap<Module, Report>();
            HashMap<Module, Set<Module>> edges = new HashMap<Module, Set<Module>>();
            for (Module module : modules) {
                Set<Object> problems = module.getProblems();
                if (problems.isEmpty()) {
                    throw new IllegalStateException("Module " + module + " could not be installed but had no problems");
                }
                Report r = new Report(module);
                for (Object problem : problems) {
                    Dependency d;
                    if (problem instanceof Dependency && justRootCause && (d = (Dependency)problem).getType() == 1 && names.contains(d.getName())) {
                        dependentModules.add(module.getCodeName());
                        continue;
                    }
                    r.problems.add(problem);
                }
                hashMap.put(module, r);
                edges.put(module, module.getManager().getModuleInterdependencies(module, true, false, false));
            }
            try {
                for (Module module : Utilities.topologicalSort(edges.keySet(), edges)) {
                    ((Report)hashMap.get(module)).write();
                }
            }
            catch (TopologicalSortException x) {
                for (Report r : hashMap.values()) {
                    r.write();
                }
            }
            if (!dependentModules.isEmpty()) {
                writeTo.append("\n\t").append(NbBundle.getMessage(NbProblemDisplayer.class, "MSG_also_dep_modules", dependentModules.size()));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

