/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.Main;
import org.openide.util.Exceptions;

final class TopThreadGroup
extends ThreadGroup
implements Runnable {
    private String[] args;
    private boolean finished;

    public TopThreadGroup(String name, String[] args) {
        super(name);
        this.args = args;
    }

    public TopThreadGroup(ThreadGroup parent, String name) {
        super(parent, name);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (!(e instanceof ThreadDeath)) {
            Thread.UncaughtExceptionHandler h = Thread.getDefaultUncaughtExceptionHandler();
            if (h != null) {
                h.uncaughtException(t, e);
                return;
            }
            if (e instanceof VirtualMachineError) {
                e.printStackTrace();
            }
            System.err.flush();
            Exceptions.printStackTrace(e);
        } else {
            super.uncaughtException(t, e);
        }
    }

    public synchronized void start() throws InterruptedException {
        Thread t = new Thread(this, this, "main");
        t.start();
        while (!this.finished) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Main.start(this.args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException x) {
                Exceptions.printStackTrace(x);
            }
            TopSecurityManager.exit(2);
        }
        finally {
            TopThreadGroup topThreadGroup = this;
            synchronized (topThreadGroup) {
                this.finished = true;
                this.notify();
            }
        }
    }
}

