/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;

public class ArchiveURLMapper
extends URLMapper {
    private static final Logger LOG = Logger.getLogger(ArchiveURLMapper.class.getName());
    private static final String JAR_PROTOCOL = "jar";
    private static final Map<File, SoftReference<JarFileSystem>> mountRoots = new ConcurrentHashMap<File, SoftReference<JarFileSystem>>();
    private static final Map<URI, File> copiedJARs = new HashMap<URI, File>();

    @Override
    public URL getURL(FileObject fo, int type) {
        assert (fo != null);
        if ((type == 1 || type == 0) && fo.isValid()) {
            File archiveFile = null;
            try {
                JarFileSystem jfs;
                FileSystem fs = fo.getFileSystem();
                if (fs instanceof JarFileSystem && ArchiveURLMapper.isRoot(archiveFile = (jfs = (JarFileSystem)fs).getJarFile())) {
                    try {
                        return new URL("jar:" + BaseUtilities.toURI(archiveFile) + "!/" + new URI(null, fo.getPath(), null).getRawSchemeSpecificPart() + (fo.isFolder() && !fo.isRoot() ? "/" : ""));
                    }
                    catch (URISyntaxException syntax) {
                        String path = new URI(null, fo.getPath(), null).toString();
                        return new URL("jar:" + BaseUtilities.toURI(archiveFile) + "!/" + path + (fo.isFolder() && !fo.isRoot() ? "/" : ""));
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "fo: " + fo + " archiveFile: " + archiveFile, e);
            }
        }
        return null;
    }

    @Override
    public FileObject[] getFileObjects(URL url) {
        String path;
        int index;
        assert (url != null);
        String protocol = url.getProtocol();
        if (JAR_PROTOCOL.equals(protocol) && (index = (path = url.getPath()).lastIndexOf(33)) >= 0) {
            try {
                URL archiveFileURL;
                URI archiveFileURI = new URI(path.substring(0, index));
                try {
                    archiveFileURL = archiveFileURI.toURL();
                }
                catch (IllegalArgumentException x) {
                    LOG.log(Level.INFO, "checking " + archiveFileURI, x);
                    return null;
                }
                FileObject fo = URLMapper.findFileObject(archiveFileURL);
                if (fo == null || fo.isVirtual()) {
                    return null;
                }
                File archiveFile = FileUtil.toFile(fo);
                if (archiveFile == null) {
                    archiveFile = ArchiveURLMapper.copyJAR(fo, archiveFileURI, false);
                }
                String offset = path.length() > index + 2 ? URLDecoder.decode(path.substring(index + 2), "UTF-8") : "";
                JarFileSystem fs = ArchiveURLMapper.getFileSystem(archiveFile);
                FileObject resource = fs.findResource(offset);
                if (resource != null) {
                    return new FileObject[]{resource};
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "checking " + url, e);
            }
            catch (URISyntaxException e) {
                LOG.log(Level.INFO, "Can't get fo for " + url, e);
            }
        }
        return null;
    }

    private static boolean isRoot(File file) {
        return mountRoots.containsKey(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarFileSystem getFileSystem(File file) throws IOException {
        Map<File, SoftReference<JarFileSystem>> map = mountRoots;
        synchronized (map) {
            Reference reference = mountRoots.get(file);
            JarFileSystem jfs = null;
            if (reference == null || (jfs = (JarFileSystem)reference.get()) == null) {
                jfs = ArchiveURLMapper.findJarFileSystemInRepository(file);
                if (jfs == null) {
                    File aRoot = FileUtil.normalizeFile(file);
                    jfs = new JarFileSystem(aRoot);
                }
                mountRoots.put(file, new JFSReference(jfs));
            }
            return jfs;
        }
    }

    private static JarFileSystem findJarFileSystemInRepository(File jarFile) {
        Enumeration<? extends FileSystem> en = Repository.getDefault().getFileSystems();
        while (en.hasMoreElements()) {
            JarFileSystem jfs;
            FileSystem fs = en.nextElement();
            if (!(fs instanceof JarFileSystem) || !jarFile.equals((jfs = (JarFileSystem)fs).getJarFile())) continue;
            return jfs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyJAR(FileObject fo, URI archiveFileURI, boolean replace) throws IOException {
        Map<URI, File> map = copiedJARs;
        synchronized (map) {
            File copy = copiedJARs.get(archiveFileURI);
            if (copy == null || replace) {
                if (copy == null) {
                    copy = File.createTempFile("copy", "-" + archiveFileURI.toString().replaceFirst(".+/", ""));
                    copy = copy.getCanonicalFile();
                    copy.deleteOnExit();
                }
                InputStream is = fo.getInputStream();
                try {
                    FileOutputStream os = new FileOutputStream(copy);
                    try {
                        FileUtil.copy(is, os);
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    is.close();
                }
                copiedJARs.put(archiveFileURI, copy);
            }
            return copy;
        }
    }

    private static class JFSReference
    extends SoftReference<JarFileSystem> {
        private FileChangeListener fcl;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JFSReference(JarFileSystem jfs) throws IOException {
            super(jfs);
            final File root = jfs.getJarFile();
            URI nestedRootURI = null;
            FileObject rootFo = null;
            Map map = copiedJARs;
            synchronized (map) {
                if (copiedJARs.values().contains(root)) {
                    for (Map.Entry entry : copiedJARs.entrySet()) {
                        if (!((File)entry.getValue()).equals(root)) continue;
                        nestedRootURI = (URI)entry.getKey();
                        rootFo = URLMapper.findFileObject(nestedRootURI.toURL());
                    }
                } else {
                    rootFo = FileUtil.toFileObject(root);
                }
            }
            final URI nestedRootURIFinal = nestedRootURI;
            if (rootFo != null) {
                this.fcl = new FileChangeAdapter(){

                    @Override
                    public void fileDeleted(FileEvent fe) {
                        JFSReference.this.releaseMe(root);
                    }

                    @Override
                    public void fileRenamed(FileRenameEvent fe) {
                        JFSReference.this.releaseMe(root);
                    }

                    @Override
                    public void fileChanged(FileEvent fe) {
                        if (nestedRootURIFinal != null) {
                            try {
                                ArchiveURLMapper.copyJAR(fe.getFile(), nestedRootURIFinal, true);
                                JFSReference.this.releaseMe(root);
                                ArchiveURLMapper.getFileSystem(root);
                            }
                            catch (IOException e) {
                                LOG.log(Level.INFO, "Can't copy JAR " + fe.getFile() + " to " + nestedRootURIFinal, e);
                            }
                        }
                    }
                };
                rootFo.addFileChangeListener(FileUtil.weakFileChangeListener(this.fcl, rootFo));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseMe(File root) {
            JarFileSystem jfs = (JarFileSystem)this.get();
            if (jfs != null) {
                Map map = mountRoots;
                synchronized (map) {
                    File keyToRemove = root != null ? root : jfs.getJarFile();
                    mountRoots.remove(keyToRemove);
                }
            }
        }
    }
}

