/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.NbRepository;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.base.LayerFactory;
import org.netbeans.core.startup.impl.BinaryLayerFactoryProvider;
import org.netbeans.core.startup.layers.BinaryCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.NbBundle;

public abstract class LayerCacheManager
implements LayerFactory {
    static final Logger err = Logger.getLogger("org.netbeans.core.projects.cache");
    private static final LayerCacheManager mgr = new BinaryCacheManager();
    private static final LayerCacheManager non = new NonCacheManager();

    public static LayerCacheManager manager(boolean real) {
        return real ? mgr : non;
    }

    public static LayerCacheManager create(String cacheLocation) {
        return new BinaryCacheManager(cacheLocation);
    }

    @Override
    public final FileSystem loadCache() throws IOException {
        FileSystem fs;
        block4: {
            String location = this.cacheLocation();
            fs = null;
            if (location != null) {
                Main.setStatusText(NbBundle.getMessage(BinaryLayerFactoryProvider.class, "MSG_start_load_cache"));
                MappedByteBuffer bb = Stamps.getModulesJARs().asMappedByteBuffer(location);
                if (bb != null) {
                    try {
                        StartLog.logStart("Loading layers");
                        fs = this.load(this.createEmptyFileSystem(), bb);
                        Main.setStatusText(NbBundle.getMessage(BinaryLayerFactoryProvider.class, "MSG_end_load_cache"));
                        StartLog.logEnd("Loading layers");
                    }
                    catch (IOException ex) {
                        err.log(Level.WARNING, "Ignoring cache of layers");
                        if (!err.isLoggable(Level.FINE)) break block4;
                        err.log(Level.WARNING, "Ignoring cache of layers", ex);
                    }
                }
            }
        }
        return fs;
    }

    @Override
    public final FileSystem store(final FileSystem fs, final List<URL> urls) throws IOException {
        class Updater
        implements FileSystem.AtomicAction,
        Stamps.Updater {
            private FileSystem toRet;
            private byte[] data;

            Updater() {
            }

            @Override
            public void flushCaches(DataOutputStream os) throws IOException {
                err.log(Level.FINEST, "flushing layers");
                os.write(this.data);
                err.log(Level.FINEST, "layers flushed");
            }

            @Override
            public void cacheReady() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws IOException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                LayerCacheManager layerCacheManager = LayerCacheManager.this;
                synchronized (layerCacheManager) {
                    try {
                        err.log(Level.FINEST, "storing to memory {0}", urls);
                        LayerCacheManager.this.store(fs, urls, os);
                        this.data = os.toByteArray();
                        ByteBuffer bb = ByteBuffer.wrap(this.data);
                        err.log(Level.FINEST, "reading from memory, size {0}", bb.limit());
                        this.toRet = LayerCacheManager.this.load(fs, bb.order(ByteOrder.LITTLE_ENDIAN));
                    }
                    catch (IOException ioe) {
                        err.log(Level.WARNING, null, ioe);
                        XMLFileSystem fallback = new XMLFileSystem();
                        try {
                            fallback.setXmlUrls(urls.toArray(new URL[urls.size()]));
                        }
                        catch (PropertyVetoException ex) {
                            err.log(Level.WARNING, null, ex);
                        }
                        this.toRet = fallback;
                    }
                }
                Stamps.getModulesJARs().scheduleSave(this, LayerCacheManager.this.cacheLocation(), false);
            }
        }
        Updater u = new Updater();
        FileUtil.runAtomicAction(u);
        return u.toRet;
    }

    @Override
    public List<URL> additionalLayers(List<URL> urls) {
        return ((NbRepository)NbRepository.getDefault()).additionalLayers(urls);
    }

    LayerCacheManager() {
    }

    @Override
    public abstract FileSystem createEmptyFileSystem() throws IOException;

    public abstract FileSystem load(FileSystem var1, ByteBuffer var2) throws IOException;

    public abstract void store(FileSystem var1, List<URL> var2, OutputStream var3) throws IOException;

    abstract String cacheLocation();

    private static final class NonCacheManager
    extends LayerCacheManager {
        private NonCacheManager() {
        }

        @Override
        public FileSystem createEmptyFileSystem() throws IOException {
            return new XMLFileSystem();
        }

        @Override
        public FileSystem load(FileSystem previous, ByteBuffer bb) throws IOException {
            byte[] arr = new byte[bb.limit()];
            bb.get(arr);
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(arr));
            ArrayList<URL> urls = new ArrayList<URL>();
            while (is.available() > 0) {
                String u = is.readUTF();
                urls.add(new URL(u));
            }
            try {
                XMLFileSystem fs = (XMLFileSystem)previous;
                fs.setXmlUrls(urls.toArray(new URL[urls.size()]));
                return fs;
            }
            catch (PropertyVetoException pve) {
                throw (IOException)new IOException(pve.toString()).initCause(pve);
            }
        }

        @Override
        public void store(FileSystem fs, List<URL> urls, OutputStream os) throws IOException {
            DataOutputStream data = new DataOutputStream(os);
            for (URL u : urls) {
                data.writeUTF(u.toExternalForm());
            }
            data.close();
        }

        @Override
        public String cacheLocation() {
            return "all-local-layers.dat";
        }
    }
}

