/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.logging.NbLogging;
import org.openide.util.RequestProcessor;

public final class PrintStreamLogger
extends PrintStream
implements Runnable {
    private Logger log;
    private final StringBuilder sb = new StringBuilder();
    private static RequestProcessor RP = new RequestProcessor("StdErr Flush");
    private RequestProcessor.Task flush = RP.create(this, true);

    private PrintStreamLogger(Logger log) {
        super(new ByteArrayOutputStream());
        this.log = log;
    }

    public static boolean isLogger(PrintStream ps) {
        return ps.getClass().getName().equals(PrintStreamLogger.class.getName());
    }

    public static PrintStream create(String loggerName) {
        return new PrintStreamLogger(Logger.getLogger(loggerName));
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (RP.isRequestProcessorThread()) {
            return;
        }
        String s = new String(buf, off, len);
        this.print(s);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        if (RP.isRequestProcessorThread()) {
            return;
        }
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            this.sb.append((char)b);
        }
        this.checkFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String s) {
        if (NbLogging.DEBUG != null && !NbLogging.wantsMessage(s)) {
            new Exception().printStackTrace(NbLogging.DEBUG);
        }
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            this.sb.append(s);
        }
        this.checkFlush();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.print(System.getProperty("line.separator"));
    }

    @Override
    public void println(Object x) {
        String s = String.valueOf(x);
        this.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        boolean empty;
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            empty = this.sb.length() == 0;
        }
        if (!empty) {
            try {
                this.flush.schedule(0);
                this.flush.waitFinished(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.flush();
    }

    private void checkFlush() {
        try {
            this.flush.schedule(100);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block3: while (true) {
            String toLog;
            StringBuilder stringBuilder = this.sb;
            synchronized (stringBuilder) {
                if (this.sb.length() == 0) {
                    break;
                }
                int last = -1;
                for (int i = this.sb.length() - 1; i >= 0; --i) {
                    if (this.sb.charAt(i) != '\n') continue;
                    last = i;
                    break;
                }
                if (last == -1) {
                    break;
                }
                toLog = this.sb.substring(0, last + 1);
                this.sb.delete(0, last + 1);
            }
            int begLine = 0;
            while (true) {
                if (begLine >= toLog.length()) continue block3;
                int endLine = toLog.indexOf(10, begLine);
                this.log.log(Level.INFO, toLog.substring(begLine, endLine + 1));
                begLine = endLine + 1;
            }
            break;
        }
    }
}

