/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.intent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.netbeans.api.intent.Intent;
import org.netbeans.spi.intent.Result;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class IntentHandler
implements Comparable<IntentHandler> {
    public static final RequestProcessor RP = new RequestProcessor(IntentHandler.class);
    private static final Result IGNORING_RESULT = new Result(){

        @Override
        public void setResult(Object result) {
        }

        @Override
        public void setException(Exception exception) {
        }
    };
    private final String className;
    private final String methodName;
    private final String displayName;
    private final String icon;
    private final Type type;
    private final int position;

    @Override
    public int compareTo(IntentHandler o) {
        return this.getPosition() - o.getPosition();
    }

    public static IntentHandler create(FileObject fo) {
        String n = fo.getName();
        int lastDash = n.lastIndexOf(45);
        if (lastDash <= 0 || lastDash + 1 >= n.length()) {
            throw new IllegalArgumentException("Invalid handler file");
        }
        String className = n.substring(0, lastDash).replace('-', '.');
        String methodName = n.substring(lastDash + 1);
        String displayName = (String)fo.getAttribute("displayName");
        String icon = (String)fo.getAttribute("icon");
        int position = (Integer)fo.getAttribute("position");
        Type type = Type.valueOf((String)fo.getAttribute("type"));
        return new IntentHandler(className, methodName, displayName, icon, type, position);
    }

    private IntentHandler(String className, String methodName, String displayName, String icon, Type type, int position) {
        this.className = className;
        this.methodName = methodName;
        this.displayName = displayName;
        this.icon = icon;
        this.type = type;
        this.position = position;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isSetBack() {
        return this.type == Type.SETBACK;
    }

    public void handle(Intent intent, Result resultOrNull) {
        Result result = resultOrNull == null ? IGNORING_RESULT : resultOrNull;
        ClassLoader cls = Lookup.getDefault().lookup(ClassLoader.class);
        if (cls == null) {
            throw new IllegalStateException("Classloader not found");
        }
        try {
            Class<?> c = Class.forName(this.className, true, cls);
            if (this.isSetBack()) {
                Method m = c.getDeclaredMethod(this.methodName, Intent.class, Result.class);
                m.invoke(null, intent, result);
            } else {
                Method m = c.getDeclaredMethod(this.methodName, Intent.class);
                Object res = m.invoke(null, intent);
                result.setResult(res);
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                result.setException((Exception)cause);
            } else {
                result.setException(new Exception(cause));
            }
        }
        catch (ReflectiveOperationException e) {
            result.setException(e);
        }
    }

    private static enum Type {
        RETURN,
        SETBACK;

    }
}

