/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.intent;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.intent.Intent;
import org.netbeans.modules.intent.IntentHandler;
import org.netbeans.spi.intent.IntentHandlerRegistration;
import org.netbeans.spi.intent.Result;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"org.netbeans.spi.intent.IntentHandlerRegistration"})
public class OpenUriHandlerProcessor
extends LayerGeneratingProcessor {
    private static final String SUFFIX = ".instance";

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        for (Element element : roundEnv.getElementsAnnotatedWith(IntentHandlerRegistration.class)) {
            IntentHandlerRegistration r = element.getAnnotation(IntentHandlerRegistration.class);
            this.registerHandler(element, r);
        }
        return true;
    }

    private void registerHandler(Element e, IntentHandlerRegistration r) throws LayerGenerationException {
        String type;
        TypeElement intentTypeElement = this.getTypeElement(Intent.class);
        TypeElement objectTypeElement = this.getTypeElement(Object.class);
        TypeElement resultTypeElement = this.getTypeElement(Result.class);
        if (!ElementKind.METHOD.equals((Object)e.getKind())) {
            throw this.error(e, "The annotation can be applied only to a method.");
        }
        if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
            throw this.error(e, "The annotated method must be static.");
        }
        if (!(e instanceof ExecutableElement)) {
            throw this.error(e, "Annotated element must be an ExecutableElement");
        }
        ExecutableElement ee = (ExecutableElement)e;
        if (ee.getParameters().size() == 1 && this.hasParameter(ee, 0, intentTypeElement) && this.hasResultType(ee, objectTypeElement)) {
            type = "RETURN";
        } else if (ee.getParameters().size() == 2 && this.hasParameter(ee, 0, intentTypeElement) && this.hasParameter(ee, 1, resultTypeElement) && this.hasVoidResultType(ee)) {
            type = "SETBACK";
        } else {
            throw this.error(e, "The handler method must take a single argument of type org.netbeans.api.intent.Intent and return Object; or take two arguments of typesorg.netbeans.api.intent.Intentand org.netbeans.spi.intent.Result and return void.");
        }
        boolean takeAll = false;
        boolean empty = true;
        StringBuilder sb = new StringBuilder();
        for (String action : r.actions()) {
            if ("*".equals(action)) {
                takeAll = true;
                break;
            }
            if (!empty) {
                sb.append(',');
            }
            sb.append(action);
            empty = false;
        }
        String actions2 = takeAll ? "*" : sb.toString();
        LayerBuilder b = this.layer(e);
        LayerBuilder.File f = b.file("Services/Intent/Handlers/" + this.getName(e).replace('.', '-') + SUFFIX);
        f.position(r.position());
        f.stringvalue("instanceClass", IntentHandler.class.getCanonicalName());
        f.methodvalue("instanceCreate", IntentHandler.class.getCanonicalName(), "create");
        f.bundlevalue("displayName", r.displayName());
        f.stringvalue("uriPattern", r.uriPattern());
        f.stringvalue("icon", r.icon());
        f.stringvalue("type", type);
        f.stringvalue("actions", actions2);
        f.write();
    }

    private String getName(Element e) {
        if (e.getKind().isClass() || e.getKind().isInterface()) {
            return this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
        }
        if (e.getKind() == ElementKind.PACKAGE) {
            return e.getSimpleName().toString();
        }
        return this.getName(e.getEnclosingElement()) + '.' + e.getSimpleName();
    }

    private boolean hasParameter(ExecutableElement ee, int pos, Element typeElement) {
        return this.processingEnv.getTypeUtils().asElement(ee.getParameters().get(pos).asType()).equals(typeElement);
    }

    private boolean hasVoidResultType(ExecutableElement ee) {
        TypeMirror returnType2 = ee.getReturnType();
        Element returnTypeElement = this.processingEnv.getTypeUtils().asElement(returnType2);
        return returnTypeElement == null;
    }

    private boolean hasResultType(ExecutableElement ee, Element typeElement) {
        TypeMirror returnType2 = ee.getReturnType();
        Element returnTypeElement = this.processingEnv.getTypeUtils().asElement(returnType2);
        return returnTypeElement.equals(typeElement);
    }

    private TypeElement getTypeElement(Class<?> cls) {
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(cls.getCanonicalName());
        return typeElement;
    }

    private IllegalArgumentException error(Element e, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getEnclosingElement().toString());
        sb.append(".");
        sb.append(e.getSimpleName());
        sb.append(":");
        sb.append(System.lineSeparator());
        sb.append(msg);
        return new IllegalArgumentException(sb.toString());
    }
}

