/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public class GlobalVisibilityQueryImpl
implements VisibilityQueryImplementation2 {
    private final ChangeSupport cs = new ChangeSupport(this);
    private static final String PROP_IGNORED_FILES = "IgnoredFiles";
    private static final String PROP_IGNORE_HIDDEN_FILES_IN_USER_HOME = "IgnoreHiddenFilesInUserHome";
    private Pattern ignoreFilesPattern = null;
    private boolean ignoreHiddenInHome = true;
    private boolean ignoreHiddenInHomeInitialized = false;
    private FileObject home = null;
    private String homePath = null;
    private boolean homeInitialized = false;
    private PreferenceChangeListener preferencesListener = null;

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/core");
    }

    @Override
    public boolean isVisible(FileObject file) {
        String name = file.getNameExt();
        if (this.isIgnoreHiddenInHome() && this.isHidden(name) && this.isInHomeFolder(file)) {
            return false;
        }
        return this.isVisible(name);
    }

    @Override
    public boolean isVisible(File file) {
        String name = file.getName();
        if (this.isIgnoreHiddenInHome() && this.isHidden(name) && this.isInHomeFolder(file)) {
            return false;
        }
        return this.isVisible(name);
    }

    boolean isVisible(String fileName) {
        Pattern pattern = this.getIgnoreFilesPattern();
        return pattern != null ? !pattern.matcher(fileName).find() : true;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private boolean isIgnoreHiddenInHome() {
        if (!this.ignoreHiddenInHomeInitialized) {
            this.ignoreHiddenInHome = GlobalVisibilityQueryImpl.getPreferences().getBoolean(PROP_IGNORE_HIDDEN_FILES_IN_USER_HOME, true);
            this.ignoreHiddenInHomeInitialized = true;
        }
        return this.ignoreHiddenInHome;
    }

    private Pattern getIgnoreFilesPattern() {
        if (this.ignoreFilesPattern == null) {
            String ignoredFiles = this.getIgnoredFiles();
            this.ignoreFilesPattern = ignoredFiles != null && ignoredFiles.length() > 0 ? Pattern.compile(ignoredFiles) : null;
        }
        return this.ignoreFilesPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getIgnoredFiles() {
        PreferenceChangeListener listenerToAdd;
        String retval = GlobalVisibilityQueryImpl.getPreferences().get(PROP_IGNORED_FILES, "^(CVS|SCCS|vssver.?\\.scc|#.*#|%.*%|_svn)$|~$|^\\.(git|hg|svn|cache|DS_Store)$|^Thumbs.db$");
        GlobalVisibilityQueryImpl globalVisibilityQueryImpl = this;
        synchronized (globalVisibilityQueryImpl) {
            listenerToAdd = this.preferencesListener == null ? (this.preferencesListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    if (GlobalVisibilityQueryImpl.PROP_IGNORED_FILES.equals(evt.getKey())) {
                        GlobalVisibilityQueryImpl.this.ignoreFilesPattern = null;
                        GlobalVisibilityQueryImpl.this.cs.fireChange();
                    } else if (GlobalVisibilityQueryImpl.PROP_IGNORE_HIDDEN_FILES_IN_USER_HOME.equals(evt.getKey())) {
                        GlobalVisibilityQueryImpl.this.ignoreHiddenInHomeInitialized = false;
                        GlobalVisibilityQueryImpl.this.cs.fireChange();
                    }
                }
            }) : null;
        }
        if (listenerToAdd != null) {
            GlobalVisibilityQueryImpl.getPreferences().addPreferenceChangeListener(listenerToAdd);
        }
        return retval;
    }

    private boolean isHidden(String fileName) {
        return fileName.startsWith(".");
    }

    private boolean isInHomeFolder(FileObject fo) {
        FileObject parent;
        if (!this.homeInitialized) {
            this.initializeHome();
        }
        return (parent = fo.getParent()) != null && parent == this.home;
    }

    private boolean isInHomeFolder(File f) {
        String parentPath;
        if (!this.homeInitialized) {
            this.initializeHome();
        }
        return (parentPath = f.getParent()) != null && parentPath.equals(this.homePath);
    }

    private void initializeHome() {
        String homeRaw = System.getProperty("user.home");
        if (homeRaw != null) {
            this.homePath = FileUtil.normalizePath(homeRaw);
            this.home = FileUtil.toFileObject(new File(this.homePath));
        }
        this.homeInitialized = true;
    }
}

