/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.nodes;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.tools.Diagnostic;
import org.netbeans.modules.openide.nodes.NodesRegistrationSupport;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.nodes.BeanInfoSearchPath;
import org.openide.nodes.PropertyEditorRegistration;
import org.openide.nodes.PropertyEditorSearchPath;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class NodesAnnotationProcessor
extends LayerGeneratingProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(PropertyEditorSearchPath.class.getName());
        set.add(PropertyEditorRegistration.class.getName());
        set.add(BeanInfoSearchPath.class.getName());
        return set;
    }

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        Object file;
        LayerBuilder builder;
        String pkgFilename;
        String pkg;
        Messager messager = this.processingEnv.getMessager();
        for (Element element : roundEnv.getElementsAnnotatedWith(PropertyEditorSearchPath.class)) {
            pkg = this.findPackage(element);
            pkgFilename = pkg.replace(".", "-");
            builder = this.layer(element);
            file = builder.file("Services/PropertyEditorManager/Package-" + pkgFilename + ".instance");
            ((LayerBuilder.File)file).methodvalue("instanceCreate", NodesRegistrationSupport.class.getName(), "createPackageRegistration");
            ((LayerBuilder.File)file).stringvalue("packagePath", pkg);
            ((LayerBuilder.File)file).stringvalue("instanceOf", NodesRegistrationSupport.PEPackageRegistration.class.getName());
            ((LayerBuilder.File)file).write();
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(PropertyEditorRegistration.class)) {
            if (element.getKind() != ElementKind.CLASS) continue;
            String className = ((TypeElement)element).getQualifiedName().toString();
            Collection targetTypes = null;
            List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!"targetType".equals(entry.getKey().getSimpleName().toString())) continue;
                    targetTypes = (Collection)entry.getValue().getValue();
                }
            }
            if (targetTypes == null) {
                messager.printMessage(Diagnostic.Kind.ERROR, "No targetType is specified", element);
                continue;
            }
            TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement("java.beans.PropertyEditor");
            if (!this.processingEnv.getTypeUtils().isSubtype(element.asType(), typeElement.asType())) {
                messager.printMessage(Diagnostic.Kind.ERROR, className + " is not subtype of PropertyEditor", element);
                continue;
            }
            LayerBuilder layerBuilder = this.layer(element);
            String clsFileName = className.replace(".", "-");
            LayerBuilder.File file2 = layerBuilder.instanceFile("Services/PropertyEditorManager", "Class-" + clsFileName);
            file2.methodvalue("instanceCreate", NodesRegistrationSupport.class.getName(), "createClassRegistration");
            file2.stringvalue("propertyEditorClass", className);
            file2.stringvalue("instanceOf", NodesRegistrationSupport.PEClassRegistration.class.getName());
            int i = 1;
            for (AnnotationValue type : targetTypes) {
                String clsName = type.accept(new SimpleAnnotationValueVisitor6<String, Object>(){

                    @Override
                    public String visitType(TypeMirror t, Object p) {
                        return t.toString();
                    }
                }, null);
                file2.stringvalue("targetType." + i, clsName);
                ++i;
            }
            file2.write();
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BeanInfoSearchPath.class)) {
            pkg = this.findPackage(element);
            pkgFilename = pkg.replace(".", "-");
            builder = this.layer(element);
            file = builder.file("Services/Introspector/BeanInfo-" + pkgFilename + ".instance");
            ((LayerBuilder.File)file).methodvalue("instanceCreate", NodesRegistrationSupport.class.getName(), "createBeanInfoRegistration");
            ((LayerBuilder.File)file).stringvalue("packagePath", pkg);
            ((LayerBuilder.File)file).stringvalue("instanceOf", NodesRegistrationSupport.BeanInfoRegistration.class.getName());
            ((LayerBuilder.File)file).write();
        }
        return true;
    }

    private String findPackage(Element e) {
        switch (e.getKind()) {
            case PACKAGE: {
                return ((PackageElement)e).getQualifiedName().toString();
            }
        }
        return this.findPackage(e.getEnclosingElement());
    }
}

