/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.openide.util.BaseUtilities;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Union2;
import org.openide.util.spi.MutexEventProvider;
import org.openide.util.spi.MutexImplementation;

public class NbMutexEventProvider
implements MutexEventProvider {
    @Override
    public MutexImplementation createMutex() {
        return new Event();
    }

    private static final class Event
    implements MutexImplementation {
        private Event() {
        }

        @Override
        public boolean isReadAccess() {
            return SwingUtilities.isEventDispatchThread();
        }

        @Override
        public boolean isWriteAccess() {
            return SwingUtilities.isEventDispatchThread();
        }

        @Override
        public void writeAccess(Runnable runnable) {
            Event.doEvent(runnable);
        }

        @Override
        public <T> T writeAccess(Mutex.ExceptionAction<T> action) throws MutexException {
            return Event.doEventAccess(action);
        }

        @Override
        public void readAccess(Runnable runnable) {
            Event.doEvent(runnable);
        }

        @Override
        public <T> T readAccess(Mutex.ExceptionAction<T> action) throws MutexException {
            return Event.doEventAccess(action);
        }

        @Override
        public void postReadRequest(Runnable run) {
            Event.doEventRequest(run);
        }

        @Override
        public void postWriteRequest(Runnable run) {
            Event.doEventRequest(run);
        }

        public String toString() {
            return "EVENT - Full JRE";
        }

        private static void doEvent(Runnable run) {
            if (EventQueue.isDispatchThread()) {
                run.run();
            } else {
                EventQueue.invokeLater(run);
            }
        }

        private static void doEventRequest(Runnable run) {
            EventQueue.invokeLater(run);
        }

        private static <T> T doEventAccess(final Mutex.ExceptionAction<T> run) throws MutexException {
            if (Event.isDispatchThread()) {
                try {
                    return run.run();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MutexException(e);
                }
            }
            final AtomicReference res = new AtomicReference();
            final AtomicBoolean started = new AtomicBoolean();
            final AtomicBoolean finished = new AtomicBoolean();
            AtomicBoolean invoked = new AtomicBoolean();
            try {
                class AWTWorker
                implements Runnable {
                    AWTWorker() {
                    }

                    @Override
                    public void run() {
                        started.set(true);
                        try {
                            res.set(Union2.createFirst(run.run()));
                        }
                        catch (Exception e) {
                            res.set(Union2.createSecond(e));
                        }
                        catch (LinkageError e) {
                            res.set(Union2.createSecond(e));
                        }
                        catch (StackOverflowError e) {
                            res.set(Union2.createSecond(e));
                        }
                        finished.set(true);
                    }
                }
                AWTWorker w = new AWTWorker();
                EventQueue.invokeAndWait(w);
                invoked.set(true);
            }
            catch (InterruptedException e) {
                res.set(Union2.createSecond(e));
            }
            catch (InvocationTargetException e) {
                res.set(Union2.createSecond(e));
            }
            Union2 _res = (Union2)res.get();
            if (_res == null) {
                throw new IllegalStateException("#210991: got neither a result nor an exception; started=" + started + " finished=" + finished + " invoked=" + invoked);
            }
            if (_res.hasFirst()) {
                return (T)_res.first();
            }
            Throwable e = (Throwable)_res.second();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw Event.notifyException(e);
        }

        private static boolean isDispatchThread() {
            boolean dispatch = EventQueue.isDispatchThread();
            if (!dispatch && BaseUtilities.getOperatingSystem() == 8) {
                dispatch = Thread.currentThread().getClass().getName().indexOf("EventDispatchThread") >= 0;
            }
            return dispatch;
        }

        private static MutexException notifyException(Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = Event.unfoldInvocationTargetException((InvocationTargetException)t);
            }
            if (t instanceof Error) {
                Event.annotateEventStack(t);
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                Event.annotateEventStack(t);
                throw (RuntimeException)t;
            }
            MutexException exc = new MutexException((Exception)t);
            exc.initCause(t);
            return exc;
        }

        private static void annotateEventStack(Throwable t) {
        }

        private static Throwable unfoldInvocationTargetException(InvocationTargetException e) {
            Throwable ret;
            while ((e = (ret = e.getTargetException()) instanceof InvocationTargetException ? (InvocationTargetException)ret : null) != null) {
            }
            return ret;
        }
    }
}

