/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.templates;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.netbeans.api.templates.TemplateRegistration;
import org.netbeans.api.templates.TemplateRegistrations;
import org.netbeans.modules.templates.HTMLWizard;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class TemplateProcessor
extends LayerGeneratingProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(TemplateRegistration.class.getCanonicalName(), TemplateRegistrations.class.getCanonicalName()));
    }

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        if (roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(TemplateRegistration.class)) {
            TemplateRegistration r = element.getAnnotation(TemplateRegistration.class);
            if (r == null) continue;
            this.process(element, r);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(TemplateRegistrations.class)) {
            TemplateRegistrations rr = element.getAnnotation(TemplateRegistrations.class);
            if (rr == null) continue;
            for (TemplateRegistration t : rr.value()) {
                this.process(element, t);
            }
        }
        return true;
    }

    private void process(Element e, TemplateRegistration t) throws LayerGenerationException {
        String basename;
        LayerBuilder builder = this.layer(e);
        if (!t.id().isEmpty()) {
            if (t.content().length > 0) {
                throw new LayerGenerationException("Cannot specify both id and content", e, this.processingEnv, t);
            }
            basename = t.id();
        } else if (t.content().length > 0) {
            basename = TemplateProcessor.basename(t.content()[0]);
        } else if (e.getKind() == ElementKind.CLASS) {
            basename = ((TypeElement)e).getQualifiedName().toString().replace('.', '-');
        } else if (e.getKind() == ElementKind.METHOD) {
            basename = ((TypeElement)e.getEnclosingElement()).getQualifiedName().toString().replace('.', '-') + '-' + e.getSimpleName();
        } else {
            throw new LayerGenerationException("cannot use @Template on a package without specifying content", e, this.processingEnv, t);
        }
        String folder = "Templates/" + t.folder() + '/';
        LayerBuilder.File f = builder.file(folder + basename);
        f.boolvalue("template", true);
        f.position(t.position());
        if (!t.displayName().isEmpty()) {
            f.bundlevalue("displayName", t.displayName());
        }
        if (!t.iconBase().isEmpty()) {
            builder.validateResource(t.iconBase(), e, t, "iconBase", true);
            f.stringvalue("iconBase", t.iconBase());
        } else if (t.content().length == 0) {
            throw new LayerGenerationException("Must specify iconBase if content is not specified", e, this.processingEnv, t);
        }
        if (!t.description().isEmpty()) {
            f.urlvalue("instantiatingWizardURL", this.contentURI(e, t.description(), builder, t, "description"));
        }
        if (e.getKind() != ElementKind.PACKAGE) {
            if (t.page().isEmpty()) {
                try {
                    Class<?> iterClazz = Class.forName("org.openide.WizardDescriptor$InstantiatingIterator");
                    f.instanceAttribute("instantiatingIterator", iterClazz);
                }
                catch (ClassNotFoundException ex) {
                    String[] msg = this.processingEnv.getMessager();
                    msg.printMessage(Diagnostic.Kind.ERROR, "Either specify 'page' value or implement or return WizardDescriptor.InstantiatingIterator", e);
                }
            } else {
                this.registerHTMLWizard(e, builder, f, t);
            }
        }
        if (t.content().length > 0) {
            f.url(this.contentURI(e, t.content()[0], builder, t, "content").toString());
            for (int i = 1; i < t.content().length; ++i) {
                builder.file(folder + TemplateProcessor.basename(t.content()[i])).url(this.contentURI(e, t.content()[i], builder, t, "content").toString()).position(0).write();
            }
        }
        if (!t.scriptEngine().isEmpty()) {
            f.stringvalue("javax.script.ScriptEngine", t.scriptEngine());
        }
        if (t.category().length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String c : t.category()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(c);
            }
            f.stringvalue("templateCategory", sb.toString());
        }
        f.boolvalue("requireProject", t.requireProject());
        if (!t.targetName().trim().isEmpty()) {
            f.bundlevalue("targetName", t.targetName());
        }
        String[] techIds = t.techIds();
        for (int i = 0; i < techIds.length; ++i) {
            String id = techIds[i];
            f.stringvalue("techId." + i, id);
        }
        f.write();
    }

    private static String basename(String relativeResource) {
        return relativeResource.replaceFirst(".+/", "").replaceFirst("[.]template$", "");
    }

    private URI contentURI(Element e, String relativePath, LayerBuilder builder, TemplateRegistration t, String annotationMethod) throws LayerGenerationException {
        String path = LayerBuilder.absolutizeResource(e, relativePath);
        builder.validateResource(path, e, t, annotationMethod, false);
        try {
            return new URI("nbresloc", "/" + path, null).normalize();
        }
        catch (URISyntaxException x) {
            throw new LayerGenerationException("could not translate " + path, e, this.processingEnv, t);
        }
    }

    private void registerHTMLWizard(Element e, LayerBuilder b, LayerBuilder.File f, TemplateRegistration t) throws LayerGenerationException {
        String pg;
        try {
            b.validateResource(t.page(), e, t, "page", true);
            pg = t.page();
        }
        catch (LayerGenerationException layerGenerationException) {
            pg = LayerBuilder.absolutizeResource(e, t.page());
        }
        b.validateResource(pg, e, t, "page", true);
        f.stringvalue("page", pg);
        if (e.getKind() != ElementKind.METHOD) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "page() attribute can be used only on static method", e);
            return;
        }
        ExecutableElement ee = (ExecutableElement)e;
        if (!ee.getModifiers().contains((Object)Modifier.STATIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "page() attribute can be used only on static method", e);
            return;
        }
        TypeElement typeString = this.processingEnv.getElementUtils().getTypeElement("java.lang.String");
        if (!this.processingEnv.getTypeUtils().isSameType(typeString.asType(), ee.getReturnType()) && !this.isModel(this.processingEnv.getTypeUtils().asElement(ee.getReturnType()))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "page() attribute requires its method to return String or class generated by @Model annotation", e);
            return;
        }
        if (!ee.getParameters().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "page() attribute requires its method to take no arguments", e);
            return;
        }
        f.methodvalue("instantiatingIterator", HTMLWizard.class.getName(), "create");
        TypeElement te = (TypeElement)e.getEnclosingElement();
        Name fqn = this.processingEnv.getElementUtils().getBinaryName(te);
        f.stringvalue("class", fqn.toString());
        f.stringvalue("method", ee.getSimpleName().toString());
    }

    private boolean isModel(Element e) {
        for (Element element : e.getEnclosedElements()) {
            if (!"modelFor".equals(element.getSimpleName().toString())) continue;
            return true;
        }
        return false;
    }
}

