/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.actions.Savable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.actions.CookieAction;

public class SaveAction
extends CookieAction {
    private static Class<? extends Node.Cookie> dataObject;
    private static Method getNodeDelegate;

    public SaveAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected Class[] cookieClasses() {
        return new Class[]{Savable.class};
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new Delegate(this, actionContext);
    }

    final void performAction(Lookup context) {
        Collection<Savable> cookieList = context.lookupAll(Savable.class);
        LinkedList<Node> nodeList = new LinkedList<Node>(context.lookupAll(Node.class));
        block0: for (Savable savable : cookieList) {
            for (Node node : nodeList) {
                if (!savable.equals(node.getLookup().lookup(Savable.class))) continue;
                this.performAction(savable, node);
                nodeList.remove(node);
                continue block0;
            }
            this.performAction(savable, null);
        }
    }

    @Override
    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node node = activatedNodes[i];
            Savable sc = node.getLookup().lookup(Savable.class);
            assert (sc != null) : "Savable must be present on " + node + ". " + "See http://www.netbeans.org/issues/show_bug.cgi?id=68285 for details on overriding " + node.getClass().getName() + ".getCookie correctly.";
            if (sc == null) {
                return;
            }
            this.performAction(sc, node);
        }
    }

    private void performAction(Savable sc, Node n) {
        UserQuestionException userEx = null;
        while (true) {
            try {
                if (userEx == null) {
                    sc.save();
                } else {
                    userEx.confirmed();
                }
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SaveAction.class, "MSG_saved", this.getSaveMessage(sc, n)));
            }
            catch (UserQuestionException ex) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)ex.getLocalizedMessage(), 0);
                Object res = DialogDisplayer.getDefault().notify(nd);
                if (!NotifyDescriptor.OK_OPTION.equals(res)) break;
                userEx = ex;
                continue;
            }
            catch (IOException e) {
                Exceptions.attachLocalizedMessage(e, NbBundle.getMessage(SaveAction.class, "EXC_notsaved", this.getSaveMessage(sc, n), e.getLocalizedMessage()));
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
            break;
        }
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    private String getSaveMessage(Savable sc, Node n) {
        Node.Cookie obj;
        if (n == null) {
            return sc.toString();
        }
        if (dataObject == null) {
            ClassLoader l = Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = this.getClass().getClassLoader();
            }
            try {
                dataObject = Class.forName("org.openide.loaders.DataObject", true, l).asSubclass(Node.Cookie.class);
                getNodeDelegate = dataObject.getMethod("getNodeDelegate", new Class[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        if (getNodeDelegate != null && (obj = n.getCookie(dataObject)) != null) {
            try {
                n = (Node)getNodeDelegate.invoke((Object)obj, new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        return n.getDisplayName();
    }

    @Override
    protected int mode() {
        return 7;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(SaveAction.class, "Save");
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAction.class);
    }

    @Override
    protected String iconResource() {
        return "org/openide/resources/actions/save.png";
    }

    private static final class Delegate
    extends AbstractAction
    implements ContextAwareAction {
        final SaveAction sa;
        final Lookup context;

        public Delegate(SaveAction sa, Lookup context) {
            this.sa = sa;
            this.context = context;
        }

        @Override
        public Action createContextAwareInstance(Lookup actionContext) {
            return new Delegate(this.sa, actionContext);
        }

        @Override
        public Object getValue(String key) {
            return this.sa.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.sa.putValue(key, value);
        }

        @Override
        public boolean isEnabled() {
            return this.context.lookup(Savable.class) != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.sa.performAction(this.context);
        }
    }
}

