/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.LifecycleManager;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;

public final class SaveAllAction
extends CallableSystemAction {
    static final long serialVersionUID = 333L;
    private static final Object RUNNING = new Object();
    private ChangeListener chl = new ModifiedListL();

    public SaveAllAction() {
        DataObject.getRegistry().addChangeListener(WeakListeners.change(this.chl, DataObject.getRegistry()));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.putProperty("enabled", Boolean.FALSE);
        this.putValue("ShortDescription", NbBundle.getMessage(DataObject.class, "HINT_SaveAll"));
        this.chl = new ModifiedListL();
        DataObject.getRegistry().addChangeListener(WeakListeners.change(this.chl, DataObject.getRegistry()));
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(DataObject.class, "SaveAll");
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAllAction.class);
    }

    @Override
    protected String iconResource() {
        return "org/openide/loaders/saveAll.gif";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction() {
        Object object = RUNNING;
        synchronized (object) {
            while (this.getProperty(RUNNING) != null) {
                try {
                    RUNNING.wait();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
            this.putProperty(RUNNING, RUNNING);
        }
        try {
            LifecycleManager.getDefault().saveAll();
        }
        finally {
            object = RUNNING;
            synchronized (object) {
                this.putProperty(RUNNING, null);
                RUNNING.notifyAll();
            }
        }
    }

    @Override
    protected boolean asynchronous() {
        return true;
    }

    final class ModifiedListL
    implements ChangeListener {
        ModifiedListL() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    SaveAllAction.this.setEnabled(DataObject.getRegistry().getModifiedSet().size() > 0);
                }
            });
        }
    }
}

