/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.openide.actions.NewTemplateAction;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.NodeAction;

public final class SaveAsTemplateAction
extends NodeAction {
    static final String SCRIPT_ENGINE_ATTR = "javax.script.ScriptEngine";

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAsTemplateAction.class);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(DataObject.class, "SaveAsTemplate");
    }

    @Override
    @Deprecated
    public String iconResource() {
        return super.iconResource();
    }

    @Override
    protected boolean surviveFocusChange() {
        return false;
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            DataObject curCookie = activatedNodes[i].getCookie(DataObject.class);
            if (curCookie != null && curCookie.isCopyAllowed()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void performAction(Node[] activatedNodes) {
        Node[] selected;
        FolderNodeAcceptor acceptor = FolderNodeAcceptor.getInstance();
        String title = NbBundle.getMessage(DataObject.class, "Title_SaveAsTemplate");
        String rootTitle = NbBundle.getMessage(DataObject.class, "CTL_SaveAsTemplate");
        Node templatesNode = NewTemplateAction.getTemplateRoot();
        templatesNode.setDisplayName(NbBundle.getMessage(DataObject.class, "CTL_SaveAsTemplate_TemplatesRoot"));
        try {
            selected = NodeOperation.getDefault().select(title, rootTitle, templatesNode, acceptor, null);
        }
        catch (UserCancelException ex) {
            return;
        }
        DataFolder targetFolder = selected[0].getCookie(DataFolder.class);
        for (int i = 0; i < activatedNodes.length; ++i) {
            this.createNewTemplate(activatedNodes[i].getCookie(DataObject.class), targetFolder);
        }
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    private void createNewTemplate(DataObject source, DataFolder targetFolder) {
        try {
            SaveCookie cookie = source.getCookie(SaveCookie.class);
            if (cookie != null) {
                cookie.save();
            }
            DataObject newTemplate = source.copy(targetFolder);
            DataObject templateSample = null;
            for (DataObject d : targetFolder.getChildren()) {
                if (!d.isTemplate()) continue;
                templateSample = d;
                break;
            }
            newTemplate.setTemplate(true);
            if (templateSample == null) {
                newTemplate.getPrimaryFile().setAttribute(SCRIPT_ENGINE_ATTR, "freemarker");
            } else {
                SaveAsTemplateAction.setTemplateAttributes(newTemplate.getPrimaryFile(), SaveAsTemplateAction.getAttributes(templateSample.getPrimaryFile()));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    private static void setTemplateAttributes(FileObject fo, Map<String, Object> attributes) throws IOException {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            if ("SystemFileSystem.localizingBundle".equals(entry.getKey())) continue;
            fo.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    private static Map<String, Object> getAttributes(FileObject fo) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration<String> attributeNames = fo.getAttributes();
        while (attributeNames.hasMoreElements()) {
            Object attrValue;
            String attrName = attributeNames.nextElement();
            if (attrName == null || (attrValue = fo.getAttribute(attrName)) == null) continue;
            attributes.put(attrName, attrValue);
        }
        return attributes;
    }

    static final class FolderNodeAcceptor
    implements NodeAcceptor {
        private static FolderNodeAcceptor instance;
        private DataFolder rootFolder;

        private FolderNodeAcceptor(DataFolder root) {
            this.rootFolder = root;
        }

        @Override
        public boolean acceptNodes(Node[] nodes) {
            boolean res = false;
            if (nodes == null || nodes.length != 1) {
                res = false;
            } else {
                Node n = nodes[0];
                DataFolder df = n.getCookie(DataFolder.class);
                if (df != null) {
                    res = !this.rootFolder.equals(df);
                }
            }
            return res;
        }

        static FolderNodeAcceptor getInstance() {
            DataFolder rootFolder = NewTemplateAction.getTemplateRoot().getCookie(DataFolder.class);
            if (instance == null) {
                instance = new FolderNodeAcceptor(rootFolder);
            }
            return instance;
        }
    }
}

