/*
 * Decompiled with CFR 0.152.
 */
package org.openide.io;

import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.spi.io.InputOutputProvider;
import org.netbeans.spi.io.support.Hyperlinks;
import org.netbeans.spi.io.support.OutputColorType;
import org.netbeans.spi.io.support.OutputColors;
import org.openide.util.Lookup;
import org.openide.windows.FoldHandle;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.IOContainer;
import org.openide.windows.IOFolding;
import org.openide.windows.IOPosition;
import org.openide.windows.IOProvider;
import org.openide.windows.IOSelect;
import org.openide.windows.IOTab;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class BridgingInputOutputProvider
implements InputOutputProvider<InputOutput, OutputWriter, IOPosition.Position, FoldHandle> {
    private final IOProvider delegate;
    private static final Logger LOG = Logger.getLogger(BridgingInputOutputProvider.class.getName());
    private final Deque<FoldHandle> foldStack = new ArrayDeque<FoldHandle>();

    public BridgingInputOutputProvider(IOProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getId() {
        return this.delegate.getName();
    }

    @Override
    public InputOutput getIO(String name, boolean newIO, Lookup lookup) {
        Action[] actions2 = lookup.lookup(Action[].class);
        IOContainer container = lookup.lookup(IOContainer.class);
        if (container == null && actions2 == null) {
            return this.delegate.getIO(name, newIO);
        }
        if (newIO) {
            if (container != null && actions2 != null) {
                return this.delegate.getIO(name, actions2, container);
            }
            if (actions2 != null) {
                return this.delegate.getIO(name, actions2);
            }
            return this.delegate.getIO(name, new Action[0], container);
        }
        return this.delegate.getIO(name, newIO, actions2 == null ? new Action[]{} : actions2, container);
    }

    @Override
    public Reader getIn(InputOutput io) {
        return io.getIn();
    }

    @Override
    public OutputWriter getOut(InputOutput io) {
        return io.getOut();
    }

    @Override
    public OutputWriter getErr(InputOutput io) {
        return io.getErr();
    }

    @Override
    public void print(InputOutput io, OutputWriter writer, String text, Hyperlink link, OutputColor outputColor, boolean printLineEnd) {
        Color awtColor = BridgingInputOutputProvider.outputColorToAwtColor(io, outputColor);
        OutputListener listener = BridgingInputOutputProvider.hyperlinkToOutputListener(link);
        boolean listenerImportant = link != null && Hyperlinks.isImportant(link);
        try {
            if (printLineEnd && outputColor == null) {
                writer.println(text, listener, listenerImportant);
            } else if (printLineEnd && IOColorLines.isSupported(io)) {
                IOColorLines.println(io, text, listener, listenerImportant, awtColor);
            } else if (IOColorPrint.isSupported(io)) {
                IOColorPrint.print(io, text, listener, listenerImportant, awtColor);
                if (printLineEnd) {
                    writer.println();
                }
            } else if (printLineEnd) {
                writer.println(text);
            } else {
                writer.print(text);
            }
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "Cannot print color or hyperlink", ex);
        }
    }

    @Override
    public Lookup getIOLookup(InputOutput io) {
        if (io instanceof Lookup.Provider) {
            return ((Lookup.Provider)((Object)io)).getLookup();
        }
        return Lookup.EMPTY;
    }

    @Override
    public void resetIO(InputOutput io) {
        try {
            io.getOut().reset();
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "Cannot reset InputOutput.", ex);
        }
    }

    @Override
    public void showIO(InputOutput io, Set<ShowOperation> operations) {
        if (operations.contains((Object)ShowOperation.OPEN) && operations.contains((Object)ShowOperation.MAKE_VISIBLE) && operations.size() == 2) {
            io.select();
        } else {
            IOSelect.select(io, this.showOperationsToIoSelect(operations));
        }
    }

    private Set<IOSelect.AdditionalOperation> showOperationsToIoSelect(Set<ShowOperation> operations) {
        EnumSet<IOSelect.AdditionalOperation> res = EnumSet.noneOf(IOSelect.AdditionalOperation.class);
        for (ShowOperation so : operations) {
            switch (so) {
                case OPEN: {
                    res.add(IOSelect.AdditionalOperation.OPEN);
                    break;
                }
                case MAKE_VISIBLE: {
                    res.add(IOSelect.AdditionalOperation.REQUEST_VISIBLE);
                    break;
                }
                case ACTIVATE: {
                    res.add(IOSelect.AdditionalOperation.REQUEST_ACTIVE);
                }
            }
        }
        return res;
    }

    @Override
    public void closeIO(InputOutput io) {
        io.closeInputOutput();
    }

    @Override
    public boolean isIOClosed(InputOutput io) {
        return io.isClosed();
    }

    @Override
    public IOPosition.Position getCurrentPosition(InputOutput io, OutputWriter writer) {
        if (IOPosition.isSupported(io)) {
            return IOPosition.currentPosition(io);
        }
        return null;
    }

    @Override
    public void scrollTo(InputOutput io, OutputWriter writer, IOPosition.Position position) {
        position.scrollTo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FoldHandle startFold(InputOutput io, OutputWriter writer, boolean expanded) {
        if (IOFolding.isSupported(io)) {
            Deque<FoldHandle> deque = this.foldStack;
            synchronized (deque) {
                if (this.foldStack.isEmpty()) {
                    this.foldStack.addLast(IOFolding.startFold(io, expanded));
                } else {
                    this.foldStack.addLast(this.foldStack.getLast().startFold(expanded));
                }
                return this.foldStack.getLast();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endFold(InputOutput io, OutputWriter writer, FoldHandle fold) {
        Deque<FoldHandle> deque = this.foldStack;
        synchronized (deque) {
            while (!this.foldStack.isEmpty() && this.foldStack.removeLast() != fold) {
            }
            fold.silentFinish();
        }
    }

    @Override
    public void setFoldExpanded(InputOutput io, OutputWriter writer, FoldHandle fold, boolean expanded) {
        fold.setExpanded(expanded);
    }

    @Override
    public String getIODescription(InputOutput io) {
        if (IOTab.isSupported(io)) {
            return IOTab.getToolTipText(io);
        }
        return null;
    }

    @Override
    public void setIODescription(InputOutput io, String description) {
        if (IOTab.isSupported(io)) {
            IOTab.setToolTipText(io, description);
        }
    }

    private static OutputListener hyperlinkToOutputListener(final Hyperlink link) {
        if (link == null) {
            return null;
        }
        return new OutputListenerAdapter(){

            @Override
            public void outputLineAction(OutputEvent ev) {
                Hyperlinks.invoke(link);
            }
        };
    }

    private static Color outputColorToAwtColor(InputOutput io, OutputColor color) {
        if (color == null) {
            return null;
        }
        OutputColorType type = OutputColors.getType(color);
        if (type == OutputColorType.RGB) {
            return new Color(OutputColors.getRGB(color));
        }
        if (IOColors.isSupported(io)) {
            switch (type) {
                case DEBUG: {
                    return IOColors.getColor(io, IOColors.OutputType.LOG_DEBUG);
                }
                case FAILURE: {
                    return IOColors.getColor(io, IOColors.OutputType.LOG_FAILURE);
                }
                case WARNING: {
                    return IOColors.getColor(io, IOColors.OutputType.LOG_WARNING);
                }
                case SUCCESS: {
                    return IOColors.getColor(io, IOColors.OutputType.LOG_SUCCESS);
                }
            }
            return null;
        }
        return null;
    }

    private static class OutputListenerAdapter
    implements OutputListener {
        private OutputListenerAdapter() {
        }

        @Override
        public void outputLineSelected(OutputEvent ev) {
        }

        @Override
        public void outputLineAction(OutputEvent ev) {
        }

        @Override
        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

