/*
 * Decompiled with CFR 0.152.
 */
package kco.forceatlas2;

import kco.forceatlas2.ForceFactory;
import kco.forceatlas2.Region;
import org.gephi.graph.api.Node;

public class NodesThread
implements Runnable {
    private Node[] nodes;
    private int from;
    private int to;
    private Region rootRegion;
    private boolean barnesHutOptimize;
    private ForceFactory.RepulsionForce Repulsion;
    private double barnesHutTheta;
    private double gravity;
    private ForceFactory.RepulsionForce GravityForce;
    private double scaling;

    public NodesThread(Node[] nodeArray, int n, int n2, boolean bl, double d, double d2, ForceFactory.RepulsionForce repulsionForce, double d3, Region region, ForceFactory.RepulsionForce repulsionForce2) {
        this.nodes = nodeArray;
        this.from = n;
        this.to = n2;
        this.rootRegion = region;
        this.barnesHutOptimize = bl;
        this.Repulsion = repulsionForce2;
        this.barnesHutTheta = d;
        this.gravity = d2;
        this.GravityForce = repulsionForce;
        this.scaling = d3;
    }

    @Override
    public void run() {
        Node node;
        int n;
        if (this.barnesHutOptimize) {
            for (n = this.from; n < this.to; ++n) {
                node = this.nodes[n];
                this.rootRegion.applyForce(node, this.Repulsion, this.barnesHutTheta);
            }
        } else {
            for (n = this.from; n < this.to; ++n) {
                node = this.nodes[n];
                for (int i = 0; i < n; ++i) {
                    Node node2 = this.nodes[i];
                    this.Repulsion.apply(node, node2);
                }
            }
        }
        for (n = this.from; n < this.to; ++n) {
            node = this.nodes[n];
            this.GravityForce.apply(node, this.gravity / this.scaling);
        }
    }
}

