# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any, BinaryIO


class ListProjectIdsRequest(TeaModel):
    def __init__(
        self,
        user_id: str = None,
    ):
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListProjectIdsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        project_ids: List[int] = None,
    ):
        self.request_id = request_id
        self.project_ids = project_ids

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.project_ids, 'project_ids')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.project_ids is not None:
            result['ProjectIds'] = self.project_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ProjectIds') is not None:
            self.project_ids = m.get('ProjectIds')
        return self


class TerminateDISyncInstanceRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class TerminateDISyncInstanceResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class TerminateDISyncInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: TerminateDISyncInstanceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = TerminateDISyncInstanceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteDISyncTaskResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeleteDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: DeleteDISyncTaskResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = DeleteDISyncTaskResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeployDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeployDISyncTaskResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeployDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: DeployDISyncTaskResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = DeployDISyncTaskResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class StartDISyncInstanceRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
        start_param: str = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id
        self.start_param = start_param

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.start_param is not None:
            result['StartParam'] = self.start_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('StartParam') is not None:
            self.start_param = m.get('StartParam')
        return self


class StartDISyncInstanceResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class StartDISyncInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: StartDISyncInstanceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = StartDISyncInstanceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDISyncInstanceInfoRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class GetDISyncInstanceInfoResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
        name: str = None,
        message: str = None,
    ):
        self.status = status
        self.name = name
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.name, 'name')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.name is not None:
            result['Name'] = self.name
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class GetDISyncInstanceInfoResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: GetDISyncInstanceInfoResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDISyncInstanceInfoResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class StopDISyncInstanceRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class StopDISyncInstanceResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class StopDISyncInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: StopDISyncInstanceResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = StopDISyncInstanceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class GetDISyncTaskResponseData(TeaModel):
    def __init__(
        self,
        code: str = None,
        status: str = None,
        message: str = None,
    ):
        self.code = code
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class GetDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: GetDISyncTaskResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDISyncTaskResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CheckMetaTableTaskRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CheckMetaTableTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CheckEngineMetaPartitionRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        partition: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.partition = partition
        self.data_source_type = data_source_type

    def validate(self):
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.partition, 'partition')
        self.validate_required(self.data_source_type, 'data_source_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.partition is not None:
            result['Partition'] = self.partition
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('Partition') is not None:
            self.partition = m.get('Partition')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckEngineMetaPartitionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CheckEngineMetaTableRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.data_source_type = data_source_type

    def validate(self):
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.data_source_type, 'data_source_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckEngineMetaTableResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ImportDataSourcesRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        data_sources: str = None,
    ):
        self.project_id = project_id
        self.data_sources = data_sources

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.data_sources, 'data_sources')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.data_sources is not None:
            result['DataSources'] = self.data_sources
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DataSources') is not None:
            self.data_sources = m.get('DataSources')
        return self


class ImportDataSourcesResponseData(TeaModel):
    def __init__(
        self,
        status: bool = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ImportDataSourcesResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: ImportDataSourcesResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ImportDataSourcesResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ExportDataSourcesRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        data_source_type: str = None,
        sub_type: str = None,
        env_type: int = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.data_source_type = data_source_type
        self.sub_type = sub_type
        self.env_type = env_type
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ExportDataSourcesResponseDataDataSources(TeaModel):
    def __init__(
        self,
        shared: bool = None,
        gmt_modified: str = None,
        connect_status: int = None,
        binding_calc_engine_id: int = None,
        description: str = None,
        data_source_type: str = None,
        gmt_create: str = None,
        default_engine: bool = None,
        operator: str = None,
        sequence: int = None,
        env_type: int = None,
        tenant_id: int = None,
        name: str = None,
        sub_type: str = None,
        id: int = None,
        project_id: int = None,
        status: int = None,
        content: str = None,
    ):
        self.shared = shared
        self.gmt_modified = gmt_modified
        self.connect_status = connect_status
        self.binding_calc_engine_id = binding_calc_engine_id
        self.description = description
        self.data_source_type = data_source_type
        self.gmt_create = gmt_create
        self.default_engine = default_engine
        self.operator = operator
        self.sequence = sequence
        self.env_type = env_type
        self.tenant_id = tenant_id
        self.name = name
        self.sub_type = sub_type
        self.id = id
        self.project_id = project_id
        self.status = status
        self.content = content

    def validate(self):
        self.validate_required(self.shared, 'shared')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.connect_status, 'connect_status')
        self.validate_required(self.binding_calc_engine_id, 'binding_calc_engine_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.data_source_type, 'data_source_type')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.default_engine, 'default_engine')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.sequence, 'sequence')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.sub_type, 'sub_type')
        self.validate_required(self.id, 'id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.content, 'content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.name is not None:
            result['Name'] = self.name
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.id is not None:
            result['Id'] = self.id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class ExportDataSourcesResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_sources: List[ExportDataSourcesResponseDataDataSources] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_sources = data_sources

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data_sources, 'data_sources')
        if self.data_sources:
            for k in self.data_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataSources'] = []
        if self.data_sources is not None:
            for k in self.data_sources:
                result['DataSources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_sources = []
        if m.get('DataSources') is not None:
            for k in m.get('DataSources'):
                temp_model = ExportDataSourcesResponseDataDataSources()
                self.data_sources.append(temp_model.from_map(k))
        return self


class ExportDataSourcesResponse(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        success: bool = None,
        request_id: str = None,
        data: ExportDataSourcesResponseData = None,
    ):
        self.http_status_code = http_status_code
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ExportDataSourcesResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataSourceMetaRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        datasource_name: str = None,
        page_number: int = None,
        page_size: int = None,
        env_type: str = None,
    ):
        self.project_id = project_id
        self.datasource_name = datasource_name
        self.page_number = page_number
        self.page_size = page_size
        self.env_type = env_type

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.datasource_name, 'datasource_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        return self


class GetDataSourceMetaResponseData(TeaModel):
    def __init__(
        self,
        meta: str = None,
        status: str = None,
        message: str = None,
    ):
        self.meta = meta
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.meta, 'meta')
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.meta is not None:
            result['Meta'] = self.meta
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class GetDataSourceMetaResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: GetDataSourceMetaResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDataSourceMetaResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class SetDataSourceShareRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        datasource_name: str = None,
        env_type: str = None,
        project_permissions: str = None,
        user_permissions: str = None,
    ):
        self.project_id = project_id
        self.datasource_name = datasource_name
        self.env_type = env_type
        self.project_permissions = project_permissions
        self.user_permissions = user_permissions

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.datasource_name, 'datasource_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.project_permissions is not None:
            result['ProjectPermissions'] = self.project_permissions
        if self.user_permissions is not None:
            result['UserPermissions'] = self.user_permissions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ProjectPermissions') is not None:
            self.project_permissions = m.get('ProjectPermissions')
        if m.get('UserPermissions') is not None:
            self.user_permissions = m.get('UserPermissions')
        return self


class SetDataSourceShareResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class SetDataSourceShareResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: SetDataSourceShareResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = SetDataSourceShareResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDIProjectConfigRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        destination_type: str = None,
        source_type: str = None,
    ):
        self.project_id = project_id
        self.destination_type = destination_type
        self.source_type = source_type

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.destination_type, 'destination_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class ListDIProjectConfigResponseData(TeaModel):
    def __init__(
        self,
        config: str = None,
    ):
        self.config = config

    def validate(self):
        self.validate_required(self.config, 'config')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        return self


class ListDIProjectConfigResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: ListDIProjectConfigResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListDIProjectConfigResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ExportConnectionsRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        data_source_type: str = None,
        sub_type: str = None,
        env_type: int = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.data_source_type = data_source_type
        self.sub_type = sub_type
        self.env_type = env_type
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ExportConnectionsResponseDataDataSources(TeaModel):
    def __init__(
        self,
        shared: bool = None,
        gmt_modified: str = None,
        connect_status: int = None,
        binding_calc_engine_id: int = None,
        description: str = None,
        data_source_type: str = None,
        gmt_create: str = None,
        default_engine: bool = None,
        operator: str = None,
        sequence: int = None,
        env_type: int = None,
        tenant_id: int = None,
        name: str = None,
        sub_type: str = None,
        id: int = None,
        project_id: int = None,
        status: int = None,
        content: str = None,
    ):
        self.shared = shared
        self.gmt_modified = gmt_modified
        self.connect_status = connect_status
        self.binding_calc_engine_id = binding_calc_engine_id
        self.description = description
        self.data_source_type = data_source_type
        self.gmt_create = gmt_create
        self.default_engine = default_engine
        self.operator = operator
        self.sequence = sequence
        self.env_type = env_type
        self.tenant_id = tenant_id
        self.name = name
        self.sub_type = sub_type
        self.id = id
        self.project_id = project_id
        self.status = status
        self.content = content

    def validate(self):
        self.validate_required(self.shared, 'shared')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.connect_status, 'connect_status')
        self.validate_required(self.binding_calc_engine_id, 'binding_calc_engine_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.data_source_type, 'data_source_type')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.default_engine, 'default_engine')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.sequence, 'sequence')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.sub_type, 'sub_type')
        self.validate_required(self.id, 'id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.content, 'content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.name is not None:
            result['Name'] = self.name
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.id is not None:
            result['Id'] = self.id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class ExportConnectionsResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_sources: List[ExportConnectionsResponseDataDataSources] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_sources = data_sources

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data_sources, 'data_sources')
        if self.data_sources:
            for k in self.data_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataSources'] = []
        if self.data_sources is not None:
            for k in self.data_sources:
                result['DataSources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_sources = []
        if m.get('DataSources') is not None:
            for k in m.get('DataSources'):
                temp_model = ExportConnectionsResponseDataDataSources()
                self.data_sources.append(temp_model.from_map(k))
        return self


class ExportConnectionsResponse(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        success: bool = None,
        request_id: str = None,
        data: ExportConnectionsResponseData = None,
    ):
        self.http_status_code = http_status_code
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ExportConnectionsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListRefDISyncTasksRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        datasource_name: str = None,
        task_type: str = None,
        ref_type: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.project_id = project_id
        self.datasource_name = datasource_name
        self.task_type = task_type
        self.ref_type = ref_type
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.datasource_name, 'datasource_name')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.ref_type, 'ref_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.ref_type is not None:
            result['RefType'] = self.ref_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('RefType') is not None:
            self.ref_type = m.get('RefType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListRefDISyncTasksResponseDataDISyncTasks(TeaModel):
    def __init__(
        self,
        node_name: str = None,
        node_id: int = None,
        task_type: str = None,
        di_destination_datasource: str = None,
        di_source_datasource: str = None,
    ):
        self.node_name = node_name
        self.node_id = node_id
        self.task_type = task_type
        self.di_destination_datasource = di_destination_datasource
        self.di_source_datasource = di_source_datasource

    def validate(self):
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.di_destination_datasource, 'di_destination_datasource')
        self.validate_required(self.di_source_datasource, 'di_source_datasource')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.di_destination_datasource is not None:
            result['DiDestinationDatasource'] = self.di_destination_datasource
        if self.di_source_datasource is not None:
            result['DiSourceDatasource'] = self.di_source_datasource
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('DiDestinationDatasource') is not None:
            self.di_destination_datasource = m.get('DiDestinationDatasource')
        if m.get('DiSourceDatasource') is not None:
            self.di_source_datasource = m.get('DiSourceDatasource')
        return self


class ListRefDISyncTasksResponseData(TeaModel):
    def __init__(
        self,
        disync_tasks: List[ListRefDISyncTasksResponseDataDISyncTasks] = None,
    ):
        self.disync_tasks = disync_tasks

    def validate(self):
        self.validate_required(self.disync_tasks, 'disync_tasks')
        if self.disync_tasks:
            for k in self.disync_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DISyncTasks'] = []
        if self.disync_tasks is not None:
            for k in self.disync_tasks:
                result['DISyncTasks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.disync_tasks = []
        if m.get('DISyncTasks') is not None:
            for k in m.get('DISyncTasks'):
                temp_model = ListRefDISyncTasksResponseDataDISyncTasks()
                self.disync_tasks.append(temp_model.from_map(k))
        return self


class ListRefDISyncTasksResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: ListRefDISyncTasksResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListRefDISyncTasksResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class SetConnectionShareRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        datasource_name: str = None,
        env_type: str = None,
        project_permissions: str = None,
        user_permissions: str = None,
    ):
        self.project_id = project_id
        self.datasource_name = datasource_name
        self.env_type = env_type
        self.project_permissions = project_permissions
        self.user_permissions = user_permissions

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.datasource_name, 'datasource_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.project_permissions is not None:
            result['ProjectPermissions'] = self.project_permissions
        if self.user_permissions is not None:
            result['UserPermissions'] = self.user_permissions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ProjectPermissions') is not None:
            self.project_permissions = m.get('ProjectPermissions')
        if m.get('UserPermissions') is not None:
            self.user_permissions = m.get('UserPermissions')
        return self


class SetConnectionShareResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
    ):
        self.status = status

    def validate(self):
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class SetConnectionShareResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: SetConnectionShareResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = SetConnectionShareResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ImportConnectionsRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        connections: str = None,
    ):
        self.project_id = project_id
        self.connections = connections

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.connections, 'connections')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.connections is not None:
            result['Connections'] = self.connections
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Connections') is not None:
            self.connections = m.get('Connections')
        return self


class ImportConnectionsResponseData(TeaModel):
    def __init__(
        self,
        status: bool = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ImportConnectionsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: ImportConnectionsResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ImportConnectionsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetConnectionMetaRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        datasource_name: str = None,
        page_number: int = None,
        page_size: int = None,
        env_type: str = None,
    ):
        self.project_id = project_id
        self.datasource_name = datasource_name
        self.page_number = page_number
        self.page_size = page_size
        self.env_type = env_type

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.datasource_name, 'datasource_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        return self


class GetConnectionMetaResponseData(TeaModel):
    def __init__(
        self,
        meta: str = None,
    ):
        self.meta = meta

    def validate(self):
        self.validate_required(self.meta, 'meta')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.meta is not None:
            result['Meta'] = self.meta
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        return self


class GetConnectionMetaResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: GetConnectionMetaResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetConnectionMetaResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateDIProjectConfigRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        destination_type: str = None,
        source_type: str = None,
        project_config: str = None,
    ):
        self.project_id = project_id
        self.destination_type = destination_type
        self.source_type = source_type
        self.project_config = project_config

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.destination_type, 'destination_type')
        self.validate_required(self.project_config, 'project_config')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.project_config is not None:
            result['ProjectConfig'] = self.project_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('ProjectConfig') is not None:
            self.project_config = m.get('ProjectConfig')
        return self


class UpdateDIProjectConfigResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
    ):
        self.status = status

    def validate(self):
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateDIProjectConfigResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: UpdateDIProjectConfigResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = UpdateDIProjectConfigResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        task_content: str = None,
        task_param: str = None,
        task_name: str = None,
        client_token: str = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.task_content = task_content
        self.task_param = task_param
        self.task_name = task_name
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.task_content, 'task_content')
        self.validate_required(self.task_param, 'task_param')
        self.validate_required(self.task_name, 'task_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_content is not None:
            result['TaskContent'] = self.task_content
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskContent') is not None:
            self.task_content = m.get('TaskContent')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateDISyncTaskResponseData(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        status: str = None,
        message: str = None,
    ):
        self.file_id = file_id
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class CreateDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: CreateDISyncTaskResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateDISyncTaskResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        task_content: str = None,
        task_param: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.task_content = task_content
        self.task_param = task_param
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_content is not None:
            result['TaskContent'] = self.task_content
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskContent') is not None:
            self.task_content = m.get('TaskContent')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class UpdateDISyncTaskResponseData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class UpdateDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        data: UpdateDISyncTaskResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = UpdateDISyncTaskResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class TestNetworkConnectionRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        datasource_name: str = None,
        env_type: str = None,
        resource_group: str = None,
    ):
        self.project_id = project_id
        self.datasource_name = datasource_name
        self.env_type = env_type
        self.resource_group = resource_group

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.datasource_name, 'datasource_name')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.resource_group, 'resource_group')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.resource_group is not None:
            result['ResourceGroup'] = self.resource_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ResourceGroup') is not None:
            self.resource_group = m.get('ResourceGroup')
        return self


class TestNetworkConnectionResponseTaskList(TeaModel):
    def __init__(
        self,
        connect_status: bool = None,
        connect_message: str = None,
    ):
        self.connect_status = connect_status
        self.connect_message = connect_message

    def validate(self):
        self.validate_required(self.connect_status, 'connect_status')
        self.validate_required(self.connect_message, 'connect_message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.connect_message is not None:
            result['ConnectMessage'] = self.connect_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('ConnectMessage') is not None:
            self.connect_message = m.get('ConnectMessage')
        return self


class TestNetworkConnectionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        task_list: TestNetworkConnectionResponseTaskList = None,
    ):
        self.request_id = request_id
        self.success = success
        self.task_list = task_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.task_list, 'task_list')
        if self.task_list:
            self.task_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_list is not None:
            result['TaskList'] = self.task_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskList') is not None:
            temp_model = TestNetworkConnectionResponseTaskList()
            self.task_list = temp_model.from_map(m['TaskList'])
        return self


class UpdateNodeRunModeRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        node_id: int = None,
        scheduler_type: int = None,
    ):
        self.project_env = project_env
        self.node_id = node_id
        self.scheduler_type = scheduler_type

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.scheduler_type, 'scheduler_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class UpdateNodeRunModeResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.success = success

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class UpdateNodeOwnerRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        node_id: int = None,
        user_id: str = None,
    ):
        self.project_env = project_env
        self.node_id = node_id
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class UpdateNodeOwnerResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.success = success

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryPublicModelEngineRequest(TeaModel):
    def __init__(
        self,
        text: str = None,
        project_id: str = None,
    ):
        self.text = text
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.text, 'text')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.text is not None:
            result['Text'] = self.text
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class QueryPublicModelEngineResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        return_value: List[Dict[str, Any]] = None,
    ):
        self.request_id = request_id
        self.return_value = return_value

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.return_value, 'return_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.return_value is not None:
            result['ReturnValue'] = self.return_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ReturnValue') is not None:
            self.return_value = m.get('ReturnValue')
        return self


class DeleteViewRequest(TeaModel):
    def __init__(
        self,
        view_name: str = None,
        app_guid: str = None,
    ):
        self.view_name = view_name
        self.app_guid = app_guid

    def validate(self):
        self.validate_required(self.view_name, 'view_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.view_name is not None:
            result['ViewName'] = self.view_name
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ViewName') is not None:
            self.view_name = m.get('ViewName')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        return self


class DeleteViewResponseTaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        content: str = None,
        status: str = None,
        next_task_id: str = None,
    ):
        self.task_id = task_id
        self.content = content
        self.status = status
        self.next_task_id = next_task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.status, 'status')
        self.validate_required(self.next_task_id, 'next_task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        return self


class DeleteViewResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: DeleteViewResponseTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_info, 'task_info')
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = DeleteViewResponseTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class CreateViewRequestViewColumn(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        comment: str = None,
    ):
        self.column_name = column_name
        self.comment = comment

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.comment is not None:
            result['Comment'] = self.comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        return self


class CreateViewRequest(TeaModel):
    def __init__(
        self,
        view_name: str = None,
        select_column: str = None,
        select_table_name: str = None,
        select_where: str = None,
        select_sql: str = None,
        app_guid: str = None,
        comment: str = None,
        view_column: List[CreateViewRequestViewColumn] = None,
        client_token: str = None,
    ):
        self.view_name = view_name
        self.select_column = select_column
        self.select_table_name = select_table_name
        self.select_where = select_where
        self.select_sql = select_sql
        self.app_guid = app_guid
        self.comment = comment
        self.view_column = view_column
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.view_name, 'view_name')
        self.validate_required(self.app_guid, 'app_guid')
        self.validate_required(self.view_column, 'view_column')
        if self.view_column:
            for k in self.view_column:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.view_name is not None:
            result['ViewName'] = self.view_name
        if self.select_column is not None:
            result['SelectColumn'] = self.select_column
        if self.select_table_name is not None:
            result['SelectTableName'] = self.select_table_name
        if self.select_where is not None:
            result['SelectWhere'] = self.select_where
        if self.select_sql is not None:
            result['SelectSQL'] = self.select_sql
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.comment is not None:
            result['Comment'] = self.comment
        result['ViewColumn'] = []
        if self.view_column is not None:
            for k in self.view_column:
                result['ViewColumn'].append(k.to_map() if k else None)
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ViewName') is not None:
            self.view_name = m.get('ViewName')
        if m.get('SelectColumn') is not None:
            self.select_column = m.get('SelectColumn')
        if m.get('SelectTableName') is not None:
            self.select_table_name = m.get('SelectTableName')
        if m.get('SelectWhere') is not None:
            self.select_where = m.get('SelectWhere')
        if m.get('SelectSQL') is not None:
            self.select_sql = m.get('SelectSQL')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        self.view_column = []
        if m.get('ViewColumn') is not None:
            for k in m.get('ViewColumn'):
                temp_model = CreateViewRequestViewColumn()
                self.view_column.append(temp_model.from_map(k))
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateViewResponseTaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        content: str = None,
        status: str = None,
        next_task_id: str = None,
    ):
        self.task_id = task_id
        self.content = content
        self.status = status
        self.next_task_id = next_task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.status, 'status')
        self.validate_required(self.next_task_id, 'next_task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        return self


class CreateViewResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: CreateViewResponseTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_info, 'task_info')
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = CreateViewResponseTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class CheckFileDeploymentRequest(TeaModel):
    def __init__(
        self,
        checker_instance_id: str = None,
        status: str = None,
        check_detail_url: str = None,
    ):
        self.checker_instance_id = checker_instance_id
        self.status = status
        self.check_detail_url = check_detail_url

    def validate(self):
        self.validate_required(self.checker_instance_id, 'checker_instance_id')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checker_instance_id is not None:
            result['CheckerInstanceId'] = self.checker_instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.check_detail_url is not None:
            result['CheckDetailUrl'] = self.check_detail_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckerInstanceId') is not None:
            self.checker_instance_id = m.get('CheckerInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CheckDetailUrl') is not None:
            self.check_detail_url = m.get('CheckDetailUrl')
        return self


class CheckFileDeploymentResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ImportDISyncTasksRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        task_content: str = None,
        task_param: str = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.task_content = task_content
        self.task_param = task_param

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.task_content, 'task_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_content is not None:
            result['TaskContent'] = self.task_content
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskContent') is not None:
            self.task_content = m.get('TaskContent')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        return self


class ImportDISyncTasksResponseTaskInfo(TeaModel):
    def __init__(
        self,
        task_id: int = None,
    ):
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ImportDISyncTasksResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        task_info: ImportDISyncTasksResponseTaskInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.task_info = task_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.task_info, 'task_info')
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskInfo') is not None:
            temp_model = ImportDISyncTasksResponseTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class ExportDISyncTasksRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        task_param: str = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.task_param = task_param

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.task_param, 'task_param')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        return self


class ExportDISyncTasksResponseTaskDetail(TeaModel):
    def __init__(
        self,
        real_time_solution: str = None,
    ):
        self.real_time_solution = real_time_solution

    def validate(self):
        self.validate_required(self.real_time_solution, 'real_time_solution')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.real_time_solution is not None:
            result['RealTimeSolution'] = self.real_time_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RealTimeSolution') is not None:
            self.real_time_solution = m.get('RealTimeSolution')
        return self


class ExportDISyncTasksResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        task_detail: ExportDISyncTasksResponseTaskDetail = None,
    ):
        self.request_id = request_id
        self.success = success
        self.task_detail = task_detail

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.task_detail, 'task_detail')
        if self.task_detail:
            self.task_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_detail is not None:
            result['TaskDetail'] = self.task_detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskDetail') is not None:
            temp_model = ExportDISyncTasksResponseTaskDetail()
            self.task_detail = temp_model.from_map(m['TaskDetail'])
        return self


class ListDISyncTasksRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_type, 'task_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListDISyncTasksResponseTaskListRealTimeSolutionList(TeaModel):
    def __init__(
        self,
        process_id: int = None,
        process_name: str = None,
        task_status: str = None,
        task_type: str = None,
        create_time: int = None,
    ):
        self.process_id = process_id
        self.process_name = process_name
        self.task_status = task_status
        self.task_type = task_type
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.process_id, 'process_id')
        self.validate_required(self.process_name, 'process_name')
        self.validate_required(self.task_status, 'task_status')
        self.validate_required(self.task_type, 'task_type')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class ListDISyncTasksResponseTaskList(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        real_time_solution_list: List[ListDISyncTasksResponseTaskListRealTimeSolutionList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.real_time_solution_list = real_time_solution_list

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.real_time_solution_list, 'real_time_solution_list')
        if self.real_time_solution_list:
            for k in self.real_time_solution_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['RealTimeSolutionList'] = []
        if self.real_time_solution_list is not None:
            for k in self.real_time_solution_list:
                result['RealTimeSolutionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.real_time_solution_list = []
        if m.get('RealTimeSolutionList') is not None:
            for k in m.get('RealTimeSolutionList'):
                temp_model = ListDISyncTasksResponseTaskListRealTimeSolutionList()
                self.real_time_solution_list.append(temp_model.from_map(k))
        return self


class ListDISyncTasksResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        task_list: ListDISyncTasksResponseTaskList = None,
    ):
        self.request_id = request_id
        self.success = success
        self.task_list = task_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.task_list, 'task_list')
        if self.task_list:
            self.task_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_list is not None:
            result['TaskList'] = self.task_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskList') is not None:
            temp_model = ListDISyncTasksResponseTaskList()
            self.task_list = temp_model.from_map(m['TaskList'])
        return self


class RevokeColumnPermissionRequest(TeaModel):
    def __init__(
        self,
        workspace_id: int = None,
        max_compute_project_name: str = None,
        table_name: str = None,
        columns: str = None,
        revoke_user_name: str = None,
        revoke_user_id: str = None,
    ):
        self.workspace_id = workspace_id
        self.max_compute_project_name = max_compute_project_name
        self.table_name = table_name
        self.columns = columns
        self.revoke_user_name = revoke_user_name
        self.revoke_user_id = revoke_user_id

    def validate(self):
        self.validate_required(self.workspace_id, 'workspace_id')
        self.validate_required(self.max_compute_project_name, 'max_compute_project_name')
        self.validate_required(self.table_name, 'table_name')
        self.validate_required(self.columns, 'columns')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.columns is not None:
            result['Columns'] = self.columns
        if self.revoke_user_name is not None:
            result['RevokeUserName'] = self.revoke_user_name
        if self.revoke_user_id is not None:
            result['RevokeUserId'] = self.revoke_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Columns') is not None:
            self.columns = m.get('Columns')
        if m.get('RevokeUserName') is not None:
            self.revoke_user_name = m.get('RevokeUserName')
        if m.get('RevokeUserId') is not None:
            self.revoke_user_id = m.get('RevokeUserId')
        return self


class RevokeColumnPermissionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        revoke_success: bool = None,
    ):
        self.request_id = request_id
        self.revoke_success = revoke_success

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.revoke_success, 'revoke_success')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.revoke_success is not None:
            result['RevokeSuccess'] = self.revoke_success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RevokeSuccess') is not None:
            self.revoke_success = m.get('RevokeSuccess')
        return self


class RevokeTablePermissionRequest(TeaModel):
    def __init__(
        self,
        workspace_id: int = None,
        max_compute_project_name: str = None,
        table_name: str = None,
        actions: str = None,
        revoke_user_name: str = None,
        revoke_user_id: str = None,
    ):
        self.workspace_id = workspace_id
        self.max_compute_project_name = max_compute_project_name
        self.table_name = table_name
        self.actions = actions
        self.revoke_user_name = revoke_user_name
        self.revoke_user_id = revoke_user_id

    def validate(self):
        self.validate_required(self.workspace_id, 'workspace_id')
        self.validate_required(self.max_compute_project_name, 'max_compute_project_name')
        self.validate_required(self.table_name, 'table_name')
        self.validate_required(self.actions, 'actions')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.actions is not None:
            result['Actions'] = self.actions
        if self.revoke_user_name is not None:
            result['RevokeUserName'] = self.revoke_user_name
        if self.revoke_user_id is not None:
            result['RevokeUserId'] = self.revoke_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Actions') is not None:
            self.actions = m.get('Actions')
        if m.get('RevokeUserName') is not None:
            self.revoke_user_name = m.get('RevokeUserName')
        if m.get('RevokeUserId') is not None:
            self.revoke_user_id = m.get('RevokeUserId')
        return self


class RevokeTablePermissionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        revoke_success: bool = None,
    ):
        self.request_id = request_id
        self.revoke_success = revoke_success

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.revoke_success, 'revoke_success')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.revoke_success is not None:
            result['RevokeSuccess'] = self.revoke_success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RevokeSuccess') is not None:
            self.revoke_success = m.get('RevokeSuccess')
        return self


class GetMetaTableThemeLevelRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.data_source_type = data_source_type

    def validate(self):
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.data_source_type, 'data_source_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableThemeLevelResponseEntityTheme(TeaModel):
    def __init__(
        self,
        theme_id: int = None,
        name: str = None,
        level: int = None,
        parent_id: int = None,
    ):
        self.theme_id = theme_id
        self.name = name
        self.level = level
        self.parent_id = parent_id

    def validate(self):
        self.validate_required(self.theme_id, 'theme_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.level, 'level')
        self.validate_required(self.parent_id, 'parent_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.name is not None:
            result['Name'] = self.name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class GetMetaTableThemeLevelResponseEntityLevel(TeaModel):
    def __init__(
        self,
        level_id: int = None,
        name: str = None,
        type: int = None,
        description: str = None,
    ):
        self.level_id = level_id
        self.name = name
        self.type = type
        self.description = description

    def validate(self):
        self.validate_required(self.level_id, 'level_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.description, 'description')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class GetMetaTableThemeLevelResponseEntity(TeaModel):
    def __init__(
        self,
        theme: List[GetMetaTableThemeLevelResponseEntityTheme] = None,
        level: List[GetMetaTableThemeLevelResponseEntityLevel] = None,
    ):
        self.theme = theme
        self.level = level

    def validate(self):
        self.validate_required(self.theme, 'theme')
        if self.theme:
            for k in self.theme:
                if k:
                    k.validate()
        self.validate_required(self.level, 'level')
        if self.level:
            for k in self.level:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Theme'] = []
        if self.theme is not None:
            for k in self.theme:
                result['Theme'].append(k.to_map() if k else None)
        result['Level'] = []
        if self.level is not None:
            for k in self.level:
                result['Level'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.theme = []
        if m.get('Theme') is not None:
            for k in m.get('Theme'):
                temp_model = GetMetaTableThemeLevelResponseEntityTheme()
                self.theme.append(temp_model.from_map(k))
        self.level = []
        if m.get('Level') is not None:
            for k in m.get('Level'):
                temp_model = GetMetaTableThemeLevelResponseEntityLevel()
                self.level.append(temp_model.from_map(k))
        return self


class GetMetaTableThemeLevelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        entity: GetMetaTableThemeLevelResponseEntity = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.entity = entity

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.entity, 'entity')
        if self.entity:
            self.entity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.entity is not None:
            result['Entity'] = self.entity.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Entity') is not None:
            temp_model = GetMetaTableThemeLevelResponseEntity()
            self.entity = temp_model.from_map(m['Entity'])
        return self


class GetPermissionApplyOrderDetailRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
    ):
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveAccountList(TeaModel):
    def __init__(
        self,
        base_id: str = None,
    ):
        self.base_id = base_id

    def validate(self):
        self.validate_required(self.base_id, 'base_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_id is not None:
            result['BaseId'] = self.base_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaseId') is not None:
            self.base_id = m.get('BaseId')
        return self


class GetPermissionApplyOrderDetailResponseApplyOrderDetailGranteeObjectList(TeaModel):
    def __init__(
        self,
        grantee_id: str = None,
        grantee_name: str = None,
        grantee_type: int = None,
        grantee_type_sub: int = None,
    ):
        self.grantee_id = grantee_id
        self.grantee_name = grantee_name
        self.grantee_type = grantee_type
        self.grantee_type_sub = grantee_type_sub

    def validate(self):
        self.validate_required(self.grantee_id, 'grantee_id')
        self.validate_required(self.grantee_name, 'grantee_name')
        self.validate_required(self.grantee_type, 'grantee_type')
        self.validate_required(self.grantee_type_sub, 'grantee_type_sub')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grantee_id is not None:
            result['GranteeId'] = self.grantee_id
        if self.grantee_name is not None:
            result['GranteeName'] = self.grantee_name
        if self.grantee_type is not None:
            result['GranteeType'] = self.grantee_type
        if self.grantee_type_sub is not None:
            result['GranteeTypeSub'] = self.grantee_type_sub
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GranteeId') is not None:
            self.grantee_id = m.get('GranteeId')
        if m.get('GranteeName') is not None:
            self.grantee_name = m.get('GranteeName')
        if m.get('GranteeType') is not None:
            self.grantee_type = m.get('GranteeType')
        if m.get('GranteeTypeSub') is not None:
            self.grantee_type_sub = m.get('GranteeTypeSub')
        return self


class GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList(TeaModel):
    def __init__(
        self,
        column_comment: str = None,
        column_name: str = None,
    ):
        self.column_comment = column_comment
        self.column_name = column_name

    def validate(self):
        self.validate_required(self.column_comment, 'column_comment')
        self.validate_required(self.column_name, 'column_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_comment is not None:
            result['ColumnComment'] = self.column_comment
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnComment') is not None:
            self.column_comment = m.get('ColumnComment')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        return self


class GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContentProjectMetaObjectMetaList(TeaModel):
    def __init__(
        self,
        object_name: str = None,
        column_meta_list: List[GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList] = None,
    ):
        self.object_name = object_name
        self.column_meta_list = column_meta_list

    def validate(self):
        self.validate_required(self.object_name, 'object_name')
        self.validate_required(self.column_meta_list, 'column_meta_list')
        if self.column_meta_list:
            for k in self.column_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_name is not None:
            result['ObjectName'] = self.object_name
        result['ColumnMetaList'] = []
        if self.column_meta_list is not None:
            for k in self.column_meta_list:
                result['ColumnMetaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ObjectName') is not None:
            self.object_name = m.get('ObjectName')
        self.column_meta_list = []
        if m.get('ColumnMetaList') is not None:
            for k in m.get('ColumnMetaList'):
                temp_model = GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList()
                self.column_meta_list.append(temp_model.from_map(k))
        return self


class GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContentProjectMeta(TeaModel):
    def __init__(
        self,
        workspace_id: int = None,
        max_compute_project_name: str = None,
        object_meta_list: List[GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContentProjectMetaObjectMetaList] = None,
    ):
        self.workspace_id = workspace_id
        self.max_compute_project_name = max_compute_project_name
        self.object_meta_list = object_meta_list

    def validate(self):
        self.validate_required(self.workspace_id, 'workspace_id')
        self.validate_required(self.max_compute_project_name, 'max_compute_project_name')
        self.validate_required(self.object_meta_list, 'object_meta_list')
        if self.object_meta_list:
            for k in self.object_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        result['ObjectMetaList'] = []
        if self.object_meta_list is not None:
            for k in self.object_meta_list:
                result['ObjectMetaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        self.object_meta_list = []
        if m.get('ObjectMetaList') is not None:
            for k in m.get('ObjectMetaList'):
                temp_model = GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContentProjectMetaObjectMetaList()
                self.object_meta_list.append(temp_model.from_map(k))
        return self


class GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContent(TeaModel):
    def __init__(
        self,
        apply_reason: str = None,
        deadline: int = None,
        order_type: int = None,
        project_meta: GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContentProjectMeta = None,
    ):
        self.apply_reason = apply_reason
        self.deadline = deadline
        self.order_type = order_type
        self.project_meta = project_meta

    def validate(self):
        self.validate_required(self.apply_reason, 'apply_reason')
        self.validate_required(self.deadline, 'deadline')
        self.validate_required(self.order_type, 'order_type')
        self.validate_required(self.project_meta, 'project_meta')
        if self.project_meta:
            self.project_meta.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.project_meta is not None:
            result['ProjectMeta'] = self.project_meta.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('ProjectMeta') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContentProjectMeta()
            self.project_meta = temp_model.from_map(m['ProjectMeta'])
        return self


class GetPermissionApplyOrderDetailResponseApplyOrderDetail(TeaModel):
    def __init__(
        self,
        apply_base_id: str = None,
        apply_timestamp: int = None,
        flow_id: str = None,
        flow_status: int = None,
        approve_account_list: List[GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveAccountList] = None,
        grantee_object_list: List[GetPermissionApplyOrderDetailResponseApplyOrderDetailGranteeObjectList] = None,
        approve_content: GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContent = None,
    ):
        self.apply_base_id = apply_base_id
        self.apply_timestamp = apply_timestamp
        self.flow_id = flow_id
        self.flow_status = flow_status
        self.approve_account_list = approve_account_list
        self.grantee_object_list = grantee_object_list
        self.approve_content = approve_content

    def validate(self):
        self.validate_required(self.apply_base_id, 'apply_base_id')
        self.validate_required(self.apply_timestamp, 'apply_timestamp')
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.flow_status, 'flow_status')
        self.validate_required(self.approve_account_list, 'approve_account_list')
        if self.approve_account_list:
            for k in self.approve_account_list:
                if k:
                    k.validate()
        self.validate_required(self.grantee_object_list, 'grantee_object_list')
        if self.grantee_object_list:
            for k in self.grantee_object_list:
                if k:
                    k.validate()
        self.validate_required(self.approve_content, 'approve_content')
        if self.approve_content:
            self.approve_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_base_id is not None:
            result['ApplyBaseId'] = self.apply_base_id
        if self.apply_timestamp is not None:
            result['ApplyTimestamp'] = self.apply_timestamp
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_status is not None:
            result['FlowStatus'] = self.flow_status
        result['ApproveAccountList'] = []
        if self.approve_account_list is not None:
            for k in self.approve_account_list:
                result['ApproveAccountList'].append(k.to_map() if k else None)
        result['GranteeObjectList'] = []
        if self.grantee_object_list is not None:
            for k in self.grantee_object_list:
                result['GranteeObjectList'].append(k.to_map() if k else None)
        if self.approve_content is not None:
            result['ApproveContent'] = self.approve_content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyBaseId') is not None:
            self.apply_base_id = m.get('ApplyBaseId')
        if m.get('ApplyTimestamp') is not None:
            self.apply_timestamp = m.get('ApplyTimestamp')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowStatus') is not None:
            self.flow_status = m.get('FlowStatus')
        self.approve_account_list = []
        if m.get('ApproveAccountList') is not None:
            for k in m.get('ApproveAccountList'):
                temp_model = GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveAccountList()
                self.approve_account_list.append(temp_model.from_map(k))
        self.grantee_object_list = []
        if m.get('GranteeObjectList') is not None:
            for k in m.get('GranteeObjectList'):
                temp_model = GetPermissionApplyOrderDetailResponseApplyOrderDetailGranteeObjectList()
                self.grantee_object_list.append(temp_model.from_map(k))
        if m.get('ApproveContent') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseApplyOrderDetailApproveContent()
            self.approve_content = temp_model.from_map(m['ApproveContent'])
        return self


class GetPermissionApplyOrderDetailResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        apply_order_detail: GetPermissionApplyOrderDetailResponseApplyOrderDetail = None,
    ):
        self.request_id = request_id
        self.apply_order_detail = apply_order_detail

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.apply_order_detail, 'apply_order_detail')
        if self.apply_order_detail:
            self.apply_order_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.apply_order_detail is not None:
            result['ApplyOrderDetail'] = self.apply_order_detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ApplyOrderDetail') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseApplyOrderDetail()
            self.apply_order_detail = temp_model.from_map(m['ApplyOrderDetail'])
        return self


class ListPermissionApplyOrdersRequest(TeaModel):
    def __init__(
        self,
        flow_status: int = None,
        workspace_id: int = None,
        order_type: int = None,
        max_compute_project_name: str = None,
        table_name: str = None,
        start_time: int = None,
        end_time: int = None,
        engine_type: str = None,
        page_num: int = None,
        page_size: int = None,
        query_type: int = None,
    ):
        self.flow_status = flow_status
        self.workspace_id = workspace_id
        self.order_type = order_type
        self.max_compute_project_name = max_compute_project_name
        self.table_name = table_name
        self.start_time = start_time
        self.end_time = end_time
        self.engine_type = engine_type
        self.page_num = page_num
        self.page_size = page_size
        self.query_type = query_type

    def validate(self):
        self.validate_required(self.order_type, 'order_type')
        self.validate_required(self.engine_type, 'engine_type')
        self.validate_required(self.query_type, 'query_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_status is not None:
            result['FlowStatus'] = self.flow_status
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.engine_type is not None:
            result['EngineType'] = self.engine_type
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_type is not None:
            result['QueryType'] = self.query_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowStatus') is not None:
            self.flow_status = m.get('FlowStatus')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EngineType') is not None:
            self.engine_type = m.get('EngineType')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryType') is not None:
            self.query_type = m.get('QueryType')
        return self


class ListPermissionApplyOrdersResponseApplyOrdersApplyOrderApproveContentProjectMetaObjectMetaList(TeaModel):
    def __init__(
        self,
        object_name: str = None,
        actions: List[str] = None,
    ):
        self.object_name = object_name
        self.actions = actions

    def validate(self):
        self.validate_required(self.object_name, 'object_name')
        self.validate_required(self.actions, 'actions')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_name is not None:
            result['ObjectName'] = self.object_name
        if self.actions is not None:
            result['Actions'] = self.actions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ObjectName') is not None:
            self.object_name = m.get('ObjectName')
        if m.get('Actions') is not None:
            self.actions = m.get('Actions')
        return self


class ListPermissionApplyOrdersResponseApplyOrdersApplyOrderApproveContentProjectMeta(TeaModel):
    def __init__(
        self,
        workspace_name: str = None,
        object_meta_list: List[ListPermissionApplyOrdersResponseApplyOrdersApplyOrderApproveContentProjectMetaObjectMetaList] = None,
    ):
        self.workspace_name = workspace_name
        self.object_meta_list = object_meta_list

    def validate(self):
        self.validate_required(self.workspace_name, 'workspace_name')
        self.validate_required(self.object_meta_list, 'object_meta_list')
        if self.object_meta_list:
            for k in self.object_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workspace_name is not None:
            result['WorkspaceName'] = self.workspace_name
        result['ObjectMetaList'] = []
        if self.object_meta_list is not None:
            for k in self.object_meta_list:
                result['ObjectMetaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkspaceName') is not None:
            self.workspace_name = m.get('WorkspaceName')
        self.object_meta_list = []
        if m.get('ObjectMetaList') is not None:
            for k in m.get('ObjectMetaList'):
                temp_model = ListPermissionApplyOrdersResponseApplyOrdersApplyOrderApproveContentProjectMetaObjectMetaList()
                self.object_meta_list.append(temp_model.from_map(k))
        return self


class ListPermissionApplyOrdersResponseApplyOrdersApplyOrderApproveContent(TeaModel):
    def __init__(
        self,
        apply_reason: str = None,
        order_type: int = None,
        project_meta: ListPermissionApplyOrdersResponseApplyOrdersApplyOrderApproveContentProjectMeta = None,
    ):
        self.apply_reason = apply_reason
        self.order_type = order_type
        self.project_meta = project_meta

    def validate(self):
        self.validate_required(self.apply_reason, 'apply_reason')
        self.validate_required(self.order_type, 'order_type')
        self.validate_required(self.project_meta, 'project_meta')
        if self.project_meta:
            self.project_meta.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.project_meta is not None:
            result['ProjectMeta'] = self.project_meta.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('ProjectMeta') is not None:
            temp_model = ListPermissionApplyOrdersResponseApplyOrdersApplyOrderApproveContentProjectMeta()
            self.project_meta = temp_model.from_map(m['ProjectMeta'])
        return self


class ListPermissionApplyOrdersResponseApplyOrdersApplyOrder(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
        apply_base_id: str = None,
        apply_timestamp: int = None,
        flow_status: int = None,
        approve_content: ListPermissionApplyOrdersResponseApplyOrdersApplyOrderApproveContent = None,
    ):
        self.flow_id = flow_id
        self.apply_base_id = apply_base_id
        self.apply_timestamp = apply_timestamp
        self.flow_status = flow_status
        self.approve_content = approve_content

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.apply_base_id, 'apply_base_id')
        self.validate_required(self.apply_timestamp, 'apply_timestamp')
        self.validate_required(self.flow_status, 'flow_status')
        self.validate_required(self.approve_content, 'approve_content')
        if self.approve_content:
            self.approve_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.apply_base_id is not None:
            result['ApplyBaseId'] = self.apply_base_id
        if self.apply_timestamp is not None:
            result['ApplyTimestamp'] = self.apply_timestamp
        if self.flow_status is not None:
            result['FlowStatus'] = self.flow_status
        if self.approve_content is not None:
            result['ApproveContent'] = self.approve_content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('ApplyBaseId') is not None:
            self.apply_base_id = m.get('ApplyBaseId')
        if m.get('ApplyTimestamp') is not None:
            self.apply_timestamp = m.get('ApplyTimestamp')
        if m.get('FlowStatus') is not None:
            self.flow_status = m.get('FlowStatus')
        if m.get('ApproveContent') is not None:
            temp_model = ListPermissionApplyOrdersResponseApplyOrdersApplyOrderApproveContent()
            self.approve_content = temp_model.from_map(m['ApproveContent'])
        return self


class ListPermissionApplyOrdersResponseApplyOrders(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        page_number: int = None,
        total_count: int = None,
        apply_order: List[ListPermissionApplyOrdersResponseApplyOrdersApplyOrder] = None,
    ):
        self.page_size = page_size
        self.page_number = page_number
        self.total_count = total_count
        self.apply_order = apply_order

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.apply_order, 'apply_order')
        if self.apply_order:
            for k in self.apply_order:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ApplyOrder'] = []
        if self.apply_order is not None:
            for k in self.apply_order:
                result['ApplyOrder'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.apply_order = []
        if m.get('ApplyOrder') is not None:
            for k in m.get('ApplyOrder'):
                temp_model = ListPermissionApplyOrdersResponseApplyOrdersApplyOrder()
                self.apply_order.append(temp_model.from_map(k))
        return self


class ListPermissionApplyOrdersResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        apply_orders: ListPermissionApplyOrdersResponseApplyOrders = None,
    ):
        self.request_id = request_id
        self.apply_orders = apply_orders

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.apply_orders, 'apply_orders')
        if self.apply_orders:
            self.apply_orders.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.apply_orders is not None:
            result['ApplyOrders'] = self.apply_orders.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ApplyOrders') is not None:
            temp_model = ListPermissionApplyOrdersResponseApplyOrders()
            self.apply_orders = temp_model.from_map(m['ApplyOrders'])
        return self


class CreatePermissionApplyOrderRequestApplyObjectColumnMetaList(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePermissionApplyOrderRequestApplyObject(TeaModel):
    def __init__(
        self,
        name: str = None,
        column_meta_list: List[CreatePermissionApplyOrderRequestApplyObjectColumnMetaList] = None,
        actions: str = None,
    ):
        self.name = name
        self.column_meta_list = column_meta_list
        self.actions = actions

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.column_meta_list, 'column_meta_list')
        if self.column_meta_list:
            for k in self.column_meta_list:
                if k:
                    k.validate()
        self.validate_required(self.actions, 'actions')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['ColumnMetaList'] = []
        if self.column_meta_list is not None:
            for k in self.column_meta_list:
                result['ColumnMetaList'].append(k.to_map() if k else None)
        if self.actions is not None:
            result['Actions'] = self.actions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.column_meta_list = []
        if m.get('ColumnMetaList') is not None:
            for k in m.get('ColumnMetaList'):
                temp_model = CreatePermissionApplyOrderRequestApplyObjectColumnMetaList()
                self.column_meta_list.append(temp_model.from_map(k))
        if m.get('Actions') is not None:
            self.actions = m.get('Actions')
        return self


class CreatePermissionApplyOrderRequest(TeaModel):
    def __init__(
        self,
        apply_user_ids: str = None,
        deadline: int = None,
        apply_reason: str = None,
        max_compute_project_name: str = None,
        workspace_id: int = None,
        order_type: int = None,
        engine_type: str = None,
        apply_object: List[CreatePermissionApplyOrderRequestApplyObject] = None,
    ):
        self.apply_user_ids = apply_user_ids
        self.deadline = deadline
        self.apply_reason = apply_reason
        self.max_compute_project_name = max_compute_project_name
        self.workspace_id = workspace_id
        self.order_type = order_type
        self.engine_type = engine_type
        self.apply_object = apply_object

    def validate(self):
        self.validate_required(self.apply_user_ids, 'apply_user_ids')
        self.validate_required(self.apply_reason, 'apply_reason')
        self.validate_required(self.max_compute_project_name, 'max_compute_project_name')
        self.validate_required(self.workspace_id, 'workspace_id')
        self.validate_required(self.apply_object, 'apply_object')
        if self.apply_object:
            for k in self.apply_object:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_user_ids is not None:
            result['ApplyUserIds'] = self.apply_user_ids
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.engine_type is not None:
            result['EngineType'] = self.engine_type
        result['ApplyObject'] = []
        if self.apply_object is not None:
            for k in self.apply_object:
                result['ApplyObject'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyUserIds') is not None:
            self.apply_user_ids = m.get('ApplyUserIds')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('EngineType') is not None:
            self.engine_type = m.get('EngineType')
        self.apply_object = []
        if m.get('ApplyObject') is not None:
            for k in m.get('ApplyObject'):
                temp_model = CreatePermissionApplyOrderRequestApplyObject()
                self.apply_object.append(temp_model.from_map(k))
        return self


class CreatePermissionApplyOrderResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        flow_id: List[str] = None,
    ):
        self.request_id = request_id
        self.flow_id = flow_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.flow_id, 'flow_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class ApprovePermissionApplyOrderRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
        approve_comment: str = None,
        approve_action: int = None,
    ):
        self.flow_id = flow_id
        self.approve_comment = approve_comment
        self.approve_action = approve_action

    def validate(self):
        self.validate_required(self.flow_id, 'flow_id')
        self.validate_required(self.approve_comment, 'approve_comment')
        self.validate_required(self.approve_action, 'approve_action')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.approve_comment is not None:
            result['ApproveComment'] = self.approve_comment
        if self.approve_action is not None:
            result['ApproveAction'] = self.approve_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('ApproveComment') is not None:
            self.approve_comment = m.get('ApproveComment')
        if m.get('ApproveAction') is not None:
            self.approve_action = m.get('ApproveAction')
        return self


class ApprovePermissionApplyOrderResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        approve_success: bool = None,
    ):
        self.request_id = request_id
        self.approve_success = approve_success

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.approve_success, 'approve_success')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.approve_success is not None:
            result['ApproveSuccess'] = self.approve_success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ApproveSuccess') is not None:
            self.approve_success = m.get('ApproveSuccess')
        return self


class ListSuccessInstanceAmountRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListSuccessInstanceAmountResponseInstanceStatusTrendTodayTrend(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: str = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.time_point, 'time_point')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class ListSuccessInstanceAmountResponseInstanceStatusTrendYesterdayTrend(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: str = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.time_point, 'time_point')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class ListSuccessInstanceAmountResponseInstanceStatusTrendAvgTrend(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: str = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.time_point, 'time_point')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class ListSuccessInstanceAmountResponseInstanceStatusTrend(TeaModel):
    def __init__(
        self,
        today_trend: List[ListSuccessInstanceAmountResponseInstanceStatusTrendTodayTrend] = None,
        yesterday_trend: List[ListSuccessInstanceAmountResponseInstanceStatusTrendYesterdayTrend] = None,
        avg_trend: List[ListSuccessInstanceAmountResponseInstanceStatusTrendAvgTrend] = None,
    ):
        self.today_trend = today_trend
        self.yesterday_trend = yesterday_trend
        self.avg_trend = avg_trend

    def validate(self):
        self.validate_required(self.today_trend, 'today_trend')
        if self.today_trend:
            for k in self.today_trend:
                if k:
                    k.validate()
        self.validate_required(self.yesterday_trend, 'yesterday_trend')
        if self.yesterday_trend:
            for k in self.yesterday_trend:
                if k:
                    k.validate()
        self.validate_required(self.avg_trend, 'avg_trend')
        if self.avg_trend:
            for k in self.avg_trend:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TodayTrend'] = []
        if self.today_trend is not None:
            for k in self.today_trend:
                result['TodayTrend'].append(k.to_map() if k else None)
        result['YesterdayTrend'] = []
        if self.yesterday_trend is not None:
            for k in self.yesterday_trend:
                result['YesterdayTrend'].append(k.to_map() if k else None)
        result['AvgTrend'] = []
        if self.avg_trend is not None:
            for k in self.avg_trend:
                result['AvgTrend'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.today_trend = []
        if m.get('TodayTrend') is not None:
            for k in m.get('TodayTrend'):
                temp_model = ListSuccessInstanceAmountResponseInstanceStatusTrendTodayTrend()
                self.today_trend.append(temp_model.from_map(k))
        self.yesterday_trend = []
        if m.get('YesterdayTrend') is not None:
            for k in m.get('YesterdayTrend'):
                temp_model = ListSuccessInstanceAmountResponseInstanceStatusTrendYesterdayTrend()
                self.yesterday_trend.append(temp_model.from_map(k))
        self.avg_trend = []
        if m.get('AvgTrend') is not None:
            for k in m.get('AvgTrend'):
                temp_model = ListSuccessInstanceAmountResponseInstanceStatusTrendAvgTrend()
                self.avg_trend.append(temp_model.from_map(k))
        return self


class ListSuccessInstanceAmountResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_status_trend: ListSuccessInstanceAmountResponseInstanceStatusTrend = None,
    ):
        self.request_id = request_id
        self.instance_status_trend = instance_status_trend

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_status_trend, 'instance_status_trend')
        if self.instance_status_trend:
            self.instance_status_trend.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_status_trend is not None:
            result['InstanceStatusTrend'] = self.instance_status_trend.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceStatusTrend') is not None:
            temp_model = ListSuccessInstanceAmountResponseInstanceStatusTrend()
            self.instance_status_trend = temp_model.from_map(m['InstanceStatusTrend'])
        return self


class ListFileTypeRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        page_number: int = None,
        page_size: int = None,
        keyword: str = None,
        locale: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.page_number = page_number
        self.page_size = page_size
        self.keyword = keyword
        self.locale = locale

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.locale is not None:
            result['Locale'] = self.locale
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Locale') is not None:
            self.locale = m.get('Locale')
        return self


class ListFileTypeResponseNodeTypeInfoListNodeTypeInfo(TeaModel):
    def __init__(
        self,
        node_type: int = None,
        node_type_name: str = None,
    ):
        self.node_type = node_type
        self.node_type_name = node_type_name

    def validate(self):
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.node_type_name, 'node_type_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.node_type_name is not None:
            result['NodeTypeName'] = self.node_type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('NodeTypeName') is not None:
            self.node_type_name = m.get('NodeTypeName')
        return self


class ListFileTypeResponseNodeTypeInfoList(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        node_type_info: List[ListFileTypeResponseNodeTypeInfoListNodeTypeInfo] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.node_type_info = node_type_info

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.node_type_info, 'node_type_info')
        if self.node_type_info:
            for k in self.node_type_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['NodeTypeInfo'] = []
        if self.node_type_info is not None:
            for k in self.node_type_info:
                result['NodeTypeInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.node_type_info = []
        if m.get('NodeTypeInfo') is not None:
            for k in m.get('NodeTypeInfo'):
                temp_model = ListFileTypeResponseNodeTypeInfoListNodeTypeInfo()
                self.node_type_info.append(temp_model.from_map(k))
        return self


class ListFileTypeResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        node_type_info_list: ListFileTypeResponseNodeTypeInfoList = None,
    ):
        self.request_id = request_id
        self.node_type_info_list = node_type_info_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.node_type_info_list, 'node_type_info_list')
        if self.node_type_info_list:
            self.node_type_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.node_type_info_list is not None:
            result['NodeTypeInfoList'] = self.node_type_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NodeTypeInfoList') is not None:
            temp_model = ListFileTypeResponseNodeTypeInfoList()
            self.node_type_info_list = temp_model.from_map(m['NodeTypeInfoList'])
        return self


class ListInstanceAmountRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        begin_date: str = None,
        end_date: str = None,
    ):
        self.project_id = project_id
        self.begin_date = begin_date
        self.end_date = end_date

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.begin_date, 'begin_date')
        self.validate_required(self.end_date, 'end_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.begin_date is not None:
            result['BeginDate'] = self.begin_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BeginDate') is not None:
            self.begin_date = m.get('BeginDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class ListInstanceAmountResponseInstanceCounts(TeaModel):
    def __init__(
        self,
        date: int = None,
        count: int = None,
    ):
        self.date = date
        self.count = count

    def validate(self):
        self.validate_required(self.date, 'date')
        self.validate_required(self.count, 'count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class ListInstanceAmountResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_counts: List[ListInstanceAmountResponseInstanceCounts] = None,
    ):
        self.request_id = request_id
        self.instance_counts = instance_counts

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_counts, 'instance_counts')
        if self.instance_counts:
            for k in self.instance_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['InstanceCounts'] = []
        if self.instance_counts is not None:
            for k in self.instance_counts:
                result['InstanceCounts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.instance_counts = []
        if m.get('InstanceCounts') is not None:
            for k in m.get('InstanceCounts'):
                temp_model = ListInstanceAmountResponseInstanceCounts()
                self.instance_counts.append(temp_model.from_map(k))
        return self


class ListDataSourcesRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        data_source_type: str = None,
        sub_type: str = None,
        status: str = None,
        env_type: int = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.data_source_type = data_source_type
        self.sub_type = sub_type
        self.status = status
        self.env_type = env_type
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.status is not None:
            result['Status'] = self.status
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ListDataSourcesResponseDataDataSources(TeaModel):
    def __init__(
        self,
        shared: bool = None,
        gmt_modified: str = None,
        connect_status: int = None,
        binding_calc_engine_id: int = None,
        description: str = None,
        data_source_type: str = None,
        gmt_create: str = None,
        default_engine: bool = None,
        operator: str = None,
        sequence: int = None,
        env_type: int = None,
        tenant_id: int = None,
        name: str = None,
        sub_type: str = None,
        id: int = None,
        project_id: int = None,
        status: int = None,
        content: str = None,
    ):
        self.shared = shared
        self.gmt_modified = gmt_modified
        self.connect_status = connect_status
        self.binding_calc_engine_id = binding_calc_engine_id
        self.description = description
        self.data_source_type = data_source_type
        self.gmt_create = gmt_create
        self.default_engine = default_engine
        self.operator = operator
        self.sequence = sequence
        self.env_type = env_type
        self.tenant_id = tenant_id
        self.name = name
        self.sub_type = sub_type
        self.id = id
        self.project_id = project_id
        self.status = status
        self.content = content

    def validate(self):
        self.validate_required(self.shared, 'shared')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.connect_status, 'connect_status')
        self.validate_required(self.binding_calc_engine_id, 'binding_calc_engine_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.data_source_type, 'data_source_type')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.default_engine, 'default_engine')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.sequence, 'sequence')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.sub_type, 'sub_type')
        self.validate_required(self.id, 'id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.content, 'content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.name is not None:
            result['Name'] = self.name
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.id is not None:
            result['Id'] = self.id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class ListDataSourcesResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_sources: List[ListDataSourcesResponseDataDataSources] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_sources = data_sources

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data_sources, 'data_sources')
        if self.data_sources:
            for k in self.data_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataSources'] = []
        if self.data_sources is not None:
            for k in self.data_sources:
                result['DataSources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_sources = []
        if m.get('DataSources') is not None:
            for k in m.get('DataSources'):
                temp_model = ListDataSourcesResponseDataDataSources()
                self.data_sources.append(temp_model.from_map(k))
        return self


class ListDataSourcesResponse(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        success: bool = None,
        request_id: str = None,
        data: ListDataSourcesResponseData = None,
    ):
        self.http_status_code = http_status_code
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListDataSourcesResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListNodesByBaselineRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
    ):
        self.baseline_id = baseline_id

    def validate(self):
        self.validate_required(self.baseline_id, 'baseline_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class ListNodesByBaselineResponseData(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListNodesByBaselineResponse(TeaModel):
    def __init__(
        self,
        success: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: List[ListNodesByBaselineResponseData] = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListNodesByBaselineResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class ListManualDagInstancesRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        project_name: str = None,
        dag_id: str = None,
    ):
        self.project_env = project_env
        self.project_name = project_name
        self.dag_id = dag_id

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.dag_id, 'dag_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        return self


class ListManualDagInstancesResponseInstances(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        instance_id: int = None,
        dag_id: int = None,
        dag_type: str = None,
        status: str = None,
        biz_date: int = None,
        cyc_time: int = None,
        create_time: int = None,
        modify_time: int = None,
        node_name: str = None,
        begin_wait_time_time: int = None,
        begin_wait_res_time: int = None,
        begin_running_time: int = None,
        param_values: str = None,
        finish_time: int = None,
        task_type: str = None,
    ):
        self.node_id = node_id
        self.instance_id = instance_id
        self.dag_id = dag_id
        self.dag_type = dag_type
        self.status = status
        self.biz_date = biz_date
        self.cyc_time = cyc_time
        self.create_time = create_time
        self.modify_time = modify_time
        self.node_name = node_name
        self.begin_wait_time_time = begin_wait_time_time
        self.begin_wait_res_time = begin_wait_res_time
        self.begin_running_time = begin_running_time
        self.param_values = param_values
        self.finish_time = finish_time
        self.task_type = task_type

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.dag_id, 'dag_id')
        self.validate_required(self.dag_type, 'dag_type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.biz_date, 'biz_date')
        self.validate_required(self.cyc_time, 'cyc_time')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modify_time, 'modify_time')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.begin_wait_time_time, 'begin_wait_time_time')
        self.validate_required(self.begin_wait_res_time, 'begin_wait_res_time')
        self.validate_required(self.begin_running_time, 'begin_running_time')
        self.validate_required(self.param_values, 'param_values')
        self.validate_required(self.finish_time, 'finish_time')
        self.validate_required(self.task_type, 'task_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.status is not None:
            result['Status'] = self.status
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class ListManualDagInstancesResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instances: List[ListManualDagInstancesResponseInstances] = None,
    ):
        self.request_id = request_id
        self.instances = instances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = ListManualDagInstancesResponseInstances()
                self.instances.append(temp_model.from_map(k))
        return self


class GetInstanceStatusStatisticRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_env: str = None,
        biz_date: str = None,
    ):
        self.project_id = project_id
        self.project_env = project_env
        self.biz_date = biz_date

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.biz_date, 'biz_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        return self


class GetInstanceStatusStatisticResponseStatusCount(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        not_run_count: int = None,
        wait_time_count: int = None,
        wait_res_count: int = None,
        running_count: int = None,
        failure_count: int = None,
        success_count: int = None,
    ):
        self.total_count = total_count
        self.not_run_count = not_run_count
        self.wait_time_count = wait_time_count
        self.wait_res_count = wait_res_count
        self.running_count = running_count
        self.failure_count = failure_count
        self.success_count = success_count

    def validate(self):
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.not_run_count, 'not_run_count')
        self.validate_required(self.wait_time_count, 'wait_time_count')
        self.validate_required(self.wait_res_count, 'wait_res_count')
        self.validate_required(self.running_count, 'running_count')
        self.validate_required(self.failure_count, 'failure_count')
        self.validate_required(self.success_count, 'success_count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class GetInstanceStatusStatisticResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status_count: GetInstanceStatusStatisticResponseStatusCount = None,
    ):
        self.request_id = request_id
        self.status_count = status_count

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.status_count, 'status_count')
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusStatisticResponseStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class DeleteDataSourceRequest(TeaModel):
    def __init__(
        self,
        data_source_id: int = None,
    ):
        self.data_source_id = data_source_id

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        return self


class DeleteDataSourceResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: str = None,
        data: bool = None,
        request_id: str = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataSourceRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        description: str = None,
        data_source_type: str = None,
        sub_type: str = None,
        env_type: int = None,
        content: str = None,
    ):
        self.project_id = project_id
        self.name = name
        self.description = description
        self.data_source_type = data_source_type
        self.sub_type = sub_type
        self.env_type = env_type
        self.content = content

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.data_source_type, 'data_source_type')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.content, 'content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateDataSourceResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: str = None,
        data: int = None,
        request_id: str = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class TopTenErrorTimesInstanceRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class TopTenErrorTimesInstanceResponseInstanceErrorRankErrorRank(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        count: int = None,
        project_id: int = None,
        program_type: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.count = count
        self.project_id = project_id
        self.program_type = program_type

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.count, 'count')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.program_type, 'program_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.count is not None:
            result['Count'] = self.count
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        return self


class TopTenErrorTimesInstanceResponseInstanceErrorRank(TeaModel):
    def __init__(
        self,
        update_time: int = None,
        error_rank: List[TopTenErrorTimesInstanceResponseInstanceErrorRankErrorRank] = None,
    ):
        self.update_time = update_time
        self.error_rank = error_rank

    def validate(self):
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.error_rank, 'error_rank')
        if self.error_rank:
            for k in self.error_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['ErrorRank'] = []
        if self.error_rank is not None:
            for k in self.error_rank:
                result['ErrorRank'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.error_rank = []
        if m.get('ErrorRank') is not None:
            for k in m.get('ErrorRank'):
                temp_model = TopTenErrorTimesInstanceResponseInstanceErrorRankErrorRank()
                self.error_rank.append(temp_model.from_map(k))
        return self


class TopTenErrorTimesInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_error_rank: TopTenErrorTimesInstanceResponseInstanceErrorRank = None,
    ):
        self.request_id = request_id
        self.instance_error_rank = instance_error_rank

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_error_rank, 'instance_error_rank')
        if self.instance_error_rank:
            self.instance_error_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_error_rank is not None:
            result['InstanceErrorRank'] = self.instance_error_rank.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceErrorRank') is not None:
            temp_model = TopTenErrorTimesInstanceResponseInstanceErrorRank()
            self.instance_error_rank = temp_model.from_map(m['InstanceErrorRank'])
        return self


class TopTenElapsedTimeInstanceRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class TopTenElapsedTimeInstanceResponseInstanceConsumeTimeRankConsumeTimeRank(TeaModel):
    def __init__(
        self,
        node_name: str = None,
        node_id: int = None,
        business_date: int = None,
        owner: str = None,
        consumed: int = None,
        instance_id: int = None,
        program_type: int = None,
    ):
        self.node_name = node_name
        self.node_id = node_id
        self.business_date = business_date
        self.owner = owner
        self.consumed = consumed
        self.instance_id = instance_id
        self.program_type = program_type

    def validate(self):
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.business_date, 'business_date')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.consumed, 'consumed')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.program_type, 'program_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.business_date is not None:
            result['BusinessDate'] = self.business_date
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.consumed is not None:
            result['Consumed'] = self.consumed
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('BusinessDate') is not None:
            self.business_date = m.get('BusinessDate')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Consumed') is not None:
            self.consumed = m.get('Consumed')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        return self


class TopTenElapsedTimeInstanceResponseInstanceConsumeTimeRank(TeaModel):
    def __init__(
        self,
        update_time: int = None,
        consume_time_rank: List[TopTenElapsedTimeInstanceResponseInstanceConsumeTimeRankConsumeTimeRank] = None,
    ):
        self.update_time = update_time
        self.consume_time_rank = consume_time_rank

    def validate(self):
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.consume_time_rank, 'consume_time_rank')
        if self.consume_time_rank:
            for k in self.consume_time_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['ConsumeTimeRank'] = []
        if self.consume_time_rank is not None:
            for k in self.consume_time_rank:
                result['ConsumeTimeRank'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.consume_time_rank = []
        if m.get('ConsumeTimeRank') is not None:
            for k in m.get('ConsumeTimeRank'):
                temp_model = TopTenElapsedTimeInstanceResponseInstanceConsumeTimeRankConsumeTimeRank()
                self.consume_time_rank.append(temp_model.from_map(k))
        return self


class TopTenElapsedTimeInstanceResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_consume_time_rank: TopTenElapsedTimeInstanceResponseInstanceConsumeTimeRank = None,
    ):
        self.request_id = request_id
        self.instance_consume_time_rank = instance_consume_time_rank

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_consume_time_rank, 'instance_consume_time_rank')
        if self.instance_consume_time_rank:
            self.instance_consume_time_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_consume_time_rank is not None:
            result['InstanceConsumeTimeRank'] = self.instance_consume_time_rank.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceConsumeTimeRank') is not None:
            temp_model = TopTenElapsedTimeInstanceResponseInstanceConsumeTimeRank()
            self.instance_consume_time_rank = temp_model.from_map(m['InstanceConsumeTimeRank'])
        return self


class GetProjectRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetProjectResponseData(TeaModel):
    def __init__(
        self,
        gmt_modified: str = None,
        max_flow_node: int = None,
        default_di_resource_group_identifier: str = None,
        destination: int = None,
        is_allow_download: int = None,
        prod_storage_quota: str = None,
        scheduler_retry_interval: int = None,
        resident_area: str = None,
        table_privacy_mode: int = None,
        project_owner_base_id: str = None,
        use_proxy_odps_account: bool = None,
        disable_development: bool = None,
        project_mode: int = None,
        gmt_create: str = None,
        dev_storage_quota: str = None,
        is_default: int = None,
        protected_mode: int = None,
        base_project: bool = None,
        tenant_id: int = None,
        project_description: str = None,
        appkey: str = None,
        scheduler_max_retry_times: int = None,
        project_name: str = None,
        project_identifier: str = None,
        project_id: int = None,
        status: int = None,
        development_type: int = None,
        env_types: List[str] = None,
    ):
        self.gmt_modified = gmt_modified
        self.max_flow_node = max_flow_node
        self.default_di_resource_group_identifier = default_di_resource_group_identifier
        self.destination = destination
        self.is_allow_download = is_allow_download
        self.prod_storage_quota = prod_storage_quota
        self.scheduler_retry_interval = scheduler_retry_interval
        self.resident_area = resident_area
        self.table_privacy_mode = table_privacy_mode
        self.project_owner_base_id = project_owner_base_id
        self.use_proxy_odps_account = use_proxy_odps_account
        self.disable_development = disable_development
        self.project_mode = project_mode
        self.gmt_create = gmt_create
        self.dev_storage_quota = dev_storage_quota
        self.is_default = is_default
        self.protected_mode = protected_mode
        self.base_project = base_project
        self.tenant_id = tenant_id
        self.project_description = project_description
        self.appkey = appkey
        self.scheduler_max_retry_times = scheduler_max_retry_times
        self.project_name = project_name
        self.project_identifier = project_identifier
        self.project_id = project_id
        self.status = status
        self.development_type = development_type
        self.env_types = env_types

    def validate(self):
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.max_flow_node, 'max_flow_node')
        self.validate_required(self.default_di_resource_group_identifier, 'default_di_resource_group_identifier')
        self.validate_required(self.destination, 'destination')
        self.validate_required(self.is_allow_download, 'is_allow_download')
        self.validate_required(self.prod_storage_quota, 'prod_storage_quota')
        self.validate_required(self.scheduler_retry_interval, 'scheduler_retry_interval')
        self.validate_required(self.resident_area, 'resident_area')
        self.validate_required(self.table_privacy_mode, 'table_privacy_mode')
        self.validate_required(self.project_owner_base_id, 'project_owner_base_id')
        self.validate_required(self.use_proxy_odps_account, 'use_proxy_odps_account')
        self.validate_required(self.disable_development, 'disable_development')
        self.validate_required(self.project_mode, 'project_mode')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.dev_storage_quota, 'dev_storage_quota')
        self.validate_required(self.is_default, 'is_default')
        self.validate_required(self.protected_mode, 'protected_mode')
        self.validate_required(self.base_project, 'base_project')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_description, 'project_description')
        self.validate_required(self.appkey, 'appkey')
        self.validate_required(self.scheduler_max_retry_times, 'scheduler_max_retry_times')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.project_identifier, 'project_identifier')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.development_type, 'development_type')
        self.validate_required(self.env_types, 'env_types')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.max_flow_node is not None:
            result['MaxFlowNode'] = self.max_flow_node
        if self.default_di_resource_group_identifier is not None:
            result['DefaultDiResourceGroupIdentifier'] = self.default_di_resource_group_identifier
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.is_allow_download is not None:
            result['IsAllowDownload'] = self.is_allow_download
        if self.prod_storage_quota is not None:
            result['ProdStorageQuota'] = self.prod_storage_quota
        if self.scheduler_retry_interval is not None:
            result['SchedulerRetryInterval'] = self.scheduler_retry_interval
        if self.resident_area is not None:
            result['ResidentArea'] = self.resident_area
        if self.table_privacy_mode is not None:
            result['TablePrivacyMode'] = self.table_privacy_mode
        if self.project_owner_base_id is not None:
            result['ProjectOwnerBaseId'] = self.project_owner_base_id
        if self.use_proxy_odps_account is not None:
            result['UseProxyOdpsAccount'] = self.use_proxy_odps_account
        if self.disable_development is not None:
            result['DisableDevelopment'] = self.disable_development
        if self.project_mode is not None:
            result['ProjectMode'] = self.project_mode
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.dev_storage_quota is not None:
            result['DevStorageQuota'] = self.dev_storage_quota
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.protected_mode is not None:
            result['ProtectedMode'] = self.protected_mode
        if self.base_project is not None:
            result['BaseProject'] = self.base_project
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_description is not None:
            result['ProjectDescription'] = self.project_description
        if self.appkey is not None:
            result['Appkey'] = self.appkey
        if self.scheduler_max_retry_times is not None:
            result['SchedulerMaxRetryTimes'] = self.scheduler_max_retry_times
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.development_type is not None:
            result['DevelopmentType'] = self.development_type
        if self.env_types is not None:
            result['EnvTypes'] = self.env_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MaxFlowNode') is not None:
            self.max_flow_node = m.get('MaxFlowNode')
        if m.get('DefaultDiResourceGroupIdentifier') is not None:
            self.default_di_resource_group_identifier = m.get('DefaultDiResourceGroupIdentifier')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('IsAllowDownload') is not None:
            self.is_allow_download = m.get('IsAllowDownload')
        if m.get('ProdStorageQuota') is not None:
            self.prod_storage_quota = m.get('ProdStorageQuota')
        if m.get('SchedulerRetryInterval') is not None:
            self.scheduler_retry_interval = m.get('SchedulerRetryInterval')
        if m.get('ResidentArea') is not None:
            self.resident_area = m.get('ResidentArea')
        if m.get('TablePrivacyMode') is not None:
            self.table_privacy_mode = m.get('TablePrivacyMode')
        if m.get('ProjectOwnerBaseId') is not None:
            self.project_owner_base_id = m.get('ProjectOwnerBaseId')
        if m.get('UseProxyOdpsAccount') is not None:
            self.use_proxy_odps_account = m.get('UseProxyOdpsAccount')
        if m.get('DisableDevelopment') is not None:
            self.disable_development = m.get('DisableDevelopment')
        if m.get('ProjectMode') is not None:
            self.project_mode = m.get('ProjectMode')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DevStorageQuota') is not None:
            self.dev_storage_quota = m.get('DevStorageQuota')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ProtectedMode') is not None:
            self.protected_mode = m.get('ProtectedMode')
        if m.get('BaseProject') is not None:
            self.base_project = m.get('BaseProject')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectDescription') is not None:
            self.project_description = m.get('ProjectDescription')
        if m.get('Appkey') is not None:
            self.appkey = m.get('Appkey')
        if m.get('SchedulerMaxRetryTimes') is not None:
            self.scheduler_max_retry_times = m.get('SchedulerMaxRetryTimes')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DevelopmentType') is not None:
            self.development_type = m.get('DevelopmentType')
        if m.get('EnvTypes') is not None:
            self.env_types = m.get('EnvTypes')
        return self


class GetProjectResponse(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        success: bool = None,
        request_id: str = None,
        data: GetProjectResponseData = None,
    ):
        self.http_status_code = http_status_code
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetProjectResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListNodesByOutputRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        outputs: str = None,
    ):
        self.project_env = project_env
        self.outputs = outputs

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.outputs, 'outputs')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.outputs is not None:
            result['Outputs'] = self.outputs
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('Outputs') is not None:
            self.outputs = m.get('Outputs')
        return self


class ListNodesByOutputResponseDataNodeList(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        owner_id: str = None,
        description: str = None,
        res_group_name: str = None,
        cron_express: str = None,
        repeatability: bool = None,
        program_type: str = None,
        project_id: int = None,
        scheduler_type: str = None,
        param_values: str = None,
        priority: int = None,
        baseline_id: int = None,
        repeat_interval: int = None,
        connection: str = None,
        dqc_type: int = None,
        dqc_description: str = None,
        related_flow_id: int = None,
        file_type: str = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.owner_id = owner_id
        self.description = description
        self.res_group_name = res_group_name
        self.cron_express = cron_express
        self.repeatability = repeatability
        self.program_type = program_type
        self.project_id = project_id
        self.scheduler_type = scheduler_type
        self.param_values = param_values
        self.priority = priority
        self.baseline_id = baseline_id
        self.repeat_interval = repeat_interval
        self.connection = connection
        self.dqc_type = dqc_type
        self.dqc_description = dqc_description
        self.related_flow_id = related_flow_id
        self.file_type = file_type

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.res_group_name, 'res_group_name')
        self.validate_required(self.cron_express, 'cron_express')
        self.validate_required(self.repeatability, 'repeatability')
        self.validate_required(self.program_type, 'program_type')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.scheduler_type, 'scheduler_type')
        self.validate_required(self.param_values, 'param_values')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.baseline_id, 'baseline_id')
        self.validate_required(self.repeat_interval, 'repeat_interval')
        self.validate_required(self.connection, 'connection')
        self.validate_required(self.dqc_type, 'dqc_type')
        self.validate_required(self.dqc_description, 'dqc_description')
        self.validate_required(self.related_flow_id, 'related_flow_id')
        self.validate_required(self.file_type, 'file_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.description is not None:
            result['Description'] = self.description
        if self.res_group_name is not None:
            result['ResGroupName'] = self.res_group_name
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.file_type is not None:
            result['FileType'] = self.file_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResGroupName') is not None:
            self.res_group_name = m.get('ResGroupName')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        return self


class ListNodesByOutputResponseData(TeaModel):
    def __init__(
        self,
        output: str = None,
        node_list: List[ListNodesByOutputResponseDataNodeList] = None,
    ):
        self.output = output
        self.node_list = node_list

    def validate(self):
        self.validate_required(self.output, 'output')
        self.validate_required(self.node_list, 'node_list')
        if self.node_list:
            for k in self.node_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output
        result['NodeList'] = []
        if self.node_list is not None:
            for k in self.node_list:
                result['NodeList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Output') is not None:
            self.output = m.get('Output')
        self.node_list = []
        if m.get('NodeList') is not None:
            for k in m.get('NodeList'):
                temp_model = ListNodesByOutputResponseDataNodeList()
                self.node_list.append(temp_model.from_map(k))
        return self


class ListNodesByOutputResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: int = None,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        data: List[ListNodesByOutputResponseData] = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListNodesByOutputResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class GetFileTypeStatisticRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_env: str = None,
    ):
        self.project_id = project_id
        self.project_env = project_env

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.project_env, 'project_env')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetFileTypeStatisticResponseProgramTypeAndCounts(TeaModel):
    def __init__(
        self,
        program_type: str = None,
        count: int = None,
    ):
        self.program_type = program_type
        self.count = count

    def validate(self):
        self.validate_required(self.program_type, 'program_type')
        self.validate_required(self.count, 'count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetFileTypeStatisticResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        program_type_and_counts: List[GetFileTypeStatisticResponseProgramTypeAndCounts] = None,
    ):
        self.request_id = request_id
        self.program_type_and_counts = program_type_and_counts

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.program_type_and_counts, 'program_type_and_counts')
        if self.program_type_and_counts:
            for k in self.program_type_and_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ProgramTypeAndCounts'] = []
        if self.program_type_and_counts is not None:
            for k in self.program_type_and_counts:
                result['ProgramTypeAndCounts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.program_type_and_counts = []
        if m.get('ProgramTypeAndCounts') is not None:
            for k in m.get('ProgramTypeAndCounts'):
                temp_model = GetFileTypeStatisticResponseProgramTypeAndCounts()
                self.program_type_and_counts.append(temp_model.from_map(k))
        return self


class RunSmokeTestRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        bizdate: str = None,
        name: str = None,
        node_id: int = None,
        node_params: str = None,
    ):
        self.project_env = project_env
        self.bizdate = bizdate
        self.name = name
        self.node_id = node_id
        self.node_params = node_params

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.bizdate, 'bizdate')
        self.validate_required(self.name, 'name')
        self.validate_required(self.node_id, 'node_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        return self


class RunSmokeTestResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ListNodeInputOrOutputRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
        io_type: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env
        self.io_type = io_type

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.io_type, 'io_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.io_type is not None:
            result['IoType'] = self.io_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('IoType') is not None:
            self.io_type = m.get('IoType')
        return self


class ListNodeInputOrOutputResponseData(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        data: str = None,
        node_id: int = None,
    ):
        self.table_name = table_name
        self.data = data
        self.node_id = node_id

    def validate(self):
        self.validate_required(self.table_name, 'table_name')
        self.validate_required(self.data, 'data')
        self.validate_required(self.node_id, 'node_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data is not None:
            result['Data'] = self.data
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class ListNodeInputOrOutputResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: List[ListNodeInputOrOutputResponseData] = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListNodeInputOrOutputResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class RunCycleDagNodesRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        start_biz_date: str = None,
        name: str = None,
        root_node_id: int = None,
        exclude_node_ids: str = None,
        biz_begin_time: str = None,
        biz_end_time: str = None,
        parallelism: bool = None,
        end_biz_date: str = None,
        node_params: str = None,
        include_node_ids: str = None,
    ):
        self.project_env = project_env
        self.start_biz_date = start_biz_date
        self.name = name
        self.root_node_id = root_node_id
        self.exclude_node_ids = exclude_node_ids
        self.biz_begin_time = biz_begin_time
        self.biz_end_time = biz_end_time
        self.parallelism = parallelism
        self.end_biz_date = end_biz_date
        self.node_params = node_params
        self.include_node_ids = include_node_ids

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.start_biz_date, 'start_biz_date')
        self.validate_required(self.name, 'name')
        self.validate_required(self.root_node_id, 'root_node_id')
        self.validate_required(self.parallelism, 'parallelism')
        self.validate_required(self.end_biz_date, 'end_biz_date')
        self.validate_required(self.include_node_ids, 'include_node_ids')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.start_biz_date is not None:
            result['StartBizDate'] = self.start_biz_date
        if self.name is not None:
            result['Name'] = self.name
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        if self.biz_begin_time is not None:
            result['BizBeginTime'] = self.biz_begin_time
        if self.biz_end_time is not None:
            result['BizEndTime'] = self.biz_end_time
        if self.parallelism is not None:
            result['Parallelism'] = self.parallelism
        if self.end_biz_date is not None:
            result['EndBizDate'] = self.end_biz_date
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('StartBizDate') is not None:
            self.start_biz_date = m.get('StartBizDate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        if m.get('BizBeginTime') is not None:
            self.biz_begin_time = m.get('BizBeginTime')
        if m.get('BizEndTime') is not None:
            self.biz_end_time = m.get('BizEndTime')
        if m.get('Parallelism') is not None:
            self.parallelism = m.get('Parallelism')
        if m.get('EndBizDate') is not None:
            self.end_biz_date = m.get('EndBizDate')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        return self


class RunCycleDagNodesResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: List[int] = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class RunManualDagNodesRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        project_name: str = None,
        flow_name: str = None,
        biz_date: str = None,
        node_parameters: str = None,
        dag_parameters: str = None,
        include_node_ids: str = None,
        exclude_node_ids: str = None,
        project_id: int = None,
    ):
        self.project_env = project_env
        self.project_name = project_name
        self.flow_name = flow_name
        self.biz_date = biz_date
        self.node_parameters = node_parameters
        self.dag_parameters = dag_parameters
        self.include_node_ids = include_node_ids
        self.exclude_node_ids = exclude_node_ids
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.flow_name, 'flow_name')
        self.validate_required(self.biz_date, 'biz_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.node_parameters is not None:
            result['NodeParameters'] = self.node_parameters
        if self.dag_parameters is not None:
            result['DagParameters'] = self.dag_parameters
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('NodeParameters') is not None:
            self.node_parameters = m.get('NodeParameters')
        if m.get('DagParameters') is not None:
            self.dag_parameters = m.get('DagParameters')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class RunManualDagNodesResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dag_id: int = None,
    ):
        self.request_id = request_id
        self.dag_id = dag_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dag_id, 'dag_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        return self


class UpdateDataSourceRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        env_type: int = None,
        content: str = None,
        status: str = None,
        data_source_id: int = None,
    ):
        self.description = description
        self.env_type = env_type
        self.content = content
        self.status = status
        self.data_source_id = data_source_id

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.content is not None:
            result['Content'] = self.content
        if self.status is not None:
            result['Status'] = self.status
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        return self


class UpdateDataSourceResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: str = None,
        data: bool = None,
        request_id: str = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateTableAddColumnRequestColumn(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_name_cn: str = None,
        column_type: str = None,
        comment: str = None,
    ):
        self.column_name = column_name
        self.column_name_cn = column_name_cn
        self.column_type = column_type
        self.comment = comment

    def validate(self):
        self.validate_required(self.column_name, 'column_name')
        self.validate_required(self.column_type, 'column_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_name_cn is not None:
            result['ColumnNameCn'] = self.column_name_cn
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.comment is not None:
            result['Comment'] = self.comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnNameCn') is not None:
            self.column_name_cn = m.get('ColumnNameCn')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        return self


class UpdateTableAddColumnRequest(TeaModel):
    def __init__(
        self,
        column: List[UpdateTableAddColumnRequestColumn] = None,
        table_guid: str = None,
    ):
        self.column = column
        self.table_guid = table_guid

    def validate(self):
        self.validate_required(self.column, 'column')
        if self.column:
            for k in self.column:
                if k:
                    k.validate()
        self.validate_required(self.table_guid, 'table_guid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Column'] = []
        if self.column is not None:
            for k in self.column:
                result['Column'].append(k.to_map() if k else None)
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.column = []
        if m.get('Column') is not None:
            for k in m.get('Column'):
                temp_model = UpdateTableAddColumnRequestColumn()
                self.column.append(temp_model.from_map(k))
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class UpdateTableAddColumnResponseTaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        content: str = None,
        status: str = None,
        next_task_id: str = None,
    ):
        self.task_id = task_id
        self.content = content
        self.status = status
        self.next_task_id = next_task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.status, 'status')
        self.validate_required(self.next_task_id, 'next_task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        return self


class UpdateTableAddColumnResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: UpdateTableAddColumnResponseTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_info, 'task_info')
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = UpdateTableAddColumnResponseTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class GetMigrationProcessRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        migration_id: int = None,
    ):
        self.project_id = project_id
        self.migration_id = migration_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.migration_id, 'migration_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.migration_id is not None:
            result['MigrationId'] = self.migration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('MigrationId') is not None:
            self.migration_id = m.get('MigrationId')
        return self


class GetMigrationProcessResponseData(TeaModel):
    def __init__(
        self,
        task_name: str = None,
        task_status: str = None,
    ):
        self.task_name = task_name
        self.task_status = task_status

    def validate(self):
        self.validate_required(self.task_name, 'task_name')
        self.validate_required(self.task_status, 'task_status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class GetMigrationProcessResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: List[GetMigrationProcessResponseData] = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetMigrationProcessResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class CreateImportMigrationRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        package_type: str = None,
        package_file: str = None,
        resource_group_map: str = None,
        workspace_map: str = None,
        calculate_engine_map: str = None,
        commit_rule: str = None,
        description: str = None,
    ):
        self.project_id = project_id
        self.name = name
        self.package_type = package_type
        self.package_file = package_file
        self.resource_group_map = resource_group_map
        self.workspace_map = workspace_map
        self.calculate_engine_map = calculate_engine_map
        self.commit_rule = commit_rule
        self.description = description

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.package_type, 'package_type')
        self.validate_required(self.package_file, 'package_file')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_file is not None:
            result['PackageFile'] = self.package_file
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageFile') is not None:
            self.package_file = m.get('PackageFile')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateImportMigrationResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateImportMigrationAdvanceRequest(TeaModel):
    def __init__(
        self,
        package_file_object: BinaryIO = None,
        project_id: int = None,
        name: str = None,
        package_type: str = None,
        resource_group_map: str = None,
        workspace_map: str = None,
        calculate_engine_map: str = None,
        commit_rule: str = None,
        description: str = None,
    ):
        self.package_file_object = package_file_object
        self.project_id = project_id
        self.name = name
        self.package_type = package_type
        self.resource_group_map = resource_group_map
        self.workspace_map = workspace_map
        self.calculate_engine_map = calculate_engine_map
        self.commit_rule = commit_rule
        self.description = description

    def validate(self):
        self.validate_required(self.package_file_object, 'package_file_object')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.package_type, 'package_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_file_object is not None:
            result['PackageFileObject'] = self.package_file_object
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackageFileObject') is not None:
            self.package_file_object = m.get('PackageFileObject')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class StartMigrationRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        migration_id: int = None,
    ):
        self.project_id = project_id
        self.migration_id = migration_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.migration_id, 'migration_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.migration_id is not None:
            result['MigrationId'] = self.migration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('MigrationId') is not None:
            self.migration_id = m.get('MigrationId')
        return self


class StartMigrationResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: bool = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class GetNodeParentsRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        node_id: int = None,
    ):
        self.project_env = project_env
        self.node_id = node_id

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.node_id, 'node_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeParentsResponseDataNodes(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        cron_express: str = None,
        scheduler_type: str = None,
        program_type: str = None,
        owner_id: str = None,
        project_id: int = None,
        repeatability: bool = None,
        priority: int = None,
        baseline_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.cron_express = cron_express
        self.scheduler_type = scheduler_type
        self.program_type = program_type
        self.owner_id = owner_id
        self.project_id = project_id
        self.repeatability = repeatability
        self.priority = priority
        self.baseline_id = baseline_id

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.cron_express, 'cron_express')
        self.validate_required(self.scheduler_type, 'scheduler_type')
        self.validate_required(self.program_type, 'program_type')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.repeatability, 'repeatability')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.baseline_id, 'baseline_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetNodeParentsResponseData(TeaModel):
    def __init__(
        self,
        nodes: List[GetNodeParentsResponseDataNodes] = None,
    ):
        self.nodes = nodes

    def validate(self):
        self.validate_required(self.nodes, 'nodes')
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetNodeParentsResponseDataNodes()
                self.nodes.append(temp_model.from_map(k))
        return self


class GetNodeParentsResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: int = None,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        data: GetNodeParentsResponseData = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetNodeParentsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeChildrenRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        node_id: int = None,
    ):
        self.project_env = project_env
        self.node_id = node_id

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.node_id, 'node_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeChildrenResponseDataNodes(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        cron_express: str = None,
        scheduler_type: str = None,
        program_type: str = None,
        owner_id: str = None,
        project_id: int = None,
        repeatability: bool = None,
        priority: int = None,
        baseline_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.cron_express = cron_express
        self.scheduler_type = scheduler_type
        self.program_type = program_type
        self.owner_id = owner_id
        self.project_id = project_id
        self.repeatability = repeatability
        self.priority = priority
        self.baseline_id = baseline_id

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.cron_express, 'cron_express')
        self.validate_required(self.scheduler_type, 'scheduler_type')
        self.validate_required(self.program_type, 'program_type')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.repeatability, 'repeatability')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.baseline_id, 'baseline_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetNodeChildrenResponseData(TeaModel):
    def __init__(
        self,
        nodes: List[GetNodeChildrenResponseDataNodes] = None,
    ):
        self.nodes = nodes

    def validate(self):
        self.validate_required(self.nodes, 'nodes')
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetNodeChildrenResponseDataNodes()
                self.nodes.append(temp_model.from_map(k))
        return self


class GetNodeChildrenResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: int = None,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        data: GetNodeChildrenResponseData = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetNodeChildrenResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSensitiveDataRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        page_no: int = None,
        name: str = None,
    ):
        self.page_size = page_size
        self.page_no = page_no
        self.name = name

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetSensitiveDataResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sensitive_data: Dict[str, Any] = None,
    ):
        self.request_id = request_id
        self.sensitive_data = sensitive_data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.sensitive_data, 'sensitive_data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sensitive_data is not None:
            result['SensitiveData'] = self.sensitive_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SensitiveData') is not None:
            self.sensitive_data = m.get('SensitiveData')
        return self


class DesensitizeDataRequest(TeaModel):
    def __init__(
        self,
        data: str = None,
        scene_code: str = None,
    ):
        self.data = data
        self.scene_code = scene_code

    def validate(self):
        self.validate_required(self.data, 'data')
        self.validate_required(self.scene_code, 'scene_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.scene_code is not None:
            result['SceneCode'] = self.scene_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('SceneCode') is not None:
            self.scene_code = m.get('SceneCode')
        return self


class DesensitizeDataResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        desensitize_data: str = None,
    ):
        self.request_id = request_id
        self.desensitize_data = desensitize_data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.desensitize_data, 'desensitize_data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.desensitize_data is not None:
            result['DesensitizeData'] = self.desensitize_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DesensitizeData') is not None:
            self.desensitize_data = m.get('DesensitizeData')
        return self


class GetOpRiskDataRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        page_no: int = None,
        name: str = None,
        date: str = None,
        risk_type: str = None,
    ):
        self.page_size = page_size
        self.page_no = page_no
        self.name = name
        self.date = date
        self.risk_type = risk_type

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.date, 'date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.name is not None:
            result['Name'] = self.name
        if self.date is not None:
            result['Date'] = self.date
        if self.risk_type is not None:
            result['RiskType'] = self.risk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('RiskType') is not None:
            self.risk_type = m.get('RiskType')
        return self


class GetOpRiskDataResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        risk_data: str = None,
    ):
        self.request_id = request_id
        self.risk_data = risk_data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.risk_data, 'risk_data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_data is not None:
            result['RiskData'] = self.risk_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskData') is not None:
            self.risk_data = m.get('RiskData')
        return self


class ScanSensitiveDataRequest(TeaModel):
    def __init__(
        self,
        data: str = None,
    ):
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ScanSensitiveDataResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sensitives: Dict[str, Any] = None,
    ):
        self.request_id = request_id
        self.sensitives = sensitives

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.sensitives, 'sensitives')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sensitives is not None:
            result['Sensitives'] = self.sensitives
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Sensitives') is not None:
            self.sensitives = m.get('Sensitives')
        return self


class GetOpSensitiveDataRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        page_size: int = None,
        page_no: int = None,
        date: str = None,
        op_type: str = None,
    ):
        self.name = name
        self.page_size = page_size
        self.page_no = page_no
        self.date = date
        self.op_type = op_type

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.date, 'date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.date is not None:
            result['Date'] = self.date
        if self.op_type is not None:
            result['OpType'] = self.op_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('OpType') is not None:
            self.op_type = m.get('OpType')
        return self


class GetOpSensitiveDataResponse(TeaModel):
    def __init__(
        self,
        op_sensitive_data: str = None,
        request_id: str = None,
    ):
        self.op_sensitive_data = op_sensitive_data
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.op_sensitive_data, 'op_sensitive_data')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.op_sensitive_data is not None:
            result['OpSensitiveData'] = self.op_sensitive_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpSensitiveData') is not None:
            self.op_sensitive_data = m.get('OpSensitiveData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBusinessRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        business_name: str = None,
        description: str = None,
        owner: str = None,
        use_type: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.business_name = business_name
        self.description = description
        self.owner = owner
        self.use_type = use_type

    def validate(self):
        self.validate_required(self.business_name, 'business_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class CreateBusinessResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        business_id: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.business_id = business_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.business_id, 'business_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        return self


class RunTriggerNodeRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        cycle_time: int = None,
        biz_date: int = None,
        app_id: int = None,
    ):
        self.node_id = node_id
        self.cycle_time = cycle_time
        self.biz_date = biz_date
        self.app_id = app_id

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.cycle_time, 'cycle_time')
        self.validate_required(self.biz_date, 'biz_date')
        self.validate_required(self.app_id, 'app_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.cycle_time is not None:
            result['CycleTime'] = self.cycle_time
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('CycleTime') is not None:
            self.cycle_time = m.get('CycleTime')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class RunTriggerNodeResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.success = success

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDagRequest(TeaModel):
    def __init__(
        self,
        dag_id: int = None,
        project_env: str = None,
    ):
        self.dag_id = dag_id
        self.project_env = project_env

    def validate(self):
        self.validate_required(self.dag_id, 'dag_id')
        self.validate_required(self.project_env, 'project_env')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetDagResponseData(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        dag_id: int = None,
        name: str = None,
        type: str = None,
        status: str = None,
        bizdate: int = None,
        gmtdate: int = None,
        start_time: int = None,
        finish_time: int = None,
        create_time: int = None,
        create_user: str = None,
        modify_time: int = None,
    ):
        self.project_id = project_id
        self.dag_id = dag_id
        self.name = name
        self.type = type
        self.status = status
        self.bizdate = bizdate
        self.gmtdate = gmtdate
        self.start_time = start_time
        self.finish_time = finish_time
        self.create_time = create_time
        self.create_user = create_user
        self.modify_time = modify_time

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.dag_id, 'dag_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.bizdate, 'bizdate')
        self.validate_required(self.gmtdate, 'gmtdate')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.finish_time, 'finish_time')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.create_user, 'create_user')
        self.validate_required(self.modify_time, 'modify_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.gmtdate is not None:
            result['Gmtdate'] = self.gmtdate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Gmtdate') is not None:
            self.gmtdate = m.get('Gmtdate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class GetDagResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: int = None,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        data: GetDagResponseData = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDagResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class SearchNodesByOutputRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        outputs: str = None,
    ):
        self.project_env = project_env
        self.outputs = outputs

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.outputs, 'outputs')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.outputs is not None:
            result['Outputs'] = self.outputs
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('Outputs') is not None:
            self.outputs = m.get('Outputs')
        return self


class SearchNodesByOutputResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: int = None,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        data: Dict[str, Any] = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class GetManualDagInstancesRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        project_name: str = None,
        dag_id: str = None,
    ):
        self.project_env = project_env
        self.project_name = project_name
        self.dag_id = dag_id

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.dag_id, 'dag_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        return self


class GetManualDagInstancesResponseInstances(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        instance_id: int = None,
        dag_id: int = None,
        dag_type: str = None,
        status: str = None,
        biz_date: int = None,
        cyc_time: int = None,
        create_time: int = None,
        modify_time: int = None,
        node_name: str = None,
        begin_wait_time_time: int = None,
        begin_wait_res_time: int = None,
        begin_running_time: int = None,
        param_values: str = None,
        finish_time: int = None,
        task_type: str = None,
    ):
        self.node_id = node_id
        self.instance_id = instance_id
        self.dag_id = dag_id
        self.dag_type = dag_type
        self.status = status
        self.biz_date = biz_date
        self.cyc_time = cyc_time
        self.create_time = create_time
        self.modify_time = modify_time
        self.node_name = node_name
        self.begin_wait_time_time = begin_wait_time_time
        self.begin_wait_res_time = begin_wait_res_time
        self.begin_running_time = begin_running_time
        self.param_values = param_values
        self.finish_time = finish_time
        self.task_type = task_type

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.dag_id, 'dag_id')
        self.validate_required(self.dag_type, 'dag_type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.biz_date, 'biz_date')
        self.validate_required(self.cyc_time, 'cyc_time')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modify_time, 'modify_time')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.begin_wait_time_time, 'begin_wait_time_time')
        self.validate_required(self.begin_wait_res_time, 'begin_wait_res_time')
        self.validate_required(self.begin_running_time, 'begin_running_time')
        self.validate_required(self.param_values, 'param_values')
        self.validate_required(self.finish_time, 'finish_time')
        self.validate_required(self.task_type, 'task_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.status is not None:
            result['Status'] = self.status
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetManualDagInstancesResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instances: List[GetManualDagInstancesResponseInstances] = None,
    ):
        self.request_id = request_id
        self.instances = instances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = GetManualDagInstancesResponseInstances()
                self.instances.append(temp_model.from_map(k))
        return self


class CreateManualDagRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        project_name: str = None,
        flow_name: str = None,
        biz_date: str = None,
        node_parameters: str = None,
        dag_parameters: str = None,
        include_node_ids: str = None,
        exclude_node_ids: str = None,
    ):
        self.project_env = project_env
        self.project_name = project_name
        self.flow_name = flow_name
        self.biz_date = biz_date
        self.node_parameters = node_parameters
        self.dag_parameters = dag_parameters
        self.include_node_ids = include_node_ids
        self.exclude_node_ids = exclude_node_ids

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.flow_name, 'flow_name')
        self.validate_required(self.biz_date, 'biz_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.node_parameters is not None:
            result['NodeParameters'] = self.node_parameters
        if self.dag_parameters is not None:
            result['DagParameters'] = self.dag_parameters
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('NodeParameters') is not None:
            self.node_parameters = m.get('NodeParameters')
        if m.get('DagParameters') is not None:
            self.dag_parameters = m.get('DagParameters')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        return self


class CreateManualDagResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dag_id: int = None,
    ):
        self.request_id = request_id
        self.dag_id = dag_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dag_id, 'dag_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        return self


class ListQualityResultsByEntityRequest(TeaModel):
    def __init__(
        self,
        entity_id: int = None,
        start_date: str = None,
        end_date: str = None,
        page_size: int = None,
        page_number: int = None,
        project_name: str = None,
    ):
        self.entity_id = entity_id
        self.start_date = start_date
        self.end_date = end_date
        self.page_size = page_size
        self.page_number = page_number
        self.project_name = project_name

    def validate(self):
        self.validate_required(self.entity_id, 'entity_id')
        self.validate_required(self.start_date, 'start_date')
        self.validate_required(self.end_date, 'end_date')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.project_name, 'project_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class ListQualityResultsByEntityResponseDataRuleChecksReferenceValue(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        discrete_property: str = None,
        value: float = None,
        threshold: float = None,
        single_check_result: int = None,
    ):
        self.biz_date = biz_date
        self.discrete_property = discrete_property
        self.value = value
        self.threshold = threshold
        self.single_check_result = single_check_result

    def validate(self):
        self.validate_required(self.biz_date, 'biz_date')
        self.validate_required(self.discrete_property, 'discrete_property')
        self.validate_required(self.value, 'value')
        self.validate_required(self.threshold, 'threshold')
        self.validate_required(self.single_check_result, 'single_check_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.discrete_property is not None:
            result['DiscreteProperty'] = self.discrete_property
        if self.value is not None:
            result['Value'] = self.value
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.single_check_result is not None:
            result['SingleCheckResult'] = self.single_check_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DiscreteProperty') is not None:
            self.discrete_property = m.get('DiscreteProperty')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('SingleCheckResult') is not None:
            self.single_check_result = m.get('SingleCheckResult')
        return self


class ListQualityResultsByEntityResponseDataRuleChecksSampleValue(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        discrete_property: str = None,
        value: float = None,
    ):
        self.biz_date = biz_date
        self.discrete_property = discrete_property
        self.value = value

    def validate(self):
        self.validate_required(self.biz_date, 'biz_date')
        self.validate_required(self.discrete_property, 'discrete_property')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.discrete_property is not None:
            result['DiscreteProperty'] = self.discrete_property
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DiscreteProperty') is not None:
            self.discrete_property = m.get('DiscreteProperty')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListQualityResultsByEntityResponseDataRuleChecks(TeaModel):
    def __init__(
        self,
        id: int = None,
        task_id: str = None,
        entity_id: int = None,
        rule_id: int = None,
        property: str = None,
        biz_date: int = None,
        date_type: str = None,
        actual_expression: str = None,
        match_expression: str = None,
        block_type: int = None,
        check_result: int = None,
        check_result_status: int = None,
        method_name: str = None,
        comment: str = None,
        where_condition: str = None,
        begin_time: int = None,
        end_time: int = None,
        time_cost: str = None,
        external_type: str = None,
        external_id: str = None,
        discrete_check: bool = None,
        fixed_check: bool = None,
        trend: str = None,
        warning_threshold: float = None,
        critical_threshold: float = None,
        expect_value: float = None,
        op: str = None,
        project_name: str = None,
        table_name: str = None,
        template_id: int = None,
        template_name: str = None,
        result_string: str = None,
        checker_id: int = None,
        checker_type: int = None,
        rule_name: str = None,
        is_prediction: bool = None,
        upper_value: float = None,
        lower_value: float = None,
        checker_name: str = None,
        reference_value: List[ListQualityResultsByEntityResponseDataRuleChecksReferenceValue] = None,
        sample_value: List[ListQualityResultsByEntityResponseDataRuleChecksSampleValue] = None,
    ):
        self.id = id
        self.task_id = task_id
        self.entity_id = entity_id
        self.rule_id = rule_id
        self.property = property
        self.biz_date = biz_date
        self.date_type = date_type
        self.actual_expression = actual_expression
        self.match_expression = match_expression
        self.block_type = block_type
        self.check_result = check_result
        self.check_result_status = check_result_status
        self.method_name = method_name
        self.comment = comment
        self.where_condition = where_condition
        self.begin_time = begin_time
        self.end_time = end_time
        self.time_cost = time_cost
        self.external_type = external_type
        self.external_id = external_id
        self.discrete_check = discrete_check
        self.fixed_check = fixed_check
        self.trend = trend
        self.warning_threshold = warning_threshold
        self.critical_threshold = critical_threshold
        self.expect_value = expect_value
        self.op = op
        self.project_name = project_name
        self.table_name = table_name
        self.template_id = template_id
        self.template_name = template_name
        self.result_string = result_string
        self.checker_id = checker_id
        self.checker_type = checker_type
        self.rule_name = rule_name
        self.is_prediction = is_prediction
        self.upper_value = upper_value
        self.lower_value = lower_value
        self.checker_name = checker_name
        self.reference_value = reference_value
        self.sample_value = sample_value

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.entity_id, 'entity_id')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.property, 'property')
        self.validate_required(self.biz_date, 'biz_date')
        self.validate_required(self.date_type, 'date_type')
        self.validate_required(self.actual_expression, 'actual_expression')
        self.validate_required(self.match_expression, 'match_expression')
        self.validate_required(self.block_type, 'block_type')
        self.validate_required(self.check_result, 'check_result')
        self.validate_required(self.check_result_status, 'check_result_status')
        self.validate_required(self.method_name, 'method_name')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.where_condition, 'where_condition')
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.time_cost, 'time_cost')
        self.validate_required(self.external_type, 'external_type')
        self.validate_required(self.external_id, 'external_id')
        self.validate_required(self.discrete_check, 'discrete_check')
        self.validate_required(self.fixed_check, 'fixed_check')
        self.validate_required(self.trend, 'trend')
        self.validate_required(self.warning_threshold, 'warning_threshold')
        self.validate_required(self.critical_threshold, 'critical_threshold')
        self.validate_required(self.expect_value, 'expect_value')
        self.validate_required(self.op, 'op')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.table_name, 'table_name')
        self.validate_required(self.template_id, 'template_id')
        self.validate_required(self.template_name, 'template_name')
        self.validate_required(self.result_string, 'result_string')
        self.validate_required(self.checker_id, 'checker_id')
        self.validate_required(self.checker_type, 'checker_type')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.is_prediction, 'is_prediction')
        self.validate_required(self.upper_value, 'upper_value')
        self.validate_required(self.lower_value, 'lower_value')
        self.validate_required(self.checker_name, 'checker_name')
        self.validate_required(self.reference_value, 'reference_value')
        if self.reference_value:
            for k in self.reference_value:
                if k:
                    k.validate()
        self.validate_required(self.sample_value, 'sample_value')
        if self.sample_value:
            for k in self.sample_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.property is not None:
            result['Property'] = self.property
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.date_type is not None:
            result['DateType'] = self.date_type
        if self.actual_expression is not None:
            result['ActualExpression'] = self.actual_expression
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.block_type is not None:
            result['BlockType'] = self.block_type
        if self.check_result is not None:
            result['CheckResult'] = self.check_result
        if self.check_result_status is not None:
            result['CheckResultStatus'] = self.check_result_status
        if self.method_name is not None:
            result['MethodName'] = self.method_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.where_condition is not None:
            result['WhereCondition'] = self.where_condition
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.time_cost is not None:
            result['TimeCost'] = self.time_cost
        if self.external_type is not None:
            result['ExternalType'] = self.external_type
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.discrete_check is not None:
            result['DiscreteCheck'] = self.discrete_check
        if self.fixed_check is not None:
            result['FixedCheck'] = self.fixed_check
        if self.trend is not None:
            result['Trend'] = self.trend
        if self.warning_threshold is not None:
            result['WarningThreshold'] = self.warning_threshold
        if self.critical_threshold is not None:
            result['CriticalThreshold'] = self.critical_threshold
        if self.expect_value is not None:
            result['ExpectValue'] = self.expect_value
        if self.op is not None:
            result['Op'] = self.op
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.result_string is not None:
            result['ResultString'] = self.result_string
        if self.checker_id is not None:
            result['CheckerId'] = self.checker_id
        if self.checker_type is not None:
            result['CheckerType'] = self.checker_type
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.is_prediction is not None:
            result['IsPrediction'] = self.is_prediction
        if self.upper_value is not None:
            result['UpperValue'] = self.upper_value
        if self.lower_value is not None:
            result['LowerValue'] = self.lower_value
        if self.checker_name is not None:
            result['CheckerName'] = self.checker_name
        result['ReferenceValue'] = []
        if self.reference_value is not None:
            for k in self.reference_value:
                result['ReferenceValue'].append(k.to_map() if k else None)
        result['SampleValue'] = []
        if self.sample_value is not None:
            for k in self.sample_value:
                result['SampleValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DateType') is not None:
            self.date_type = m.get('DateType')
        if m.get('ActualExpression') is not None:
            self.actual_expression = m.get('ActualExpression')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('BlockType') is not None:
            self.block_type = m.get('BlockType')
        if m.get('CheckResult') is not None:
            self.check_result = m.get('CheckResult')
        if m.get('CheckResultStatus') is not None:
            self.check_result_status = m.get('CheckResultStatus')
        if m.get('MethodName') is not None:
            self.method_name = m.get('MethodName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('WhereCondition') is not None:
            self.where_condition = m.get('WhereCondition')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TimeCost') is not None:
            self.time_cost = m.get('TimeCost')
        if m.get('ExternalType') is not None:
            self.external_type = m.get('ExternalType')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('DiscreteCheck') is not None:
            self.discrete_check = m.get('DiscreteCheck')
        if m.get('FixedCheck') is not None:
            self.fixed_check = m.get('FixedCheck')
        if m.get('Trend') is not None:
            self.trend = m.get('Trend')
        if m.get('WarningThreshold') is not None:
            self.warning_threshold = m.get('WarningThreshold')
        if m.get('CriticalThreshold') is not None:
            self.critical_threshold = m.get('CriticalThreshold')
        if m.get('ExpectValue') is not None:
            self.expect_value = m.get('ExpectValue')
        if m.get('Op') is not None:
            self.op = m.get('Op')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('ResultString') is not None:
            self.result_string = m.get('ResultString')
        if m.get('CheckerId') is not None:
            self.checker_id = m.get('CheckerId')
        if m.get('CheckerType') is not None:
            self.checker_type = m.get('CheckerType')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('IsPrediction') is not None:
            self.is_prediction = m.get('IsPrediction')
        if m.get('UpperValue') is not None:
            self.upper_value = m.get('UpperValue')
        if m.get('LowerValue') is not None:
            self.lower_value = m.get('LowerValue')
        if m.get('CheckerName') is not None:
            self.checker_name = m.get('CheckerName')
        self.reference_value = []
        if m.get('ReferenceValue') is not None:
            for k in m.get('ReferenceValue'):
                temp_model = ListQualityResultsByEntityResponseDataRuleChecksReferenceValue()
                self.reference_value.append(temp_model.from_map(k))
        self.sample_value = []
        if m.get('SampleValue') is not None:
            for k in m.get('SampleValue'):
                temp_model = ListQualityResultsByEntityResponseDataRuleChecksSampleValue()
                self.sample_value.append(temp_model.from_map(k))
        return self


class ListQualityResultsByEntityResponseData(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_number: int = None,
        page_size: int = None,
        rule_checks: List[ListQualityResultsByEntityResponseDataRuleChecks] = None,
    ):
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.rule_checks = rule_checks

    def validate(self):
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.rule_checks, 'rule_checks')
        if self.rule_checks:
            for k in self.rule_checks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['RuleChecks'] = []
        if self.rule_checks is not None:
            for k in self.rule_checks:
                result['RuleChecks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.rule_checks = []
        if m.get('RuleChecks') is not None:
            for k in m.get('RuleChecks'):
                temp_model = ListQualityResultsByEntityResponseDataRuleChecks()
                self.rule_checks.append(temp_model.from_map(k))
        return self


class ListQualityResultsByEntityResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        http_status_code: int = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: ListQualityResultsByEntityResponseData = None,
    ):
        self.request_id = request_id
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListQualityResultsByEntityResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeTypeListInfoRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        page_number: int = None,
        page_size: int = None,
        keyword: str = None,
        locale: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.page_number = page_number
        self.page_size = page_size
        self.keyword = keyword
        self.locale = locale

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.locale is not None:
            result['Locale'] = self.locale
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Locale') is not None:
            self.locale = m.get('Locale')
        return self


class GetNodeTypeListInfoResponseNodeTypeInfoListNodeTypeInfo(TeaModel):
    def __init__(
        self,
        node_type: int = None,
        node_type_name: str = None,
    ):
        self.node_type = node_type
        self.node_type_name = node_type_name

    def validate(self):
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.node_type_name, 'node_type_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.node_type_name is not None:
            result['NodeTypeName'] = self.node_type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('NodeTypeName') is not None:
            self.node_type_name = m.get('NodeTypeName')
        return self


class GetNodeTypeListInfoResponseNodeTypeInfoList(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        node_type_info: List[GetNodeTypeListInfoResponseNodeTypeInfoListNodeTypeInfo] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.node_type_info = node_type_info

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.node_type_info, 'node_type_info')
        if self.node_type_info:
            for k in self.node_type_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['NodeTypeInfo'] = []
        if self.node_type_info is not None:
            for k in self.node_type_info:
                result['NodeTypeInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.node_type_info = []
        if m.get('NodeTypeInfo') is not None:
            for k in m.get('NodeTypeInfo'):
                temp_model = GetNodeTypeListInfoResponseNodeTypeInfoListNodeTypeInfo()
                self.node_type_info.append(temp_model.from_map(k))
        return self


class GetNodeTypeListInfoResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        node_type_info_list: GetNodeTypeListInfoResponseNodeTypeInfoList = None,
    ):
        self.request_id = request_id
        self.node_type_info_list = node_type_info_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.node_type_info_list, 'node_type_info_list')
        if self.node_type_info_list:
            self.node_type_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.node_type_info_list is not None:
            result['NodeTypeInfoList'] = self.node_type_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NodeTypeInfoList') is not None:
            temp_model = GetNodeTypeListInfoResponseNodeTypeInfoList()
            self.node_type_info_list = temp_model.from_map(m['NodeTypeInfoList'])
        return self


class GetInstanceStatusCountRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_env: str = None,
        biz_date: str = None,
    ):
        self.project_id = project_id
        self.project_env = project_env
        self.biz_date = biz_date

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.biz_date, 'biz_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        return self


class GetInstanceStatusCountResponseStatusCount(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        not_run_count: int = None,
        wait_time_count: int = None,
        wait_res_count: int = None,
        running_count: int = None,
        failure_count: int = None,
        success_count: int = None,
    ):
        self.total_count = total_count
        self.not_run_count = not_run_count
        self.wait_time_count = wait_time_count
        self.wait_res_count = wait_res_count
        self.running_count = running_count
        self.failure_count = failure_count
        self.success_count = success_count

    def validate(self):
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.not_run_count, 'not_run_count')
        self.validate_required(self.wait_time_count, 'wait_time_count')
        self.validate_required(self.wait_res_count, 'wait_res_count')
        self.validate_required(self.running_count, 'running_count')
        self.validate_required(self.failure_count, 'failure_count')
        self.validate_required(self.success_count, 'success_count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class GetInstanceStatusCountResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status_count: GetInstanceStatusCountResponseStatusCount = None,
    ):
        self.request_id = request_id
        self.status_count = status_count

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.status_count, 'status_count')
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusCountResponseStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class ListDataServiceFoldersRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        tenant_id: int = None,
        group_id: str = None,
        folder_name_keyword: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.tenant_id = tenant_id
        self.group_id = group_id
        self.folder_name_keyword = folder_name_keyword

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.tenant_id, 'tenant_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.folder_name_keyword is not None:
            result['FolderNameKeyword'] = self.folder_name_keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('FolderNameKeyword') is not None:
            self.folder_name_keyword = m.get('FolderNameKeyword')
        return self


class ListDataServiceFoldersResponseFolderPagingResultFolders(TeaModel):
    def __init__(
        self,
        folder_id: int = None,
        folder_name: str = None,
        project_id: int = None,
        tenant_id: int = None,
        created_time: str = None,
        modified_time: str = None,
        group_id: str = None,
        parent_id: int = None,
    ):
        self.folder_id = folder_id
        self.folder_name = folder_name
        self.project_id = project_id
        self.tenant_id = tenant_id
        self.created_time = created_time
        self.modified_time = modified_time
        self.group_id = group_id
        self.parent_id = parent_id

    def validate(self):
        self.validate_required(self.folder_id, 'folder_id')
        self.validate_required(self.folder_name, 'folder_name')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.created_time, 'created_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.parent_id, 'parent_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class ListDataServiceFoldersResponseFolderPagingResult(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        folders: List[ListDataServiceFoldersResponseFolderPagingResultFolders] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.folders = folders

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.folders, 'folders')
        if self.folders:
            for k in self.folders:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Folders'] = []
        if self.folders is not None:
            for k in self.folders:
                result['Folders'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.folders = []
        if m.get('Folders') is not None:
            for k in m.get('Folders'):
                temp_model = ListDataServiceFoldersResponseFolderPagingResultFolders()
                self.folders.append(temp_model.from_map(k))
        return self


class ListDataServiceFoldersResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        folder_paging_result: ListDataServiceFoldersResponseFolderPagingResult = None,
    ):
        self.request_id = request_id
        self.folder_paging_result = folder_paging_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.folder_paging_result, 'folder_paging_result')
        if self.folder_paging_result:
            self.folder_paging_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.folder_paging_result is not None:
            result['FolderPagingResult'] = self.folder_paging_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FolderPagingResult') is not None:
            temp_model = ListDataServiceFoldersResponseFolderPagingResult()
            self.folder_paging_result = temp_model.from_map(m['FolderPagingResult'])
        return self


class ListQualityResultsByRuleRequest(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
        start_date: str = None,
        end_date: str = None,
        page_size: int = None,
        page_number: int = None,
        project_name: str = None,
    ):
        self.rule_id = rule_id
        self.start_date = start_date
        self.end_date = end_date
        self.page_size = page_size
        self.page_number = page_number
        self.project_name = project_name

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.start_date, 'start_date')
        self.validate_required(self.end_date, 'end_date')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.project_name, 'project_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class ListQualityResultsByRuleResponseDataRuleChecksReferenceValue(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        discrete_property: str = None,
        value: float = None,
        threshold: float = None,
        single_check_result: int = None,
    ):
        self.biz_date = biz_date
        self.discrete_property = discrete_property
        self.value = value
        self.threshold = threshold
        self.single_check_result = single_check_result

    def validate(self):
        self.validate_required(self.biz_date, 'biz_date')
        self.validate_required(self.discrete_property, 'discrete_property')
        self.validate_required(self.value, 'value')
        self.validate_required(self.threshold, 'threshold')
        self.validate_required(self.single_check_result, 'single_check_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.discrete_property is not None:
            result['DiscreteProperty'] = self.discrete_property
        if self.value is not None:
            result['Value'] = self.value
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.single_check_result is not None:
            result['SingleCheckResult'] = self.single_check_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DiscreteProperty') is not None:
            self.discrete_property = m.get('DiscreteProperty')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('SingleCheckResult') is not None:
            self.single_check_result = m.get('SingleCheckResult')
        return self


class ListQualityResultsByRuleResponseDataRuleChecksSampleValue(TeaModel):
    def __init__(
        self,
        biz_date: str = None,
        discrete_property: str = None,
        value: float = None,
    ):
        self.biz_date = biz_date
        self.discrete_property = discrete_property
        self.value = value

    def validate(self):
        self.validate_required(self.biz_date, 'biz_date')
        self.validate_required(self.discrete_property, 'discrete_property')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.discrete_property is not None:
            result['DiscreteProperty'] = self.discrete_property
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DiscreteProperty') is not None:
            self.discrete_property = m.get('DiscreteProperty')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListQualityResultsByRuleResponseDataRuleChecks(TeaModel):
    def __init__(
        self,
        id: int = None,
        task_id: str = None,
        entity_id: int = None,
        rule_id: int = None,
        property: str = None,
        biz_date: int = None,
        date_type: str = None,
        actual_expression: str = None,
        match_expression: str = None,
        block_type: int = None,
        check_result: int = None,
        check_result_status: int = None,
        method_name: str = None,
        comment: str = None,
        where_condition: str = None,
        begin_time: int = None,
        end_time: int = None,
        time_cost: str = None,
        external_type: str = None,
        external_id: str = None,
        discrete_check: bool = None,
        fixed_check: bool = None,
        trend: str = None,
        warning_threshold: float = None,
        critical_threshold: float = None,
        expect_value: float = None,
        op: str = None,
        project_name: str = None,
        table_name: str = None,
        template_id: int = None,
        template_name: str = None,
        result_string: str = None,
        checker_id: int = None,
        checker_type: int = None,
        rule_name: str = None,
        is_prediction: bool = None,
        upper_value: float = None,
        lower_value: float = None,
        checker_name: str = None,
        reference_value: List[ListQualityResultsByRuleResponseDataRuleChecksReferenceValue] = None,
        sample_value: List[ListQualityResultsByRuleResponseDataRuleChecksSampleValue] = None,
    ):
        self.id = id
        self.task_id = task_id
        self.entity_id = entity_id
        self.rule_id = rule_id
        self.property = property
        self.biz_date = biz_date
        self.date_type = date_type
        self.actual_expression = actual_expression
        self.match_expression = match_expression
        self.block_type = block_type
        self.check_result = check_result
        self.check_result_status = check_result_status
        self.method_name = method_name
        self.comment = comment
        self.where_condition = where_condition
        self.begin_time = begin_time
        self.end_time = end_time
        self.time_cost = time_cost
        self.external_type = external_type
        self.external_id = external_id
        self.discrete_check = discrete_check
        self.fixed_check = fixed_check
        self.trend = trend
        self.warning_threshold = warning_threshold
        self.critical_threshold = critical_threshold
        self.expect_value = expect_value
        self.op = op
        self.project_name = project_name
        self.table_name = table_name
        self.template_id = template_id
        self.template_name = template_name
        self.result_string = result_string
        self.checker_id = checker_id
        self.checker_type = checker_type
        self.rule_name = rule_name
        self.is_prediction = is_prediction
        self.upper_value = upper_value
        self.lower_value = lower_value
        self.checker_name = checker_name
        self.reference_value = reference_value
        self.sample_value = sample_value

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.entity_id, 'entity_id')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.property, 'property')
        self.validate_required(self.biz_date, 'biz_date')
        self.validate_required(self.date_type, 'date_type')
        self.validate_required(self.actual_expression, 'actual_expression')
        self.validate_required(self.match_expression, 'match_expression')
        self.validate_required(self.block_type, 'block_type')
        self.validate_required(self.check_result, 'check_result')
        self.validate_required(self.check_result_status, 'check_result_status')
        self.validate_required(self.method_name, 'method_name')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.where_condition, 'where_condition')
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.time_cost, 'time_cost')
        self.validate_required(self.external_type, 'external_type')
        self.validate_required(self.external_id, 'external_id')
        self.validate_required(self.discrete_check, 'discrete_check')
        self.validate_required(self.fixed_check, 'fixed_check')
        self.validate_required(self.trend, 'trend')
        self.validate_required(self.warning_threshold, 'warning_threshold')
        self.validate_required(self.critical_threshold, 'critical_threshold')
        self.validate_required(self.expect_value, 'expect_value')
        self.validate_required(self.op, 'op')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.table_name, 'table_name')
        self.validate_required(self.template_id, 'template_id')
        self.validate_required(self.template_name, 'template_name')
        self.validate_required(self.result_string, 'result_string')
        self.validate_required(self.checker_id, 'checker_id')
        self.validate_required(self.checker_type, 'checker_type')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.is_prediction, 'is_prediction')
        self.validate_required(self.upper_value, 'upper_value')
        self.validate_required(self.lower_value, 'lower_value')
        self.validate_required(self.checker_name, 'checker_name')
        self.validate_required(self.reference_value, 'reference_value')
        if self.reference_value:
            for k in self.reference_value:
                if k:
                    k.validate()
        self.validate_required(self.sample_value, 'sample_value')
        if self.sample_value:
            for k in self.sample_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.property is not None:
            result['Property'] = self.property
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.date_type is not None:
            result['DateType'] = self.date_type
        if self.actual_expression is not None:
            result['ActualExpression'] = self.actual_expression
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.block_type is not None:
            result['BlockType'] = self.block_type
        if self.check_result is not None:
            result['CheckResult'] = self.check_result
        if self.check_result_status is not None:
            result['CheckResultStatus'] = self.check_result_status
        if self.method_name is not None:
            result['MethodName'] = self.method_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.where_condition is not None:
            result['WhereCondition'] = self.where_condition
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.time_cost is not None:
            result['TimeCost'] = self.time_cost
        if self.external_type is not None:
            result['ExternalType'] = self.external_type
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.discrete_check is not None:
            result['DiscreteCheck'] = self.discrete_check
        if self.fixed_check is not None:
            result['FixedCheck'] = self.fixed_check
        if self.trend is not None:
            result['Trend'] = self.trend
        if self.warning_threshold is not None:
            result['WarningThreshold'] = self.warning_threshold
        if self.critical_threshold is not None:
            result['CriticalThreshold'] = self.critical_threshold
        if self.expect_value is not None:
            result['ExpectValue'] = self.expect_value
        if self.op is not None:
            result['Op'] = self.op
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.result_string is not None:
            result['ResultString'] = self.result_string
        if self.checker_id is not None:
            result['CheckerId'] = self.checker_id
        if self.checker_type is not None:
            result['CheckerType'] = self.checker_type
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.is_prediction is not None:
            result['IsPrediction'] = self.is_prediction
        if self.upper_value is not None:
            result['UpperValue'] = self.upper_value
        if self.lower_value is not None:
            result['LowerValue'] = self.lower_value
        if self.checker_name is not None:
            result['CheckerName'] = self.checker_name
        result['ReferenceValue'] = []
        if self.reference_value is not None:
            for k in self.reference_value:
                result['ReferenceValue'].append(k.to_map() if k else None)
        result['SampleValue'] = []
        if self.sample_value is not None:
            for k in self.sample_value:
                result['SampleValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DateType') is not None:
            self.date_type = m.get('DateType')
        if m.get('ActualExpression') is not None:
            self.actual_expression = m.get('ActualExpression')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('BlockType') is not None:
            self.block_type = m.get('BlockType')
        if m.get('CheckResult') is not None:
            self.check_result = m.get('CheckResult')
        if m.get('CheckResultStatus') is not None:
            self.check_result_status = m.get('CheckResultStatus')
        if m.get('MethodName') is not None:
            self.method_name = m.get('MethodName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('WhereCondition') is not None:
            self.where_condition = m.get('WhereCondition')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TimeCost') is not None:
            self.time_cost = m.get('TimeCost')
        if m.get('ExternalType') is not None:
            self.external_type = m.get('ExternalType')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('DiscreteCheck') is not None:
            self.discrete_check = m.get('DiscreteCheck')
        if m.get('FixedCheck') is not None:
            self.fixed_check = m.get('FixedCheck')
        if m.get('Trend') is not None:
            self.trend = m.get('Trend')
        if m.get('WarningThreshold') is not None:
            self.warning_threshold = m.get('WarningThreshold')
        if m.get('CriticalThreshold') is not None:
            self.critical_threshold = m.get('CriticalThreshold')
        if m.get('ExpectValue') is not None:
            self.expect_value = m.get('ExpectValue')
        if m.get('Op') is not None:
            self.op = m.get('Op')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('ResultString') is not None:
            self.result_string = m.get('ResultString')
        if m.get('CheckerId') is not None:
            self.checker_id = m.get('CheckerId')
        if m.get('CheckerType') is not None:
            self.checker_type = m.get('CheckerType')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('IsPrediction') is not None:
            self.is_prediction = m.get('IsPrediction')
        if m.get('UpperValue') is not None:
            self.upper_value = m.get('UpperValue')
        if m.get('LowerValue') is not None:
            self.lower_value = m.get('LowerValue')
        if m.get('CheckerName') is not None:
            self.checker_name = m.get('CheckerName')
        self.reference_value = []
        if m.get('ReferenceValue') is not None:
            for k in m.get('ReferenceValue'):
                temp_model = ListQualityResultsByRuleResponseDataRuleChecksReferenceValue()
                self.reference_value.append(temp_model.from_map(k))
        self.sample_value = []
        if m.get('SampleValue') is not None:
            for k in m.get('SampleValue'):
                temp_model = ListQualityResultsByRuleResponseDataRuleChecksSampleValue()
                self.sample_value.append(temp_model.from_map(k))
        return self


class ListQualityResultsByRuleResponseData(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_number: int = None,
        page_size: int = None,
        rule_checks: List[ListQualityResultsByRuleResponseDataRuleChecks] = None,
    ):
        self.total_count = total_count
        self.page_number = page_number
        self.page_size = page_size
        self.rule_checks = rule_checks

    def validate(self):
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.rule_checks, 'rule_checks')
        if self.rule_checks:
            for k in self.rule_checks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['RuleChecks'] = []
        if self.rule_checks is not None:
            for k in self.rule_checks:
                result['RuleChecks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.rule_checks = []
        if m.get('RuleChecks') is not None:
            for k in m.get('RuleChecks'):
                temp_model = ListQualityResultsByRuleResponseDataRuleChecks()
                self.rule_checks.append(temp_model.from_map(k))
        return self


class ListQualityResultsByRuleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        data: ListQualityResultsByRuleResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            temp_model = ListQualityResultsByRuleResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListMetaDBRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        data_source_type: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.project_id = project_id
        self.data_source_type = data_source_type
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.data_source_type, 'data_source_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListMetaDBResponseDatabaseInfoDbList(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        owner_id: str = None,
        location: str = None,
        create_time_stamp: int = None,
        modified_time_stamp: int = None,
        uuid: str = None,
    ):
        self.name = name
        self.type = type
        self.owner_id = owner_id
        self.location = location
        self.create_time_stamp = create_time_stamp
        self.modified_time_stamp = modified_time_stamp
        self.uuid = uuid

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.location, 'location')
        self.validate_required(self.create_time_stamp, 'create_time_stamp')
        self.validate_required(self.modified_time_stamp, 'modified_time_stamp')
        self.validate_required(self.uuid, 'uuid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.location is not None:
            result['Location'] = self.location
        if self.create_time_stamp is not None:
            result['CreateTimeStamp'] = self.create_time_stamp
        if self.modified_time_stamp is not None:
            result['ModifiedTimeStamp'] = self.modified_time_stamp
        if self.uuid is not None:
            result['UUID'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('CreateTimeStamp') is not None:
            self.create_time_stamp = m.get('CreateTimeStamp')
        if m.get('ModifiedTimeStamp') is not None:
            self.modified_time_stamp = m.get('ModifiedTimeStamp')
        if m.get('UUID') is not None:
            self.uuid = m.get('UUID')
        return self


class ListMetaDBResponseDatabaseInfo(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        db_list: List[ListMetaDBResponseDatabaseInfoDbList] = None,
    ):
        self.total_count = total_count
        self.db_list = db_list

    def validate(self):
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.db_list, 'db_list')
        if self.db_list:
            for k in self.db_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DbList'] = []
        if self.db_list is not None:
            for k in self.db_list:
                result['DbList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.db_list = []
        if m.get('DbList') is not None:
            for k in m.get('DbList'):
                temp_model = ListMetaDBResponseDatabaseInfoDbList()
                self.db_list.append(temp_model.from_map(k))
        return self


class ListMetaDBResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        database_info: ListMetaDBResponseDatabaseInfo = None,
    ):
        self.request_id = request_id
        self.database_info = database_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.database_info, 'database_info')
        if self.database_info:
            self.database_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.database_info is not None:
            result['DatabaseInfo'] = self.database_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DatabaseInfo') is not None:
            temp_model = ListMetaDBResponseDatabaseInfo()
            self.database_info = temp_model.from_map(m['DatabaseInfo'])
        return self


class CreateTableRequestColumns(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_name_cn: str = None,
        column_type: str = None,
        seq_number: int = None,
        length: int = None,
        is_partition_col: bool = None,
        comment: str = None,
    ):
        self.column_name = column_name
        self.column_name_cn = column_name_cn
        self.column_type = column_type
        self.seq_number = seq_number
        self.length = length
        self.is_partition_col = is_partition_col
        self.comment = comment

    def validate(self):
        self.validate_required(self.column_name, 'column_name')
        self.validate_required(self.column_type, 'column_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_name_cn is not None:
            result['ColumnNameCn'] = self.column_name_cn
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.seq_number is not None:
            result['SeqNumber'] = self.seq_number
        if self.length is not None:
            result['Length'] = self.length
        if self.is_partition_col is not None:
            result['IsPartitionCol'] = self.is_partition_col
        if self.comment is not None:
            result['Comment'] = self.comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnNameCn') is not None:
            self.column_name_cn = m.get('ColumnNameCn')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('SeqNumber') is not None:
            self.seq_number = m.get('SeqNumber')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('IsPartitionCol') is not None:
            self.is_partition_col = m.get('IsPartitionCol')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        return self


class CreateTableRequestThemes(TeaModel):
    def __init__(
        self,
        theme_id: int = None,
        theme_level: int = None,
    ):
        self.theme_id = theme_id
        self.theme_level = theme_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.theme_level is not None:
            result['ThemeLevel'] = self.theme_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('ThemeLevel') is not None:
            self.theme_level = m.get('ThemeLevel')
        return self


class CreateTableRequest(TeaModel):
    def __init__(
        self,
        columns: List[CreateTableRequestColumns] = None,
        is_view: int = None,
        visibility: int = None,
        life_cycle: int = None,
        category_id: int = None,
        logical_level_id: int = None,
        physics_level_id: int = None,
        external_table_type: str = None,
        location: str = None,
        project_id: int = None,
        table_name: str = None,
        endpoint: str = None,
        env_type: int = None,
        themes: List[CreateTableRequestThemes] = None,
        app_guid: str = None,
        comment: str = None,
        owner_id: str = None,
        has_part: int = None,
        client_token: str = None,
    ):
        self.columns = columns
        self.is_view = is_view
        self.visibility = visibility
        self.life_cycle = life_cycle
        self.category_id = category_id
        self.logical_level_id = logical_level_id
        self.physics_level_id = physics_level_id
        self.external_table_type = external_table_type
        self.location = location
        self.project_id = project_id
        self.table_name = table_name
        self.endpoint = endpoint
        self.env_type = env_type
        self.themes = themes
        self.app_guid = app_guid
        self.comment = comment
        self.owner_id = owner_id
        self.has_part = has_part
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.columns, 'columns')
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()
        self.validate_required(self.table_name, 'table_name')
        if self.themes:
            for k in self.themes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.visibility is not None:
            result['Visibility'] = self.visibility
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.logical_level_id is not None:
            result['LogicalLevelId'] = self.logical_level_id
        if self.physics_level_id is not None:
            result['PhysicsLevelId'] = self.physics_level_id
        if self.external_table_type is not None:
            result['ExternalTableType'] = self.external_table_type
        if self.location is not None:
            result['Location'] = self.location
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        result['Themes'] = []
        if self.themes is not None:
            for k in self.themes:
                result['Themes'].append(k.to_map() if k else None)
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.has_part is not None:
            result['HasPart'] = self.has_part
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = CreateTableRequestColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('Visibility') is not None:
            self.visibility = m.get('Visibility')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('LogicalLevelId') is not None:
            self.logical_level_id = m.get('LogicalLevelId')
        if m.get('PhysicsLevelId') is not None:
            self.physics_level_id = m.get('PhysicsLevelId')
        if m.get('ExternalTableType') is not None:
            self.external_table_type = m.get('ExternalTableType')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        self.themes = []
        if m.get('Themes') is not None:
            for k in m.get('Themes'):
                temp_model = CreateTableRequestThemes()
                self.themes.append(temp_model.from_map(k))
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('HasPart') is not None:
            self.has_part = m.get('HasPart')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateTableResponseTaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        content: str = None,
        status: str = None,
        next_task_id: str = None,
    ):
        self.task_id = task_id
        self.content = content
        self.status = status
        self.next_task_id = next_task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.status, 'status')
        self.validate_required(self.next_task_id, 'next_task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        return self


class CreateTableResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: CreateTableResponseTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_info, 'task_info')
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = CreateTableResponseTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class CreateTableThemeRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        level: int = None,
        name: str = None,
        parent_id: int = None,
    ):
        self.project_id = project_id
        self.level = level
        self.name = name
        self.parent_id = parent_id

    def validate(self):
        self.validate_required(self.level, 'level')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateTableThemeResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        theme_id: int = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.theme_id = theme_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.theme_id, 'theme_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        return self


class GetInstanceErrorRankRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceErrorRankResponseInstanceErrorRankErrorRank(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        count: int = None,
        project_id: int = None,
        prg_type: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.count = count
        self.project_id = project_id
        self.prg_type = prg_type

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.count, 'count')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.prg_type, 'prg_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.count is not None:
            result['Count'] = self.count
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        return self


class GetInstanceErrorRankResponseInstanceErrorRank(TeaModel):
    def __init__(
        self,
        update_time: int = None,
        error_rank: List[GetInstanceErrorRankResponseInstanceErrorRankErrorRank] = None,
    ):
        self.update_time = update_time
        self.error_rank = error_rank

    def validate(self):
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.error_rank, 'error_rank')
        if self.error_rank:
            for k in self.error_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['ErrorRank'] = []
        if self.error_rank is not None:
            for k in self.error_rank:
                result['ErrorRank'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.error_rank = []
        if m.get('ErrorRank') is not None:
            for k in m.get('ErrorRank'):
                temp_model = GetInstanceErrorRankResponseInstanceErrorRankErrorRank()
                self.error_rank.append(temp_model.from_map(k))
        return self


class GetInstanceErrorRankResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_error_rank: GetInstanceErrorRankResponseInstanceErrorRank = None,
    ):
        self.request_id = request_id
        self.instance_error_rank = instance_error_rank

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_error_rank, 'instance_error_rank')
        if self.instance_error_rank:
            self.instance_error_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_error_rank is not None:
            result['InstanceErrorRank'] = self.instance_error_rank.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceErrorRank') is not None:
            temp_model = GetInstanceErrorRankResponseInstanceErrorRank()
            self.instance_error_rank = temp_model.from_map(m['InstanceErrorRank'])
        return self


class GetDDLJobStatusRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDDLJobStatusResponseData(TeaModel):
    def __init__(
        self,
        next_task_id: str = None,
        content: str = None,
        status: str = None,
        task_id: str = None,
    ):
        self.next_task_id = next_task_id
        self.content = content
        self.status = status
        self.task_id = task_id

    def validate(self):
        self.validate_required(self.next_task_id, 'next_task_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.status, 'status')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.content is not None:
            result['Content'] = self.content
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDDLJobStatusResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetDDLJobStatusResponseData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDDLJobStatusResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetInstanceConsumeTimeRankRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        bizdate: str = None,
    ):
        self.project_id = project_id
        self.bizdate = bizdate

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.bizdate, 'bizdate')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        return self


class GetInstanceConsumeTimeRankResponseInstanceConsumeTimeRankConsumeTimeRank(TeaModel):
    def __init__(
        self,
        node_name: str = None,
        node_id: int = None,
        bizdate: int = None,
        owner: str = None,
        consumed: int = None,
        instance_id: int = None,
        prg_type: int = None,
    ):
        self.node_name = node_name
        self.node_id = node_id
        self.bizdate = bizdate
        self.owner = owner
        self.consumed = consumed
        self.instance_id = instance_id
        self.prg_type = prg_type

    def validate(self):
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.bizdate, 'bizdate')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.consumed, 'consumed')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.prg_type, 'prg_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.consumed is not None:
            result['Consumed'] = self.consumed
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Consumed') is not None:
            self.consumed = m.get('Consumed')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        return self


class GetInstanceConsumeTimeRankResponseInstanceConsumeTimeRank(TeaModel):
    def __init__(
        self,
        update_time: int = None,
        consume_time_rank: List[GetInstanceConsumeTimeRankResponseInstanceConsumeTimeRankConsumeTimeRank] = None,
    ):
        self.update_time = update_time
        self.consume_time_rank = consume_time_rank

    def validate(self):
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.consume_time_rank, 'consume_time_rank')
        if self.consume_time_rank:
            for k in self.consume_time_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['ConsumeTimeRank'] = []
        if self.consume_time_rank is not None:
            for k in self.consume_time_rank:
                result['ConsumeTimeRank'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.consume_time_rank = []
        if m.get('ConsumeTimeRank') is not None:
            for k in m.get('ConsumeTimeRank'):
                temp_model = GetInstanceConsumeTimeRankResponseInstanceConsumeTimeRankConsumeTimeRank()
                self.consume_time_rank.append(temp_model.from_map(k))
        return self


class GetInstanceConsumeTimeRankResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_consume_time_rank: GetInstanceConsumeTimeRankResponseInstanceConsumeTimeRank = None,
    ):
        self.request_id = request_id
        self.instance_consume_time_rank = instance_consume_time_rank

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_consume_time_rank, 'instance_consume_time_rank')
        if self.instance_consume_time_rank:
            self.instance_consume_time_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_consume_time_rank is not None:
            result['InstanceConsumeTimeRank'] = self.instance_consume_time_rank.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceConsumeTimeRank') is not None:
            temp_model = GetInstanceConsumeTimeRankResponseInstanceConsumeTimeRank()
            self.instance_consume_time_rank = temp_model.from_map(m['InstanceConsumeTimeRank'])
        return self


class CreateDataServiceApiAuthorityRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_id: int = None,
        authorized_project_id: int = None,
        end_time: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_id = api_id
        self.authorized_project_id = authorized_project_id
        self.end_time = end_time

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.authorized_project_id, 'authorized_project_id')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class CreateDataServiceApiAuthorityResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
    ):
        self.success = success
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDataServiceApiAuthorityRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_id: int = None,
        authorized_project_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_id = api_id
        self.authorized_project_id = authorized_project_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.authorized_project_id, 'authorized_project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        return self


class DeleteDataServiceApiAuthorityResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
    ):
        self.success = success
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceGroupRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_gateway_group_id: str = None,
        group_name: str = None,
        description: str = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_gateway_group_id = api_gateway_group_id
        self.group_name = group_name
        self.description = description

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.api_gateway_group_id, 'api_gateway_group_id')
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateDataServiceGroupResponse(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        request_id: str = None,
    ):
        self.group_id = group_id
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateMetaTableRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        table_name: str = None,
        env_type: int = None,
        table_guid: str = None,
        new_owner_id: str = None,
        added_labels: str = None,
        removed_labels: str = None,
        category_id: int = None,
        visibility: int = None,
        caption: str = None,
    ):
        self.project_id = project_id
        self.table_name = table_name
        self.env_type = env_type
        self.table_guid = table_guid
        self.new_owner_id = new_owner_id
        self.added_labels = added_labels
        self.removed_labels = removed_labels
        self.category_id = category_id
        self.visibility = visibility
        self.caption = caption

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.new_owner_id is not None:
            result['NewOwnerId'] = self.new_owner_id
        if self.added_labels is not None:
            result['AddedLabels'] = self.added_labels
        if self.removed_labels is not None:
            result['RemovedLabels'] = self.removed_labels
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.visibility is not None:
            result['Visibility'] = self.visibility
        if self.caption is not None:
            result['Caption'] = self.caption
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('NewOwnerId') is not None:
            self.new_owner_id = m.get('NewOwnerId')
        if m.get('AddedLabels') is not None:
            self.added_labels = m.get('AddedLabels')
        if m.get('RemovedLabels') is not None:
            self.removed_labels = m.get('RemovedLabels')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Visibility') is not None:
            self.visibility = m.get('Visibility')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        return self


class UpdateMetaTableResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        update_result: bool = None,
    ):
        self.request_id = request_id
        self.update_result = update_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.update_result, 'update_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.update_result is not None:
            result['UpdateResult'] = self.update_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UpdateResult') is not None:
            self.update_result = m.get('UpdateResult')
        return self


class GetInstanceCountTrendRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        begin_date: str = None,
        end_date: str = None,
    ):
        self.project_id = project_id
        self.begin_date = begin_date
        self.end_date = end_date

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.begin_date, 'begin_date')
        self.validate_required(self.end_date, 'end_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.begin_date is not None:
            result['BeginDate'] = self.begin_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BeginDate') is not None:
            self.begin_date = m.get('BeginDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetInstanceCountTrendResponseInstanceCounts(TeaModel):
    def __init__(
        self,
        date: int = None,
        count: int = None,
    ):
        self.date = date
        self.count = count

    def validate(self):
        self.validate_required(self.date, 'date')
        self.validate_required(self.count, 'count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetInstanceCountTrendResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_counts: List[GetInstanceCountTrendResponseInstanceCounts] = None,
    ):
        self.request_id = request_id
        self.instance_counts = instance_counts

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_counts, 'instance_counts')
        if self.instance_counts:
            for k in self.instance_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['InstanceCounts'] = []
        if self.instance_counts is not None:
            for k in self.instance_counts:
                result['InstanceCounts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.instance_counts = []
        if m.get('InstanceCounts') is not None:
            for k in m.get('InstanceCounts'):
                temp_model = GetInstanceCountTrendResponseInstanceCounts()
                self.instance_counts.append(temp_model.from_map(k))
        return self


class DeleteTableRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        table_name: str = None,
        env_type: int = None,
        app_guid: str = None,
    ):
        self.project_id = project_id
        self.table_name = table_name
        self.env_type = env_type
        self.app_guid = app_guid

    def validate(self):
        self.validate_required(self.table_name, 'table_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        return self


class DeleteTableResponseTaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        content: str = None,
        status: str = None,
        next_task_id: str = None,
    ):
        self.task_id = task_id
        self.content = content
        self.status = status
        self.next_task_id = next_task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.status, 'status')
        self.validate_required(self.next_task_id, 'next_task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        return self


class DeleteTableResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: DeleteTableResponseTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_info, 'task_info')
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = DeleteTableResponseTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class ListTableThemeRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        parent_id: int = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.project_id = project_id
        self.parent_id = parent_id
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListTableThemeResponseDataThemeList(TeaModel):
    def __init__(
        self,
        theme_id: int = None,
        name: str = None,
        level: int = None,
        parent_id: int = None,
        project_id: int = None,
        creator: str = None,
        create_time_stamp: int = None,
    ):
        self.theme_id = theme_id
        self.name = name
        self.level = level
        self.parent_id = parent_id
        self.project_id = project_id
        self.creator = creator
        self.create_time_stamp = create_time_stamp

    def validate(self):
        self.validate_required(self.theme_id, 'theme_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.level, 'level')
        self.validate_required(self.parent_id, 'parent_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.creator, 'creator')
        self.validate_required(self.create_time_stamp, 'create_time_stamp')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.name is not None:
            result['Name'] = self.name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.create_time_stamp is not None:
            result['CreateTimeStamp'] = self.create_time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('CreateTimeStamp') is not None:
            self.create_time_stamp = m.get('CreateTimeStamp')
        return self


class ListTableThemeResponseData(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        theme_list: List[ListTableThemeResponseDataThemeList] = None,
    ):
        self.total_count = total_count
        self.theme_list = theme_list

    def validate(self):
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.theme_list, 'theme_list')
        if self.theme_list:
            for k in self.theme_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ThemeList'] = []
        if self.theme_list is not None:
            for k in self.theme_list:
                result['ThemeList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.theme_list = []
        if m.get('ThemeList') is not None:
            for k in m.get('ThemeList'):
                temp_model = ListTableThemeResponseDataThemeList()
                self.theme_list.append(temp_model.from_map(k))
        return self


class ListTableThemeResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: ListTableThemeResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListTableThemeResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSuccessInstanceTrendRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetSuccessInstanceTrendResponseInstanceStatusTrendTodayTrend(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: str = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.time_point, 'time_point')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class GetSuccessInstanceTrendResponseInstanceStatusTrendYesterdayTrend(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: str = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.time_point, 'time_point')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class GetSuccessInstanceTrendResponseInstanceStatusTrendAvgTrend(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: str = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.time_point, 'time_point')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class GetSuccessInstanceTrendResponseInstanceStatusTrend(TeaModel):
    def __init__(
        self,
        today_trend: List[GetSuccessInstanceTrendResponseInstanceStatusTrendTodayTrend] = None,
        yesterday_trend: List[GetSuccessInstanceTrendResponseInstanceStatusTrendYesterdayTrend] = None,
        avg_trend: List[GetSuccessInstanceTrendResponseInstanceStatusTrendAvgTrend] = None,
    ):
        self.today_trend = today_trend
        self.yesterday_trend = yesterday_trend
        self.avg_trend = avg_trend

    def validate(self):
        self.validate_required(self.today_trend, 'today_trend')
        if self.today_trend:
            for k in self.today_trend:
                if k:
                    k.validate()
        self.validate_required(self.yesterday_trend, 'yesterday_trend')
        if self.yesterday_trend:
            for k in self.yesterday_trend:
                if k:
                    k.validate()
        self.validate_required(self.avg_trend, 'avg_trend')
        if self.avg_trend:
            for k in self.avg_trend:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TodayTrend'] = []
        if self.today_trend is not None:
            for k in self.today_trend:
                result['TodayTrend'].append(k.to_map() if k else None)
        result['YesterdayTrend'] = []
        if self.yesterday_trend is not None:
            for k in self.yesterday_trend:
                result['YesterdayTrend'].append(k.to_map() if k else None)
        result['AvgTrend'] = []
        if self.avg_trend is not None:
            for k in self.avg_trend:
                result['AvgTrend'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.today_trend = []
        if m.get('TodayTrend') is not None:
            for k in m.get('TodayTrend'):
                temp_model = GetSuccessInstanceTrendResponseInstanceStatusTrendTodayTrend()
                self.today_trend.append(temp_model.from_map(k))
        self.yesterday_trend = []
        if m.get('YesterdayTrend') is not None:
            for k in m.get('YesterdayTrend'):
                temp_model = GetSuccessInstanceTrendResponseInstanceStatusTrendYesterdayTrend()
                self.yesterday_trend.append(temp_model.from_map(k))
        self.avg_trend = []
        if m.get('AvgTrend') is not None:
            for k in m.get('AvgTrend'):
                temp_model = GetSuccessInstanceTrendResponseInstanceStatusTrendAvgTrend()
                self.avg_trend.append(temp_model.from_map(k))
        return self


class GetSuccessInstanceTrendResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_status_trend: GetSuccessInstanceTrendResponseInstanceStatusTrend = None,
    ):
        self.request_id = request_id
        self.instance_status_trend = instance_status_trend

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_status_trend, 'instance_status_trend')
        if self.instance_status_trend:
            self.instance_status_trend.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_status_trend is not None:
            result['InstanceStatusTrend'] = self.instance_status_trend.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceStatusTrend') is not None:
            temp_model = GetSuccessInstanceTrendResponseInstanceStatusTrend()
            self.instance_status_trend = temp_model.from_map(m['InstanceStatusTrend'])
        return self


class UpdateTableRequestColumns(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_name_cn: str = None,
        column_type: str = None,
        seq_number: int = None,
        length: int = None,
        is_partition_col: bool = None,
        comment: str = None,
    ):
        self.column_name = column_name
        self.column_name_cn = column_name_cn
        self.column_type = column_type
        self.seq_number = seq_number
        self.length = length
        self.is_partition_col = is_partition_col
        self.comment = comment

    def validate(self):
        self.validate_required(self.column_name, 'column_name')
        self.validate_required(self.column_type, 'column_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_name_cn is not None:
            result['ColumnNameCn'] = self.column_name_cn
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.seq_number is not None:
            result['SeqNumber'] = self.seq_number
        if self.length is not None:
            result['Length'] = self.length
        if self.is_partition_col is not None:
            result['IsPartitionCol'] = self.is_partition_col
        if self.comment is not None:
            result['Comment'] = self.comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnNameCn') is not None:
            self.column_name_cn = m.get('ColumnNameCn')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('SeqNumber') is not None:
            self.seq_number = m.get('SeqNumber')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('IsPartitionCol') is not None:
            self.is_partition_col = m.get('IsPartitionCol')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        return self


class UpdateTableRequestThemes(TeaModel):
    def __init__(
        self,
        theme_id: int = None,
        theme_level: int = None,
    ):
        self.theme_id = theme_id
        self.theme_level = theme_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.theme_level is not None:
            result['ThemeLevel'] = self.theme_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('ThemeLevel') is not None:
            self.theme_level = m.get('ThemeLevel')
        return self


class UpdateTableRequest(TeaModel):
    def __init__(
        self,
        columns: List[UpdateTableRequestColumns] = None,
        is_view: int = None,
        visibility: int = None,
        life_cycle: int = None,
        category_id: int = None,
        logical_level_id: int = None,
        physics_level_id: int = None,
        external_table_type: str = None,
        location: str = None,
        project_id: int = None,
        table_name: str = None,
        endpoint: str = None,
        env_type: int = None,
        themes: List[UpdateTableRequestThemes] = None,
        app_guid: str = None,
        create_if_not_exists: bool = None,
        owner_id: str = None,
        has_part: int = None,
        comment: str = None,
    ):
        self.columns = columns
        self.is_view = is_view
        self.visibility = visibility
        self.life_cycle = life_cycle
        self.category_id = category_id
        self.logical_level_id = logical_level_id
        self.physics_level_id = physics_level_id
        self.external_table_type = external_table_type
        self.location = location
        self.project_id = project_id
        self.table_name = table_name
        self.endpoint = endpoint
        self.env_type = env_type
        self.themes = themes
        self.app_guid = app_guid
        self.create_if_not_exists = create_if_not_exists
        self.owner_id = owner_id
        self.has_part = has_part
        self.comment = comment

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()
        self.validate_required(self.table_name, 'table_name')
        if self.themes:
            for k in self.themes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.visibility is not None:
            result['Visibility'] = self.visibility
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.logical_level_id is not None:
            result['LogicalLevelId'] = self.logical_level_id
        if self.physics_level_id is not None:
            result['PhysicsLevelId'] = self.physics_level_id
        if self.external_table_type is not None:
            result['ExternalTableType'] = self.external_table_type
        if self.location is not None:
            result['Location'] = self.location
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        result['Themes'] = []
        if self.themes is not None:
            for k in self.themes:
                result['Themes'].append(k.to_map() if k else None)
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.create_if_not_exists is not None:
            result['CreateIfNotExists'] = self.create_if_not_exists
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.has_part is not None:
            result['HasPart'] = self.has_part
        if self.comment is not None:
            result['Comment'] = self.comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = UpdateTableRequestColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('Visibility') is not None:
            self.visibility = m.get('Visibility')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('LogicalLevelId') is not None:
            self.logical_level_id = m.get('LogicalLevelId')
        if m.get('PhysicsLevelId') is not None:
            self.physics_level_id = m.get('PhysicsLevelId')
        if m.get('ExternalTableType') is not None:
            self.external_table_type = m.get('ExternalTableType')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        self.themes = []
        if m.get('Themes') is not None:
            for k in m.get('Themes'):
                temp_model = UpdateTableRequestThemes()
                self.themes.append(temp_model.from_map(k))
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('CreateIfNotExists') is not None:
            self.create_if_not_exists = m.get('CreateIfNotExists')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('HasPart') is not None:
            self.has_part = m.get('HasPart')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        return self


class UpdateTableResponseTaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        content: str = None,
        status: str = None,
        next_task_id: str = None,
    ):
        self.task_id = task_id
        self.content = content
        self.status = status
        self.next_task_id = next_task_id

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.status, 'status')
        self.validate_required(self.next_task_id, 'next_task_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        return self


class UpdateTableResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: UpdateTableResponseTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_info, 'task_info')
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = UpdateTableResponseTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class GetDataServiceFolderRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        folder_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.folder_id = folder_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.folder_id, 'folder_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class GetDataServiceFolderResponseFolder(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        folder_id: int = None,
        folder_name: str = None,
        created_time: str = None,
        modified_time: str = None,
        group_id: str = None,
        parent_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.folder_id = folder_id
        self.folder_name = folder_name
        self.created_time = created_time
        self.modified_time = modified_time
        self.group_id = group_id
        self.parent_id = parent_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.folder_id, 'folder_id')
        self.validate_required(self.folder_name, 'folder_name')
        self.validate_required(self.created_time, 'created_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.parent_id, 'parent_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class GetDataServiceFolderResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        folder: GetDataServiceFolderResponseFolder = None,
    ):
        self.request_id = request_id
        self.folder = folder

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.folder, 'folder')
        if self.folder:
            self.folder.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.folder is not None:
            result['Folder'] = self.folder.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Folder') is not None:
            temp_model = GetDataServiceFolderResponseFolder()
            self.folder = temp_model.from_map(m['Folder'])
        return self


class ListTableLevelRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        level_type: int = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.project_id = project_id
        self.level_type = level_type
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.level_type, 'level_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.level_type is not None:
            result['LevelType'] = self.level_type
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('LevelType') is not None:
            self.level_type = m.get('LevelType')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListTableLevelResponseTableLevelInfoLevelList(TeaModel):
    def __init__(
        self,
        level_id: int = None,
        name: str = None,
        project_id: int = None,
        level_type: int = None,
        description: str = None,
    ):
        self.level_id = level_id
        self.name = name
        self.project_id = project_id
        self.level_type = level_type
        self.description = description

    def validate(self):
        self.validate_required(self.level_id, 'level_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.level_type, 'level_type')
        self.validate_required(self.description, 'description')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.name is not None:
            result['Name'] = self.name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.level_type is not None:
            result['LevelType'] = self.level_type
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('LevelType') is not None:
            self.level_type = m.get('LevelType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class ListTableLevelResponseTableLevelInfo(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        level_list: List[ListTableLevelResponseTableLevelInfoLevelList] = None,
    ):
        self.total_count = total_count
        self.level_list = level_list

    def validate(self):
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.level_list, 'level_list')
        if self.level_list:
            for k in self.level_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['LevelList'] = []
        if self.level_list is not None:
            for k in self.level_list:
                result['LevelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.level_list = []
        if m.get('LevelList') is not None:
            for k in m.get('LevelList'):
                temp_model = ListTableLevelResponseTableLevelInfoLevelList()
                self.level_list.append(temp_model.from_map(k))
        return self


class ListTableLevelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        table_level_info: ListTableLevelResponseTableLevelInfo = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.table_level_info = table_level_info

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.table_level_info, 'table_level_info')
        if self.table_level_info:
            self.table_level_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.table_level_info is not None:
            result['TableLevelInfo'] = self.table_level_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TableLevelInfo') is not None:
            temp_model = ListTableLevelResponseTableLevelInfo()
            self.table_level_info = temp_model.from_map(m['TableLevelInfo'])
        return self


class ListDataServiceGroupsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        tenant_id: int = None,
        group_name_keyword: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.tenant_id = tenant_id
        self.group_name_keyword = group_name_keyword

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.tenant_id, 'tenant_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.group_name_keyword is not None:
            result['GroupNameKeyword'] = self.group_name_keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('GroupNameKeyword') is not None:
            self.group_name_keyword = m.get('GroupNameKeyword')
        return self


class ListDataServiceGroupsResponseGroupPagingResultGroups(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        group_id: str = None,
        api_gateway_group_id: str = None,
        group_name: str = None,
        description: str = None,
        created_time: str = None,
        modified_time: str = None,
        creator_id: str = None,
        project_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.group_id = group_id
        self.api_gateway_group_id = api_gateway_group_id
        self.group_name = group_name
        self.description = description
        self.created_time = created_time
        self.modified_time = modified_time
        self.creator_id = creator_id
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.api_gateway_group_id, 'api_gateway_group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.created_time, 'created_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.creator_id, 'creator_id')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.description is not None:
            result['Description'] = self.description
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListDataServiceGroupsResponseGroupPagingResult(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        groups: List[ListDataServiceGroupsResponseGroupPagingResultGroups] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.groups = groups

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.groups, 'groups')
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = ListDataServiceGroupsResponseGroupPagingResultGroups()
                self.groups.append(temp_model.from_map(k))
        return self


class ListDataServiceGroupsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        group_paging_result: ListDataServiceGroupsResponseGroupPagingResult = None,
    ):
        self.request_id = request_id
        self.group_paging_result = group_paging_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.group_paging_result, 'group_paging_result')
        if self.group_paging_result:
            self.group_paging_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.group_paging_result is not None:
            result['GroupPagingResult'] = self.group_paging_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('GroupPagingResult') is not None:
            temp_model = ListDataServiceGroupsResponseGroupPagingResult()
            self.group_paging_result = temp_model.from_map(m['GroupPagingResult'])
        return self


class UpdateTableThemeRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        theme_id: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.theme_id = theme_id

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.theme_id, 'theme_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        return self


class UpdateTableThemeResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        update_result: bool = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.update_result = update_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.update_result, 'update_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.update_result is not None:
            result['UpdateResult'] = self.update_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('UpdateResult') is not None:
            self.update_result = m.get('UpdateResult')
        return self


class CreateDataServiceFolderRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        folder_name: str = None,
        parent_id: int = None,
        group_id: str = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.folder_name = folder_name
        self.parent_id = parent_id
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.folder_name, 'folder_name')
        self.validate_required(self.parent_id, 'parent_id')
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class CreateDataServiceFolderResponse(TeaModel):
    def __init__(
        self,
        folder_id: int = None,
        request_id: str = None,
    ):
        self.folder_id = folder_id
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.folder_id, 'folder_id')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDataServiceGroupRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        group_id: str = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class GetDataServiceGroupResponseGroup(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        group_id: str = None,
        api_gateway_group_id: str = None,
        group_name: str = None,
        description: str = None,
        created_time: str = None,
        modified_time: str = None,
        creator_id: str = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.group_id = group_id
        self.api_gateway_group_id = api_gateway_group_id
        self.group_name = group_name
        self.description = description
        self.created_time = created_time
        self.modified_time = modified_time
        self.creator_id = creator_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.api_gateway_group_id, 'api_gateway_group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.created_time, 'created_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.creator_id, 'creator_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.description is not None:
            result['Description'] = self.description
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        return self


class GetDataServiceGroupResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        group: GetDataServiceGroupResponseGroup = None,
    ):
        self.request_id = request_id
        self.group = group

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.group, 'group')
        if self.group:
            self.group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.group is not None:
            result['Group'] = self.group.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Group') is not None:
            temp_model = GetDataServiceGroupResponseGroup()
            self.group = temp_model.from_map(m['Group'])
        return self


class CreateTableLevelRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        level_type: int = None,
        name: str = None,
        description: str = None,
    ):
        self.project_id = project_id
        self.level_type = level_type
        self.name = name
        self.description = description

    def validate(self):
        self.validate_required(self.level_type, 'level_type')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.level_type is not None:
            result['LevelType'] = self.level_type
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('LevelType') is not None:
            self.level_type = m.get('LevelType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateTableLevelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        level_id: int = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.level_id = level_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.level_id, 'level_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        return self


class UpdateMetaTableIntroWikiRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        content: str = None,
    ):
        self.table_guid = table_guid
        self.content = content

    def validate(self):
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.content, 'content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class UpdateMetaTableIntroWikiResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        update_result: bool = None,
    ):
        self.request_id = request_id
        self.update_result = update_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.update_result, 'update_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.update_result is not None:
            result['UpdateResult'] = self.update_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UpdateResult') is not None:
            self.update_result = m.get('UpdateResult')
        return self


class DeleteTableLevelRequest(TeaModel):
    def __init__(
        self,
        level_id: int = None,
        project_id: int = None,
    ):
        self.level_id = level_id
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.level_id, 'level_id')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteTableLevelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        delete_result: bool = None,
    ):
        self.request_id = request_id
        self.delete_result = delete_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.delete_result, 'delete_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        return self


class UpdateTableLevelRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        level_type: int = None,
        name: str = None,
        description: str = None,
        level_id: int = None,
    ):
        self.project_id = project_id
        self.level_type = level_type
        self.name = name
        self.description = description
        self.level_id = level_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.level_id, 'level_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.level_type is not None:
            result['LevelType'] = self.level_type
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('LevelType') is not None:
            self.level_type = m.get('LevelType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        return self


class UpdateTableLevelResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        update_result: bool = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.update_result = update_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.update_result, 'update_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.update_result is not None:
            result['UpdateResult'] = self.update_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('UpdateResult') is not None:
            self.update_result = m.get('UpdateResult')
        return self


class DeleteTableThemeRequest(TeaModel):
    def __init__(
        self,
        theme_id: int = None,
        project_id: int = None,
    ):
        self.theme_id = theme_id
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.theme_id, 'theme_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteTableThemeResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        delete_result: bool = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.delete_result = delete_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.delete_result, 'delete_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        return self


class ListProgramTypeCountRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_env: str = None,
    ):
        self.project_id = project_id
        self.project_env = project_env

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.project_env, 'project_env')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class ListProgramTypeCountResponseProgramTypeAndCounts(TeaModel):
    def __init__(
        self,
        program_type: str = None,
        count: int = None,
    ):
        self.program_type = program_type
        self.count = count

    def validate(self):
        self.validate_required(self.program_type, 'program_type')
        self.validate_required(self.count, 'count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class ListProgramTypeCountResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        program_type_and_counts: List[ListProgramTypeCountResponseProgramTypeAndCounts] = None,
    ):
        self.request_id = request_id
        self.program_type_and_counts = program_type_and_counts

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.program_type_and_counts, 'program_type_and_counts')
        if self.program_type_and_counts:
            for k in self.program_type_and_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ProgramTypeAndCounts'] = []
        if self.program_type_and_counts is not None:
            for k in self.program_type_and_counts:
                result['ProgramTypeAndCounts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.program_type_and_counts = []
        if m.get('ProgramTypeAndCounts') is not None:
            for k in m.get('ProgramTypeAndCounts'):
                temp_model = ListProgramTypeCountResponseProgramTypeAndCounts()
                self.program_type_and_counts.append(temp_model.from_map(k))
        return self


class UpdateTableModelInfoRequest(TeaModel):
    def __init__(
        self,
        first_level_theme_id: int = None,
        second_level_theme_id: int = None,
        level_id: int = None,
        table_guid: str = None,
        level_type: int = None,
    ):
        self.first_level_theme_id = first_level_theme_id
        self.second_level_theme_id = second_level_theme_id
        self.level_id = level_id
        self.table_guid = table_guid
        self.level_type = level_type

    def validate(self):
        self.validate_required(self.table_guid, 'table_guid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_level_theme_id is not None:
            result['FirstLevelThemeId'] = self.first_level_theme_id
        if self.second_level_theme_id is not None:
            result['SecondLevelThemeId'] = self.second_level_theme_id
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.level_type is not None:
            result['LevelType'] = self.level_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirstLevelThemeId') is not None:
            self.first_level_theme_id = m.get('FirstLevelThemeId')
        if m.get('SecondLevelThemeId') is not None:
            self.second_level_theme_id = m.get('SecondLevelThemeId')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('LevelType') is not None:
            self.level_type = m.get('LevelType')
        return self


class UpdateTableModelInfoResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        update_result: bool = None,
    ):
        self.request_id = request_id
        self.update_result = update_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.update_result, 'update_result')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.update_result is not None:
            result['UpdateResult'] = self.update_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UpdateResult') is not None:
            self.update_result = m.get('UpdateResult')
        return self


class ListProjectsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListProjectsResponsePageResultProjectList(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        project_identifier: str = None,
        project_description: str = None,
        project_status: int = None,
        project_id: int = None,
        project_owner_base_id: str = None,
        project_status_code: str = None,
    ):
        self.project_name = project_name
        self.project_identifier = project_identifier
        self.project_description = project_description
        self.project_status = project_status
        self.project_id = project_id
        self.project_owner_base_id = project_owner_base_id
        self.project_status_code = project_status_code

    def validate(self):
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.project_identifier, 'project_identifier')
        self.validate_required(self.project_description, 'project_description')
        self.validate_required(self.project_status, 'project_status')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.project_owner_base_id, 'project_owner_base_id')
        self.validate_required(self.project_status_code, 'project_status_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.project_description is not None:
            result['ProjectDescription'] = self.project_description
        if self.project_status is not None:
            result['ProjectStatus'] = self.project_status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_owner_base_id is not None:
            result['ProjectOwnerBaseId'] = self.project_owner_base_id
        if self.project_status_code is not None:
            result['ProjectStatusCode'] = self.project_status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ProjectDescription') is not None:
            self.project_description = m.get('ProjectDescription')
        if m.get('ProjectStatus') is not None:
            self.project_status = m.get('ProjectStatus')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectOwnerBaseId') is not None:
            self.project_owner_base_id = m.get('ProjectOwnerBaseId')
        if m.get('ProjectStatusCode') is not None:
            self.project_status_code = m.get('ProjectStatusCode')
        return self


class ListProjectsResponsePageResult(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        project_list: List[ListProjectsResponsePageResultProjectList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.project_list = project_list

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.project_list, 'project_list')
        if self.project_list:
            for k in self.project_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ProjectList'] = []
        if self.project_list is not None:
            for k in self.project_list:
                result['ProjectList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.project_list = []
        if m.get('ProjectList') is not None:
            for k in m.get('ProjectList'):
                temp_model = ListProjectsResponsePageResultProjectList()
                self.project_list.append(temp_model.from_map(k))
        return self


class ListProjectsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_result: ListProjectsResponsePageResult = None,
    ):
        self.request_id = request_id
        self.page_result = page_result

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.page_result, 'page_result')
        if self.page_result:
            self.page_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_result is not None:
            result['PageResult'] = self.page_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageResult') is not None:
            temp_model = ListProjectsResponsePageResult()
            self.page_result = temp_model.from_map(m['PageResult'])
        return self


class ListProjectMembersRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.project_id = project_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListProjectMembersResponseDataProjectMemberListProjectRoleList(TeaModel):
    def __init__(
        self,
        project_role_code: str = None,
        project_role_id: int = None,
        project_role_name: str = None,
        project_role_type: str = None,
    ):
        self.project_role_code = project_role_code
        self.project_role_id = project_role_id
        self.project_role_name = project_role_name
        self.project_role_type = project_role_type

    def validate(self):
        self.validate_required(self.project_role_code, 'project_role_code')
        self.validate_required(self.project_role_id, 'project_role_id')
        self.validate_required(self.project_role_name, 'project_role_name')
        self.validate_required(self.project_role_type, 'project_role_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_role_code is not None:
            result['ProjectRoleCode'] = self.project_role_code
        if self.project_role_id is not None:
            result['ProjectRoleId'] = self.project_role_id
        if self.project_role_name is not None:
            result['ProjectRoleName'] = self.project_role_name
        if self.project_role_type is not None:
            result['ProjectRoleType'] = self.project_role_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectRoleCode') is not None:
            self.project_role_code = m.get('ProjectRoleCode')
        if m.get('ProjectRoleId') is not None:
            self.project_role_id = m.get('ProjectRoleId')
        if m.get('ProjectRoleName') is not None:
            self.project_role_name = m.get('ProjectRoleName')
        if m.get('ProjectRoleType') is not None:
            self.project_role_type = m.get('ProjectRoleType')
        return self


class ListProjectMembersResponseDataProjectMemberList(TeaModel):
    def __init__(
        self,
        nick: str = None,
        project_member_id: str = None,
        project_member_name: str = None,
        project_member_type: str = None,
        status: str = None,
        project_role_list: List[ListProjectMembersResponseDataProjectMemberListProjectRoleList] = None,
    ):
        self.nick = nick
        self.project_member_id = project_member_id
        self.project_member_name = project_member_name
        self.project_member_type = project_member_type
        self.status = status
        self.project_role_list = project_role_list

    def validate(self):
        self.validate_required(self.nick, 'nick')
        self.validate_required(self.project_member_id, 'project_member_id')
        self.validate_required(self.project_member_name, 'project_member_name')
        self.validate_required(self.project_member_type, 'project_member_type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.project_role_list, 'project_role_list')
        if self.project_role_list:
            for k in self.project_role_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nick is not None:
            result['Nick'] = self.nick
        if self.project_member_id is not None:
            result['ProjectMemberId'] = self.project_member_id
        if self.project_member_name is not None:
            result['ProjectMemberName'] = self.project_member_name
        if self.project_member_type is not None:
            result['ProjectMemberType'] = self.project_member_type
        if self.status is not None:
            result['Status'] = self.status
        result['ProjectRoleList'] = []
        if self.project_role_list is not None:
            for k in self.project_role_list:
                result['ProjectRoleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Nick') is not None:
            self.nick = m.get('Nick')
        if m.get('ProjectMemberId') is not None:
            self.project_member_id = m.get('ProjectMemberId')
        if m.get('ProjectMemberName') is not None:
            self.project_member_name = m.get('ProjectMemberName')
        if m.get('ProjectMemberType') is not None:
            self.project_member_type = m.get('ProjectMemberType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.project_role_list = []
        if m.get('ProjectRoleList') is not None:
            for k in m.get('ProjectRoleList'):
                temp_model = ListProjectMembersResponseDataProjectMemberListProjectRoleList()
                self.project_role_list.append(temp_model.from_map(k))
        return self


class ListProjectMembersResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        project_member_list: List[ListProjectMembersResponseDataProjectMemberList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.project_member_list = project_member_list

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.project_member_list, 'project_member_list')
        if self.project_member_list:
            for k in self.project_member_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ProjectMemberList'] = []
        if self.project_member_list is not None:
            for k in self.project_member_list:
                result['ProjectMemberList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.project_member_list = []
        if m.get('ProjectMemberList') is not None:
            for k in m.get('ProjectMemberList'):
                temp_model = ListProjectMembersResponseDataProjectMemberList()
                self.project_member_list.append(temp_model.from_map(k))
        return self


class ListProjectMembersResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: ListProjectMembersResponseData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListProjectMembersResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateProjectMemberRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        user_id: str = None,
        client_token: str = None,
        role_code: str = None,
    ):
        self.project_id = project_id
        self.user_id = user_id
        self.client_token = client_token
        self.role_code = role_code

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        return self


class CreateProjectMemberResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListProjectRolesRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListProjectRolesResponseProjectRoleList(TeaModel):
    def __init__(
        self,
        project_role_code: str = None,
        project_role_id: int = None,
        project_role_name: str = None,
        project_role_type: str = None,
    ):
        self.project_role_code = project_role_code
        self.project_role_id = project_role_id
        self.project_role_name = project_role_name
        self.project_role_type = project_role_type

    def validate(self):
        self.validate_required(self.project_role_code, 'project_role_code')
        self.validate_required(self.project_role_id, 'project_role_id')
        self.validate_required(self.project_role_name, 'project_role_name')
        self.validate_required(self.project_role_type, 'project_role_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_role_code is not None:
            result['ProjectRoleCode'] = self.project_role_code
        if self.project_role_id is not None:
            result['ProjectRoleId'] = self.project_role_id
        if self.project_role_name is not None:
            result['ProjectRoleName'] = self.project_role_name
        if self.project_role_type is not None:
            result['ProjectRoleType'] = self.project_role_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectRoleCode') is not None:
            self.project_role_code = m.get('ProjectRoleCode')
        if m.get('ProjectRoleId') is not None:
            self.project_role_id = m.get('ProjectRoleId')
        if m.get('ProjectRoleName') is not None:
            self.project_role_name = m.get('ProjectRoleName')
        if m.get('ProjectRoleType') is not None:
            self.project_role_type = m.get('ProjectRoleType')
        return self


class ListProjectRolesResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        project_role_list: List[ListProjectRolesResponseProjectRoleList] = None,
    ):
        self.request_id = request_id
        self.project_role_list = project_role_list

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.project_role_list, 'project_role_list')
        if self.project_role_list:
            for k in self.project_role_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ProjectRoleList'] = []
        if self.project_role_list is not None:
            for k in self.project_role_list:
                result['ProjectRoleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.project_role_list = []
        if m.get('ProjectRoleList') is not None:
            for k in m.get('ProjectRoleList'):
                temp_model = ListProjectRolesResponseProjectRoleList()
                self.project_role_list.append(temp_model.from_map(k))
        return self


class AddProjectMemberToRoleRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        user_id: str = None,
        role_code: str = None,
        client_token: str = None,
    ):
        self.project_id = project_id
        self.user_id = user_id
        self.role_code = role_code
        self.client_token = client_token

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.user_id, 'user_id')
        self.validate_required(self.role_code, 'role_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class AddProjectMemberToRoleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemoveProjectMemberFromRoleRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        user_id: str = None,
        role_code: str = None,
    ):
        self.project_id = project_id
        self.user_id = user_id
        self.role_code = role_code

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.user_id, 'user_id')
        self.validate_required(self.role_code, 'role_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        return self


class RemoveProjectMemberFromRoleResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteProjectMemberRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        user_id: str = None,
    ):
        self.project_id = project_id
        self.user_id = user_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.user_id, 'user_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DeleteProjectMemberResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDagComplementRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        start_biz_date: str = None,
        name: str = None,
        root_node_id: int = None,
        include_node_ids: str = None,
        exclude_node_ids: str = None,
        biz_begin_time: str = None,
        biz_end_time: str = None,
        parallelism: bool = None,
        end_biz_date: str = None,
        node_params: str = None,
    ):
        self.project_env = project_env
        self.start_biz_date = start_biz_date
        self.name = name
        self.root_node_id = root_node_id
        self.include_node_ids = include_node_ids
        self.exclude_node_ids = exclude_node_ids
        self.biz_begin_time = biz_begin_time
        self.biz_end_time = biz_end_time
        self.parallelism = parallelism
        self.end_biz_date = end_biz_date
        self.node_params = node_params

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.start_biz_date, 'start_biz_date')
        self.validate_required(self.name, 'name')
        self.validate_required(self.root_node_id, 'root_node_id')
        self.validate_required(self.include_node_ids, 'include_node_ids')
        self.validate_required(self.parallelism, 'parallelism')
        self.validate_required(self.end_biz_date, 'end_biz_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.start_biz_date is not None:
            result['StartBizDate'] = self.start_biz_date
        if self.name is not None:
            result['Name'] = self.name
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        if self.biz_begin_time is not None:
            result['BizBeginTime'] = self.biz_begin_time
        if self.biz_end_time is not None:
            result['BizEndTime'] = self.biz_end_time
        if self.parallelism is not None:
            result['Parallelism'] = self.parallelism
        if self.end_biz_date is not None:
            result['EndBizDate'] = self.end_biz_date
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('StartBizDate') is not None:
            self.start_biz_date = m.get('StartBizDate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        if m.get('BizBeginTime') is not None:
            self.biz_begin_time = m.get('BizBeginTime')
        if m.get('BizEndTime') is not None:
            self.biz_end_time = m.get('BizEndTime')
        if m.get('Parallelism') is not None:
            self.parallelism = m.get('Parallelism')
        if m.get('EndBizDate') is not None:
            self.end_biz_date = m.get('EndBizDate')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        return self


class CreateDagComplementResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: List[int] = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateDagTestRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        bizdate: str = None,
        name: str = None,
        node_id: int = None,
        node_params: str = None,
    ):
        self.project_env = project_env
        self.bizdate = bizdate
        self.name = name
        self.node_id = node_id
        self.node_params = node_params

    def validate(self):
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.bizdate, 'bizdate')
        self.validate_required(self.name, 'name')
        self.validate_required(self.node_id, 'node_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        return self


class CreateDagTestResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: int = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ListCalcEnginesRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        calc_engine_type: str = None,
        env_type: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.calc_engine_type = calc_engine_type
        self.env_type = env_type
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.calc_engine_type, 'calc_engine_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.calc_engine_type is not None:
            result['CalcEngineType'] = self.calc_engine_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CalcEngineType') is not None:
            self.calc_engine_type = m.get('CalcEngineType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ListCalcEnginesResponseDataCalcEngines(TeaModel):
    def __init__(
        self,
        calc_engine_type: str = None,
        gmt_create: str = None,
        dw_region: str = None,
        is_default: bool = None,
        binding_project_id: int = None,
        env_type: str = None,
        tenant_id: int = None,
        name: str = None,
        binding_project_name: str = None,
        region: str = None,
        engine_id: int = None,
        engine_info: Dict[str, Any] = None,
        task_auth_type: str = None,
    ):
        self.calc_engine_type = calc_engine_type
        self.gmt_create = gmt_create
        self.dw_region = dw_region
        self.is_default = is_default
        self.binding_project_id = binding_project_id
        self.env_type = env_type
        self.tenant_id = tenant_id
        self.name = name
        self.binding_project_name = binding_project_name
        self.region = region
        self.engine_id = engine_id
        self.engine_info = engine_info
        self.task_auth_type = task_auth_type

    def validate(self):
        self.validate_required(self.calc_engine_type, 'calc_engine_type')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.dw_region, 'dw_region')
        self.validate_required(self.is_default, 'is_default')
        self.validate_required(self.binding_project_id, 'binding_project_id')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.binding_project_name, 'binding_project_name')
        self.validate_required(self.region, 'region')
        self.validate_required(self.engine_id, 'engine_id')
        self.validate_required(self.engine_info, 'engine_info')
        self.validate_required(self.task_auth_type, 'task_auth_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calc_engine_type is not None:
            result['CalcEngineType'] = self.calc_engine_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.dw_region is not None:
            result['DwRegion'] = self.dw_region
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.binding_project_id is not None:
            result['BindingProjectId'] = self.binding_project_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.name is not None:
            result['Name'] = self.name
        if self.binding_project_name is not None:
            result['BindingProjectName'] = self.binding_project_name
        if self.region is not None:
            result['Region'] = self.region
        if self.engine_id is not None:
            result['EngineId'] = self.engine_id
        if self.engine_info is not None:
            result['EngineInfo'] = self.engine_info
        if self.task_auth_type is not None:
            result['TaskAuthType'] = self.task_auth_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalcEngineType') is not None:
            self.calc_engine_type = m.get('CalcEngineType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DwRegion') is not None:
            self.dw_region = m.get('DwRegion')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('BindingProjectId') is not None:
            self.binding_project_id = m.get('BindingProjectId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('BindingProjectName') is not None:
            self.binding_project_name = m.get('BindingProjectName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('EngineId') is not None:
            self.engine_id = m.get('EngineId')
        if m.get('EngineInfo') is not None:
            self.engine_info = m.get('EngineInfo')
        if m.get('TaskAuthType') is not None:
            self.task_auth_type = m.get('TaskAuthType')
        return self


class ListCalcEnginesResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        calc_engines: List[ListCalcEnginesResponseDataCalcEngines] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.calc_engines = calc_engines

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.calc_engines, 'calc_engines')
        if self.calc_engines:
            for k in self.calc_engines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['CalcEngines'] = []
        if self.calc_engines is not None:
            for k in self.calc_engines:
                result['CalcEngines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.calc_engines = []
        if m.get('CalcEngines') is not None:
            for k in m.get('CalcEngines'):
                temp_model = ListCalcEnginesResponseDataCalcEngines()
                self.calc_engines.append(temp_model.from_map(k))
        return self


class ListCalcEnginesResponse(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        success: bool = None,
        request_id: str = None,
        data: ListCalcEnginesResponseData = None,
    ):
        self.http_status_code = http_status_code
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListCalcEnginesResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListConnectionsRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        connection_type: str = None,
        sub_type: str = None,
        status: str = None,
        env_type: int = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.connection_type = connection_type
        self.sub_type = sub_type
        self.status = status
        self.env_type = env_type
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.status is not None:
            result['Status'] = self.status
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ListConnectionsResponseDataConnections(TeaModel):
    def __init__(
        self,
        shared: bool = None,
        gmt_modified: str = None,
        connect_status: int = None,
        binding_calc_engine_id: int = None,
        description: str = None,
        connection_type: str = None,
        gmt_create: str = None,
        default_engine: bool = None,
        operator: str = None,
        sequence: int = None,
        env_type: int = None,
        tenant_id: int = None,
        name: str = None,
        sub_type: str = None,
        id: int = None,
        project_id: int = None,
        status: int = None,
        content: str = None,
    ):
        self.shared = shared
        self.gmt_modified = gmt_modified
        self.connect_status = connect_status
        self.binding_calc_engine_id = binding_calc_engine_id
        self.description = description
        self.connection_type = connection_type
        self.gmt_create = gmt_create
        self.default_engine = default_engine
        self.operator = operator
        self.sequence = sequence
        self.env_type = env_type
        self.tenant_id = tenant_id
        self.name = name
        self.sub_type = sub_type
        self.id = id
        self.project_id = project_id
        self.status = status
        self.content = content

    def validate(self):
        self.validate_required(self.shared, 'shared')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.connect_status, 'connect_status')
        self.validate_required(self.binding_calc_engine_id, 'binding_calc_engine_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.connection_type, 'connection_type')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.default_engine, 'default_engine')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.sequence, 'sequence')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.sub_type, 'sub_type')
        self.validate_required(self.id, 'id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.content, 'content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.description is not None:
            result['Description'] = self.description
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.name is not None:
            result['Name'] = self.name
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.id is not None:
            result['Id'] = self.id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class ListConnectionsResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        connections: List[ListConnectionsResponseDataConnections] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.connections = connections

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.connections, 'connections')
        if self.connections:
            for k in self.connections:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Connections'] = []
        if self.connections is not None:
            for k in self.connections:
                result['Connections'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.connections = []
        if m.get('Connections') is not None:
            for k in m.get('Connections'):
                temp_model = ListConnectionsResponseDataConnections()
                self.connections.append(temp_model.from_map(k))
        return self


class ListConnectionsResponse(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        success: bool = None,
        request_id: str = None,
        data: ListConnectionsResponseData = None,
    ):
        self.http_status_code = http_status_code
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListConnectionsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateConnectionRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        env_type: int = None,
        content: str = None,
        status: str = None,
        connection_id: int = None,
    ):
        self.description = description
        self.env_type = env_type
        self.content = content
        self.status = status
        self.connection_id = connection_id

    def validate(self):
        self.validate_required(self.connection_id, 'connection_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.content is not None:
            result['Content'] = self.content
        if self.status is not None:
            result['Status'] = self.status
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class UpdateConnectionResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: str = None,
        data: bool = None,
        request_id: str = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteConnectionRequest(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
    ):
        self.connection_id = connection_id

    def validate(self):
        self.validate_required(self.connection_id, 'connection_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class DeleteConnectionResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: str = None,
        data: bool = None,
        request_id: str = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetProjectDetailRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetProjectDetailResponseData(TeaModel):
    def __init__(
        self,
        gmt_modified: str = None,
        default_di_resource_group_identifier: str = None,
        is_allow_download: int = None,
        scheduler_retry_interval: int = None,
        resident_area: str = None,
        project_owner_base_id: str = None,
        project_mode: int = None,
        gmt_create: str = None,
        protected_mode: int = None,
        tenant_id: int = None,
        project_description: str = None,
        scheduler_max_retry_times: int = None,
        project_name: str = None,
        project_identifier: str = None,
        project_id: int = None,
        status: int = None,
        development_type: int = None,
        env_types: List[str] = None,
    ):
        self.gmt_modified = gmt_modified
        self.default_di_resource_group_identifier = default_di_resource_group_identifier
        self.is_allow_download = is_allow_download
        self.scheduler_retry_interval = scheduler_retry_interval
        self.resident_area = resident_area
        self.project_owner_base_id = project_owner_base_id
        self.project_mode = project_mode
        self.gmt_create = gmt_create
        self.protected_mode = protected_mode
        self.tenant_id = tenant_id
        self.project_description = project_description
        self.scheduler_max_retry_times = scheduler_max_retry_times
        self.project_name = project_name
        self.project_identifier = project_identifier
        self.project_id = project_id
        self.status = status
        self.development_type = development_type
        self.env_types = env_types

    def validate(self):
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.default_di_resource_group_identifier, 'default_di_resource_group_identifier')
        self.validate_required(self.is_allow_download, 'is_allow_download')
        self.validate_required(self.scheduler_retry_interval, 'scheduler_retry_interval')
        self.validate_required(self.resident_area, 'resident_area')
        self.validate_required(self.project_owner_base_id, 'project_owner_base_id')
        self.validate_required(self.project_mode, 'project_mode')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.protected_mode, 'protected_mode')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_description, 'project_description')
        self.validate_required(self.scheduler_max_retry_times, 'scheduler_max_retry_times')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.project_identifier, 'project_identifier')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.development_type, 'development_type')
        self.validate_required(self.env_types, 'env_types')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.default_di_resource_group_identifier is not None:
            result['DefaultDiResourceGroupIdentifier'] = self.default_di_resource_group_identifier
        if self.is_allow_download is not None:
            result['IsAllowDownload'] = self.is_allow_download
        if self.scheduler_retry_interval is not None:
            result['SchedulerRetryInterval'] = self.scheduler_retry_interval
        if self.resident_area is not None:
            result['ResidentArea'] = self.resident_area
        if self.project_owner_base_id is not None:
            result['ProjectOwnerBaseId'] = self.project_owner_base_id
        if self.project_mode is not None:
            result['ProjectMode'] = self.project_mode
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.protected_mode is not None:
            result['ProtectedMode'] = self.protected_mode
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_description is not None:
            result['ProjectDescription'] = self.project_description
        if self.scheduler_max_retry_times is not None:
            result['SchedulerMaxRetryTimes'] = self.scheduler_max_retry_times
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.development_type is not None:
            result['DevelopmentType'] = self.development_type
        if self.env_types is not None:
            result['EnvTypes'] = self.env_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('DefaultDiResourceGroupIdentifier') is not None:
            self.default_di_resource_group_identifier = m.get('DefaultDiResourceGroupIdentifier')
        if m.get('IsAllowDownload') is not None:
            self.is_allow_download = m.get('IsAllowDownload')
        if m.get('SchedulerRetryInterval') is not None:
            self.scheduler_retry_interval = m.get('SchedulerRetryInterval')
        if m.get('ResidentArea') is not None:
            self.resident_area = m.get('ResidentArea')
        if m.get('ProjectOwnerBaseId') is not None:
            self.project_owner_base_id = m.get('ProjectOwnerBaseId')
        if m.get('ProjectMode') is not None:
            self.project_mode = m.get('ProjectMode')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ProtectedMode') is not None:
            self.protected_mode = m.get('ProtectedMode')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectDescription') is not None:
            self.project_description = m.get('ProjectDescription')
        if m.get('SchedulerMaxRetryTimes') is not None:
            self.scheduler_max_retry_times = m.get('SchedulerMaxRetryTimes')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DevelopmentType') is not None:
            self.development_type = m.get('DevelopmentType')
        if m.get('EnvTypes') is not None:
            self.env_types = m.get('EnvTypes')
        return self


class GetProjectDetailResponse(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        success: bool = None,
        request_id: str = None,
        data: GetProjectDetailResponseData = None,
    ):
        self.http_status_code = http_status_code
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetProjectDetailResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListResourceGroupsRequest(TeaModel):
    def __init__(
        self,
        resource_group_type: int = None,
        keyword: str = None,
        biz_ext_key: str = None,
    ):
        self.resource_group_type = resource_group_type
        self.keyword = keyword
        self.biz_ext_key = biz_ext_key

    def validate(self):
        self.validate_required(self.resource_group_type, 'resource_group_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_group_type is not None:
            result['ResourceGroupType'] = self.resource_group_type
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.biz_ext_key is not None:
            result['BizExtKey'] = self.biz_ext_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceGroupType') is not None:
            self.resource_group_type = m.get('ResourceGroupType')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('BizExtKey') is not None:
            self.biz_ext_key = m.get('BizExtKey')
        return self


class ListResourceGroupsResponseData(TeaModel):
    def __init__(
        self,
        identifier: str = None,
        cluster: str = None,
        biz_ext_key: str = None,
        enable_kp: bool = None,
        update_time: str = None,
        resource_group_type: str = None,
        mode: str = None,
        sequence: int = None,
        is_default: bool = None,
        create_time: str = None,
        name: str = None,
        tenant_id: int = None,
        id: int = None,
        status: int = None,
        specs: Dict[str, Any] = None,
    ):
        self.identifier = identifier
        self.cluster = cluster
        self.biz_ext_key = biz_ext_key
        self.enable_kp = enable_kp
        self.update_time = update_time
        self.resource_group_type = resource_group_type
        self.mode = mode
        self.sequence = sequence
        self.is_default = is_default
        self.create_time = create_time
        self.name = name
        self.tenant_id = tenant_id
        self.id = id
        self.status = status
        self.specs = specs

    def validate(self):
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.cluster, 'cluster')
        self.validate_required(self.biz_ext_key, 'biz_ext_key')
        self.validate_required(self.enable_kp, 'enable_kp')
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.resource_group_type, 'resource_group_type')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.sequence, 'sequence')
        self.validate_required(self.is_default, 'is_default')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.name, 'name')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.id, 'id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.specs, 'specs')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.cluster is not None:
            result['Cluster'] = self.cluster
        if self.biz_ext_key is not None:
            result['BizExtKey'] = self.biz_ext_key
        if self.enable_kp is not None:
            result['EnableKp'] = self.enable_kp
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.resource_group_type is not None:
            result['ResourceGroupType'] = self.resource_group_type
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.name is not None:
            result['Name'] = self.name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        if self.specs is not None:
            result['Specs'] = self.specs
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Cluster') is not None:
            self.cluster = m.get('Cluster')
        if m.get('BizExtKey') is not None:
            self.biz_ext_key = m.get('BizExtKey')
        if m.get('EnableKp') is not None:
            self.enable_kp = m.get('EnableKp')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('ResourceGroupType') is not None:
            self.resource_group_type = m.get('ResourceGroupType')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Specs') is not None:
            self.specs = m.get('Specs')
        return self


class ListResourceGroupsResponse(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        success: bool = None,
        request_id: str = None,
        data: List[ListResourceGroupsResponseData] = None,
    ):
        self.http_status_code = http_status_code
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListResourceGroupsResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class CreateConnectionRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        description: str = None,
        connection_type: str = None,
        sub_type: str = None,
        env_type: int = None,
        content: str = None,
    ):
        self.project_id = project_id
        self.name = name
        self.description = description
        self.connection_type = connection_type
        self.sub_type = sub_type
        self.env_type = env_type
        self.content = content

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.connection_type, 'connection_type')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.content, 'content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateConnectionResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: str = None,
        data: int = None,
        request_id: str = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDataServiceApplicationRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        application_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.application_id = application_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.application_id, 'application_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class GetDataServiceApplicationResponseData(TeaModel):
    def __init__(
        self,
        application_code: str = None,
        application_id: int = None,
        application_key: str = None,
        application_name: str = None,
        application_secret: str = None,
        project_id: int = None,
    ):
        self.application_code = application_code
        self.application_id = application_id
        self.application_key = application_key
        self.application_name = application_name
        self.application_secret = application_secret
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.application_code, 'application_code')
        self.validate_required(self.application_id, 'application_id')
        self.validate_required(self.application_key, 'application_key')
        self.validate_required(self.application_name, 'application_name')
        self.validate_required(self.application_secret, 'application_secret')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_code is not None:
            result['ApplicationCode'] = self.application_code
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_key is not None:
            result['ApplicationKey'] = self.application_key
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_secret is not None:
            result['ApplicationSecret'] = self.application_secret
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationCode') is not None:
            self.application_code = m.get('ApplicationCode')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationKey') is not None:
            self.application_key = m.get('ApplicationKey')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationSecret') is not None:
            self.application_secret = m.get('ApplicationSecret')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetDataServiceApplicationResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: GetDataServiceApplicationResponseData = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDataServiceApplicationResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDataServiceApplicationsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        project_id_list: str = None,
        tenant_id: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.project_id_list = project_id_list
        self.tenant_id = tenant_id

    def validate(self):
        self.validate_required(self.project_id_list, 'project_id_list')
        self.validate_required(self.tenant_id, 'tenant_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id_list is not None:
            result['ProjectIdList'] = self.project_id_list
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectIdList') is not None:
            self.project_id_list = m.get('ProjectIdList')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListDataServiceApplicationsResponseDataApplications(TeaModel):
    def __init__(
        self,
        application_id: int = None,
        application_name: str = None,
        project_id: int = None,
    ):
        self.application_id = application_id
        self.application_name = application_name
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.application_id, 'application_id')
        self.validate_required(self.application_name, 'application_name')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListDataServiceApplicationsResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        applications: List[ListDataServiceApplicationsResponseDataApplications] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.applications = applications

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.applications, 'applications')
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListDataServiceApplicationsResponseDataApplications()
                self.applications.append(temp_model.from_map(k))
        return self


class ListDataServiceApplicationsResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: ListDataServiceApplicationsResponseData = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListDataServiceApplicationsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeOnBaselineRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
    ):
        self.baseline_id = baseline_id

    def validate(self):
        self.validate_required(self.baseline_id, 'baseline_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetNodeOnBaselineResponseData(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetNodeOnBaselineResponse(TeaModel):
    def __init__(
        self,
        success: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: List[GetNodeOnBaselineResponseData] = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetNodeOnBaselineResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class ListBaselineConfigsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        owner: str = None,
        project_id: int = None,
        priority: str = None,
        useflag: bool = None,
        baseline_types: str = None,
        search_text: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.owner = owner
        self.project_id = project_id
        self.priority = priority
        self.useflag = useflag
        self.baseline_types = baseline_types
        self.search_text = search_text

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.useflag is not None:
            result['Useflag'] = self.useflag
        if self.baseline_types is not None:
            result['BaselineTypes'] = self.baseline_types
        if self.search_text is not None:
            result['SearchText'] = self.search_text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Useflag') is not None:
            self.useflag = m.get('Useflag')
        if m.get('BaselineTypes') is not None:
            self.baseline_types = m.get('BaselineTypes')
        if m.get('SearchText') is not None:
            self.search_text = m.get('SearchText')
        return self


class ListBaselineConfigsResponseDataBaselines(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        priority: int = None,
        baseline_name: str = None,
        owner: str = None,
        project_id: int = None,
        use_flag: bool = None,
        baseline_type: str = None,
        exp_hour: int = None,
        exp_minu: int = None,
        sla_hour: int = None,
        sla_minu: int = None,
        hour_exp_detail: str = None,
        hour_sla_detail: str = None,
        is_default: bool = None,
    ):
        self.baseline_id = baseline_id
        self.priority = priority
        self.baseline_name = baseline_name
        self.owner = owner
        self.project_id = project_id
        self.use_flag = use_flag
        self.baseline_type = baseline_type
        self.exp_hour = exp_hour
        self.exp_minu = exp_minu
        self.sla_hour = sla_hour
        self.sla_minu = sla_minu
        self.hour_exp_detail = hour_exp_detail
        self.hour_sla_detail = hour_sla_detail
        self.is_default = is_default

    def validate(self):
        self.validate_required(self.baseline_id, 'baseline_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.baseline_name, 'baseline_name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.use_flag, 'use_flag')
        self.validate_required(self.baseline_type, 'baseline_type')
        self.validate_required(self.exp_hour, 'exp_hour')
        self.validate_required(self.exp_minu, 'exp_minu')
        self.validate_required(self.sla_hour, 'sla_hour')
        self.validate_required(self.sla_minu, 'sla_minu')
        self.validate_required(self.hour_exp_detail, 'hour_exp_detail')
        self.validate_required(self.hour_sla_detail, 'hour_sla_detail')
        self.validate_required(self.is_default, 'is_default')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.use_flag is not None:
            result['UseFlag'] = self.use_flag
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.exp_hour is not None:
            result['ExpHour'] = self.exp_hour
        if self.exp_minu is not None:
            result['ExpMinu'] = self.exp_minu
        if self.sla_hour is not None:
            result['SlaHour'] = self.sla_hour
        if self.sla_minu is not None:
            result['SlaMinu'] = self.sla_minu
        if self.hour_exp_detail is not None:
            result['HourExpDetail'] = self.hour_exp_detail
        if self.hour_sla_detail is not None:
            result['HourSlaDetail'] = self.hour_sla_detail
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UseFlag') is not None:
            self.use_flag = m.get('UseFlag')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('ExpHour') is not None:
            self.exp_hour = m.get('ExpHour')
        if m.get('ExpMinu') is not None:
            self.exp_minu = m.get('ExpMinu')
        if m.get('SlaHour') is not None:
            self.sla_hour = m.get('SlaHour')
        if m.get('SlaMinu') is not None:
            self.sla_minu = m.get('SlaMinu')
        if m.get('HourExpDetail') is not None:
            self.hour_exp_detail = m.get('HourExpDetail')
        if m.get('HourSlaDetail') is not None:
            self.hour_sla_detail = m.get('HourSlaDetail')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        return self


class ListBaselineConfigsResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        baselines: List[ListBaselineConfigsResponseDataBaselines] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.baselines = baselines

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.baselines, 'baselines')
        if self.baselines:
            for k in self.baselines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Baselines'] = []
        if self.baselines is not None:
            for k in self.baselines:
                result['Baselines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.baselines = []
        if m.get('Baselines') is not None:
            for k in m.get('Baselines'):
                temp_model = ListBaselineConfigsResponseDataBaselines()
                self.baselines.append(temp_model.from_map(k))
        return self


class ListBaselineConfigsResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: ListBaselineConfigsResponseData = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListBaselineConfigsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableChangeLogRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_guid: str = None,
        change_type: str = None,
        object_type: str = None,
        start_date: str = None,
        end_date: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.table_guid = table_guid
        self.change_type = change_type
        self.object_type = object_type
        self.start_date = start_date
        self.end_date = end_date

    def validate(self):
        self.validate_required(self.table_guid, 'table_guid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetMetaTableChangeLogResponseDataDataEntityList(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        modified_time: int = None,
        change_type: str = None,
        operator: str = None,
        object_type: str = None,
        change_content: str = None,
    ):
        self.create_time = create_time
        self.modified_time = modified_time
        self.change_type = change_type
        self.operator = operator
        self.object_type = object_type
        self.change_content = change_content

    def validate(self):
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.change_type, 'change_type')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.object_type, 'object_type')
        self.validate_required(self.change_content, 'change_content')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.change_content is not None:
            result['ChangeContent'] = self.change_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('ChangeContent') is not None:
            self.change_content = m.get('ChangeContent')
        return self


class GetMetaTableChangeLogResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[GetMetaTableChangeLogResponseDataDataEntityList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data_entity_list, 'data_entity_list')
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableChangeLogResponseDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTableChangeLogResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: GetMetaTableChangeLogResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetMetaTableChangeLogResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableOutputRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_guid: str = None,
        start_date: str = None,
        end_date: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.table_guid = table_guid
        self.start_date = start_date
        self.end_date = end_date

    def validate(self):
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.start_date, 'start_date')
        self.validate_required(self.end_date, 'end_date')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetMetaTableOutputResponseDataDataEntityList(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        task_id: str = None,
        start_time: str = None,
        end_time: str = None,
        wait_time: str = None,
        project_id: int = None,
        task_instance_id: int = None,
    ):
        self.table_guid = table_guid
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.wait_time = wait_time
        self.project_id = project_id
        self.task_instance_id = task_instance_id

    def validate(self):
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.wait_time, 'wait_time')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.task_instance_id, 'task_instance_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.wait_time is not None:
            result['WaitTime'] = self.wait_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_instance_id is not None:
            result['TaskInstanceId'] = self.task_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('WaitTime') is not None:
            self.wait_time = m.get('WaitTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskInstanceId') is not None:
            self.task_instance_id = m.get('TaskInstanceId')
        return self


class GetMetaTableOutputResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[GetMetaTableOutputResponseDataDataEntityList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data_entity_list, 'data_entity_list')
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableOutputResponseDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTableOutputResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: GetMetaTableOutputResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetMetaTableOutputResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTablePartitionRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_guid: str = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.table_guid = table_guid
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTablePartitionResponseDataDataEntityList(TeaModel):
    def __init__(
        self,
        partition_guid: str = None,
        partition_name: str = None,
        create_time: int = None,
        data_size: int = None,
        record_count: int = None,
        modified_time: int = None,
        table_guid: str = None,
        comment: str = None,
        partition_type: str = None,
        partition_path: str = None,
        partition_location: str = None,
    ):
        self.partition_guid = partition_guid
        self.partition_name = partition_name
        self.create_time = create_time
        self.data_size = data_size
        self.record_count = record_count
        self.modified_time = modified_time
        self.table_guid = table_guid
        self.comment = comment
        self.partition_type = partition_type
        self.partition_path = partition_path
        self.partition_location = partition_location

    def validate(self):
        self.validate_required(self.partition_guid, 'partition_guid')
        self.validate_required(self.partition_name, 'partition_name')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.data_size, 'data_size')
        self.validate_required(self.record_count, 'record_count')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.partition_type, 'partition_type')
        self.validate_required(self.partition_path, 'partition_path')
        self.validate_required(self.partition_location, 'partition_location')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.partition_guid is not None:
            result['PartitionGuid'] = self.partition_guid
        if self.partition_name is not None:
            result['PartitionName'] = self.partition_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.record_count is not None:
            result['RecordCount'] = self.record_count
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.partition_type is not None:
            result['PartitionType'] = self.partition_type
        if self.partition_path is not None:
            result['PartitionPath'] = self.partition_path
        if self.partition_location is not None:
            result['PartitionLocation'] = self.partition_location
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PartitionGuid') is not None:
            self.partition_guid = m.get('PartitionGuid')
        if m.get('PartitionName') is not None:
            self.partition_name = m.get('PartitionName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('RecordCount') is not None:
            self.record_count = m.get('RecordCount')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('PartitionType') is not None:
            self.partition_type = m.get('PartitionType')
        if m.get('PartitionPath') is not None:
            self.partition_path = m.get('PartitionPath')
        if m.get('PartitionLocation') is not None:
            self.partition_location = m.get('PartitionLocation')
        return self


class GetMetaTablePartitionResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[GetMetaTablePartitionResponseDataDataEntityList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data_entity_list, 'data_entity_list')
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTablePartitionResponseDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTablePartitionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: GetMetaTablePartitionResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetMetaTablePartitionResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableFullInfoRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        page_num: int = None,
        page_size: int = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.page_num = page_num
        self.page_size = page_size
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableFullInfoResponseDataColumnList(TeaModel):
    def __init__(
        self,
        column_guid: str = None,
        column_name: str = None,
        column_type: str = None,
        is_primary_key: bool = None,
        comment: str = None,
        is_partition_column: bool = None,
        is_foreign_key: bool = None,
        caption: str = None,
        position: int = None,
    ):
        self.column_guid = column_guid
        self.column_name = column_name
        self.column_type = column_type
        self.is_primary_key = is_primary_key
        self.comment = comment
        self.is_partition_column = is_partition_column
        self.is_foreign_key = is_foreign_key
        self.caption = caption
        self.position = position

    def validate(self):
        self.validate_required(self.column_guid, 'column_guid')
        self.validate_required(self.column_name, 'column_name')
        self.validate_required(self.column_type, 'column_type')
        self.validate_required(self.is_primary_key, 'is_primary_key')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.is_partition_column, 'is_partition_column')
        self.validate_required(self.is_foreign_key, 'is_foreign_key')
        self.validate_required(self.caption, 'caption')
        self.validate_required(self.position, 'position')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class GetMetaTableFullInfoResponseData(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        table_guid: str = None,
        owner_id: str = None,
        tenant_id: int = None,
        project_id: int = None,
        create_time: int = None,
        last_modify_time: int = None,
        life_cycle: int = None,
        is_visible: int = None,
        project_name: str = None,
        data_size: int = None,
        env_type: int = None,
        comment: str = None,
        total_column_count: int = None,
        last_ddl_time: int = None,
        last_access_time: int = None,
        database_name: str = None,
        partition_keys: str = None,
        location: str = None,
        cluster_id: str = None,
        column_list: List[GetMetaTableFullInfoResponseDataColumnList] = None,
    ):
        self.table_name = table_name
        self.table_guid = table_guid
        self.owner_id = owner_id
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.create_time = create_time
        self.last_modify_time = last_modify_time
        self.life_cycle = life_cycle
        self.is_visible = is_visible
        self.project_name = project_name
        self.data_size = data_size
        self.env_type = env_type
        self.comment = comment
        self.total_column_count = total_column_count
        self.last_ddl_time = last_ddl_time
        self.last_access_time = last_access_time
        self.database_name = database_name
        self.partition_keys = partition_keys
        self.location = location
        self.cluster_id = cluster_id
        self.column_list = column_list

    def validate(self):
        self.validate_required(self.table_name, 'table_name')
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.last_modify_time, 'last_modify_time')
        self.validate_required(self.life_cycle, 'life_cycle')
        self.validate_required(self.is_visible, 'is_visible')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.data_size, 'data_size')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.total_column_count, 'total_column_count')
        self.validate_required(self.last_ddl_time, 'last_ddl_time')
        self.validate_required(self.last_access_time, 'last_access_time')
        self.validate_required(self.database_name, 'database_name')
        self.validate_required(self.partition_keys, 'partition_keys')
        self.validate_required(self.location, 'location')
        self.validate_required(self.cluster_id, 'cluster_id')
        self.validate_required(self.column_list, 'column_list')
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.total_column_count is not None:
            result['TotalColumnCount'] = self.total_column_count
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.location is not None:
            result['Location'] = self.location
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('TotalColumnCount') is not None:
            self.total_column_count = m.get('TotalColumnCount')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableFullInfoResponseDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        return self


class GetMetaTableFullInfoResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: GetMetaTableFullInfoResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetMetaTableFullInfoResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetFileVersionRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
        file_version: int = None,
    ):
        self.file_id = file_id
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.file_version = file_version

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.file_version, 'file_version')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        return self


class GetFileVersionResponseData(TeaModel):
    def __init__(
        self,
        file_version: int = None,
        file_content: str = None,
        file_property_content: str = None,
        node_content: str = None,
        comment: str = None,
        node_id: int = None,
        is_current_prod: bool = None,
        change_type: str = None,
        status: str = None,
        file_name: str = None,
        commit_user: str = None,
        commit_time: int = None,
        use_type: str = None,
    ):
        self.file_version = file_version
        self.file_content = file_content
        self.file_property_content = file_property_content
        self.node_content = node_content
        self.comment = comment
        self.node_id = node_id
        self.is_current_prod = is_current_prod
        self.change_type = change_type
        self.status = status
        self.file_name = file_name
        self.commit_user = commit_user
        self.commit_time = commit_time
        self.use_type = use_type

    def validate(self):
        self.validate_required(self.file_version, 'file_version')
        self.validate_required(self.file_content, 'file_content')
        self.validate_required(self.file_property_content, 'file_property_content')
        self.validate_required(self.node_content, 'node_content')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.is_current_prod, 'is_current_prod')
        self.validate_required(self.change_type, 'change_type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.commit_user, 'commit_user')
        self.validate_required(self.commit_time, 'commit_time')
        self.validate_required(self.use_type, 'use_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.file_content is not None:
            result['FileContent'] = self.file_content
        if self.file_property_content is not None:
            result['FilePropertyContent'] = self.file_property_content
        if self.node_content is not None:
            result['NodeContent'] = self.node_content
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.is_current_prod is not None:
            result['IsCurrentProd'] = self.is_current_prod
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.status is not None:
            result['Status'] = self.status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.commit_user is not None:
            result['CommitUser'] = self.commit_user
        if self.commit_time is not None:
            result['CommitTime'] = self.commit_time
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('FileContent') is not None:
            self.file_content = m.get('FileContent')
        if m.get('FilePropertyContent') is not None:
            self.file_property_content = m.get('FilePropertyContent')
        if m.get('NodeContent') is not None:
            self.node_content = m.get('NodeContent')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('IsCurrentProd') is not None:
            self.is_current_prod = m.get('IsCurrentProd')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('CommitUser') is not None:
            self.commit_user = m.get('CommitUser')
        if m.get('CommitTime') is not None:
            self.commit_time = m.get('CommitTime')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetFileVersionResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        data: GetFileVersionResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            temp_model = GetFileVersionResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableBasicInfoRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
        extension: bool = None,
    ):
        self.table_guid = table_guid
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type
        self.extension = extension

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.extension is not None:
            result['Extension'] = self.extension
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        return self


class GetMetaTableBasicInfoResponseData(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        table_guid: str = None,
        owner_id: str = None,
        tenant_id: int = None,
        project_id: int = None,
        create_time: int = None,
        last_modify_time: int = None,
        life_cycle: int = None,
        is_visible: int = None,
        last_ddl_time: int = None,
        last_access_time: int = None,
        env_type: int = None,
        data_size: int = None,
        comment: str = None,
        project_name: str = None,
        database_name: str = None,
        partition_keys: str = None,
        location: str = None,
        cluster_id: str = None,
        caption: str = None,
        is_partition_table: bool = None,
        read_count: int = None,
        view_count: int = None,
        favorite_count: int = None,
        is_view: bool = None,
        column_count: int = None,
    ):
        self.table_name = table_name
        self.table_guid = table_guid
        self.owner_id = owner_id
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.create_time = create_time
        self.last_modify_time = last_modify_time
        self.life_cycle = life_cycle
        self.is_visible = is_visible
        self.last_ddl_time = last_ddl_time
        self.last_access_time = last_access_time
        self.env_type = env_type
        self.data_size = data_size
        self.comment = comment
        self.project_name = project_name
        self.database_name = database_name
        self.partition_keys = partition_keys
        self.location = location
        self.cluster_id = cluster_id
        self.caption = caption
        self.is_partition_table = is_partition_table
        self.read_count = read_count
        self.view_count = view_count
        self.favorite_count = favorite_count
        self.is_view = is_view
        self.column_count = column_count

    def validate(self):
        self.validate_required(self.table_name, 'table_name')
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.last_modify_time, 'last_modify_time')
        self.validate_required(self.life_cycle, 'life_cycle')
        self.validate_required(self.is_visible, 'is_visible')
        self.validate_required(self.last_ddl_time, 'last_ddl_time')
        self.validate_required(self.last_access_time, 'last_access_time')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.data_size, 'data_size')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.database_name, 'database_name')
        self.validate_required(self.partition_keys, 'partition_keys')
        self.validate_required(self.location, 'location')
        self.validate_required(self.cluster_id, 'cluster_id')
        self.validate_required(self.caption, 'caption')
        self.validate_required(self.is_partition_table, 'is_partition_table')
        self.validate_required(self.read_count, 'read_count')
        self.validate_required(self.view_count, 'view_count')
        self.validate_required(self.favorite_count, 'favorite_count')
        self.validate_required(self.is_view, 'is_view')
        self.validate_required(self.column_count, 'column_count')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.location is not None:
            result['Location'] = self.location
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.is_partition_table is not None:
            result['IsPartitionTable'] = self.is_partition_table
        if self.read_count is not None:
            result['ReadCount'] = self.read_count
        if self.view_count is not None:
            result['ViewCount'] = self.view_count
        if self.favorite_count is not None:
            result['FavoriteCount'] = self.favorite_count
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.column_count is not None:
            result['ColumnCount'] = self.column_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('IsPartitionTable') is not None:
            self.is_partition_table = m.get('IsPartitionTable')
        if m.get('ReadCount') is not None:
            self.read_count = m.get('ReadCount')
        if m.get('ViewCount') is not None:
            self.view_count = m.get('ViewCount')
        if m.get('FavoriteCount') is not None:
            self.favorite_count = m.get('FavoriteCount')
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('ColumnCount') is not None:
            self.column_count = m.get('ColumnCount')
        return self


class GetMetaTableBasicInfoResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: GetMetaTableBasicInfoResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetMetaTableBasicInfoResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableColumnRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        page_num: int = None,
        page_size: int = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.page_num = page_num
        self.page_size = page_size
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableColumnResponseDataColumnList(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_guid: str = None,
        comment: str = None,
        is_primary_key: bool = None,
        column_type: str = None,
        is_partition_column: bool = None,
        is_foreign_key: bool = None,
        caption: str = None,
        position: int = None,
    ):
        self.column_name = column_name
        self.column_guid = column_guid
        self.comment = comment
        self.is_primary_key = is_primary_key
        self.column_type = column_type
        self.is_partition_column = is_partition_column
        self.is_foreign_key = is_foreign_key
        self.caption = caption
        self.position = position

    def validate(self):
        self.validate_required(self.column_name, 'column_name')
        self.validate_required(self.column_guid, 'column_guid')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.is_primary_key, 'is_primary_key')
        self.validate_required(self.column_type, 'column_type')
        self.validate_required(self.is_partition_column, 'is_partition_column')
        self.validate_required(self.is_foreign_key, 'is_foreign_key')
        self.validate_required(self.caption, 'caption')
        self.validate_required(self.position, 'position')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class GetMetaTableColumnResponseData(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_num: int = None,
        page_size: int = None,
        column_list: List[GetMetaTableColumnResponseDataColumnList] = None,
    ):
        self.total_count = total_count
        self.page_num = page_num
        self.page_size = page_size
        self.column_list = column_list

    def validate(self):
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.column_list, 'column_list')
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableColumnResponseDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        return self


class GetMetaTableColumnResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: GetMetaTableColumnResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetMetaTableColumnResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaDBInfoRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        cluster_id: str = None,
        database_name: str = None,
        data_source_type: str = None,
    ):
        self.app_guid = app_guid
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaDBInfoResponseData(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        tenant_id: int = None,
        endpoint: str = None,
        project_id: int = None,
        env_type: int = None,
        project_name: str = None,
        project_name_cn: str = None,
        create_time: int = None,
        modify_time: int = None,
        owner_id: str = None,
        owner_name: str = None,
        name: str = None,
        type: str = None,
        comment: str = None,
        location: str = None,
        cluster_biz_id: str = None,
    ):
        self.app_guid = app_guid
        self.tenant_id = tenant_id
        self.endpoint = endpoint
        self.project_id = project_id
        self.env_type = env_type
        self.project_name = project_name
        self.project_name_cn = project_name_cn
        self.create_time = create_time
        self.modify_time = modify_time
        self.owner_id = owner_id
        self.owner_name = owner_name
        self.name = name
        self.type = type
        self.comment = comment
        self.location = location
        self.cluster_biz_id = cluster_biz_id

    def validate(self):
        self.validate_required(self.app_guid, 'app_guid')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.endpoint, 'endpoint')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.project_name_cn, 'project_name_cn')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modify_time, 'modify_time')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.owner_name, 'owner_name')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.location, 'location')
        self.validate_required(self.cluster_biz_id, 'cluster_biz_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_name_cn is not None:
            result['ProjectNameCn'] = self.project_name_cn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_name is not None:
            result['OwnerName'] = self.owner_name
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.location is not None:
            result['Location'] = self.location
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectNameCn') is not None:
            self.project_name_cn = m.get('ProjectNameCn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerName') is not None:
            self.owner_name = m.get('OwnerName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        return self


class GetMetaDBInfoResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetMetaDBInfoResponseData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetMetaDBInfoResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        parent_category_id: int = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.parent_category_id = parent_category_id
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetMetaCategoryResponseDataDataEntityList(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        name: str = None,
        create_time: int = None,
        modified_time: int = None,
        comment: str = None,
        owner_id: str = None,
        last_operator_id: str = None,
        parent_category_id: int = None,
        depth: int = None,
    ):
        self.category_id = category_id
        self.name = name
        self.create_time = create_time
        self.modified_time = modified_time
        self.comment = comment
        self.owner_id = owner_id
        self.last_operator_id = last_operator_id
        self.parent_category_id = parent_category_id
        self.depth = depth

    def validate(self):
        self.validate_required(self.category_id, 'category_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.last_operator_id, 'last_operator_id')
        self.validate_required(self.parent_category_id, 'parent_category_id')
        self.validate_required(self.depth, 'depth')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.name is not None:
            result['Name'] = self.name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.last_operator_id is not None:
            result['LastOperatorId'] = self.last_operator_id
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        if self.depth is not None:
            result['Depth'] = self.depth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('LastOperatorId') is not None:
            self.last_operator_id = m.get('LastOperatorId')
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        if m.get('Depth') is not None:
            self.depth = m.get('Depth')
        return self


class GetMetaCategoryResponseData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[GetMetaCategoryResponseDataDataEntityList] = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data_entity_list, 'data_entity_list')
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaCategoryResponseDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: GetMetaCategoryResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetMetaCategoryResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListAlertMessagesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        begin_time: str = None,
        end_time: str = None,
        remind_id: int = None,
        alert_methods: str = None,
        alert_user: str = None,
        alert_rule_types: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.begin_time = begin_time
        self.end_time = end_time
        self.remind_id = remind_id
        self.alert_methods = alert_methods
        self.alert_user = alert_user
        self.alert_rule_types = alert_rule_types

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_user is not None:
            result['AlertUser'] = self.alert_user
        if self.alert_rule_types is not None:
            result['AlertRuleTypes'] = self.alert_rule_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertUser') is not None:
            self.alert_user = m.get('AlertUser')
        if m.get('AlertRuleTypes') is not None:
            self.alert_rule_types = m.get('AlertRuleTypes')
        return self


class ListAlertMessagesResponseDataAlertMessagesInstances(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        project_id: int = None,
        status: str = None,
        instance_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.project_id = project_id
        self.status = status
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListAlertMessagesResponseDataAlertMessagesTopics(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        instance_id: int = None,
        topic_id: int = None,
        topic_name: str = None,
        topic_owner: str = None,
        topic_status: str = None,
    ):
        self.node_id = node_id
        self.instance_id = instance_id
        self.topic_id = topic_id
        self.topic_name = topic_name
        self.topic_owner = topic_owner
        self.topic_status = topic_status

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.topic_id, 'topic_id')
        self.validate_required(self.topic_name, 'topic_name')
        self.validate_required(self.topic_owner, 'topic_owner')
        self.validate_required(self.topic_status, 'topic_status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.topic_owner is not None:
            result['TopicOwner'] = self.topic_owner
        if self.topic_status is not None:
            result['TopicStatus'] = self.topic_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('TopicOwner') is not None:
            self.topic_owner = m.get('TopicOwner')
        if m.get('TopicStatus') is not None:
            self.topic_status = m.get('TopicStatus')
        return self


class ListAlertMessagesResponseDataAlertMessagesNodes(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListAlertMessagesResponseDataAlertMessagesSlaAlert(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        baseline_name: str = None,
        baseline_owner: str = None,
        bizdate: int = None,
        in_group_id: int = None,
        project_id: int = None,
        status: str = None,
    ):
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.baseline_owner = baseline_owner
        self.bizdate = bizdate
        self.in_group_id = in_group_id
        self.project_id = project_id
        self.status = status

    def validate(self):
        self.validate_required(self.baseline_id, 'baseline_id')
        self.validate_required(self.baseline_name, 'baseline_name')
        self.validate_required(self.baseline_owner, 'baseline_owner')
        self.validate_required(self.bizdate, 'bizdate')
        self.validate_required(self.in_group_id, 'in_group_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_owner is not None:
            result['BaselineOwner'] = self.baseline_owner
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineOwner') is not None:
            self.baseline_owner = m.get('BaselineOwner')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAlertMessagesResponseDataAlertMessages(TeaModel):
    def __init__(
        self,
        alert_id: int = None,
        alert_time: int = None,
        source: str = None,
        remind_id: int = None,
        remind_name: str = None,
        alert_user: str = None,
        alert_method: str = None,
        alert_message_status: str = None,
        content: str = None,
        instances: List[ListAlertMessagesResponseDataAlertMessagesInstances] = None,
        topics: List[ListAlertMessagesResponseDataAlertMessagesTopics] = None,
        nodes: List[ListAlertMessagesResponseDataAlertMessagesNodes] = None,
        sla_alert: ListAlertMessagesResponseDataAlertMessagesSlaAlert = None,
    ):
        self.alert_id = alert_id
        self.alert_time = alert_time
        self.source = source
        self.remind_id = remind_id
        self.remind_name = remind_name
        self.alert_user = alert_user
        self.alert_method = alert_method
        self.alert_message_status = alert_message_status
        self.content = content
        self.instances = instances
        self.topics = topics
        self.nodes = nodes
        self.sla_alert = sla_alert

    def validate(self):
        self.validate_required(self.alert_id, 'alert_id')
        self.validate_required(self.alert_time, 'alert_time')
        self.validate_required(self.source, 'source')
        self.validate_required(self.remind_id, 'remind_id')
        self.validate_required(self.remind_name, 'remind_name')
        self.validate_required(self.alert_user, 'alert_user')
        self.validate_required(self.alert_method, 'alert_method')
        self.validate_required(self.alert_message_status, 'alert_message_status')
        self.validate_required(self.content, 'content')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        self.validate_required(self.topics, 'topics')
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()
        self.validate_required(self.nodes, 'nodes')
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()
        self.validate_required(self.sla_alert, 'sla_alert')
        if self.sla_alert:
            self.sla_alert.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.source is not None:
            result['Source'] = self.source
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.alert_user is not None:
            result['AlertUser'] = self.alert_user
        if self.alert_method is not None:
            result['AlertMethod'] = self.alert_method
        if self.alert_message_status is not None:
            result['AlertMessageStatus'] = self.alert_message_status
        if self.content is not None:
            result['Content'] = self.content
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.sla_alert is not None:
            result['SlaAlert'] = self.sla_alert.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('AlertUser') is not None:
            self.alert_user = m.get('AlertUser')
        if m.get('AlertMethod') is not None:
            self.alert_method = m.get('AlertMethod')
        if m.get('AlertMessageStatus') is not None:
            self.alert_message_status = m.get('AlertMessageStatus')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = ListAlertMessagesResponseDataAlertMessagesInstances()
                self.instances.append(temp_model.from_map(k))
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = ListAlertMessagesResponseDataAlertMessagesTopics()
                self.topics.append(temp_model.from_map(k))
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = ListAlertMessagesResponseDataAlertMessagesNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('SlaAlert') is not None:
            temp_model = ListAlertMessagesResponseDataAlertMessagesSlaAlert()
            self.sla_alert = temp_model.from_map(m['SlaAlert'])
        return self


class ListAlertMessagesResponseData(TeaModel):
    def __init__(
        self,
        page_number: str = None,
        page_size: str = None,
        total_count: str = None,
        alert_messages: List[ListAlertMessagesResponseDataAlertMessages] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.alert_messages = alert_messages

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.alert_messages, 'alert_messages')
        if self.alert_messages:
            for k in self.alert_messages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['AlertMessages'] = []
        if self.alert_messages is not None:
            for k in self.alert_messages:
                result['AlertMessages'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.alert_messages = []
        if m.get('AlertMessages') is not None:
            for k in m.get('AlertMessages'):
                temp_model = ListAlertMessagesResponseDataAlertMessages()
                self.alert_messages.append(temp_model.from_map(k))
        return self


class ListAlertMessagesResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: ListAlertMessagesResponseData = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListAlertMessagesResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetBaselineConfigRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
    ):
        self.baseline_id = baseline_id

    def validate(self):
        self.validate_required(self.baseline_id, 'baseline_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetBaselineConfigResponseData(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        priority: int = None,
        baseline_name: str = None,
        owner: str = None,
        project_id: int = None,
        use_flag: bool = None,
        baseline_type: str = None,
        exp_hour: int = None,
        exp_minu: int = None,
        sla_hour: int = None,
        sla_minu: int = None,
        hour_exp_detail: str = None,
        hour_sla_detail: str = None,
        is_default: bool = None,
    ):
        self.baseline_id = baseline_id
        self.priority = priority
        self.baseline_name = baseline_name
        self.owner = owner
        self.project_id = project_id
        self.use_flag = use_flag
        self.baseline_type = baseline_type
        self.exp_hour = exp_hour
        self.exp_minu = exp_minu
        self.sla_hour = sla_hour
        self.sla_minu = sla_minu
        self.hour_exp_detail = hour_exp_detail
        self.hour_sla_detail = hour_sla_detail
        self.is_default = is_default

    def validate(self):
        self.validate_required(self.baseline_id, 'baseline_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.baseline_name, 'baseline_name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.use_flag, 'use_flag')
        self.validate_required(self.baseline_type, 'baseline_type')
        self.validate_required(self.exp_hour, 'exp_hour')
        self.validate_required(self.exp_minu, 'exp_minu')
        self.validate_required(self.sla_hour, 'sla_hour')
        self.validate_required(self.sla_minu, 'sla_minu')
        self.validate_required(self.hour_exp_detail, 'hour_exp_detail')
        self.validate_required(self.hour_sla_detail, 'hour_sla_detail')
        self.validate_required(self.is_default, 'is_default')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.use_flag is not None:
            result['UseFlag'] = self.use_flag
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.exp_hour is not None:
            result['ExpHour'] = self.exp_hour
        if self.exp_minu is not None:
            result['ExpMinu'] = self.exp_minu
        if self.sla_hour is not None:
            result['SlaHour'] = self.sla_hour
        if self.sla_minu is not None:
            result['SlaMinu'] = self.sla_minu
        if self.hour_exp_detail is not None:
            result['HourExpDetail'] = self.hour_exp_detail
        if self.hour_sla_detail is not None:
            result['HourSlaDetail'] = self.hour_sla_detail
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UseFlag') is not None:
            self.use_flag = m.get('UseFlag')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('ExpHour') is not None:
            self.exp_hour = m.get('ExpHour')
        if m.get('ExpMinu') is not None:
            self.exp_minu = m.get('ExpMinu')
        if m.get('SlaHour') is not None:
            self.sla_hour = m.get('SlaHour')
        if m.get('SlaMinu') is not None:
            self.sla_minu = m.get('SlaMinu')
        if m.get('HourExpDetail') is not None:
            self.hour_exp_detail = m.get('HourExpDetail')
        if m.get('HourSlaDetail') is not None:
            self.hour_sla_detail = m.get('HourSlaDetail')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        return self


class GetBaselineConfigResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: GetBaselineConfigResponseData = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetBaselineConfigResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class SearchMetaTablesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        app_guid: str = None,
        keyword: str = None,
        entity_type: int = None,
        cluster_id: str = None,
        data_source_type: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.app_guid = app_guid
        self.keyword = keyword
        self.entity_type = entity_type
        self.cluster_id = cluster_id
        self.data_source_type = data_source_type

    def validate(self):
        self.validate_required(self.keyword, 'keyword')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class SearchMetaTablesResponseDataDataEntityList(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        table_guid: str = None,
        owner_id: str = None,
        tenant_id: int = None,
        env_type: int = None,
        entity_type: int = None,
        project_id: int = None,
        project_name: str = None,
        cluster_id: str = None,
        database_name: str = None,
    ):
        self.table_name = table_name
        self.table_guid = table_guid
        self.owner_id = owner_id
        self.tenant_id = tenant_id
        self.env_type = env_type
        self.entity_type = entity_type
        self.project_id = project_id
        self.project_name = project_name
        self.cluster_id = cluster_id
        self.database_name = database_name

    def validate(self):
        self.validate_required(self.table_name, 'table_name')
        self.validate_required(self.table_guid, 'table_guid')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.env_type, 'env_type')
        self.validate_required(self.entity_type, 'entity_type')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.project_name, 'project_name')
        self.validate_required(self.cluster_id, 'cluster_id')
        self.validate_required(self.database_name, 'database_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        return self


class SearchMetaTablesResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[SearchMetaTablesResponseDataDataEntityList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data_entity_list, 'data_entity_list')
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = SearchMetaTablesResponseDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class SearchMetaTablesResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: SearchMetaTablesResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = SearchMetaTablesResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableListByCategoryRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        category_id: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.category_id = category_id

    def validate(self):
        self.validate_required(self.category_id, 'category_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class GetMetaTableListByCategoryResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        table_guid_list: List[str] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.table_guid_list = table_guid_list

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.table_guid_list, 'table_guid_list')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.table_guid_list is not None:
            result['TableGuidList'] = self.table_guid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TableGuidList') is not None:
            self.table_guid_list = m.get('TableGuidList')
        return self


class GetMetaTableListByCategoryResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: GetMetaTableListByCategoryResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetMetaTableListByCategoryResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
    ):
        self.category_id = category_id

    def validate(self):
        self.validate_required(self.category_id, 'category_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class DeleteMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class UpdateMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        comment: str = None,
        category_id: int = None,
    ):
        self.name = name
        self.comment = comment
        self.category_id = category_id

    def validate(self):
        self.validate_required(self.category_id, 'category_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class UpdateMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ListTopicsRequest(TeaModel):
    def __init__(
        self,
        begin_time: str = None,
        end_time: str = None,
        topic_types: str = None,
        topic_statuses: str = None,
        node_id: int = None,
        instance_id: int = None,
        owner: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.begin_time = begin_time
        self.end_time = end_time
        self.topic_types = topic_types
        self.topic_statuses = topic_statuses
        self.node_id = node_id
        self.instance_id = instance_id
        self.owner = owner
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.topic_types is not None:
            result['TopicTypes'] = self.topic_types
        if self.topic_statuses is not None:
            result['TopicStatuses'] = self.topic_statuses
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TopicTypes') is not None:
            self.topic_types = m.get('TopicTypes')
        if m.get('TopicStatuses') is not None:
            self.topic_statuses = m.get('TopicStatuses')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListTopicsResponseDataTopics(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
        topic_name: str = None,
        topic_status: str = None,
        topic_type: str = None,
        add_time: int = None,
        happen_time: int = None,
        fix_time: int = None,
        instance_id: int = None,
        node_id: int = None,
        node_name: str = None,
        node_owner: str = None,
        project_id: int = None,
    ):
        self.topic_id = topic_id
        self.topic_name = topic_name
        self.topic_status = topic_status
        self.topic_type = topic_type
        self.add_time = add_time
        self.happen_time = happen_time
        self.fix_time = fix_time
        self.instance_id = instance_id
        self.node_id = node_id
        self.node_name = node_name
        self.node_owner = node_owner
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.topic_id, 'topic_id')
        self.validate_required(self.topic_name, 'topic_name')
        self.validate_required(self.topic_status, 'topic_status')
        self.validate_required(self.topic_type, 'topic_type')
        self.validate_required(self.add_time, 'add_time')
        self.validate_required(self.happen_time, 'happen_time')
        self.validate_required(self.fix_time, 'fix_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.node_owner, 'node_owner')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.topic_status is not None:
            result['TopicStatus'] = self.topic_status
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.add_time is not None:
            result['AddTime'] = self.add_time
        if self.happen_time is not None:
            result['HappenTime'] = self.happen_time
        if self.fix_time is not None:
            result['FixTime'] = self.fix_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_owner is not None:
            result['NodeOwner'] = self.node_owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('TopicStatus') is not None:
            self.topic_status = m.get('TopicStatus')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('AddTime') is not None:
            self.add_time = m.get('AddTime')
        if m.get('HappenTime') is not None:
            self.happen_time = m.get('HappenTime')
        if m.get('FixTime') is not None:
            self.fix_time = m.get('FixTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeOwner') is not None:
            self.node_owner = m.get('NodeOwner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListTopicsResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        topics: List[ListTopicsResponseDataTopics] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.topics = topics

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.topics, 'topics')
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = ListTopicsResponseDataTopics()
                self.topics.append(temp_model.from_map(k))
        return self


class ListTopicsResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: ListTopicsResponseData = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListTopicsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListFileVersionsRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.file_id = file_id
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListFileVersionsResponseDataFileVersions(TeaModel):
    def __init__(
        self,
        file_version: int = None,
        file_content: str = None,
        commit_time: int = None,
        commit_user: str = None,
        file_name: str = None,
        status: str = None,
        change_type: str = None,
        is_current_prod: bool = None,
        node_id: int = None,
        comment: str = None,
        node_content: str = None,
        file_property_content: str = None,
        use_type: str = None,
    ):
        self.file_version = file_version
        self.file_content = file_content
        self.commit_time = commit_time
        self.commit_user = commit_user
        self.file_name = file_name
        self.status = status
        self.change_type = change_type
        self.is_current_prod = is_current_prod
        self.node_id = node_id
        self.comment = comment
        self.node_content = node_content
        self.file_property_content = file_property_content
        self.use_type = use_type

    def validate(self):
        self.validate_required(self.file_version, 'file_version')
        self.validate_required(self.file_content, 'file_content')
        self.validate_required(self.commit_time, 'commit_time')
        self.validate_required(self.commit_user, 'commit_user')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.status, 'status')
        self.validate_required(self.change_type, 'change_type')
        self.validate_required(self.is_current_prod, 'is_current_prod')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.node_content, 'node_content')
        self.validate_required(self.file_property_content, 'file_property_content')
        self.validate_required(self.use_type, 'use_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.file_content is not None:
            result['FileContent'] = self.file_content
        if self.commit_time is not None:
            result['CommitTime'] = self.commit_time
        if self.commit_user is not None:
            result['CommitUser'] = self.commit_user
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.status is not None:
            result['Status'] = self.status
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.is_current_prod is not None:
            result['IsCurrentProd'] = self.is_current_prod
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.node_content is not None:
            result['NodeContent'] = self.node_content
        if self.file_property_content is not None:
            result['FilePropertyContent'] = self.file_property_content
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('FileContent') is not None:
            self.file_content = m.get('FileContent')
        if m.get('CommitTime') is not None:
            self.commit_time = m.get('CommitTime')
        if m.get('CommitUser') is not None:
            self.commit_user = m.get('CommitUser')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('IsCurrentProd') is not None:
            self.is_current_prod = m.get('IsCurrentProd')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('NodeContent') is not None:
            self.node_content = m.get('NodeContent')
        if m.get('FilePropertyContent') is not None:
            self.file_property_content = m.get('FilePropertyContent')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class ListFileVersionsResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        file_versions: List[ListFileVersionsResponseDataFileVersions] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.file_versions = file_versions

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.file_versions, 'file_versions')
        if self.file_versions:
            for k in self.file_versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['FileVersions'] = []
        if self.file_versions is not None:
            for k in self.file_versions:
                result['FileVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.file_versions = []
        if m.get('FileVersions') is not None:
            for k in m.get('FileVersions'):
                temp_model = ListFileVersionsResponseDataFileVersions()
                self.file_versions.append(temp_model.from_map(k))
        return self


class ListFileVersionsResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        data: ListFileVersionsResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            temp_model = ListFileVersionsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        comment: str = None,
        parent_id: int = None,
    ):
        self.name = name
        self.comment = comment
        self.parent_id = parent_id

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateMetaCategoryResponseData(TeaModel):
    def __init__(
        self,
        category_id: int = None,
    ):
        self.category_id = category_id

    def validate(self):
        self.validate_required(self.category_id, 'category_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class CreateMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: CreateMetaCategoryResponseData = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateMetaCategoryResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListNodeIORequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
        io_type: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env
        self.io_type = io_type

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.project_env, 'project_env')
        self.validate_required(self.io_type, 'io_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.io_type is not None:
            result['IoType'] = self.io_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('IoType') is not None:
            self.io_type = m.get('IoType')
        return self


class ListNodeIOResponseData(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        data: str = None,
        node_id: int = None,
    ):
        self.table_name = table_name
        self.data = data
        self.node_id = node_id

    def validate(self):
        self.validate_required(self.table_name, 'table_name')
        self.validate_required(self.data, 'data')
        self.validate_required(self.node_id, 'node_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data is not None:
            result['Data'] = self.data
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class ListNodeIOResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: List[ListNodeIOResponseData] = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListNodeIOResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class GetTopicInfluenceRequest(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
    ):
        self.topic_id = topic_id

    def validate(self):
        self.validate_required(self.topic_id, 'topic_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class GetTopicInfluenceResponseDataInfluences(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        bizdate: int = None,
        in_group_id: int = None,
        baseline_name: str = None,
        owner: str = None,
        status: str = None,
        project_id: int = None,
        priority: int = None,
        buffer: int = None,
    ):
        self.baseline_id = baseline_id
        self.bizdate = bizdate
        self.in_group_id = in_group_id
        self.baseline_name = baseline_name
        self.owner = owner
        self.status = status
        self.project_id = project_id
        self.priority = priority
        self.buffer = buffer

    def validate(self):
        self.validate_required(self.baseline_id, 'baseline_id')
        self.validate_required(self.bizdate, 'bizdate')
        self.validate_required(self.in_group_id, 'in_group_id')
        self.validate_required(self.baseline_name, 'baseline_name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.status, 'status')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.buffer, 'buffer')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.status is not None:
            result['Status'] = self.status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        return self


class GetTopicInfluenceResponseData(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
        influences: List[GetTopicInfluenceResponseDataInfluences] = None,
    ):
        self.topic_id = topic_id
        self.influences = influences

    def validate(self):
        self.validate_required(self.topic_id, 'topic_id')
        self.validate_required(self.influences, 'influences')
        if self.influences:
            for k in self.influences:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        result['Influences'] = []
        if self.influences is not None:
            for k in self.influences:
                result['Influences'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        self.influences = []
        if m.get('Influences') is not None:
            for k in m.get('Influences'):
                temp_model = GetTopicInfluenceResponseDataInfluences()
                self.influences.append(temp_model.from_map(k))
        return self


class GetTopicInfluenceResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: GetTopicInfluenceResponseData = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetTopicInfluenceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetTopicRequest(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
    ):
        self.topic_id = topic_id

    def validate(self):
        self.validate_required(self.topic_id, 'topic_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class GetTopicResponseData(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
        topic_name: str = None,
        topic_status: str = None,
        topic_type: str = None,
        add_time: int = None,
        alert_time: int = None,
        assigner: str = None,
        baseline_id: int = None,
        baseline_name: str = None,
        baseline_in_group_id: int = None,
        baseline_status: str = None,
        baseline_buffer: int = None,
        buffer: int = None,
        deal_time: int = None,
        deal_user: str = None,
        fix_time: int = None,
        happen_time: int = None,
        instance_id: int = None,
        next_alert_time: int = None,
        node_id: int = None,
        node_name: str = None,
        owner: str = None,
        project_id: int = None,
    ):
        self.topic_id = topic_id
        self.topic_name = topic_name
        self.topic_status = topic_status
        self.topic_type = topic_type
        self.add_time = add_time
        self.alert_time = alert_time
        self.assigner = assigner
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.baseline_in_group_id = baseline_in_group_id
        self.baseline_status = baseline_status
        self.baseline_buffer = baseline_buffer
        self.buffer = buffer
        self.deal_time = deal_time
        self.deal_user = deal_user
        self.fix_time = fix_time
        self.happen_time = happen_time
        self.instance_id = instance_id
        self.next_alert_time = next_alert_time
        self.node_id = node_id
        self.node_name = node_name
        self.owner = owner
        self.project_id = project_id

    def validate(self):
        self.validate_required(self.topic_id, 'topic_id')
        self.validate_required(self.topic_name, 'topic_name')
        self.validate_required(self.topic_status, 'topic_status')
        self.validate_required(self.topic_type, 'topic_type')
        self.validate_required(self.add_time, 'add_time')
        self.validate_required(self.alert_time, 'alert_time')
        self.validate_required(self.assigner, 'assigner')
        self.validate_required(self.baseline_id, 'baseline_id')
        self.validate_required(self.baseline_name, 'baseline_name')
        self.validate_required(self.baseline_in_group_id, 'baseline_in_group_id')
        self.validate_required(self.baseline_status, 'baseline_status')
        self.validate_required(self.baseline_buffer, 'baseline_buffer')
        self.validate_required(self.buffer, 'buffer')
        self.validate_required(self.deal_time, 'deal_time')
        self.validate_required(self.deal_user, 'deal_user')
        self.validate_required(self.fix_time, 'fix_time')
        self.validate_required(self.happen_time, 'happen_time')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.next_alert_time, 'next_alert_time')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.topic_status is not None:
            result['TopicStatus'] = self.topic_status
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.add_time is not None:
            result['AddTime'] = self.add_time
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.assigner is not None:
            result['Assigner'] = self.assigner
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_in_group_id is not None:
            result['BaselineInGroupId'] = self.baseline_in_group_id
        if self.baseline_status is not None:
            result['BaselineStatus'] = self.baseline_status
        if self.baseline_buffer is not None:
            result['BaselineBuffer'] = self.baseline_buffer
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_user is not None:
            result['DealUser'] = self.deal_user
        if self.fix_time is not None:
            result['FixTime'] = self.fix_time
        if self.happen_time is not None:
            result['HappenTime'] = self.happen_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.next_alert_time is not None:
            result['NextAlertTime'] = self.next_alert_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('TopicStatus') is not None:
            self.topic_status = m.get('TopicStatus')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('AddTime') is not None:
            self.add_time = m.get('AddTime')
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('Assigner') is not None:
            self.assigner = m.get('Assigner')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineInGroupId') is not None:
            self.baseline_in_group_id = m.get('BaselineInGroupId')
        if m.get('BaselineStatus') is not None:
            self.baseline_status = m.get('BaselineStatus')
        if m.get('BaselineBuffer') is not None:
            self.baseline_buffer = m.get('BaselineBuffer')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealUser') is not None:
            self.deal_user = m.get('DealUser')
        if m.get('FixTime') is not None:
            self.fix_time = m.get('FixTime')
        if m.get('HappenTime') is not None:
            self.happen_time = m.get('HappenTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NextAlertTime') is not None:
            self.next_alert_time = m.get('NextAlertTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetTopicResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: GetTopicResponseData = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetTopicResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteFromMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        table_guid: str = None,
    ):
        self.category_id = category_id
        self.table_guid = table_guid

    def validate(self):
        self.validate_required(self.category_id, 'category_id')
        self.validate_required(self.table_guid, 'table_guid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class DeleteFromMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class GetNodeRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.project_env, 'project_env')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeResponseData(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        owner_id: str = None,
        description: str = None,
        res_group_name: str = None,
        node_name: str = None,
        cron_express: str = None,
        repeatability: str = None,
        program_type: str = None,
        project_id: int = None,
        scheduler_type: str = None,
        param_values: str = None,
        priority: int = None,
        baseline_id: int = None,
        repeat_interval: int = None,
        connection: str = None,
        dqc_type: int = None,
        dqc_description: str = None,
        related_flow_id: int = None,
        business_id: int = None,
    ):
        self.node_id = node_id
        self.owner_id = owner_id
        self.description = description
        self.res_group_name = res_group_name
        self.node_name = node_name
        self.cron_express = cron_express
        self.repeatability = repeatability
        self.program_type = program_type
        self.project_id = project_id
        self.scheduler_type = scheduler_type
        self.param_values = param_values
        self.priority = priority
        self.baseline_id = baseline_id
        self.repeat_interval = repeat_interval
        self.connection = connection
        self.dqc_type = dqc_type
        self.dqc_description = dqc_description
        self.related_flow_id = related_flow_id
        self.business_id = business_id

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.res_group_name, 'res_group_name')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.cron_express, 'cron_express')
        self.validate_required(self.repeatability, 'repeatability')
        self.validate_required(self.program_type, 'program_type')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.scheduler_type, 'scheduler_type')
        self.validate_required(self.param_values, 'param_values')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.baseline_id, 'baseline_id')
        self.validate_required(self.repeat_interval, 'repeat_interval')
        self.validate_required(self.connection, 'connection')
        self.validate_required(self.dqc_type, 'dqc_type')
        self.validate_required(self.dqc_description, 'dqc_description')
        self.validate_required(self.related_flow_id, 'related_flow_id')
        self.validate_required(self.business_id, 'business_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.description is not None:
            result['Description'] = self.description
        if self.res_group_name is not None:
            result['ResGroupName'] = self.res_group_name
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResGroupName') is not None:
            self.res_group_name = m.get('ResGroupName')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        return self


class GetNodeResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: GetNodeResponseData = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetNodeResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListNodesRequest(TeaModel):
    def __init__(
        self,
        owner: str = None,
        biz_name: str = None,
        program_type: str = None,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        project_env: str = None,
        node_name: str = None,
    ):
        self.owner = owner
        self.biz_name = biz_name
        self.program_type = program_type
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.project_env = project_env
        self.node_name = node_name

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.project_env, 'project_env')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.biz_name is not None:
            result['BizName'] = self.biz_name
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('BizName') is not None:
            self.biz_name = m.get('BizName')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        return self


class ListNodesResponseDataNodes(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        node_name: str = None,
        cron_express: str = None,
        scheduler_type: str = None,
        program_type: str = None,
        owner_id: str = None,
        project_id: int = None,
        repeatability: bool = None,
        param_values: str = None,
        description: str = None,
        res_group_name: str = None,
        priority: int = None,
        baseline_id: int = None,
        repeat_interval: int = None,
        connection: str = None,
        dqc_type: int = None,
        dqc_description: str = None,
        related_flow_id: int = None,
        business_id: int = None,
    ):
        self.node_id = node_id
        self.node_name = node_name
        self.cron_express = cron_express
        self.scheduler_type = scheduler_type
        self.program_type = program_type
        self.owner_id = owner_id
        self.project_id = project_id
        self.repeatability = repeatability
        self.param_values = param_values
        self.description = description
        self.res_group_name = res_group_name
        self.priority = priority
        self.baseline_id = baseline_id
        self.repeat_interval = repeat_interval
        self.connection = connection
        self.dqc_type = dqc_type
        self.dqc_description = dqc_description
        self.related_flow_id = related_flow_id
        self.business_id = business_id

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.node_name, 'node_name')
        self.validate_required(self.cron_express, 'cron_express')
        self.validate_required(self.scheduler_type, 'scheduler_type')
        self.validate_required(self.program_type, 'program_type')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.repeatability, 'repeatability')
        self.validate_required(self.param_values, 'param_values')
        self.validate_required(self.description, 'description')
        self.validate_required(self.res_group_name, 'res_group_name')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.baseline_id, 'baseline_id')
        self.validate_required(self.repeat_interval, 'repeat_interval')
        self.validate_required(self.connection, 'connection')
        self.validate_required(self.dqc_type, 'dqc_type')
        self.validate_required(self.dqc_description, 'dqc_description')
        self.validate_required(self.related_flow_id, 'related_flow_id')
        self.validate_required(self.business_id, 'business_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.description is not None:
            result['Description'] = self.description
        if self.res_group_name is not None:
            result['ResGroupName'] = self.res_group_name
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResGroupName') is not None:
            self.res_group_name = m.get('ResGroupName')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        return self


class ListNodesResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        nodes: List[ListNodesResponseDataNodes] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.nodes = nodes

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.nodes, 'nodes')
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = ListNodesResponseDataNodes()
                self.nodes.append(temp_model.from_map(k))
        return self


class ListNodesResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        http_status_code: int = None,
        error_code: str = None,
        error_message: str = None,
        request_id: str = None,
        data: ListNodesResponseData = None,
    ):
        self.success = success
        self.http_status_code = http_status_code
        self.error_code = error_code
        self.error_message = error_message
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ListNodesResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeCodeRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env

    def validate(self):
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.project_env, 'project_env')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeCodeResponse(TeaModel):
    def __init__(
        self,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        data: str = None,
    ):
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.data = data

    def validate(self):
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class EstablishRelationTableToBusinessRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        business_id: str = None,
        table_guid: str = None,
        folder_id: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.business_id = business_id
        self.table_guid = table_guid
        self.folder_id = folder_id

    def validate(self):
        self.validate_required(self.business_id, 'business_id')
        self.validate_required(self.table_guid, 'table_guid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class EstablishRelationTableToBusinessResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        return self


class UpdateDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_id: int = None,
        request_method: int = None,
        response_content_type: int = None,
        timeout: int = None,
        visible_range: int = None,
        protocols: str = None,
        wizard_details: str = None,
        script_details: str = None,
        registration_details: str = None,
        api_path: str = None,
        api_description: str = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_id = api_id
        self.request_method = request_method
        self.response_content_type = response_content_type
        self.timeout = timeout
        self.visible_range = visible_range
        self.protocols = protocols
        self.wizard_details = wizard_details
        self.script_details = script_details
        self.registration_details = registration_details
        self.api_path = api_path
        self.api_description = api_description

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.request_method, 'request_method')
        self.validate_required(self.response_content_type, 'response_content_type')
        self.validate_required(self.timeout, 'timeout')
        self.validate_required(self.visible_range, 'visible_range')
        self.validate_required(self.protocols, 'protocols')
        self.validate_required(self.api_path, 'api_path')
        self.validate_required(self.api_description, 'api_description')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.api_description is not None:
            result['ApiDescription'] = self.api_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('WizardDetails') is not None:
            self.wizard_details = m.get('WizardDetails')
        if m.get('ScriptDetails') is not None:
            self.script_details = m.get('ScriptDetails')
        if m.get('RegistrationDetails') is not None:
            self.registration_details = m.get('RegistrationDetails')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('ApiDescription') is not None:
            self.api_description = m.get('ApiDescription')
        return self


class UpdateDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        success: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.success = success
        self.request_id = request_id

    def validate(self):
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateUdfFileRequest(TeaModel):
    def __init__(
        self,
        file_folder_path: str = None,
        project_id: int = None,
        function_type: str = None,
        class_name: str = None,
        resources: str = None,
        udf_description: str = None,
        cmd_description: str = None,
        parameter_description: str = None,
        return_value: str = None,
        example: str = None,
        project_identifier: str = None,
        file_id: str = None,
    ):
        self.file_folder_path = file_folder_path
        self.project_id = project_id
        self.function_type = function_type
        self.class_name = class_name
        self.resources = resources
        self.udf_description = udf_description
        self.cmd_description = cmd_description
        self.parameter_description = parameter_description
        self.return_value = return_value
        self.example = example
        self.project_identifier = project_identifier
        self.file_id = file_id

    def validate(self):
        self.validate_required(self.function_type, 'function_type')
        self.validate_required(self.class_name, 'class_name')
        self.validate_required(self.resources, 'resources')
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.function_type is not None:
            result['FunctionType'] = self.function_type
        if self.class_name is not None:
            result['ClassName'] = self.class_name
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.udf_description is not None:
            result['UdfDescription'] = self.udf_description
        if self.cmd_description is not None:
            result['CmdDescription'] = self.cmd_description
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.return_value is not None:
            result['ReturnValue'] = self.return_value
        if self.example is not None:
            result['Example'] = self.example
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FunctionType') is not None:
            self.function_type = m.get('FunctionType')
        if m.get('ClassName') is not None:
            self.class_name = m.get('ClassName')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('UdfDescription') is not None:
            self.udf_description = m.get('UdfDescription')
        if m.get('CmdDescription') is not None:
            self.cmd_description = m.get('CmdDescription')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ReturnValue') is not None:
            self.return_value = m.get('ReturnValue')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class UpdateUdfFileResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        return self


class CreateUdfFileRequest(TeaModel):
    def __init__(
        self,
        file_folder_path: str = None,
        project_id: int = None,
        file_name: str = None,
        function_type: str = None,
        class_name: str = None,
        resources: str = None,
        udf_description: str = None,
        cmd_description: str = None,
        parameter_description: str = None,
        return_value: str = None,
        example: str = None,
        project_identifier: str = None,
    ):
        self.file_folder_path = file_folder_path
        self.project_id = project_id
        self.file_name = file_name
        self.function_type = function_type
        self.class_name = class_name
        self.resources = resources
        self.udf_description = udf_description
        self.cmd_description = cmd_description
        self.parameter_description = parameter_description
        self.return_value = return_value
        self.example = example
        self.project_identifier = project_identifier

    def validate(self):
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.function_type, 'function_type')
        self.validate_required(self.class_name, 'class_name')
        self.validate_required(self.resources, 'resources')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.function_type is not None:
            result['FunctionType'] = self.function_type
        if self.class_name is not None:
            result['ClassName'] = self.class_name
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.udf_description is not None:
            result['UdfDescription'] = self.udf_description
        if self.cmd_description is not None:
            result['CmdDescription'] = self.cmd_description
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.return_value is not None:
            result['ReturnValue'] = self.return_value
        if self.example is not None:
            result['Example'] = self.example
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FunctionType') is not None:
            self.function_type = m.get('FunctionType')
        if m.get('ClassName') is not None:
            self.class_name = m.get('ClassName')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('UdfDescription') is not None:
            self.udf_description = m.get('UdfDescription')
        if m.get('CmdDescription') is not None:
            self.cmd_description = m.get('CmdDescription')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ReturnValue') is not None:
            self.return_value = m.get('ReturnValue')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class CreateUdfFileResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        data: int = None,
        http_status_code: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.data = data
        self.http_status_code = http_status_code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        self.validate_required(self.http_status_code, 'http_status_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        return self


class ListFilesRequest(TeaModel):
    def __init__(
        self,
        file_folder_path: str = None,
        project_id: int = None,
        keyword: str = None,
        project_identifier: str = None,
        page_number: int = None,
        page_size: int = None,
        use_type: str = None,
        file_types: str = None,
        owner: str = None,
        node_id: int = None,
    ):
        self.file_folder_path = file_folder_path
        self.project_id = project_id
        self.keyword = keyword
        self.project_identifier = project_identifier
        self.page_number = page_number
        self.page_size = page_size
        self.use_type = use_type
        self.file_types = file_types
        self.owner = owner
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.use_type is not None:
            result['UseType'] = self.use_type
        if self.file_types is not None:
            result['FileTypes'] = self.file_types
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        if m.get('FileTypes') is not None:
            self.file_types = m.get('FileTypes')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class ListFilesResponseDataFiles(TeaModel):
    def __init__(
        self,
        connection_name: str = None,
        parent_id: int = None,
        is_max_compute: bool = None,
        create_time: int = None,
        create_user: str = None,
        biz_id: int = None,
        file_folder_id: str = None,
        file_name: str = None,
        file_type: int = None,
        use_type: str = None,
        file_description: str = None,
        content: str = None,
        node_id: int = None,
        current_version: int = None,
        owner: str = None,
        last_edit_user: str = None,
        last_edit_time: int = None,
        commit_status: int = None,
        file_id: int = None,
        business_id: int = None,
        auto_parsing: bool = None,
    ):
        self.connection_name = connection_name
        self.parent_id = parent_id
        self.is_max_compute = is_max_compute
        self.create_time = create_time
        self.create_user = create_user
        self.biz_id = biz_id
        self.file_folder_id = file_folder_id
        self.file_name = file_name
        self.file_type = file_type
        self.use_type = use_type
        self.file_description = file_description
        self.content = content
        self.node_id = node_id
        self.current_version = current_version
        self.owner = owner
        self.last_edit_user = last_edit_user
        self.last_edit_time = last_edit_time
        self.commit_status = commit_status
        self.file_id = file_id
        self.business_id = business_id
        self.auto_parsing = auto_parsing

    def validate(self):
        self.validate_required(self.connection_name, 'connection_name')
        self.validate_required(self.parent_id, 'parent_id')
        self.validate_required(self.is_max_compute, 'is_max_compute')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.create_user, 'create_user')
        self.validate_required(self.biz_id, 'biz_id')
        self.validate_required(self.file_folder_id, 'file_folder_id')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.file_type, 'file_type')
        self.validate_required(self.use_type, 'use_type')
        self.validate_required(self.file_description, 'file_description')
        self.validate_required(self.content, 'content')
        self.validate_required(self.node_id, 'node_id')
        self.validate_required(self.current_version, 'current_version')
        self.validate_required(self.owner, 'owner')
        self.validate_required(self.last_edit_user, 'last_edit_user')
        self.validate_required(self.last_edit_time, 'last_edit_time')
        self.validate_required(self.commit_status, 'commit_status')
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.business_id, 'business_id')
        self.validate_required(self.auto_parsing, 'auto_parsing')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.is_max_compute is not None:
            result['IsMaxCompute'] = self.is_max_compute
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.file_folder_id is not None:
            result['FileFolderId'] = self.file_folder_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.use_type is not None:
            result['UseType'] = self.use_type
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.content is not None:
            result['Content'] = self.content
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.last_edit_user is not None:
            result['LastEditUser'] = self.last_edit_user
        if self.last_edit_time is not None:
            result['LastEditTime'] = self.last_edit_time
        if self.commit_status is not None:
            result['CommitStatus'] = self.commit_status
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('IsMaxCompute') is not None:
            self.is_max_compute = m.get('IsMaxCompute')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('FileFolderId') is not None:
            self.file_folder_id = m.get('FileFolderId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('LastEditUser') is not None:
            self.last_edit_user = m.get('LastEditUser')
        if m.get('LastEditTime') is not None:
            self.last_edit_time = m.get('LastEditTime')
        if m.get('CommitStatus') is not None:
            self.commit_status = m.get('CommitStatus')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        return self


class ListFilesResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        files: List[ListFilesResponseDataFiles] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.files = files

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.files, 'files')
        if self.files:
            for k in self.files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Files'] = []
        if self.files is not None:
            for k in self.files:
                result['Files'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.files = []
        if m.get('Files') is not None:
            for k in m.get('Files'):
                temp_model = ListFilesResponseDataFiles()
                self.files.append(temp_model.from_map(k))
        return self


class ListFilesResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        data: ListFilesResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            temp_model = ListFilesResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDataServiceAuthorizedApisRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        page_number: int = None,
        page_size: int = None,
        tenant_id: int = None,
        api_name_keyword: str = None,
    ):
        self.project_id = project_id
        self.page_number = page_number
        self.page_size = page_size
        self.tenant_id = tenant_id
        self.api_name_keyword = api_name_keyword

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.tenant_id, 'tenant_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_name_keyword is not None:
            result['ApiNameKeyword'] = self.api_name_keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiNameKeyword') is not None:
            self.api_name_keyword = m.get('ApiNameKeyword')
        return self


class ListDataServiceAuthorizedApisResponseDataApiAuthorizedList(TeaModel):
    def __init__(
        self,
        api_id: int = None,
        api_name: str = None,
        api_path: str = None,
        api_status: int = None,
        created_time: str = None,
        creator_id: str = None,
        grant_created_time: str = None,
        grant_end_time: str = None,
        grant_operator_id: str = None,
        group_id: str = None,
        modified_time: str = None,
        project_id: int = None,
        tenant_id: int = None,
    ):
        self.api_id = api_id
        self.api_name = api_name
        self.api_path = api_path
        self.api_status = api_status
        self.created_time = created_time
        self.creator_id = creator_id
        self.grant_created_time = grant_created_time
        self.grant_end_time = grant_end_time
        self.grant_operator_id = grant_operator_id
        self.group_id = group_id
        self.modified_time = modified_time
        self.project_id = project_id
        self.tenant_id = tenant_id

    def validate(self):
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.api_name, 'api_name')
        self.validate_required(self.api_path, 'api_path')
        self.validate_required(self.api_status, 'api_status')
        self.validate_required(self.created_time, 'created_time')
        self.validate_required(self.creator_id, 'creator_id')
        self.validate_required(self.grant_created_time, 'grant_created_time')
        self.validate_required(self.grant_end_time, 'grant_end_time')
        self.validate_required(self.grant_operator_id, 'grant_operator_id')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.tenant_id, 'tenant_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.api_status is not None:
            result['ApiStatus'] = self.api_status
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.grant_created_time is not None:
            result['GrantCreatedTime'] = self.grant_created_time
        if self.grant_end_time is not None:
            result['GrantEndTime'] = self.grant_end_time
        if self.grant_operator_id is not None:
            result['GrantOperatorId'] = self.grant_operator_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('ApiStatus') is not None:
            self.api_status = m.get('ApiStatus')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('GrantCreatedTime') is not None:
            self.grant_created_time = m.get('GrantCreatedTime')
        if m.get('GrantEndTime') is not None:
            self.grant_end_time = m.get('GrantEndTime')
        if m.get('GrantOperatorId') is not None:
            self.grant_operator_id = m.get('GrantOperatorId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListDataServiceAuthorizedApisResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        api_authorized_list: List[ListDataServiceAuthorizedApisResponseDataApiAuthorizedList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.api_authorized_list = api_authorized_list

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.api_authorized_list, 'api_authorized_list')
        if self.api_authorized_list:
            for k in self.api_authorized_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ApiAuthorizedList'] = []
        if self.api_authorized_list is not None:
            for k in self.api_authorized_list:
                result['ApiAuthorizedList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.api_authorized_list = []
        if m.get('ApiAuthorizedList') is not None:
            for k in m.get('ApiAuthorizedList'):
                temp_model = ListDataServiceAuthorizedApisResponseDataApiAuthorizedList()
                self.api_authorized_list.append(temp_model.from_map(k))
        return self


class ListDataServiceAuthorizedApisResponse(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: ListDataServiceAuthorizedApisResponseData = None,
    ):
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListDataServiceAuthorizedApisResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateFileRequest(TeaModel):
    def __init__(
        self,
        file_folder_path: str = None,
        project_id: int = None,
        file_name: str = None,
        file_description: str = None,
        content: str = None,
        auto_rerun_times: int = None,
        auto_rerun_interval_millis: int = None,
        rerun_mode: str = None,
        stop: bool = None,
        para_value: str = None,
        start_effect_date: int = None,
        end_effect_date: int = None,
        cron_express: str = None,
        cycle_type: str = None,
        dependent_type: str = None,
        dependent_node_id_list: str = None,
        input_list: str = None,
        project_identifier: str = None,
        file_id: int = None,
        output_list: str = None,
        resource_group_identifier: str = None,
        connection_name: str = None,
        owner: str = None,
        auto_parsing: bool = None,
        scheduler_type: str = None,
    ):
        self.file_folder_path = file_folder_path
        self.project_id = project_id
        self.file_name = file_name
        self.file_description = file_description
        self.content = content
        self.auto_rerun_times = auto_rerun_times
        self.auto_rerun_interval_millis = auto_rerun_interval_millis
        self.rerun_mode = rerun_mode
        self.stop = stop
        self.para_value = para_value
        self.start_effect_date = start_effect_date
        self.end_effect_date = end_effect_date
        self.cron_express = cron_express
        self.cycle_type = cycle_type
        self.dependent_type = dependent_type
        self.dependent_node_id_list = dependent_node_id_list
        self.input_list = input_list
        self.project_identifier = project_identifier
        self.file_id = file_id
        self.output_list = output_list
        self.resource_group_identifier = resource_group_identifier
        self.connection_name = connection_name
        self.owner = owner
        self.auto_parsing = auto_parsing
        self.scheduler_type = scheduler_type

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.content is not None:
            result['Content'] = self.content
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.stop is not None:
            result['Stop'] = self.stop
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.start_effect_date is not None:
            result['StartEffectDate'] = self.start_effect_date
        if self.end_effect_date is not None:
            result['EndEffectDate'] = self.end_effect_date
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.input_list is not None:
            result['InputList'] = self.input_list
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.output_list is not None:
            result['OutputList'] = self.output_list
        if self.resource_group_identifier is not None:
            result['ResourceGroupIdentifier'] = self.resource_group_identifier
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('Stop') is not None:
            self.stop = m.get('Stop')
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('StartEffectDate') is not None:
            self.start_effect_date = m.get('StartEffectDate')
        if m.get('EndEffectDate') is not None:
            self.end_effect_date = m.get('EndEffectDate')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('InputList') is not None:
            self.input_list = m.get('InputList')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('OutputList') is not None:
            self.output_list = m.get('OutputList')
        if m.get('ResourceGroupIdentifier') is not None:
            self.resource_group_identifier = m.get('ResourceGroupIdentifier')
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class UpdateFileResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        return self


class DeleteFolderRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        folder_id: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.folder_id = folder_id

    def validate(self):
        self.validate_required(self.folder_id, 'folder_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class DeleteFolderResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        return self


class ListFoldersRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        parent_folder_path: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.parent_folder_path = parent_folder_path
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.parent_folder_path, 'parent_folder_path')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.parent_folder_path is not None:
            result['ParentFolderPath'] = self.parent_folder_path
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ParentFolderPath') is not None:
            self.parent_folder_path = m.get('ParentFolderPath')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListFoldersResponseDataFolders(TeaModel):
    def __init__(
        self,
        folder_id: str = None,
        folder_path: str = None,
    ):
        self.folder_id = folder_id
        self.folder_path = folder_path

    def validate(self):
        self.validate_required(self.folder_id, 'folder_id')
        self.validate_required(self.folder_path, 'folder_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        return self


class ListFoldersResponseData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        folders: List[ListFoldersResponseDataFolders] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.folders = folders

    def validate(self):
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.folders, 'folders')
        if self.folders:
            for k in self.folders:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Folders'] = []
        if self.folders is not None:
            for k in self.folders:
                result['Folders'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.folders = []
        if m.get('Folders') is not None:
            for k in m.get('Folders'):
                temp_model = ListFoldersResponseDataFolders()
                self.folders.append(temp_model.from_map(k))
        return self


class ListFoldersResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        error_message: str = None,
        http_status_code: int = None,
        data: ListFoldersResponseData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.error_message = error_message
        self.http_status_code = http_status_code
        self.data = data

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            temp_model = ListFoldersResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CheckMetaPartitionRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        partition: str = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.partition = partition
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        se