# mypy-boto3-elastictranscoder

[![PyPI - mypy-boto3-elastictranscoder](https://img.shields.io/pypi/v/mypy-boto3-elastictranscoder.svg?color=blue)](https://pypi.org/project/mypy-boto3-elastictranscoder)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elastictranscoder.svg?color=blue)](https://pypi.org/project/mypy-boto3-elastictranscoder)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ElasticTranscoder 1.14.60](https://boto3.amazonaws.com/v1/documentation/api/1.14.60/reference/services/elastictranscoder.html#ElasticTranscoder) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-elastictranscoder](#mypy-boto3-elastictranscoder)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `ElasticTranscoder` service.

```bash
python -m pip install boto3-stubs[elastictranscoder]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[elastictranscoder]` in your environment: `python -m pip install 'boto3-stubs[elastictranscoder]'`

Both type checking and auto-complete should work for `ElasticTranscoder` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[elastictranscoder]` in your environment: `python -m pip install 'boto3-stubs[elastictranscoder]'`

Both type checking and auto-complete should work for `ElasticTranscoder` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[elastictranscoder]` in your environment: `python -m pip install 'boto3-stubs[elastictranscoder]'`
- Run `mypy` as usual

Type checking should work for `ElasticTranscoder` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[elastictranscoder]` in your environment: `python -m pip install 'boto3-stubs[elastictranscoder]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElasticTranscoder` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ElasticTranscoderClient` provides annotations for `boto3.client("elastictranscoder")`.

```python
import boto3

from mypy_boto3_elastictranscoder import ElasticTranscoderClient

client: ElasticTranscoderClient = boto3.client("elastictranscoder")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticTranscoderClient = session.client("elastictranscoder")
```

### Paginators annotations

`mypy_boto3_elastictranscoder.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_elastictranscoder import ElasticTranscoderClient
from mypy_boto3_elastictranscoder.paginator import (
    ListJobsByPipelinePaginator,
    ListJobsByStatusPaginator,
    ListPipelinesPaginator,
    ListPresetsPaginator,
)

client: ElasticTranscoderClient = boto3.client("elastictranscoder")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_jobs_by_pipeline_paginator: ListJobsByPipelinePaginator = client.get_paginator("list_jobs_by_pipeline")
list_jobs_by_status_paginator: ListJobsByStatusPaginator = client.get_paginator("list_jobs_by_status")
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
list_presets_paginator: ListPresetsPaginator = client.get_paginator("list_presets")
```


### Waiters annotations

`mypy_boto3_elastictranscoder.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_elastictranscoder import ElasticTranscoderClient
from mypy_boto3_elastictranscoder.waiter import JobCompleteWaiter

client: ElasticTranscoderClient = boto3.client("elastictranscoder")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
job_complete_waiter: JobCompleteWaiter = client.get_waiter("job_complete")
```





### Typed dictionations

`mypy_boto3_elastictranscoder.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_elastictranscoder.type_defs import (
    ArtworkTypeDef,
    AudioCodecOptionsTypeDef,
    AudioParametersTypeDef,
    CaptionFormatTypeDef,
    CaptionSourceTypeDef,
    CaptionsTypeDef,
    ClipTypeDef,
    CreateJobOutputTypeDef,
    CreateJobPlaylistTypeDef,
    CreateJobResponseTypeDef,
    CreatePipelineResponseTypeDef,
    CreatePresetResponseTypeDef,
    DetectedPropertiesTypeDef,
    EncryptionTypeDef,
    HlsContentProtectionTypeDef,
    InputCaptionsTypeDef,
    JobAlbumArtTypeDef,
    JobInputTypeDef,
    JobOutputTypeDef,
    JobTypeDef,
    JobWatermarkTypeDef,
    ListJobsByPipelineResponseTypeDef,
    ListJobsByStatusResponseTypeDef,
    ListPipelinesResponseTypeDef,
    ListPresetsResponseTypeDef,
    NotificationsTypeDef,
    PaginatorConfigTypeDef,
    PermissionTypeDef,
    PipelineOutputConfigTypeDef,
    PipelineTypeDef,
    PlaylistTypeDef,
    PlayReadyDrmTypeDef,
    PresetTypeDef,
    PresetWatermarkTypeDef,
    ReadJobResponseTypeDef,
    ReadPipelineResponseTypeDef,
    ReadPresetResponseTypeDef,
    TestRoleResponseTypeDef,
    ThumbnailsTypeDef,
    TimeSpanTypeDef,
    TimingTypeDef,
    UpdatePipelineNotificationsResponseTypeDef,
    UpdatePipelineResponseTypeDef,
    UpdatePipelineStatusResponseTypeDef,
    VideoParametersTypeDef,
    WaiterConfigTypeDef,
    WarningTypeDef,
)

def get_structure() -> ArtworkTypeDef:
    return {
      ...
    }
```
