/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.result.Result;

public class LdbSqlException
extends RuntimeException {
    public static final LdbSqlException[] emptyArray = new LdbSqlException[0];
    public static final LdbSqlException noDataCondition = Error.error(3494);
    public Object info;
    private String message;
    private String state;
    private int code;
    private int level;
    private int statementGroup;
    private int statementCode;
    private LdbSqlNameManager.SimpleName conditionName;
    private boolean isPrintStack = true;

    public LdbSqlException(Throwable t, String message, String state, int code) {
        this(t, message, state, code, true);
    }

    public LdbSqlException(Throwable t, String message, String state, int code, boolean isPrintStack) {
        super(t);
        this.message = t != null ? message + ", " + LdbSqlException.collectErrorCausedBy(t, new StringBuilder()) : message;
        this.state = state;
        this.code = code;
        this.isPrintStack = isPrintStack;
    }

    public LdbSqlException(LdbSqlNameManager.SimpleName conditionName) {
        super((Throwable)null);
        this.conditionName = conditionName;
    }

    public LdbSqlException(Result r) {
        this.message = r.getMainString();
        this.state = r.getSubString();
        this.code = r.getErrorCode();
    }

    public LdbSqlException(Throwable t, String errorState, int errorCode) {
        super(t);
        this.message = LdbSqlException.collectErrorCausedBy(t, new StringBuilder()).toString();
        this.state = errorState;
        this.code = errorCode;
    }

    private static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static StringBuilder collectErrorCausedBy(Throwable t, StringBuilder sb) {
        if (t == null) {
            return sb;
        }
        if (t.getMessage() == null) {
            sb.append("S1000 General error");
        } else {
            sb.append(t.getMessage());
        }
        if (t.getCause() != null) {
            sb.append(" Caused by [");
            LdbSqlException.collectErrorCausedBy(t.getCause(), sb);
            sb.append("]");
        }
        return sb;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getSQLState() {
        return this.state;
    }

    public int getErrorCode() {
        return this.code;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getStatementCode() {
        return this.statementCode;
    }

    public void setStatementType(int group, int code) {
        this.statementGroup = group;
        this.statementCode = code;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object other) {
        if (other instanceof LdbSqlException) {
            LdbSqlException o = (LdbSqlException)other;
            return this.code == o.code && LdbSqlException.equals(this.state, o.state) && LdbSqlException.equals(this.message, o.message);
        }
        return false;
    }

    public LdbSqlNameManager.SimpleName getConditionName() {
        return this.conditionName;
    }

    public boolean isPrintStack() {
        return this.isPrintStack;
    }

    public static class HsqlRuntimeMemoryError
    extends OutOfMemoryError {
        HsqlRuntimeMemoryError() {
        }
    }
}

