/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.Locale;

enum AuthenticationScheme {
    nativeAuthentication,
    javaKerberos;


    static AuthenticationScheme valueOfString(String string) throws SQLServerException {
        AuthenticationScheme authenticationScheme;
        if (string.toLowerCase(Locale.US).equalsIgnoreCase(javaKerberos.toString())) {
            authenticationScheme = javaKerberos;
        } else if (string.toLowerCase(Locale.US).equalsIgnoreCase(nativeAuthentication.toString())) {
            authenticationScheme = nativeAuthentication;
        } else {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidAuthenticationScheme"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return authenticationScheme;
    }
}

