# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Ptsv2paymentsTravelInformationTransitAirline(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'booking_reference_number': 'str',
        'carrier_name': 'str',
        'ticket_issuer': 'Ptsv2paymentsTravelInformationTransitAirlineTicketIssuer',
        'ticket_number': 'str',
        'check_digit': 'str',
        'restricted_ticket_indicator': 'int',
        'transaction_type': 'int',
        'extended_payment_code': 'str',
        'passenger_name': 'str',
        'customer_code': 'str',
        'document_type': 'str',
        'document_number': 'str',
        'document_number_of_parts': 'int',
        'invoice_number': 'str',
        'invoice_date': 'int',
        'additional_charges': 'str',
        'total_fee_amount': 'str',
        'clearing_sequence': 'str',
        'clearing_count': 'str',
        'total_clearing_amount': 'str',
        'number_of_passengers': 'int',
        'reservation_system_code': 'str',
        'process_identifier': 'str',
        'ticket_issue_date': 'str',
        'electronic_ticket_indicator': 'bool',
        'original_ticket_number': 'str',
        'purchase_type': 'str',
        'credit_reason_indicator': 'str',
        'ticket_change_indicator': 'str',
        'plan_number': 'str',
        'arrival_date': 'str',
        'restricted_ticket_desciption': 'str',
        'exchange_ticket_amount': 'str',
        'exchange_ticket_fee_amount': 'str',
        'reservation_type': 'str',
        'boarding_fee_amount': 'str',
        'legs': 'list[Ptsv2paymentsTravelInformationTransitAirlineLegs]',
        'ancillary_information': 'Ptsv2paymentsTravelInformationTransitAirlineAncillaryInformation'
    }

    attribute_map = {
        'booking_reference_number': 'bookingReferenceNumber',
        'carrier_name': 'carrierName',
        'ticket_issuer': 'ticketIssuer',
        'ticket_number': 'ticketNumber',
        'check_digit': 'checkDigit',
        'restricted_ticket_indicator': 'restrictedTicketIndicator',
        'transaction_type': 'transactionType',
        'extended_payment_code': 'extendedPaymentCode',
        'passenger_name': 'passengerName',
        'customer_code': 'customerCode',
        'document_type': 'documentType',
        'document_number': 'documentNumber',
        'document_number_of_parts': 'documentNumberOfParts',
        'invoice_number': 'invoiceNumber',
        'invoice_date': 'invoiceDate',
        'additional_charges': 'additionalCharges',
        'total_fee_amount': 'totalFeeAmount',
        'clearing_sequence': 'clearingSequence',
        'clearing_count': 'clearingCount',
        'total_clearing_amount': 'totalClearingAmount',
        'number_of_passengers': 'numberOfPassengers',
        'reservation_system_code': 'reservationSystemCode',
        'process_identifier': 'processIdentifier',
        'ticket_issue_date': 'ticketIssueDate',
        'electronic_ticket_indicator': 'electronicTicketIndicator',
        'original_ticket_number': 'originalTicketNumber',
        'purchase_type': 'purchaseType',
        'credit_reason_indicator': 'creditReasonIndicator',
        'ticket_change_indicator': 'ticketChangeIndicator',
        'plan_number': 'planNumber',
        'arrival_date': 'arrivalDate',
        'restricted_ticket_desciption': 'restrictedTicketDesciption',
        'exchange_ticket_amount': 'exchangeTicketAmount',
        'exchange_ticket_fee_amount': 'exchangeTicketFeeAmount',
        'reservation_type': 'reservationType',
        'boarding_fee_amount': 'boardingFeeAmount',
        'legs': 'legs',
        'ancillary_information': 'ancillaryInformation'
    }

    def __init__(self, booking_reference_number=None, carrier_name=None, ticket_issuer=None, ticket_number=None, check_digit=None, restricted_ticket_indicator=None, transaction_type=None, extended_payment_code=None, passenger_name=None, customer_code=None, document_type=None, document_number=None, document_number_of_parts=None, invoice_number=None, invoice_date=None, additional_charges=None, total_fee_amount=None, clearing_sequence=None, clearing_count=None, total_clearing_amount=None, number_of_passengers=None, reservation_system_code=None, process_identifier=None, ticket_issue_date=None, electronic_ticket_indicator=None, original_ticket_number=None, purchase_type=None, credit_reason_indicator=None, ticket_change_indicator=None, plan_number=None, arrival_date=None, restricted_ticket_desciption=None, exchange_ticket_amount=None, exchange_ticket_fee_amount=None, reservation_type=None, boarding_fee_amount=None, legs=None, ancillary_information=None):
        """
        Ptsv2paymentsTravelInformationTransitAirline - a model defined in Swagger
        """

        self._booking_reference_number = None
        self._carrier_name = None
        self._ticket_issuer = None
        self._ticket_number = None
        self._check_digit = None
        self._restricted_ticket_indicator = None
        self._transaction_type = None
        self._extended_payment_code = None
        self._passenger_name = None
        self._customer_code = None
        self._document_type = None
        self._document_number = None
        self._document_number_of_parts = None
        self._invoice_number = None
        self._invoice_date = None
        self._additional_charges = None
        self._total_fee_amount = None
        self._clearing_sequence = None
        self._clearing_count = None
        self._total_clearing_amount = None
        self._number_of_passengers = None
        self._reservation_system_code = None
        self._process_identifier = None
        self._ticket_issue_date = None
        self._electronic_ticket_indicator = None
        self._original_ticket_number = None
        self._purchase_type = None
        self._credit_reason_indicator = None
        self._ticket_change_indicator = None
        self._plan_number = None
        self._arrival_date = None
        self._restricted_ticket_desciption = None
        self._exchange_ticket_amount = None
        self._exchange_ticket_fee_amount = None
        self._reservation_type = None
        self._boarding_fee_amount = None
        self._legs = None
        self._ancillary_information = None

        if booking_reference_number is not None:
          self.booking_reference_number = booking_reference_number
        if carrier_name is not None:
          self.carrier_name = carrier_name
        if ticket_issuer is not None:
          self.ticket_issuer = ticket_issuer
        if ticket_number is not None:
          self.ticket_number = ticket_number
        if check_digit is not None:
          self.check_digit = check_digit
        if restricted_ticket_indicator is not None:
          self.restricted_ticket_indicator = restricted_ticket_indicator
        if transaction_type is not None:
          self.transaction_type = transaction_type
        if extended_payment_code is not None:
          self.extended_payment_code = extended_payment_code
        if passenger_name is not None:
          self.passenger_name = passenger_name
        if customer_code is not None:
          self.customer_code = customer_code
        if document_type is not None:
          self.document_type = document_type
        if document_number is not None:
          self.document_number = document_number
        if document_number_of_parts is not None:
          self.document_number_of_parts = document_number_of_parts
        if invoice_number is not None:
          self.invoice_number = invoice_number
        if invoice_date is not None:
          self.invoice_date = invoice_date
        if additional_charges is not None:
          self.additional_charges = additional_charges
        if total_fee_amount is not None:
          self.total_fee_amount = total_fee_amount
        if clearing_sequence is not None:
          self.clearing_sequence = clearing_sequence
        if clearing_count is not None:
          self.clearing_count = clearing_count
        if total_clearing_amount is not None:
          self.total_clearing_amount = total_clearing_amount
        if number_of_passengers is not None:
          self.number_of_passengers = number_of_passengers
        if reservation_system_code is not None:
          self.reservation_system_code = reservation_system_code
        if process_identifier is not None:
          self.process_identifier = process_identifier
        if ticket_issue_date is not None:
          self.ticket_issue_date = ticket_issue_date
        if electronic_ticket_indicator is not None:
          self.electronic_ticket_indicator = electronic_ticket_indicator
        if original_ticket_number is not None:
          self.original_ticket_number = original_ticket_number
        if purchase_type is not None:
          self.purchase_type = purchase_type
        if credit_reason_indicator is not None:
          self.credit_reason_indicator = credit_reason_indicator
        if ticket_change_indicator is not None:
          self.ticket_change_indicator = ticket_change_indicator
        if plan_number is not None:
          self.plan_number = plan_number
        if arrival_date is not None:
          self.arrival_date = arrival_date
        if restricted_ticket_desciption is not None:
          self.restricted_ticket_desciption = restricted_ticket_desciption
        if exchange_ticket_amount is not None:
          self.exchange_ticket_amount = exchange_ticket_amount
        if exchange_ticket_fee_amount is not None:
          self.exchange_ticket_fee_amount = exchange_ticket_fee_amount
        if reservation_type is not None:
          self.reservation_type = reservation_type
        if boarding_fee_amount is not None:
          self.boarding_fee_amount = boarding_fee_amount
        if legs is not None:
          self.legs = legs
        if ancillary_information is not None:
          self.ancillary_information = ancillary_information

    @property
    def booking_reference_number(self):
        """
        Gets the booking_reference_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Reference number for the airline booking. Required if ticket numbers are not issued. 

        :return: The booking_reference_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._booking_reference_number

    @booking_reference_number.setter
    def booking_reference_number(self, booking_reference_number):
        """
        Sets the booking_reference_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Reference number for the airline booking. Required if ticket numbers are not issued. 

        :param booking_reference_number: The booking_reference_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if booking_reference_number is not None and len(booking_reference_number) > 15:
            raise ValueError("Invalid value for `booking_reference_number`, length must be less than or equal to `15`")

        self._booking_reference_number = booking_reference_number

    @property
    def carrier_name(self):
        """
        Gets the carrier_name of this Ptsv2paymentsTravelInformationTransitAirline.
        Name of the airline. If you do not include this field, CyberSource uses the value for your merchant name that is in the CyberSource merchant configuration database. 

        :return: The carrier_name of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._carrier_name

    @carrier_name.setter
    def carrier_name(self, carrier_name):
        """
        Sets the carrier_name of this Ptsv2paymentsTravelInformationTransitAirline.
        Name of the airline. If you do not include this field, CyberSource uses the value for your merchant name that is in the CyberSource merchant configuration database. 

        :param carrier_name: The carrier_name of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if carrier_name is not None and len(carrier_name) > 15:
            raise ValueError("Invalid value for `carrier_name`, length must be less than or equal to `15`")

        self._carrier_name = carrier_name

    @property
    def ticket_issuer(self):
        """
        Gets the ticket_issuer of this Ptsv2paymentsTravelInformationTransitAirline.

        :return: The ticket_issuer of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: Ptsv2paymentsTravelInformationTransitAirlineTicketIssuer
        """
        return self._ticket_issuer

    @ticket_issuer.setter
    def ticket_issuer(self, ticket_issuer):
        """
        Sets the ticket_issuer of this Ptsv2paymentsTravelInformationTransitAirline.

        :param ticket_issuer: The ticket_issuer of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: Ptsv2paymentsTravelInformationTransitAirlineTicketIssuer
        """

        self._ticket_issuer = ticket_issuer

    @property
    def ticket_number(self):
        """
        Gets the ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Ticket number. Format: English characters only 

        :return: The ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._ticket_number

    @ticket_number.setter
    def ticket_number(self, ticket_number):
        """
        Sets the ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Ticket number. Format: English characters only 

        :param ticket_number: The ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if ticket_number is not None and len(ticket_number) > 15:
            raise ValueError("Invalid value for `ticket_number`, length must be less than or equal to `15`")

        self._ticket_number = ticket_number

    @property
    def check_digit(self):
        """
        Gets the check_digit of this Ptsv2paymentsTravelInformationTransitAirline.
        Check digit for the ticket number. CyberSource recommends that you validate the check digit. With Discover and Diners Club, a valid ticket number has these characteristics: - The value is numeric. - The first three digits are a valid IATA2 license plate carrier code. - The last digit is a check digit or zero (0). - All remaining digits are nonzero. 

        :return: The check_digit of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._check_digit

    @check_digit.setter
    def check_digit(self, check_digit):
        """
        Sets the check_digit of this Ptsv2paymentsTravelInformationTransitAirline.
        Check digit for the ticket number. CyberSource recommends that you validate the check digit. With Discover and Diners Club, a valid ticket number has these characteristics: - The value is numeric. - The first three digits are a valid IATA2 license plate carrier code. - The last digit is a check digit or zero (0). - All remaining digits are nonzero. 

        :param check_digit: The check_digit of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if check_digit is not None and len(check_digit) > 1:
            raise ValueError("Invalid value for `check_digit`, length must be less than or equal to `1`")

        self._check_digit = check_digit

    @property
    def restricted_ticket_indicator(self):
        """
        Gets the restricted_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Flag that indicates whether or not the ticket is restricted (nonrefundable). Possible values: - 0: No restriction (refundable) - 1: Restricted (nonrefundable) 

        :return: The restricted_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._restricted_ticket_indicator

    @restricted_ticket_indicator.setter
    def restricted_ticket_indicator(self, restricted_ticket_indicator):
        """
        Sets the restricted_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Flag that indicates whether or not the ticket is restricted (nonrefundable). Possible values: - 0: No restriction (refundable) - 1: Restricted (nonrefundable) 

        :param restricted_ticket_indicator: The restricted_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._restricted_ticket_indicator = restricted_ticket_indicator

    @property
    def transaction_type(self):
        """
        Gets the transaction_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of charge. Possible values: - 01: Charge is for an airline ticket - 02: Charge is for an item that is not an airline ticket 

        :return: The transaction_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """
        Sets the transaction_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of charge. Possible values: - 01: Charge is for an airline ticket - 02: Charge is for an item that is not an airline ticket 

        :param transaction_type: The transaction_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._transaction_type = transaction_type

    @property
    def extended_payment_code(self):
        """
        Gets the extended_payment_code of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline process identifier. This value is the airline’s three-digit IATA1 code which is used to process extended payment airline tickets.. 

        :return: The extended_payment_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._extended_payment_code

    @extended_payment_code.setter
    def extended_payment_code(self, extended_payment_code):
        """
        Sets the extended_payment_code of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline process identifier. This value is the airline’s three-digit IATA1 code which is used to process extended payment airline tickets.. 

        :param extended_payment_code: The extended_payment_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if extended_payment_code is not None and len(extended_payment_code) > 3:
            raise ValueError("Invalid value for `extended_payment_code`, length must be less than or equal to `3`")

        self._extended_payment_code = extended_payment_code

    @property
    def passenger_name(self):
        """
        Gets the passenger_name of this Ptsv2paymentsTravelInformationTransitAirline.
        Name of the passenger to whom the ticket was issued. This will always be a single passenger's name. If there are more than one passengers, provide only the primary passenger's name. Do not include special characters such as commas, hyphens, or apostrophes. Only ASCII characters are supported. 

        :return: The passenger_name of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._passenger_name

    @passenger_name.setter
    def passenger_name(self, passenger_name):
        """
        Sets the passenger_name of this Ptsv2paymentsTravelInformationTransitAirline.
        Name of the passenger to whom the ticket was issued. This will always be a single passenger's name. If there are more than one passengers, provide only the primary passenger's name. Do not include special characters such as commas, hyphens, or apostrophes. Only ASCII characters are supported. 

        :param passenger_name: The passenger_name of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if passenger_name is not None and len(passenger_name) > 42:
            raise ValueError("Invalid value for `passenger_name`, length must be less than or equal to `42`")

        self._passenger_name = passenger_name

    @property
    def customer_code(self):
        """
        Gets the customer_code of this Ptsv2paymentsTravelInformationTransitAirline.
        1.Reference number or code that identifies the cardholder. 2. Code provided by the cardholder. 3. Address of the ticket issuer. The first 13 characters will appear onthe cardholder’s statement. 4. Customer reference. 

        :return: The customer_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._customer_code

    @customer_code.setter
    def customer_code(self, customer_code):
        """
        Sets the customer_code of this Ptsv2paymentsTravelInformationTransitAirline.
        1.Reference number or code that identifies the cardholder. 2. Code provided by the cardholder. 3. Address of the ticket issuer. The first 13 characters will appear onthe cardholder’s statement. 4. Customer reference. 

        :param customer_code: The customer_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if customer_code is not None and len(customer_code) > 40:
            raise ValueError("Invalid value for `customer_code`, length must be less than or equal to `40`")

        self._customer_code = customer_code

    @property
    def document_type(self):
        """
        Gets the document_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline document type code that specifies the purpose of the transaction. For the possible values, see Appendix A, \"Airline Document Type Codes\". 

        :return: The document_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._document_type

    @document_type.setter
    def document_type(self, document_type):
        """
        Sets the document_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline document type code that specifies the purpose of the transaction. For the possible values, see Appendix A, \"Airline Document Type Codes\". 

        :param document_type: The document_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if document_type is not None and len(document_type) > 1:
            raise ValueError("Invalid value for `document_type`, length must be less than or equal to `1`")

        self._document_type = document_type

    @property
    def document_number(self):
        """
        Gets the document_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Ticket number or a value that might be a booking reference number. 

        :return: The document_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._document_number

    @document_number.setter
    def document_number(self, document_number):
        """
        Sets the document_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Ticket number or a value that might be a booking reference number. 

        :param document_number: The document_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if document_number is not None and len(document_number) > 14:
            raise ValueError("Invalid value for `document_number`, length must be less than or equal to `14`")

        self._document_number = document_number

    @property
    def document_number_of_parts(self):
        """
        Gets the document_number_of_parts of this Ptsv2paymentsTravelInformationTransitAirline.
        Number of travel legs. Numbering for the travel legs: 0 to 3. 

        :return: The document_number_of_parts of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._document_number_of_parts

    @document_number_of_parts.setter
    def document_number_of_parts(self, document_number_of_parts):
        """
        Sets the document_number_of_parts of this Ptsv2paymentsTravelInformationTransitAirline.
        Number of travel legs. Numbering for the travel legs: 0 to 3. 

        :param document_number_of_parts: The document_number_of_parts of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._document_number_of_parts = document_number_of_parts

    @property
    def invoice_number(self):
        """
        Gets the invoice_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Invoice number for the airline transaction. 

        :return: The invoice_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._invoice_number

    @invoice_number.setter
    def invoice_number(self, invoice_number):
        """
        Sets the invoice_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Invoice number for the airline transaction. 

        :param invoice_number: The invoice_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if invoice_number is not None and len(invoice_number) > 25:
            raise ValueError("Invalid value for `invoice_number`, length must be less than or equal to `25`")

        self._invoice_number = invoice_number

    @property
    def invoice_date(self):
        """
        Gets the invoice_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Invoice date. The format is YYYYMMDD. If this value is included in the request, it is used in the creation of the invoice number. See \"Invoice Number,\" 

        :return: The invoice_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._invoice_date

    @invoice_date.setter
    def invoice_date(self, invoice_date):
        """
        Sets the invoice_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Invoice date. The format is YYYYMMDD. If this value is included in the request, it is used in the creation of the invoice number. See \"Invoice Number,\" 

        :param invoice_date: The invoice_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._invoice_date = invoice_date

    @property
    def additional_charges(self):
        """
        Gets the additional_charges of this Ptsv2paymentsTravelInformationTransitAirline.
        Description of the charge if the charge does not involve an airline ticket. For example: Excess baggage. 

        :return: The additional_charges of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._additional_charges

    @additional_charges.setter
    def additional_charges(self, additional_charges):
        """
        Sets the additional_charges of this Ptsv2paymentsTravelInformationTransitAirline.
        Description of the charge if the charge does not involve an airline ticket. For example: Excess baggage. 

        :param additional_charges: The additional_charges of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if additional_charges is not None and len(additional_charges) > 20:
            raise ValueError("Invalid value for `additional_charges`, length must be less than or equal to `20`")

        self._additional_charges = additional_charges

    @property
    def total_fee_amount(self):
        """
        Gets the total_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total fee for the ticket. This value cannot exceed 99999999999999999999 (twenty 9s). 

        :return: The total_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._total_fee_amount

    @total_fee_amount.setter
    def total_fee_amount(self, total_fee_amount):
        """
        Sets the total_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total fee for the ticket. This value cannot exceed 99999999999999999999 (twenty 9s). 

        :param total_fee_amount: The total_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if total_fee_amount is not None and len(total_fee_amount) > 12:
            raise ValueError("Invalid value for `total_fee_amount`, length must be less than or equal to `12`")

        self._total_fee_amount = total_fee_amount

    @property
    def clearing_sequence(self):
        """
        Gets the clearing_sequence of this Ptsv2paymentsTravelInformationTransitAirline.
        Total number of captures when requesting multiple partial captures for one authorization. Used along with airlineData_clearingCount to keep track of which capture is beingprocessed. For example, the second of five captures would be passed to CyberSource as airlineData_clearingSequence = 2 and airlineData_clearingCount = 5. 

        :return: The clearing_sequence of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._clearing_sequence

    @clearing_sequence.setter
    def clearing_sequence(self, clearing_sequence):
        """
        Sets the clearing_sequence of this Ptsv2paymentsTravelInformationTransitAirline.
        Total number of captures when requesting multiple partial captures for one authorization. Used along with airlineData_clearingCount to keep track of which capture is beingprocessed. For example, the second of five captures would be passed to CyberSource as airlineData_clearingSequence = 2 and airlineData_clearingCount = 5. 

        :param clearing_sequence: The clearing_sequence of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if clearing_sequence is not None and len(clearing_sequence) > 2:
            raise ValueError("Invalid value for `clearing_sequence`, length must be less than or equal to `2`")

        self._clearing_sequence = clearing_sequence

    @property
    def clearing_count(self):
        """
        Gets the clearing_count of this Ptsv2paymentsTravelInformationTransitAirline.
        Total number of clearing messages associated with the authorization request. Format: English characters only. 

        :return: The clearing_count of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._clearing_count

    @clearing_count.setter
    def clearing_count(self, clearing_count):
        """
        Sets the clearing_count of this Ptsv2paymentsTravelInformationTransitAirline.
        Total number of clearing messages associated with the authorization request. Format: English characters only. 

        :param clearing_count: The clearing_count of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if clearing_count is not None and len(clearing_count) > 2:
            raise ValueError("Invalid value for `clearing_count`, length must be less than or equal to `2`")

        self._clearing_count = clearing_count

    @property
    def total_clearing_amount(self):
        """
        Gets the total_clearing_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total clearing amount for all transactions in the clearing count set. If this field is not set and if the total amount from the original authorization is not NULL, CyberSource sets the total clearing amount to the total amount from the original authorization. 

        :return: The total_clearing_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._total_clearing_amount

    @total_clearing_amount.setter
    def total_clearing_amount(self, total_clearing_amount):
        """
        Sets the total_clearing_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Total clearing amount for all transactions in the clearing count set. If this field is not set and if the total amount from the original authorization is not NULL, CyberSource sets the total clearing amount to the total amount from the original authorization. 

        :param total_clearing_amount: The total_clearing_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if total_clearing_amount is not None and len(total_clearing_amount) > 20:
            raise ValueError("Invalid value for `total_clearing_amount`, length must be less than or equal to `20`")

        self._total_clearing_amount = total_clearing_amount

    @property
    def number_of_passengers(self):
        """
        Gets the number_of_passengers of this Ptsv2paymentsTravelInformationTransitAirline.
        Number of passengers for whom the ticket was issued. If you do not include this field in your request, CyberSource uses a default value of 1. 

        :return: The number_of_passengers of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: int
        """
        return self._number_of_passengers

    @number_of_passengers.setter
    def number_of_passengers(self, number_of_passengers):
        """
        Sets the number_of_passengers of this Ptsv2paymentsTravelInformationTransitAirline.
        Number of passengers for whom the ticket was issued. If you do not include this field in your request, CyberSource uses a default value of 1. 

        :param number_of_passengers: The number_of_passengers of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: int
        """

        self._number_of_passengers = number_of_passengers

    @property
    def reservation_system_code(self):
        """
        Gets the reservation_system_code of this Ptsv2paymentsTravelInformationTransitAirline.
        Code that specifies the computerized reservation system used to make the reservation and purchase the ticket. Format: English characters only 

        :return: The reservation_system_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._reservation_system_code

    @reservation_system_code.setter
    def reservation_system_code(self, reservation_system_code):
        """
        Sets the reservation_system_code of this Ptsv2paymentsTravelInformationTransitAirline.
        Code that specifies the computerized reservation system used to make the reservation and purchase the ticket. Format: English characters only 

        :param reservation_system_code: The reservation_system_code of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if reservation_system_code is not None and len(reservation_system_code) > 4:
            raise ValueError("Invalid value for `reservation_system_code`, length must be less than or equal to `4`")

        self._reservation_system_code = reservation_system_code

    @property
    def process_identifier(self):
        """
        Gets the process_identifier of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline process identifier. This value is the airline’s three-digit IATA1 code which is used to process extended payment airline tickets. 

        :return: The process_identifier of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._process_identifier

    @process_identifier.setter
    def process_identifier(self, process_identifier):
        """
        Sets the process_identifier of this Ptsv2paymentsTravelInformationTransitAirline.
        Airline process identifier. This value is the airline’s three-digit IATA1 code which is used to process extended payment airline tickets. 

        :param process_identifier: The process_identifier of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if process_identifier is not None and len(process_identifier) > 3:
            raise ValueError("Invalid value for `process_identifier`, length must be less than or equal to `3`")

        self._process_identifier = process_identifier

    @property
    def ticket_issue_date(self):
        """
        Gets the ticket_issue_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Date on which the transactionoccurred. Format: YYYYMMDD 

        :return: The ticket_issue_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._ticket_issue_date

    @ticket_issue_date.setter
    def ticket_issue_date(self, ticket_issue_date):
        """
        Sets the ticket_issue_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Date on which the transactionoccurred. Format: YYYYMMDD 

        :param ticket_issue_date: The ticket_issue_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if ticket_issue_date is not None and len(ticket_issue_date) > 8:
            raise ValueError("Invalid value for `ticket_issue_date`, length must be less than or equal to `8`")

        self._ticket_issue_date = ticket_issue_date

    @property
    def electronic_ticket_indicator(self):
        """
        Gets the electronic_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Flag that indicates whether an electronic ticket was issued. Possible values: - true - false 

        :return: The electronic_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: bool
        """
        return self._electronic_ticket_indicator

    @electronic_ticket_indicator.setter
    def electronic_ticket_indicator(self, electronic_ticket_indicator):
        """
        Sets the electronic_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Flag that indicates whether an electronic ticket was issued. Possible values: - true - false 

        :param electronic_ticket_indicator: The electronic_ticket_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: bool
        """

        self._electronic_ticket_indicator = electronic_ticket_indicator

    @property
    def original_ticket_number(self):
        """
        Gets the original_ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Original ticket number when the transaction is for a replacement ticket. 

        :return: The original_ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._original_ticket_number

    @original_ticket_number.setter
    def original_ticket_number(self, original_ticket_number):
        """
        Sets the original_ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Original ticket number when the transaction is for a replacement ticket. 

        :param original_ticket_number: The original_ticket_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if original_ticket_number is not None and len(original_ticket_number) > 14:
            raise ValueError("Invalid value for `original_ticket_number`, length must be less than or equal to `14`")

        self._original_ticket_number = original_ticket_number

    @property
    def purchase_type(self):
        """
        Gets the purchase_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of purchase. Possible values: - EXC: Exchange ticket - MSC: Miscellaneous (not a ticket purchase and not a transaction related to an exchange ticket) - REF: Refund - TKT: Ticket Format: English characters only. 

        :return: The purchase_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._purchase_type

    @purchase_type.setter
    def purchase_type(self, purchase_type):
        """
        Sets the purchase_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of purchase. Possible values: - EXC: Exchange ticket - MSC: Miscellaneous (not a ticket purchase and not a transaction related to an exchange ticket) - REF: Refund - TKT: Ticket Format: English characters only. 

        :param purchase_type: The purchase_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if purchase_type is not None and len(purchase_type) > 3:
            raise ValueError("Invalid value for `purchase_type`, length must be less than or equal to `3`")

        self._purchase_type = purchase_type

    @property
    def credit_reason_indicator(self):
        """
        Gets the credit_reason_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Reason for the credit. Possible values: - A: Cancellation of the ancillary passenger transport purchase. - B: Cancellation of the airline ticket and the passenger transport ancillary purchase. - C: Cancellation of the airline ticket. - O: Other. - P: Partial refund of the airline ticket. 

        :return: The credit_reason_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._credit_reason_indicator

    @credit_reason_indicator.setter
    def credit_reason_indicator(self, credit_reason_indicator):
        """
        Sets the credit_reason_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Reason for the credit. Possible values: - A: Cancellation of the ancillary passenger transport purchase. - B: Cancellation of the airline ticket and the passenger transport ancillary purchase. - C: Cancellation of the airline ticket. - O: Other. - P: Partial refund of the airline ticket. 

        :param credit_reason_indicator: The credit_reason_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if credit_reason_indicator is not None and len(credit_reason_indicator) > 1:
            raise ValueError("Invalid value for `credit_reason_indicator`, length must be less than or equal to `1`")

        self._credit_reason_indicator = credit_reason_indicator

    @property
    def ticket_change_indicator(self):
        """
        Gets the ticket_change_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of update. Possible values: - C: Change to the existing ticket. - N: New ticket. Format: English characters only 

        :return: The ticket_change_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._ticket_change_indicator

    @ticket_change_indicator.setter
    def ticket_change_indicator(self, ticket_change_indicator):
        """
        Sets the ticket_change_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of update. Possible values: - C: Change to the existing ticket. - N: New ticket. Format: English characters only 

        :param ticket_change_indicator: The ticket_change_indicator of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if ticket_change_indicator is not None and len(ticket_change_indicator) > 1:
            raise ValueError("Invalid value for `ticket_change_indicator`, length must be less than or equal to `1`")

        self._ticket_change_indicator = ticket_change_indicator

    @property
    def plan_number(self):
        """
        Gets the plan_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Plan number based on the fare. This value is provided by the airline. Format: English characters only 

        :return: The plan_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._plan_number

    @plan_number.setter
    def plan_number(self, plan_number):
        """
        Sets the plan_number of this Ptsv2paymentsTravelInformationTransitAirline.
        Plan number based on the fare. This value is provided by the airline. Format: English characters only 

        :param plan_number: The plan_number of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if plan_number is not None and len(plan_number) > 1:
            raise ValueError("Invalid value for `plan_number`, length must be less than or equal to `1`")

        self._plan_number = plan_number

    @property
    def arrival_date(self):
        """
        Gets the arrival_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Date of arrival for the last leg of the trip. Format: MMDDYYYY English characters only. 

        :return: The arrival_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._arrival_date

    @arrival_date.setter
    def arrival_date(self, arrival_date):
        """
        Sets the arrival_date of this Ptsv2paymentsTravelInformationTransitAirline.
        Date of arrival for the last leg of the trip. Format: MMDDYYYY English characters only. 

        :param arrival_date: The arrival_date of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if arrival_date is not None and len(arrival_date) > 8:
            raise ValueError("Invalid value for `arrival_date`, length must be less than or equal to `8`")

        self._arrival_date = arrival_date

    @property
    def restricted_ticket_desciption(self):
        """
        Gets the restricted_ticket_desciption of this Ptsv2paymentsTravelInformationTransitAirline.
        Text that describes the ticket limitations, such as nonrefundable. Format: English characters only. 

        :return: The restricted_ticket_desciption of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._restricted_ticket_desciption

    @restricted_ticket_desciption.setter
    def restricted_ticket_desciption(self, restricted_ticket_desciption):
        """
        Sets the restricted_ticket_desciption of this Ptsv2paymentsTravelInformationTransitAirline.
        Text that describes the ticket limitations, such as nonrefundable. Format: English characters only. 

        :param restricted_ticket_desciption: The restricted_ticket_desciption of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if restricted_ticket_desciption is not None and len(restricted_ticket_desciption) > 20:
            raise ValueError("Invalid value for `restricted_ticket_desciption`, length must be less than or equal to `20`")

        self._restricted_ticket_desciption = restricted_ticket_desciption

    @property
    def exchange_ticket_amount(self):
        """
        Gets the exchange_ticket_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Amount of the exchanged ticket. Format: English characters only. 

        :return: The exchange_ticket_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._exchange_ticket_amount

    @exchange_ticket_amount.setter
    def exchange_ticket_amount(self, exchange_ticket_amount):
        """
        Sets the exchange_ticket_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Amount of the exchanged ticket. Format: English characters only. 

        :param exchange_ticket_amount: The exchange_ticket_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if exchange_ticket_amount is not None and len(exchange_ticket_amount) > 12:
            raise ValueError("Invalid value for `exchange_ticket_amount`, length must be less than or equal to `12`")

        self._exchange_ticket_amount = exchange_ticket_amount

    @property
    def exchange_ticket_fee_amount(self):
        """
        Gets the exchange_ticket_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Fee for exchanging the ticket. Format: English characters only 

        :return: The exchange_ticket_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._exchange_ticket_fee_amount

    @exchange_ticket_fee_amount.setter
    def exchange_ticket_fee_amount(self, exchange_ticket_fee_amount):
        """
        Sets the exchange_ticket_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Fee for exchanging the ticket. Format: English characters only 

        :param exchange_ticket_fee_amount: The exchange_ticket_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if exchange_ticket_fee_amount is not None and len(exchange_ticket_fee_amount) > 12:
            raise ValueError("Invalid value for `exchange_ticket_fee_amount`, length must be less than or equal to `12`")

        self._exchange_ticket_fee_amount = exchange_ticket_fee_amount

    @property
    def reservation_type(self):
        """
        Gets the reservation_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of journey such as one way or round trip. 

        :return: The reservation_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._reservation_type

    @reservation_type.setter
    def reservation_type(self, reservation_type):
        """
        Sets the reservation_type of this Ptsv2paymentsTravelInformationTransitAirline.
        Type of journey such as one way or round trip. 

        :param reservation_type: The reservation_type of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if reservation_type is not None and len(reservation_type) > 32:
            raise ValueError("Invalid value for `reservation_type`, length must be less than or equal to `32`")

        self._reservation_type = reservation_type

    @property
    def boarding_fee_amount(self):
        """
        Gets the boarding_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Boarding fee. 

        :return: The boarding_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: str
        """
        return self._boarding_fee_amount

    @boarding_fee_amount.setter
    def boarding_fee_amount(self, boarding_fee_amount):
        """
        Sets the boarding_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        Boarding fee. 

        :param boarding_fee_amount: The boarding_fee_amount of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: str
        """
        if boarding_fee_amount is not None and len(boarding_fee_amount) > 12:
            raise ValueError("Invalid value for `boarding_fee_amount`, length must be less than or equal to `12`")

        self._boarding_fee_amount = boarding_fee_amount

    @property
    def legs(self):
        """
        Gets the legs of this Ptsv2paymentsTravelInformationTransitAirline.

        :return: The legs of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: list[Ptsv2paymentsTravelInformationTransitAirlineLegs]
        """
        return self._legs

    @legs.setter
    def legs(self, legs):
        """
        Sets the legs of this Ptsv2paymentsTravelInformationTransitAirline.

        :param legs: The legs of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: list[Ptsv2paymentsTravelInformationTransitAirlineLegs]
        """

        self._legs = legs

    @property
    def ancillary_information(self):
        """
        Gets the ancillary_information of this Ptsv2paymentsTravelInformationTransitAirline.

        :return: The ancillary_information of this Ptsv2paymentsTravelInformationTransitAirline.
        :rtype: Ptsv2paymentsTravelInformationTransitAirlineAncillaryInformation
        """
        return self._ancillary_information

    @ancillary_information.setter
    def ancillary_information(self, ancillary_information):
        """
        Sets the ancillary_information of this Ptsv2paymentsTravelInformationTransitAirline.

        :param ancillary_information: The ancillary_information of this Ptsv2paymentsTravelInformationTransitAirline.
        :type: Ptsv2paymentsTravelInformationTransitAirlineAncillaryInformation
        """

        self._ancillary_information = ancillary_information

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Ptsv2paymentsTravelInformationTransitAirline):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
