# Generated by Django 3.2.11 on 2022-10-03 12:47

import django.contrib.postgres.fields
import django.contrib.postgres.indexes
import django.contrib.postgres.operations
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        django.contrib.postgres.operations.CreateExtension('intarray'),
        migrations.CreateModel(
            name='Stats',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('recipient_object_id', models.CharField(max_length=255, verbose_name='Recipient: Id')),
                ('flags', models.JSONField(blank=True, default=dict, verbose_name='Flags stats')),
                ('total', models.PositiveBigIntegerField(default=0, verbose_name='Total')),
                ('recipient_content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='stats_recipient', to='contenttypes.contenttype', verbose_name='Recipient: Content type')),
            ],
            options={
                'verbose_name': 'Notification stats',
                'verbose_name_plural': 'List of notifications stats',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('recipient_object_id', models.CharField(max_length=255, verbose_name='Recipient: Id')),
                ('actor_object_id', models.CharField(blank=True, max_length=255, null=True, verbose_name='Actor: Id')),
                ('action_object_id', models.CharField(blank=True, max_length=255, null=True, verbose_name='Action: Id')),
                ('target_object_id', models.CharField(blank=True, max_length=255, null=True, verbose_name='Target: Id')),
                ('flags', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), size=None, verbose_name='Flags')),
                ('message', models.TextField(verbose_name='Message')),
                ('data', models.JSONField(blank=True, default=dict, verbose_name='Data')),
                ('sended_at', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('created_at', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('ordering_field', models.BigIntegerField(db_index=True, editable=False)),
                ('action_content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notification_action', to='contenttypes.contenttype', verbose_name='Action: Content type')),
                ('actor_content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notification_actor', to='contenttypes.contenttype', verbose_name='Actor: Content type')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='wcd_notifications.notification', verbose_name='Parent notification')),
                ('recipient_content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notification_recipient', to='contenttypes.contenttype', verbose_name='Recipient: Content type')),
                ('target_content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notification_target', to='contenttypes.contenttype', verbose_name='Target: Content type')),
            ],
            options={
                'verbose_name': 'Notification',
                'verbose_name_plural': 'Notifications',
                'ordering': ('ordering_field', '-sended_at', '-created_at', '-pk'),
            },
        ),
        migrations.AddIndex(
            model_name='stats',
            index=django.contrib.postgres.indexes.BTreeIndex(fields=['recipient_content_type', 'recipient_object_id'], name='wcd_notific_recipie_7a6270_btree'),
        ),
        migrations.AddIndex(
            model_name='notification',
            index=django.contrib.postgres.indexes.GinIndex(fields=['flags'], name='wcdnt_notification_flags', opclasses=('gin__int_ops',)),
        ),
        migrations.AddIndex(
            model_name='notification',
            index=django.contrib.postgres.indexes.BTreeIndex(fields=['recipient_content_type', 'recipient_object_id'], name='wcd_notific_recipie_1c0195_btree'),
        ),
        migrations.AddIndex(
            model_name='notification',
            index=django.contrib.postgres.indexes.BTreeIndex(fields=['actor_content_type', 'actor_object_id'], name='wcd_notific_actor_c_ec6f85_btree'),
        ),
        migrations.AddIndex(
            model_name='notification',
            index=django.contrib.postgres.indexes.BTreeIndex(fields=['action_content_type', 'action_object_id'], name='wcd_notific_action__70b4f7_btree'),
        ),
        migrations.AddIndex(
            model_name='notification',
            index=django.contrib.postgres.indexes.BTreeIndex(fields=['target_content_type', 'target_object_id'], name='wcd_notific_target__4dd7da_btree'),
        ),
    ]
