"""Constants."""


from beartype.typing import Any, Callable, Dict, List, Optional, Union


class NotFound:

    ...


T_SER = Optional[Union[str, int, float, bool, List, Dict]]
"""JSON-Serializable types."""

T_CONVERTER = Callable[[Any], T_SER]
"""Generic type for converters with a single argument."""

T_DIFF = Any
"""Possible Old or New difference type."""

DEF_CACHE_DIR_NAME = 'assert-cache'
"""Default `pytest_assert_cache` directory name."""

KEY_NAME_META = '_info'
"""Key for metadata."""

KEY_NAME_DATA = '_json'
"""Key for cached data."""

CACHE_README_TEXT = """# Pytest Assert Cache

This folder is automatically generated by `pytest_cache_assert`.

Files can be regenerated by deleting and allowing `pytest_cache_assert` to recreate them when next running the test suite.
"""
"""README content for the cache directory."""
