# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['geekbot_api', 'geekbot_api.clients']

package_data = \
{'': ['*']}

install_requires = \
['httpx>=0.23.3,<0.24.0', 'pydantic>=1.10.5,<2.0.0', 'requests>=2.28.2,<3.0.0']

setup_kwargs = {
    'name': 'geekbot-api',
    'version': '0.2.1',
    'description': 'Async Python client for the geekbot (https://geekbot.com) api',
    'long_description': '# geekbot-api-py\n<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->\n[![All Contributors](https://img.shields.io/badge/all_contributors-3-orange.svg?style=flat-square)](#contributors-)\n<!-- ALL-CONTRIBUTORS-BADGE:END -->\n\nA Geekbot (<https://geekbot.com/>) API client in python supporting async and sync operations.\n\nImplements the Geekbot API per <https://geekbot.com/developers/>\n\n<p align="center">\n    <a href="https://github.com/andrewthetechie/geekbot-api-py" target="_blank">\n        <img src="https://img.shields.io/github/last-commit/andrewthetechie/geekbot-api-py" alt="Latest Commit">\n    </a>\n        <img src="https://github.com/andrewthetechie/geekbot-api-py/actions/workflows/run_tests_with_tox.yaml/badge.svg?branch=main">\n        <img src="https://codecov.io/gh/andrewthetechie/geekbot-api-py/branch/main/graph/badge.svg?token=7BK6JL2VL4"/>\n    <br />\n    <a href="https://pypi.org/project/geekbot-api" target="_blank">\n        <img src="https://img.shields.io/pypi/v/geekbot-api" alt="Package version">\n    </a>\n    <img src="https://img.shields.io/pypi/pyversions/geekbot-api">\n    <img src="https://img.shields.io/badge/license-MIT-green">\n</p>\n\n## Main Dependencies\n\n- [Python +3.7](https://www.python.org)\n- [pydantic](https://github.com/samuelcolvin/pydantic/)\n- [httpx](https://www.python-httpx.org/)\n- [requests](https://docs.python-requests.org/en/master/)\n\n## Getting Started\n\n### Installation\n\nInstall the package\n\n    pip install geekbot-api\n\n### Usage\n\nFollow the directions on <https://geekbot.com/developers/> to get an API Token\n\n#### Example\n\n    from geekbot_api.config import GeekbotAPIConfig\n    from geekbot_api.client import GeekbotAPIClient\n\n    config = GeekbotAPIConfig(api_key="api_YOURKEYGOESHERE")\n\n    client = GeekbotAPIClient(config=config)\n\n    for standup in client.standups.list():\n        standups.append(standup)\n\n        print(standups)\n\n#### Async Example\n\n    import asyncio\n    from geekbot_api.config import GeekbotAPIConfig\n    from geekbot_api.client import GeekbotAPIClient\n\n    config = GeekbotAPIConfig(api_key="api_YOURKEYGOESHERE")\n\n    client = GeekbotAPIClient(config=config)\n\n    async def print_standups():\n        standups = list()\n        async for standup in client.async_standups.list():\n            standups.append(standup)\n\n        print(standups)\n\n    if __name__ == "__main__":\n        loop = asyncio.get_event_loop()\n        loop.run_until_complete(print_standups())\n\n#### Reporting to a standup using schemas\n\n    import asyncio\n    from geekbot_api.config import GeekbotAPIConfig\n    from geekbot_api.client import GeekbotAPIClient\n    from geekbot_api.schemas import ReportIn\n\n    config = GeekbotAPIConfig(api_key="api_YOURKEYGOESHERE")\n\n    client = GeekbotAPIClient(config=config)\n    standup_id = "12345" # Your standup id\n    answers = dict() # keys are question ids, values are a dict responding to the question\n    answers[\'123\'] = {\'text\': "My first answer"}\n    answers[\'234\'] = {\'text\': "My second answer"}\n\n    report_in = ReportIn(standup_id=standup_id, answers=answers) # pydantic will validate your inputs\n    report = client.reports.create(report_in)\n    print(report)\n\n## Development\n\nThe [Makefile](./makefile) has useful targets to help setup your\ndevelopment encironment. We suggest using pyenv to have access to\nmultiple python versions easily.\n\n### Environment Setup\n\n- Clone the repo and enter its root folder\n\n  ```{.sourceCode .bash}\n  git clone https://github.com/andrewthetechie/geekbot-api-py.git && cd geekbot-api-py\n  ```\n\n- Create a python 3.11 virtual environment and activate it. We suggest\n  using [pyenv](https://github.com/pyenv/pyenv) to easily setup\n  multiple python environments on multiple versions.\n\n- Install the dependencies\n\n  ```{.sourceCode .bash}\n  make setup\n  ```\n\n### How to Run Tests\n\n- Run the test command to run tests on only python 3.9\n\n  ```{.sourceCode .bash}\n  pytest\n  ```\n\n- Run Nox to run all python version tests\n\n  ```{.sourceCode .bash}\n  nox -s tests\n  ```\n\n### Test Requirements\n\nPrs should always have tests to cover the change being made. Code\ncoverage goals for this project are 100% coverage.\n\n### Code Linting\n\nCode is linted with ruff\n\nYou can run the linting manually with make\n\n```{.sourceCode .bash}\nmake lint\n```\n\n## CI\n\nCI is run via Github Actions on all PRs and pushes to the main branch.\n\nReleases are automatically released by Github Actions to Pypi.\n\n## License\n\nLicensed under the [MIT License](./LICENSE)\n\n### Contributors\n\nThanks go to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tbody>\n    <tr>\n      <td align="center" valign="top" width="14.28%"><a href="https://github.com/andrewthetechie"><img src="https://avatars.githubusercontent.com/u/1377314?v=4?s=100" width="100px;" alt="Andrew"/><br /><sub><b>Andrew</b></sub></a><br /><a href="https://github.com/andrewthetechie/geekbot-api-py/commits?author=andrewthetechie" title="Code">💻</a> <a href="https://github.com/andrewthetechie/geekbot-api-py/commits?author=andrewthetechie" title="Documentation">📖</a> <a href="https://github.com/andrewthetechie/geekbot-api-py/commits?author=andrewthetechie" title="Tests">⚠️</a></td>\n      <td align="center" valign="top" width="14.28%"><a href="https://github.com/CodingDavid8"><img src="https://avatars.githubusercontent.com/u/54584421?v=4?s=100" width="100px;" alt="David"/><br /><sub><b>David</b></sub></a><br /><a href="https://github.com/andrewthetechie/geekbot-api-py/commits?author=CodingDavid8" title="Code">💻</a> <a href="https://github.com/andrewthetechie/geekbot-api-py/issues?q=author%3ACodingDavid8" title="Bug reports">🐛</a></td>\n      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rmathew8-gh"><img src="https://avatars.githubusercontent.com/u/117225085?v=4?s=100" width="100px;" alt="rmathew8-gh"/><br /><sub><b>rmathew8-gh</b></sub></a><br /><a href="https://github.com/andrewthetechie/geekbot-api-py/commits?author=rmathew8-gh" title="Code">💻</a> <a href="https://github.com/andrewthetechie/geekbot-api-py/commits?author=rmathew8-gh" title="Tests">⚠️</a></td>\n    </tr>\n  </tbody>\n</table>\n\n<!-- markdownlint-restore -->\n<!-- prettier-ignore-end -->\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\n## Contributors ✨\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<!-- markdownlint-restore -->\n<!-- prettier-ignore-end -->\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!\n',
    'author': 'Andrew Herrington',
    'author_email': 'andrew.the.techie@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/andrewthetechie/geekbot-api-py',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
