import logging
import sys

from pathlib import Path

from rsl_comm_py.shearwater_serial import ShearWaterSerial


if __name__ == '__main__':
    logging.basicConfig(
        level=logging.WARNING,
        format='[%(asctime)s.%(msecs)03d] [%(levelname)-8s]:  %(message)s',
        datefmt='%Y-%m-%d %H:%M:%S',
        handlers=[
            logging.FileHandler(f'{Path(__file__).stem}.log', mode='w'),
            logging.StreamHandler(sys.stdout),
        ])
    script_dir = Path(__file__).parent
    device_file = script_dir.parent / "rsl_A500CNHD.json"
    shearwater = ShearWaterSerial(device=device_file)

    print(f"\n========== HIDDEN REGISTERS ===================================")
    print(f"hidden_gyro_1_variance        : {shearwater.hidden_gyro_1_variance}")
    print(f"hidden_gyro_2_variance        : {shearwater.hidden_gyro_2_variance}")
    print(f"hidden_accel_1_variance       : {shearwater.hidden_accel_1_variance}")
    print(f"hidden_mag_1_variance         : {shearwater.hidden_mag_1_variance}")
    print(f"hidden_mag_2_variance         : {shearwater.hidden_mag_2_variance}")
    print(f"hidden_gps_course_variance    : {shearwater.hidden_gps_course_variance}")
    print(f"hidden_gps_position_variance  : {shearwater.hidden_gps_position_variance}")
    print(f"hidden_gps_velocity_variance  : {shearwater.hidden_gps_velocity_variance}")
    print(f"hidden_static_press_variance  : {shearwater.hidden_static_press_variance}")
    print(f"hidden_diff_press_variance    : {shearwater.hidden_diff_press_variance}")
    print(f"hidden_q_uvw                  : {shearwater.hidden_q_uvw}")
    print(f"hidden_q_quaternion           : {shearwater.hidden_q_quaternion}")
    print(f"hidden_q_gps_position         : {shearwater.hidden_q_gps_position}")
    print(f"hidden_q_bias                 : {shearwater.hidden_q_bias}")
    print(f"hidden_q_euler_angles         : {shearwater.hidden_q_euler_angles}")
    print(f"hidden_low_vg_accel_noise_factor: {shearwater.hidden_low_vg_accel_noise_factor}")
    print(f"hidden_lpf_tau_groundspeed    : {shearwater.hidden_lpf_tau_groundspeed}")
    print(f"hidden_lpf_tau_gyro_1         : {shearwater.hidden_lpf_tau_gyro_1}")
    print(f"hidden_lpf_tau_gyro_2         : {shearwater.hidden_lpf_tau_gyro_2}")
    print(f"hidden_lpf_tau_accel_1        : {shearwater.hidden_lpf_tau_accel_1}")
    print(f"hidden_lpf_tau_mag_1          : {shearwater.hidden_lpf_tau_mag_1}")
    print(f"hidden_lpf_tau_mag_2          : {shearwater.hidden_lpf_tau_mag_2}")
    print(f"hidden_c_gyro_1_bias_x_pow_0  : {shearwater.hidden_c_gyro_1_bias_x_pow_0}")
    print(f"hidden_c_gyro_1_bias_x_pow_1  : {shearwater.hidden_c_gyro_1_bias_x_pow_1}")
    print(f"hidden_c_gyro_1_bias_x_pow_2  : {shearwater.hidden_c_gyro_1_bias_x_pow_2}")
    print(f"hidden_c_gyro_1_bias_x_pow_3  : {shearwater.hidden_c_gyro_1_bias_x_pow_3}")
    print(f"hidden_c_gyro_1_bias_y_pow_0  : {shearwater.hidden_c_gyro_1_bias_y_pow_0}")
    print(f"hidden_c_gyro_1_bias_y_pow_1  : {shearwater.hidden_c_gyro_1_bias_y_pow_1}")
    print(f"hidden_c_gyro_1_bias_y_pow_2  : {shearwater.hidden_c_gyro_1_bias_y_pow_2}")
    print(f"hidden_c_gyro_1_bias_y_pow_3  : {shearwater.hidden_c_gyro_1_bias_y_pow_3}")
    print(f"hidden_c_gyro_1_bias_z_pow_0  : {shearwater.hidden_c_gyro_1_bias_z_pow_0}")
    print(f"hidden_c_gyro_1_bias_z_pow_1  : {shearwater.hidden_c_gyro_1_bias_z_pow_1}")
    print(f"hidden_c_gyro_1_bias_z_pow_2  : {shearwater.hidden_c_gyro_1_bias_z_pow_2}")
    print(f"hidden_c_gyro_1_bias_z_pow_3  : {shearwater.hidden_c_gyro_1_bias_z_pow_3}")
    print(f"hidden_c_gyro_1_scale_x_pow_0 : {shearwater.hidden_c_gyro_1_scale_x_pow_0}")
    print(f"hidden_c_gyro_1_scale_x_pow_1 : {shearwater.hidden_c_gyro_1_scale_x_pow_1}")
    print(f"hidden_c_gyro_1_scale_x_pow_2 : {shearwater.hidden_c_gyro_1_scale_x_pow_2}")
    print(f"hidden_c_gyro_1_scale_x_pow_3 : {shearwater.hidden_c_gyro_1_scale_x_pow_3}")
    print(f"hidden_c_gyro_1_scale_y_pow_0 : {shearwater.hidden_c_gyro_1_scale_y_pow_0}")
    print(f"hidden_c_gyro_1_scale_y_pow_1 : {shearwater.hidden_c_gyro_1_scale_y_pow_1}")
    print(f"hidden_c_gyro_1_scale_y_pow_2 : {shearwater.hidden_c_gyro_1_scale_y_pow_2}")
    print(f"hidden_c_gyro_1_scale_y_pow_3 : {shearwater.hidden_c_gyro_1_scale_y_pow_3}")
    print(f"hidden_c_gyro_1_scale_z_pow_0 : {shearwater.hidden_c_gyro_1_scale_z_pow_0}")
    print(f"hidden_c_gyro_1_scale_z_pow_1 : {shearwater.hidden_c_gyro_1_scale_z_pow_1}")
    print(f"hidden_c_gyro_1_scale_z_pow_2 : {shearwater.hidden_c_gyro_1_scale_z_pow_2}")
    print(f"hidden_c_gyro_1_scale_z_pow_3 : {shearwater.hidden_c_gyro_1_scale_z_pow_3}")
    print(f"hidden_gyro_1_alignment1_1    : {shearwater.hidden_gyro_1_alignment1_1}")
    print(f"hidden_gyro_1_alignment1_2    : {shearwater.hidden_gyro_1_alignment1_2}")
    print(f"hidden_gyro_1_alignment1_3    : {shearwater.hidden_gyro_1_alignment1_3}")
    print(f"hidden_gyro_1_alignment2_1    : {shearwater.hidden_gyro_1_alignment2_1}")
    print(f"hidden_gyro_1_alignment2_2    : {shearwater.hidden_gyro_1_alignment2_2}")
    print(f"hidden_gyro_1_alignment2_3    : {shearwater.hidden_gyro_1_alignment2_3}")
    print(f"hidden_gyro_1_alignment3_1    : {shearwater.hidden_gyro_1_alignment3_1}")
    print(f"hidden_gyro_1_alignment3_2    : {shearwater.hidden_gyro_1_alignment3_2}")
    print(f"hidden_gyro_1_alignment3_3    : {shearwater.hidden_gyro_1_alignment3_3}")
    print(f"hidden_c_gyro_2_bias_x_pow_0  : {shearwater.hidden_c_gyro_2_bias_x_pow_0}")
    print(f"hidden_c_gyro_2_bias_x_pow_1  : {shearwater.hidden_c_gyro_2_bias_x_pow_1}")
    print(f"hidden_c_gyro_2_bias_x_pow_2  : {shearwater.hidden_c_gyro_2_bias_x_pow_2}")
    print(f"hidden_c_gyro_2_bias_x_pow_3  : {shearwater.hidden_c_gyro_2_bias_x_pow_3}")
    print(f"hidden_c_gyro_2_bias_y_pow_0  : {shearwater.hidden_c_gyro_2_bias_y_pow_0}")
    print(f"hidden_c_gyro_2_bias_y_pow_1  : {shearwater.hidden_c_gyro_2_bias_y_pow_1}")
    print(f"hidden_c_gyro_2_bias_y_pow_2  : {shearwater.hidden_c_gyro_2_bias_y_pow_2}")
    print(f"hidden_c_gyro_2_bias_y_pow_3  : {shearwater.hidden_c_gyro_2_bias_y_pow_3}")
    print(f"hidden_c_gyro_2_bias_z_pow_0  : {shearwater.hidden_c_gyro_2_bias_z_pow_0}")
    print(f"hidden_c_gyro_2_bias_z_pow_1  : {shearwater.hidden_c_gyro_2_bias_z_pow_1}")
    print(f"hidden_c_gyro_2_bias_z_pow_2  : {shearwater.hidden_c_gyro_2_bias_z_pow_2}")
    print(f"hidden_c_gyro_2_bias_z_pow_3  : {shearwater.hidden_c_gyro_2_bias_z_pow_3}")
    print(f"hidden_c_gyro_2_scale_x_pow_0 : {shearwater.hidden_c_gyro_2_scale_x_pow_0}")
    print(f"hidden_c_gyro_2_scale_x_pow_1 : {shearwater.hidden_c_gyro_2_scale_x_pow_1}")
    print(f"hidden_c_gyro_2_scale_x_pow_2 : {shearwater.hidden_c_gyro_2_scale_x_pow_2}")
    print(f"hidden_c_gyro_2_scale_x_pow_3 : {shearwater.hidden_c_gyro_2_scale_x_pow_3}")
    print(f"hidden_c_gyro_2_scale_y_pow_0 : {shearwater.hidden_c_gyro_2_scale_y_pow_0}")
    print(f"hidden_c_gyro_2_scale_y_pow_1 : {shearwater.hidden_c_gyro_2_scale_y_pow_1}")
    print(f"hidden_c_gyro_2_scale_y_pow_2 : {shearwater.hidden_c_gyro_2_scale_y_pow_2}")
    print(f"hidden_c_gyro_2_scale_y_pow_3 : {shearwater.hidden_c_gyro_2_scale_y_pow_3}")
    print(f"hidden_c_gyro_2_scale_z_pow_0 : {shearwater.hidden_c_gyro_2_scale_z_pow_0}")
    print(f"hidden_c_gyro_2_scale_z_pow_1 : {shearwater.hidden_c_gyro_2_scale_z_pow_1}")
    print(f"hidden_c_gyro_2_scale_z_pow_2 : {shearwater.hidden_c_gyro_2_scale_z_pow_2}")
    print(f"hidden_c_gyro_2_scale_z_pow_3 : {shearwater.hidden_c_gyro_2_scale_z_pow_3}")
    print(f"hidden_gyro_2_alignment1_1    : {shearwater.hidden_gyro_2_alignment1_1}")
    print(f"hidden_gyro_2_alignment1_2    : {shearwater.hidden_gyro_2_alignment1_2}")
    print(f"hidden_gyro_2_alignment1_3    : {shearwater.hidden_gyro_2_alignment1_3}")
    print(f"hidden_gyro_2_alignment2_1    : {shearwater.hidden_gyro_2_alignment2_1}")
    print(f"hidden_gyro_2_alignment2_2    : {shearwater.hidden_gyro_2_alignment2_2}")
    print(f"hidden_gyro_2_alignment2_3    : {shearwater.hidden_gyro_2_alignment2_3}")
    print(f"hidden_gyro_2_alignment3_1    : {shearwater.hidden_gyro_2_alignment3_1}")
    print(f"hidden_gyro_2_alignment3_2    : {shearwater.hidden_gyro_2_alignment3_2}")
    print(f"hidden_gyro_2_alignment3_3    : {shearwater.hidden_gyro_2_alignment3_3}")
    print(f"hidden_c_accel_1_bias_x_pow_0 : {shearwater.hidden_c_accel_1_bias_x_pow_0}")
    print(f"hidden_c_accel_1_bias_x_pow_1 : {shearwater.hidden_c_accel_1_bias_x_pow_1}")
    print(f"hidden_c_accel_1_bias_x_pow_2 : {shearwater.hidden_c_accel_1_bias_x_pow_2}")
    print(f"hidden_c_accel_1_bias_x_pow_3 : {shearwater.hidden_c_accel_1_bias_x_pow_3}")
    print(f"hidden_c_accel_1_bias_y_pow_0 : {shearwater.hidden_c_accel_1_bias_y_pow_0}")
    print(f"hidden_c_accel_1_bias_y_pow_1 : {shearwater.hidden_c_accel_1_bias_y_pow_1}")
    print(f"hidden_c_accel_1_bias_y_pow_2 : {shearwater.hidden_c_accel_1_bias_y_pow_2}")
    print(f"hidden_c_accel_1_bias_y_pow_3 : {shearwater.hidden_c_accel_1_bias_y_pow_3}")
    print(f"hidden_c_accel_1_bias_z_pow_0 : {shearwater.hidden_c_accel_1_bias_z_pow_0}")
    print(f"hidden_c_accel_1_bias_z_pow_1 : {shearwater.hidden_c_accel_1_bias_z_pow_1}")
    print(f"hidden_c_accel_1_bias_z_pow_2 : {shearwater.hidden_c_accel_1_bias_z_pow_2}")
    print(f"hidden_c_accel_1_bias_z_pow_3 : {shearwater.hidden_c_accel_1_bias_z_pow_3}")
    print(f"hidden_c_accel_1_scale_x_pow_0: {shearwater.hidden_c_accel_1_scale_x_pow_0}")
    print(f"hidden_c_accel_1_scale_x_pow_1: {shearwater.hidden_c_accel_1_scale_x_pow_1}")
    print(f"hidden_c_accel_1_scale_x_pow_2: {shearwater.hidden_c_accel_1_scale_x_pow_2}")
    print(f"hidden_c_accel_1_scale_x_pow_3: {shearwater.hidden_c_accel_1_scale_x_pow_3}")
    print(f"hidden_c_accel_1_scale_y_pow_0: {shearwater.hidden_c_accel_1_scale_y_pow_0}")
    print(f"hidden_c_accel_1_scale_y_pow_1: {shearwater.hidden_c_accel_1_scale_y_pow_1}")
    print(f"hidden_c_accel_1_scale_y_pow_2: {shearwater.hidden_c_accel_1_scale_y_pow_2}")
    print(f"hidden_c_accel_1_scale_y_pow_3: {shearwater.hidden_c_accel_1_scale_y_pow_3}")
    print(f"hidden_c_accel_1_scale_z_pow_0: {shearwater.hidden_c_accel_1_scale_z_pow_0}")
    print(f"hidden_c_accel_1_scale_z_pow_1: {shearwater.hidden_c_accel_1_scale_z_pow_1}")
    print(f"hidden_c_accel_1_scale_z_pow_2: {shearwater.hidden_c_accel_1_scale_z_pow_2}")
    print(f"hidden_c_accel_1_scale_z_pow_3: {shearwater.hidden_c_accel_1_scale_z_pow_3}")
    print(f"hidden_accel_1_alignment1_1   : {shearwater.hidden_accel_1_alignment1_1}")
    print(f"hidden_accel_1_alignment1_2   : {shearwater.hidden_accel_1_alignment1_2}")
    print(f"hidden_accel_1_alignment1_3   : {shearwater.hidden_accel_1_alignment1_3}")
    print(f"hidden_accel_1_alignment2_1   : {shearwater.hidden_accel_1_alignment2_1}")
    print(f"hidden_accel_1_alignment2_2   : {shearwater.hidden_accel_1_alignment2_2}")
    print(f"hidden_accel_1_alignment2_3   : {shearwater.hidden_accel_1_alignment2_3}")
    print(f"hidden_accel_1_alignment3_1   : {shearwater.hidden_accel_1_alignment3_1}")
    print(f"hidden_accel_1_alignment3_2   : {shearwater.hidden_accel_1_alignment3_2}")
    print(f"hidden_accel_1_alignment3_3   : {shearwater.hidden_accel_1_alignment3_3}")
    print(f"hidden_c_mag_1_bias_x_pow_0   : {shearwater.hidden_c_mag_1_bias_x_pow_0}")
    print(f"hidden_c_mag_1_bias_x_pow_1   : {shearwater.hidden_c_mag_1_bias_x_pow_1}")
    print(f"hidden_c_mag_1_bias_x_pow_2   : {shearwater.hidden_c_mag_1_bias_x_pow_2}")
    print(f"hidden_c_mag_1_bias_x_pow_3   : {shearwater.hidden_c_mag_1_bias_x_pow_3}")
    print(f"hidden_c_mag_1_bias_y_pow_0   : {shearwater.hidden_c_mag_1_bias_y_pow_0}")
    print(f"hidden_c_mag_1_bias_y_pow_1   : {shearwater.hidden_c_mag_1_bias_y_pow_1}")
    print(f"hidden_c_mag_1_bias_y_pow_2   : {shearwater.hidden_c_mag_1_bias_y_pow_2}")
    print(f"hidden_c_mag_1_bias_y_pow_3   : {shearwater.hidden_c_mag_1_bias_y_pow_3}")
    print(f"hidden_c_mag_1_bias_z_pow_0   : {shearwater.hidden_c_mag_1_bias_z_pow_0}")
    print(f"hidden_c_mag_1_bias_z_pow_1   : {shearwater.hidden_c_mag_1_bias_z_pow_1}")
    print(f"hidden_c_mag_1_bias_z_pow_2   : {shearwater.hidden_c_mag_1_bias_z_pow_2}")
    print(f"hidden_c_mag_1_bias_z_pow_3   : {shearwater.hidden_c_mag_1_bias_z_pow_3}")
    print(f"hidden_c_mag_1_scale_x_pow_0  : {shearwater.hidden_c_mag_1_scale_x_pow_0}")
    print(f"hidden_c_mag_1_scale_x_pow_1  : {shearwater.hidden_c_mag_1_scale_x_pow_1}")
    print(f"hidden_c_mag_1_scale_x_pow_2  : {shearwater.hidden_c_mag_1_scale_x_pow_2}")
    print(f"hidden_c_mag_1_scale_x_pow_3  : {shearwater.hidden_c_mag_1_scale_x_pow_3}")
    print(f"hidden_c_mag_1_scale_y_pow_0  : {shearwater.hidden_c_mag_1_scale_y_pow_0}")
    print(f"hidden_c_mag_1_scale_y_pow_1  : {shearwater.hidden_c_mag_1_scale_y_pow_1}")
    print(f"hidden_c_mag_1_scale_y_pow_2  : {shearwater.hidden_c_mag_1_scale_y_pow_2}")
    print(f"hidden_c_mag_1_scale_y_pow_3  : {shearwater.hidden_c_mag_1_scale_y_pow_3}")
    print(f"hidden_c_mag_1_scale_z_pow_0  : {shearwater.hidden_c_mag_1_scale_z_pow_0}")
    print(f"hidden_c_mag_1_scale_z_pow_1  : {shearwater.hidden_c_mag_1_scale_z_pow_1}")
    print(f"hidden_c_mag_1_scale_z_pow_2  : {shearwater.hidden_c_mag_1_scale_z_pow_2}")
    print(f"hidden_c_mag_1_scale_z_pow_3  : {shearwater.hidden_c_mag_1_scale_z_pow_3}")
    print(f"hidden_mag_1_alignment1_1     : {shearwater.hidden_mag_1_alignment1_1}")
    print(f"hidden_mag_1_alignment1_2     : {shearwater.hidden_mag_1_alignment1_2}")
    print(f"hidden_mag_1_alignment1_3     : {shearwater.hidden_mag_1_alignment1_3}")
    print(f"hidden_mag_1_alignment2_1     : {shearwater.hidden_mag_1_alignment2_1}")
    print(f"hidden_mag_1_alignment2_2     : {shearwater.hidden_mag_1_alignment2_2}")
    print(f"hidden_mag_1_alignment2_3     : {shearwater.hidden_mag_1_alignment2_3}")
    print(f"hidden_mag_1_alignment3_1     : {shearwater.hidden_mag_1_alignment3_1}")
    print(f"hidden_mag_1_alignment3_2     : {shearwater.hidden_mag_1_alignment3_2}")
    print(f"hidden_mag_1_alignment3_3     : {shearwater.hidden_mag_1_alignment3_3}")
    print(f"hidden_mag_1_reference_x      : {shearwater.hidden_mag_1_reference_x}")
    print(f"hidden_mag_1_reference_y      : {shearwater.hidden_mag_1_reference_y}")
    print(f"hidden_mag_1_reference_z      : {shearwater.hidden_mag_1_reference_z}")
    print(f"hidden_c_mag_2_bias_x_pow_0   : {shearwater.hidden_c_mag_2_bias_x_pow_0}")
    print(f"hidden_c_mag_2_bias_x_pow_1   : {shearwater.hidden_c_mag_2_bias_x_pow_1}")
    print(f"hidden_c_mag_2_bias_x_pow_2   : {shearwater.hidden_c_mag_2_bias_x_pow_2}")
    print(f"hidden_c_mag_2_bias_x_pow_3   : {shearwater.hidden_c_mag_2_bias_x_pow_3}")
    print(f"hidden_c_mag_2_bias_y_pow_0   : {shearwater.hidden_c_mag_2_bias_y_pow_0}")
    print(f"hidden_c_mag_2_bias_y_pow_1   : {shearwater.hidden_c_mag_2_bias_y_pow_1}")
    print(f"hidden_c_mag_2_bias_y_pow_2   : {shearwater.hidden_c_mag_2_bias_y_pow_2}")
    print(f"hidden_c_mag_2_bias_y_pow_3   : {shearwater.hidden_c_mag_2_bias_y_pow_3}")
    print(f"hidden_c_mag_2_bias_z_pow_0   : {shearwater.hidden_c_mag_2_bias_z_pow_0}")
    print(f"hidden_c_mag_2_bias_z_pow_1   : {shearwater.hidden_c_mag_2_bias_z_pow_1}")
    print(f"hidden_c_mag_2_bias_z_pow_2   : {shearwater.hidden_c_mag_2_bias_z_pow_2}")
    print(f"hidden_c_mag_2_bias_z_pow_3   : {shearwater.hidden_c_mag_2_bias_z_pow_3}")
    print(f"hidden_c_mag_2_scale_x_pow_0  : {shearwater.hidden_c_mag_2_scale_x_pow_0}")
    print(f"hidden_c_mag_2_scale_x_pow_1  : {shearwater.hidden_c_mag_2_scale_x_pow_1}")
    print(f"hidden_c_mag_2_scale_x_pow_2  : {shearwater.hidden_c_mag_2_scale_x_pow_2}")
    print(f"hidden_c_mag_2_scale_x_pow_3  : {shearwater.hidden_c_mag_2_scale_x_pow_3}")
    print(f"hidden_c_mag_2_scale_y_pow_0  : {shearwater.hidden_c_mag_2_scale_y_pow_0}")
    print(f"hidden_c_mag_2_scale_y_pow_1  : {shearwater.hidden_c_mag_2_scale_y_pow_1}")
    print(f"hidden_c_mag_2_scale_y_pow_2  : {shearwater.hidden_c_mag_2_scale_y_pow_2}")
    print(f"hidden_c_mag_2_scale_y_pow_3  : {shearwater.hidden_c_mag_2_scale_y_pow_3}")
    print(f"hidden_c_mag_2_scale_z_pow_0  : {shearwater.hidden_c_mag_2_scale_z_pow_0}")
    print(f"hidden_c_mag_2_scale_z_pow_1  : {shearwater.hidden_c_mag_2_scale_z_pow_1}")
    print(f"hidden_c_mag_2_scale_z_pow_2  : {shearwater.hidden_c_mag_2_scale_z_pow_2}")
    print(f"hidden_c_mag_2_scale_z_pow_3  : {shearwater.hidden_c_mag_2_scale_z_pow_3}")
    print(f"hidden_mag_2_alignment1_1     : {shearwater.hidden_mag_2_alignment1_1}")
    print(f"hidden_mag_2_alignment1_2     : {shearwater.hidden_mag_2_alignment1_2}")
    print(f"hidden_mag_2_alignment1_3     : {shearwater.hidden_mag_2_alignment1_3}")
    print(f"hidden_mag_2_alignment2_1     : {shearwater.hidden_mag_2_alignment2_1}")
    print(f"hidden_mag_2_alignment2_2     : {shearwater.hidden_mag_2_alignment2_2}")
    print(f"hidden_mag_2_alignment2_3     : {shearwater.hidden_mag_2_alignment2_3}")
    print(f"hidden_mag_2_alignment3_1     : {shearwater.hidden_mag_2_alignment3_1}")
    print(f"hidden_mag_2_alignment3_2     : {shearwater.hidden_mag_2_alignment3_2}")
    print(f"hidden_mag_2_alignment3_3     : {shearwater.hidden_mag_2_alignment3_3}")
    print(f"hidden_mag_2_reference_x      : {shearwater.hidden_mag_2_reference_x}")
    print(f"hidden_mag_2_reference_y      : {shearwater.hidden_mag_2_reference_y}")
    print(f"hidden_mag_2_reference_z      : {shearwater.hidden_mag_2_reference_z}")
    print(f"hidden_gyro_1_conversion      : {shearwater.hidden_gyro_1_conversion}")
    print(f"hidden_gyro_2_conversion      : {shearwater.hidden_gyro_2_conversion}")
    print(f"hidden_accel_1_conversion     : {shearwater.hidden_accel_1_conversion}")
    print(f"hidden_mag_1_conversion       : {shearwater.hidden_mag_1_conversion}")
    print(f"hidden_mag_2_conversion       : {shearwater.hidden_mag_2_conversion}")
