"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorizers = exports.IamAuthorizer = exports.NoneAuthorizer = exports.CustomAuthorizer = exports.CustomAuthorizerType = exports.CognitoAuthorizer = exports.Authorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const constants_1 = require("../prepare-spec-event-handler/constants");
/**
 * An authorizer for authorizing API requests
 */
class Authorizer {
    constructor(props) {
        this.authorizerId = props.authorizerId;
        this.authorizationType = props.authorizationType;
        this.authorizationScopes = props.authorizationScopes;
    }
}
exports.Authorizer = Authorizer;
_a = JSII_RTTI_SYMBOL_1;
Authorizer[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Authorizer", version: "0.12.22" };
/**
 * An authorizer that uses Cognito identity or access tokens.
 */
class CognitoAuthorizer extends Authorizer {
    constructor(props) {
        super({
            authorizerId: props.authorizerId,
            authorizationType: aws_apigateway_1.AuthorizationType.COGNITO,
            authorizationScopes: props.authorizationScopes,
        });
        this.userPools = props.userPools;
    }
    /**
     * Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ
     * on a per-operation basis
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     * @param authorizationScopes the scopes to apply
     */
    withScopes(...authorizationScopes) {
        return new CognitoAuthorizer({
            authorizerId: this.authorizerId,
            userPools: this.userPools,
            authorizationScopes,
        });
    }
}
exports.CognitoAuthorizer = CognitoAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
CognitoAuthorizer[_b] = { fqn: "@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer", version: "0.12.22" };
/**
 * The type of custom authorizer
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type
 */
var CustomAuthorizerType;
(function (CustomAuthorizerType) {
    /**
     * A custom authorizer that uses a Lambda function.
     */
    CustomAuthorizerType["TOKEN"] = "token";
    /**
     * An authorizer that uses a Lambda function using incoming request parameters.
     */
    CustomAuthorizerType["REQUEST"] = "request";
})(CustomAuthorizerType = exports.CustomAuthorizerType || (exports.CustomAuthorizerType = {}));
// The default time to cache the custom authorizer result
const DEFAULT_CUSTOM_AUTHORIZER_RESULT_TTL_SECONDS = 300;
/**
 * An authorizer that uses a lambda function to authorize requests
 */
class CustomAuthorizer extends Authorizer {
    constructor(props) {
        super({
            authorizerId: props.authorizerId,
            authorizationType: aws_apigateway_1.AuthorizationType.CUSTOM,
        });
        this.function = props.function;
        this.type = props.type ?? CustomAuthorizerType.TOKEN;
        this.identitySource =
            props.identitySource ?? "method.request.header.Authorization";
        this.authorizerResultTtlInSeconds =
            props.authorizerResultTtlInSeconds ??
                DEFAULT_CUSTOM_AUTHORIZER_RESULT_TTL_SECONDS;
    }
}
exports.CustomAuthorizer = CustomAuthorizer;
_c = JSII_RTTI_SYMBOL_1;
CustomAuthorizer[_c] = { fqn: "@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer", version: "0.12.22" };
/**
 * No authorizer
 */
class NoneAuthorizer extends Authorizer {
    constructor() {
        super({
            authorizerId: constants_1.DefaultAuthorizerIds.NONE,
            authorizationType: aws_apigateway_1.AuthorizationType.NONE,
        });
    }
}
exports.NoneAuthorizer = NoneAuthorizer;
_d = JSII_RTTI_SYMBOL_1;
NoneAuthorizer[_d] = { fqn: "@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer", version: "0.12.22" };
/**
 * An IAM authorizer
 */
class IamAuthorizer extends Authorizer {
    constructor() {
        super({
            authorizerId: constants_1.DefaultAuthorizerIds.IAM,
            authorizationType: aws_apigateway_1.AuthorizationType.IAM,
        });
    }
}
exports.IamAuthorizer = IamAuthorizer;
_e = JSII_RTTI_SYMBOL_1;
IamAuthorizer[_e] = { fqn: "@aws-prototyping-sdk/open-api-gateway.IamAuthorizer", version: "0.12.22" };
/**
 * Class used to construct authorizers for use in the OpenApiGatewayLambdaApi construct
 */
class Authorizers {
    /**
     * An IAM authorizer which uses AWS signature version 4 to authorize requests
     */
    static iam() {
        return new IamAuthorizer();
    }
    /**
     * No authorizer
     */
    static none() {
        return new NoneAuthorizer();
    }
    /**
     * A Cognito User Pools authorizer
     */
    static cognito(props) {
        return new CognitoAuthorizer(props);
    }
    /**
     * A custom authorizer
     */
    static custom(props) {
        return new CustomAuthorizer(props);
    }
}
exports.Authorizers = Authorizers;
_f = JSII_RTTI_SYMBOL_1;
Authorizers[_f] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Authorizers", version: "0.12.22" };
//# sourceMappingURL=data:application/json;base64,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