# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sqlalchemy_file']

package_data = \
{'': ['*']}

install_requires = \
['SQLAlchemy>=1.4,<1.5', 'apache-libcloud>=3.6.0,<3.8']

setup_kwargs = {
    'name': 'sqlalchemy-file',
    'version': '0.3.0',
    'description': 'SQLAlchemy-file is a SQLAlchemy extension for attaching files to SQLAlchemy model and uploading them to various storage.',
    'long_description': '# sqlalchemy-file\n\n\n**SQLAlchemy-file** is a [SQLAlchemy](https://www.sqlalchemy.org/) extension for attaching files to SQLAlchemy model and\nuploading them to various storage such as Local Storage, Amazon S3, Rackspace CloudFiles, Google Storage and others\nusing [Apache Libcloud](https://github.com/apache/libcloud).\n\n<p align="center">\n<a href="https://github.com/jowilf/sqlalchemy-file/actions">\n    <img src="https://github.com/jowilf/sqlalchemy-file/actions/workflows/test.yml/badge.svg" alt="Test suite">\n</a>\n<a href="https://github.com/jowilf/sqlalchemy-file/actions">\n    <img src="https://github.com/jowilf/sqlalchemy-file/actions/workflows/publish.yml/badge.svg" alt="Publish">\n</a>\n<a href="https://codecov.io/gh/jowilf/sqlalchemy-file">\n    <img src="https://codecov.io/gh/jowilf/sqlalchemy-file/branch/main/graph/badge.svg" alt="Codecov">\n</a>\n<a href="https://pypi.org/project/sqlalchemy-file/">\n    <img src="https://badge.fury.io/py/sqlalchemy-file.svg" alt="Package version">\n</a>\n<a href="https://pypi.org/project/sqlalchemy-file/">\n    <img src="https://img.shields.io/pypi/pyversions/sqlalchemy-file?color=2334D058" alt="Supported Python versions">\n</a>\n</p>\n\n\nThe key features are:\n\n* **Multiple Storage :** Use Object Storage API provided by [Apache Libcloud](https://github.com/apache/libcloud) to\n  store files. Therefore, you can store your files on Local Storage, Amazon S3, Google Cloud Storage, MinIO etc, and\n  easily switch between them. For a full list of supported providers\n  visit [supported providers page](https://libcloud.readthedocs.io/en/stable/storage/supported_providers.html) from Apache\n  Libcloud documentation.\n* **Validator :**  Provide an interface for validating each files before saving them.\n* **Size Validator :** Built-in validator for file maximum `size` validation.\n* **Content-Type Validator :** Built-in validator for file ``mimetype`` restrictions.\n* **Image Validator :** Built-in validator for image `mimetype`, `width`, `height` and `ratio` validation.\n* **Processor :** Provide an interface to easily save multiple transformation of the original files.\n* **ThumbnailGenerator :** Built-in processor to auto generate thumbnail\n* **Multiple Files :** You can attach multiple files directly to a Model.\n* **Session awareness :** Whenever an object is deleted or a rollback is performed the files uploaded during the unit of\n  work or attached to the deleted objects are automatically deleted.\n* **Meant for Evolution :** Change the storage provider anytime you want, old data will continue to work\n* **SQLModel Support:** Tested with [SQLModel](https://github.com/tiangolo/sqlmodel)\n\n---\n\n**Documentation**: [https://jowilf.github.io/sqlalchemy-file](https://jowilf.github.io/sqlalchemy-file/)\n\n**Source Code**: [https://github.com/jowilf/sqlalchemy-file](https://github.com/jowilf/sqlalchemy-file)\n\n---\n\n## Requirements\n\nA recent and currently supported version of Python (right\nnow, <a href="https://www.python.org/downloads/" class="external-link" target="_blank">Python supports versions 3.7 and\nabove</a>).\n\nAs **SQLAlchemy-file** is based on **Apache Libcloud** and **SQLAlchemy**, it requires them. They will be automatically\ninstalled when you install SQLAlchemy-file.\n\n## Installation\n\n### PIP\n\n```shell\n$ pip install sqlalchemy-file\n```\n\n### Poetry\n\n```shell\n$ poetry add sqlalchemy-file\n```\n\n## Example\n\nAttaching files to models is as simple as declaring a field on the model itself\n\n```Python\nimport os\n\nfrom libcloud.storage.drivers.local import LocalStorageDriver\nfrom sqlalchemy import Column, Integer, String, create_engine\nfrom sqlalchemy.ext.declarative import declarative_base\nfrom sqlalchemy.orm import Session\nfrom sqlalchemy_file import File, FileField\nfrom sqlalchemy_file.storage import StorageManager\n\nBase = declarative_base()\n\n\n# Define your model\nclass Attachment(Base):\n    __tablename__ = "attachment"\n\n    id = Column(Integer, autoincrement=True, primary_key=True)\n    name = Column(String(50), unique=True)\n    content = Column(FileField)\n\n\n# Configure Storage\nos.makedirs("/tmp/storage/attachment", 0o777, exist_ok=True)\ncontainer = LocalStorageDriver("/tmp/storage").get_container("attachment")\nStorageManager.add_storage("default", container)\n\n# Save your model\nengine = create_engine(\n    "sqlite:///example.db", connect_args={"check_same_thread": False}\n)\nBase.metadata.create_all(engine)\n\nwith Session(engine) as session:\n    session.add(Attachment(name="attachment1", content=open("./example.txt", "rb")))\n    session.add(Attachment(name="attachment2", content=b"Hello world"))\n    session.add(Attachment(name="attachment3", content="Hello world"))\n    file = File(content="Hello World", filename="hello.txt", content_type="text/plain")\n    session.add(Attachment(name="attachment4", content=file))\n    session.commit()\n\n```\n\n## Related projects and inspirations\n\n* [filedepot: ](https://github.com/amol-/depot) When I was looking for a library like this, depot was the\nbest I saw. This project inspired **SQLAlchemy-file** extensively\nand some features are implemented the same.\n* [sqlalchemy-media: ](https://github.com/pylover/sqlalchemy-media) Another attachment extension for SqlAlchemy\nto manage assets which are associated with database models\n',
    'author': 'Jocelin Hounon',
    'author_email': 'hounonj@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://jowilf.github.io/sqlalchemy-file',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
