# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['datamodel_code_generator',
 'datamodel_code_generator.model',
 'datamodel_code_generator.model.pydantic',
 'datamodel_code_generator.parser']

package_data = \
{'': ['*'],
 'datamodel_code_generator.model': ['template/*', 'template/pydantic/*']}

install_requires = \
['PySnooper>=0.4.1,<1.0.0',
 'argcomplete>=1.10,<2.0',
 'black>=19.10b0',
 'genson>=1.2.1,<2.0',
 'inflect>=4.1.0,<6.0',
 'isort>=4.3.21,<6.0',
 'jinja2>=2.10.1,<4.0',
 'openapi-spec-validator>=0.2.8,<0.4',
 'prance>=0.18.2,<1.0',
 'pydantic[email]>=1.5.1,<2.0',
 'regex!=2021.8.27',
 'toml>=0.10.0,<1.0.0']

extras_require = \
{'http': ['httpx']}

entry_points = \
{'console_scripts': ['datamodel-codegen = '
                     'datamodel_code_generator.__main__:main']}

setup_kwargs = {
    'name': 'datamodel-code-generator',
    'version': '0.11.14',
    'description': 'Datamodel Code Generator',
    'long_description': '# datamodel-code-generator\n\nThis code generator creates pydantic model from an openapi file and others.\n\n[![Build Status](https://github.com/koxudaxi/datamodel-code-generator/workflows/Test/badge.svg)](https://github.com/koxudaxi/datamodel-code-generator/actions?query=workflow%3ATest)\n[![PyPI version](https://badge.fury.io/py/datamodel-code-generator.svg)](https://pypi.python.org/pypi/datamodel-code-generator)\n[![Downloads](https://pepy.tech/badge/datamodel-code-generator/month)](https://pepy.tech/project/datamodel-code-generator)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/datamodel-code-generator)](https://pypi.python.org/pypi/datamodel-code-generator)\n[![codecov](https://codecov.io/gh/koxudaxi/datamodel-code-generator/branch/master/graph/badge.svg)](https://codecov.io/gh/koxudaxi/datamodel-code-generator)\n![license](https://img.shields.io/github/license/koxudaxi/datamodel-code-generator.svg)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Total alerts](https://img.shields.io/lgtm/alerts/g/koxudaxi/datamodel-code-generator.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/koxudaxi/datamodel-code-generator/alerts/)\n[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/koxudaxi/datamodel-code-generator.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/koxudaxi/datamodel-code-generator/context:python)\n\n## Help\nSee [documentation](https://koxudaxi.github.io/datamodel-code-generator) for more details.\n\n## Supported source types\n-  OpenAPI 3 (YAML/JSON, [OpenAPI Data Type](https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.2.md#data-types))\n-  JSON Schema ([JSON Schema Core](http://json-schema.org/draft/2019-09/json-schema-validation.html)/[JSON Schema Validation](http://json-schema.org/draft/2019-09/json-schema-validation.html))\n-  JSON/YAML/CSV Data (it will be converted to JSON Schema)\n-  Python dictionary (it will be converted to JSON Schema)\n\n## Implemented list\n### OpenAPI 3 and JsonSchema\n#### DataType\n-  string (include patter/minLength/maxLenght)\n-  number (include maximum/exclusiveMaximum/minimum/exclusiveMinimum/multipleOf/le/ge)\n-  integer (include maximum/exclusiveMaximum/minimum/exclusiveMinimum/multipleOf/le/ge)\n-  boolean\n-  array\n-  object\n\n##### String Format\n-  date\n-  datetime\n-  time\n-  password\n-  email\n-  idn-email\n-  uuid (uuid1/uuid2/uuid3/uuid4/uuid5)\n-  ipv4\n-  ipv6\n-  hostname\n-  decimal\n\n#### Other schema\n-  enum (as enum.Enum or typing.Literal)\n-  allOf (as Multiple inheritance)\n-  anyOf (as typing.Union)\n-  oneOf (as typing.Union)\n-  $ref ([http extra](#http-extra-option) is required when resolving $ref for remote files.)\n-  $id (for [JSONSchema](https://json-schema.org/understanding-json-schema/structuring.html#the-id-property))\n\n## Installation\n\nTo install `datamodel-code-generator`:\n```bash\n$ pip install datamodel-code-generator\n```\n\n### `http` extra option\nIf you want to resolve `$ref` for remote files then you should specify `http` extra option.\n```bash\n$ pip install datamodel-code-generator[http]\n```\n\n## Usage\n\nThe `datamodel-codegen` command:\n```bash\nusage: datamodel-codegen [-h] [--input INPUT] [--url URL]\n                         [--http-headers HTTP_HEADER [HTTP_HEADER ...]]\n                         [--input-file-type {auto,openapi,jsonschema,json,yaml,dict,csv}]\n                         [--openapi-scopes {schemas,paths} [{schemas,paths} ...]]\n                         [--output OUTPUT] [--base-class BASE_CLASS]\n                         [--field-constraints] [--use-annotated]\n                         [--field-extra-keys FIELD_EXTRA_KEYS [FIELD_EXTRA_KEYS ...]]\n                         [--field-include-all-keys] [--snake-case-field]\n                         [--strip-default-none]\n                         [--disable-appending-item-suffix]\n                         [--allow-population-by-field-name]\n                         [--enable-faux-immutability] [--use-default]\n                         [--force-optional] [--strict-nullable]\n                         [--strict-types {str,bytes,int,float,bool} [{str,bytes,int,float,bool} ...]]\n                         [--disable-timestamp] [--use-standard-collections]\n                         [--use-generic-container-types]\n                         [--use-schema-description] [--reuse-model]\n                         [--enum-field-as-literal {all,one}]\n                         [--set-default-enum-member]\n                         [--empty-enum-field-name EMPTY_ENUM_FIELD_NAME]\n                         [--class-name CLASS_NAME] [--use-title-as-name]\n                         [--custom-template-dir CUSTOM_TEMPLATE_DIR]\n                         [--extra-template-data EXTRA_TEMPLATE_DATA]\n                         [--aliases ALIASES]\n                         [--target-python-version {3.6,3.7,3.8,3.9}]\n                         [--wrap-string-literal] [--validation]\n                         [--encoding ENCODING] [--debug] [--version]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --input INPUT         Input file/directory (default: stdin)\n  --url URL             Input file URL. `--input` is ignore when `--url` is\n                        used\n  --http-headers HTTP_HEADER [HTTP_HEADER ...]\n                        Set headers in HTTP requests to the remote host.\n                        (example: "Authorization: Basic dXNlcjpwYXNz")\n  --input-file-type {auto,openapi,jsonschema,json,yaml,dict,csv}\n                        Input file type (default: auto)\n  --openapi-scopes {schemas,paths} [{schemas,paths} ...]\n                        Scopes of OpenAPI model generation (default: schemas)\n  --output OUTPUT       Output file (default: stdout)\n  --base-class BASE_CLASS\n                        Base Class (default: pydantic.BaseModel)\n  --field-constraints   Use field constraints and not con* annotations\n  --use-annotated       Use typing.Annotated for Field(). Also, `--field-\n                        constraints` option will be enabled.\n  --field-extra-keys FIELD_EXTRA_KEYS [FIELD_EXTRA_KEYS ...]\n                        Add extra keys to field parameters\n  --field-include-all-keys\n                        Add all keys to field parameters\n  --snake-case-field    Change camel-case field name to snake-case\n  --strip-default-none  Strip default None on fields\n  --disable-appending-item-suffix\n                        Disable appending `Item` suffix to model name in an\n                        array\n  --allow-population-by-field-name\n                        Allow population by field name\n  --enable-faux-immutability\n                        Enable faux immutability\n  --use-default         Use default value even if a field is required\n  --force-optional      Force optional for required fields\n  --strict-nullable     Treat default field as a non-nullable field (Only\n                        OpenAPI)\n  --strict-types {str,bytes,int,float,bool} [{str,bytes,int,float,bool} ...]\n                        Use strict types\n  --disable-timestamp   Disable timestamp on file headers\n  --use-standard-collections\n                        Use standard collections for type hinting (list, dict)\n  --use-generic-container-types\n                        Use generic container types for type hinting\n                        (typing.Sequence, typing.Mapping). If `--use-standard-\n                        collections` option is set, then import from\n                        collections.abc instead of typing\n  --use-schema-description\n                        Use schema description to populate class docstring\n  --reuse-model         Re-use models on the field when a module has the model\n                        with the same content\n  --enum-field-as-literal {all,one}\n                        Parse enum field as literal. all: all enum field type\n                        are Literal. one: field type is Literal when an enum\n                        has only one possible value\n  --set-default-enum-member\n                        Set enum members as default values for enum field\n  --empty-enum-field-name EMPTY_ENUM_FIELD_NAME\n                        Set field name when enum value is empty (default: `_`)\n  --class-name CLASS_NAME\n                        Set class name of root model\n  --use-title-as-name   use titles as class names of models\n  --custom-template-dir CUSTOM_TEMPLATE_DIR\n                        Custom template directory\n  --extra-template-data EXTRA_TEMPLATE_DATA\n                        Extra template data\n  --aliases ALIASES     Alias mapping file\n  --target-python-version {3.6,3.7,3.8,3.9}\n                        target python version (default: 3.7)\n  --wrap-string-literal\n                        Wrap string literal by using black `experimental-\n                        string-processing` option (require black 20.8b0 or\n                        later)\n  --validation          Enable validation (Only OpenAPI)\n  --encoding ENCODING   The encoding of input and output (default: UTF-8)\n  --debug               show debug message\n  --version             show version\n```\n\n## Example\n### OpenAPI\n```sh\n# Generate models from a local file.\n$ datamodel-codegen --input api.yaml --output model.py\n# or directly from a URL.\n$ datamodel-codegen --url https://<INPUT FILE URL> --output model.py\n```\n\n<details>\n<summary>api.yaml</summary>\n\n```yaml\nopenapi: "3.0.0"\ninfo:\n  version: 1.0.0\n  title: Swagger Petstore\n  license:\n    name: MIT\nservers:\n  - url: http://petstore.swagger.io/v1\npaths:\n  /pets:\n    get:\n      summary: List all pets\n      operationId: listPets\n      tags:\n        - pets\n      parameters:\n        - name: limit\n          in: query\n          description: How many items to return at one time (max 100)\n          required: false\n          schema:\n            type: integer\n            format: int32\n      responses:\n        \'200\':\n          description: A paged array of pets\n          headers:\n            x-next:\n              description: A link to the next page of responses\n              schema:\n                type: string\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Pets"\n        default:\n          description: unexpected error\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Error"\n                x-amazon-apigateway-integration:\n                  uri:\n                    Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n                  passthroughBehavior: when_no_templates\n                  httpMethod: POST\n                  type: aws_proxy\n    post:\n      summary: Create a pet\n      operationId: createPets\n      tags:\n        - pets\n      responses:\n        \'201\':\n          description: Null response\n        default:\n          description: unexpected error\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Error"\n                x-amazon-apigateway-integration:\n                  uri:\n                    Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n                  passthroughBehavior: when_no_templates\n                  httpMethod: POST\n                  type: aws_proxy\n  /pets/{petId}:\n    get:\n      summary: Info for a specific pet\n      operationId: showPetById\n      tags:\n        - pets\n      parameters:\n        - name: petId\n          in: path\n          required: true\n          description: The id of the pet to retrieve\n          schema:\n            type: string\n      responses:\n        \'200\':\n          description: Expected response to a valid request\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Pets"\n        default:\n          description: unexpected error\n          content:\n            application/json:\n              schema:\n                $ref: "#/components/schemas/Error"\n    x-amazon-apigateway-integration:\n      uri:\n        Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n      passthroughBehavior: when_no_templates\n      httpMethod: POST\n      type: aws_proxy\ncomponents:\n  schemas:\n    Pet:\n      required:\n        - id\n        - name\n      properties:\n        id:\n          type: integer\n          format: int64\n        name:\n          type: string\n        tag:\n          type: string\n    Pets:\n      type: array\n      items:\n        $ref: "#/components/schemas/Pet"\n    Error:\n      required:\n        - code\n        - message\n      properties:\n        code:\n          type: integer\n          format: int32\n        message:\n          type: string\n    apis:\n      type: array\n      items:\n        type: object\n        properties:\n          apiKey:\n            type: string\n            description: To be used as a dataset parameter value\n          apiVersionNumber:\n            type: string\n            description: To be used as a version parameter value\n          apiUrl:\n            type: string\n            format: uri\n            description: "The URL describing the dataset\'s fields"\n          apiDocumentationUrl:\n            type: string\n            format: uri\n            description: A URL to the API console for each API\n```\n\n</details>\n\n`model.py`:\n```python\n# generated by datamodel-codegen:\n#   filename:  api.yaml\n#   timestamp: 2020-06-02T05:28:24+00:00\n\nfrom __future__ import annotations\n\nfrom typing import List, Optional\n\nfrom pydantic import AnyUrl, BaseModel, Field\n\n\nclass Pet(BaseModel):\n    id: int\n    name: str\n    tag: Optional[str] = None\n\n\nclass Pets(BaseModel):\n    __root__: List[Pet]\n\n\nclass Error(BaseModel):\n    code: int\n    message: str\n\n\nclass Api(BaseModel):\n    apiKey: Optional[str] = Field(\n        None, description=\'To be used as a dataset parameter value\'\n    )\n    apiVersionNumber: Optional[str] = Field(\n        None, description=\'To be used as a version parameter value\'\n    )\n    apiUrl: Optional[AnyUrl] = Field(\n        None, description="The URL describing the dataset\'s fields"\n    )\n    apiDocumentationUrl: Optional[AnyUrl] = Field(\n        None, description=\'A URL to the API console for each API\'\n    )\n\n\nclass Apis(BaseModel):\n    __root__: List[Api]\n```\n\n## Related projects\n### fastapi-code-generator\nThis code generator creates [FastAPI](https://github.com/tiangolo/fastapi) app from an openapi file.\n\n[https://github.com/koxudaxi/fastapi-code-generator](https://github.com/koxudaxi/fastapi-code-generator)\n\n### pydantic-pycharm-plugin\n[A JetBrains PyCharm plugin](https://plugins.jetbrains.com/plugin/12861-pydantic) for [`pydantic`](https://github.com/samuelcolvin/pydantic).\n\n[https://github.com/koxudaxi/pydantic-pycharm-plugin](https://github.com/koxudaxi/pydantic-pycharm-plugin)\n\n## PyPi\n\n[https://pypi.org/project/datamodel-code-generator](https://pypi.org/project/datamodel-code-generator)\n\n## License\n\ndatamodel-code-generator is released under the MIT License. http://www.opensource.org/licenses/mit-license\n',
    'author': 'Koudai Aono',
    'author_email': 'koxudaxi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/koxudaxi/datamodel-code-generator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
