"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineCheckParameterAction = void 0;
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const check_parameter_function_1 = require("./check-parameter-function");
/**
 * Represents a reference to a CodePipelineCheckParameterAction.
 */
class CodePipelineCheckParameterAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.INVOKE,
            provider: 'Lambda',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
    }
    bound(scope, _stage, options) {
        const { parameterName, regExp, logParameter = false, crossAccountRole } = this.props;
        const checkParameterFunction = new check_parameter_function_1.CheckParameterFunction(scope, 'CheckParamterFunction', {
            parameterName,
            crossAccountRole,
        });
        // allow pipeline to list functions
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:ListFunctions'],
            resources: ['*'],
        }));
        // allow pipeline to invoke this lambda functionn
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:InvokeFunction'],
            resources: [checkParameterFunction.functionArn],
        }));
        // allow lambda to put job results for this pipeline
        // CodePipeline requires this to be granted to '*'
        // (the Pipeline ARN will not be enough)
        checkParameterFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['codepipeline:PutJobSuccessResult', 'codepipeline:PutJobFailureResult'],
        }));
        return {
            configuration: {
                FunctionName: checkParameterFunction.functionName,
                UserParameters: core_1.Stack.of(scope).toJsonString({
                    parameterName,
                    regExp: regExp ? regExp.source : undefined,
                    logParameter,
                    crossAccountRole,
                }),
            },
        };
    }
}
exports.CodePipelineCheckParameterAction = CodePipelineCheckParameterAction;
//# sourceMappingURL=data:application/json;base64,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