import pytest
from mercury_engine_data_structures.formats.bmsas import BMSAS
from test.test_lib import parse_build_compare_editor

all_bmsas = [
    "actors/characters/armadigger/charclasses/armadigger.bmsas",
    "actors/characters/armadigger/charclasses/timeline.bmsas",
    "actors/characters/autclast/charclasses/autclast.bmsas",
    "actors/characters/autclast/charclasses/autclast_left.bmsas",
    "actors/characters/autclast/charclasses/autclast_right.bmsas",
    "actors/characters/autclast/charclasses/timeline.bmsas",
    "actors/characters/autector/charclasses/autector.bmsas",
    "actors/characters/autector/charclasses/timeline.bmsas",
    "actors/characters/autool/charclasses/autool.bmsas",
    "actors/characters/autool/charclasses/timeline.bmsas",
    "actors/characters/autsharp/charclasses/autsharp.bmsas",
    "actors/characters/autsharp/charclasses/timeline.bmsas",
    "actors/characters/autsniper/charclasses/autsniper.bmsas",
    "actors/characters/autsniper/charclasses/timeline.bmsas",
    "actors/characters/batalloon/charclasses/batalloon.bmsas",
    "actors/characters/bigfist/charclasses/bigfist.bmsas",
    "actors/characters/bigfist/charclasses/timeline.bmsas",
    "actors/characters/bigkranx/charclasses/bigkranx.bmsas",
    "actors/characters/bigkranx/charclasses/timeline.bmsas",
    "actors/characters/caterzilla/charclasses/caterzilla.bmsas",
    "actors/characters/caterzilla/charclasses/timeline.bmsas",
    "actors/characters/centralunitcave/charclasses/centralunitcave.bmsas",
    "actors/characters/centralunitcave/charclasses/timeline.bmsas",
    "actors/characters/chozocommander/charclasses/attack.bmsas",
    "actors/characters/chozocommander/charclasses/chozocommander.bmsas",
    "actors/characters/chozocommander/charclasses/timeline.bmsas",
    "actors/characters/chozocommanderx/charclasses/chozocommanderx.bmsas",
    "actors/characters/chozocommanderx/charclasses/timeline.bmsas",
    "actors/characters/chozorobotsoldier/charclasses/chozorobotsoldier.bmsas",
    "actors/characters/chozorobotsoldier/charclasses/timeline.bmsas",
    "actors/characters/chozowarrior/charclasses/chozowarrior.bmsas",
    "actors/characters/chozowarrior/charclasses/hiddenshield.bmsas",
    "actors/characters/chozowarrior/charclasses/shield.bmsas",
    "actors/characters/chozowarrior/charclasses/timeline.bmsas",
    "actors/characters/chozowarriorx/charclasses/chozowarriorx.bmsas",
    "actors/characters/chozowarriorx/charclasses/chozowarriorx_powerbomb.bmsas",
    "actors/characters/chozowarriorx/charclasses/timeline.bmsas",
    "actors/characters/chozozombiex/charclasses/chozozombiex.bmsas",
    "actors/characters/chozozombiex/charclasses/timeline.bmsas",
    "actors/characters/cooldownxboss/charclasses/cooldownxboss.bmsas",
    "actors/characters/cooldownxboss/charclasses/stage2.bmsas",
    "actors/characters/cooldownxboss/charclasses/timeline.bmsas",
    "actors/characters/core_x/charclasses/core_x.bmsas",
    "actors/characters/core_x/charclasses/timeline.bmsas",
    "actors/characters/cucannon/charclasses/cucannon.bmsas",
    "actors/characters/cucannon/charclasses/timeline.bmsas",
    "actors/characters/daivo/charclasses/daivo.bmsas",
    "actors/characters/daivo/charclasses/timeline.bmsas",
    "actors/characters/depthorn/charclasses/timeline.bmsas",
    "actors/characters/dredhed/charclasses/dredhed.bmsas",
    "actors/characters/dredhed/charclasses/dredhed_low.bmsas",
    "actors/characters/dredhed/charclasses/timeline.bmsas",
    "actors/characters/dropter/charclasses/dropter.bmsas",
    "actors/characters/dropter/charclasses/timeline.bmsas",
    "actors/characters/emmy/charclasses/emmy.bmsas",
    "actors/characters/emmy/charclasses/emmyattack.bmsas",
    "actors/characters/emmy/charclasses/emmytunnel.bmsas",
    "actors/characters/emmy/charclasses/timeline.bmsas",
    "actors/characters/emmyforest/charclasses/emmyforest.bmsas",
    "actors/characters/emmylab/charclasses/emmylab.bmsas",
    "actors/characters/emmyproto/charclasses/emmyproto.bmsas",
    "actors/characters/emmyproto/charclasses/timeline.bmsas",
    "actors/characters/emmyshipyard/charclasses/emmyshipyard.bmsas",
    "actors/characters/emmyshipyard/charclasses/timeline.bmsas",
    "actors/characters/fulmite/charclasses/fulmite.bmsas",
    "actors/characters/gobbler/charclasses/gobbler.bmsas",
    "actors/characters/gobbler/charclasses/timeline.bmsas",
    "actors/characters/goliath/charclasses/attack.bmsas",
    "actors/characters/goliath/charclasses/goliath.bmsas",
    "actors/characters/goliath/charclasses/goliathx.bmsas",
    "actors/characters/goliath/charclasses/timeline.bmsas",
    "actors/characters/gooplot/charclasses/gooplot.bmsas",
    "actors/characters/gooplot/charclasses/timeline.bmsas",
    "actors/characters/gooshocker/charclasses/gooshocker.bmsas",
    "actors/characters/gooshocker/charclasses/timeline.bmsas",
    "actors/characters/groundshocker/charclasses/groundshocker.bmsas",
    "actors/characters/groundshocker/charclasses/left.bmsas",
    "actors/characters/groundshocker/charclasses/right.bmsas",
    "actors/characters/groundshocker/charclasses/timeline.bmsas",
    "actors/characters/hecathon/charclasses/hecathon.bmsas",
    "actors/characters/hecathon/charclasses/timeline.bmsas",
    "actors/characters/hydrogiga/charclasses/halfempty.bmsas",
    "actors/characters/hydrogiga/charclasses/hydrogiga.bmsas",
    "actors/characters/hydrogiga/charclasses/preseta.bmsas",
    "actors/characters/hydrogiga/charclasses/presetb.bmsas",
    "actors/characters/hydrogiga/charclasses/presetc.bmsas",
    "actors/characters/hydrogiga/charclasses/timeline.bmsas",
    "actors/characters/iceflea/charclasses/iceflea.bmsas",
    "actors/characters/iceflea/charclasses/timeline.bmsas",
    "actors/characters/infester/charclasses/infester.bmsas",
    "actors/characters/infester/charclasses/timeline.bmsas",
    "actors/characters/klaida/charclasses/klaida.bmsas",
    "actors/characters/klaida/charclasses/timeline.bmsas",
    "actors/characters/kraid/charclasses/kraid.bmsas",
    "actors/characters/kraid/charclasses/stage2.bmsas",
    "actors/characters/kraid/charclasses/timeline.bmsas",
    "actors/characters/kreep/charclasses/timeline.bmsas",
    "actors/characters/morphball/charclasses/morphball.bmsas",
    "actors/characters/morphball/charclasses/timeline.bmsas",
    "actors/characters/nailong/charclasses/left.bmsas",
    "actors/characters/nailong/charclasses/nailong.bmsas",
    "actors/characters/nailong/charclasses/right.bmsas",
    "actors/characters/nailong/charclasses/timeline.bmsas",
    "actors/characters/nailugger/charclasses/timeline.bmsas",
    "actors/characters/obsydomithon/charclasses/left.bmsas",
    "actors/characters/obsydomithon/charclasses/obsydomithon.bmsas",
    "actors/characters/obsydomithon/charclasses/right.bmsas",
    "actors/characters/obsydomithon/charclasses/timeline.bmsas",
    "actors/characters/omnithon/charclasses/timeline.bmsas",
    "actors/characters/poisonfly/charclasses/poisonfly.bmsas",
    "actors/characters/poisonfly/charclasses/timeline.bmsas",
    "actors/characters/quetzoa/charclasses/quetzoa.bmsas",
    "actors/characters/quetzoa/charclasses/quetzoax.bmsas",
    "actors/characters/quetzoa/charclasses/timeline.bmsas",
    "actors/characters/rinka/charclasses/rinka.bmsas",
    "actors/characters/rinka/charclasses/timeline.bmsas",
    "actors/characters/rockdiver/charclasses/rockdiver.bmsas",
    "actors/characters/rockdiver/charclasses/timeline.bmsas",
    "actors/characters/rodomithonx/charclasses/rodomithonx.bmsas",
    "actors/characters/rodomithonx/charclasses/timeline.bmsas",
    "actors/characters/rodotuk/charclasses/rodotuk.bmsas",
    "actors/characters/rodotuk/charclasses/timeline.bmsas",
    "actors/characters/sabotoru/charclasses/sabotoru.bmsas",
    "actors/characters/sabotoru/charclasses/timeline.bmsas",
    "actors/characters/sakai/charclasses/sakai.bmsas",
    "actors/characters/sakai/charclasses/sakai_low.bmsas",
    "actors/characters/samus/charclasses/samus.bmsas",
    "actors/characters/samus/charclasses/samus_chozowarriorx_powerbomb.bmsas",
    "actors/characters/samus/charclasses/samus_slope.bmsas",
    "actors/characters/samus/charclasses/samus_slope26up.bmsas",
    "actors/characters/samus/charclasses/samus_stealth.bmsas",
    "actors/characters/samus/charclasses/samus_stealthslope.bmsas",
    "actors/characters/samus/charclasses/samus_stealthslope26up.bmsas",
    "actors/characters/samus/charclasses/timeline.bmsas",
    "actors/characters/samuszerolow/charclasses/samuszerolow.bmsas",
    "actors/characters/samuszerolow/charclasses/timeline.bmsas",
    "actors/characters/sclawk/charclasses/sclawk.bmsas",
    "actors/characters/sclawk/charclasses/timeline.bmsas",
    "actors/characters/scorpius/charclasses/scorpius.bmsas",
    "actors/characters/scorpius/charclasses/timeline.bmsas",
    "actors/characters/scourge/charclasses/scourge.bmsas",
    "actors/characters/scourge/charclasses/timeline.bmsas",
    "actors/characters/shakernaut/charclasses/left.bmsas",
    "actors/characters/shakernaut/charclasses/right.bmsas",
    "actors/characters/shakernaut/charclasses/shakernaut.bmsas",
    "actors/characters/shakernaut/charclasses/timeline.bmsas",
    "actors/characters/sharpaw/charclasses/timeline.bmsas",
    "actors/characters/shelmit/charclasses/shelmit.bmsas",
    "actors/characters/shelmit/charclasses/shelmit_left.bmsas",
    "actors/characters/shelmit/charclasses/shelmit_right.bmsas",
    "actors/characters/shelmit/charclasses/timeline.bmsas",
    "actors/characters/slidle/charclasses/slidle.bmsas",
    "actors/characters/slidle/charclasses/timeline.bmsas",
    "actors/characters/slugger/charclasses/slugger.bmsas",
    "actors/characters/slugger/charclasses/timeline.bmsas",
    "actors/characters/specimen_x4a/charclasses/specimen_x4a.bmsas",
    "actors/characters/specimen_x4a/charclasses/timeline.bmsas",
    "actors/characters/spitclawk/charclasses/spitclawk.bmsas",
    "actors/characters/spitclawk/charclasses/timeline.bmsas",
    "actors/characters/spittail/charclasses/timeline.bmsas",
    "actors/characters/sunnap/charclasses/sunnap.bmsas",
    "actors/characters/sunnap/charclasses/timeline.bmsas",
    "actors/characters/supergoliath/charclasses/timeline.bmsas",
    "actors/characters/takumaku/charclasses/left.bmsas",
    "actors/characters/takumaku/charclasses/low.bmsas",
    "actors/characters/takumaku/charclasses/right.bmsas",
    "actors/characters/takumaku/charclasses/takumaku.bmsas",
    "actors/characters/takumaku/charclasses/timeline.bmsas",
    "actors/characters/vulkran/charclasses/timeline.bmsas",
    "actors/characters/vulkran/charclasses/vulkran.bmsas",
    "actors/characters/warlotus/charclasses/timeline.bmsas",
    "actors/characters/warlotus/charclasses/warlotus.bmsas",
    "actors/characters/xparasite/charclasses/timeline.bmsas",
    "actors/characters/xparasite/charclasses/xparasite.bmsas",
    "actors/characters/yampa/charclasses/timeline.bmsas",
    "actors/characters/yampa/charclasses/yampa.bmsas",
    "actors/events/mapev_armor01/charclasses/mapev_armor01.bmsas",
    "actors/events/mapev_armor02/charclasses/mapev_armor02.bmsas",
    "actors/events/mapev_armor03/charclasses/mapev_armor03.bmsas",
    "actors/events/mapev_atriumdebris/charclasses/timeline.bmsas",
    "actors/events/mapev_bigdebrisqua01/charclasses/mapev_bigdebrisqua01.bmsas",
    "actors/events/mapev_bigdebrisqua02/charclasses/mapev_bigdebrisqua02.bmsas",
    "actors/events/mapev_bigfistgrub_a/charclasses/mapev_bigfistgrub_a.bmsas",
    "actors/events/mapev_birdforest01/charclasses/mapev_birdforest01.bmsas",
    "actors/events/mapev_birdforest02/charclasses/mapev_birdforest02.bmsas",
    "actors/events/mapev_birdforest03/charclasses/mapev_birdforest03.bmsas",
    "actors/events/mapev_birdforest04/charclasses/mapev_birdforest04.bmsas",
    "actors/events/mapev_birdforest05/charclasses/mapev_birdforest05.bmsas",
    "actors/events/mapev_birdforest06/charclasses/mapev_birdforest06.bmsas",
    "actors/events/mapev_birdforest07/charclasses/mapev_birdforest07.bmsas",
    "actors/events/mapev_birdforest08/charclasses/mapev_birdforest08.bmsas",
    "actors/events/mapev_birdforest09/charclasses/mapev_birdforest09.bmsas",
    "actors/events/mapev_birdforest10/charclasses/mapev_birdforest10.bmsas",
    "actors/events/mapev_birdforest11/charclasses/mapev_birdforest11.bmsas",
    "actors/events/mapev_bridgeparts/charclasses/mapev_bridgeparts.bmsas",
    "actors/events/mapev_butterflygroup01/charclasses/mapev_butterflygroup01.bmsas",
    "actors/events/mapev_butterflygroup02/charclasses/mapev_butterflygroup02.bmsas",
    "actors/events/mapev_butterflygroup03/charclasses/mapev_butterflygroup03.bmsas",
    "actors/events/mapev_butterflygroup04/charclasses/mapev_butterflygroup04.bmsas",
    "actors/events/mapev_celldoors/charclasses/mapev_celldoors.bmsas",
    "actors/events/mapev_coral01/charclasses/mapev_coral01.bmsas",
    "actors/events/mapev_cwxencounter01a/charclasses/mapev_cwxencounter01a.bmsas",
    "actors/events/mapev_cwxencounter01b/charclasses/mapev_cwxencounter01b.bmsas",
    "actors/events/mapev_cwxencounter02/charclasses/mapev_cwxencounter02.bmsas",
    "actors/events/mapev_cwxencounter02_ship/charclasses/mapev_cwxencounter02_ship.bmsas",
    "actors/events/mapev_cwxencounter03/charclasses/mapev_cwxencounter03.bmsas",
    "actors/events/mapev_deer01/charclasses/mapev_deer01.bmsas",
    "actors/events/mapev_deer02/charclasses/mapev_deer02.bmsas",
    "actors/events/mapev_deer03/charclasses/mapev_deer03.bmsas",
    "actors/events/mapev_deer04/charclasses/mapev_deer04.bmsas",
    "actors/events/mapev_deer05/charclasses/mapev_deer05.bmsas",
    "actors/events/mapev_deer06/charclasses/mapev_deer06.bmsas",
    "actors/events/mapev_deer07/charclasses/mapev_deer07.bmsas",
    "actors/events/mapev_deer08/charclasses/mapev_deer08.bmsas",
    "actors/events/mapev_deer09/charclasses/mapev_deer09.bmsas",
    "actors/events/mapev_deer10/charclasses/mapev_deer10.bmsas",
    "actors/events/mapev_deer11/charclasses/mapev_deer11.bmsas",
    "actors/events/mapev_deer12/charclasses/mapev_deer12.bmsas",
    "actors/events/mapev_deer13/charclasses/mapev_deer13.bmsas",
    "actors/events/mapev_deer14/charclasses/mapev_deer14.bmsas",
    "actors/events/mapev_deer15/charclasses/mapev_deer15.bmsas",
    "actors/events/mapev_disectedcreature01/charclasses/mapev_disectedcreature01.bmsas",
    "actors/events/mapev_disectedcreature02/charclasses/mapev_disectedcreature02.bmsas",
    "actors/events/mapev_disectedcreature03/charclasses/mapev_disectedcreature03.bmsas",
    "actors/events/mapev_fishes01/charclasses/mapev_fishes01.bmsas",
    "actors/events/mapev_fishes02/charclasses/mapev_fishes02.bmsas",
    "actors/events/mapev_fishes03/charclasses/mapev_fishes03.bmsas",
    "actors/events/mapev_fishes04/charclasses/mapev_fishes04.bmsas",
    "actors/events/mapev_gooplot/charclasses/mapev_gooplot.bmsas",
    "actors/events/mapev_gooplot/charclasses/timeline.bmsas",
    "actors/events/mapev_hecathon01/charclasses/mapev_hecathon01.bmsas",
    "actors/events/mapev_hecathon02/charclasses/mapev_hecathon02.bmsas",
    "actors/events/mapev_hecathon03/charclasses/mapev_hecathon03.bmsas",
    "actors/events/mapev_hecathon04/charclasses/mapev_hecathon04.bmsas",
    "actors/events/mapev_hecathon05/charclasses/mapev_hecathon05.bmsas",
    "actors/events/mapev_hecathon06/charclasses/mapev_hecathon06.bmsas",
    "actors/events/mapev_hecathon07/charclasses/mapev_hecathon07.bmsas",
    "actors/events/mapev_hecathon08/charclasses/mapev_hecathon08.bmsas",
    "actors/events/mapev_hecathon09/charclasses/mapev_hecathon09.bmsas",
    "actors/events/mapev_hecathon10/charclasses/mapev_hecathon10.bmsas",
    "actors/events/mapev_insects_forest_001/charclasses/mapev_insects_forest_001.bmsas",
    "actors/events/mapev_insects_forest_002/charclasses/mapev_insects_forest_002.bmsas",
    "actors/events/mapev_insects_magma_001a/charclasses/mapev_insects_magma_001a.bmsas",
    "actors/events/mapev_insects_magma_001b/charclasses/mapev_insects_magma_001b.bmsas",
    "actors/events/mapev_insects_magma_002/charclasses/mapev_insects_magma_002.bmsas",
    "actors/events/mapev_insects_magma_003/charclasses/mapev_insects_magma_003.bmsas",
    "actors/events/mapev_insects_magma_004/charclasses/mapev_insects_magma_004.bmsas",
    "actors/events/mapev_insects_magma_005/charclasses/mapev_insects_magma_005.bmsas",
    "actors/events/mapev_insects_quarantine_001/charclasses/mapev_insects_quarantine_001.bmsas",
    "actors/events/mapev_insects_quarantine_002/charclasses/mapev_insects_quarantine_002.bmsas",
    "actors/events/mapev_lapa_01/charclasses/mapev_lapa_01.bmsas",
    "actors/events/mapev_lapa_02/charclasses/mapev_lapa_02.bmsas",
    "actors/events/mapev_lightinsects/charclasses/mapev_lightinsects.bmsas",
    "actors/events/mapev_lum_ell/charclasses/mapev_lum_ell.bmsas",
    "actors/events/mapev_magma_crab/charclasses/mapev_magma_crab01.bmsas",
    "actors/events/mapev_magma_crab02/charclasses/mapev_magma_crab02.bmsas",
    "actors/events/mapev_omnithon01/charclasses/mapev_omnithon01.bmsas",
    "actors/events/mapev_omnithon02/charclasses/mapev_omnithon02.bmsas",
    "actors/events/mapev_omnithon03/charclasses/mapev_omnithon03.bmsas",
    "actors/events/mapev_omnithon04/charclasses/mapev_omnithon04.bmsas",
    "actors/events/mapev_omnithon05/charclasses/mapev_omnithon05.bmsas",
    "actors/events/mapev_omnithon06/charclasses/mapev_omnithon06.bmsas",
    "actors/events/mapev_omnithon09/charclasses/mapev_omnithon09.bmsas",
    "actors/events/mapev_omnithon10/charclasses/mapev_omnithon10.bmsas",
    "actors/events/mapev_omnithon11/charclasses/mapev_omnithon11.bmsas",
    "actors/events/mapev_omnithon12/charclasses/mapev_omnithon12.bmsas",
    "actors/events/mapev_plant001/charclasses/mapev_plant001.bmsas",
    "actors/events/mapev_plant002_x2/charclasses/mapev_plant002_x2.bmsas",
    "actors/events/mapev_plant002_x4/charclasses/mapev_plant002_x4.bmsas",
    "actors/events/mapev_plant002_x6/charclasses/mapev_plant002_x6.bmsas",
    "actors/events/mapev_plant003_small/charclasses/mapev_plant003_small.bmsas",
    "actors/events/mapev_planteater01/charclasses/mapev_planteater01.bmsas",
    "actors/events/mapev_planteater02/charclasses/mapev_planteater02.bmsas",
    "actors/events/mapev_planteater03/charclasses/mapev_planteater03.bmsas",
    "actors/events/mapev_planteater04/charclasses/mapev_planteater04.bmsas",
    "actors/events/mapev_planteater04_deer/charclasses/mapev_planteater04_deer.bmsas",
    "actors/events/mapev_planteater05/charclasses/mapev_planteater05.bmsas",
    "actors/events/mapev_planteater06/charclasses/mapev_planteater06.bmsas",
    "actors/events/mapev_planteater07/charclasses/mapev_planteater07.bmsas",
    "actors/events/mapev_planteater08/charclasses/mapev_planteater08.bmsas",
    "actors/events/mapev_planteater09/charclasses/mapev_planteater09.bmsas",
    "actors/events/mapev_reptile01/charclasses/mapev_reptile01.bmsas",
    "actors/events/mapev_reptile02/charclasses/mapev_reptile02.bmsas",
    "actors/events/mapev_sanc_superquetzoa001/charclasses/mapev_sanc_superquetzoa001.bmsas",
    "actors/events/mapev_sanc_superquetzoa002/charclasses/mapev_sanc_superquetzoa002.bmsas",
    "actors/events/mapev_sanc_superquetzoa003/charclasses/mapev_sanc_superquetzoa003.bmsas",
    "actors/events/mapev_sanc_superquetzoa004/charclasses/mapev_sanc_superquetzoa004.bmsas",
    "actors/events/mapev_scorpiushunting01/charclasses/mapev_scorpiushunting01.bmsas",
    "actors/events/mapev_scorpiushunting01/charclasses/timeline.bmsas",
    "actors/events/mapev_scorpiushunting02/charclasses/mapev_scorpiushunting02.bmsas",
    "actors/events/mapev_scorpiushunting03/charclasses/mapev_scorpiushunting03.bmsas",
    "actors/events/mapev_scorpiushunting04/charclasses/mapev_scorpiushunting04.bmsas",
    "actors/events/mapev_scorpiustail/charclasses/mapev_scorpiustail.bmsas",
    "actors/events/mapev_sealife/charclasses/mapev_sealife.bmsas",
    "actors/events/mapev_shrimps/charclasses/mapev_shrimps.bmsas",
    "actors/events/mapev_yamplot/charclasses/mapev_yamplot.bmsas",
    "actors/fx/escape_explosion_big/charclasses/timeline.bmsas",
    "actors/fx/escape_explosion_medium/charclasses/timeline.bmsas",
    "actors/fx/escape_explosion_path/charclasses/timeline.bmsas",
    "actors/fx/escape_explosion_small/charclasses/timeline.bmsas",
    "actors/fx/escape_glass/charclasses/escape_glass.bmsas",
    "actors/fx/escape_glass/charclasses/timeline.bmsas",
    "actors/fx/flickeringlight01/charclasses/timeline.bmsas",
    "actors/fx/spraypipe_cave/timeline.bmsas",
    "actors/fx/steamprotoemmy/charclasses/timeline.bmsas",
    "actors/items/item_energyfragment/charclasses/item_energyfragment.bmsas",
    "actors/items/item_energytank/charclasses/item_energytank.bmsas",
    "actors/items/item_missiletank/charclasses/item_missiletank.bmsas",
    "actors/items/item_missiletankplus/charclasses/item_missiletankplus.bmsas",
    "actors/items/item_powerbombtank/charclasses/item_powerbombtank.bmsas",
    "actors/items/itemsphere/charclasses/timeline.bmsas",
    "actors/items/itemsphere_chargebeam/charclasses/itemsphere_chargebeam.bmsas",
    "actors/items/powerup_bomb/charclasses/powerup_bomb.bmsas",
    "actors/items/powerup_chargebeam/charclasses/powerup_chargebeam.bmsas",
    "actors/items/powerup_diffusionbeam/charclasses/powerup_diffusionbeam.bmsas",
    "actors/items/powerup_doublejump/charclasses/powerup_doublejump.bmsas",
    "actors/items/powerup_ghostaura/charclasses/powerup_ghostaura.bmsas",
    "actors/items/powerup_grapplebeam/charclasses/powerup_grapplebeam.bmsas",
    "actors/items/powerup_gravitysuit/charclasses/powerup_gravitysuit.bmsas",
    "actors/items/powerup_plasmabeam/charclasses/powerup_plasmabeam.bmsas",
    "actors/items/powerup_screwattack/charclasses/powerup_screwattack.bmsas",
    "actors/items/powerup_spacejump/charclasses/powerup_spacejump.bmsas",
    "actors/items/powerup_supermissile/charclasses/powerup_supermissile.bmsas",
    "actors/items/powerup_variasuit/charclasses/powerup_variasuit.bmsas",
    "actors/items/powerup_widebeam/charclasses/powerup_widebeam.bmsas",
    "actors/logic/magnetsurfacewithhusk/magnetsurfacewithhusk.bmsas",
    "actors/logic/magnetsurfacewithhusk/timeline.bmsas",
    "actors/logic/magnetsurfacewithhuskright/magnetsurfacewithhuskright.bmsas",
    "actors/logic/magnetsurfacewithhuskright/timeline.bmsas",
    "actors/props/accesspoint/charclasses/accesspoint.bmsas",
    "actors/props/accesspoint/charclasses/timeline.bmsas",
    "actors/props/ammorecharge/charclasses/ammorecharge.bmsas",
    "actors/props/ammorecharge/charclasses/timeline.bmsas",
    "actors/props/block_cut43/charclasses/timeline.bmsas",
    "actors/props/block_hyperbeam/charclasses/timeline.bmsas",
    "actors/props/block_pbcolumn/charclasses/block_pbcolumn.bmsas",
    "actors/props/block_pbcolumn/charclasses/timeline.bmsas",
    "actors/props/block_pbtube_001/charclasses/block_pbtube_001.bmsas",
    "actors/props/block_pbtube_001/charclasses/timeline.bmsas",
    "actors/props/block_pbtube_002/charclasses/block_pbtube_002.bmsas",
    "actors/props/block_pbtube_002/charclasses/timeline.bmsas",
    "actors/props/block_slide_reg_001/charclasses/block_slide_reg_001.bmsas",
    "actors/props/box_grapple_cv_001/charclasses/box_grapple_cv_001.bmsas",
    "actors/props/box_grapple_cv_001/charclasses/timeline.bmsas",
    "actors/props/box_magnet_aq_001/charclasses/box_magnet_aq_001.bmsas",
    "actors/props/box_magnet_aq_001/charclasses/timeline.bmsas",
    "actors/props/box_magnet_fr_001/charclasses/box_magnet_fr_001.bmsas",
    "actors/props/box_magnet_fr_001/charclasses/timeline.bmsas",
    "actors/props/box_magnet_mg_003/charclasses/box_magnet_mg_003.bmsas",
    "actors/props/box_magnet_mg_003/charclasses/timeline.bmsas",
    "actors/props/box_weight_cv_001/charclasses/box_weight_cv_001.bmsas",
    "actors/props/box_wide_cv_001/charclasses/box_wide_cv_001.bmsas",
    "actors/props/box_wide_cv_001/charclasses/timeline.bmsas",
    "actors/props/breakablecave002/charclasses/breakablecave002.bmsas",
    "actors/props/breakablecave002/charclasses/timeline.bmsas",
    "actors/props/breakablecave003/charclasses/breakablecave003.bmsas",
    "actors/props/breakablecave003/charclasses/timeline.bmsas",
    "actors/props/breakablecave006/charclasses/breakablecave006.bmsas",
    "actors/props/breakablecave006/charclasses/timeline.bmsas",
    "actors/props/breakablecave007/charclasses/breakablecave007.bmsas",
    "actors/props/breakablecave007/charclasses/timeline.bmsas",
    "actors/props/breakablecave008/charclasses/breakablecave008.bmsas",
    "actors/props/breakablecave008/charclasses/timeline.bmsas",
    "actors/props/breakablecave009/charclasses/breakablecave009.bmsas",
    "actors/props/breakablecave009/charclasses/timeline.bmsas",
    "actors/props/breakablecave010/charclasses/breakablecave010.bmsas",
    "actors/props/breakablecave010/charclasses/timeline.bmsas",
    "actors/props/breakablecave014/charclasses/breakablecave014.bmsas",
    "actors/props/breakablecave014/charclasses/timeline.bmsas",
    "actors/props/breakablecave016/charclasses/breakablecave016.bmsas",
    "actors/props/breakablecave016/charclasses/timeline.bmsas",
    "actors/props/breakablecave017/charclasses/breakablecave017.bmsas",
    "actors/props/breakablecave017/charclasses/timeline.bmsas",
    "actors/props/breakablecave018/charclasses/breakablecave018.bmsas",
    "actors/props/breakablecave018/charclasses/timeline.bmsas",
    "actors/props/breakablecave020/charclasses/breakablecave020.bmsas",
    "actors/props/breakablecave020/charclasses/timeline.bmsas",
    "actors/props/breakablemag001/charclasses/breakablemag001.bmsas",
    "actors/props/breakablemag001/charclasses/timeline.bmsas",
    "actors/props/breakablemag002/charclasses/breakablemag002.bmsas",
    "actors/props/breakablemag002/charclasses/timeline.bmsas",
    "actors/props/breakablemag003/charclasses/breakablemag003.bmsas",
    "actors/props/breakablemag003/charclasses/timeline.bmsas",
    "actors/props/breakablemag004/charclasses/breakablemag004.bmsas",
    "actors/props/breakablemag004/charclasses/timeline.bmsas",
    "actors/props/breakablemag005/charclasses/breakablemag005.bmsas",
    "actors/props/breakablemag005/charclasses/timeline.bmsas",
    "actors/props/breakablemag007/charclasses/breakablemag007.bmsas",
    "actors/props/breakablemag007/charclasses/timeline.bmsas",
    "actors/props/breakablemag008/charclasses/breakablemag008.bmsas",
    "actors/props/breakablemag008/charclasses/timeline.bmsas",
    "actors/props/breakablemag009/charclasses/breakablemag009.bmsas",
    "actors/props/breakablemag009/charclasses/timeline.bmsas",
    "actors/props/breakablemag010/charclasses/breakablemag010.bmsas",
    "actors/props/breakablemag010/charclasses/timeline.bmsas",
    "actors/props/breakablemag012/charclasses/breakablemag012.bmsas",
    "actors/props/breakablemag012/charclasses/timeline.bmsas",
    "actors/props/breakablemag013/charclasses/breakablemag013.bmsas",
    "actors/props/breakablemag013/charclasses/timeline.bmsas",
    "actors/props/breakablemag014/charclasses/breakablemag014.bmsas",
    "actors/props/breakablemag014/charclasses/timeline.bmsas",
    "actors/props/burnertrapcav01/charclasses/timeline.bmsas",
    "actors/props/capsule_commander/charclasses/capsule_commander.bmsas",
    "actors/props/capsule_commander/charclasses/timeline.bmsas",
    "actors/props/capsuleelevatorskybase/charclasses/capsuleelevatorskybase.bmsas",
    "actors/props/capsuleelevatorskybase/charclasses/timeline.bmsas",
    "actors/props/capsulelaunchershipyard/charclasses/capsulelaunchershipyard.bmsas",
    "actors/props/capsulelaunchershipyard/charclasses/timeline.bmsas",
    "actors/props/centralunit/charclasses/timeline.bmsas",
    "actors/props/centralunitmagmacontroller/charclasses/timeline.bmsas",
    "actors/props/chozoastro/charclasses/chozoastro.bmsas",
    "actors/props/commander_elevator/charclasses/commander_elevator.bmsas",
    "actors/props/db_dif_b1_001/charclasses/db_dif_b1_001.bmsas",
    "actors/props/db_dif_b1_001/charclasses/timeline.bmsas",
    "actors/props/db_dif_b1_002/charclasses/db_dif_b1_002.bmsas",
    "actors/props/db_dif_b1_002/charclasses/timeline.bmsas",
    "actors/props/db_dif_cv_001/charclasses/db_dif_cv_001.bmsas",
    "actors/props/db_dif_cv_001/charclasses/timeline.bmsas",
    "actors/props/db_dif_mg_001/charclasses/db_dif_mg_001.bmsas",
    "actors/props/db_dif_mg_001/charclasses/timeline.bmsas",
    "actors/props/db_dif_mg_002/charclasses/db_dif_mg_002.bmsas",
    "actors/props/db_dif_mg_002/charclasses/timeline.bmsas",
    "actors/props/db_dside_mg_001/charclasses/db_dside_mg_001.bmsas",
    "actors/props/db_dside_mg_001/charclasses/timeline.bmsas",
    "actors/props/db_dside_mg_001b/charclasses/db_dside_mg_001b.bmsas",
    "actors/props/db_dside_mg_001b/charclasses/timeline.bmsas",
    "actors/props/db_dside_mg_002/charclasses/db_dside_mg_002.bmsas",
    "actors/props/db_dside_mg_002/charclasses/timeline.bmsas",
    "actors/props/db_dside_mg_002b/charclasses/db_dside_mg_002b.bmsas",
    "actors/props/db_dside_mg_002b/charclasses/timeline.bmsas",
    "actors/props/db_dside_mg_003/charclasses/db_dside_mg_003.bmsas",
    "actors/props/db_dside_mg_003/charclasses/timeline.bmsas",
    "actors/props/db_dside_mg_003b/charclasses/db_dside_mg_003b.bmsas",
    "actors/props/db_dside_mg_003b/charclasses/timeline.bmsas",
    "actors/props/db_hdoor_b1_001/charclasses/db_hdoor_b1_001.bmsas",
    "actors/props/db_hdoor_b1_001/charclasses/timeline.bmsas",
    "actors/props/db_hdoor_mg_001/charclasses/db_hdoor_mg_001.bmsas",
    "actors/props/db_hdoor_mg_001/charclasses/timeline.bmsas",
    "actors/props/db_hdoor_mg_002/charclasses/db_hdoor_mg_002.bmsas",
    "actors/props/db_hdoor_mg_002/charclasses/timeline.bmsas",
    "actors/props/db_hdoor_mg_002b/charclasses/db_hdoor_mg_002b.bmsas",
    "actors/props/db_hdoor_mg_002b/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_001/charclasses/db_reg_aq_001.bmsas",
    "actors/props/db_reg_aq_001/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_002/charclasses/db_reg_aq_002.bmsas",
    "actors/props/db_reg_aq_002/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_003/charclasses/db_reg_aq_003.bmsas",
    "actors/props/db_reg_aq_003/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_004/charclasses/db_reg_aq_004.bmsas",
    "actors/props/db_reg_aq_004/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_005/charclasses/db_reg_aq_005.bmsas",
    "actors/props/db_reg_aq_005/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_007/charclasses/db_reg_aq_007.bmsas",
    "actors/props/db_reg_aq_007/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_008/charclasses/db_reg_aq_008.bmsas",
    "actors/props/db_reg_aq_008/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_009/charclasses/db_reg_aq_009.bmsas",
    "actors/props/db_reg_aq_009/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_010/charclasses/db_reg_aq_010.bmsas",
    "actors/props/db_reg_aq_010/charclasses/timeline.bmsas",
    "actors/props/db_reg_aq_011/charclasses/db_reg_aq_011.bmsas",
    "actors/props/db_reg_aq_011/charclasses/timeline.bmsas",
    "actors/props/db_reg_b1_001/charclasses/db_reg_b1_001.bmsas",
    "actors/props/db_reg_b1_001/charclasses/timeline.bmsas",
    "actors/props/db_reg_b1_002/charclasses/db_reg_b1_002.bmsas",
    "actors/props/db_reg_b1_002/charclasses/timeline.bmsas",
    "actors/props/db_reg_b1_003/charclasses/db_reg_b1_003.bmsas",
    "actors/props/db_reg_b1_003/charclasses/timeline.bmsas",
    "actors/props/db_reg_b1_004/charclasses/db_reg_b1_004.bmsas",
    "actors/props/db_reg_b1_004/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_001/charclasses/db_reg_b2_001.bmsas",
    "actors/props/db_reg_b2_001/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_003/charclasses/db_reg_b2_003.bmsas",
    "actors/props/db_reg_b2_003/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_004/charclasses/db_reg_b2_004.bmsas",
    "actors/props/db_reg_b2_004/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_005/charclasses/db_reg_b2_005.bmsas",
    "actors/props/db_reg_b2_005/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_006/charclasses/db_reg_b2_006.bmsas",
    "actors/props/db_reg_b2_006/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_007/charclasses/db_reg_b2_007.bmsas",
    "actors/props/db_reg_b2_007/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_008/charclasses/db_reg_b2_008.bmsas",
    "actors/props/db_reg_b2_008/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_009/charclasses/db_reg_b2_009.bmsas",
    "actors/props/db_reg_b2_009/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_010/charclasses/db_reg_b2_010.bmsas",
    "actors/props/db_reg_b2_010/charclasses/timeline.bmsas",
    "actors/props/db_reg_b2_011/charclasses/db_reg_b2_011.bmsas",
    "actors/props/db_reg_b2_011/charclasses/timeline.bmsas",
    "actors/props/db_reg_cv_020/charclasses/db_reg_cv_020.bmsas",
    "actors/props/db_reg_cv_020/charclasses/timeline.bmsas",
    "actors/props/db_reg_cv_021/charclasses/db_reg_cv_021.bmsas",
    "actors/props/db_reg_cv_021/charclasses/timeline.bmsas",
    "actors/props/db_reg_cv_022/charclasses/db_reg_cv_022.bmsas",
    "actors/props/db_reg_cv_022/charclasses/timeline.bmsas",
    "actors/props/db_reg_mg_016/charclasses/db_reg_mg_016.bmsas",
    "actors/props/db_reg_mg_016/charclasses/timeline.bmsas",
    "actors/props/db_reg_mg_018/charclasses/db_reg_mg_018.bmsas",
    "actors/props/db_reg_mg_018/charclasses/timeline.bmsas",
    "actors/props/db_reg_mg_019/charclasses/db_reg_mg_019.bmsas",
    "actors/props/db_reg_mg_019/charclasses/timeline.bmsas",
    "actors/props/db_reg_mg_020/charclasses/db_reg_mg_020.bmsas",
    "actors/props/db_reg_mg_020/charclasses/timeline.bmsas",
    "actors/props/db_reg_qt_001/charclasses/db_reg_qt_001.bmsas",
    "actors/props/db_reg_qt_001/charclasses/timeline.bmsas",
    "actors/props/deviceheat/charclasses/deviceheat.bmsas",
    "actors/props/door/actionset/doorbase.bmsas",
    "actors/props/door/actionset/doorgrapple.bmsas",
    "actors/props/door/actionset/doorpresence.bmsas",
    "actors/props/door_shield_plasma/charclasses/door_shield_plasma.bmsas",
    "actors/props/door_shield_plasma/charclasses/timeline.bmsas",
    "actors/props/doorcentralunit/charclasses/doorcentralunit.bmsas",
    "actors/props/doorcentralunit/charclasses/timeline.bmsas",
    "actors/props/doorchargecharge/charclasses/timeline.bmsas",
    "actors/props/doorchargeclosed/charclasses/timeline.bmsas",
    "actors/props/doorclosedcharge/charclasses/timeline.bmsas",
    "actors/props/doorclosedgrapple/charclasses/timeline.bmsas",
    "actors/props/doorclosedpower/charclasses/timeline.bmsas",
    "actors/props/dooremmy/charclasses/dooremmy.bmsas",
    "actors/props/dooremmy/charclasses/timeline.bmsas",
    "actors/props/doorframe/charclasses/doorframe.bmsas",
    "actors/props/doorgrappleclosed/charclasses/timeline.bmsas",
    "actors/props/doorgrapplegrapple/charclasses/timeline.bmsas",
    "actors/props/doorheat/charclasses/doorheat.bmsas",
    "actors/props/doorlock/charclasses/doorlock.bmsas",
    "actors/props/doorpowerclosed/charclasses/timeline.bmsas",
    "actors/props/doorpowerpower/charclasses/timeline.bmsas",
    "actors/props/doorpresencepresence/charclasses/timeline.bmsas",
    "actors/props/doorshieldmissile/charclasses/doorshieldmissile.bmsas",
    "actors/props/doorshieldmissile/charclasses/timeline.bmsas",
    "actors/props/doorshieldsupermissile/charclasses/doorshieldsupermissile.bmsas",
    "actors/props/doorshieldsupermissile/charclasses/timeline.bmsas",
    "actors/props/doorshutter/charclasses/doorshutter.bmsas",
    "actors/props/doorshutter/charclasses/timeline.bmsas",
    "actors/props/doorwavebeam/charclasses/doorwavebeam.bmsas",
    "actors/props/doorwavebeam/charclasses/timeline.bmsas",
    "actors/props/doorwidebeam/charclasses/timeline.bmsas",
    "actors/props/elevator/charclasses/elevator.bmsas",
    "actors/props/elevator_with_cutscene/charclasses/elevator_with_cutscene.bmsas",
    "actors/props/emergency_light/charclasses/emergency_light.bmsas",
    "actors/props/emergency_light/charclasses/timeline.bmsas",
    "actors/props/emmy_sanc_deactivated/charclasses/emmy_sanc_deactivated.bmsas",
    "actors/props/emmyvalve_reg_gen_001/charclasses/emmyvalve_reg_gen_001.bmsas",
    "actors/props/energyrecharge/charclasses/energyrecharge.bmsas",
    "actors/props/energyrecharge/charclasses/timeline.bmsas",
    "actors/props/ev_aquadrain_left/charclasses/ev_aquadrain_left.bmsas",
    "actors/props/ev_aquadrain_right/charclasses/ev_aquadrain_right.bmsas",
    "actors/props/ev_chainreaction_cv_001/charclasses/ev_chainreaction_cv_001.bmsas",
    "actors/props/ev_chainreaction_cv_001/charclasses/timeline.bmsas",
    "actors/props/ev_chainreaction_cv_001_a/charclasses/ev_chainreaction_cv_001_a.bmsas",
    "actors/props/ev_chainreaction_cv_001_a/charclasses/timeline.bmsas",
    "actors/props/ev_chainreaction_cv_001_b/charclasses/ev_chainreaction_cv_001_b.bmsas",
    "actors/props/ev_chainreaction_cv_001_b/charclasses/timeline.bmsas",
    "actors/props/ev_chainreaction_cv_002/charclasses/ev_chainreaction_cv_002.bmsas",
    "actors/props/ev_chainreaction_cv_003/charclasses/ev_chainreaction_cv_003.bmsas",
    "actors/props/ev_chainreaction_cv_004/charclasses/ev_chainreaction_cv_004.bmsas",
    "actors/props/ev_chainreaction_cv_004/charclasses/timeline.bmsas",
    "actors/props/ev_chainreaction_cv_004_a/charclasses/ev_chainreaction_cv_004_a.bmsas",
    "actors/props/ev_chainreaction_cv_004_a/charclasses/timeline.bmsas",
    "actors/props/ev_chainreaction_cv_005/charclasses/ev_chainreaction_cv_005.bmsas",
    "actors/props/ev_chainreaction_cv_006/charclasses/ev_chainreaction_cv_006.bmsas",
    "actors/props/ev_chainreaction_cv_007/charclasses/ev_chainreaction_cv_007.bmsas",
    "actors/props/ev_chainreaction_cv_009/charclasses/ev_chainreaction_cv_009.bmsas",
    "actors/props/ev_chainreaction_cv_010/charclasses/ev_chainreaction_cv_010.bmsas",
    "actors/props/ev_chainreaction_cv_010_b/charclasses/ev_chainreaction_cv_010_b.bmsas",
    "actors/props/ev_chainreaction_cv_011/charclasses/ev_chainreaction_cv_011.bmsas",
    "actors/props/ev_chainreaction_cv_fx_001/charclasses/timeline.bmsas",
    "actors/props/ev_chainreaction_cv_fx_002/charclasses/timeline.bmsas",
    "actors/props/ev_chainreaction_cv_fx_003/charclasses/timeline.bmsas",
    "actors/props/ev_chainreaction_cv_fx_004/charclasses/timeline.bmsas",
    "actors/props/ev_commanderx_rock01/charclasses/ev_commanderx_rock01.bmsas",
    "actors/props/ev_demolition_block/charclasses/ev_demolition_block.bmsas",
    "actors/props/ev_demolition_block/charclasses/timeline.bmsas",
    "actors/props/ev_demolition_db_001/charclasses/ev_demolition_db_001.bmsas",
    "actors/props/ev_demolition_db_001/charclasses/timeline.bmsas",
    "actors/props/ev_demolition_db_002/charclasses/ev_demolition_db_002.bmsas",
    "actors/props/ev_demolition_db_002/charclasses/timeline.bmsas",
    "actors/props/ev_demolition_db_003/charclasses/ev_demolition_db_003.bmsas",
    "actors/props/ev_demolition_db_003/charclasses/timeline.bmsas",
    "actors/props/ev_demolition_grapple/charclasses/timeline.bmsas",
    "actors/props/ev_dna_centrifuge_001/charclasses/ev_dna_centrifuge_001.bmsas",
    "actors/props/ev_dna_centrifuge_002/charclasses/ev_dna_centrifuge_002.bmsas",
    "actors/props/ev_dna_centrifuge_003/charclasses/ev_dna_centrifuge_003.bmsas",
    "actors/props/ev_dna_centrifuge_004/charclasses/ev_dna_centrifuge_004.bmsas",
    "actors/props/ev_dna_centrifuge_005/charclasses/ev_dna_centrifuge_005.bmsas",
    "actors/props/ev_dna_centrifuge_006/charclasses/ev_dna_centrifuge_006.bmsas",
    "actors/props/ev_doorprof/charclasses/ev_doorprof.bmsas",
    "actors/props/ev_dspiston_heat/charclasses/timeline.bmsas",
    "actors/props/ev_dspiston_mg_001/charclasses/ev_dspiston_mg_001.bmsas",
    "actors/props/ev_entercu_cv_001/charclasses/ev_entercu_cv_001.bmsas",
    "actors/props/ev_entercu_cv_001/charclasses/timeline.bmsas",
    "actors/props/ev_evacuation/charclasses/timeline.bmsas",
    "actors/props/ev_gatesealed_aut_001/charclasses/ev_gatesealed_aut_001.bmsas",
    "actors/props/ev_hpiston_mg_001/charclasses/ev_hpiston_mg_001.bmsas",
    "actors/props/ev_kraid_entrance/charclasses/ev_kraid_entrance.bmsas",
    "actors/props/ev_lavapump_mg_001/charclasses/ev_lavapump_mg_001.bmsas",
    "actors/props/ev_ph2drain_activator/charclasses/timeline.bmsas",
    "actors/props/ev_ph2drain_platform/charclasses/ev_ph2drain_platform.bmsas",
    "actors/props/ev_ph2drain_platform/charclasses/timeline.bmsas",
    "actors/props/ev_piston_cv_001/charclasses/ev_piston_cv_001.bmsas",
    "actors/props/ev_shi_ray02/charclasses/timeline.bmsas",
    "actors/props/ev_shi_rayimpact01/charclasses/ev_shi_rayimpact01.bmsas",
    "actors/props/ev_shi_rayimpact01/charclasses/timeline.bmsas",
    "actors/props/ev_shi_ship01/charclasses/ev_shi_ship01.bmsas",
    "actors/props/ev_shi_ship02/charclasses/ev_shi_ship02.bmsas",
    "actors/props/ev_tbdrainboss/charclasses/ev_tbdrainboss.bmsas",
    "actors/props/ev_tbdrainboss/charclasses/timeline.bmsas",
    "actors/props/ev_tentacle_001/charclasses/ev_tentacle_001.bmsas",
    "actors/props/ev_tentacle_002/charclasses/ev_tentacle_002.bmsas",
    "actors/props/ev_tentacle_003/charclasses/ev_tentacle_003.bmsas",
    "actors/props/ev_tentacle_004/charclasses/ev_tentacle_004.bmsas",
    "actors/props/ev_tpiston_heat/charclasses/timeline.bmsas",
    "actors/props/ev_tpiston_mg_001/charclasses/ev_tpiston_mg_001.bmsas",
    "actors/props/ev_watervalve_hydrogiga/charclasses/ev_watervalve_hydrogiga.bmsas",
    "actors/props/ev_watervalve_hydrogiga/charclasses/timeline.bmsas",
    "actors/props/fan_cooldown/charclasses/fan_cooldown.bmsas",
    "actors/props/fan_cooldown/charclasses/timeline.bmsas",
    "actors/props/fan_reg/charclasses/fan_reg.bmsas",
    "actors/props/fedship_hol/charclasses/fedship_hol.bmsas",
    "actors/props/footstepplatform/charclasses/timeline.bmsas",
    "actors/props/fusiblebox/charclasses/timeline.bmsas",
    "actors/props/fx_cold_door/charclasses/timeline.bmsas",
    "actors/props/fx_heat_door/charclasses/timeline.bmsas",
    "actors/props/fx_heat_tunnel/charclasses/timeline.bmsas",
    "actors/props/gatecaveprotoemmy/charclasses/gatecaveprotoemmy.bmsas",
    "actors/props/gobblerweb/timeline.bmsas",
    "actors/props/grapplepulloff1x2/charclasses/timeline.bmsas",
    "actors/props/grappleswingpoint/charclasses/timeline.bmsas",
    "actors/props/ice_cube/charclasses/ice_cube.bmsas",
    "actors/props/ice_cube/charclasses/timeline.bmsas",
    "actors/props/lavazone/charclasses/timeline.bmsas",
    "actors/props/maproom/charclasses/maproom.bmsas",
    "actors/props/maproom/charclasses/timeline.bmsas",
    "actors/props/mblauncher_exit_gen_001/charclasses/mblauncher_exit_gen_001.bmsas",
    "actors/props/mblauncher_exit_kraid/charclasses/mblauncher_exit_kraid.bmsas",
    "actors/props/mblauncher_launcher_gen_001/charclasses/mblauncher_launcher_gen_001.bmsas",
    "actors/props/mblauncher_launcher_gen_001/charclasses/timeline.bmsas",
    "actors/props/mlm_block/charclasses/timeline.bmsas",
    "actors/props/mlm_point/charclasses/timeline.bmsas",
    "actors/props/pf_mushr_fr/charclasses/pf_mushr_fr.bmsas",
    "actors/props/pf_mushr_fr/charclasses/timeline.bmsas",
    "actors/props/pf_mushr_fr_ice_cube/charclasses/pf_mushr_fr_ice_cube.bmsas",
    "actors/props/pf_mushr_fr_ice_cube/charclasses/timeline.bmsas",
    "actors/props/piston_right_kraid/charclasses/piston_right_kraid.bmsas",
    "actors/props/pistonmag01/charclasses/pistonmag01.bmsas",
    "actors/props/pistonmag01/charclasses/timeline.bmsas",
    "actors/props/platformcavewaterb/charclasses/platformcavewaterb.bmsas",
    "actors/props/platformcavewaterb/charclasses/timeline.bmsas",
    "actors/props/platformcavmagnet3left/charclasses/platformcavmagnet3left.bmsas",
    "actors/props/platformcavmagnet3left/charclasses/timeline.bmsas",
    "actors/props/platformcavmagnet4down/charclasses/platformcavmagnet4down.bmsas",
    "actors/props/platformcavmagnet4down/charclasses/timeline.bmsas",
    "actors/props/platformcavmagnet5down/charclasses/platformcavmagnet5down.bmsas",
    "actors/props/platformcavmagnet5down/charclasses/timeline.bmsas",
    "actors/props/platformtrapgrapple5right/charclasses/platformtrapgrapple5right.bmsas",
    "actors/props/portal_trainwagon_left/charclasses/portal_trainwagon_left.bmsas",
    "actors/props/portal_trainwagon_left/charclasses/timeline.bmsas",
    "actors/props/portal_trainwagon_right/charclasses/portal_trainwagon_right.bmsas",
    "actors/props/portal_trainwagon_right/charclasses/timeline.bmsas",
    "actors/props/powergenerator/charclasses/timeline.bmsas",
    "actors/props/powergeneratorengine/charclasses/powergeneratorengine.bmsas",
    "actors/props/powergeneratorengine/charclasses/timeline.bmsas",
    "actors/props/samus_deadsuit/charclasses/samus_deadsuit.bmsas",
    "actors/props/samus_deadsuit/charclasses/timeline.bmsas",
    "actors/props/savestation/charclasses/savestation.bmsas",
    "actors/props/savestation/charclasses/timeline.bmsas",
    "actors/props/shootactivatorhidrogiga/charclasses/timeline.bmsas",
    "actors/props/shootactivatormag01/charclasses/timeline.bmsas",
    "actors/props/skybase/charclasses/skybase.bmsas",
    "actors/props/skybase/charclasses/timeline.bmsas",
    "actors/props/steammag01/charclasses/timeline.bmsas",
    "actors/props/teleporter/charclasses/teleporter.bmsas",
    "actors/props/teleporter/charclasses/timeline.bmsas",
    "actors/props/totalrechargestation/charclasses/timeline.bmsas",
    "actors/props/totalrechargestation/charclasses/totalrechargestation.bmsas",
    "actors/props/trap_rot_cv_001/charclasses/timeline.bmsas",
    "actors/props/trap_rot_cv_002/charclasses/timeline.bmsas",
    "actors/props/trap_thermal_horizontal/charclasses/trap_thermal_horizontal.bmsas",
    "actors/props/tunnelframe/charclasses/tunnelframe.bmsas",
    "actors/props/wagontrain/charclasses/wagontrain.bmsas",
    "actors/props/waterzone/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_access/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_access/charclasses/weightactivatedplatform_access.bmsas",
    "actors/props/weightactivatedplatform_ammo/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_ammo/charclasses/weightactivatedplatform_ammo.bmsas",
    "actors/props/weightactivatedplatform_elevator/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_elevator/charclasses/weightactivatedplatform_elevator.bmsas",
    "actors/props/weightactivatedplatform_elevator_frozen/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_energy/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_energy/charclasses/weightactivatedplatform_energy.bmsas",
    "actors/props/weightactivatedplatform_generator/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_generator/charclasses/weightactivatedplatform_generator.bmsas",
    "actors/props/weightactivatedplatform_map/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_map/charclasses/weightactivatedplatform_map.bmsas",
    "actors/props/weightactivatedplatform_save/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_save/charclasses/weightactivatedplatform_save.bmsas",
    "actors/props/weightactivatedplatform_teleport/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_teleport/charclasses/weightactivatedplatform_teleport.bmsas",
    "actors/props/weightactivatedplatform_thermal/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_thermal/charclasses/weightactivatedplatform_thermal.bmsas",
    "actors/props/weightactivatedplatform_total/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_total/charclasses/weightactivatedplatform_total.bmsas",
    "actors/props/weightactivatedplatform_train/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_train/charclasses/weightactivatedplatform_train.bmsas",
    "actors/props/weightactivatedplatform_valve/charclasses/timeline.bmsas",
    "actors/props/weightactivatedplatform_valve/charclasses/weightactivatedplatform_valve.bmsas",
    "actors/props/wplatform_cm_elevator/charclasses/timeline.bmsas",
    "actors/props/wplatform_cm_elevator/charclasses/weightactivatedplatform_commanderelevator.bmsas",
    "actors/props/zipline_bottom_gen_001/charclasses/timeline.bmsas",
    "actors/props/zipline_bottom_gen_001/charclasses/zipline_bottom_gen_001.bmsas",
    "actors/props/zipline_bottom_hydrogiga/charclasses/timeline.bmsas",
    "actors/props/zipline_bottom_hydrogiga/charclasses/zipline_bottom_hydrogiga.bmsas",
    "actors/props/zipline_left_gen_001/charclasses/timeline.bmsas",
    "actors/props/zipline_left_gen_001/charclasses/zipline_left_gen_001.bmsas",
    "actors/props/zipline_rail_hydrogiga/charclasses/timeline.bmsas",
    "actors/props/zipline_right_gen_001/charclasses/timeline.bmsas",
    "actors/props/zipline_right_gen_001/charclasses/zipline_right_gen_001.bmsas",
    "actors/spawnpoints/spawnpointautool/charclasses/spawnpointautool.bmsas",
    "actors/spawnpoints/spawnpointautool/charclasses/timeline.bmsas",
    "actors/spawnpoints/spawnpointautsharp/charclasses/spawnpointautsharp.bmsas",
    "actors/spawnpoints/spawnpointautsharp/charclasses/timeline.bmsas",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidleout.bmsas",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidleoutwall.bmsas",
    "actors/spawnpoints/spawnpointslidle/charclasses/timeline.bmsas",
    "actors/weapons/bigkranxmagmaball/charclasses/bigkranxmagmaball.bmsas",
    "actors/weapons/bigkranxmagmaball/charclasses/timeline.bmsas",
    "actors/weapons/bomb/charclasses/timeline.bmsas",
    "actors/weapons/chozocommanderenergyshardsfragment/charclasses/timeline.bmsas",
    "actors/weapons/chozocommanderenergyshardssphere/charclasses/timeline.bmsas",
    "actors/weapons/chozocommandersentencesphere/charclasses/timeline.bmsas",
    "actors/weapons/chozorobotsoldierbeam/charclasses/chozorobotsoldierbeam.bmsas",
    "actors/weapons/chozorobotsoldierbeam/charclasses/timeline.bmsas",
    "actors/weapons/chozowarriorxspit/charclasses/chozowarriorxspit.bmsas",
    "actors/weapons/chozowarriorxspit/charclasses/timeline.bmsas",
    "actors/weapons/cooldownxbossfireball/charclasses/timeline.bmsas",
    "actors/weapons/cooldownxbosslavacarpet/charclasses/timeline.bmsas",
    "actors/weapons/cooldownxbosswindtunneldamagetrigger/charclasses/timeline.bmsas",
    "actors/weapons/cucannonbeam/charclasses/cucannonbeam.bmsas",
    "actors/weapons/cucannonbeam/charclasses/timeline.bmsas",
    "actors/weapons/depthornball/charclasses/depthornball.bmsas",
    "actors/weapons/depthornball/charclasses/timeline.bmsas",
    "actors/weapons/emmywave/charclasses/timeline.bmsas",
    "actors/weapons/fulmitebellymine/charclasses/fulmitebellymine.bmsas",
    "actors/weapons/fulmitebellymine/charclasses/timeline.bmsas",
    "actors/weapons/icemissile/charclasses/icemissile.bmsas",
    "actors/weapons/icemissile/charclasses/timeline.bmsas",
    "actors/weapons/infesterball/charclasses/infesterball.bmsas",
    "actors/weapons/infesterball/charclasses/timeline.bmsas",
    "actors/weapons/kraidacidblobs/charclasses/timeline.bmsas",
    "actors/weapons/kraidbouncingcreatures/charclasses/timeline.bmsas",
    "actors/weapons/kraidbouncingcreaturesunb/charclasses/timeline.bmsas",
    "actors/weapons/kraidnail/charclasses/timeline.bmsas",
    "actors/weapons/kraidrottenmeat/charclasses/timeline.bmsas",
    "actors/weapons/kraidshockersplashprojectile/charclasses/timeline.bmsas",
    "actors/weapons/kraidspike/charclasses/kraidspike.bmsas",
    "actors/weapons/kraidspike/charclasses/timeline.bmsas",
    "actors/weapons/kraidspikedown/charclasses/kraidspikedown.bmsas",
    "actors/weapons/kraidspikedown/charclasses/timeline.bmsas",
    "actors/weapons/kraidspikemedium/charclasses/kraidspikemedium.bmsas",
    "actors/weapons/kraidspikemedium/charclasses/timeline.bmsas",
    "actors/weapons/kraidspikeup/charclasses/kraidspikeup.bmsas",
    "actors/weapons/kraidspikeup/charclasses/timeline.bmsas",
    "actors/weapons/linebomb/charclasses/timeline.bmsas",
    "actors/weapons/lockonmissile/charclasses/lockonmissile.bmsas",
    "actors/weapons/lockonmissile/charclasses/timeline.bmsas",
    "actors/weapons/lockonmissilemarker/charclasses/timeline.bmsas",
    "actors/weapons/missile/charclasses/missile.bmsas",
    "actors/weapons/missile/charclasses/timeline.bmsas",
    "actors/weapons/nailongthorn/charclasses/nailongthorn.bmsas",
    "actors/weapons/nailongthorn/charclasses/timeline.bmsas",
    "actors/weapons/nailuggeracidball/charclasses/nailuggeracidball.bmsas",
    "actors/weapons/nailuggeracidball/charclasses/timeline.bmsas",
    "actors/weapons/powerbomb/charclasses/timeline.bmsas",
    "actors/weapons/quetzoaenergywave/charclasses/quetzoaenergywave.bmsas",
    "actors/weapons/quetzoaenergywave/charclasses/timeline.bmsas",
    "actors/weapons/scorpiuspoisonousspit/charclasses/scorpiuspoisonousspit.bmsas",
    "actors/weapons/scorpiuspoisonousspit/charclasses/timeline.bmsas",
    "actors/weapons/sluggeracidball/charclasses/timeline.bmsas",
    "actors/weapons/specialrocket/charclasses/specialrocket.bmsas",
    "actors/weapons/specialrocket/charclasses/timeline.bmsas",
    "actors/weapons/spittailmagmaball/charclasses/spittailmagmaball.bmsas",
    "actors/weapons/spittailmagmaball/charclasses/timeline.bmsas",
    "actors/weapons/supergoliathlinebomb/charclasses/timeline.bmsas",
    "actors/weapons/supermissile/charclasses/supermissile.bmsas",
    "actors/weapons/supermissile/charclasses/timeline.bmsas",
    "actors/weapons/superquetzoaenergywave/charclasses/superquetzoaenergywave.bmsas",
    "actors/weapons/superquetzoaenergywave/charclasses/timeline.bmsas",
    "actors/weapons/superquetzoavoidmissiles/charclasses/superquetzoavoidmissiles.bmsas",
    "actors/weapons/superquetzoavoidmissiles/charclasses/timeline.bmsas",
    "actors/weapons/vulkranmagmaball/charclasses/timeline.bmsas",
    "actors/weapons/vulkranmagmaball/charclasses/vulkranmagmaball.bmsas",
    "cutscenes/0001gameintro_arrivalatrium/0001gameintro_arrivalatrium.bmsas",
    "cutscenes/0001gameintro_fight/0001gameintro_fight.bmsas",
    "cutscenes/0001gameintro_flashbackend/0001gameintro_flashbackend.bmsas",
    "cutscenes/0001gameintro_flashbackinit/0001gameintro_flashbackinit.bmsas",
    "cutscenes/0001gameintro_space/0001gameintro_space.bmsas",
    "cutscenes/0001gameintrolanding/0001gameintrolanding.bmsas",
    "cutscenes/0003firstcomunicationfakeadam/0003firstcomunicationfakeadam.bmsas",
    "cutscenes/0004quarantinedoorsopen/0004quarantinedoorsopen.bmsas",
    "cutscenes/0005meleetutorial/0005meleetutorial.bmsas",
    "cutscenes/0007beginningofcooldown/0007beginningofcooldown.bmsas",
    "cutscenes/0012metroidnizationstrongreactionevent/0012metroidnizationstrongreactionevent.bmsas",
    "cutscenes/0013firstencounterchozozombie/0013firstencounterchozozombie.bmsas",
    "cutscenes/0030variasuiteobtention/0030variasuiteobtention.bmsas",
    "cutscenes/0031gravitysuiteobtention/0031gravitysuiteobtention.bmsas",
    "cutscenes/0032ghostdashobtention/0032ghostdashobtention.bmsas",
    "cutscenes/0033sonarobtention/0033sonarobtention.bmsas",
    "cutscenes/0034protoemmyappears/0034protoemmyappears.bmsas",
    "cutscenes/0035protoemmycantclimb/0035protoemmycantclimb.bmsas",
    "cutscenes/0036enteremmyzone/0036enteremmyzone.bmsas",
    "cutscenes/0037emmycaveappears/0037emmycaveappears.bmsas",
    "cutscenes/0038magmaemmypresentation/0038magmaemmypresentation.bmsas",
    "cutscenes/0039labemmypresentation/0039labemmypresentation.bmsas",
    "cutscenes/0040sancemmypresentation_part1/0040sancemmypresentation_part1.bmsas",
    "cutscenes/0040sancemmypresentation_part2a/0040sancemmypresentation_part2a.bmsas",
    "cutscenes/0040sancemmypresentation_part2b/0040sancemmypresentation_part2b.bmsas",
    "cutscenes/0040sancemmypresentation_part3/0040sancemmypresentation_part3.bmsas",
    "cutscenes/0042professorxpresentation/0042professorxpresentation.bmsas",
    "cutscenes/0043emmymetroidnization/0043emmymetroidnization.bmsas",
    "cutscenes/0048firstcupowerobtention/0048firstcupowerobtention.bmsas",
    "cutscenes/0049centralunitdetectsamus01/0049centralunitdetectsamus01.bmsas",
    "cutscenes/0049centralunitdetectsamus02/0049centralunitdetectsamus02.bmsas",
    "cutscenes/0050firstcupresentation/0050firstcupresentation.bmsas",
    "cutscenes/0051cudeathandpowerobtention/0051cudeathandpowerobtention.bmsas",
    "cutscenes/0053genericcupowerobtention/0053genericcupowerobtention.bmsas",
    "cutscenes/0053genericcupowerobtention_r/0053genericcupowerobtention_r.bmsas",
    "cutscenes/0054scorpiuspresentation/0054scorpiuspresentation.bmsas",
    "cutscenes/0055scorpiusphase2/0055scorpiusphase2.bmsas",
    "cutscenes/0057scorpiusdeath/0057scorpiusdeath.bmsas",
    "cutscenes/0059kraidpresentation/0059kraidpresentation.bmsas",
    "cutscenes/0060kraidphase02/0060kraidphase02.bmsas",
    "cutscenes/0061kraiddeath/0061kraiddeath.bmsas",
    "cutscenes/0061kraiddeath_zipline_mb/0061kraiddeath_zipline_mb.bmsas",
    "cutscenes/0063_hydrogiga-presentation/0063_hydrogiga-presentation.bmsas",
    "cutscenes/0065hydrogigadeath/0065hydrogigadeath.bmsas",
    "cutscenes/0067chozowarriorxpresentation/0067chozowarriorxpresentation.bmsas",
    "cutscenes/0071chozowarriorxelitepresentation/0071chozowarriorxelitepresentation.bmsas",
    "cutscenes/0078cooldownpresentation/0078cooldownpresentation.bmsas",
    "cutscenes/0081cooldowndeath/0081cooldowndeath.bmsas",
    "cutscenes/0081cooldowndeath_grab/0081cooldowndeath_grab.bmsas",
    "cutscenes/0086commanderorbital/0086commanderorbital.bmsas",
    "cutscenes/0101commanderlosehiswings/0101commanderlosehiswings.bmsas",
    "cutscenes/0101commanderlosehiswings_left/0101commanderlosehiswings_left.bmsas",
    "cutscenes/0101commanderlosehiswings_right/0101commanderlosehiswings_right.bmsas",
    "cutscenes/0108fallofskybase/0108fallofskybase.bmsas",
    "cutscenes/0108shipyard/0108shipyard.bmsas",
    "cutscenes/0110commanderxdeath/0110commanderxdeath.bmsas",
    "cutscenes/0112endgame/0112endgame.bmsas",
    "cutscenes/0113quarantinearrival/0113quarantinearrival.bmsas",
    "cutscenes/0155scorpiusphase3/0155scorpiusphase3.bmsas",
    "cutscenes/100commandershowswings/100commandershowswings.bmsas",
]


@pytest.mark.parametrize("bmsas_path", all_bmsas)
def test_bmsas(dread_file_tree, bmsas_path):
    parse_build_compare_editor(BMSAS, dread_file_tree, bmsas_path)