import copy
import json
import os
import sys
import typing
from pathlib import Path

import construct
import numpy
from shapely.geometry import Point
from shapely.geometry.polygon import Polygon

from mercury_engine_data_structures import dread_data
from mercury_engine_data_structures.formats import Bmscc, Brfld, Brsa
from mercury_engine_data_structures.game_check import Game
from mercury_engine_data_structures.file_tree_editor import FileTreeEditor

world_names = {
    'maps/levels/c10_samus/s010_cave/s010_cave.brfld': "Artaria",
    'maps/levels/c10_samus/s020_magma/s020_magma.brfld': "Cataris",
    'maps/levels/c10_samus/s030_baselab/s030_baselab.brfld': "Dairon",
    'maps/levels/c10_samus/s040_aqua/s040_aqua.brfld': "Burenia",
    'maps/levels/c10_samus/s050_forest/s050_forest.brfld': "Ghavoran",
    'maps/levels/c10_samus/s060_quarantine/s060_quarantine.brfld': "Elun",
    'maps/levels/c10_samus/s070_basesanc/s070_basesanc.brfld': "Ferenia",
    'maps/levels/c10_samus/s080_shipyard/s080_shipyard.brfld': "Hanubia",
    'maps/levels/c10_samus/s090_skybase/s090_skybase.brfld': "Itorash",
}
id_to_name = {
    os.path.splitext(path.split("/")[-1])[0]: name
    for path, name in world_names.items()
}
pickup_index = 0
bmscc: typing.Optional[Bmscc] = None
brsa: typing.Optional[Brsa] = None
brfld: typing.Optional[Brfld] = None
brfld_path: str = None
events: dict[str, dict] = {}

_polygon_override = {
    ("s010_cave", "collision_camera_010"): [
        [-1200.0, 2200.0],
        [-5200.0, 2200.0],
        [-5200.0, -5600.0],
        [-4800.0, -5600.0],
        [-3300.0, -6200.0],
        [-1200.0, -6200.0]
    ],
    ("s010_cave", "collision_camera_023"): [
        [24900.0, 5100.0], [17800.0, 5100.0], [17800.0, 3400.0], [24900.0, 3400.0]
    ],
    ("s010_cave", "collision_camera_048"): [
        [800.0, 3900.0],
        [-1200.0, 3900.0],
        [-1200.0, 5200.0],
        [-5200.0, 5200.0],
        [-5200.0, 2100.0],
        [-1000.0, 2100.0],
        [-1000.0, 1500.0],
        [500.0, 1500.0],
        [800.0, 1500.0]
    ],
    ("s040_aqua", "collision_camera_023_B"): [
        [4100.0, -9800.0],
        [2000.0, -9800.0],
        [2000.0, -12150.0],
        [3500.0, -12150.0],
        [3500.0, -12500.0],
        [4100.0, -12500.0],
    ],
    ("s070_basesanc", "collision_camera_003"): [
        [-4400.0, -2100.0],
        [-10500.0, -2100.0],
        [-10500.0, -4900.0],
        [-8400.0, -4900.0],
        [-8400.0, -3800.0],
        [-6400.0, -3800.0],
        [-4400.0, -4100.0],
    ],
}
_camera_skip = {
    ("s010_cave", "collision_camera_900"),
    ("s010_cave", "collision_camera_999"),
    ("s020_magma", "collision_camera_063_Stage_001"),
    ("s020_magma", "collision_camera_063_Stage_002"),
    ("s040_aqua", "collision_camera_001_B"),
    ("s050_forest", "collision_camera_019_B"),
    ("s050_forest", "collision_camera_024_B"),
    ("s050_forest", "collision_camera_025"),
    ("s050_forest", "collision_camera_025_C"),
    ("s080_shipyard", "collision_camera_009_C"),
    ("s080_shipyard", "collision_camera_015_B"),
    ("s080_shipyard", "collision_camera_1000 (H)"),
    ("s090_skybase", "collision_camera_005"),
    ("s090_skybase", "collision_camera_900"),
}
dock_weakness = {
    "frame": "Access Open",
    "closed": "Access Closed",
    "power": "Power Beam Door",
    "charge": "Charge Beam Door",
    "presence": "Sensor Lock Door",
    "grapple": "Grapple Beam Door",
    "phase_shift": "Phase Shift Door",
}
_weakness_table_for_def = {
    'doorframe': (dock_weakness["frame"], dock_weakness["frame"]),
    'doorchargecharge': (dock_weakness["charge"], dock_weakness["charge"]),
    'doorclosedcharge': (dock_weakness["closed"], dock_weakness["charge"]),
    'doorpowerpower': (dock_weakness["power"], dock_weakness["power"]),
    'doorclosedpower': (dock_weakness["closed"], dock_weakness["power"]),
    'doorpowerclosed': (dock_weakness["power"], dock_weakness["closed"]),
    'doorchargeclosed': (dock_weakness["charge"], dock_weakness["closed"]),
    'doorpresencepresence': (dock_weakness["presence"], dock_weakness["presence"]),
    'doorpresenceframe': (dock_weakness["presence"], dock_weakness["frame"]),
    'doorframepresence': (dock_weakness["frame"], dock_weakness["presence"]),
    'doorgrapplegrapple': (dock_weakness["grapple"], dock_weakness["grapple"]),
    'doorclosedgrapple': (dock_weakness["closed"], dock_weakness["grapple"]),
    'doorgrappleclosed': (dock_weakness["grapple"], dock_weakness["closed"]),
    'doorshutter': (dock_weakness["phase_shift"], dock_weakness["phase_shift"]),

    # These doors are going to be event or whatever it is
    'doorheat': (None, None),

    # These are the entirely different kind of door
    'dooremmy': ("EMMI Door", "EMMI Door"),
}
_dock_type_for_weakness = {
    "EMMI Door": "other",
}

_ELEVATOR_USABLE = {
    "CCapsuleUsableComponent",
    "CElevatorUsableComponent",
    "CTeleporterUsableComponent",
    "CTrainUsableComponent",
    "CTrainUsableComponentCutScene",
    "CTrainWithPortalUsableComponent",
}

_rooms_for_actors = {
    's010_cave': {
        'AP_01': ['collision_camera_068 (A)'],
        'AP_02': ['collision_camera_065 (A)'],
        'AccessPointTutoTrigger': ['collision_camera_068 (A)'],
        'CAM_Default': [],
        'CAM_Far': ['collision_camera_023 (A)'],
        'CAM_Far_Chasing': ['collision_camera_023 (A)'],
        'CamTunnel': ['collision_camera_055 (A)'],
        'CamTunnel_R': ['collision_camera_055 (A)'],
        'Cam_PreChain': ['collision_camera_026 (A)'],
        'Door001 (CG-CG)': ['collision_camera_013 (A)', 'collision_camera_014 (A)'],
        'Door002 (CG-CG)': ['collision_camera_000_Init (A)', 'collision_camera_013 (A)'],
        'Door003 (PW-PW)': ['collision_camera_013 (A)', 'collision_camera_062 (A)'],
        'Door003_missileShield': ['collision_camera_013 (A)', 'collision_camera_062 (A)'],
        'Door004 (PW-PW)': ['collision_camera_013 (A)', 'collision_camera_062 (A)'],
        'Door004 (PW-PW)_001': ['collision_camera_062 (A)', 'collision_camera_086 (A)'],
        'Door005 (PW-PW)': ['collision_camera_045 (A)', 'collision_camera_054 (A)'],
        'Door006 (CG-CG)': ['collision_camera_000 (A)', 'collision_camera_001 (A)'],
        'Door007 (CG-CG)': ['collision_camera_001 (A)', 'collision_camera_002 (A)'],
        'Door008 (PW-PW)': ['collision_camera_002 (A)', 'collision_camera_068 (A)'],
        'Door009 (PW-PW)': ['collision_camera_000 (A)', 'collision_camera_068 (A)'],
        'Door010 (CL-PW,OP)': ['collision_camera_003 (A)', 'collision_camera_016 (A)'],
        'Door011 (CG-CG)': ['collision_camera_003 (A)', 'collision_camera_004 (A)'],
        'Door012 (PW-PW, MISSILE)': ['collision_camera_003 (A)', 'collision_camera_063 (A)'],
        'Door014 (CG-CG)': ['collision_camera_005 (A)', 'collision_camera_018 (A)'],
        'Door015 (CG-CG)': ['collision_camera_017 (A)', 'collision_camera_049 (A)'],
        'Door016 (PW-PW)': ['collision_camera_015 (A)', 'collision_camera_017 (A)'],
        'Door017 (CU)_000': ['collision_camera_049 (A)'],
        'Door018 (CG-CL,OP)': ['collision_camera_005 (A)', 'collision_camera_017 (A)'],
        'Door020 (PW-PW)': ['collision_camera_008 (A)', 'collision_camera_009 (A)'],
        'Door021 (PW-PW)': ['collision_camera_058 (A)', 'collision_camera_060 (A)'],
        'Door021 (PW-PW)_000': ['collision_camera_059 (A)', 'collision_camera_060 (A)'],
        'Door022 (PW-PW) ': ['collision_camera_056 (A)', 'collision_camera_058 (A)'],
        'Door022 (PW-PW) _000': ['collision_camera_056 (A)', 'collision_camera_059 (A)'],
        'Door023 (PW-PW)': ['collision_camera_012 (A)', 'collision_camera_056 (A)'],
        'Door024 (PW-PW)': ['collision_camera_011 (A)', 'collision_camera_012 (A)'],
        'Door025 (PW-PW)': ['collision_camera_009 (A)', 'collision_camera_048 (A)'],
        'Door026 (PW-PW)': ['collision_camera_006 (A)', 'collision_camera_008 (A)'],
        'Door028': ['collision_camera_008 (A)', 'collision_camera_009 (A)'],
        'Door029 (CG-CL,OP)': ['collision_camera_021 (A)', 'collision_camera_065 (A)'],
        'Door030 (PW-PW)': ['collision_camera_050 (A)', 'collision_camera_065 (A)'],
        'Door032 (CG-CG)': ['collision_camera_022 (A)', 'collision_camera_023 (A)'],
        'Door033 (PW-PW)': ['collision_camera_066 (A)', 'collision_camera_067 (A)'],
        'Door034 (PW-PW)': ['collision_camera_025 (A)', 'collision_camera_066 (A)'],
        'Door035 (PW-PW)': ['collision_camera_024 (A)', 'collision_camera_025 (A)'],
        'Door036 (PW-PW)': ['collision_camera_023 (A)', 'collision_camera_024 (A)'],
        'Door037 (CG-CG)': ['collision_camera_023_B (A)', 'collision_camera_024 (A)'],
        'Door038 (PW-PW)': ['collision_camera_004 (A)', 'collision_camera_063 (A)'],
        'Door038 (PW-PW)_000': ['collision_camera_004 (A)', 'collision_camera_072 (A)'],
        'Door041 (TH)': ['collision_camera_006 (A)', 'collision_camera_008 (A)'],
        'Door042 (PW-PW) ': ['collision_camera_065 (A)', 'collision_camera_070 (A)'],
        'Door044 (TH)': ['collision_camera_021 (A)', 'collision_camera_022 (A)'],
        'Door045 (TH)': ['collision_camera_022 (A)', 'collision_camera_067 (A)'],
        'Door046 (PW-CL,OP)': ['collision_camera_066 (A)', 'collision_camera_067 (A)'],
        'Door049 (PR-PR)': ['collision_camera_050 (A)', 'collision_camera_073 (A)'],
        'Door050 (TH)': ['collision_camera_006 (A)', 'collision_camera_015 (A)'],
        'Door052': ['collision_camera_072 (A)', 'collision_camera_073 (A)'],
        'Door053': ['collision_camera_026 (A)', 'collision_camera_055 (A)'],
        'Door054': ['collision_camera_011 (A)', 'collision_camera_055 (A)'],
        'Door055': ['collision_camera_026 (A)', 'collision_camera_028 (A)'],
        'Door055 (PW-PW)': ['collision_camera_003 (A)', 'collision_camera_016 (A)'],
        'Door056': ['collision_camera_011 (A)', 'collision_camera_028 (A)'],
        'Door056 (CU)': ['collision_camera_064 (A)', 'collision_camera_074 (A)'],
        'Door057': ['collision_camera_026 (A)', 'collision_camera_029 (A)'],
        'Door057 (TH)': ['collision_camera_065 (A)', 'collision_camera_070 (A)'],
        'Door058': ['collision_camera_029 (A)', 'collision_camera_031 (A)'],
        'Door058 (PW-PW)': ['collision_camera_016 (A)', 'collision_camera_064 (A)'],
        'Door059': ['collision_camera_030 (A)', 'collision_camera_031 (A)'],
        'Door059 (CL-PW)': ['collision_camera_017 (A)', 'collision_camera_049 (A)'],
        'Door059_missileShield': ['collision_camera_030 (A)', 'collision_camera_031 (A)'],
        'Door060': ['collision_camera_024 (A)', 'collision_camera_078 (A)'],
        'Door062': ['collision_camera_077 (A)', 'collision_camera_078 (A)'],
        'Door062 (PW-PW, Special)': ['collision_camera_005 (A)', 'collision_camera_006 (A)'],
        'Door063': ['collision_camera_077 (A)', 'collision_camera_079 (A)'],
        'Door064': ['collision_camera_076 (A)', 'collision_camera_088 (A)'],
        'Door065': ['collision_camera_032 (A)', 'collision_camera_076 (A)'],
        'Door066': ['collision_camera_032 (A)', 'collision_camera_034 (A)'],
        'Door067': ['collision_camera_032 (A)', 'collision_camera_089 (A)'],
        'Door069': ['collision_camera_033 (A)', 'collision_camera_089 (A)'],
        'Door069_missileShield': ['collision_camera_033 (A)', 'collision_camera_089 (A)'],
        'Door070': ['collision_camera_080 (A)', 'collision_camera_081 (A)'],
        'Door070_missileShield': ['collision_camera_080 (A)', 'collision_camera_081 (A)'],
        'Door073': ['collision_camera_081 (A)', 'collision_camera_085 (A)'],
        'Door074': ['collision_camera_085 (A)', 'collision_camera_056 (A)'],
        'Door075': ['collision_camera_081 (A)', 'collision_camera_082 (A)'],
        'Door076': ['collision_camera_082 (A)', 'collision_camera_056 (A)'],
        'Door077': ['collision_camera_082 (A)', 'collision_camera_091 (A)'],
        'Door078': ['collision_camera_086 (A)', 'collision_camera_091 (A)'],
        'DoorEmmy01': ['collision_camera_054 (A)', 'collision_camera_061 (A)'],
        'DoorEmmy02': ['collision_camera_060 (A)', 'collision_camera_075 (A)'],
        'DoorEmmy03': ['collision_camera_011 (A)', 'collision_camera_051 (A)'],
        'DoorEmmy05': ['collision_camera_009 (A)', 'collision_camera_088 (A)'],
        'DoorEmmy06': ['collision_camera_008 (A)', 'collision_camera_070 (A)'],
        'DoorEmmy07': ['collision_camera_008 (A)', 'collision_camera_070 (A)'],
        'DoorEmmy08': ['collision_camera_050 (A)', 'collision_camera_071 (A)'],
        'DoorEmmy10': ['collision_camera_004 (A)', 'collision_camera_005 (A)'],
        'DoorEmmy10_000': ['collision_camera_004 (A)', 'collision_camera_005 (A)'],
        'DoorEmmy11': ['collision_camera_003 (A)', 'collision_camera_018 (A)'],
        'DoorFrame_001': ['collision_camera_048 (A)', 'collision_camera_051 (A)'],
        'DoorFrame_004': ['collision_camera_010 (A)', 'collision_camera_075 (A)'],
        'DoorFrame_005': ['collision_camera_010 (A)', 'collision_camera_075 (A)'],
        'DoorFrame_006': ['collision_camera_010 (A)', 'collision_camera_069 (A)'],
        'DoorFrame_007': ['collision_camera_010 (A)', 'collision_camera_069 (A)'],
        'DoorFrame_009': ['collision_camera_015 (A)', 'collision_camera_017 (A)'],
        'DoorFrame_010': ['collision_camera_015 (A)', 'collision_camera_017 (A)'],
        'DoorFrame_011': ['collision_camera_015 (A)', 'collision_camera_017 (A)'],
        'DoorFrame_012': ['collision_camera_015 (A)', 'collision_camera_069 (A)'],
        'DoorFrame_014': ['collision_camera_006 (A)', 'collision_camera_053 (A)'],
        'DoorFrame_015': ['collision_camera_008 (A)', 'collision_camera_071 (A)'],
        'DoorFrame_016': ['collision_camera_008 (A)', 'collision_camera_071 (A)'],
        'DoorFrame_017': ['collision_camera_010 (A)', 'collision_camera_053 (A)'],
        'DoorPowerPower_001': ['collision_camera_008 (A)', 'collision_camera_071 (A)'],
        'FreeAimTutoTriggerEnter': ['collision_camera_000 (A)'],
        'FreeAimTutoTriggerExit': ['collision_camera_000 (A)'],
        'HiddenBlocksTutoTriggerEnter': ['collision_camera_000 (A)'],
        'HiddenBlocksTutoTriggerExit': ['collision_camera_000 (A)'],
        'IT_VARIA_GEN_001': ['collision_camera_031 (A)'],
        'ItemSphere_ChargeBeam': ['collision_camera_014 (A)'],
        'ItemSphere_GrappleBeam': ['collision_camera_033 (A)'],
        'ItemSphere_ScrewAttack': ['collision_camera_081 (A)'],
        'Item_EnergyTank001': ['collision_camera_001 (A)'],
        'Item_MissileTank001': ['collision_camera_005 (A)'],
        'Item_MissileTank002': ['collision_camera_015 (A)'],
        'Item_MissileTank003': ['collision_camera_056 (A)'],
        'Item_MissileTank003_1': ['collision_camera_003 (A)'],
        'Item_MissileTank004': ['collision_camera_011 (A)'],
        'Item_MissileTank005': ['collision_camera_021 (A)'],
        'Item_MissileTank006': ['collision_camera_067 (A)'],
        'Item_MissileTank007': ['collision_camera_023_B (A)'],
        'Item_MissileTank009': ['collision_camera_016 (A)'],
        'Item_MissileTank010': ['collision_camera_054 (A)'],
        'Item_MissileTank011': ['collision_camera_070 (A)'],
        'Item_MissileTank012': ['collision_camera_078 (A)'],
        'Item_MissileTank014': ['collision_camera_081 (A)'],
        'Item_MissileTank015': ['collision_camera_082 (A)'],
        'Item_MissileTank016': ['collision_camera_013 (A)'],
        'LE_CentraUnitDestroyedProto': ['collision_camera_074 (A)'],
        'LE_Elevator_FromMagma': ['collision_camera_077 (A)'],
        'LE_GateProtoEmmy': ['collision_camera_016 (A)'],
        'LE_MagnetSurface_01': ['collision_camera_005 (A)'],
        'LE_MagnetSurface_03': ['collision_camera_005 (A)'],
        'LE_MagnetSurface_03_000': ['collision_camera_005 (A)'],
        'LE_MagnetSurface_05': ['collision_camera_015 (A)'],
        'LE_MagnetSurface_05_000': ['collision_camera_017 (A)'],
        'LE_MagnetSurface_06': ['collision_camera_069 (A)'],
        'LE_MagnetSurface_07': ['collision_camera_010 (A)'],
        'LE_MagnetSurface_08': ['collision_camera_010 (A)'],
        'LE_MagnetSurface_09': ['collision_camera_010 (A)'],
        'LE_MagnetSurface_09_000': ['collision_camera_048 (A)'],
        'LE_MagnetSurface_10': ['collision_camera_023_B (A)'],
        'LE_MagnetSurface_11': ['collision_camera_005 (A)'],
        'LE_MagnetSurface_12': ['collision_camera_006 (A)'],
        'LE_MagnetSurface_15': ['collision_camera_077 (A)'],
        'LE_MagnetSurface_16': ['collision_camera_077 (A)'],
        'LE_MagnetSurface_17': ['collision_camera_026 (A)'],
        'LE_MagnetSurface_19': ['collision_camera_073 (A)'],
        'LE_MagnetSurface_20': ['collision_camera_078 (A)'],
        'LE_MagnetSurface_21': ['collision_camera_079 (A)'],
        'LE_MagnetSurface_23': ['collision_camera_088 (A)'],
        'LE_MagnetSurface_24': ['collision_camera_032 (A)'],
        'LE_MagnetSurface_25': ['collision_camera_032 (A)'],
        'LE_MagnetSurface_26': ['collision_camera_032 (A)'],
        'LE_MagnetSurface_29': ['collision_camera_005 (A)'],
        'LE_MagnetSurface_30': ['collision_camera_005 (A)'],
        'LE_MagnetSurface_31': ['collision_camera_005 (A)'],
        'LE_MagnetSurface_32': ['collision_camera_022 (A)'],
        'LE_MagnetSurface_34': ['collision_camera_022 (A)'],
        'LE_MagnetSurface_35': ['collision_camera_054 (A)'],
        'LE_Platform_Elevator_FromMagma': ['collision_camera_077 (A)'],
        'LE_Platform_Teleport_FromMagma': ['collision_camera_011 (A)'],
        'LE_Platform_Teleport_FromMagma_frozen': ['collision_camera_011 (A)'],
        'LE_Teleport_FromMagma': ['collision_camera_011 (A)'],
        'LE_WorldGraph': [],
        'LE_zipline_bottom_gen_001_001': ['collision_camera_079 (A)'],
        'LE_zipline_bottom_gen_001_001_frozen': ['collision_camera_079 (A)'],
        'LE_zipline_bottom_gen_001_002': ['collision_camera_078 (A)'],
        'LE_zipline_right_gen_001': ['collision_camera_050 (A)'],
        'LE_zipline_right_gen_001_frozen': ['collision_camera_050 (A)'],
        'LM_AfterCentralUnitCavesDestroyed_000': ['collision_camera_090 (A)'],
        'LM_AfterEmmyProtoClimbSequence_Emmy': ['collision_camera_064 (A)'],
        'LM_AfterEmmyProtoClimbSequence_Samus': ['collision_camera_064 (A)'],
        'LM_EmmyCaveStartGoAwayHack': ['collision_camera_008 (A)'],
        'LM_EmmyDestroySearchLandmark01': ['collision_camera_017 (A)'],
        'LM_EmmyEntrancePoint_000': ['collision_camera_071 (A)'],
        'LM_EmmyEntrancePoint_001': ['collision_camera_009 (A)'],
        'LM_EmmyEntrancePoint_002': ['collision_camera_009 (A)'],
        'LM_EmmyEntrancePoint_003': ['collision_camera_051 (A)'],
        'LM_EmmyEntrancePoint_004': ['collision_camera_051 (A)'],
        'LM_EmmyEntrancePoint_005': ['collision_camera_010 (A)'],
        'LM_EmmyEntrancePoint_006': ['collision_camera_010 (A)'],
        'LM_EmmyEntrancePoint_008': ['collision_camera_061 (A)'],
        'LM_EmmyEntrancePoint_009': ['collision_camera_061 (A)'],
        'LM_EmmyEntrancePoint_010': ['collision_camera_010 (A)'],
        'LM_EmmyEntrancePoint_011': ['collision_camera_006 (A)'],
        'LM_EmmyEntrancePoint_012': ['collision_camera_006 (A)'],
        'LM_EmmyEntrancePoint_013': ['collision_camera_053 (A)'],
        'LM_EmmyGlobalSL_end_000A': ['collision_camera_048 (A)'],
        'LM_EmmyGlobalSL_end_000B': ['collision_camera_048 (A)'],
        'LM_EmmyGlobalSL_end_000C': ['collision_camera_051 (A)'],
        'LM_EmmyGlobalSL_end_003': ['collision_camera_017 (A)'],
        'LM_EmmyGlobalSL_end_003b': ['collision_camera_015 (A)'],
        'LM_EmmyGlobalSL_end_003c': ['collision_camera_017 (A)'],
        'LM_EmmyGlobalSL_start_000': ['collision_camera_048 (A)'],
        'LM_EmmyGlobalSL_start_001': ['collision_camera_048 (A)'],
        'LM_EmmyGlobalSL_start_002': ['collision_camera_051 (A)'],
        'LM_EmmyGlobalSL_start_003a': ['collision_camera_015 (A)'],
        'LM_EmmyGlobalSL_start_003b': ['collision_camera_017 (A)'],
        'LM_EmmyGrabOverride_000': ['collision_camera_071 (A)'],
        'LM_EmmyGrabOverride_001': ['collision_camera_071 (A)'],
        'LM_EmmyTunnelChaseLandmark01': ['collision_camera_015 (A)'],
        'LM_Emmy_WaterPlant': ['collision_camera_075 (A)'],
        'LM_EnterEmmyZoneSecondTime': ['collision_camera_006 (A)'],
        'LM_PROTOEMMY_AFTER_CU': ['collision_camera_016 (A)'],
        'LM_PROTOEMMY_AFTER_CU_001': ['collision_camera_064 (A)'],
        'LM_PROTOEMMY_AFTER_CU_002': ['collision_camera_064 (A)'],
        'LM_SamusPerceptionModifier_Focus': ['collision_camera_071 (A)'],
        'LM_SamusPerceptionPosition': ['collision_camera_015 (A)'],
        'LM_SamusPerceptionPosition_001': ['collision_camera_015 (A)'],
        'LM_SamusPerceptionPosition_002': ['collision_camera_048 (A)'],
        'LM_SamusPerceptionPosition_003': ['collision_camera_061 (A)'],
        'LM_SamusPerceptionPosition_004': ['collision_camera_015 (A)'],
        'LM_TutoFocus_EmmyNoFocusTutorialPoint': ['collision_camera_009 (A)'],
        'LM_TutoFocus_EmmyTPPoint': ['collision_camera_071 (A)'],
        'LS_CentralUnitArea': ['collision_camera_090 (A)'],
        'LS_ChangeCamera_003_B': ['collision_camera_003 (A)'],
        'LS_ChangeCamera_FX_01': ['collision_camera_048 (A)'],
        'LS_EMMYIMPASSABLE_01': ['collision_camera_075 (A)'],
        'LS_EMMYIMPASSABLE_02': ['collision_camera_075 (A)'],
        'LS_EMMYIMPASSABLE_03': ['collision_camera_075 (A)'],
        'LS_EMMYIMPASSABLE_04': ['collision_camera_075 (A)'],
        'LS_EMMYIMPASSABLE_05': ['collision_camera_010 (A)'],
        'LS_EMMYIMPASSABLE_06': ['collision_camera_048 (A)', 'collision_camera_051 (A)'],
        'LS_EMMYIMPASSABLE_07': ['collision_camera_048 (A)'],
        'LS_EMMYIMPASSABLE_09': ['collision_camera_009 (A)'],
        'LS_EMMYIMPASSABLE_10': ['collision_camera_009 (A)'],
        'LS_EMMYIMPASSABLE_11': ['collision_camera_009 (A)'],
        'LS_EMMYIMPASSABLE_12': ['collision_camera_009 (A)'],
        'LS_EMMYIMPASSABLE_13': ['collision_camera_009 (A)'],
        'LS_EMMYIMPASSABLE_14': ['collision_camera_008 (A)'],
        'LS_EMMYIMPASSABLE_16': ['collision_camera_006 (A)'],
        'LS_EMMYIMPASSABLE_17': ['collision_camera_006 (A)'],
        'LS_EMMYIMPASSABLE_18': ['collision_camera_005 (A)'],
        'LS_EMMYIMPASSABLE_19': ['collision_camera_049 (A)'],
        'LS_EMMYIMPASSABLE_20': ['collision_camera_049 (A)'],
        'LS_EMMYIMPASSABLE_22': ['collision_camera_015 (A)'],
        'LS_EMMYIMPASSABLE_23': ['collision_camera_015 (A)'],
        'LS_EMMYIMPASSABLE_24': ['collision_camera_015 (A)'],
        'LS_EMMYIMPASSABLE_25': ['collision_camera_015 (A)'],
        'LS_EMMYIMPASSABLE_26': ['collision_camera_015 (A)'],
        'LS_EMMYIMPASSABLE_27': ['collision_camera_015 (A)'],
        'LS_EMMYIMPASSABLE_28': ['collision_camera_008 (A)'],
        'LS_EMMYIMPASSABLE_29': ['collision_camera_071 (A)'],
        'LS_EMMYIMPASSABLE_30': ['collision_camera_008 (A)'],
        'LS_EMMYIMPASSABLE_32': ['collision_camera_008 (A)'],
        'LS_EMMYIMPASSABLE_33': ['collision_camera_069 (A)'],
        'LS_EMMYIMPASSABLE_34': ['collision_camera_010 (A)'],
        'LS_EMMYIMPASSABLE_35': ['collision_camera_006 (A)'],
        'LS_EMMYIMPASSABLE_36': ['collision_camera_008 (A)'],
        'LS_EMMYIMPASSABLE_37': ['collision_camera_051 (A)'],
        'LS_EMMYIMPASSABLE_38': ['collision_camera_017 (A)'],
        'LS_EMMYIMPASSABLE_39': ['collision_camera_010 (A)'],
        'LS_EMMYIMPASSABLE_40': ['collision_camera_048 (A)'],
        'LS_EMMYIMPASSABLE_41': ['collision_camera_010 (A)'],
        'LS_EMMYIMPASSABLE_42': ['collision_camera_010 (A)'],
        'LS_EMMYIMPASSABLE_43': ['collision_camera_049 (A)'],
        'LS_EMMYIMPASSABLE_44': ['collision_camera_009 (A)'],
        'LS_EMMYIMPASSABLE_45': ['collision_camera_005 (A)', 'collision_camera_018 (A)'],
        'LS_EMMYIMPASSABLE_46': ['collision_camera_071 (A)'],
        'LS_EMMYIMPASSABLE_47': ['collision_camera_005 (A)'],
        'LS_EMMYIMPASSABLE_48': ['collision_camera_048 (A)', 'collision_camera_051 (A)'],
        'LS_EmmyCavePresentationForbiddenEdges': ['collision_camera_006 (A)'],
        'LS_EmmyEndStagger_000': ['collision_camera_008 (A)'],
        'LS_EmmyGlobalGL_emmy_003a': ['collision_camera_015 (A)'],
        'LS_EmmyGlobalSL_000': ['collision_camera_009 (A)'],
        'LS_EmmyGlobalSL_001': ['collision_camera_048 (A)'],
        'LS_EmmyGlobalSL_002': [],
        'LS_EmmyGlobalSL_edges_000': ['collision_camera_048 (A)'],
        'LS_EmmyGlobalSL_emmy_000': ['collision_camera_048 (A)'],
        'LS_EmmyGlobalSL_emmy_003b': ['collision_camera_015 (A)'],
        'LS_EmmyGlobalSL_forbidden_000': ['collision_camera_048 (A)'],
        'LS_EmmyGlobalSL_samus_000': ['collision_camera_048 (A)'],
        'LS_EmmyGrabOverride_000': ['collision_camera_071 (A)'],
        'LS_EmmyGrabOverride_001': ['collision_camera_071 (A)'],
        'LS_EmmyProtoZone': ['collision_camera_064 (A)'],
        'LS_EmmyZone': ['collision_camera_005 (A)'],
        'LS_IMPASSABLE_PROTO01': ['collision_camera_016 (A)'],
        'LS_PATROLEMMYACTIVATOR_01': ['collision_camera_005 (A)'],
        'LS_PATROLEMMYACTIVATOR_02': ['collision_camera_005 (A)'],
        'LS_PATROLEMMYACTIVATOR_03': ['collision_camera_006 (A)'],
        'LS_PATROLEMMYACTIVATOR_04': ['collision_camera_006 (A)'],
        'LS_PATROLEMMYACTIVATOR_05': ['collision_camera_008 (A)'],
        'LS_PATROLEMMYACTIVATOR_06': ['collision_camera_008 (A)'],
        'LS_PATROLEMMYACTIVATOR_07': ['collision_camera_009 (A)'],
        'LS_PATROLEMMYACTIVATOR_08': ['collision_camera_048 (A)'],
        'LS_PATROLEMMYACTIVATOR_09': ['collision_camera_051 (A)'],
        'LS_PATROLEMMYACTIVATOR_10': ['collision_camera_075 (A)'],
        'LS_PATROLEMMYACTIVATOR_11': ['collision_camera_010 (A)'],
        'LS_PATROLEMMYACTIVATOR_12': ['collision_camera_015 (A)'],
        'LS_PATROLEMMYACTIVATOR_13': ['collision_camera_017 (A)'],
        'LS_PATROLEMMYACTIVATOR_14': ['collision_camera_017 (A)'],
        'LS_PATROLEMMYACTIVATOR_15': ['collision_camera_017 (A)'],
        'LS_PATROLEMMY_01': ['collision_camera_005 (A)'],
        'LS_PATROLEMMY_02': ['collision_camera_005 (A)'],
        'LS_PATROLEMMY_03': ['collision_camera_005 (A)'],
        'LS_PATROLEMMY_04': ['collision_camera_006 (A)'],
        'LS_PATROLEMMY_05': ['collision_camera_006 (A)'],
        'LS_PATROLEMMY_06': ['collision_camera_008 (A)'],
        'LS_PATROLEMMY_07': ['collision_camera_070 (A)'],
        'LS_PATROLEMMY_08': ['collision_camera_048 (A)'],
        'LS_PATROLEMMY_09': ['collision_camera_051 (A)'],
        'LS_PATROLEMMY_10': ['collision_camera_075 (A)'],
        'LS_PATROLEMMY_11': [],
        'LS_PATROLEMMY_12': ['collision_camera_010 (A)'],
        'LS_PATROLEMMY_13': ['collision_camera_017 (A)'],
        'LS_PATROLEMMY_14': ['collision_camera_017 (A)'],
        'LS_PATROLEMMY_15': ['collision_camera_017 (A)'],
        'LS_PATROLTUTOFOCUS': ['collision_camera_008 (A)'],
        'LS_RinkaLifeArea_000': ['collision_camera_090 (A)'],
        'LS_ToAvoidCornerReposition_000': ['collision_camera_051 (A)'],
        'LS_ToAvoidCornerReposition_001': ['collision_camera_017 (A)'],
        'MapOptionsTutoTriggerEnter': [],
        'MapOptionsTutoTriggerExit': [],
        'MapRoomTutoTriggerEnter': ['collision_camera_058 (A)'],
        'MapRoomTutoTriggerExit': [],
        'MeleeTutoTriggerEnter': ['collision_camera_003 (A)'],
        'MeleeTutoTriggerEnter_002': ['collision_camera_003 (A)'],
        'MeleeTutoTriggerEnter_003': ['collision_camera_003 (A)'],
        'MeleeTutoTriggerExit': ['collision_camera_003 (A)'],
        'MeleeTutoTriggerExit_002': ['collision_camera_003 (A)'],
        'MeleeTutoTriggerExit_003': ['collision_camera_003 (A)'],
        'MissileTutoObserver': ['collision_camera_000 (A)'],
        'MissileTutoTriggerEnter': ['collision_camera_000 (A)'],
        'MissileTutoTriggerExit': ['collision_camera_000 (A)'],
        'PRP_CV_AccessPoint001': ['collision_camera_068 (A)'],
        'PRP_CV_AccessPoint001_WeightPlate': ['collision_camera_068 (A)'],
        'PRP_CV_AccessPoint002': ['collision_camera_065 (A)'],
        'PRP_CV_AccessPoint002_WeightPlate': ['collision_camera_065 (A)'],
        'PRP_CV_AmmoStation001': ['collision_camera_000 (A)'],
        'PRP_CV_AmmoStation001_WeightPlate': ['collision_camera_000 (A)'],
        'PRP_CV_CentralUnitCaves': ['collision_camera_090 (A)'],
        'PRP_CV_CentralUnitProto': ['collision_camera_074 (A)'],
        'PRP_CV_EnergyStation001': ['collision_camera_054 (A)'],
        'PRP_CV_EnergyStation001_WeightPlate': ['collision_camera_054 (A)'],
        'PRP_CV_EnergyStation002': ['collision_camera_011 (A)'],
        'PRP_CV_EnergyStation002_WeightPlate': ['collision_camera_011 (A)'],
        'PRP_CV_MapStation001': ['collision_camera_058 (A)'],
        'PRP_CV_MapStation001_WeightPlate': ['collision_camera_058 (A)'],
        'PRP_CV_PlatformCaveWaterWeightPlate': ['collision_camera_010 (A)'],
        'PRP_CV_PlatformCaveWater_B': ['collision_camera_010 (A)'],
        'PRP_CV_PlatformMagnet3Left': ['collision_camera_005 (A)'],
        'PRP_CV_PlatformMagnet4Down': ['collision_camera_015 (A)'],
        'PRP_CV_PlatformMagnet5Down': ['collision_camera_006 (A)'],
        'PRP_CV_SaveStation001': ['collision_camera_063 (A)'],
        'PRP_CV_SaveStation001_WeightPlate': ['collision_camera_063 (A)'],
        'PRP_CV_SaveStation002': ['collision_camera_025 (A)'],
        'PRP_CV_SaveStation002_WeightPlate': ['collision_camera_025 (A)'],
        'PRP_CV_SaveStation003': ['collision_camera_012 (A)'],
        'PRP_CV_SaveStation003_WeightPlate': ['collision_camera_012 (A)'],
        'PRP_CV_SaveStation004': ['collision_camera_076 (A)'],
        'PRP_CV_SaveStation004_WeightPlate': ['collision_camera_076 (A)'],
        'PRP_CV_ThermalDevice': ['collision_camera_067 (A)'],
        'PRP_CV_ThermalDevice_WeightPlate': ['collision_camera_067 (A)'],
        'PRP_CV_watercave01a': ['collision_camera_004 (A)'],
        'PRP_CV_watercave01b': ['collision_camera_004 (A)'],
        'PRP_CV_watercave02': [],
        'PRP_CV_watercave05': ['collision_camera_000 (A)'],
        'PRP_CV_watercave07': ['collision_camera_004 (A)'],
        'PRP_CV_watercave08a': ['collision_camera_057 (A)'],
        'PRP_CV_watercave08b': ['collision_camera_060 (A)'],
        'PRP_CV_watercave09': ['collision_camera_011 (A)'],
        'PRP_CV_watercave10': ['collision_camera_054 (A)'],
        'PRP_CV_watercave10_001': ['collision_camera_054 (A)'],
        'PRP_DB_CV_000': ['collision_camera_048 (A)'],
        'PRP_DB_CV_002': ['collision_camera_006 (A)'],
        'PRP_DB_CV_003': ['collision_camera_004 (A)'],
        'PRP_DB_CV_006': ['collision_camera_000 (A)'],
        'PRP_DB_CV_007': ['collision_camera_022 (A)'],
        'PRP_DB_CV_008': ['collision_camera_060 (A)'],
        'PRP_DB_CV_010': ['collision_camera_013 (A)'],
        'PRP_DB_CV_014': ['collision_camera_003 (A)'],
        'PRP_DB_CV_020': ['collision_camera_004 (A)'],
        'PRP_TotalR_000': ['collision_camera_081 (A)'],
        'PRP_TotalR_001': ['collision_camera_070 (A)'],
        'PRP_TotalR_Platform_000': ['collision_camera_081 (A)'],
        'PRP_TotalR_Platform_001': ['collision_camera_070 (A)'],
        'ProtoEmmyTrigger': ['collision_camera_016 (A)'],
        'SG_Cave_Cannons': ['collision_camera_090 (A)'],
        'SPBCentralUnitTutoTrigger': [],
        'SPRTutoTrigger_000': ['collision_camera_074 (A)'],
        'SP_Cave_CUCannon_000': ['collision_camera_090 (A)'],
        'SP_Checkpoint_AccessPoint_002': ['collision_camera_050 (A)'],
        'SP_Checkpoint_AccessPoint_1B': ['collision_camera_000 (A)'],
        'SP_Checkpoint_AccessPoint_2B': ['collision_camera_021 (A)'],
        'SP_Checkpoint_CURoom': ['collision_camera_074 (A)'],
        'SP_Checkpoint_CentralUnit': ['collision_camera_049 (A)'],
        'SP_Checkpoint_ChainReaction': ['collision_camera_026 (A)'],
        'SP_Checkpoint_ChargeBeam': ['collision_camera_014 (A)'],
        'SP_Checkpoint_ChozoWarriorCave': ['collision_camera_082 (A)'],
        'SP_Checkpoint_Cooldown': ['collision_camera_081 (A)'],
        'SP_Checkpoint_Dead_ChozoWarriorX': ['collision_camera_091 (A)'],
        'SP_Checkpoint_EmmyCave': ['collision_camera_005 (A)'],
        'SP_Checkpoint_EmmyCavePhase2': ['collision_camera_090 (A)'],
        'SP_Checkpoint_Grapple': ['collision_camera_033 (A)'],
        'SP_Checkpoint_MagnetGlove': ['collision_camera_017 (A)'],
        'SP_Checkpoint_OpticalCamo': ['collision_camera_020 (A)'],
        'SP_Checkpoint_Post_ChainReaction': ['collision_camera_030 (A)'],
        'SP_Checkpoint_Pre_ChozoWarriorX': ['collision_camera_056 (A)'],
        'SP_Checkpoint_ProtoEmmy': ['collision_camera_003 (A)'],
        'SP_Checkpoint_Scorpius': ['collision_camera_072 (A)'],
        'SP_Checkpoint_ScrewAttack': ['collision_camera_081 (A)'],
        'SP_Checkpoint_ThermalDevice': ['collision_camera_067 (A)'],
        'SP_Checkpoint_VariaSuit': ['collision_camera_031 (A)'],
        'SP_Checkpoint_WaterValve': ['collision_camera_060 (A)'],
        'SP_Emmy': ['collision_camera_006 (A)'],
        'SP_EmmyProto': ['collision_camera_016 (A)'],
        'SlideTutoTriggerEnter': ['collision_camera_000 (A)'],
        'SlideTutoTriggerExit': ['collision_camera_000 (A)'],
        'StartPoint0': ['collision_camera_000_Init (A)'],
        'TG_ChainReaction_001': ['collision_camera_026 (A)'],
        'TG_ChainReaction_002': ['collision_camera_026 (A)'],
        'TG_ChainReaction_003': ['collision_camera_026 (A)'],
        'TG_ChainReaction_BigExplosion': ['collision_camera_030 (A)'],
        'TG_ChainReaction_Camera_000': ['collision_camera_026 (A)'],
        'TG_ChainReaction_Camera_001': ['collision_camera_026 (A)'],
        'TG_ChainReaction_Camera_002': ['collision_camera_026 (A)'],
        'TG_ChainReaction_Camera_003': ['collision_camera_026 (A)'],
        'TG_ChainReaction_Camera_004': ['collision_camera_026 (A)'],
        'TG_ChainReaction_Camera_005': ['collision_camera_026 (A)'],
        'TG_ChainReaction_Camera_006': ['collision_camera_030 (A)'],
        'TG_ChainReaction_ChangeFinalSetup': ['collision_camera_030 (A)'],
        'TG_ChainReaction_SteamJet_001': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_002': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_003': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_004': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_005': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_006': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_007': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_008': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_009': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_010': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_011': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_012': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_013': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_014': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_015': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_016': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_017': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_018': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_019': ['collision_camera_026 (A)'],
        'TG_ChainReaction_SteamJet_020': ['collision_camera_026 (A)'],
        'TG_ChangeCamera_003_B': ['collision_camera_003 (A)'],
        'TG_ChangeCamera_003_C': ['collision_camera_003 (A)'],
        'TG_ChangeCamera_015_B': ['collision_camera_015 (A)'],
        'TG_ChangeCamera_023_B': ['collision_camera_023_B (A)'],
        'TG_ChangeCamera_031_B': ['collision_camera_031 (A)'],
        'TG_ChangeCamera_048_B': ['collision_camera_048 (A)'],
        'TG_ChangeCamera_048_C': ['collision_camera_048 (A)'],
        'TG_ChangeCamera_050_B': ['collision_camera_050 (A)'],
        'TG_ChangeCamera_056_B': ['collision_camera_056 (A)'],
        'TG_ChangeCamera_056_C': ['collision_camera_056 (A)'],
        'TG_ChangeCamera_064B': ['collision_camera_064 (A)'],
        'TG_ChangeCamera_091_B': ['collision_camera_091 (A)'],
        'TG_ChangeCamera_FX_01': ['collision_camera_048 (A)'],
        'TG_DisableCamera_048': ['collision_camera_010 (A)', 'collision_camera_051 (A)'],
        'TG_EmmyCavePresentationForbiddenEdges': ['collision_camera_006 (A)'],
        'TG_EmmyCavePresentationForbiddenEdgesEnd': ['collision_camera_006 (A)'],
        'TG_EmmyCaveSnapshot': ['collision_camera_049 (A)'],
        'TG_EmmyCaveStartVisualConeHack': ['collision_camera_071 (A)'],
        'TG_EmmyEndStagger_000': ['collision_camera_008 (A)'],
        'TG_EmmyGrabOverride_000': ['collision_camera_071 (A)'],
        'TG_EmmyGrabOverride_001': ['collision_camera_071 (A)'],
        'TG_EmmyPerceptionModifier': ['collision_camera_015 (A)'],
        'TG_EmmyPerceptionModifier_001': ['collision_camera_015 (A)'],
        'TG_EmmyPerceptionModifier_002': ['collision_camera_048 (A)'],
        'TG_EmmyPerceptionModifier_003': ['collision_camera_010 (A)'],
        'TG_EmmyPerceptionModifier_004': ['collision_camera_015 (A)'],
        'TG_EmmyPerceptionModifier_Focus': ['collision_camera_008 (A)'],
        'TG_EmmySpawnSequence_Samus': ['collision_camera_006 (A)'],
        'TG_EmmyTunnelChaseDeviation': ['collision_camera_015 (A)'],
        'TG_IgnoreFloorSlideUpperBodySubmerged': ['collision_camera_004 (A)'],
        'TG_MusicChange_ScrewAttack_StatueRoom': ['collision_camera_081 (A)'],
        'TG_PATROLEMMYACTIVATOR_01': ['collision_camera_005 (A)'],
        'TG_PATROLEMMYACTIVATOR_02': ['collision_camera_005 (A)'],
        'TG_PATROLEMMYACTIVATOR_03': ['collision_camera_006 (A)'],
        'TG_PATROLEMMYACTIVATOR_04': ['collision_camera_006 (A)'],
        'TG_PATROLEMMYACTIVATOR_05': ['collision_camera_008 (A)'],
        'TG_PATROLEMMYACTIVATOR_06': ['collision_camera_070 (A)'],
        'TG_PATROLEMMYACTIVATOR_07': ['collision_camera_009 (A)'],
        'TG_PATROLEMMYACTIVATOR_08': ['collision_camera_048 (A)'],
        'TG_PATROLEMMYACTIVATOR_09': ['collision_camera_011 (A)'],
        'TG_PATROLEMMYACTIVATOR_10': ['collision_camera_060 (A)'],
        'TG_PATROLEMMYACTIVATOR_11': ['collision_camera_010 (A)'],
        'TG_PATROLEMMYACTIVATOR_12': ['collision_camera_015 (A)'],
        'TG_PATROLEMMYACTIVATOR_13': ['collision_camera_017 (A)'],
        'TG_PATROLEMMYACTIVATOR_14': ['collision_camera_017 (A)'],
        'TG_PATROLEMMYACTIVATOR_15': ['collision_camera_049 (A)'],
        'TG_PROTOEMMY_ACTIVATE': ['collision_camera_064 (A)'],
        'TG_PROTOEMMY_ACTIVATE_TIMER': ['collision_camera_064 (A)'],
        'TG_PROTOEMMY_BEHAVIOR': ['collision_camera_064 (A)'],
        'TG_PROTOEMMY_BEHAVIOR_001': ['collision_camera_064 (A)'],
        'TG_PROTOEMMY_BEHAVIOR_002': ['collision_camera_064 (A)'],
        'TG_PROTOEMMY_BEHAVIOR_003': ['collision_camera_064 (A)'],
        'TG_Snapshot_Checkpoint_EmmyCave': ['collision_camera_006 (A)'],
        'TG_StartCUCombat_001': ['collision_camera_090 (A)'],
        'TG_TutoFocus_Caves': ['collision_camera_050 (A)'],
        'TG_TutoFocus_Caves_001': ['collision_camera_009 (A)'],
        'TG_WaterValve_Tuto': ['collision_camera_075 (A)'],
        'Watervalve_fillmap': ['collision_camera_010 (A)'],
        'block_slide_reg_001': ['collision_camera_048 (A)'],
        'box_grapple_cv_001': ['collision_camera_033 (A)'],
        'box_weight_cv_001': ['collision_camera_069 (A)'],
        'box_weight_cv_001_col': ['collision_camera_069 (A)'],
        'box_wide_cv_001': ['collision_camera_069 (A)'],
        'breakablecave016': ['collision_camera_070 (A)'],
        'breakablecave017': ['collision_camera_070 (A)'],
        'breakablecave019': ['collision_camera_081 (A)'],
        'breakablehint_000': ['collision_camera_009 (A)'],
        'breakablehint_001': ['collision_camera_016 (A)'],
        'breakablehint_002': ['collision_camera_011 (A)'],
        'breakablehint_003': ['collision_camera_067 (A)'],
        'breakablehint_004': ['collision_camera_081 (A)'],
        'breakablehint_005': ['collision_camera_062 (A)'],
        'breakablehint_006': ['collision_camera_051 (A)'],
        'breakablehint_007': ['collision_camera_003 (A)'],
        'burnertrapcav01': ['collision_camera_023_B (A)'],
        'burnertrapcav01_000': ['collision_camera_023_B (A)'],
        'camRail_PreChain': ['collision_camera_026 (A)'],
        'camRail_mbTunnel': ['collision_camera_055 (A)'],
        'camerarailpath_MagmaCorridor': ['collision_camera_023 (A)'],
        'centralunitcave_000': ['collision_camera_090 (A)'],
        'db_dif_cv_002': ['collision_camera_056 (A)'],
        'db_reg_cv_021': ['collision_camera_022 (A)'],
        'db_reg_cv_022': ['collision_camera_011 (A)'],
        'db_reg_cv_023': ['collision_camera_011 (A)'],
        'door_frblack_gen_003': ['collision_camera_017 (A)', 'collision_camera_049 (A)'],
        'door_frblack_gen_004': ['collision_camera_017 (A)', 'collision_camera_049 (A)'],
        'door_frblack_gen_005': ['collision_camera_049 (A)'],
        'door_frblack_gen_006': ['collision_camera_015 (A)', 'collision_camera_017 (A)'],
        'door_frblack_gen_007': ['collision_camera_015 (A)'],
        'door_frblack_gen_008': ['collision_camera_017 (A)', 'collision_camera_049 (A)'],
        'door_frblack_gen_009': ['collision_camera_017 (A)', 'collision_camera_049 (A)'],
        'door_frblack_gen_010': ['collision_camera_017 (A)'],
        'door_frblack_gen_011': ['collision_camera_015 (A)', 'collision_camera_017 (A)'],
        'door_frblack_protoemmy': ['collision_camera_016 (A)', 'collision_camera_064 (A)'],
        'door_frblack_protoemmy_000': ['collision_camera_016 (A)',
                                       'collision_camera_064 (A)'],
        'door_frblack_protoemmy_001': ['collision_camera_064 (A)',
                                       'collision_camera_074 (A)'],
        'door_shield_plasma_000': ['collision_camera_081 (A)', 'collision_camera_085 (A)'],
        'door_shield_plasma_001': ['collision_camera_082 (A)'],
        'door_shield_plasma_002': ['collision_camera_082 (A)'],
        'door_shield_plasma_003': ['collision_camera_081 (A)', 'collision_camera_085 (A)'],
        'doorclosedgrapple_000': ['collision_camera_033 (A)', 'collision_camera_089 (A)'],
        'doorclosedpower_000': ['collision_camera_010 (A)', 'collision_camera_051 (A)'],
        'doorgrapplegrapple': ['collision_camera_081 (A)', 'collision_camera_082 (A)'],
        'doorpresenceframe_000': ['collision_camera_022 (A)', 'collision_camera_050 (A)'],
        'doorpresenceframe_001': ['collision_camera_024 (A)', 'collision_camera_079 (A)'],
        'doorshieldsupermissile_000': ['collision_camera_011 (A)',
                                       'collision_camera_055 (A)'],
        'doorshutter_000': ['collision_camera_030 (A)'],
        'doorwavebeam_000': ['collision_camera_010 (A)', 'collision_camera_051 (A)'],
        'doorwidebeam_000': ['collision_camera_008 (A)', 'collision_camera_009 (A)'],
        'elevator_aqua_000_platform': ['collision_camera_080 (A)'],
        'elevator_aqua_000_platform_frozen': ['collision_camera_080 (A)'],
        'elevator_baselab_000': ['collision_camera_034 (A)'],
        'elevator_baselab_000_platform': ['collision_camera_034 (A)'],
        'elevator_with_cutscene_aqua_000': ['collision_camera_080 (A)'],
        'env_frozen_gen_001_000': ['collision_camera_091 (A)'],
        'env_frozen_gen_001_001': ['collision_camera_062 (A)'],
        'env_frozen_gen_001_002': ['collision_camera_082 (A)'],
        'env_heat_gen_001_001': ['collision_camera_023_B (A)'],
        'env_heat_gen_001_002': ['collision_camera_078 (A)'],
        'env_heat_gen_001_003': ['collision_camera_028 (A)'],
        'env_heat_gen_001_004': ['collision_camera_029 (A)'],
        'env_heat_gen_001_CR_001': ['collision_camera_026 (A)'],
        'env_heat_gen_001_CR_002': ['collision_camera_026 (A)'],
        'env_heat_gen_001_CR_003': ['collision_camera_026 (A)'],
        'env_heat_gen_001_CR_004': ['collision_camera_026 (A)'],
        'env_heat_gen_001_CR_005': ['collision_camera_026 (A)'],
        'env_heat_gen_001_CR_END': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_001': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_001_a': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_001_b': ['collision_camera_011 (A)'],
        'ev_chainreaction_cv_002': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_003': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_004': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_004_a': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_005': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_006': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_007': ['collision_camera_011 (A)'],
        'ev_chainreaction_cv_009': ['collision_camera_011 (A)'],
        'ev_chainreaction_cv_009_B': ['collision_camera_011 (A)'],
        'ev_chainreaction_cv_010': ['collision_camera_028 (A)'],
        'ev_chainreaction_cv_010_b': ['collision_camera_028 (A)'],
        'ev_chainreaction_cv_012': ['collision_camera_011 (A)'],
        'ev_chainreaction_cv_fx_000': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_001': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_002': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_003': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_004': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_005': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_006': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_007': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_008': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_009': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_010': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_011': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_012': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_013': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_014': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_015': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_016': ['collision_camera_026 (A)'],
        'ev_chainreaction_cv_fx_018': ['collision_camera_026 (A)'],
        'ev_chainreaction_deviceheat': ['collision_camera_026 (A)'],
        'ev_chainreaction_weightactivatedplatform': ['collision_camera_026 (A)'],
        'ev_entercu_cv_001': ['collision_camera_049 (A)'],
        'ev_piston_cv_002': ['collision_camera_017 (A)'],
        'ev_protoemmy_chasemusic': ['collision_camera_064 (A)'],
        'footstepplatform_000': ['collision_camera_030 (A)'],
        'fx_cold_door': ['collision_camera_013 (A)', 'collision_camera_062 (A)'],
        'fx_cold_door_000': ['collision_camera_062 (A)', 'collision_camera_086 (A)'],
        'fx_cold_door_001': ['collision_camera_086 (A)', 'collision_camera_091 (A)'],
        'fx_cold_door_002': ['collision_camera_081 (A)', 'collision_camera_082 (A)'],
        'fx_heat_door': ['collision_camera_028 (A)'],
        'fx_heat_door_000': ['collision_camera_026 (A)', 'collision_camera_028 (A)'],
        'fx_heat_door_001': ['collision_camera_029 (A)', 'collision_camera_031 (A)'],
        'fx_heat_door_002': ['collision_camera_024 (A)', 'collision_camera_078 (A)'],
        'fx_heat_door_003': ['collision_camera_023_B (A)', 'collision_camera_024 (A)'],
        'fx_heat_door_004': ['collision_camera_077 (A)', 'collision_camera_078 (A)'],
        'fx_heat_door_005': ['collision_camera_026 (A)', 'collision_camera_055 (A)'],
        'fx_heat_tunnel_000': ['collision_camera_026 (A)'],
        'fxsmokepipesyellowadorn01_000': ['collision_camera_016 (A)'],
        'fxsmokepipesyellowadorn01_012': ['collision_camera_016 (A)'],
        'fxsmokepipesyellowadorn01_013': ['collision_camera_016 (A)'],
        'fxsmokepipesyellowadorn01_014': ['collision_camera_016 (A)'],
        'fxsmokepipesyellowadorn01_015': ['collision_camera_016 (A)'],
        'grapplepulloff1x2_001': ['collision_camera_081 (A)'],
        'grapplepulloff1x2_002': ['collision_camera_030 (A)'],
        'grappleswingpoint_000': ['collision_camera_089 (A)'],
        'heatroomfx_001_01': ['collision_camera_026 (A)'],
        'heatroomfx_001_02': ['collision_camera_026 (A)'],
        'heatroomfx_001_03': ['collision_camera_026 (A)'],
        'heatroomfx_001_04': ['collision_camera_026 (A)'],
        'heatroomfx_001_05': ['collision_camera_026 (A)'],
        'heatroomfx_001_06': ['collision_camera_026 (A)'],
        'heatroomfx_002_01': ['collision_camera_026 (A)'],
        'heatroomfx_002_02': ['collision_camera_026 (A)'],
        'heatroomfx_002_03': ['collision_camera_026 (A)'],
        'heatroomfx_003_01': ['collision_camera_026 (A)'],
        'heatroomfx_003_02': ['collision_camera_026 (A)'],
        'heatroomfx_003_03': ['collision_camera_026 (A)'],
        'heatroomfx_003_04': ['collision_camera_026 (A)'],
        'heatroomfx_003_05': ['collision_camera_026 (A)'],
        'heatroomfx_003_06': ['collision_camera_026 (A)'],
        'heatroomfx_004_01': ['collision_camera_026 (A)'],
        'heatroomfx_004_02': ['collision_camera_026 (A)'],
        'heatroomfx_004_03': ['collision_camera_026 (A)'],
        'heatroomfx_004_04': ['collision_camera_026 (A)'],
        'heatroomfx_004_05': ['collision_camera_026 (A)'],
        'heatroomfx_005_01': ['collision_camera_026 (A)'],
        'heatroomfx_005_02': ['collision_camera_026 (A)'],
        'heatroomfx_005_03': ['collision_camera_026 (A)'],
        'heatroomfx_005_04': ['collision_camera_026 (A)'],
        'heatroomfx_END_01': ['collision_camera_026 (A)'],
        'heatroomfx_END_02': ['collision_camera_026 (A)'],
        'instancefx_036': ['collision_camera_060 (A)'],
        'instancefx_037': ['collision_camera_060 (A)'],
        'instancefx_038': ['collision_camera_060 (A)'],
        'item_energyfragment_000': ['collision_camera_086 (A)'],
        'item_energyfragment_001': ['collision_camera_056 (A)'],
        'item_energytank_000': ['collision_camera_030 (A)'],
        'item_missiletank_000': ['collision_camera_050 (A)'],
        'item_missiletank_001': ['collision_camera_009 (A)'],
        'item_missiletank_002': ['collision_camera_081 (A)'],
        'item_missiletank_003': ['collision_camera_011 (A)'],
        'item_missiletank_004': ['collision_camera_051 (A)'],
        'item_missiletank_005': ['collision_camera_003 (A)'],
        'item_missiletank_006': ['collision_camera_080 (A)'],
        'item_missiletankplus_000': ['collision_camera_086 (A)'],
        'item_missiletankplus_001': ['collision_camera_029 (A)'],
        'item_powerbombtank_000': ['collision_camera_010 (A)'],
        'lavazone_001': [],
        'lavazone_002': ['collision_camera_028 (A)'],
        'lavazone_003': ['collision_camera_023_B (A)'],
        'logicactiontrigger_000': ['collision_camera_064 (A)'],
        'logicactiontrigger_001': [],
        'platformtrapgrapple5right': ['collision_camera_015 (A)'],
        'rail_magnet_PlatformMagnet3Left': ['collision_camera_005 (A)'],
        'rail_magnet_PlatformMagnet4Down': ['collision_camera_015 (A)'],
        'rail_magnet_PlatformMagnet5Down': ['collision_camera_006 (A)'],
        'spawnpointrinka_000': ['collision_camera_090 (A)'],
        'spawnpointrinka_001': ['collision_camera_090 (A)'],
        'spraypipe_cave': ['collision_camera_056 (A)'],
        'steammag01_005': ['collision_camera_077 (A)'],
        'steammag01_006': ['collision_camera_077 (A)'],
        'steammag01_007': ['collision_camera_077 (A)'],
        'steammag01_008': ['collision_camera_077 (A)'],
        'steammag01_009': ['collision_camera_077 (A)'],
        'steammag01_chainreaction_001': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_002': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_003': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_004': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_005': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_006': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_007': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_008': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_009': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_010': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_011': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_012': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_013': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_014': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_015': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_016': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_017': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_018': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_019': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_020': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_old': ['collision_camera_026 (A)'],
        'steammag01_chainreaction_old_000': ['collision_camera_029 (A)'],
        'steamprotoemmy': ['collision_camera_064 (A)'],
        'steamprotoemmy_000': ['collision_camera_016 (A)'],
        'steamprotoemmy_001': ['collision_camera_016 (A)'],
        'steamprotoemmy_002': ['collision_camera_016 (A)'],
        'teleport_baselab_000': ['collision_camera_008 (A)'],
        'teleport_baselab_000_platform': ['collision_camera_008 (A)'],
        'teleport_baselab_000_platform_frozen': ['collision_camera_008 (A)'],
        'teleporter_magma_000': ['collision_camera_081 (A)'],
        'teleporter_magma_000_platform': ['collision_camera_081 (A)'],
        'teleporter_magma_000_platform_frozen': ['collision_camera_081 (A)'],
        'trap_rot_cv_001': ['collision_camera_081 (A)'],
        'trap_rot_cv_003': ['collision_camera_056 (A)'],
        'trap_thermal_horizontal_000': ['collision_camera_011 (A)'],
        'trap_thermal_horizontal_001': ['collision_camera_011 (A)'],
        'waterbeforemaproom': ['collision_camera_056 (A)'],
        'waterzone_000': ['collision_camera_081 (A)'],
        'waterzone_001': ['collision_camera_081 (A)'],
        'waterzone_002': ['collision_camera_081 (A)'],
        'waterzone_003': []},
    's020_magma': {'AP_03': ['collision_camera_002 (C)'],
                   'AP_03B': ['collision_camera_058 (C)'],
                   'CAM_Default': ['collision_camera_046 (C)'],
                   'CAM_Far': ['collision_camera_009 (C)', 'collision_camera_CooldownX (C)'],
                   'CAM_NewPath': ['collision_camera_042 (C)'],
                   'CAM_ToKraid_MetroClose': ['collision_camera_024 (C)'],
                   'CAM_ToKraid_MetroClose_2': ['collision_camera_024 (C)'],
                   'CAM_ToKraid_MetroClose_3': ['collision_camera_024 (C)'],
                   'CAM_Transition_Left_0': ['collision_camera_009 (C)'],
                   'CAM_Transition_Right_0': ['collision_camera_009 (C)'],
                   'CAM_Transition_Right_1': ['collision_camera_009 (C)'],
                   'CamRail_KraidFace': ['collision_camera_023 (C)'],
                   'Cam_KraidFace': ['collision_camera_023 (C)'],
                   'Cam_KraidFace_Close': ['collision_camera_023 (C)'],
                   'CameraRail_PathToKraid': ['collision_camera_024 (C)'],
                   'Disable_CamToKraid': ['collision_camera_061 (C)'],
                   'LE_Elevator_FromCave': ['collision_camera_000 (C)'],
                   'LE_Platform_Elevator_FromCave': ['collision_camera_000 (C)'],
                   'LE_Platform_Teleport_FromCave': ['collision_camera_025 (C)'],
                   'LE_Teleport_FromCave': ['collision_camera_025 (C)'],
                   'LE_WorldGraph': ['collision_camera_046 (C)'],
                   'LM_EmmyDestroySearch_001': ['collision_camera_036 (C)'],
                   'LM_EmmyEntrancePoint_000': ['collision_camera_020 (C)'],
                   'LM_EmmyEntrancePoint_002': ['collision_camera_046 (C)'],
                   'LM_EmmyEntrancePoint_003': ['collision_camera_046 (C)'],
                   'LM_EmmyEntrancePoint_004': ['collision_camera_020 (C)'],
                   'LM_EmmyEntrancePoint_005': ['collision_camera_010 (C)'],
                   'LM_EmmyEntrancePoint_006': ['collision_camera_010 (C)'],
                   'LM_EmmyEntrancePoint_007': ['collision_camera_059 (C)'],
                   'LM_EmmyEntrancePoint_008': ['collision_camera_028 (C)'],
                   'LM_EmmyEntrancePoint_009': ['collision_camera_028 (C)'],
                   'LM_EmmyEntrancePoint_010': ['collision_camera_028 (C)'],
                   'LM_EmmyEntrancePoint_012': ['collision_camera_029 (C)'],
                   'LM_EmmyEntrancePoint_013': ['collision_camera_036 (C)'],
                   'LM_EmmyEntrancePoint_014': ['collision_camera_022 (C)'],
                   'LM_EmmyEntrancePoint_015': ['collision_camera_035 (C)'],
                   'LM_EmmyEntrancePoint_017': ['collision_camera_046 (C)'],
                   'LM_EmmyEntrancePoint_019': ['collision_camera_032 (C)'],
                   'LM_EmmyEntrancePoint_020': ['collision_camera_010 (C)'],
                   'LM_EmmyEntrancePoint_021': ['collision_camera_032 (C)'],
                   'LM_EmmyEntrancePoint_024': ['collision_camera_046 (C)'],
                   'LM_EmmyEntrancePoint_025': ['collision_camera_010 (C)'],
                   'LS_EmmyForbidden_000': ['collision_camera_032 (C)'],
                   'LS_EmmyForbidden_001': ['collision_camera_032 (C)'],
                   'LS_EmmyForbidden_002': ['collision_camera_032 (C)'],
                   'LS_EmmyForbidden_003': ['collision_camera_046 (C)'],
                   'LS_EmmyForbidden_004': ['collision_camera_059 (C)'],
                   'LS_EmmyForbidden_005': ['collision_camera_032 (C)'],
                   'LS_EmmyForbidden_006': ['collision_camera_020 (C)'],
                   'LS_EmmyForbidden_007': ['collision_camera_046 (C)'],
                   'LS_EmmyForbidden_009': ['collision_camera_028 (C)'],
                   'LS_EmmyForbidden_010': ['collision_camera_029 (C)'],
                   'LS_EmmyForbidden_011': ['collision_camera_035 (C)'],
                   'LS_EmmyForbidden_012': ['collision_camera_035 (C)'],
                   'LS_EmmyForbidden_013': ['collision_camera_036 (C)'],
                   'LS_EmmyForbidden_014': ['collision_camera_036 (C)'],
                   'LS_EmmyForbidden_015': ['collision_camera_020 (C)'],
                   'LS_EmmyForbidden_016': ['collision_camera_020 (C)'],
                   'LS_EmmyForbidden_017': ['collision_camera_035 (C)'],
                   'LS_EmmyForbidden_018': ['collision_camera_046 (C)'],
                   'LS_EmmyForbidden_019': ['collision_camera_032 (C)'],
                   'LS_EmmyForbidden_020': ['collision_camera_032 (C)'],
                   'LS_EmmyForbidden_021': ['collision_camera_032 (C)'],
                   'LS_EmmyForbidden_022': ['collision_camera_020 (C)'],
                   'LS_EmmyForbidden_023': ['collision_camera_036 (C)'],
                   'LS_EmmyForbidden_024': ['collision_camera_010 (C)'],
                   'LS_EmmyForbidden_025': ['collision_camera_032 (C)'],
                   'LS_EmmyForbidden_026': ['collision_camera_020 (C)'],
                   'LS_EmmyForbidden_027': ['collision_camera_036 (C)'],
                   'LS_EmmyForbidden_028': ['collision_camera_036 (C)'],
                   'LS_EmmyZone': ['collision_camera_020 (C)'],
                   'LS_MagmaRinkaLifeArea_000': ['collision_camera_037 (C)'],
                   'LS_PATROLEMMY_01': ['collision_camera_052 (C)'],
                   'LS_PATROLEMMY_02': ['collision_camera_020 (C)'],
                   'LS_PATROLEMMY_03': ['collision_camera_032 (C)'],
                   'LS_PATROLEMMY_04': ['collision_camera_034 (C)', 'collision_camera_055 (C)'],
                   'LS_PATROLEMMY_05': ['collision_camera_013 (C)'],
                   'LS_PATROLEMMY_06': ['collision_camera_028 (C)'],
                   'LS_PATROLEMMY_07': [],
                   'LS_PATROLEMMY_08': ['collision_camera_059 (C)'],
                   'LS_PATROLEMMY_09': ['collision_camera_036 (C)'],
                   'LS_PATROLEMMY_10': ['collision_camera_036 (C)'],
                   'LS_PATROLEMMY_11': ['collision_camera_032 (C)'],
                   'LS_PATROLEMMY_12': ['collision_camera_035 (C)'],
                   'LS_PATROLEMMY_13': ['collision_camera_052 (C)'],
                   'LS_PATROLEMMY_14': ['collision_camera_046 (C)'],
                   'SG_Magma_Cannons_000': ['collision_camera_037 (C)'],
                   'SP_AccessPoint_3': ['collision_camera_000 (C)'],
                   'SP_AccessPoint_3_B': ['collision_camera_025 (C)'],
                   'SP_Checkpoint_CentralUnit': ['collision_camera_036 (C)'],
                   'SP_Checkpoint_CooldownX': ['collision_camera_004 (C)'],
                   'SP_Checkpoint_Dead_CooldownX': ['collision_camera_009 (C)',
                                                    'collision_camera_CooldownX (C)'],
                   'SP_Checkpoint_Dead_Kraid': ['collision_camera_063 (C)'],
                   'SP_Checkpoint_EmmyMagma': ['collision_camera_052 (C)'],
                   'SP_Checkpoint_EmmyMagmaPhase2': ['collision_camera_037 (C)'],
                   'SP_Checkpoint_Kraid': ['collision_camera_061 (C)'],
                   'SP_Checkpoint_MorphBall': ['collision_camera_036 (C)'],
                   'SP_Checkpoint_PistonLeft': ['collision_camera_038 (C)'],
                   'SP_Checkpoint_PistonRight': ['collision_camera_012 (C)'],
                   'SP_Checkpoint_WideBeam': ['collision_camera_041 (C)'],
                   'SP_DiffusionBeam': ['collision_camera_044 (C)'],
                   'SP_Emmy': ['collision_camera_046 (C)'],
                   'SP_Magma_CUCannon_000': ['collision_camera_037 (C)'],
                   'SP_Magma_CUCannon_001': ['collision_camera_037 (C)'],
                   'SP_Magma_CUCannon_002': ['collision_camera_037 (C)'],
                   'SP_Magma_CUCannon_003': ['collision_camera_037 (C)'],
                   'StartPoint0': ['collision_camera_000 (C)'],
                   'TG_ChangeCamera_000_B': ['collision_camera_000 (C)'],
                   'TG_ChangeCamera_009_B': ['collision_camera_009 (C)'],
                   'TG_ChangeCamera_009_C': ['collision_camera_009 (C)'],
                   'TG_ChangeCamera_015_B': ['collision_camera_015 (C)'],
                   'TG_ChangeCamera_023_B': ['collision_camera_023 (C)'],
                   'TG_ChangeCamera_025_B': ['collision_camera_025 (C)'],
                   'TG_ChangeCamera_026_B': ['collision_camera_026 (C)'],
                   'TG_ChangeCamera_051_B': ['collision_camera_051 (C)'],
                   'TG_CombatCU': [],
                   'TG_Diffusion_MusicChange': ['collision_camera_044 (C)'],
                   'TG_Diffusion_MusicChange_000': ['collision_camera_044 (C)'],
                   'TG_EmmyUnlockDoors': ['collision_camera_028 (C)'],
                   'TG_FadeActivation_CooldownX_000': ['collision_camera_004 (C)'],
                   'TG_InsideTunnelMusicChange': ['collision_camera_053 (C)'],
                   'TG_PATROLEMMYACTIVATOR_01': ['collision_camera_046 (C)'],
                   'TG_PATROLEMMYACTIVATOR_02': ['collision_camera_020 (C)'],
                   'TG_PATROLEMMYACTIVATOR_03': ['collision_camera_032 (C)'],
                   'TG_PATROLEMMYACTIVATOR_04': ['collision_camera_032 (C)'],
                   'TG_PATROLEMMYACTIVATOR_05': ['collision_camera_013 (C)'],
                   'TG_PATROLEMMYACTIVATOR_06': ['collision_camera_028 (C)'],
                   'TG_PATROLEMMYACTIVATOR_07': ['collision_camera_027 (C)'],
                   'TG_PATROLEMMYACTIVATOR_08': ['collision_camera_059 (C)'],
                   'TG_PATROLEMMYACTIVATOR_09': ['collision_camera_038 (C)'],
                   'TG_PATROLEMMYACTIVATOR_10': ['collision_camera_036 (C)'],
                   'TG_PATROLEMMYACTIVATOR_11': [],
                   'TG_PATROLEMMYACTIVATOR_12': ['collision_camera_031 (C)'],
                   'TG_PATROLEMMYACTIVATOR_13': ['collision_camera_046 (C)'],
                   'TG_PATROLEMMYACTIVATOR_14': ['collision_camera_046 (C)'],
                   'TG_PistonLeft_MusicChange': ['collision_camera_038 (C)'],
                   'TG_PistonLeft_MusicChange_000': ['collision_camera_042 (C)'],
                   'TG_PistonRight_MusicChange': ['collision_camera_012 (C)'],
                   'TG_PostCoolDownX_MusicChange': ['collision_camera_009 (C)',
                                                    'collision_camera_CooldownX (C)'],
                   'TG_Subarea_043_MusicChange': ['collision_camera_043 (C)'],
                   'TG_TutoOC_Enter': ['collision_camera_046 (C)'],
                   'TG_TutoOC_Exit': ['collision_camera_020 (C)'],
                   'TG_ZoomOutQuit': ['collision_camera_042 (C)'],
                   'accesspoint': ['collision_camera_002 (C)'],
                   'accesspoint_000': ['collision_camera_058 (C)'],
                   'accesspoint_platform': ['collision_camera_002 (C)'],
                   'accesspoint_platform_000': ['collision_camera_058 (C)'],
                   'ammorecharge_000': ['collision_camera_023 (C)'],
                   'block_slide_reg_002': ['collision_camera_024 (C)'],
                   'box_magnet_mg_004': ['collision_camera_042 (C)'],
                   'box_magnet_mg_01_000': ['collision_camera_015 (C)'],
                   'box_wide_cv_001': ['collision_camera_040 (C)'],
                   'box_wide_cv_002': ['collision_camera_048 (C)'],
                   'breakablemag001': ['collision_camera_007 (C)'],
                   'breakablemag002': ['collision_camera_000 (C)'],
                   'breakablemag003': ['collision_camera_009 (C)'],
                   'breakablemag004': ['collision_camera_019 (C)'],
                   'breakablemag005': ['collision_camera_020 (C)'],
                   'breakablemag007': ['collision_camera_036 (C)'],
                   'breakablemag008': ['collision_camera_036 (C)'],
                   'breakablemag009': ['collision_camera_051 (C)'],
                   'breakablemag010': ['collision_camera_024 (C)'],
                   'breakablemag012': ['collision_camera_015 (C)'],
                   'breakablemag013': ['collision_camera_019 (C)'],
                   'breakablemag014': ['collision_camera_019 (C)'],
                   'camerarailpath': ['collision_camera_042 (C)'],
                   'centralunitmagma_000': ['collision_camera_037 (C)'],
                   'centralunitmagmacontroller': ['collision_camera_037 (C)'],
                   'cooldownxbosslavacarpet': ['collision_camera_009 (C)',
                                               'collision_camera_CooldownX (C)'],
                   'db_dif_mg_001': ['collision_camera_051 (C)'],
                   'db_dif_mg_002': ['collision_camera_044 (C)'],
                   'db_dside_mg_001b_000': ['collision_camera_026 (C)'],
                   'db_dside_mg_002': ['collision_camera_027 (C)'],
                   'db_dside_mg_002b_000': ['collision_camera_025 (C)'],
                   'db_dside_mg_003': ['collision_camera_026 (C)'],
                   'db_dside_mg_003b_000': ['collision_camera_045 (C)'],
                   'db_dside_mg_004': ['collision_camera_015 (C)'],
                   'db_hdoor_mg_001': ['collision_camera_016 (C)'],
                   'db_hdoor_mg_002': ['collision_camera_052 (C)'],
                   'db_hdoor_mg_002b_000': ['collision_camera_052 (C)'],
                   'db_reg_mg_017': ['collision_camera_023 (C)'],
                   'db_reg_mg_019': ['collision_camera_024 (C)'],
                   'db_reg_mg_020': ['collision_camera_061 (C)'],
                   'db_reg_mg_021': ['collision_camera_061 (C)'],
                   'deviceheat': ['collision_camera_004 (C)'],
                   'deviceheat_001': ['collision_camera_034 (C)'],
                   'deviceheat_002': ['collision_camera_042 (C)'],
                   'deviceheat_camerafar_000': ['collision_camera_042 (C)'],
                   'door_frblack_gen_000': ['collision_camera_036 (C)'],
                   'door_frblack_gen_001': ['collision_camera_022 (C)',
                                            'collision_camera_035 (C)',
                                            'collision_camera_036 (C)'],
                   'door_frblack_gen_002': ['collision_camera_028 (C)', 'collision_camera_036 (C)'],
                   'doorcentralunit': ['collision_camera_036 (C)'],
                   'doorchargecharge': ['collision_camera_018 (C)', 'collision_camera_042 (C)'],
                   'doorchargecharge_001': ['collision_camera_012 (C)', 'collision_camera_013 (C)'],
                   'doorchargecharge_002': ['collision_camera_012 (C)', 'collision_camera_045 (C)'],
                   'doorchargecharge_003': ['collision_camera_006 (C)', 'collision_camera_012 (C)'],
                   'doorchargecharge_005': ['collision_camera_020 (C)', 'collision_camera_046 (C)'],
                   'doorchargecharge_007': ['collision_camera_009 (C)', 'collision_camera_049 (C)'],
                   'doorclosedcharge': ['collision_camera_032 (C)', 'collision_camera_046 (C)'],
                   'doorclosedcharge_001': ['collision_camera_010 (C)', 'collision_camera_032 (C)'],
                   'doorclosedcharge_002': ['collision_camera_014 (C)', 'collision_camera_018 (C)'],
                   'doorclosedpower_000': ['collision_camera_044 (C)', 'collision_camera_051 (C)'],
                   'doorclosedpower_001': ['collision_camera_052 (C)', 'collision_camera_053 (C)'],
                   'dooremmy': ['collision_camera_010 (C)', 'collision_camera_013 (C)'],
                   'dooremmy_001': ['collision_camera_031 (C)', 'collision_camera_032 (C)'],
                   'dooremmy_002': ['collision_camera_032 (C)', 'collision_camera_034 (C)'],
                   'dooremmy_003': ['collision_camera_020 (C)', 'collision_camera_052 (C)'],
                   'dooremmy_004': ['collision_camera_022 (C)', 'collision_camera_030 (C)'],
                   'dooremmy_005': ['collision_camera_031 (C)', 'collision_camera_035 (C)'],
                   'dooremmy_006': ['collision_camera_035 (C)', 'collision_camera_040 (C)'],
                   'dooremmy_007': ['collision_camera_027 (C)', 'collision_camera_028 (C)'],
                   'dooremmy_008': ['collision_camera_023 (C)', 'collision_camera_028 (C)'],
                   'dooremmy_009': ['collision_camera_023 (C)', 'collision_camera_028 (C)'],
                   'doorframe': ['collision_camera_025 (C)', 'collision_camera_043 (C)'],
                   'doorframepresence': ['collision_camera_020 (C)', 'collision_camera_059 (C)'],
                   'doorframepresence_001': ['collision_camera_012 (C)', 'collision_camera_045 (C)'],
                   'doorgrapplegrapple': ['collision_camera_051 (C)', 'collision_camera_052 (C)'],
                   'doorgrapplegrapple_000': ['collision_camera_014 (C)', 'collision_camera_015 (C)'],
                   'doorheat_001': ['collision_camera_004 (C)', 'collision_camera_007 (C)'],
                   'doorheat_004': ['collision_camera_040 (C)', 'collision_camera_042 (C)'],
                   'doorpowerpower': ['collision_camera_000 (C)', 'collision_camera_006 (C)'],
                   'doorpowerpower_000': ['collision_camera_032 (C)', 'collision_camera_046 (C)'],
                   'doorpowerpower_001': ['collision_camera_006 (C)', 'collision_camera_015 (C)'],
                   'doorpowerpower_002': ['collision_camera_000 (C)', 'collision_camera_002 (C)'],
                   'doorpowerpower_003': ['collision_camera_002 (C)', 'collision_camera_004 (C)'],
                   'doorpowerpower_004': ['collision_camera_004 (C)', 'collision_camera_007 (C)'],
                   'doorpowerpower_007': ['collision_camera_025 (C)', 'collision_camera_062 (C)'],
                   'doorpowerpower_008': ['collision_camera_025 (C)', 'collision_camera_064 (C)'],
                   'doorpowerpower_009': ['collision_camera_025 (C)', 'collision_camera_058 (C)'],
                   'doorpowerpower_010': ['collision_camera_027 (C)', 'collision_camera_058 (C)'],
                   'doorpowerpower_011': ['collision_camera_028 (C)', 'collision_camera_029 (C)'],
                   'doorpowerpower_012': ['collision_camera_024 (C)', 'collision_camera_061 (C)'],
                   'doorpowerpower_013': ['collision_camera_022 (C)', 'collision_camera_029 (C)'],
                   'doorpowerpower_014': ['collision_camera_030 (C)', 'collision_camera_031 (C)'],
                   'doorpowerpower_015': ['collision_camera_032 (C)', 'collision_camera_046 (C)'],
                   'doorpowerpower_016': ['collision_camera_010 (C)', 'collision_camera_032 (C)'],
                   'doorpowerpower_017': ['collision_camera_033 (C)', 'collision_camera_034 (C)'],
                   'doorpowerpower_018': ['collision_camera_018 (C)', 'collision_camera_033 (C)'],
                   'doorpowerpower_019': ['collision_camera_004 (C)', 'collision_camera_007 (C)'],
                   'doorpowerpower_020': ['collision_camera_016 (C)', 'collision_camera_042 (C)'],
                   'doorpowerpower_021': ['collision_camera_040 (C)', 'collision_camera_041 (C)'],
                   'doorpowerpower_022': ['collision_camera_013 (C)', 'collision_camera_014 (C)'],
                   'doorpowerpower_023': ['collision_camera_014 (C)', 'collision_camera_045 (C)'],
                   'doorpowerpower_025': ['collision_camera_016 (C)', 'collision_camera_048 (C)'],
                   'doorpowerpower_026': ['collision_camera_009 (C)', 'collision_camera_021 (C)'],
                   'doorpowerpower_027': ['collision_camera_019 (C)', 'collision_camera_052 (C)'],
                   'doorpowerpower_028': ['collision_camera_023 (C)', 'collision_camera_064 (C)'],
                   'doorpowerpower_029': ['collision_camera_023 (C)', 'collision_camera_043 (C)'],
                   'doorpowerpower_030': ['collision_camera_035 (C)', 'collision_camera_036 (C)'],
                   'doorpresenceframe_000': ['collision_camera_014 (C)', 'collision_camera_018 (C)'],
                   'doorshieldmissile': ['collision_camera_044 (C)', 'collision_camera_051 (C)'],
                   'doorshutter_000': ['collision_camera_010 (C)'],
                   'doorshutter_001': ['collision_camera_020 (C)', 'collision_camera_046 (C)'],
                   'doorshutter_002': ['collision_camera_028 (C)', 'collision_camera_059 (C)'],
                   'doorwavebeam_000': ['collision_camera_052 (C)', 'collision_camera_053 (C)'],
                   'doorwidebeam_000': ['collision_camera_035 (C)', 'collision_camera_036 (C)'],
                   'emmyvalve_reg_gen_000': ['collision_camera_046 (C)'],
                   'emmyvalve_reg_gen_001': ['collision_camera_020 (C)'],
                   'emmyvalve_reg_gen_002': ['collision_camera_028 (C)'],
                   'emmyvalve_reg_gen_003': ['collision_camera_059 (C)'],
                   'emmyvalve_reg_gen_004': ['collision_camera_028 (C)'],
                   'emmyvalve_reg_gen_005': ['collision_camera_046 (C)'],
                   'emmyvalve_reg_gen_006': ['collision_camera_020 (C)'],
                   'emmyvalve_reg_gen_007': ['collision_camera_036 (C)'],
                   'emmyvalve_reg_gen_008': ['collision_camera_028 (C)'],
                   'emmyvalve_reg_gen_009': ['collision_camera_022 (C)'],
                   'emmyvalve_reg_gen_010': ['collision_camera_035 (C)'],
                   'emmyvalve_reg_gen_011': ['collision_camera_046 (C)'],
                   'emmyvalve_reg_gen_012': ['collision_camera_032 (C)'],
                   'emmyvalve_reg_gen_013': ['collision_camera_028 (C)'],
                   'emmyvalve_reg_gen_014': ['collision_camera_020 (C)'],
                   'emmyvalve_reg_gen_015': ['collision_camera_029 (C)'],
                   'emmyvalve_reg_gen_016': ['collision_camera_028 (C)'],
                   'emmyvalve_reg_gen_017': ['collision_camera_028 (C)'],
                   'emmyvalve_reg_gen_018': ['collision_camera_036 (C)'],
                   'emmyvalve_reg_gen_019': ['collision_camera_036 (C)'],
                   'emmyvalve_reg_gen_020': ['collision_camera_020 (C)'],
                   'emmyvalve_reg_gen_021': ['collision_camera_020 (C)'],
                   'emmyvalve_reg_gen_022': ['collision_camera_046 (C)'],
                   'emmyvalve_reg_gen_023': ['collision_camera_032 (C)'],
                   'emmyvalve_reg_gen_024': ['collision_camera_032 (C)'],
                   'energyrecharge': ['collision_camera_018 (C)'],
                   'env_heat_gen_001': ['collision_camera_015 (C)'],
                   'env_heat_gen_002': ['collision_camera_021 (C)'],
                   'env_heat_gen_003': ['collision_camera_026 (C)'],
                   'env_heat_gen_004': ['collision_camera_053 (C)'],
                   'env_heat_gen_005': ['collision_camera_038 (C)'],
                   'env_heat_gen_006': ['collision_camera_049 (C)'],
                   'env_heat_gen_007': ['collision_camera_012 (C)'],
                   'ev_dspiston_heat_000': ['collision_camera_042 (C)'],
                   'ev_dspiston_mg_001': ['collision_camera_031 (C)'],
                   'ev_hpiston_mg_001': ['collision_camera_009 (C)', 'collision_camera_CooldownX (C)'],
                   'ev_hpiston_mg_001_off': ['collision_camera_009 (C)',
                                             'collision_camera_CooldownX (C)'],
                   'ev_lavapump_mg_001': ['collision_camera_009 (C)'],
                   'ev_tpiston_heat_000': ['collision_camera_012 (C)'],
                   'ev_tpiston_mg_001': ['collision_camera_014 (C)'],
                   'fan_cooldown_000': ['collision_camera_009 (C)'],
                   'footstepplatform_000': ['collision_camera_010 (C)'],
                   'footstepplatform_001': ['collision_camera_020 (C)'],
                   'footstepplatform_002': ['collision_camera_028 (C)'],
                   'fusiblebox_000': ['collision_camera_009 (C)', 'collision_camera_CooldownX (C)'],
                   'fusiblebox_broken_000': ['collision_camera_009 (C)',
                                             'collision_camera_CooldownX (C)'],
                   'fx_heat_door': ['collision_camera_009 (C)', 'collision_camera_049 (C)'],
                   'fx_heat_door_000': ['collision_camera_009 (C)', 'collision_camera_021 (C)'],
                   'fx_heat_door_001': ['collision_camera_052 (C)', 'collision_camera_053 (C)'],
                   'fx_heat_door_002': ['collision_camera_019 (C)', 'collision_camera_052 (C)'],
                   'fx_heat_door_003': ['collision_camera_051 (C)', 'collision_camera_052 (C)'],
                   'fx_heat_door_004': ['collision_camera_023 (C)', 'collision_camera_043 (C)'],
                   'fx_heat_door_005': ['collision_camera_018 (C)', 'collision_camera_042 (C)'],
                   'fx_heat_door_006': ['collision_camera_016 (C)', 'collision_camera_042 (C)'],
                   'fx_heat_door_007': ['collision_camera_016 (C)', 'collision_camera_048 (C)'],
                   'fx_heat_door_008': ['collision_camera_006 (C)', 'collision_camera_015 (C)'],
                   'fx_heat_door_009': ['collision_camera_006 (C)', 'collision_camera_012 (C)'],
                   'fx_heat_door_010': ['collision_camera_012 (C)', 'collision_camera_045 (C)'],
                   'fx_heat_door_011': ['collision_camera_012 (C)', 'collision_camera_013 (C)'],
                   'fx_heat_door_012': ['collision_camera_014 (C)', 'collision_camera_015 (C)'],
                   'fx_heat_tunnel_000': ['collision_camera_025 (C)'],
                   'fx_heat_tunnel_001': ['collision_camera_027 (C)'],
                   'fx_heat_tunnel_002': ['collision_camera_045 (C)'],
                   'grapplepulloff1x2': ['collision_camera_044 (C)'],
                   'grapplepulloff1x2_000': ['collision_camera_053 (C)'],
                   'grapplepulloff1x2_001': ['collision_camera_026 (C)'],
                   'instanceactor_085': ['collision_camera_053 (C)'],
                   'instanceactor_086': ['collision_camera_053 (C)'],
                   'instanceactor_087': ['collision_camera_053 (C)'],
                   'instanceactor_088': ['collision_camera_053 (C)'],
                   'instanceactor_089': ['collision_camera_053 (C)'],
                   'instanceactor_091': ['collision_camera_053 (C)'],
                   'instanceactor_092': ['collision_camera_053 (C)'],
                   'instanceactor_093': ['collision_camera_053 (C)'],
                   'instanceactor_297': ['collision_camera_036 (C)'],
                   'instanceactor_298': ['collision_camera_036 (C)'],
                   'instanceactor_299': ['collision_camera_036 (C)'],
                   'instancefx_032': ['collision_camera_049 (C)'],
                   'item_energyfragment_000': ['collision_camera_053 (C)'],
                   'item_energyfragment_001': ['collision_camera_042 (C)'],
                   'item_energytank_000': ['collision_camera_042 (C)'],
                   'item_missiletank': ['collision_camera_000 (C)'],
                   'item_missiletank_000': ['collision_camera_040 (C)'],
                   'item_missiletank_001': ['collision_camera_021 (C)'],
                   'item_missiletank_002': ['collision_camera_049 (C)'],
                   'item_missiletank_003': ['collision_camera_051 (C)'],
                   'item_missiletank_004': ['collision_camera_028 (C)'],
                   'item_missiletank_005': ['collision_camera_026 (C)'],
                   'item_missiletank_006': ['collision_camera_026 (C)'],
                   'item_missiletank_007': ['collision_camera_048 (C)'],
                   'item_missiletank_008': ['collision_camera_009 (C)'],
                   'item_missiletank_009': ['collision_camera_015 (C)'],
                   'item_missiletank_010': ['collision_camera_045 (C)'],
                   'item_missiletank_011': ['collision_camera_055 (C)'],
                   'item_missiletank_012': ['collision_camera_061 (C)'],
                   'item_missiletankplus_000': ['collision_camera_025 (C)'],
                   'item_powerbombtank_000': ['collision_camera_015 (C)'],
                   'item_powerbombtank_001': ['collision_camera_044 (C)'],
                   'item_powerbombtank_002': ['collision_camera_029 (C)'],
                   'itemsphere_diffusionbeam': ['collision_camera_044 (C)'],
                   'lavazone': ['collision_camera_012 (C)'],
                   'lavazone_000': [],
                   'lavazone_001': ['collision_camera_049 (C)'],
                   'lavazone_002': ['collision_camera_021 (C)'],
                   'lavazone_003': ['collision_camera_019 (C)'],
                   'lavazone_004': ['collision_camera_019 (C)'],
                   'lavazone_005': [],
                   'lavazone_006': ['collision_camera_051 (C)'],
                   'lavazone_007': ['collision_camera_061 (C)'],
                   'lavazone_008': ['collision_camera_061 (C)'],
                   'lavazone_009': ['collision_camera_024 (C)'],
                   'lavazone_010': ['collision_camera_024 (C)'],
                   'lavazone_011': ['collision_camera_038 (C)'],
                   'lavazone_012': ['collision_camera_043 (C)'],
                   'lavazone_013': ['collision_camera_026 (C)'],
                   'lavazone_014': ['collision_camera_015 (C)'],
                   'lavazone_015': ['collision_camera_063 (C)'],
                   'magnetsurface': ['collision_camera_019 (C)'],
                   'magnetsurface_000': ['collision_camera_019 (C)'],
                   'magnetsurface_001': ['collision_camera_051 (C)'],
                   'magnetsurface_002': ['collision_camera_063 (C)'],
                   'magnetsurface_003': ['collision_camera_036 (C)'],
                   'magnetsurface_004': ['collision_camera_028 (C)'],
                   'magnetsurface_005': ['collision_camera_032 (C)'],
                   'magnetsurface_006': ['collision_camera_036 (C)'],
                   'magnetsurface_007': ['collision_camera_035 (C)'],
                   'magnetsurface_008': ['collision_camera_031 (C)'],
                   'magnetsurface_009': ['collision_camera_031 (C)'],
                   'magnetsurface_010': ['collision_camera_031 (C)'],
                   'magnetsurface_011': ['collision_camera_032 (C)'],
                   'magnetsurface_012': ['collision_camera_042 (C)'],
                   'magnetsurface_013': ['collision_camera_014 (C)'],
                   'magnetsurface_014': ['collision_camera_028 (C)'],
                   'magnetsurface_015': ['collision_camera_042 (C)'],
                   'magnetsurface_016': ['collision_camera_055 (C)'],
                   'magnetsurface_017': ['collision_camera_009 (C)'],
                   'magnetsurface_018': ['collision_camera_010 (C)'],
                   'magnetsurface_019': ['collision_camera_000 (C)'],
                   'magnetsurface_020': ['collision_camera_000 (C)'],
                   'magnetsurface_021': ['collision_camera_014 (C)'],
                   'magnetsurface_022': ['collision_camera_018 (C)'],
                   'magnetsurface_023': ['collision_camera_028 (C)'],
                   'magnetsurface_024': ['collision_camera_020 (C)'],
                   'magnetsurface_025': ['collision_camera_046 (C)'],
                   'magnetsurface_026': ['collision_camera_032 (C)'],
                   'magnetsurface_027': ['collision_camera_032 (C)'],
                   'magnetsurface_028': ['collision_camera_010 (C)'],
                   'magnetsurface_029': ['collision_camera_028 (C)'],
                   'magnetsurface_030': ['collision_camera_036 (C)'],
                   'magnetsurface_031': ['collision_camera_028 (C)'],
                   'magnetsurface_032': ['collision_camera_029 (C)'],
                   'magnetsurface_033': ['collision_camera_059 (C)'],
                   'magnetsurface_034': ['collision_camera_059 (C)'],
                   'magnetsurface_035': ['collision_camera_020 (C)'],
                   'magnetsurface_036': ['collision_camera_020 (C)'],
                   'magnetsurface_037': ['collision_camera_020 (C)'],
                   'magnetsurface_038': ['collision_camera_046 (C)'],
                   'magnetsurface_039': ['collision_camera_032 (C)'],
                   'magnetsurface_040': ['collision_camera_032 (C)'],
                   'magnetsurface_041': ['collision_camera_032 (C)'],
                   'magnetsurface_042': ['collision_camera_010 (C)'],
                   'magnetsurface_043': ['collision_camera_010 (C)'],
                   'magnetsurface_044': ['collision_camera_063 (C)'],
                   'magnetsurface_045': ['collision_camera_061 (C)'],
                   'magnetsurface_046': ['collision_camera_026 (C)'],
                   'maproom': ['collision_camera_030 (C)'],
                   'maproom_platform': ['collision_camera_030 (C)'],
                   'mblauncher_exit_gen_001': ['collision_camera_009 (C)'],
                   'mblauncher_exit_gen_002': ['collision_camera_063 (C)',
                                               'collision_camera_063_Stage_002 (C)'],
                   'mblauncher_exit_gen_003': ['collision_camera_063 (C)',
                                               'collision_camera_063_Stage_002 (C)'],
                   'mblauncher_launcher_gen_001': ['collision_camera_004 (C)'],
                   'mblauncher_launcher_gen_002': ['collision_camera_063 (C)',
                                                   'collision_camera_063_Stage_002 (C)'],
                   'mblauncher_launcher_gen_003': ['collision_camera_063 (C)',
                                                   'collision_camera_063_Stage_002 (C)'],
                   'nofreezeroom_000': ['collision_camera_009 (C)', 'collision_camera_CooldownX (C)'],
                   'pistonmag01': ['collision_camera_038 (C)'],
                   'pistonmag01_000': ['collision_camera_012 (C)'],
                   'pistonmag01_001': [],
                   'pistonmag01_off': [],
                   'pistonmag01_off_post': [],
                   'rail_magnet_mg_001': ['collision_camera_015 (C)'],
                   'rail_magnet_mg_003': ['collision_camera_042 (C)'],
                   'savestation_000': ['collision_camera_062 (C)'],
                   'savestation_000_platform': ['collision_camera_062 (C)'],
                   'savestation_001': ['collision_camera_033 (C)'],
                   'savestation_001_platform': ['collision_camera_033 (C)'],
                   'sg_vignette_prevent_001': ['collision_camera_026 (C)'],
                   'shootactivatormag01': ['collision_camera_038 (C)'],
                   'shootactivatormag01_000': ['collision_camera_012 (C)'],
                   'shootactivatormag01_001': [],
                   'shootactivatormag01fakeblock_000': ['collision_camera_012 (C)'],
                   'shootactivatoroff_000': [],
                   'shootactivatoroff_000_post': [],
                   'spawnpointrinka_000': ['collision_camera_037 (C)'],
                   'spawnpointrinka_001': ['collision_camera_037 (C)'],
                   'steammag01': ['collision_camera_000 (C)'],
                   'steammag01_000': ['collision_camera_000 (C)'],
                   'steammag01_001': ['collision_camera_000 (C)'],
                   'steammag01_002': ['collision_camera_000 (C)'],
                   'steammag01_003': ['collision_camera_000 (C)'],
                   'steammag01_004': ['collision_camera_000 (C)'],
                   'steammag01_005': ['collision_camera_000 (C)'],
                   'steammag01_006': ['collision_camera_000 (C)'],
                   'steammag01_007': ['collision_camera_000 (C)'],
                   'steammag01_008': ['collision_camera_000 (C)'],
                   'steammag01_009': ['collision_camera_000 (C)'],
                   'steammag01_010': ['collision_camera_040 (C)'],
                   'steammag01_011': ['collision_camera_040 (C)'],
                   'steammag01_012': ['collision_camera_040 (C)'],
                   'steammag01_013': ['collision_camera_040 (C)'],
                   'steammag01_014': ['collision_camera_038 (C)'],
                   'steammag01_015': ['collision_camera_038 (C)'],
                   'steammag01_016': ['collision_camera_012 (C)'],
                   'steammag01_017': ['collision_camera_012 (C)'],
                   'steammag01_018': ['collision_camera_012 (C)'],
                   'teleport_baselab_000': ['collision_camera_051 (C)'],
                   'teleport_baselab_000_platform': ['collision_camera_051 (C)'],
                   'teleporter_cave_000': ['collision_camera_015 (C)'],
                   'teleporter_cave_000_platform': ['collision_camera_015 (C)'],
                   'teleporter_forest_000': ['collision_camera_026 (C)'],
                   'teleporter_forest_000_platform': ['collision_camera_026 (C)'],
                   'totalrechargestation': ['collision_camera_007 (C)'],
                   'totalrechargestation_000': ['collision_camera_016 (C)'],
                   'trap_thermal_horizontal': ['collision_camera_042 (C)'],
                   'trap_thermal_horizontal_000': ['collision_camera_009 (C)'],
                   'trap_thermal_horizontal_001': ['collision_camera_010 (C)'],
                   'trap_thermal_horizontal_002': ['collision_camera_012 (C)'],
                   'trap_thermal_horizontal_003': ['collision_camera_032 (C)'],
                   'trap_thermal_horizontal_004': ['collision_camera_004 (C)'],
                   'trap_thermal_horizontal_005': ['collision_camera_009 (C)'],
                   'trap_thermal_horizontal_POSTCOOL': ['collision_camera_009 (C)'],
                   'trap_thermal_horizontal_PRECOOL': ['collision_camera_009 (C)'],
                   'videomanager_000': ['collision_camera_036 (C)'],
                   'wagontrain_baselab_000': ['collision_camera_041 (C)'],
                   'wagontrain_baselab_000_platform': ['collision_camera_041 (C)'],
                   'weightactivatedplatform_000': ['collision_camera_023 (C)'],
                   'weightactivatedplatform_002': ['collision_camera_018 (C)'],
                   'weightactivatedplatform_003': ['collision_camera_042 (C)'],
                   'weightactivatedplatform_004': ['collision_camera_034 (C)'],
                   'weightactivatedplatform_005': ['collision_camera_004 (C)'],
                   'weightactivatedplatform_006': ['collision_camera_042 (C)'],
                   'weightactivatedplatform_total': ['collision_camera_007 (C)'],
                   'weightactivatedplatform_total_000': ['collision_camera_016 (C)'],
                   'zipline_bottom_gen_001': [],
                   'zipline_bottom_gen_002': ['collision_camera_025 (C)'],
                   'zipline_bottom_gen_003': ['collision_camera_020 (C)'],
                   'zipline_right_gen_001': ['collision_camera_025 (C)'],
                   'zipline_right_gen_002': ['collision_camera_015 (C)'],
                   'zipline_right_gen_003': ['collision_camera_035 (C)']},
    's030_baselab': {'AP_04': [],
                     'AP_06': ['collision_camera_044 (D)'],
                     'CAM_Default': [],
                     'CAM_PowerGenerator': ['collision_camera_007 (D)'],
                     'CAM_ShakernautEvent': ['collision_camera_022 (D)'],
                     'CAM_Train': ['collision_camera_043 (D)'],
                     'CoolShineLeftVisited': ['collision_camera_016 (D)'],
                     'CoolShineUpViewed': ['collision_camera_016 (D)'],
                     'CoolShineUpVisited': ['collision_camera_016 (D)'],
                     'LE_WorldGraph': [],
                     'LM_EmmyDestroySearch': ['collision_camera_040 (D)'],
                     'LM_EmmyEntrancePoint_000': ['collision_camera_018 (D)'],
                     'LM_EmmyEntrancePoint_001': ['collision_camera_018 (D)'],
                     'LM_EmmyEntrancePoint_002': ['collision_camera_018 (D)'],
                     'LM_EmmyEntrancePoint_003': ['collision_camera_005 (D)'],
                     'LM_EmmyEntrancePoint_004': ['collision_camera_005 (D)'],
                     'LM_EmmyEntrancePoint_005': ['collision_camera_005 (D)'],
                     'LM_EmmyEntrancePoint_006': ['collision_camera_018 (D)'],
                     'LM_EmmyEntrancePoint_007': ['collision_camera_005 (D)'],
                     'LM_EmmyEntrancePoint_010': ['collision_camera_017 (D)'],
                     'LM_EmmyEntrancePoint_011': ['collision_camera_017 (D)'],
                     'LM_EmmyEntrancePoint_012': ['collision_camera_017 (D)'],
                     'LM_EmmyEntrancePoint_013': ['collision_camera_017 (D)'],
                     'LM_EmmyEntrancePoint_015': ['collision_camera_016 (D)'],
                     'LM_EmmyEntrancePoint_016': ['collision_camera_016 (D)'],
                     'LM_EmmyEntrancePoint_017': ['collision_camera_016 (D)'],
                     'LM_EmmyEntrancePoint_019': ['collision_camera_016 (D)'],
                     'LM_EmmyEntrancePoint_020': ['collision_camera_016 (D)'],
                     'LM_EmmyEntrancePoint_021': ['collision_camera_029 (D)'],
                     'LM_EmmyEntrancePoint_022': ['collision_camera_027 (D)'],
                     'LM_EmmyEntrancePoint_023': ['collision_camera_027 (D)'],
                     'LM_EmmyEntrancePoint_024': ['collision_camera_029 (D)'],
                     'LM_EmmyEntrancePoint_025': ['collision_camera_029 (D)'],
                     'LM_EmmyEntrancePoint_026': ['collision_camera_036 (D)'],
                     'LM_EmmyEntrancePoint_027': ['collision_camera_037 (D)'],
                     'LM_EmmyEntrancePoint_028': ['collision_camera_037 (D)'],
                     'LM_EmmyEntrancePoint_029': ['collision_camera_037 (D)'],
                     'LM_EmmyPresentation': ['collision_camera_018 (D)'],
                     'LM_EmmySpawnAfterAqua': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_000': ['collision_camera_040 (D)'],
                     'LS_EMMYIMPASSABLE_001': ['collision_camera_017 (D)'],
                     'LS_EMMYIMPASSABLE_002': ['collision_camera_017 (D)'],
                     'LS_EMMYIMPASSABLE_003': ['collision_camera_036 (D)'],
                     'LS_EMMYIMPASSABLE_004': ['collision_camera_016 (D)'],
                     'LS_EMMYIMPASSABLE_005': ['collision_camera_016 (D)'],
                     'LS_EMMYIMPASSABLE_006': ['collision_camera_017 (D)'],
                     'LS_EMMYIMPASSABLE_007': ['collision_camera_027 (D)'],
                     'LS_EMMYIMPASSABLE_008': ['collision_camera_029 (D)'],
                     'LS_EMMYIMPASSABLE_009': ['collision_camera_029 (D)'],
                     'LS_EMMYIMPASSABLE_010': ['collision_camera_029 (D)'],
                     'LS_EMMYIMPASSABLE_011': ['collision_camera_040 (D)'],
                     'LS_EMMYIMPASSABLE_012': ['collision_camera_040 (D)'],
                     'LS_EMMYIMPASSABLE_013': ['collision_camera_040 (D)'],
                     'LS_EMMYIMPASSABLE_014': ['collision_camera_018 (D)'],
                     'LS_EMMYIMPASSABLE_015': ['collision_camera_005 (D)'],
                     'LS_EMMYIMPASSABLE_016': ['collision_camera_018 (D)'],
                     'LS_EMMYIMPASSABLE_017': ['collision_camera_027 (D)'],
                     'LS_EMMYIMPASSABLE_018': ['collision_camera_040 (D)'],
                     'LS_EMMYIMPASSABLE_019': ['collision_camera_040 (D)'],
                     'LS_EMMYIMPASSABLE_020': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_021': ['collision_camera_005 (D)'],
                     'LS_EMMYIMPASSABLE_022': ['collision_camera_005 (D)'],
                     'LS_EMMYIMPASSABLE_023': ['collision_camera_005 (D)'],
                     'LS_EMMYIMPASSABLE_024': ['collision_camera_027 (D)'],
                     'LS_EMMYIMPASSABLE_025': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_026': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_027': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_028': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_029': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_030': ['collision_camera_018 (D)'],
                     'LS_EMMYIMPASSABLE_031': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_032': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_033': ['collision_camera_029 (D)'],
                     'LS_EMMYIMPASSABLE_034': ['collision_camera_029 (D)'],
                     'LS_EMMYIMPASSABLE_035': ['collision_camera_029 (D)'],
                     'LS_EMMYIMPASSABLE_036': ['collision_camera_037 (D)'],
                     'LS_EMMYIMPASSABLE_037': ['collision_camera_016 (D)', 'collision_camera_027 (D)'],
                     'LS_EmmyZone': ['collision_camera_018 (D)'],
                     'LS_Lab_RinkaLifeArea': ['collision_camera_038 (D)'],
                     'LS_PATROLEMMY_01': ['collision_camera_018 (D)'],
                     'LS_PATROLEMMY_02': ['collision_camera_018 (D)'],
                     'LS_PATROLEMMY_03': ['collision_camera_017 (D)'],
                     'LS_PATROLEMMY_04': ['collision_camera_016 (D)'],
                     'LS_PATROLEMMY_05': ['collision_camera_016 (D)'],
                     'LS_PATROLEMMY_06': ['collision_camera_016 (D)'],
                     'LS_PATROLEMMY_07': ['collision_camera_029 (D)'],
                     'LS_PATROLEMMY_08': ['collision_camera_029 (D)'],
                     'LS_PATROLEMMY_09': ['collision_camera_040 (D)'],
                     'LS_PATROLEMMY_10': ['collision_camera_040 (D)'],
                     'LS_PATROLEMMY_11': ['collision_camera_005 (D)'],
                     'LS_PATROLEMMY_12': ['collision_camera_040 (D)'],
                     'LS_PATROLEMMY_13': ['collision_camera_037 (D)'],
                     'LS_PATROLEMMY_14': ['collision_camera_037 (D)'],
                     'PoolViewed': ['collision_camera_025 (D)'],
                     'PoolVisited': ['collision_camera_025 (D)'],
                     'Rail_Train': ['collision_camera_043 (D)'],
                     'SG_Lab_Cannons': ['collision_camera_038 (D)'],
                     'SP_AccessPoint_4': ['collision_camera_013 (D)'],
                     'SP_Checkpoint_AfterAqua': ['collision_camera_045 (D)'],
                     'SP_Checkpoint_AfterDiffusion': ['collision_camera_008 (D)'],
                     'SP_Checkpoint_AfterProfessor': ['collision_camera_019 (D)'],
                     'SP_Checkpoint_Blackout': ['collision_camera_004 (D)'],
                     'SP_Checkpoint_Blackout2': ['collision_camera_020 (D)'],
                     'SP_Checkpoint_Bomb': ['collision_camera_021 (D)'],
                     'SP_Checkpoint_CentralUnit': ['collision_camera_040 (D)'],
                     'SP_Checkpoint_EmmyBaseLab': ['collision_camera_004 (D)'],
                     'SP_Checkpoint_EmmyLabPhase2': ['collision_camera_038 (D)'],
                     'SP_Checkpoint_SpeedBooster': ['collision_camera_040 (D)'],
                     'SP_Emmy': ['collision_camera_017 (D)'],
                     'SP_Lab_CUCannon': ['collision_camera_038 (D)'],
                     'SP_Lab_Rinka_000': ['collision_camera_038 (D)'],
                     'SP_Lab_Rinka_001': ['collision_camera_038 (D)'],
                     'SP_Lab_Rinka_002': ['collision_camera_038 (D)'],
                     'SP_WideBeam': ['collision_camera_006 (D)'],
                     'StartPoint0': ['collision_camera_043 (D)'],
                     'TG_CombatCU': ['collision_camera_038 (D)'],
                     'TG_Cool_Shinespark_Begin': ['collision_camera_016 (D)'],
                     'TG_Cool_Shinespark_End': ['collision_camera_016 (D)'],
                     'TG_EmmyLAB_Deactivation': ['collision_camera_004 (D)'],
                     'TG_EmmySpawnAfterAqua': ['collision_camera_045 (D)'],
                     'TG_EmmyUnlockDoors': ['collision_camera_037 (D)'],
                     'TG_MapCoolShineLeft': ['collision_camera_033 (D)'],
                     'TG_MapCoolShineUp': ['collision_camera_016 (D)'],
                     'TG_PATROLEMMYACTIVATOR_01': ['collision_camera_000 (D)'],
                     'TG_PATROLEMMYACTIVATOR_02': ['collision_camera_018 (D)'],
                     'TG_PATROLEMMYACTIVATOR_03': ['collision_camera_017 (D)'],
                     'TG_PATROLEMMYACTIVATOR_04': ['collision_camera_026 (D)'],
                     'TG_PATROLEMMYACTIVATOR_05': ['collision_camera_033 (D)'],
                     'TG_PATROLEMMYACTIVATOR_06': ['collision_camera_015 (D)'],
                     'TG_PATROLEMMYACTIVATOR_07': ['collision_camera_027 (D)'],
                     'TG_PATROLEMMYACTIVATOR_08': ['collision_camera_031 (D)'],
                     'TG_PATROLEMMYACTIVATOR_09': ['collision_camera_029 (D)'],
                     'TG_PATROLEMMYACTIVATOR_10': ['collision_camera_039 (D)'],
                     'TG_PATROLEMMYACTIVATOR_11': ['collision_camera_005 (D)'],
                     'TG_PATROLEMMYACTIVATOR_12': ['collision_camera_040 (D)'],
                     'TG_PATROLEMMYACTIVATOR_13': ['collision_camera_037 (D)'],
                     'TG_PATROLEMMYACTIVATOR_14': ['collision_camera_037 (D)'],
                     'TG_VisitLauncherSection': ['collision_camera_021 (D)'],
                     'TG_VisitPool': ['collision_camera_025 (D)'],
                     'VisitLauncherSection': ['collision_camera_021 (D)'],
                     'accesspoint_000': ['collision_camera_014 (D)'],
                     'accesspoint_000_platform': ['collision_camera_014 (D)'],
                     'accesspoint_001': ['collision_camera_044 (D)'],
                     'accesspoint_001_platform': ['collision_camera_044 (D)'],
                     'ammorecharge_001': ['collision_camera_034 (D)'],
                     'ammorecharge_001_platform': ['collision_camera_034 (D)'],
                     'box_grapple_cv_001': ['collision_camera_003 (D)'],
                     'box_wide_cv_001': ['collision_camera_002 (D)'],
                     'box_wide_cv_002': ['collision_camera_019 (D)'],
                     'box_wide_cv_003': ['collision_camera_001 (D)'],
                     'box_wide_cv_004': ['collision_camera_004 (D)'],
                     'camerarailpath_PowerGenerator': ['collision_camera_007 (D)'],
                     'camerarailpath_ShakernautEvent': ['collision_camera_022 (D)'],
                     'centralunitlaboratory': ['collision_camera_038 (D)'],
                     'centralunitmagmacontroller': ['collision_camera_038 (D)'],
                     'db_dif_b1_001': ['collision_camera_008 (D)'],
                     'db_dif_b1_002': ['collision_camera_017 (D)'],
                     'db_hdoor_b1_001': ['collision_camera_010 (D)'],
                     'db_reg_b1_001': ['collision_camera_025 (D)'],
                     'db_reg_b1_002': ['collision_camera_025 (D)'],
                     'db_reg_b1_003': ['collision_camera_024 (D)'],
                     'db_reg_b1_005': ['collision_camera_004 (D)'],
                     'door_frblack_gen_000': ['collision_camera_040 (D)'],
                     'door_frblack_gen_001': ['collision_camera_037 (D)', 'collision_camera_040 (D)'],
                     'door_frblack_gen_002': ['collision_camera_037 (D)', 'collision_camera_040 (D)'],
                     'doorcentralunit': ['collision_camera_040 (D)'],
                     'doorchargecharge_000': ['collision_camera_037 (D)', 'collision_camera_040 (D)'],
                     'doorchargecharge_001': ['collision_camera_013 (D)', 'collision_camera_014 (D)'],
                     'doorchargecharge_002': ['collision_camera_010 (D)', 'collision_camera_013 (D)'],
                     'doorchargeclosed_000': ['collision_camera_005 (D)', 'collision_camera_018 (D)'],
                     'doorchargeclosed_001': ['collision_camera_011 (D)', 'collision_camera_012 (D)'],
                     'doorclosedcharge_000': ['collision_camera_033 (D)', 'collision_camera_034 (D)'],
                     'dooremmy_000': ['collision_camera_004 (D)', 'collision_camera_018 (D)'],
                     'dooremmy_001': ['collision_camera_002 (D)', 'collision_camera_005 (D)'],
                     'dooremmy_002': ['collision_camera_003 (D)', 'collision_camera_005 (D)'],
                     'dooremmy_003': ['collision_camera_017 (D)', 'collision_camera_019 (D)'],
                     'dooremmy_004': ['collision_camera_017 (D)', 'collision_camera_020 (D)'],
                     'dooremmy_005': ['collision_camera_016 (D)', 'collision_camera_026 (D)'],
                     'dooremmy_006': ['collision_camera_015 (D)', 'collision_camera_016 (D)'],
                     'dooremmy_007': ['collision_camera_016 (D)', 'collision_camera_033 (D)'],
                     'dooremmy_008': ['collision_camera_027 (D)', 'collision_camera_028 (D)'],
                     'dooremmy_009': ['collision_camera_029 (D)', 'collision_camera_030 (D)'],
                     'dooremmy_010': ['collision_camera_036 (D)', 'collision_camera_039 (D)'],
                     'dooremmy_011': ['collision_camera_034 (D)', 'collision_camera_037 (D)'],
                     'dooremmy_012': ['collision_camera_037 (D)', 'collision_camera_041 (D)'],
                     'doorframe_000': ['collision_camera_037 (D)', 'collision_camera_040 (D)'],
                     'doorpowerclosed_000': ['collision_camera_021 (D)', 'collision_camera_022 (D)'],
                     'doorpowerpower': ['collision_camera_029 (D)', 'collision_camera_036 (D)'],
                     'doorpowerpower_000': ['collision_camera_000 (D)', 'collision_camera_001 (D)'],
                     'doorpowerpower_001': ['collision_camera_000 (D)', 'collision_camera_002 (D)'],
                     'doorpowerpower_002': ['collision_camera_016 (D)', 'collision_camera_027 (D)'],
                     'doorpowerpower_003': ['collision_camera_027 (D)', 'collision_camera_029 (D)'],
                     'doorpowerpower_004': ['collision_camera_014 (D)', 'collision_camera_015 (D)'],
                     'doorpowerpower_007': ['collision_camera_010 (D)', 'collision_camera_012 (D)'],
                     'doorpowerpower_009': ['collision_camera_031 (D)', 'collision_camera_032 (D)'],
                     'doorpowerpower_010': ['collision_camera_004 (D)', 'collision_camera_006 (D)'],
                     'doorpowerpower_011': ['collision_camera_008 (D)', 'collision_camera_010 (D)'],
                     'doorpowerpower_012': ['collision_camera_016 (D)', 'collision_camera_017 (D)'],
                     'doorpowerpower_013': ['collision_camera_019 (D)', 'collision_camera_044 (D)'],
                     'doorpowerpower_014': ['collision_camera_019 (D)', 'collision_camera_044 (D)'],
                     'doorpowerpower_015': ['collision_camera_001 (D)', 'collision_camera_043 (D)'],
                     'doorpowerpower_016': ['collision_camera_039 (D)', 'collision_camera_046 (D)'],
                     'doorpowerpower_017': ['collision_camera_041 (D)', 'collision_camera_045 (D)'],
                     'doorpowerpower_018': ['collision_camera_008 (D)', 'collision_camera_009 (D)'],
                     'doorpowerpower_019': ['collision_camera_004 (D)', 'collision_camera_009 (D)'],
                     'doorpowerpower_020': ['collision_camera_007 (D)', 'collision_camera_008 (D)'],
                     'doorpowerpower_021': ['collision_camera_006 (D)', 'collision_camera_008 (D)'],
                     'doorpowerpower_022': ['collision_camera_020 (D)', 'collision_camera_022 (D)'],
                     'doorpowerpower_023': ['collision_camera_022 (D)', 'collision_camera_026 (D)'],
                     'doorpowerpower_025': ['collision_camera_022 (D)', 'collision_camera_023 (D)'],
                     'doorpowerpower_026': ['collision_camera_023 (D)', 'collision_camera_025 (D)'],
                     'doorpowerpower_027': ['collision_camera_024 (D)', 'collision_camera_025 (D)'],
                     'doorpowerpower_028': ['collision_camera_025 (D)', 'collision_camera_042 (D)'],
                     'doorpowerpower_029': ['collision_camera_028 (D)', 'collision_camera_030 (D)'],
                     'doorpowerpower_030': ['collision_camera_025 (D)', 'collision_camera_042 (D)'],
                     'doorshieldmissile_000': ['collision_camera_006 (D)', 'collision_camera_008 (D)'],
                     'doorshieldmissile_001': ['collision_camera_021 (D)', 'collision_camera_022 (D)'],
                     'doorshutter_001': ['collision_camera_018 (D)'],
                     'doorshutter_002': ['collision_camera_037 (D)'],
                     'doorshutter_004': ['collision_camera_005 (D)'],
                     'doorwidebeam_000': ['collision_camera_004 (D)', 'collision_camera_006 (D)'],
                     'doorwidebeam_001': ['collision_camera_008 (D)', 'collision_camera_010 (D)'],
                     'doorwidebeam_002': ['collision_camera_004 (D)', 'collision_camera_006 (D)'],
                     'elevator_cave_000': ['collision_camera_011 (D)'],
                     'elevator_cave_000_platform': ['collision_camera_011 (D)'],
                     'elevator_forest_000': ['collision_camera_047 (D)'],
                     'elevator_forest_000_platform': ['collision_camera_047 (D)'],
                     'elevator_sanctuary_000': ['collision_camera_003 (D)'],
                     'elevator_sanctuary_000_platform': ['collision_camera_003 (D)'],
                     'elevator_sanctuary_001': ['collision_camera_019 (D)'],
                     'elevator_sanctuary_001_platform': ['collision_camera_019 (D)'],
                     'emergency_light_000': ['collision_camera_009 (D)'],
                     'emergency_light_001': ['collision_camera_008 (D)'],
                     'emergency_light_002': ['collision_camera_020 (D)'],
                     'emergency_light_003': ['collision_camera_022 (D)'],
                     'emergency_light_004': ['collision_camera_022 (D)'],
                     'emergency_light_005': ['collision_camera_026 (D)'],
                     'emergency_light_006': ['collision_camera_022 (D)'],
                     'emergency_light_007': ['collision_camera_025 (D)'],
                     'emergency_light_008': ['collision_camera_025 (D)'],
                     'emergency_light_009': ['collision_camera_028 (D)'],
                     'emergency_light_010': ['collision_camera_030 (D)'],
                     'emergency_light_011': ['collision_camera_023 (D)'],
                     'emergency_light_012': ['collision_camera_023 (D)'],
                     'emmyvalve_reg_gen_000': ['collision_camera_018 (D)'],
                     'emmyvalve_reg_gen_001': ['collision_camera_018 (D)'],
                     'emmyvalve_reg_gen_002': ['collision_camera_017 (D)', 'collision_camera_018 (D)'],
                     'emmyvalve_reg_gen_003': ['collision_camera_017 (D)'],
                     'emmyvalve_reg_gen_004': ['collision_camera_016 (D)'],
                     'emmyvalve_reg_gen_005': ['collision_camera_016 (D)'],
                     'emmyvalve_reg_gen_008': ['collision_camera_027 (D)'],
                     'emmyvalve_reg_gen_009': ['collision_camera_029 (D)'],
                     'emmyvalve_reg_gen_010': ['collision_camera_036 (D)'],
                     'emmyvalve_reg_gen_011': ['collision_camera_040 (D)'],
                     'emmyvalve_reg_gen_012': ['collision_camera_037 (D)'],
                     'emmyvalve_reg_gen_013': ['collision_camera_040 (D)'],
                     'emmyvalve_reg_gen_014': ['collision_camera_017 (D)'],
                     'emmyvalve_reg_gen_015': ['collision_camera_017 (D)'],
                     'emmyvalve_reg_gen_016': ['collision_camera_037 (D)'],
                     'emmyvalve_reg_gen_017': ['collision_camera_037 (D)'],
                     'energyrecharge_000': ['collision_camera_015 (D)'],
                     'energyrecharge_000_platform': ['collision_camera_015 (D)'],
                     'energyrecharge_001': ['collision_camera_042 (D)'],
                     'energyrecharge_001_platform': ['collision_camera_042 (D)'],
                     'energyrecharge_002': ['collision_camera_001 (D)'],
                     'energyrecharge_002_platform': ['collision_camera_001 (D)'],
                     'env_frozen_gen_001': ['collision_camera_025 (D)'],
                     'env_heat_gen_001': ['collision_camera_013 (D)'],
                     'footstepplatform_001': ['collision_camera_018 (D)'],
                     'footstepplatform_002': ['collision_camera_037 (D)'],
                     'footstepplatform_004': ['collision_camera_005 (D)'],
                     'fx_cold_door': ['collision_camera_025 (D)', 'collision_camera_042 (D)'],
                     'fx_cold_door_000': ['collision_camera_025 (D)', 'collision_camera_042 (D)'],
                     'fx_cold_door_001': ['collision_camera_024 (D)', 'collision_camera_025 (D)'],
                     'fx_cold_door_002': ['collision_camera_023 (D)', 'collision_camera_025 (D)'],
                     'fx_heat_door': ['collision_camera_013 (D)', 'collision_camera_014 (D)'],
                     'fx_heat_door_000': ['collision_camera_008 (D)', 'collision_camera_010 (D)'],
                     'grapplepulloff1x2': ['collision_camera_026 (D)'],
                     'grapplepulloff1x2_000': ['collision_camera_012 (D)'],
                     'grapplepulloff1x2_001': ['collision_camera_012 (D)'],
                     'grapplepulloff1x2_002': ['collision_camera_020 (D)'],
                     'grapplepulloff1x2_003': ['collision_camera_035 (D)'],
                     'grapplepulloff1x2_005': ['collision_camera_030 (D)'],
                     'grapplepulloff1x2_006': ['collision_camera_011 (D)'],
                     'grapplepulloff1x2_007': ['collision_camera_004 (D)'],
                     'grappleswingpoint_000': ['collision_camera_004 (D)'],
                     'grappleswingpoint_001': ['collision_camera_004 (D)'],
                     'grappleswingpoint_002': ['collision_camera_004 (D)'],
                     'grappleswingpoint_003': ['collision_camera_004 (D)'],
                     'item_energyfragment_000': ['collision_camera_018 (D)'],
                     'item_energyfragment_001': ['collision_camera_010 (D)'],
                     'item_energyfragment_002': ['collision_camera_042 (D)'],
                     'item_energyfragment_003': ['collision_camera_040 (D)'],
                     'item_energytank': ['collision_camera_016 (D)'],
                     'item_missiletank': ['collision_camera_004 (D)'],
                     'item_missiletank_000': ['collision_camera_001 (D)'],
                     'item_missiletank_001': ['collision_camera_030 (D)'],
                     'item_missiletank_002': ['collision_camera_012 (D)'],
                     'item_missiletank_003': ['collision_camera_021 (D)'],
                     'item_missiletank_004': ['collision_camera_012 (D)'],
                     'item_missiletank_005': ['collision_camera_020 (D)'],
                     'item_missiletank_006': ['collision_camera_025 (D)'],
                     'item_missiletank_007': ['collision_camera_027 (D)'],
                     'item_missiletank_008': ['collision_camera_025 (D)'],
                     'item_missiletank_010': ['collision_camera_031 (D)'],
                     'item_missiletankplus_000': ['collision_camera_033 (D)'],
                     'item_powerbombtank_000': ['collision_camera_011 (D)'],
                     'item_powerbombtank_001': ['collision_camera_035 (D)'],
                     'item_powerbombtank_002': ['collision_camera_017 (D)'],
                     'itemsphere_bomb': ['collision_camera_021 (D)'],
                     'itemsphere_widebeam': ['collision_camera_006 (D)'],
                     'lavazone_000': ['collision_camera_012 (D)'],
                     'lavazone_001': ['collision_camera_010 (D)'],
                     'lavazone_002': ['collision_camera_013 (D)'],
                     'magnetsurface': ['collision_camera_027 (D)'],
                     'magnetsurface_000': ['collision_camera_001 (D)'],
                     'magnetsurface_001': ['collision_camera_017 (D)'],
                     'magnetsurface_002': ['collision_camera_001 (D)'],
                     'magnetsurface_003': ['collision_camera_002 (D)'],
                     'magnetsurface_004': ['collision_camera_037 (D)'],
                     'magnetsurface_005': ['collision_camera_011 (D)'],
                     'magnetsurface_006': ['collision_camera_008 (D)'],
                     'magnetsurface_007': ['collision_camera_037 (D)'],
                     'magnetsurface_008': ['collision_camera_017 (D)'],
                     'magnetsurface_009': ['collision_camera_015 (D)'],
                     'magnetsurface_010': ['collision_camera_016 (D)'],
                     'magnetsurface_011': ['collision_camera_016 (D)'],
                     'magnetsurface_012': ['collision_camera_027 (D)'],
                     'magnetsurface_013': ['collision_camera_037 (D)'],
                     'magnetsurface_014': ['collision_camera_016 (D)'],
                     'magnetsurface_015': ['collision_camera_016 (D)'],
                     'magnetsurface_016': ['collision_camera_037 (D)'],
                     'magnetsurface_017': ['collision_camera_016 (D)'],
                     'magnetsurface_018': ['collision_camera_037 (D)'],
                     'magnetsurface_019': ['collision_camera_037 (D)'],
                     'magnetsurface_020': ['collision_camera_027 (D)'],
                     'magnetsurface_021': ['collision_camera_029 (D)'],
                     'magnetsurface_022': ['collision_camera_029 (D)'],
                     'magnetsurface_023': ['collision_camera_029 (D)'],
                     'magnetsurface_024': ['collision_camera_036 (D)'],
                     'magnetsurface_025': ['collision_camera_037 (D)'],
                     'magnetsurface_026': ['collision_camera_036 (D)'],
                     'magnetsurface_027': ['collision_camera_005 (D)'],
                     'magnetsurface_028': ['collision_camera_039 (D)'],
                     'magnetsurface_029': ['collision_camera_031 (D)'],
                     'magnetsurface_030': ['collision_camera_018 (D)'],
                     'magnetsurface_031': ['collision_camera_016 (D)'],
                     'magnetsurface_032': ['collision_camera_016 (D)'],
                     'magnetsurface_033': ['collision_camera_016 (D)'],
                     'magnetsurface_034': ['collision_camera_025 (D)'],
                     'magnetsurface_035': ['collision_camera_017 (D)'],
                     'magnetsurface_036': ['collision_camera_017 (D)'],
                     'magnetsurface_037': ['collision_camera_016 (D)'],
                     'magnetsurface_038': ['collision_camera_016 (D)'],
                     'magnetsurface_039': ['collision_camera_022 (D)'],
                     'magnetsurface_040': ['collision_camera_025 (D)'],
                     'magnetsurface_041': ['collision_camera_037 (D)'],
                     'maproom_000': ['collision_camera_023 (D)'],
                     'maproom_000_platform': ['collision_camera_023 (D)'],
                     'mblauncher_exit_gen_001': ['collision_camera_022 (D)'],
                     'mblauncher_exit_gen_002': ['collision_camera_028 (D)'],
                     'mblauncher_exit_gen_003': ['collision_camera_002 (D)'],
                     'mblauncher_launcher_gen_001': ['collision_camera_021 (D)'],
                     'mblauncher_launcher_gen_002': ['collision_camera_026 (D)'],
                     'mblauncher_launcher_gen_003': ['collision_camera_031 (D)'],
                     'mblauncher_launcher_gen_004': ['collision_camera_030 (D)'],
                     'mblauncher_launcher_gen_005': ['collision_camera_031 (D)'],
                     'mblauncher_launcher_gen_006': ['collision_camera_030 (D)'],
                     'mblauncher_launcher_gen_007': ['collision_camera_011 (D)'],
                     'mlm_block_000': ['collision_camera_033 (D)'],
                     'mlm_point_000': ['collision_camera_033 (D)'],
                     'mlm_point_001': ['collision_camera_033 (D)'],
                     'mlm_point_002': ['collision_camera_033 (D)'],
                     'mlm_point_003': ['collision_camera_033 (D)'],
                     'mlm_point_004': ['collision_camera_033 (D)'],
                     'portal_trainwagon_left': [],
                     'powergenerator_001': ['collision_camera_007 (D)'],
                     'powergenerator_001_platform': ['collision_camera_007 (D)'],
                     'powergenerator_002': ['collision_camera_024 (D)'],
                     'powergenerator_002_platform': ['collision_camera_024 (D)'],
                     'powergeneratorengine_001': ['collision_camera_007 (D)'],
                     'powergeneratorengine_002': ['collision_camera_024 (D)'],
                     'savestation_000': ['collision_camera_000 (D)'],
                     'savestation_000_platform': ['collision_camera_000 (D)'],
                     'savestation_001': ['collision_camera_032 (D)'],
                     'savestation_001_platform': ['collision_camera_032 (D)'],
                     'teleport_cave_000': ['collision_camera_001 (D)'],
                     'teleport_cave_000_platform': ['collision_camera_001 (D)'],
                     'teleport_magma_000': ['collision_camera_008 (D)'],
                     'teleport_magma_000_platform': ['collision_camera_008 (D)'],
                     'totalrechargestation_000': ['collision_camera_022 (D)'],
                     'totalrechargestation_001': ['collision_camera_009 (D)'],
                     'wagontrain_aqua_000': ['collision_camera_046 (D)'],
                     'wagontrain_aqua_000_platform': ['collision_camera_046 (D)'],
                     'wagontrain_aqua_001_platform': ['collision_camera_045 (D)'],
                     'wagontrain_magma_000': ['collision_camera_043 (D)'],
                     'wagontrain_magma_000_platform': ['collision_camera_043 (D)'],
                     'wagontrain_with_portal_aqua_001': ['collision_camera_045 (D)'],
                     'waterzone_000': ['collision_camera_035 (D)'],
                     'waterzone_001': ['collision_camera_041 (D)'],
                     'waterzone_002': ['collision_camera_039 (D)'],
                     'waterzone_003': ['collision_camera_039 (D)'],
                     'waterzone_004': ['collision_camera_039 (D)'],
                     'waterzone_005': [],
                     'waterzone_006': ['collision_camera_025 (D)'],
                     'weightactivatedplatform_total_000': ['collision_camera_022 (D)'],
                     'weightactivatedplatform_total_001': ['collision_camera_009 (D)'],
                     'zipline_bottom_gen_000': ['collision_camera_029 (D)'],
                     'zipline_bottom_gen_002': ['collision_camera_016 (D)'],
                     'zipline_left_gen_002': ['collision_camera_016 (D)'],
                     'zipline_right_gen_001': ['collision_camera_017 (D)'],
                     'zipline_right_gen_002': ['collision_camera_016 (D)']},
    's040_aqua': {'AP_05': ['collision_camera_009 (B)'],
                  'AP_09': ['collision_camera_016 (B)'],
                  'CAM_Default': [],
                  'CAM_Far': ['collision_camera_001 (B)'],
                  'CAM_Train': ['collision_camera_003 (B)'],
                  'LE_Platform_Teleport_Secret': ['collision_camera_008 (B)'],
                  'LE_Teleport_Secret': ['collision_camera_008 (B)'],
                  'Rail_Train': ['collision_camera_003 (B)'],
                  'SP_AccessPoint_5': ['collision_camera_001 (B)'],
                  'SP_AccessPoint_9': ['collision_camera_021 (B)'],
                  'SP_AccessPoint_9B': ['collision_camera_017 (B)'],
                  'SP_Checkpoint_Cooldown': ['collision_camera_017 (B)'],
                  'SP_Checkpoint_Dead_2RCW': ['collision_camera_021 (B)'],
                  'SP_Checkpoint_Demolition': ['collision_camera_021 (B)'],
                  'SP_Checkpoint_DoorProfessor': ['collision_camera_001 (B)'],
                  'SP_Checkpoint_GhostDash': ['collision_camera_010 (B)'],
                  'SP_Checkpoint_GhostDashObtained': ['collision_camera_014 (B)'],
                  'SP_Checkpoint_GravitySuit': ['collision_camera_023_B (B)'],
                  'SP_Checkpoint_Hydrogiga': ['collision_camera_005 (B)'],
                  'SP_Checkpoint_Hydrogiga_Dead': ['collision_camera_028 (B)'],
                  'SP_Checkpoint_Trench': ['collision_camera_015 (B)'],
                  'SP_Checkpoint_TwoChozoRobots_Aqua': ['collision_camera_021 (B)'],
                  'StartPoint0': ['collision_camera_003 (B)'],
                  'TG_Cam010_MusicChange': ['collision_camera_013 (B)'],
                  'TG_Cam010_MusicChange_000': ['collision_camera_013 (B)'],
                  'TG_Cam010_MusicChange_001': ['collision_camera_010 (B)'],
                  'TG_Cam010_MusicChange_002': ['collision_camera_010 (B)'],
                  'TG_Cam010_MusicChange_003': ['collision_camera_015 (B)'],
                  'TG_ChangeCamera_001_B': ['collision_camera_001 (B)'],
                  'TG_ChangeCamera_002': ['collision_camera_002 (B)'],
                  'TG_ChangeCamera_021': ['collision_camera_021 (B)'],
                  'TG_ChangeCamera_023_Enter': [],
                  'TG_ChangeCamera_023_Exit': [],
                  'TG_ChangeCamera_10': ['collision_camera_010 (B)'],
                  'TG_ChangeCamera_15': ['collision_camera_015 (B)'],
                  'TG_FlashShiftClose': ['collision_camera_014 (B)'],
                  'TG_GravitySuit_MusicChange': ['collision_camera_023_B (B)'],
                  'TG_IgnoreHangHydrogigaArena': ['collision_camera_007 (B)'],
                  'TG_KeepDirection_000': ['collision_camera_028 (B)', 'collision_camera_029 (B)'],
                  'TG_KeepDirection_001': ['collision_camera_007 (B)'],
                  'TG_MusicChange_021_nodelay': ['collision_camera_023_B (B)'],
                  'TG_MusicChange_021_nodelay_000': ['collision_camera_021 (B)'],
                  'TG_waterzone_010': ['collision_camera_010 (B)'],
                  'TG_waterzone_011': ['collision_camera_010 (B)'],
                  'TG_waterzone_012': ['collision_camera_010 (B)'],
                  'TG_waterzone_013': ['collision_camera_010 (B)'],
                  'TG_waterzone_014': ['collision_camera_010 (B)'],
                  'TG_waterzone_015': ['collision_camera_010 (B)'],
                  'TG_waterzone_016': ['collision_camera_010 (B)'],
                  'TG_waterzone_018': ['collision_camera_010 (B)'],
                  'TG_waterzone_027': ['collision_camera_010 (B)'],
                  'TriggerOpt_001': ['collision_camera_010 (B)'],
                  'TriggerOpt_002': ['collision_camera_010 (B)'],
                  'TriggerOpt_003': ['collision_camera_010 (B)'],
                  'TriggerOpt_004': ['collision_camera_010 (B)'],
                  'TriggerOpt_005': ['collision_camera_010 (B)'],
                  'TriggerOpt_006': ['collision_camera_010 (B)'],
                  'TriggerOpt_007': ['collision_camera_010 (B)'],
                  'accesspoint_000': ['collision_camera_009 (B)'],
                  'accesspoint_000_platform': ['collision_camera_009 (B)'],
                  'accesspoint_001': ['collision_camera_016 (B)'],
                  'accesspoint_001_platform': ['collision_camera_016 (B)'],
                  'aeiongd_statue': ['collision_camera_014 (B)'],
                  'ammorecharge_001': ['collision_camera_022 (B)'],
                  'ammorecharge_001_platform': ['collision_camera_022 (B)'],
                  'ammorecharge_002': ['collision_camera_008 (B)'],
                  'ammorecharge_002_platform': ['collision_camera_008 (B)'],
                  'box_magnet_aq_002': ['collision_camera_010 (B)'],
                  'camerarailpath': ['collision_camera_001 (B)'],
                  'db_reg_aq_001': ['collision_camera_002 (B)'],
                  'db_reg_aq_002': ['collision_camera_002 (B)'],
                  'db_reg_aq_003': ['collision_camera_010 (B)'],
                  'db_reg_aq_004': ['collision_camera_023_B (B)'],
                  'db_reg_aq_005': ['collision_camera_021 (B)'],
                  'db_reg_aq_007': ['collision_camera_002 (B)'],
                  'db_reg_aq_008': ['collision_camera_006 (B)'],
                  'db_reg_aq_009': ['collision_camera_008 (B)'],
                  'db_reg_aq_011': ['collision_camera_006 (B)'],
                  'db_reg_aq_012': ['collision_camera_015 (B)'],
                  'door_shield_plasma_002': ['collision_camera_010 (B)', 'collision_camera_013 (B)'],
                  'door_shield_plasma_003': ['collision_camera_010 (B)', 'collision_camera_013 (B)'],
                  'door_shield_plasma_004': ['collision_camera_010 (B)', 'collision_camera_015 (B)'],
                  'doorclosedcharge_001': ['collision_camera_015 (B)', 'collision_camera_021 (B)'],
                  'doorclosedcharge_002': ['collision_camera_010 (B)', 'collision_camera_015 (B)'],
                  'doorclosedpower': ['collision_camera_010 (B)', 'collision_camera_015 (B)'],
                  'doorframepresence': ['collision_camera_021 (B)', 'collision_camera_022 (B)'],
                  'doorframepresence_000': ['collision_camera_021 (B)', 'collision_camera_022 (B)'],
                  'doorgrapplegrapple_000': ['collision_camera_005 (B)', 'collision_camera_008 (B)'],
                  'doorgrapplegrapple_001': ['collision_camera_006 (B)', 'collision_camera_007 (B)'],
                  'doorpowerclosed_000': ['collision_camera_010 (B)', 'collision_camera_014 (B)'],
                  'doorpowerpower_000': ['collision_camera_002 (B)', 'collision_camera_003 (B)'],
                  'doorpowerpower_001': ['collision_camera_001 (B)', 'collision_camera_002 (B)'],
                  'doorpowerpower_002': ['collision_camera_001 (B)', 'collision_camera_009 (B)'],
                  'doorpowerpower_003': ['collision_camera_008 (B)', 'collision_camera_009 (B)'],
                  'doorpowerpower_004': ['collision_camera_008 (B)', 'collision_camera_010 (B)'],
                  'doorpowerpower_005': ['collision_camera_010 (B)', 'collision_camera_011 (B)'],
                  'doorpowerpower_006': ['collision_camera_002 (B)', 'collision_camera_012 (B)'],
                  'doorpowerpower_007': ['collision_camera_002 (B)', 'collision_camera_004 (B)'],
                  'doorpowerpower_008': ['collision_camera_000 (B)', 'collision_camera_001 (B)'],
                  'doorpowerpower_009': ['collision_camera_000 (B)', 'collision_camera_008 (B)'],
                  'doorpowerpower_010': ['collision_camera_005 (B)', 'collision_camera_029 (B)'],
                  'doorpowerpower_011': ['collision_camera_006 (B)', 'collision_camera_030 (B)'],
                  'doorpowerpower_013': ['collision_camera_010 (B)', 'collision_camera_013 (B)'],
                  'doorpowerpower_014': ['collision_camera_010 (B)', 'collision_camera_013 (B)'],
                  'doorpowerpower_015': ['collision_camera_021 (B)', 'collision_camera_023_B (B)'],
                  'doorpowerpower_016': ['collision_camera_021 (B)', 'collision_camera_023_B (B)'],
                  'doorpowerpower_018': ['collision_camera_016 (B)', 'collision_camera_021 (B)'],
                  'doorpowerpower_019': ['collision_camera_016 (B)', 'collision_camera_017 (B)'],
                  'doorpowerpower_020': ['collision_camera_015 (B)', 'collision_camera_018 (B)'],
                  'doorpowerpower_021': ['collision_camera_015 (B)', 'collision_camera_018 (B)'],
                  'doorpowerpower_022': ['collision_camera_010 (B)', 'collision_camera_026 (B)'],
                  'doorpowerpower_023': ['collision_camera_010 (B)', 'collision_camera_026 (B)'],
                  'doorpowerpower_024': ['collision_camera_010 (B)', 'collision_camera_025 (B)'],
                  'doorpowerpower_025': ['collision_camera_026 (B)', 'collision_camera_027 (B)'],
                  'doorshieldmissile_000': ['collision_camera_010 (B)', 'collision_camera_014 (B)'],
                  'doorshieldmissile_001': ['collision_camera_021 (B)', 'collision_camera_023_B (B)'],
                  'doorshutter_000': ['collision_camera_010 (B)', 'collision_camera_012 (B)'],
                  'doorshutter_001': ['collision_camera_010 (B)', 'collision_camera_014 (B)'],
                  'doorshutter_002': ['collision_camera_008 (B)'],
                  'doorshutter_003': ['collision_camera_021 (B)'],
                  'doorshutter_004': ['collision_camera_021 (B)'],
                  'elevator_cave_000': ['collision_camera_017 (B)'],
                  'elevator_cave_000_platform': ['collision_camera_017 (B)'],
                  'elevator_forest_000': ['collision_camera_006 (B)'],
                  'elevator_forest_000_platform': ['collision_camera_006 (B)'],
                  'energyrecharge_000': ['collision_camera_006 (B)'],
                  'energyrecharge_000_platform': ['collision_camera_006 (B)'],
                  'energyrecharge_001': ['collision_camera_013 (B)'],
                  'energyrecharge_001_platform': ['collision_camera_013 (B)'],
                  'ev_aquadrain_left': ['collision_camera_002 (B)'],
                  'ev_aquadrain_right': ['collision_camera_002 (B)'],
                  'ev_demolition_block': ['collision_camera_021 (B)'],
                  'ev_demolition_db_001': ['collision_camera_021 (B)'],
                  'ev_demolition_db_002': ['collision_camera_021 (B)'],
                  'ev_demolition_db_003': ['collision_camera_021 (B)'],
                  'ev_demolition_debris': ['collision_camera_021 (B)'],
                  'ev_demolition_grapple': ['collision_camera_021 (B)'],
                  'ev_demolition_tunnel': ['collision_camera_021 (B)'],
                  'ev_doorprof': ['collision_camera_001 (B)'],
                  'ev_doorprof_open': ['collision_camera_001 (B)'],
                  'fan_reg': ['collision_camera_002 (B)'],
                  'footstepplatform_000': ['collision_camera_010 (B)'],
                  'footstepplatform_001': ['collision_camera_010 (B)'],
                  'footstepplatform_002': ['collision_camera_014 (B)'],
                  'footstepplatform_003': ['collision_camera_008 (B)'],
                  'grapplepulloff1x2_000': ['collision_camera_002 (B)'],
                  'grapplepulloff1x2_001': ['collision_camera_008 (B)'],
                  'grapplepulloff1x2_003': ['collision_camera_010 (B)'],
                  'grapplepulloff1x2_004': ['collision_camera_006 (B)'],
                  'grapplepulloff1x2_005': ['collision_camera_010 (B)'],
                  'grapplepulloff1x2_006': ['collision_camera_029 (B)'],
                  'grappleswingpoint_000': ['collision_camera_005 (B)'],
                  'grappleswingpoint_001': ['collision_camera_005 (B)'],
                  'grappleswingpoint_002': ['collision_camera_007 (B)'],
                  'grappleswingpoint_003': ['collision_camera_007 (B)'],
                  'instanceactor_001': ['collision_camera_003 (B)'],
                  'instanceactor_232': ['collision_camera_002 (B)'],
                  'instanceactor_233': ['collision_camera_002 (B)'],
                  'instanceactor_234': ['collision_camera_002 (B)'],
                  'instanceactor_235': ['collision_camera_002 (B)'],
                  'instanceactor_237': ['collision_camera_002 (B)'],
                  'instanceactor_238': ['collision_camera_002 (B)'],
                  'instanceactor_239': ['collision_camera_002 (B)'],
                  'instanceactor_241': ['collision_camera_018 (B)'],
                  'instanceactor_242': ['collision_camera_018 (B)'],
                  'instanceactor_243': ['collision_camera_018 (B)'],
                  'instanceactor_244': ['collision_camera_002 (B)'],
                  'instanceactor_248': ['collision_camera_003 (B)'],
                  'instanceactor_249': ['collision_camera_003 (B)'],
                  'instanceactor_250': ['collision_camera_003 (B)'],
                  'instanceactor_251': ['collision_camera_003 (B)'],
                  'instanceactor_252': ['collision_camera_003 (B)'],
                  'instanceactor_253': ['collision_camera_003 (B)'],
                  'instanceactor_254': ['collision_camera_003 (B)'],
                  'instanceactor_255': ['collision_camera_003 (B)'],
                  'instanceactor_256': ['collision_camera_003 (B)'],
                  'instanceactor_257': ['collision_camera_003 (B)'],
                  'instanceactor_258': ['collision_camera_003 (B)'],
                  'instanceactor_259': ['collision_camera_003 (B)'],
                  'instanceactor_260': ['collision_camera_003 (B)'],
                  'instancefx_000': [],
                  'instancefx_001': [],
                  'instancefx_002': [],
                  'instancefx_003': [],
                  'instancefx_004': [],
                  'instancefx_005': [],
                  'instancefx_006': [],
                  'instancefx_007': [],
                  'instancefx_008': [],
                  'instancefx_doorprof_drops_000': ['collision_camera_001 (B)'],
                  'instancefx_doorprof_drops_001': ['collision_camera_001 (B)'],
                  'instancefx_doorprof_drops_002': ['collision_camera_001 (B)'],
                  'instancefx_doorprof_stream_000': ['collision_camera_001 (B)'],
                  'instancefx_doorprof_stream_001': ['collision_camera_001 (B)'],
                  'instancefx_doorprof_stream_002': ['collision_camera_001 (B)'],
                  'instancefx_doorprof_stream_003': ['collision_camera_001 (B)'],
                  'instancefx_doorprof_stream_004': ['collision_camera_001 (B)'],
                  'instancefx_doorprof_stream_005': ['collision_camera_001 (B)'],
                  'item_energyfragment_000': ['collision_camera_002 (B)'],
                  'item_energyfragment_002': ['collision_camera_018 (B)'],
                  'item_energytank': ['collision_camera_025 (B)'],
                  'item_energytank_000': ['collision_camera_010 (B)'],
                  'item_missiletank': ['collision_camera_013 (B)'],
                  'item_missiletank_000': ['collision_camera_007 (B)'],
                  'item_missiletank_001': ['collision_camera_002 (B)'],
                  'item_missiletank_003': ['collision_camera_017 (B)'],
                  'item_missiletank_004': ['collision_camera_021 (B)'],
                  'item_missiletank_005': ['collision_camera_010 (B)'],
                  'item_missiletank_006': ['collision_camera_001 (B)'],
                  'item_missiletank_007': ['collision_camera_010 (B)'],
                  'item_missiletankplus': ['collision_camera_021 (B)'],
                  'item_missiletankplus_000': ['collision_camera_008 (B)'],
                  'item_missiletankplus_001': ['collision_camera_010 (B)'],
                  'item_missiletankplus_002': ['collision_camera_018 (B)'],
                  'item_powerbombtank_000': ['collision_camera_023_B (B)'],
                  'itemsphere_gravitysuit': ['collision_camera_023_B (B)'],
                  'magnetsurface_000': ['collision_camera_002 (B)'],
                  'magnetsurface_001': ['collision_camera_006 (B)'],
                  'magnetsurface_002': ['collision_camera_007 (B)'],
                  'magnetsurface_003': ['collision_camera_002 (B)'],
                  'magnetsurface_004': ['collision_camera_008 (B)'],
                  'magnetsurface_005': ['collision_camera_010 (B)'],
                  'magnetsurface_006': ['collision_camera_025 (B)'],
                  'magnetsurface_007': ['collision_camera_018 (B)'],
                  'magnetsurface_008': ['collision_camera_019 (B)'],
                  'magnetsurface_009': ['collision_camera_008 (B)'],
                  'magnetsurface_010': ['collision_camera_006 (B)'],
                  'magnetsurface_011': ['collision_camera_010 (B)'],
                  'magnetsurface_012': ['collision_camera_002 (B)'],
                  'magnetsurface_014': ['collision_camera_005 (B)'],
                  'magnetsurface_015': ['collision_camera_010 (B)'],
                  'magnetsurface_016': ['collision_camera_006 (B)'],
                  'magnetsurface_018': ['collision_camera_005 (B)'],
                  'magnetsurface_019': ['collision_camera_010 (B)'],
                  'maproom': ['collision_camera_000 (B)'],
                  'maproom_platform': ['collision_camera_000 (B)'],
                  'mlm2_point_000': ['collision_camera_008 (B)'],
                  'mlm2_point_001': ['collision_camera_008 (B)'],
                  'mlm2_point_002': ['collision_camera_008 (B)'],
                  'mlm2_point_003': ['collision_camera_008 (B)'],
                  'mlm2_point_004': ['collision_camera_008 (B)'],
                  'mlm_block_000': ['collision_camera_025 (B)'],
                  'mlm_block_001': ['collision_camera_008 (B)'],
                  'mlm_point_000': ['collision_camera_025 (B)'],
                  'mlm_point_001': ['collision_camera_025 (B)'],
                  'mlm_point_002': ['collision_camera_025 (B)'],
                  'mlm_point_003': ['collision_camera_025 (B)'],
                  'mlm_point_004': ['collision_camera_025 (B)'],
                  'portal_trainwagon_right': [],
                  'powerup_ghostaura': ['collision_camera_014 (B)'],
                  'rail_magnet_aq_001': ['collision_camera_010 (B)'],
                  'savestation_000': ['collision_camera_011 (B)'],
                  'savestation_000_platform': ['collision_camera_011 (B)'],
                  'savestation_001': ['collision_camera_027 (B)'],
                  'savestation_001_platform': ['collision_camera_027 (B)'],
                  'savestation_002': ['collision_camera_030 (B)'],
                  'savestation_002_platform': ['collision_camera_030 (B)'],
                  'spacejump_marker_000': ['collision_camera_010 (B)'],
                  'spacejump_marker_001': ['collision_camera_010 (B)'],
                  'spacejump_marker_002': ['collision_camera_010 (B)'],
                  'spacejump_marker_003': ['collision_camera_010 (B)'],
                  'spacejump_marker_004': ['collision_camera_010 (B)'],
                  'spacejump_marker_005': ['collision_camera_010 (B)'],
                  'teleporter_forest_000': ['collision_camera_015 (B)'],
                  'teleporter_forest_000_platform': ['collision_camera_015 (B)'],
                  'wagontrain_baselab_000': ['collision_camera_003 (B)'],
                  'wagontrain_baselab_000_platform': ['collision_camera_003 (B)'],
                  'wagontrain_baselab_001_platform': ['collision_camera_004 (B)'],
                  'wagontrain_with_portal_baselab_001': ['collision_camera_004 (B)'],
                  'waterzone_000': ['collision_camera_002 (B)'],
                  'waterzone_001': ['collision_camera_002 (B)'],
                  'waterzone_002': ['collision_camera_002 (B)'],
                  'waterzone_003': ['collision_camera_002 (B)'],
                  'waterzone_004': ['collision_camera_002 (B)'],
                  'waterzone_005': ['collision_camera_017 (B)'],
                  'waterzone_006': ['collision_camera_002 (B)'],
                  'waterzone_007': ['collision_camera_023_B (B)'],
                  'waterzone_008': ['collision_camera_021 (B)'],
                  'waterzone_009': ['collision_camera_008 (B)'],
                  'waterzone_010': ['collision_camera_010 (B)'],
                  'waterzone_011': ['collision_camera_010 (B)'],
                  'waterzone_012': ['collision_camera_010 (B)'],
                  'waterzone_013': ['collision_camera_010 (B)'],
                  'waterzone_014': ['collision_camera_010 (B)'],
                  'waterzone_015': ['collision_camera_010 (B)'],
                  'waterzone_016': ['collision_camera_010 (B)'],
                  'waterzone_017': ['collision_camera_012 (B)'],
                  'waterzone_018': ['collision_camera_010 (B)'],
                  'waterzone_019': ['collision_camera_026 (B)'],
                  'waterzone_020': ['collision_camera_015 (B)'],
                  'waterzone_021': ['collision_camera_018 (B)'],
                  'waterzone_022': ['collision_camera_019 (B)'],
                  'waterzone_023': ['collision_camera_013 (B)'],
                  'waterzone_024': ['collision_camera_024 (B)'],
                  'waterzone_027': ['collision_camera_010 (B)'],
                  'waterzone_028': ['collision_camera_018 (B)'],
                  'waterzone_029': ['collision_camera_021 (B)'],
                  'waterzone_030': ['collision_camera_021 (B)'],
                  'waterzone_031': [],
                  'waterzone_032': ['collision_camera_021 (B)'],
                  'waterzone_033': ['collision_camera_021 (B)'],
                  'zipline_bottom_gen_002': ['collision_camera_010 (B)'],
                  'zipline_right_gen_000': ['collision_camera_010 (B)'],
                  'zipline_right_gen_001': ['collision_camera_010 (B)']},
    's050_forest': {'AP_07': ['collision_camera_006 (G)'],
                    'CAM_Default': ['collision_camera_000 (G)'],
                    'SP_AccessPoint_7': ['collision_camera_005 (G)'],
                    'SP_AccessPoint_7B': ['collision_camera_007 (G)'],
                    'SP_Checkpoint_CentralUnit': ['collision_camera_019 (G)'],
                    'SP_Checkpoint_ChozoRobotForest': ['collision_camera_001 (G)'],
                    'SP_Checkpoint_ChozoWarriorForest': ['collision_camera_025_B (G)'],
                    'SP_Checkpoint_Dead_ChozoRobotSoldier': ['collision_camera_002 (G)'],
                    'SP_Checkpoint_Dead_ChozoWarriorX': ['collision_camera_023 (G)'],
                    'SP_Checkpoint_DoubleJump': ['collision_camera_030 (G)'],
                    'SP_Checkpoint_EmmyForest': ['collision_camera_005 (G)'],
                    'SP_Checkpoint_EmmyForestPhase2': ['collision_camera_017 (G)'],
                    'SP_Checkpoint_IceMissiles': ['collision_camera_019 (G)'],
                    'SP_Checkpoint_LineBomb': ['collision_camera_026 (G)'],
                    'SP_Checkpoint_Sonar': ['collision_camera_039 (G)'],
                    'SP_Checkpoint_SonarObtained': ['collision_camera_032 (G)'],
                    'SP_Checkpoint_SuperGoliath': ['collision_camera_024 (G)'],
                    'SP_Checkpoint_SuperMissiles': ['collision_camera_010 (G)'],
                    'StartPoint0': ['collision_camera_000 (G)'],
                    'TG_KeepDirection_000': ['collision_camera_036 (G)'],
                    'TG_KeepDirection_001': ['collision_camera_024 (G)'],
                    'TG_SuperMissile_MusicChange': ['collision_camera_010 (G)'],
                    'accesspoint_000': ['collision_camera_006 (G)'],
                    'accesspoint_000_platform': ['collision_camera_006 (G)'],
                    'aeionstatue': ['collision_camera_032 (G)'],
                    'ammorecharge_001': ['collision_camera_021 (G)'],
                    'ammorecharge_001_platform': ['collision_camera_021 (G)'],
                    'box_grapple_cv_001': ['collision_camera_001 (G)'],
                    'box_grapple_cv_002': ['collision_camera_025_B (G)'],
                    'box_magnet_fr_001': ['collision_camera_035 (G)'],
                    'door_frblack_gen_000': [],
                    'door_frblack_gen_001': ['collision_camera_019 (G)'],
                    'door_frblack_gen_002': [],
                    'door_frblack_gen_003': ['collision_camera_019 (G)', 'collision_camera_020 (G)'],
                    'door_frblack_gen_004': ['collision_camera_019 (G)', 'collision_camera_020 (G)'],
                    'door_frblack_gen_005': ['collision_camera_019 (G)', 'collision_camera_020 (G)'],
                    'door_frblack_gen_006': ['collision_camera_019 (G)', 'collision_camera_020 (G)'],
                    'door_frblack_gen_007': ['collision_camera_019 (G)'],
                    'door_shield_plasma_000': ['collision_camera_000 (G)', 'collision_camera_003 (G)'],
                    'door_shield_plasma_001': ['collision_camera_004 (G)', 'collision_camera_011 (G)'],
                    'door_shield_plasma_002': ['collision_camera_000 (G)', 'collision_camera_003 (G)'],
                    'door_shield_plasma_003': ['collision_camera_021 (G)', 'collision_camera_022 (G)'],
                    'door_shield_plasma_004': ['collision_camera_021 (G)', 'collision_camera_022 (G)'],
                    'doorchargecharge_000': ['collision_camera_018 (G)', 'collision_camera_020 (G)'],
                    'doorchargecharge_001': ['collision_camera_016 (G)', 'collision_camera_019 (G)'],
                    'doorclosedcharge': ['collision_camera_024 (G)', 'collision_camera_039 (G)'],
                    'doorclosedpower_000': ['collision_camera_033 (G)', 'collision_camera_034 (G)'],
                    'doorclosedpower_001': ['collision_camera_009 (G)', 'collision_camera_010 (G)'],
                    'doorclosedpower_002': ['collision_camera_024 (G)', 'collision_camera_025_B (G)'],
                    'doorclosedpower_003': ['collision_camera_033 (G)', 'collision_camera_036 (G)'],
                    'dooremmy': ['collision_camera_020 (G)', 'collision_camera_021 (G)'],
                    'dooremmy_000': ['collision_camera_003 (G)', 'collision_camera_004 (G)'],
                    'dooremmy_001': ['collision_camera_004 (G)', 'collision_camera_005 (G)'],
                    'dooremmy_002': ['collision_camera_011 (G)', 'collision_camera_012 (G)'],
                    'dooremmy_003': ['collision_camera_011 (G)', 'collision_camera_012 (G)'],
                    'dooremmy_004': ['collision_camera_014 (G)', 'collision_camera_015 (G)'],
                    'dooremmy_005': ['collision_camera_014 (G)', 'collision_camera_015 (G)'],
                    'dooremmy_006': ['collision_camera_015 (G)', 'collision_camera_016 (G)'],
                    'dooremmy_007': ['collision_camera_020 (G)', 'collision_camera_021 (G)'],
                    'doorframe_000': ['collision_camera_011 (G)', 'collision_camera_014 (G)'],
                    'doorgrappleclosed_000': ['collision_camera_021 (G)', 'collision_camera_039 (G)'],
                    'doorgrapplegrapple_000': ['collision_camera_024 (G)', 'collision_camera_031 (G)'],
                    'doorgrapplegrapple_001': ['collision_camera_000 (G)', 'collision_camera_001 (G)'],
                    'doorgrapplegrapple_003': ['collision_camera_029 (G)', 'collision_camera_037 (G)'],
                    'doorgrapplegrapple_006': ['collision_camera_014 (G)', 'collision_camera_018 (G)'],
                    'doorpowerclosed_000': ['collision_camera_001 (G)', 'collision_camera_035 (G)'],
                    'doorpowerclosed_002': ['collision_camera_023 (G)', 'collision_camera_025_B (G)'],
                    'doorpowerclosed_003': ['collision_camera_026 (G)', 'collision_camera_033 (G)'],
                    'doorpowerpower': ['collision_camera_024 (G)', 'collision_camera_040 (G)'],
                    'doorpowerpower_000': ['collision_camera_001 (G)', 'collision_camera_002 (G)'],
                    'doorpowerpower_001': ['collision_camera_008 (G)', 'collision_camera_038 (G)'],
                    'doorpowerpower_002': ['collision_camera_004 (G)', 'collision_camera_011 (G)'],
                    'doorpowerpower_003': ['collision_camera_005 (G)', 'collision_camera_006 (G)'],
                    'doorpowerpower_004': ['collision_camera_006 (G)', 'collision_camera_007 (G)'],
                    'doorpowerpower_005': ['collision_camera_007 (G)', 'collision_camera_029 (G)'],
                    'doorpowerpower_006': ['collision_camera_008 (G)', 'collision_camera_009 (G)'],
                    'doorpowerpower_007': ['collision_camera_009 (G)', 'collision_camera_010 (G)'],
                    'doorpowerpower_008': ['collision_camera_012 (G)', 'collision_camera_013 (G)'],
                    'doorpowerpower_009': ['collision_camera_014 (G)', 'collision_camera_018 (G)'],
                    'doorpowerpower_010': ['collision_camera_019 (G)', 'collision_camera_020 (G)'],
                    'doorpowerpower_011': ['collision_camera_019 (G)', 'collision_camera_020 (G)'],
                    'doorpowerpower_012': ['collision_camera_001 (G)', 'collision_camera_010 (G)'],
                    'doorpowerpower_013': ['collision_camera_022 (G)', 'collision_camera_023 (G)'],
                    'doorpowerpower_014': ['collision_camera_024 (G)', 'collision_camera_025_B (G)'],
                    'doorpowerpower_015': ['collision_camera_024 (G)', 'collision_camera_036 (G)'],
                    'doorpowerpower_017': ['collision_camera_002 (G)', 'collision_camera_003 (G)'],
                    'doorpowerpower_018': ['collision_camera_000 (G)', 'collision_camera_003 (G)'],
                    'doorpowerpower_019': ['collision_camera_021 (G)', 'collision_camera_022 (G)'],
                    'doorshieldmissile_000': ['collision_camera_009 (G)', 'collision_camera_010 (G)'],
                    'doorshieldmissile_001': ['collision_camera_024 (G)',
                                              'collision_camera_025_B (G)'],
                    'doorshieldsupermissile_000': ['collision_camera_001 (G)',
                                                   'collision_camera_035 (G)'],
                    'doorshieldsupermissile_001': ['collision_camera_007 (G)',
                                                   'collision_camera_029 (G)'],
                    'doorshieldsupermissile_002': ['collision_camera_009 (G)',
                                                   'collision_camera_010 (G)'],
                    'elevator_aqua_000': ['collision_camera_000 (G)'],
                    'elevator_aqua_000_platform': ['collision_camera_000 (G)'],
                    'elevator_baselab_000': ['collision_camera_038 (G)'],
                    'elevator_baselab_000_platform': ['collision_camera_038 (G)'],
                    'emmy_frozen': ['collision_camera_004 (G)'],
                    'emmyvalve_reg_gen_000': ['collision_camera_004 (G)'],
                    'emmyvalve_reg_gen_001': ['collision_camera_011 (G)'],
                    'emmyvalve_reg_gen_002': ['collision_camera_014 (G)'],
                    'emmyvalve_reg_gen_003': ['collision_camera_018 (G)'],
                    'emmyvalve_reg_gen_005': ['collision_camera_020 (G)'],
                    'emmyvalve_reg_gen_006': ['collision_camera_020 (G)'],
                    'emmyvalve_reg_gen_007': ['collision_camera_020 (G)'],
                    'energyrecharge_002': ['collision_camera_031 (G)'],
                    'energyrecharge_002_platform': ['collision_camera_031 (G)'],
                    'grapplepulloff1x2_000': ['collision_camera_021 (G)'],
                    'grapplepulloff1x2_002': ['collision_camera_008 (G)'],
                    'grappleswingpoint_000': ['collision_camera_003 (G)'],
                    'grappleswingpoint_001': ['collision_camera_003 (G)'],
                    'grappleswingpoint_002': ['collision_camera_003 (G)'],
                    'item_energyfragment': ['collision_camera_024 (G)'],
                    'item_energyfragment_000': ['collision_camera_021 (G)'],
                    'item_energytank_000': ['collision_camera_021 (G)'],
                    'item_missiletank': ['collision_camera_024 (G)'],
                    'item_missiletank_000': ['collision_camera_001 (G)'],
                    'item_missiletank_001': ['collision_camera_008 (G)'],
                    'item_missiletank_002': ['collision_camera_028 (G)'],
                    'item_missiletank_003': ['collision_camera_003 (G)'],
                    'item_missiletank_004': ['collision_camera_024 (G)'],
                    'item_missiletank_005': ['collision_camera_033 (G)'],
                    'item_missiletank_006': ['collision_camera_039 (G)'],
                    'item_missiletank_007': ['collision_camera_024 (G)'],
                    'item_missiletank_009': ['collision_camera_029 (G)'],
                    'item_missiletankplus_000': ['collision_camera_009 (G)'],
                    'item_powerbombtank_000': ['collision_camera_021 (G)'],
                    'itemsphere_doublejump': ['collision_camera_030 (G)'],
                    'itemsphere_supermissile': ['collision_camera_010 (G)'],
                    'magnetsurface': ['collision_camera_029 (G)'],
                    'magnetsurface_000': ['collision_camera_001 (G)'],
                    'magnetsurface_001': ['collision_camera_001 (G)'],
                    'magnetsurface_002': ['collision_camera_003 (G)'],
                    'magnetsurface_003': ['collision_camera_003 (G)'],
                    'magnetsurface_004': ['collision_camera_004 (G)'],
                    'magnetsurface_005': ['collision_camera_004 (G)'],
                    'magnetsurface_006': ['collision_camera_011 (G)'],
                    'magnetsurface_007': ['collision_camera_009 (G)'],
                    'magnetsurface_008': ['collision_camera_035 (G)'],
                    'magnetsurface_009': ['collision_camera_012 (G)'],
                    'magnetsurface_010': ['collision_camera_014 (G)'],
                    'magnetsurface_011': ['collision_camera_014 (G)'],
                    'magnetsurface_012': ['collision_camera_018 (G)'],
                    'magnetsurface_013': ['collision_camera_021 (G)'],
                    'magnetsurface_014': ['collision_camera_021 (G)'],
                    'magnetsurface_015': ['collision_camera_025_B (G)'],
                    'magnetsurface_016': ['collision_camera_025_B (G)'],
                    'magnetsurface_017': ['collision_camera_031 (G)'],
                    'magnetsurface_018': ['collision_camera_014 (G)'],
                    'magnetsurface_019': ['collision_camera_031 (G)'],
                    'magnetsurface_020': ['collision_camera_020 (G)'],
                    'maproom': ['collision_camera_013 (G)'],
                    'maproom_platform': ['collision_camera_013 (G)'],
                    'mblauncher_exit_gen_001': ['collision_camera_007 (G)'],
                    'mblauncher_launcher_gen_001': ['collision_camera_035 (G)'],
                    'mblauncher_launcher_gen_002': ['collision_camera_024 (G)'],
                    'mblauncher_launcher_gen_003': ['collision_camera_030 (G)'],
                    'mlm_block_000': ['collision_camera_024 (G)'],
                    'mlm_point_000': ['collision_camera_025_B (G)'],
                    'mlm_point_001': ['collision_camera_024 (G)'],
                    'mlm_point_002': ['collision_camera_025_B (G)'],
                    'mlm_point_003': ['collision_camera_025_B (G)'],
                    'mlm_point_004': ['collision_camera_025_B (G)'],
                    'pf_mushr_fr_000': ['collision_camera_021 (G)'],
                    'pf_mushr_fr_001': ['collision_camera_021 (G)'],
                    'pf_mushr_fr_002': ['collision_camera_021 (G)'],
                    'pf_mushr_fr_003': ['collision_camera_021 (G)'],
                    'pf_mushr_fr_004': ['collision_camera_021 (G)'],
                    'pf_mushr_fr_005': ['collision_camera_021 (G)'],
                    'pf_mushr_fr_006': ['collision_camera_015 (G)'],
                    'pf_mushr_fr_007': ['collision_camera_015 (G)'],
                    'pf_mushr_fr_008': ['collision_camera_015 (G)'],
                    'pf_mushr_fr_009': ['collision_camera_025_B (G)'],
                    'pf_mushr_fr_010': ['collision_camera_015 (G)'],
                    'pf_mushr_fr_011': ['collision_camera_015 (G)'],
                    'pf_mushr_fr_012': ['collision_camera_025_B (G)'],
                    'powerup_sonar': ['collision_camera_032 (G)'],
                    'rail_magnet_fr_001': ['collision_camera_035 (G)'],
                    'savestation': ['collision_camera_040 (G)'],
                    'savestation_000': ['collision_camera_022 (G)'],
                    'savestation_000_platform': ['collision_camera_022 (G)'],
                    'spacejump_marker_000': ['collision_camera_031 (G)'],
                    'spacejump_marker_001': ['collision_camera_031 (G)'],
                    'spacejump_marker_002': ['collision_camera_031 (G)'],
                    'spacejump_marker_003': ['collision_camera_031 (G)'],
                    'spacejump_marker_004': ['collision_camera_031 (G)'],
                    'spacejump_marker_005': ['collision_camera_031 (G)'],
                    'spacejump_marker_006': ['collision_camera_015 (G)'],
                    'spacejump_marker_007': ['collision_camera_015 (G)'],
                    'spacejump_marker_008': ['collision_camera_015 (G)'],
                    'spacejump_marker_009': ['collision_camera_031 (G)'],
                    'teleporter_aqua_000': ['collision_camera_024 (G)'],
                    'teleporter_aqua_000_platform': ['collision_camera_024 (G)'],
                    'teleporter_magma_000': ['collision_camera_024 (G)'],
                    'teleporter_magma_000_platform': ['collision_camera_024 (G)'],
                    'totalrechargestation_000': ['collision_camera_025_B (G)'],
                    'totalrechargestation_001': ['collision_camera_001 (G)'],
                    'trap_rot_cv_001': ['collision_camera_007 (G)'],
                    'trigger_camera_019_B': ['collision_camera_019 (G)'],
                    'trigger_camera_03_B': ['collision_camera_003 (G)'],
                    'trigger_camera_03_C': ['collision_camera_003 (G)'],
                    'trigger_camera_23_B': ['collision_camera_023 (G)'],
                    'trigger_camera_24_B': ['collision_camera_024 (G)'],
                    'trigger_camera_25_B': ['collision_camera_025_B (G)'],
                    'trigger_camera_25_C': ['collision_camera_025_B (G)'],
                    'trigger_camera_ZoomIn_off': ['collision_camera_008 (G)'],
                    'trigger_camera_ZoomIn_on': ['collision_camera_007 (G)'],
                    'tunnelframe': ['collision_camera_016 (G)', 'collision_camera_019 (G)'],
                    'wagontrain_quarantine_000': ['collision_camera_037 (G)'],
                    'wagontrain_quarantine_000_platform': ['collision_camera_037 (G)'],
                    'wagontrain_quarantine_with_cutscene_000': ['collision_camera_037 (G)'],
                    'wagontrain_sanctuary_000': ['collision_camera_027 (G)'],
                    'wagontrain_sanctuary_000_platform': ['collision_camera_027 (G)'],
                    'wagontrain_shipyard_000': ['collision_camera_034 (G)'],
                    'wagontrain_shipyard_000_platform': ['collision_camera_034 (G)'],
                    'waterzone_000': ['collision_camera_001 (G)'],
                    'waterzone_001': ['collision_camera_011 (G)'],
                    'waterzone_002': ['collision_camera_028 (G)'],
                    'waterzone_003': [],
                    'waterzone_004': [],
                    'waterzone_005': ['collision_camera_031 (G)'],
                    'waterzone_006': ['collision_camera_024 (G)'],
                    'waterzone_007': ['collision_camera_020 (G)'],
                    'waterzone_008': ['collision_camera_024 (G)'],
                    'weightactivatedplatform_save': ['collision_camera_040 (G)'],
                    'weightactivatedplatform_total_000': ['collision_camera_025_B (G)'],
                    'weightactivatedplatform_total_001': ['collision_camera_001 (G)'],
                    'zipline_bottom_gen_002': ['collision_camera_019 (G)'],
                    'zipline_right_gen_002': ['collision_camera_004 (G)']},
    's060_quarantine': {'CAM_Default': ['collision_camera_011 (E)'],
                        'FillMapLauncher': ['collision_camera_002 (E)'],
                        'GateTrigger': ['collision_camera_011 (E)'],
                        'SP_Checkpoint_ChozoWarriorX': ['collision_camera_007 (E)'],
                        'SP_Checkpoint_Dead_ChozoWarriorX': ['collision_camera_004 (E)'],
                        'SP_Checkpoint_PlasmaBeam': ['collision_camera_003 (E)'],
                        'SP_Checkpoint_ProfessorX': ['collision_camera_001 (E)'],
                        'SP_PlasmaBeam': ['collision_camera_006 (E)'],
                        'StartPoint0': ['collision_camera_001 (E)'],
                        'TG_CameraChange_003_B': ['collision_camera_003 (E)'],
                        'TG_ChangeCamera_004_B': ['collision_camera_004 (E)'],
                        'TG_ChangeCamera_MBL': ['collision_camera_MBL_B (E)'],
                        'TG_ChangeSetup_MBL': ['collision_camera_MBL_B (E)'],
                        'TG_Disable_Camera_003_B': ['collision_camera_003 (E)'],
                        'TG_FillLauncher': ['collision_camera_002 (E)'],
                        'TG_QuarentineOpen': ['collision_camera_003 (E)',
                                              'collision_camera_MBL_B (E)'],
                        'TutoParasiteEnter': ['collision_camera_005 (E)'],
                        'TutoParasiteExit': ['collision_camera_005 (E)'],
                        'ammorecharge_000': ['collision_camera_003 (E)'],
                        'ammorecharge_000_platform': ['collision_camera_003 (E)'],
                        'chozoastro': ['collision_camera_005 (E)'],
                        'db_reg_qt_001': ['collision_camera_003 (E)'],
                        'door_shield_plasma_000': ['collision_camera_002 (E)',
                                                   'collision_camera_003 (E)'],
                        'door_shield_plasma_001': [],
                        'door_shield_plasma_002': ['collision_camera_005 (E)',
                                                   'collision_camera_007 (E)'],
                        'door_shield_plasma_004': ['collision_camera_002 (E)',
                                                   'collision_camera_003 (E)'],
                        'door_shield_plasma_005': [],
                        'doorpowerclosed_000': ['collision_camera_003 (E)', 'collision_camera_006 (E)'],
                        'doorpowerpower_000': ['collision_camera_002 (E)', 'collision_camera_003 (E)'],
                        'doorpowerpower_001': ['collision_camera_003 (E)', 'collision_camera_004 (E)'],
                        'doorpowerpower_002': ['collision_camera_003 (E)', 'collision_camera_005 (E)'],
                        'doorpowerpower_003': ['collision_camera_003 (E)', 'collision_camera_006 (E)'],
                        'doorpowerpower_004': ['collision_camera_001 (E)', 'collision_camera_012 (E)'],
                        'doorpowerpower_005': ['collision_camera_004 (E)', 'collision_camera_007 (E)'],
                        'doorpowerpower_006': ['collision_camera_005 (E)', 'collision_camera_007 (E)'],
                        'doorpowerpower_007': ['collision_camera_005 (E)', 'collision_camera_008 (E)'],
                        'doorpowerpower_008': ['collision_camera_011 (E)', 'collision_camera_012 (E)'],
                        'doorshieldmissile_000': [],
                        'energyrecharge_000': ['collision_camera_009 (E)'],
                        'energyrecharge_000_platform': ['collision_camera_009 (E)'],
                        'ev_gatesealed_closed': ['collision_camera_011 (E)'],
                        'ev_gatesealed_opened': ['collision_camera_011 (E)'],
                        'ev_gatesealed_second': ['collision_camera_000 (E)',
                                                 'collision_camera_002 (E)'],
                        'ev_quarantine_roomlights_001': ['collision_camera_000 (E)'],
                        'fan_reg_000': ['collision_camera_008 (E)'],
                        'grapplepulloff1x2_000': ['collision_camera_009 (E)'],
                        'item_energytank_000': ['collision_camera_003 (E)'],
                        'item_missiletank_000': ['collision_camera_010 (E)'],
                        'item_missiletank_002': ['collision_camera_008 (E)'],
                        'item_powerbombtank_000': ['collision_camera_009 (E)'],
                        'itemsphere_plasmabeam_000': ['collision_camera_006 (E)'],
                        'magnetsurface_000': ['collision_camera_007 (E)'],
                        'mblauncher_exit_gen_001': ['collision_camera_003 (E)',
                                                    'collision_camera_MBL_B (E)'],
                        'mblauncher_launcher_gen_000': ['collision_camera_MBL_B (E)'],
                        'mblauncher_launcher_gen_001': ['collision_camera_002 (E)'],
                        'mblauncher_launcher_gen_002': ['collision_camera_003 (E)',
                                                        'collision_camera_MBL_B (E)'],
                        'savestation': ['collision_camera_012 (E)'],
                        'wagontrain_forest_000': ['collision_camera_001 (E)'],
                        'wagontrain_forest_000_platform': ['collision_camera_001 (E)'],
                        'weightactivatedplatform_save': ['collision_camera_012 (E)']},
    's070_basesanc': {'AP_08': ['collision_camera_016 (F)'],
                      'CAM_Default': ['collision_camera_021 (F)'],
                      'CAM_Entrance': ['collision_camera_014 (F)'],
                      'LM_EmmyTrap': ['collision_camera_034 (F)'],
                      'LS_EmmyTrap': ['collision_camera_034 (F)'],
                      'LS_Phase2HeatEnabled_000': ['collision_camera_034 (F)'],
                      'LS_TrainViewed': ['collision_camera_014 (F)'],
                      'PRP_professor_death': ['collision_camera_005 (F)'],
                      'PoolVisited': ['collision_camera_030 (F)'],
                      'SP_AccessPoint_8': ['collision_camera_012 (F)'],
                      'SP_Checkpoint_CentralUnit': ['collision_camera_038_A (F)'],
                      'SP_Checkpoint_ChozoRobotSanc': ['collision_camera_005 (F)'],
                      'SP_Checkpoint_Dead_2ChozoRobots': ['collision_camera_017 (F)'],
                      'SP_Checkpoint_Dead_ChozoRobotSoldier': ['collision_camera_005 (F)'],
                      'SP_Checkpoint_EmmySanc': ['collision_camera_007 (F)'],
                      'SP_Checkpoint_EmmySancPhase2': ['collision_camera_038_A (F)'],
                      'SP_Checkpoint_EmmySancPhase2_CURoom': ['collision_camera_035 (F)'],
                      'SP_Checkpoint_MultiLockOn': ['collision_camera_027 (F)'],
                      'SP_Checkpoint_Professor': ['collision_camera_040 (F)'],
                      'SP_Checkpoint_SpaceJump': ['collision_camera_012 (F)'],
                      'SP_Checkpoint_SuperQuetzoa': ['collision_camera_026 (F)'],
                      'SP_Checkpoint_TwoChozoRobots': ['collision_camera_019 (F)'],
                      'SP_Checkpoint_TwoChozoRobots_BottomLeft': ['collision_camera_007 (F)'],
                      'SP_Checkpoint_TwoChozoRobots_TopLeft': ['collision_camera_017 (F)'],
                      'SP_Checkpoint_TwoChozoRobots_TopRight': ['collision_camera_017 (F)'],
                      'SP_Checkpoint_WaveBeam': ['collision_camera_034 (F)'],
                      'StartPoint0': ['collision_camera_000 (F)'],
                      'TG_ChangeCamera_003_B': ['collision_camera_003 (F)'],
                      'TG_ChangeCamera_012_B': ['collision_camera_012 (F)'],
                      'TG_ChangeCamera_012_C': ['collision_camera_012 (F)'],
                      'TG_ChangeCamera_024_A': ['collision_camera_024 (F)'],
                      'TG_ChangeCamera_024_B': ['collision_camera_024 (F)'],
                      'TG_ChangeCamera_024_C': ['collision_camera_024 (F)'],
                      'TG_ChangeCamera_030_B': ['collision_camera_030 (F)'],
                      'TG_ChangeCamera_038_B_Enter': [],
                      'TG_ChangeCamera_038_B_Exit': [],
                      'TG_MusicChange_SpaceJumpWater': ['collision_camera_012 (F)'],
                      'TG_MusicChange_Spacejump': ['collision_camera_012 (F)'],
                      'TG_Professor_CUT_Placeholder': ['collision_camera_040 (F)'],
                      'TG_TrainViewed': ['collision_camera_014 (F)'],
                      'TG_VisitPool': ['collision_camera_030 (F)'],
                      'accesspoint_000': ['collision_camera_016 (F)'],
                      'accesspoint_000_platform': ['collision_camera_016 (F)'],
                      'box_wide_cv_002': ['collision_camera_034 (F)'],
                      'box_wide_cv_003': ['collision_camera_034 (F)'],
                      'camerarailpath_entrance': ['collision_camera_014 (F)'],
                      'db_reg_b2_001': ['collision_camera_012 (F)'],
                      'db_reg_b2_003': ['collision_camera_009 (F)'],
                      'db_reg_b2_004': ['collision_camera_013 (F)'],
                      'db_reg_b2_005': ['collision_camera_028 (F)'],
                      'db_reg_b2_006': ['collision_camera_031 (F)'],
                      'db_reg_b2_007': ['collision_camera_034 (F)'],
                      'db_reg_b2_008': ['collision_camera_034 (F)'],
                      'db_reg_b2_009': ['collision_camera_034 (F)'],
                      'db_reg_b2_010': ['collision_camera_034 (F)'],
                      'db_reg_b2_011': ['collision_camera_034 (F)'],
                      'door_shield_plasma_000': ['collision_camera_018 (F)',
                                                 'collision_camera_030 (F)'],
                      'door_shield_plasma_001': ['collision_camera_018 (F)',
                                                 'collision_camera_030 (F)'],
                      'door_shield_plasma_002': ['collision_camera_007 (F)',
                                                 'collision_camera_010 (F)'],
                      'door_shield_plasma_003': ['collision_camera_007 (F)',
                                                 'collision_camera_010 (F)'],
                      'doorchargecharge_000': ['collision_camera_018 (F)', 'collision_camera_030 (F)'],
                      'doorclosedcharge_000': ['collision_camera_015 (F)', 'collision_camera_017 (F)'],
                      'doorclosedcharge_001': ['collision_camera_032 (F)', 'collision_camera_033 (F)'],
                      'doorclosedcharge_002': ['collision_camera_031 (F)', 'collision_camera_033 (F)'],
                      'doorclosedcharge_003': ['collision_camera_025 (F)', 'collision_camera_041 (F)'],
                      'doorclosedcharge_004': ['collision_camera_003 (F)', 'collision_camera_021 (F)'],
                      'doorclosedpower_000': ['collision_camera_012 (F)', 'collision_camera_015 (F)'],
                      'dooremmy_000': ['collision_camera_001 (F)', 'collision_camera_040 (F)'],
                      'dooremmy_001': ['collision_camera_004 (F)', 'collision_camera_040 (F)'],
                      'dooremmy_002': ['collision_camera_003 (F)', 'collision_camera_007 (F)'],
                      'dooremmy_003': ['collision_camera_019 (F)', 'collision_camera_021 (F)'],
                      'dooremmy_004': ['collision_camera_021 (F)', 'collision_camera_022 (F)'],
                      'dooremmy_005': ['collision_camera_021 (F)', 'collision_camera_022 (F)'],
                      'dooremmy_006': ['collision_camera_025 (F)', 'collision_camera_032 (F)'],
                      'dooremmy_007': ['collision_camera_029 (F)', 'collision_camera_031 (F)'],
                      'dooremmy_008': ['collision_camera_030 (F)', 'collision_camera_031 (F)'],
                      'doorgrapplegrapple_000': ['collision_camera_018 (F)',
                                                 'collision_camera_030 (F)'],
                      'doorpowerpower': ['collision_camera_018 (F)', 'collision_camera_030 (F)'],
                      'doorpowerpower_000': ['collision_camera_000 (F)', 'collision_camera_002 (F)'],
                      'doorpowerpower_002': ['collision_camera_004 (F)', 'collision_camera_005 (F)'],
                      'doorpowerpower_003': ['collision_camera_006 (F)', 'collision_camera_010 (F)'],
                      'doorpowerpower_004': ['collision_camera_006 (F)', 'collision_camera_008 (F)'],
                      'doorpowerpower_005': ['collision_camera_007 (F)', 'collision_camera_010 (F)'],
                      'doorpowerpower_006': ['collision_camera_009 (F)', 'collision_camera_010 (F)'],
                      'doorpowerpower_007': ['collision_camera_007 (F)', 'collision_camera_017 (F)'],
                      'doorpowerpower_008': ['collision_camera_017 (F)', 'collision_camera_019 (F)'],
                      'doorpowerpower_009': ['collision_camera_017 (F)', 'collision_camera_018 (F)'],
                      'doorpowerpower_010': ['collision_camera_016 (F)', 'collision_camera_017 (F)'],
                      'doorpowerpower_011': ['collision_camera_012 (F)', 'collision_camera_016 (F)'],
                      'doorpowerpower_012': ['collision_camera_012 (F)', 'collision_camera_015 (F)'],
                      'doorpowerpower_013': ['collision_camera_012 (F)', 'collision_camera_015 (F)'],
                      'doorpowerpower_014': ['collision_camera_026 (F)', 'collision_camera_027 (F)'],
                      'doorpowerpower_015': ['collision_camera_021 (F)', 'collision_camera_033 (F)'],
                      'doorpowerpower_016': ['collision_camera_003 (F)', 'collision_camera_021 (F)'],
                      'doorpowerpower_017': ['collision_camera_032 (F)', 'collision_camera_033 (F)'],
                      'doorpowerpower_018': ['collision_camera_024 (F)', 'collision_camera_025 (F)'],
                      'doorpowerpower_019': ['collision_camera_022 (F)', 'collision_camera_024 (F)'],
                      'doorpowerpower_020': ['collision_camera_022 (F)', 'collision_camera_023 (F)'],
                      'doorpowerpower_021': ['collision_camera_018 (F)', 'collision_camera_028 (F)'],
                      'doorpowerpower_022': ['collision_camera_028 (F)', 'collision_camera_029 (F)'],
                      'doorpowerpower_023': ['collision_camera_031 (F)', 'collision_camera_034 (F)'],
                      'doorpowerpower_024': ['collision_camera_024 (F)', 'collision_camera_041 (F)'],
                      'doorshieldmissile_000': ['collision_camera_012 (F)',
                                                'collision_camera_015 (F)'],
                      'doorshutter_000': ['collision_camera_017 (F)'],
                      'doorshutter_001': ['collision_camera_017 (F)'],
                      'doorshutter_002': ['collision_camera_017 (F)'],
                      'doorshutter_003': ['collision_camera_017 (F)'],
                      'doorshutter_004': ['collision_camera_034 (F)'],
                      'doorshutter_005': ['collision_camera_034 (F)'],
                      'doorshutter_006': ['collision_camera_040 (F)'],
                      'doorshutter_007': ['collision_camera_001 (F)', 'collision_camera_002 (F)'],
                      'doorwavebeam_000': ['collision_camera_028 (F)', 'collision_camera_029 (F)'],
                      'doorwavebeam_001': ['collision_camera_028 (F)', 'collision_camera_029 (F)'],
                      'doorwavebeam_002': ['collision_camera_031 (F)', 'collision_camera_034 (F)'],
                      'doorwavebeam_003': ['collision_camera_031 (F)', 'collision_camera_034 (F)'],
                      'doorwavebeam_004': ['collision_camera_009 (F)', 'collision_camera_010 (F)'],
                      'doorwavebeam_005': ['collision_camera_009 (F)', 'collision_camera_010 (F)'],
                      'elevator_baselab_000': ['collision_camera_000 (F)'],
                      'elevator_baselab_000_platform': ['collision_camera_000 (F)'],
                      'elevator_baselab_001': ['collision_camera_008 (F)'],
                      'elevator_baselab_001_platform': ['collision_camera_008 (F)'],
                      'elevator_shipyard_000': ['collision_camera_028 (F)'],
                      'elevator_shipyard_000_platform': ['collision_camera_028 (F)'],
                      'emmy_sanc_deactivated': ['collision_camera_040 (F)'],
                      'emmyvalve_reg_gen_000': ['collision_camera_040 (F)'],
                      'emmyvalve_reg_gen_001': ['collision_camera_040 (F)'],
                      'emmyvalve_reg_gen_002': ['collision_camera_003 (F)',
                                                'collision_camera_040 (F)'],
                      'emmyvalve_reg_gen_003': ['collision_camera_003 (F)'],
                      'emmyvalve_reg_gen_004': ['collision_camera_021 (F)'],
                      'emmyvalve_reg_gen_005': ['collision_camera_021 (F)'],
                      'emmyvalve_reg_gen_006': ['collision_camera_033 (F)'],
                      'emmyvalve_reg_gen_007': ['collision_camera_031 (F)'],
                      'emmyvalve_reg_gen_008': ['collision_camera_034 (F)'],
                      'emmyvalve_reg_gen_009': ['collision_camera_034 (F)'],
                      'emmyvalve_reg_gen_010': ['collision_camera_034 (F)'],
                      'emmyvalve_reg_gen_011': ['collision_camera_034 (F)'],
                      'emmyvalve_reg_gen_012': ['collision_camera_034 (F)'],
                      'emmyvalve_reg_gen_013': ['collision_camera_034 (F)'],
                      'emmyvalve_reg_gen_014': ['collision_camera_034 (F)'],
                      'emmyvalve_reg_gen_015': ['collision_camera_034 (F)'],
                      'energyrecharge_000': ['collision_camera_018 (F)'],
                      'energyrecharge_000_platform': ['collision_camera_018 (F)'],
                      'energyrecharge_001': ['collision_camera_019 (F)'],
                      'env_frozen_gen_000': ['collision_camera_010 (F)'],
                      'env_frozen_gen_001': ['collision_camera_018 (F)'],
                      'ev_chozowall': ['collision_camera_040 (F)'],
                      'ev_entercu_cv_001': ['collision_camera_034 (F)', 'collision_camera_038_A (F)'],
                      'ev_gatesealed_sanc_000': ['collision_camera_012 (F)', 'collision_camera_014 (F)'],
                      'ev_ph2drain_activator': ['collision_camera_038_A (F)'],
                      'ev_ph2drain_platform': ['collision_camera_038_A (F)'],
                      'fan_reg_000': ['collision_camera_006 (F)'],
                      'fedship_hol': ['collision_camera_018 (F)'],
                      'footstepplatform_000': ['collision_camera_034 (F)'],
                      'footstepplatform_001': ['collision_camera_034 (F)'],
                      'footstepplatform_002': ['collision_camera_040 (F)'],
                      'footstepplatform_003': ['collision_camera_002 (F)'],
                      'fx_cold_door': ['collision_camera_006 (F)', 'collision_camera_010 (F)'],
                      'fx_cold_door_000': ['collision_camera_007 (F)', 'collision_camera_010 (F)'],
                      'fx_cold_door_001': ['collision_camera_009 (F)', 'collision_camera_010 (F)'],
                      'fx_cold_door_002': ['collision_camera_017 (F)', 'collision_camera_018 (F)'],
                      'fx_cold_door_003': ['collision_camera_018 (F)', 'collision_camera_028 (F)'],
                      'grapplepulloff1x2_000': ['collision_camera_019 (F)'],
                      'grapplepulloff1x2_002': ['collision_camera_018 (F)'],
                      'grapplepulloff1x2_003': ['collision_camera_009 (F)'],
                      'grappleswingpoint_000': ['collision_camera_001 (F)'],
                      'grappleswingpoint_001': ['collision_camera_002 (F)'],
                      'item_energyfragment': ['collision_camera_025 (F)'],
                      'item_energyfragment_000': ['collision_camera_009 (F)'],
                      'item_energyfragment_001': ['collision_camera_020 (F)'],
                      'item_energyfragment_002': ['collision_camera_002 (F)'],
                      'item_missiletank_000': ['collision_camera_013 (F)'],
                      'item_missiletank_001': ['collision_camera_011 (F)'],
                      'item_missiletank_002': ['collision_camera_012 (F)'],
                      'item_missiletank_003': ['collision_camera_030 (F)'],
                      'item_missiletank_004': ['collision_camera_026 (F)'],
                      'item_missiletank_005': ['collision_camera_011 (F)'],
                      'item_missiletankplus_000': ['collision_camera_012 (F)'],
                      'item_missiletankplus_001': ['collision_camera_006 (F)'],
                      'item_powerbombtank_000': ['collision_camera_040 (F)'],
                      'item_powerbombtank_001': ['collision_camera_017 (F)'],
                      'itemsphere_spacejump': ['collision_camera_012 (F)'],
                      'magnetsurface': ['collision_camera_002 (F)'],
                      'magnetsurface_000': ['collision_camera_032 (F)'],
                      'magnetsurface_001': ['collision_camera_004 (F)'],
                      'magnetsurface_002': ['collision_camera_012 (F)'],
                      'magnetsurface_003': ['collision_camera_012 (F)'],
                      'magnetsurface_004': ['collision_camera_012 (F)'],
                      'magnetsurface_005': ['collision_camera_003 (F)'],
                      'magnetsurface_006': ['collision_camera_021 (F)'],
                      'magnetsurface_007': ['collision_camera_021 (F)'],
                      'magnetsurface_008': ['collision_camera_003 (F)'],
                      'magnetsurface_009': ['collision_camera_033 (F)'],
                      'magnetsurface_010': ['collision_camera_021 (F)'],
                      'magnetsurface_011': ['collision_camera_021 (F)'],
                      'magnetsurface_012': ['collision_camera_021 (F)'],
                      'magnetsurface_013': ['collision_camera_021 (F)'],
                      'magnetsurface_014': ['collision_camera_021 (F)'],
                      'magnetsurface_015': ['collision_camera_021 (F)'],
                      'magnetsurface_016': ['collision_camera_033 (F)'],
                      'magnetsurface_017': ['collision_camera_002 (F)'],
                      'magnetsurface_018': ['collision_camera_032 (F)'],
                      'magnetsurface_019': ['collision_camera_034 (F)'],
                      'magnetsurface_020': ['collision_camera_003 (F)'],
                      'magnetsurface_021': ['collision_camera_003 (F)'],
                      'magnetsurface_022': ['collision_camera_003 (F)'],
                      'magnetsurface_023': ['collision_camera_003 (F)'],
                      'magnetsurface_024': ['collision_camera_031 (F)'],
                      'maproom': ['collision_camera_023 (F)'],
                      'maproom_platform': ['collision_camera_023 (F)'],
                      'mblauncher_exit_gen_000': ['collision_camera_034 (F)'],
                      'mblauncher_launcher_gen_000': [],
                      'mlm_block_000': ['collision_camera_024 (F)'],
                      'mlm_block_001': ['collision_camera_015 (F)'],
                      'mlm_block_002': ['collision_camera_019 (F)'],
                      'mlm_block_003': ['collision_camera_030 (F)'],
                      'mlm_point_000': ['collision_camera_024 (F)'],
                      'mlm_point_001': ['collision_camera_024 (F)'],
                      'mlm_point_002': ['collision_camera_024 (F)'],
                      'mlm_point_003': ['collision_camera_024 (F)'],
                      'mlm_point_004': ['collision_camera_024 (F)'],
                      'mlm_point_005': ['collision_camera_015 (F)'],
                      'mlm_point_006': ['collision_camera_015 (F)'],
                      'mlm_point_007': ['collision_camera_015 (F)'],
                      'mlm_point_008': ['collision_camera_015 (F)'],
                      'mlm_point_009': ['collision_camera_015 (F)'],
                      'mlm_point_010': ['collision_camera_019 (F)'],
                      'mlm_point_011': ['collision_camera_019 (F)'],
                      'mlm_point_012': ['collision_camera_019 (F)'],
                      'mlm_point_013': ['collision_camera_019 (F)'],
                      'mlm_point_014': ['collision_camera_019 (F)'],
                      'mlm_point_015': ['collision_camera_030 (F)'],
                      'mlm_point_016': ['collision_camera_030 (F)'],
                      'mlm_point_017': ['collision_camera_030 (F)'],
                      'mlm_point_018': ['collision_camera_030 (F)'],
                      'mlm_point_019': ['collision_camera_030 (F)'],
                      'savestation_000': ['collision_camera_029 (F)'],
                      'savestation_000_platform': ['collision_camera_029 (F)'],
                      'savestation_001': ['collision_camera_041 (F)'],
                      'savestation_001_platform': ['collision_camera_041 (F)'],
                      'spacejump_marker_000': ['collision_camera_012 (F)'],
                      'spacejump_marker_001': ['collision_camera_012 (F)'],
                      'spacejump_marker_002': ['collision_camera_012 (F)'],
                      'tunnelframe': ['collision_camera_031 (F)', 'collision_camera_034 (F)'],
                      'tunnelframe_000': ['collision_camera_034 (F)', 'collision_camera_038_A (F)'],
                      'teleporter_000': ['collision_camera_007 (F)'],
                      'teleporter_000_platform': ['collision_camera_007 (F)'],
                      'totalrechargestation_000': ['collision_camera_002 (F)'],
                      'totalrechargestation_001': ['collision_camera_024 (F)'],
                      'wagontrain_forest_000': ['collision_camera_014 (F)'],
                      'wagontrain_forest_000_platform': ['collision_camera_014 (F)'],
                      'waterzone_000': ['collision_camera_012 (F)'],
                      'waterzone_001': ['collision_camera_001 (F)'],
                      'waterzone_002': ['collision_camera_033 (F)'],
                      'waterzone_003': ['collision_camera_034 (F)'],
                      'waterzone_004': ['collision_camera_001 (F)'],
                      'waterzone_005': ['collision_camera_030 (F)'],
                      'waterzone_006': ['collision_camera_038_A (F)'],
                      'weightactivatedplatform_energy_000': ['collision_camera_019 (F)'],
                      'weightactivatedplatform_total_000': ['collision_camera_002 (F)'],
                      'weightactivatedplatform_total_001': ['collision_camera_024 (F)'],
                      'zipline_bottom_gen_000': ['collision_camera_034 (F)'],
                      'zipline_bottom_gen_002': ['collision_camera_033 (F)'],
                      'zipline_bottom_gen_004': ['collision_camera_032 (F)']},
    's080_shipyard': {'AP_10': ['collision_camera_003 (H)'],
                      'CAM_Default': ['collision_camera_001 (H)'],
                      'CAM_Far_Atrium': ['collision_camera_004 (H)'],
                      'CAM_PreElite': ['collision_camera_006 (H)'],
                      'CAM_PreElite2': ['collision_camera_006 (H)'],
                      'CAM_Train': ['collision_camera_001 (H)'],
                      'CamRailTrain': ['collision_camera_001 (H)'],
                      'CameraRailAtriumEscape': ['collision_camera_004 (H)'],
                      'CameraRailAtriumEscape_Left': ['collision_camera_004 (H)'],
                      'CameraRailAtriumEscape_Right': ['collision_camera_004 (H)'],
                      'CameraRail_PreElite': ['collision_camera_006 (H)'],
                      'CoolShineLeftBottomVisited': ['collision_camera_004 (H)'],
                      'CoolShineLeftTopVisited': ['collision_camera_004 (H)'],
                      'CoolShineRightBottomVisited': ['collision_camera_016 (H)'],
                      'CoolShineRightTopVisited': ['collision_camera_004 (H)'],
                      'CoolShineUpViewed': ['collision_camera_004 (H)'],
                      'CoolShineUpVisited': ['collision_camera_004 (H)'],
                      'LM_Samus_Ship': ['collision_camera_008 (H)'],
                      'LS_EmmyZone': ['collision_camera_012 (H)'],
                      'PRP_CUDeactivated': ['collision_camera_012 (H)'],
                      'PRP_EmmyShipyard': ['collision_camera_014 (H)'],
                      'SP_AccessPoint_10': ['collision_camera_004 (H)'],
                      'SP_AccessPoint_10B': ['collision_camera_009 (H)'],
                      'SP_Checkpoint_CommanderX': ['collision_camera_020 (H)'],
                      'SP_Checkpoint_Dead_CWX_Elite': ['collision_camera_005 (H)'],
                      'SP_Checkpoint_Dead_ChozoWarriorX': ['collision_camera_014 (H)'],
                      'SP_Checkpoint_EliteChozoWarriorX': ['collision_camera_006 (H)'],
                      'SP_Checkpoint_Endgame': ['collision_camera_008 (H)'],
                      'SP_Checkpoint_Escape': ['collision_camera_020 (H)'],
                      'SP_Checkpoint_PowerBomb': ['collision_camera_011 (H)'],
                      'SP_Checkpoint_StrongReaction': ['collision_camera_009 (H)'],
                      'SP_Emmy': ['collision_camera_013 (H)'],
                      'StartPoint0': ['collision_camera_001 (H)'],
                      'TG_Activation_Escape_Sequence': ['collision_camera_020 (H)'],
                      'TG_ChangeCamera_005_B': ['collision_camera_005 (H)'],
                      'TG_ChangeCamera_006_B': ['collision_camera_006 (H)'],
                      'TG_ChangeCamera_009_B': ['collision_camera_009 (H)'],
                      'TG_ChangeCamera_009_C': ['collision_camera_009 (H)'],
                      'TG_ChangeCamera_013_B': ['collision_camera_013 (H)'],
                      'TG_ChangeCamera_013_C': ['collision_camera_013 (H)'],
                      'TG_ChangeCamera_014_B': ['collision_camera_014 (H)'],
                      'TG_CoolShineLeftBottom': ['collision_camera_004 (H)'],
                      'TG_CoolShineLeftTop': ['collision_camera_004 (H)'],
                      'TG_CoolShineRightBottom': ['collision_camera_016 (H)'],
                      'TG_CoolShineRightTop': ['collision_camera_004 (H)'],
                      'TG_CoolShineUp': ['collision_camera_004 (H)'],
                      'TG_Cool_Shinespark_Begin': ['collision_camera_004 (H)'],
                      'TG_Cool_Shinespark_End': ['collision_camera_004 (H)'],
                      'TG_EscapeSequence_Drop_01': ['collision_camera_015 (H)'],
                      'TG_EscapeSequence_Drop_02': ['collision_camera_015 (H)'],
                      'TG_EscapeSequence_Drop_03': ['collision_camera_011 (H)'],
                      'TG_EscapeSequence_Drop_04': ['collision_camera_004 (H)'],
                      'accesspoint_000': ['collision_camera_003 (H)'],
                      'ammorecharge_000': ['collision_camera_004 (H)'],
                      'ammorecharge_000_platform': ['collision_camera_004 (H)'],
                      'block_cut43': ['collision_camera_014 (H)'],
                      'block_hyperbeam_000': ['collision_camera_004 (H)'],
                      'block_pbtube': ['collision_camera_004 (H)'],
                      'block_pbtube_003': ['collision_camera_004 (H)'],
                      'block_pbtube_2': ['collision_camera_013 (H)'],
                      'breakablehint_000': ['collision_camera_009 (H)'],
                      'breakablehint_001': ['collision_camera_006 (H)'],
                      'breakabletilegroup_000': ['collision_camera_020 (H)'],
                      'breakabletilegroup_001': ['collision_camera_019 (H)'],
                      'breakabletilegroup_002': ['collision_camera_019 (H)'],
                      'breakabletilegroup_003': ['collision_camera_019 (H)'],
                      'breakabletilegroup_004': ['collision_camera_018 (H)'],
                      'breakabletilegroup_006': ['collision_camera_018 (H)'],
                      'breakabletilegroup_007': ['collision_camera_018 (H)'],
                      'breakabletilegroup_008': ['collision_camera_018 (H)'],
                      'breakabletilegroup_009': ['collision_camera_018 (H)'],
                      'breakabletilegroup_010': ['collision_camera_018 (H)'],
                      'breakabletilegroup_011': ['collision_camera_015 (H)'],
                      'breakabletilegroup_012': ['collision_camera_016 (H)'],
                      'breakabletilegroup_013': ['collision_camera_016 (H)'],
                      'breakabletilegroup_014': ['collision_camera_016 (H)'],
                      'breakabletilegroup_015': ['collision_camera_016 (H)'],
                      'breakabletilegroup_016': ['collision_camera_016 (H)'],
                      'breakabletilegroup_017': ['collision_camera_016 (H)'],
                      'breakabletilegroup_018': ['collision_camera_016 (H)'],
                      'breakabletilegroup_020': ['collision_camera_016 (H)'],
                      'breakabletilegroup_021': ['collision_camera_016 (H)'],
                      'breakabletilegroup_022': ['collision_camera_016 (H)'],
                      'breakabletilegroup_023': ['collision_camera_016 (H)'],
                      'breakabletilegroup_025': ['collision_camera_016 (H)'],
                      'breakabletilegroup_026': ['collision_camera_016 (H)'],
                      'breakabletilegroup_027': ['collision_camera_016 (H)'],
                      'breakabletilegroup_028': ['collision_camera_016 (H)'],
                      'breakabletilegroup_029': ['collision_camera_016 (H)'],
                      'breakabletilegroup_030': ['collision_camera_009 (H)'],
                      'breakabletilegroup_031': ['collision_camera_004 (H)'],
                      'breakabletilegroup_032': ['collision_camera_004 (H)'],
                      'breakabletilegroup_033': ['collision_camera_010 (H)'],
                      'breakabletilegroup_034': ['collision_camera_011 (H)'],
                      'breakabletilegroup_035': ['collision_camera_015 (H)'],
                      'breakabletilegroup_036': ['collision_camera_002 (H)'],
                      'breakabletilegroup_037': ['collision_camera_015 (H)'],
                      'breakabletilegroup_038': ['collision_camera_002 (H)'],
                      'breakabletilegroup_039': ['collision_camera_002 (H)'],
                      'breakabletilegroup_040': ['collision_camera_002 (H)'],
                      'breakabletilegroup_041': ['collision_camera_002 (H)'],
                      'breakabletilegroup_042': ['collision_camera_002 (H)'],
                      'breakabletilegroup_043': ['collision_camera_002 (H)'],
                      'breakabletilegroup_044': ['collision_camera_016 (H)'],
                      'breakabletilegroup_045': ['collision_camera_010 (H)'],
                      'breakabletilegroup_046': ['collision_camera_009 (H)'],
                      'breakabletilegroup_047': ['collision_camera_011 (H)'],
                      'breakabletilegroup_049': ['collision_camera_006 (H)'],
                      'breakablevignette_Escape_001': ['collision_camera_015 (H)'],
                      'breakablevignette_Escape_002': ['collision_camera_016 (H)'],
                      'capsulelaunchershipyard_000': ['collision_camera_007 (H)'],
                      'centralunitmagmacontroller_000': ['collision_camera_012 (H)'],
                      'centralunitshipyard': ['collision_camera_012 (H)'],
                      'doorclosedpower_000': ['collision_camera_003 (H)', 'collision_camera_009 (H)'],
                      'doorclosedpower_001': ['collision_camera_009 (H)', 'collision_camera_010 (H)'],
                      'dooremmy_000': ['collision_camera_010 (H)', 'collision_camera_011 (H)'],
                      'dooremmy_001': ['collision_camera_010 (H)', 'collision_camera_011 (H)'],
                      'dooremmy_002': ['collision_camera_013 (H)', 'collision_camera_015 (H)'],
                      'dooremmy_003': ['collision_camera_013 (H)', 'collision_camera_015 (H)'],
                      'doorpowerclosed_000': ['collision_camera_009 (H)', 'collision_camera_010 (H)'],
                      'doorpowerclosed_001': ['collision_camera_011 (H)', 'collision_camera_014 (H)'],
                      'doorpowerpower_000': ['collision_camera_001 (H)', 'collision_camera_004 (H)'],
                      'doorpowerpower_001': ['collision_camera_003 (H)', 'collision_camera_004 (H)'],
                      'doorpowerpower_002': ['collision_camera_003 (H)', 'collision_camera_009 (H)'],
                      'doorpowerpower_004': ['collision_camera_000 (H)', 'collision_camera_002 (H)'],
                      'doorpowerpower_005': ['collision_camera_004 (H)', 'collision_camera_006 (H)'],
                      'doorpowerpower_006': ['collision_camera_005 (H)', 'collision_camera_006 (H)'],
                      'doorpowerpower_007': ['collision_camera_005 (H)', 'collision_camera_007 (H)'],
                      'doorwavebeam': ['collision_camera_005 (H)', 'collision_camera_006 (H)'],
                      'doorwavebeam_000': ['collision_camera_009 (H)', 'collision_camera_010 (H)'],
                      'doorwavebeam_001': ['collision_camera_011 (H)', 'collision_camera_014 (H)'],
                      'doorwavebeam_002': ['collision_camera_004 (H)', 'collision_camera_006 (H)'],
                      'doorwavebeam_003': ['collision_camera_003 (H)', 'collision_camera_009 (H)'],
                      'elevator_sanctuary_000': ['collision_camera_000 (H)'],
                      'elevator_sanctuary_000_platform': ['collision_camera_000 (H)'],
                      'elevator_skybase_000_platform': ['collision_camera_007 (H)'],
                      'emmyvalve_reg_gen_000': ['collision_camera_013 (H)'],
                      'emmyvalve_reg_gen_001': ['collision_camera_014 (H)'],
                      'escape_explosion_big': ['collision_camera_008 (H)'],
                      'escape_explosion_big_000': ['collision_camera_008 (H)'],
                      'escape_explosion_big_001': ['collision_camera_008 (H)'],
                      'escape_explosion_big_002': ['collision_camera_008 (H)'],
                      'escape_explosion_big_003': ['collision_camera_008 (H)'],
                      'escape_explosion_big_004': ['collision_camera_008 (H)'],
                      'escape_explosion_big_005': ['collision_camera_008 (H)'],
                      'escape_explosion_big_006': ['collision_camera_008 (H)'],
                      'escape_explosion_big_008': ['collision_camera_008 (H)'],
                      'escape_explosion_big_009': ['collision_camera_008 (H)'],
                      'escape_explosion_big_010': ['collision_camera_008 (H)'],
                      'escape_explosion_big_011': ['collision_camera_008 (H)'],
                      'escape_explosion_big_012': ['collision_camera_008 (H)'],
                      'escape_explosion_big_013': ['collision_camera_008 (H)'],
                      'escape_explosion_big_014': ['collision_camera_008 (H)'],
                      'escape_explosion_big_015': ['collision_camera_004 (H)'],
                      'escape_explosion_big_016': ['collision_camera_004 (H)'],
                      'escape_explosion_big_017': ['collision_camera_004 (H)'],
                      'escape_explosion_big_018': ['collision_camera_004 (H)'],
                      'escape_explosion_big_019': ['collision_camera_004 (H)'],
                      'escape_explosion_big_020': ['collision_camera_004 (H)'],
                      'escape_explosion_big_021': ['collision_camera_004 (H)'],
                      'escape_explosion_big_022': ['collision_camera_004 (H)'],
                      'escape_explosion_big_023': ['collision_camera_004 (H)'],
                      'escape_explosion_big_024': ['collision_camera_004 (H)'],
                      'escape_explosion_big_025': ['collision_camera_004 (H)'],
                      'escape_explosion_big_026': ['collision_camera_004 (H)'],
                      'escape_explosion_big_027': ['collision_camera_019 (H)'],
                      'escape_explosion_big_028': ['collision_camera_018 (H)'],
                      'escape_explosion_big_029': ['collision_camera_019 (H)'],
                      'escape_explosion_big_030': ['collision_camera_018 (H)'],
                      'escape_explosion_big_031': ['collision_camera_018 (H)'],
                      'escape_explosion_big_032': ['collision_camera_015 (H)'],
                      'escape_explosion_big_033': ['collision_camera_015 (H)'],
                      'escape_explosion_big_034': ['collision_camera_015 (H)'],
                      'escape_explosion_big_035': ['collision_camera_013 (H)'],
                      'escape_explosion_big_036': ['collision_camera_013 (H)'],
                      'escape_explosion_big_037': ['collision_camera_013 (H)'],
                      'escape_explosion_big_038': ['collision_camera_012 (H)'],
                      'escape_explosion_big_039': ['collision_camera_012 (H)'],
                      'escape_explosion_big_040': ['collision_camera_012 (H)'],
                      'escape_explosion_big_041': ['collision_camera_011 (H)'],
                      'escape_explosion_big_042': ['collision_camera_011 (H)'],
                      'escape_explosion_big_043': ['collision_camera_010 (H)'],
                      'escape_explosion_big_044': ['collision_camera_010 (H)'],
                      'escape_explosion_big_045': ['collision_camera_010 (H)'],
                      'escape_explosion_big_046': ['collision_camera_010 (H)'],
                      'escape_explosion_big_047': ['collision_camera_010 (H)'],
                      'escape_explosion_big_048': ['collision_camera_011 (H)'],
                      'escape_explosion_big_049': ['collision_camera_011 (H)'],
                      'escape_explosion_big_050': ['collision_camera_016 (H)'],
                      'escape_explosion_big_051': ['collision_camera_016 (H)'],
                      'escape_explosion_big_052': ['collision_camera_016 (H)'],
                      'escape_explosion_big_053': ['collision_camera_016 (H)'],
                      'escape_explosion_big_054': ['collision_camera_016 (H)'],
                      'escape_explosion_big_055': ['collision_camera_016 (H)'],
                      'escape_explosion_big_056': ['collision_camera_016 (H)'],
                      'escape_explosion_big_057': ['collision_camera_016 (H)'],
                      'escape_explosion_big_058': ['collision_camera_016 (H)'],
                      'escape_explosion_big_059': ['collision_camera_016 (H)'],
                      'escape_explosion_big_060': ['collision_camera_016 (H)'],
                      'escape_explosion_big_061': ['collision_camera_016 (H)'],
                      'escape_explosion_big_062': ['collision_camera_016 (H)'],
                      'escape_explosion_big_063': ['collision_camera_016 (H)'],
                      'escape_explosion_big_064': ['collision_camera_016 (H)'],
                      'escape_explosion_big_065': ['collision_camera_016 (H)'],
                      'escape_explosion_big_066': ['collision_camera_016 (H)'],
                      'escape_explosion_big_067': ['collision_camera_016 (H)'],
                      'escape_explosion_big_068': ['collision_camera_004 (H)'],
                      'escape_explosion_big_069': ['collision_camera_004 (H)'],
                      'escape_explosion_big_070': ['collision_camera_008 (H)'],
                      'escape_explosion_big_071': ['collision_camera_008 (H)'],
                      'escape_explosion_medium': ['collision_camera_011 (H)'],
                      'escape_explosion_medium_000': ['collision_camera_011 (H)'],
                      'escape_explosion_medium_001': ['collision_camera_010 (H)'],
                      'escape_explosion_medium_002': ['collision_camera_010 (H)'],
                      'escape_explosion_medium_003': ['collision_camera_010 (H)'],
                      'escape_explosion_medium_004': ['collision_camera_010 (H)'],
                      'escape_explosion_medium_005': ['collision_camera_011 (H)'],
                      'escape_explosion_medium_006': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_007': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_008': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_009': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_010': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_011': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_012': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_013': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_014': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_015': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_016': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_017': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_018': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_019': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_020': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_021': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_022': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_023': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_024': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_025': ['collision_camera_011 (H)'],
                      'escape_explosion_medium_026': ['collision_camera_010 (H)'],
                      'escape_explosion_medium_027': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_028': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_029': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_030': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_031': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_032': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_033': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_034': ['collision_camera_019 (H)'],
                      'escape_explosion_medium_035': ['collision_camera_018 (H)'],
                      'escape_explosion_medium_036': ['collision_camera_019 (H)'],
                      'escape_explosion_medium_037': ['collision_camera_018 (H)'],
                      'escape_explosion_medium_038': ['collision_camera_018 (H)'],
                      'escape_explosion_medium_039': ['collision_camera_018 (H)'],
                      'escape_explosion_medium_040': ['collision_camera_015 (H)'],
                      'escape_explosion_medium_041': ['collision_camera_015 (H)'],
                      'escape_explosion_medium_042': ['collision_camera_015 (H)'],
                      'escape_explosion_medium_043': ['collision_camera_013 (H)'],
                      'escape_explosion_medium_044': ['collision_camera_013 (H)'],
                      'escape_explosion_medium_045': ['collision_camera_013 (H)'],
                      'escape_explosion_medium_046': ['collision_camera_012 (H)'],
                      'escape_explosion_medium_047': ['collision_camera_012 (H)'],
                      'escape_explosion_medium_048': ['collision_camera_012 (H)'],
                      'escape_explosion_medium_049': ['collision_camera_016 (H)'],
                      'escape_explosion_medium_050': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_051': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_052': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_053': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_054': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_055': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_056': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_057': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_058': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_059': ['collision_camera_004 (H)'],
                      'escape_explosion_medium_060': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_061': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_062': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_063': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_064': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_065': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_066': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_067': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_068': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_069': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_070': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_071': ['collision_camera_008 (H)'],
                      'escape_explosion_medium_072': ['collision_camera_008 (H)'],
                      'escape_explosion_path_01': ['collision_camera_015 (H)'],
                      'escape_explosion_path_02': ['collision_camera_015 (H)'],
                      'escape_explosion_path_03': ['collision_camera_011 (H)'],
                      'escape_explosion_small': ['collision_camera_011 (H)'],
                      'escape_explosion_small_000': ['collision_camera_019 (H)'],
                      'escape_explosion_small_001': ['collision_camera_018 (H)'],
                      'escape_explosion_small_002': ['collision_camera_018 (H)'],
                      'escape_explosion_small_003': ['collision_camera_015 (H)'],
                      'escape_explosion_small_004': ['collision_camera_015 (H)'],
                      'escape_explosion_small_005': ['collision_camera_013 (H)'],
                      'escape_explosion_small_006': ['collision_camera_013 (H)'],
                      'escape_explosion_small_007': ['collision_camera_012 (H)'],
                      'escape_explosion_small_008': ['collision_camera_012 (H)'],
                      'escape_explosion_small_009': ['collision_camera_018 (H)'],
                      'escape_explosion_small_010': ['collision_camera_019 (H)'],
                      'escape_explosion_small_011': ['collision_camera_019 (H)'],
                      'escape_explosion_small_012': ['collision_camera_018 (H)'],
                      'escape_explosion_small_013': ['collision_camera_015 (H)'],
                      'escape_explosion_small_014': ['collision_camera_013 (H)'],
                      'escape_explosion_small_015': ['collision_camera_012 (H)'],
                      'escape_explosion_small_016': ['collision_camera_011 (H)'],
                      'escape_explosion_small_017': ['collision_camera_010 (H)'],
                      'escape_explosion_small_018': ['collision_camera_010 (H)'],
                      'escape_explosion_small_019': ['collision_camera_010 (H)'],
                      'escape_explosion_small_020': ['collision_camera_010 (H)'],
                      'escape_explosion_small_021': ['collision_camera_010 (H)'],
                      'escape_explosion_small_022': ['collision_camera_011 (H)'],
                      'escape_explosion_small_023': ['collision_camera_011 (H)'],
                      'escape_explosion_small_024': ['collision_camera_016 (H)'],
                      'escape_explosion_small_025': ['collision_camera_016 (H)'],
                      'escape_explosion_small_026': ['collision_camera_016 (H)'],
                      'escape_explosion_small_027': ['collision_camera_016 (H)'],
                      'escape_explosion_small_028': ['collision_camera_016 (H)'],
                      'escape_explosion_small_029': ['collision_camera_016 (H)'],
                      'escape_explosion_small_030': ['collision_camera_016 (H)'],
                      'escape_explosion_small_031': ['collision_camera_016 (H)'],
                      'escape_explosion_small_032': ['collision_camera_016 (H)'],
                      'escape_explosion_small_033': ['collision_camera_016 (H)'],
                      'escape_explosion_small_034': ['collision_camera_016 (H)'],
                      'escape_explosion_small_035': ['collision_camera_016 (H)'],
                      'escape_explosion_small_036': ['collision_camera_016 (H)'],
                      'escape_explosion_small_037': ['collision_camera_016 (H)'],
                      'escape_explosion_small_038': ['collision_camera_016 (H)'],
                      'escape_explosion_small_039': ['collision_camera_016 (H)'],
                      'escape_explosion_small_040': ['collision_camera_016 (H)'],
                      'escape_explosion_small_041': ['collision_camera_016 (H)'],
                      'escape_explosion_small_042': ['collision_camera_016 (H)'],
                      'escape_explosion_small_043': ['collision_camera_016 (H)'],
                      'escape_explosion_small_044': ['collision_camera_004 (H)'],
                      'escape_explosion_small_045': ['collision_camera_004 (H)'],
                      'escape_explosion_small_046': ['collision_camera_004 (H)'],
                      'escape_explosion_small_047': ['collision_camera_004 (H)'],
                      'escape_explosion_small_048': ['collision_camera_004 (H)'],
                      'escape_explosion_small_049': ['collision_camera_004 (H)'],
                      'escape_explosion_small_050': ['collision_camera_004 (H)'],
                      'escape_explosion_small_051': ['collision_camera_004 (H)'],
                      'escape_explosion_small_052': ['collision_camera_004 (H)'],
                      'escape_explosion_small_053': ['collision_camera_004 (H)'],
                      'escape_explosion_small_054': ['collision_camera_004 (H)'],
                      'escape_explosion_small_055': ['collision_camera_004 (H)'],
                      'escape_explosion_small_056': ['collision_camera_008 (H)'],
                      'escape_explosion_small_057': ['collision_camera_008 (H)'],
                      'escape_explosion_small_058': ['collision_camera_008 (H)'],
                      'escape_explosion_small_059': ['collision_camera_008 (H)'],
                      'escape_explosion_small_060': ['collision_camera_008 (H)'],
                      'escape_explosion_small_061': ['collision_camera_008 (H)'],
                      'escape_explosion_small_062': ['collision_camera_008 (H)'],
                      'escape_explosion_small_063': ['collision_camera_008 (H)'],
                      'escape_explosion_small_064': ['collision_camera_008 (H)'],
                      'escape_explosion_small_065': ['collision_camera_008 (H)'],
                      'escape_explosion_small_066': ['collision_camera_008 (H)'],
                      'escape_explosion_small_067': ['collision_camera_008 (H)'],
                      'escape_explosion_small_068': ['collision_camera_008 (H)'],
                      'escape_glass_01': ['collision_camera_004 (H)'],
                      'escape_glass_02': ['collision_camera_004 (H)'],
                      'escape_glass_03': ['collision_camera_004 (H)'],
                      'ev_escape_1': ['collision_camera_015 (H)'],
                      'ev_escape_2_end': ['collision_camera_011 (H)'],
                      'ev_escape_2_init': ['collision_camera_011 (H)'],
                      'ev_escape_3': ['collision_camera_004 (H)'],
                      'ev_escape_4': ['collision_camera_015 (H)'],
                      'ev_evacuation': ['collision_camera_020 (H)'],
                      'ev_shi_ray02_005': [],
                      'ev_shi_rayimpact01': ['collision_camera_009 (H)'],
                      'grapplepulloff1x2': ['collision_camera_002 (H)', 'collision_camera_009 (H)'],
                      'grapplepulloff1x2_000': ['collision_camera_002 (H)'],
                      'grapplepulloff1x2_001': ['collision_camera_006 (H)'],
                      'item_missiletank': ['collision_camera_002 (H)'],
                      'item_missiletank_000': ['collision_camera_006 (H)'],
                      'item_powerbombtank_000': ['collision_camera_009 (H)'],
                      'mapev_atriumdebris': ['collision_camera_004 (H)'],
                      'sg_vignette000': ['collision_camera_004 (H)'],
                      'sg_vignette001': ['collision_camera_016 (H)'],
                      'totalrechargestation_000': ['collision_camera_015 (H)'],
                      'totalrechargestation_001': ['collision_camera_006 (H)'],
                      'trigger_PowerBombObtained': ['collision_camera_014 (H)'],
                      'wagontrain_forest_000': ['collision_camera_001 (H)'],
                      'wagontrain_forest_000_platform': ['collision_camera_001 (H)'],
                      'weightactivatedplatform_access_000': ['collision_camera_003 (H)'],
                      'weightactivatedplatform_total_000': ['collision_camera_015 (H)'],
                      'weightactivatedplatform_total_001': ['collision_camera_006 (H)']},
    's090_skybase': {
        'CAM_Default': ['collision_camera_001 (I)'],
        'CAM_Far': ['collision_camera_001 (I)'],
        'CAM_Near': ['collision_camera_002 (I)'],
        'CAM_Near_Left': ['collision_camera_002 (I)'],
        'CAM_Near_Right': ['collision_camera_002 (I)'],
        'SP_Checkpoint_Commander': ['collision_camera_002 (I)'],
        'StartPoint0': ['collision_camera_001 (I)'],
        'TG_ChangeCamera_002_Far': ['collision_camera_002 (I)'],
        'TG_ChangeCamera_002_Near': ['collision_camera_002 (I)'],
        'TG_ChangeInterp_002': ['collision_camera_002 (I)'],
        'TG_Snapshot_Checkpoint_Commander': ['collision_camera_002 (I)'],
        'accesspoint_vignette': ['collision_camera_005 (I)'],
        'accesspointcommander_000': ['collision_camera_005 (I)'],
        'block_pbcolumn_000': ['collision_camera_002 (I)'],
        'camerarailpath_000': ['collision_camera_001 (I)'],
        'camerarailpath_Raven': ['collision_camera_002 (I)'],
        'capsule_commander_000': [],
        'capsuleelevatorskybase_000': ['collision_camera_001 (I)'],
        'commander_elevator': ['collision_camera_002 (I)'],
        'doorpowerpower_000': ['collision_camera_000 (I)', 'collision_camera_001 (I)'],
        'doorpowerpower_001': ['collision_camera_000 (I)', 'collision_camera_002 (I)'],
        'elevator_shipyard_000_platform': ['collision_camera_001 (I)'],
        'energyfield': ['collision_camera_004 (I)'],
        'energyfield_grabs': ['collision_camera_004 (I)'],
        'savestation_000': ['collision_camera_000 (I)'],
        'savestation_000_platform': ['collision_camera_000 (I)'],
        'skybase_000': [],
        'totalrechargestation_000': ['collision_camera_001 (I)'],
        'weightactivatedplatform_commanderelevator_000': ['collision_camera_002 (I)'],
        'weightactivatedplatform_total_000': ['collision_camera_001 (I)']}}

_usable_component_to_node_name = {
    "CAccessPointComponent": "Navigation Room",
    "CSaveStationUsableComponent": "Save Station",
    "CLifeRechargeComponent": "Life Recharge",
    "CAmmoRechargeComponent": "Ammo Recharge",
    "CMapAcquisitionComponent": "Map Station",
    "CTotalRechargeComponent": "Total Recharge",

    "CElevatorCommanderUsableComponent": "Raven Beak Elevator",

    "CWaterPlatformUsableComponent": "Event - Water Device",
    "CThermalDeviceComponent": "Event - Thermal Device",
    "CElectricGeneratorComponent": "Event - Electric Generator",
}
_usable_component_as_event_node = {
    "CWaterPlatformUsableComponent",
    "CThermalDeviceComponent",
    "CElectricGeneratorComponent",
}


def create_event(layer_name: str, actor_name: str) -> str:
    level_name = os.path.splitext(os.path.split(brfld_path)[1])[0]
    short_name = f"{level_name}:{layer_name}:{actor_name}"
    events[short_name] = {
        "long_name": f"{world_names[brfld_path]} - {actor_name}",
        "extra": {},
    }
    return short_name


class NodeDefinition(typing.NamedTuple):
    name: str
    data: dict[str, typing.Any]


class ActorDetails:
    def __init__(self, layer_name: str, actor: construct.Container, all_rooms: dict[str, Polygon]):
        level_name = os.path.splitext(os.path.split(brfld_path)[1])[0]
        self.actor = actor
        self.actor_def = os.path.splitext(os.path.split(actor.oActorDefLink)[1])[0]
        self.actor_layer = layer_name
        self.position = Point(actor.vPos)
        try:
            self.rooms = [room for room in _rooms_for_actors[level_name][actor.sName] if room in all_rooms]
        except KeyError:
            self.rooms = []
        if not self.rooms:
            self.rooms: list[str] = [name for name, pol in all_rooms.items() if pol.contains(self.position)]

        self.is_door = "LIFE" in actor.pComponents and "CDoorLifeComponent" == actor.pComponents.LIFE["@type"]
        self.is_door = self.is_door or "SENSORDOOR" in actor.pComponents or self.actor_def == "dooremmy"
        self.is_start_point = "STARTPOINT" in actor.pComponents and "dooremmy" not in self.actor_def
        self.is_pickup = "actors/items" in actor.oActorDefLink
        self.is_elevator = "USABLE" in actor.pComponents and actor.pComponents.USABLE["@type"] in _ELEVATOR_USABLE
        self.is_usable = "USABLE" in actor.pComponents
        self.is_breakable_blob = "BREAKABLESCENARIO" in actor.pComponents or "grapplepulloff" in self.actor_def

    def create_node_template(
            self, node_type: str,
            default_name: str,
            existing_data: typing.Optional[dict[str, NodeDefinition]],
    ) -> NodeDefinition:

        result: dict = {
            "node_type": node_type,
            "heal": False,
            "coordinates": {
                "x": self.actor.vPos[0],
                "y": self.actor.vPos[1],
                "z": self.actor.vPos[2],
            },
            "description": "",
            "extra": {
                "actor_name": self.actor.sName,
                "actor_def": self.actor.oActorDefLink,
            },
        }
        if self.actor_layer != "default":
            result["extra"]["actor_layer"] = self.actor_layer

        if node_type == "dock":
            result["destination"] = {
                "world_name": None,
                "area_name": None,
                "node_name": None,
            }
            result["dock_type"] = "other"
            result["dock_weakness"] = "Not Determined"

        elif node_type == "pickup":
            result["pickup_index"] = None
            result["major_location"] = None

        elif node_type == "teleporter":
            result["destination"] = {
                "world_name": None,
                "area_name": None,
            }
            result["keep_name_when_vanilla"] = True
            result["editable"] = True

        elif node_type == "event":
            result["event_name"] = None

        if existing_data is not None and self.actor.sName in existing_data:
            old_node_data = existing_data[self.actor.sName]
            node_name = old_node_data.name
            if node_type == "generic" and old_node_data.data["node_type"] != "generic":
                new_result = copy.deepcopy(old_node_data.data)
                new_result["coordinates"] = result["coordinates"]
                new_result["extra"].update(result["extra"])
                result = new_result
            else:
                result["heal"] = old_node_data.data["heal"]
                result["description"] = old_node_data.data["description"]
                result["connections"] = old_node_data.data["connections"]
                for extra_key in old_node_data.data["extra"]:
                    if extra_key not in result["extra"]:
                        result["extra"][extra_key] = old_node_data.data["extra"][extra_key]
        else:
            node_name = default_name
            result["connections"] = {}

        return NodeDefinition(node_name, result)


def _find_room_orientation(world: dict, room_a: str, room_b: str):
    a_bounds = world["areas"][room_a]["extra"]["total_boundings"]
    b_bounds = world["areas"][room_b]["extra"]["total_boundings"]
    a_cx = (a_bounds["x1"] + a_bounds["x2"]) / 2
    b_cx = (b_bounds["x1"] + b_bounds["x2"]) / 2
    if a_cx < b_cx:
        return 0, 1
    elif a_cx > b_cx:
        return 1, 0
    else:
        raise ValueError(f"{room_a} and {room_b} are aligned")


def get_def_link_for_entity(actor_ref: str) -> typing.Optional[str]:
    a = brfld.follow_link(actor_ref)
    if a is not None:
        return a.oActorDefLink


def create_door_nodes_for_actor(
        details: ActorDetails,
        node_data_for_area: dict[str, dict[str, NodeDefinition]],
        world: dict
) -> list[NodeDefinition]:
    actor = details.actor

    extra = {}
    if "LIFE" in actor.pComponents:
        extra = {
            "left_shield_entity": actor.pComponents.LIFE.wpLeftDoorShieldEntity,
            "left_shield_def": get_def_link_for_entity(actor.pComponents.LIFE.wpLeftDoorShieldEntity),
            "right_shield_entity": actor.pComponents.LIFE.wpRightDoorShieldEntity,
            "right_shield_def": get_def_link_for_entity(actor.pComponents.LIFE.wpRightDoorShieldEntity),
        }

    simple = {"def": details.actor_def,
              "left": extra.get("left_shield_def"),
              "right": extra.get("right_shield_def")}

    left_room, right_room = _find_room_orientation(world, *details.rooms)

    custom_weakness = [None, None]
    if simple["left"] == simple["right"] and simple["left"] is None:
        if details.actor_def in _weakness_table_for_def:
            custom_weakness[left_room], custom_weakness[right_room] = _weakness_table_for_def[details.actor_def]
        else:
            print(f"no weakness for {details.actor_def} without shields")

    doors: list[NodeDefinition] = [
        details.create_node_template("dock", f"Door ({actor.sName})", node_data_for_area.get(room_name))
        for room_name in details.rooms
    ]
    for i, definition in enumerate(doors):
        definition.data["extra"].update(extra)
        definition.data["destination"]["world_name"] = world["name"]
        definition.data["destination"]["area_name"] = details.rooms[(i + 1) % 2]
        definition.data["destination"]["node_name"] = doors[(i + 1) % 2].name
        if custom_weakness[i] is not None:
            definition.data["dock_type"] = _dock_type_for_weakness.get(custom_weakness[i], "door")
            definition.data["dock_weakness"] = custom_weakness[i]

    return doors


def get_actor_name_for_node(node: dict) -> str:
    for variable in ["actor_name", "start_point_actor_name"]:
        if variable in node["extra"]:
            return node["extra"][variable]


def decode_world(root: Path, target_level: str, out_path: Path, only_update_existing_areas: bool = True,
                 skip_existing_actors: bool = True):
    global pickup_index, bmscc, brsa, brfld, brfld_path
    all_names = dread_data.all_asset_id_to_name()
    game = Game.DREAD

    pkg_editor = FileTreeEditor(root, Game.DREAD)

    for asset_id, name in all_names.items():
        if target_level not in name:
            continue

        if name.endswith("bmscc"):
            print(f"Reading {name}...")
            bmscc = Bmscc.parse(pkg_editor.get_raw_asset(asset_id), game)

        elif name.endswith("brsa"):
            print(f"Reading {name}...")
            brsa = Brsa.parse(pkg_editor.get_raw_asset(asset_id), game)

        elif name.endswith("brfld"):
            print(f"Reading {name}...")
            brfld = Brfld.parse(pkg_editor.get_raw_asset(asset_id), game)
            brfld_path = name

    if bmscc is None or brsa is None or brfld is None:
        raise ValueError("DATA IS NONE")

    cams: dict[str, set[str]] = {}

    for setup in brsa.raw.Root.pSubareaManager.vSubareaSetups:
        for config in setup.vSubareaConfigs:
            for cam in config.vsCameraCollisionsIds:
                cams[cam] = cams.get(cam, set())
                if config.sCharclassGroupId:
                    cams[cam].add(config.sCharclassGroupId)

    all_rooms = {}

    area_name_by_world_and_actor = _get_area_name_from_actors_in_existing_db(out_path)

    try:
        with out_path.joinpath(f"{world_names[brfld_path]}.json").open() as f:
            world: dict = json.load(f)
    except FileNotFoundError:
        world: dict = {
            "name": world_names[brfld_path],
            "extra": {
                "asset_id": brfld_path,
            },
            "areas": {}
        }

    area_names = {
        entry.name: f"{entry.name} ({world_names[brfld_path][0]})"
        for entry in bmscc.raw.layers[0].entries
    }
    node_data_for_area: dict[str, dict[str, NodeDefinition]] = {}
    for area_name, area_data in world["areas"].items():
        if "asset_id" in area_data["extra"]:
            area_names[area_data["extra"]["asset_id"]] = area_name
            node_data_for_area[area_name] = {}
            for node_name, node_data in area_data["nodes"].items():
                node_data_for_area[area_name][get_actor_name_for_node(node_data)] = NodeDefinition(node_name, node_data)

    for entry in bmscc.raw.layers[0].entries:
        assert entry.type == "POLYCOLLECTION2D"

        x1, y1, x2, y2 = entry.data.total_boundings
        if abs(x1) > 59999 or abs(y1) > 59999 or abs(x2) > 59999 or abs(y2) > 59999:
            continue

        if entry.name not in cams:
            continue

        area_name = area_names[entry.name]

        if (target_level, entry.name) in _camera_skip:
            world["areas"].pop(area_name, None)
            continue

        assert len(entry.data.polys) == 1
        raw_vertices = []
        for v in entry.data.polys[0].points:
            raw_vertices.append((v.x, v.y))

        raw_vertices = _polygon_override.get((target_level, entry.name), raw_vertices)
        vertices = numpy.array(raw_vertices)

        all_rooms[area_name] = Polygon(vertices)
        if only_update_existing_areas and area_name in world["areas"]:
            continue

        world["areas"][area_name] = {
            "default_node": None,
            "valid_starting_location": False,
            "extra": {
                "total_boundings": {
                    "x1": x1,
                    "x2": x2,
                    "y1": y1,
                    "y2": y2,
                },
                "polygon": raw_vertices,
                "asset_id": entry.name,
            },
            "nodes": {},
        }

    all_default_details: dict[tuple[str, str], ActorDetails] = {
        (layer_name, actor.sName): ActorDetails(layer_name, actor, all_rooms)
        for layer_name, _, actor in brfld.all_actors()
    }
    actor_to_area: dict[str, str] = {}

    def add_node(target_area: str, node_def: NodeDefinition):
        new_actor = get_actor_name_for_node(node_def.data)
        for existing_name, existing_node in world["areas"][target_area]["nodes"].items():
            if existing_name == node_def.name:
                continue
            if get_actor_name_for_node(existing_node) == new_actor:
                raise ValueError(f"New node {node_def.name} with actor {new_actor} conflicts "
                                 f"with existing node {existing_name} in {target_area}")

        world["areas"][target_area]["nodes"][node_def.name] = node_def.data
        actor_to_area[get_actor_name_for_node(node_def.data)] = target_area

    def get_node_def_for_actor(actor_name: str) -> typing.Optional[NodeDefinition]:
        actor_area = actor_to_area.get(actor_name)
        if actor_area is not None:
            for existing_name, existing_node in world["areas"][actor_area]["nodes"].items():
                if get_actor_name_for_node(existing_node) == actor_name:
                    return NodeDefinition(existing_name, existing_node)

    for layer_name, actor_name, actor in brfld.all_actors():
        details = all_default_details[(layer_name, actor.sName)]
        if not any([details.is_door, details.is_pickup, details.is_elevator, details.is_usable,
                    details.is_breakable_blob]):
            continue

        # if others := [name for name, details in all_default_details.items() if p.distance(details.position) < 3]:
        #     print(f"{actor.sName} is very close to {[other for other in others]}")

        if details.is_door:
            if details.is_start_point:
                print(f"{actor.sName} is a door and start point")

            if len(details.rooms) == 2:
                doors = create_door_nodes_for_actor(details, node_data_for_area, world)
                for i, room_name in enumerate(details.rooms):
                    add_node(room_name, doors[i])

            else:
                if all(x not in actor.sName for x in ["doorshutter", "trap_thermal_"]):
                    print("multiple rooms for door!", actor.sName, details.position, details.rooms)

        elif details.is_pickup:
            if details.is_start_point:
                print(f"{actor.sName} is a pickup and start point")

            for room_name in details.rooms:
                definition = details.create_node_template("pickup", f"Pickup ({actor.sName})",
                                                          node_data_for_area.get(room_name))
                definition.data.update({
                    "pickup_index": pickup_index,
                    "major_location": "tank" not in details.actor_def,
                })
                add_node(room_name, definition)

            if len(details.rooms) != 1:
                print("wrong item!", actor.sName, details.rooms)
            pickup_index += 1

        elif details.is_elevator:
            if len(details.rooms) != 1:
                print("elevator for multiple rooms?", actor.sName, details.rooms)
                continue

            room_name = details.rooms[0]
            this_area = world["areas"][details.rooms[0]]

            usable = actor.pComponents.USABLE
            definition = details.create_node_template("teleporter", f"Elevator ({actor.sName})",
                                                      node_data_for_area.get(room_name))
            definition.data["extra"].update({
                "elevator_component": usable["@type"],
                "target_spawn_point": usable.sTargetSpawnPoint,
            })
            target_world_name = id_to_name[usable.sScenarioName]
            definition.data.update({
                "destination": {
                    "world_name": target_world_name,
                    "area_name": area_name_by_world_and_actor[target_world_name].get(
                        usable.sTargetSpawnPoint,
                        _rooms_for_actors[usable.sScenarioName][usable.sTargetSpawnPoint][0],
                    ),
                }
            })
            add_node(room_name, definition)
            if details.is_start_point:
                this_area["valid_starting_location"] = True
                if this_area["default_node"] is None:
                    this_area["default_node"] = definition.name

        elif details.is_usable:
            if len(details.rooms) != 1:
                print("usable multiple rooms?", actor.sName, details.rooms)
                continue

            usable_type = actor.pComponents.USABLE["@type"]
            if usable_type not in _usable_component_to_node_name:
                raise ValueError(f"Unknown usable type: {usable_type}")

            room_name = details.rooms[0]
            this_area = world["areas"][room_name]
            node_prefix = _usable_component_to_node_name[usable_type]

            definition = details.create_node_template(
                "event" if usable_type in _usable_component_as_event_node else "generic",
                _build_node_name_with_prefix(node_prefix, this_area),
                node_data_for_area.get(room_name),
            )
            if usable_type in _usable_component_as_event_node:
                definition.data["event_name"] = create_event("default", actor.sName)
            if usable_type in {"CLifeRechargeComponent", "CTotalRechargeComponent"}:
                definition.data["heal"] = True

            add_node(room_name, _fix_nodes_with_prefix(definition, node_prefix, this_area))

        elif details.is_breakable_blob:
            if len(details.rooms) != 1:
                print("breakable blob in multiple rooms?", actor.sName, details.rooms)
                continue

            room_name = details.rooms[0]
            definition = details.create_node_template(
                "event",
                f"Event - Breakable ({actor.sName})",
                node_data_for_area.get(room_name),
            )
            definition.data["event_name"] = create_event("default", actor.sName)
            add_node(room_name, definition)

    # Add start points
    # Since these include the "platforms for usable", we do this after everything else so we have a chance of
    # merging this node into the existing one.
    for layer_name, actor_name, actor in brfld.all_actors():
        details = all_default_details[(layer_name, actor.sName)]
        if not details.is_start_point:
            continue

        if len(details.rooms) != 1:
            print("start point for multiple rooms?", actor.sName, details.rooms)
            continue

        if details.is_usable:
            # print(f"Skipping start point {actor.sName} as it's also usable")
            continue

        room_name = details.rooms[0]
        this_area = world["areas"][room_name]

        if layer_name != "default" and actor.sName not in node_data_for_area.get(room_name, {}):
            # Skipping start points from other layers for now
            continue

        definition = details.create_node_template(
            "generic",
            _build_node_name_with_prefix("Start Point", this_area),
            node_data_for_area.get(room_name),
        )

        other_actor = None
        if "SMARTOBJECT" in actor.pComponents and "sUsableEntity" in actor.pComponents.SMARTOBJECT:
            other_actor = get_node_def_for_actor(actor.pComponents.SMARTOBJECT.sUsableEntity)
            definition.data["extra"]["usable_entity"] = actor.pComponents.SMARTOBJECT.sUsableEntity

        if other_actor is not None:
            this_area["nodes"].pop(other_actor.name)
            this_area["nodes"].pop(definition.name, None)
            if this_area["default_node"] == definition.name:
                this_area["default_node"] = None
            definition = other_actor
        else:
            definition.data["extra"].pop("actor_name")
            definition.data["extra"].pop("actor_layer", None)
            definition.data["extra"].pop("actor_def")

        if this_area["default_node"] is None:
            this_area["default_node"] = definition.name
        elif details.actor_def == "startpoint":

            default_node_data = this_area["nodes"][this_area["default_node"]]
            if "startpoint" not in default_node_data["extra"].get("start_point_actor_def", ""):
                this_area["default_node"] = definition.name

        if details.actor_def == "startpoint":
            this_area["valid_starting_location"] = True

        definition.data["extra"]["start_point_actor_name"] = actor.sName
        definition.data["extra"]["start_point_actor_def"] = actor.oActorDefLink
        if layer_name != "default":
            definition.data["extra"]["start_point_actor_layer"] = layer_name
        add_node(room_name, _fix_nodes_with_prefix(definition, "Start Point", this_area))

    for layer_name, actor_name, actor in brfld.all_actors():
        if "TILEGROUP" not in actor.pComponents:
            continue

        details = ActorDetails(layer_name, actor, all_rooms)

        if len(details.rooms) != 1:
            print("TILEGROUP multiple rooms?", actor.sName, details.rooms)
            continue

        room_name = details.rooms[0]
        this_area = world["areas"][room_name]

        tile_types = set()
        for grid_tile in actor.pComponents.TILEGROUP.aGridTiles:
            tile_types.add(grid_tile.eTileType)
        group_name = " ".join(sorted(tile_types))

        node_prefix = f"Tile Group ({group_name})"
        definition = details.create_node_template(
            "configurable_node",
            _build_node_name_with_prefix(node_prefix, this_area),
            node_data_for_area.get(room_name),
        )
        definition.data["extra"]["tile_types"] = sorted(tile_types)
        if "WEIGHT" in tile_types:
            definition.data["node_type"] = "generic"
        add_node(room_name, _fix_nodes_with_prefix(definition, node_prefix, this_area))

    for area_name, area in world["areas"].items():
        if area["nodes"]:
            if "Placeholder" in area["nodes"] and len(area["nodes"]) > 1:
                area["nodes"].pop("Placeholder")
        else:
            area["nodes"]["Placeholder"] = {
                "node_type": "generic",
                "heal": False,
                "coordinates": None,
                "description": "",
                "extra": {},
                "connections": {},
            }

    print(f"Writing updated {world_names[brfld_path]}")
    with out_path.joinpath(f"{world_names[brfld_path]}.json").open("w") as f:
        json.dump(world, f, indent=4)


def _get_area_name_from_actors_in_existing_db(out_path: Path) -> dict[str, dict[str, str]]:
    area_name_by_world_and_actor = {}

    for world_name in world_names.values():
        try:
            with out_path.joinpath(f"{world_name}.json").open() as f:
                area_name_by_world_and_actor[world_name] = {}
                for area_name, area_data in json.load(f)["areas"].items():
                    for node_data in area_data["nodes"].values():
                        for variable in ["actor_name", "start_point_actor_name"]:
                            if variable in node_data["extra"]:
                                area_name_by_world_and_actor[world_name][node_data["extra"][variable]] = area_name
        except FileNotFoundError:
            area_name_by_world_and_actor[world_name] = {}

    return area_name_by_world_and_actor


def _build_node_name_with_prefix(node_prefix: str, this_area: dict) -> str:
    count = sum(1 for name in this_area["nodes"] if name.startswith(node_prefix))

    if count == 0:
        return node_prefix

    return f"{node_prefix} {count + 1}"


def _fix_nodes_with_prefix(definition: NodeDefinition, node_prefix: str, this_area: dict) -> NodeDefinition:
    if not definition.name.startswith(node_prefix):
        return definition

    this_area["nodes"].pop(definition.name, None)
    count = sum(1 for name in this_area["nodes"] if name.startswith(node_prefix))

    if count == 0:
        return NodeDefinition(node_prefix, definition.data)

    elif node_prefix in this_area["nodes"]:
        not_numbered_renamed = f"{node_prefix} 1"
        if not_numbered_renamed in this_area["nodes"]:
            raise ValueError(f"Expected area to not have a {not_numbered_renamed}")

        this_area["nodes"][not_numbered_renamed] = this_area["nodes"].pop(node_prefix)
        if this_area["default_node"] == node_prefix:
            this_area["default_node"] = not_numbered_renamed

    return definition


def decode_all_worlds(root: Path, out_path: Path):
    header_path = out_path.joinpath("header.json")
    with header_path.open() as f:
        header = json.load(f)

    events.clear()
    events.update(header["resource_database"]["events"])

    for area_path in world_names.keys():
        level_name = os.path.splitext(os.path.split(area_path)[1])[0]
        decode_world(root, level_name, out_path)

    header["resource_database"]["events"] = events

    with header_path.open("w") as f:
        json.dump(header, f, indent=4)


if __name__ == '__main__':
    decode_all_worlds(Path("F:/DreadExtract"), Path(sys.argv[1]))
    # decode_world(Path("F:/DreadExtract"), "s080_shipyard", Path(sys.argv[1]))
